// content/common/render_widget_host_ns_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/render_widget_host_ns_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/render_widget_host_ns_view.mojom-params-data.h"
#include "content/common/render_widget_host_ns_view.mojom-shared-message-ids.h"

#include "content/common/render_widget_host_ns_view.mojom-import-headers.h"
#include "content/common/render_widget_host_ns_view.mojom-test-utils.h"


namespace remote_cocoa::mojom {
PopupMenu::PopupMenu()
    : items(),
      bounds(),
      item_font_size(),
      right_aligned(),
      selected_item(),
      receiver() {}

PopupMenu::PopupMenu(
    std::vector<::blink::mojom::MenuItemPtr> items_in,
    const ::gfx::Rect& bounds_in,
    double item_font_size_in,
    bool right_aligned_in,
    uint32_t selected_item_in,
    ::mojo::PendingReceiver<PopupMenuRunner> receiver_in)
    : items(std::move(items_in)),
      bounds(std::move(bounds_in)),
      item_font_size(std::move(item_font_size_in)),
      right_aligned(std::move(right_aligned_in)),
      selected_item(std::move(selected_item_in)),
      receiver(std::move(receiver_in)) {}

PopupMenu::~PopupMenu() = default;

void PopupMenu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_font_size"), this->item_font_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_aligned"), this->right_aligned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_item"), this->selected_item,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<PopupMenuRunner>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PopupMenu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PopupMenuRunner::IPCStableHashFunction PopupMenuRunner::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PopupMenuRunner>(message.name())) {
    case messages::PopupMenuRunner::kHide: {
      return &PopupMenuRunner::Hide_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PopupMenuRunner::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PopupMenuRunner>(message.name())) {
      case messages::PopupMenuRunner::kHide:
            return "Receive remote_cocoa::mojom::PopupMenuRunner::Hide";
    }
  } else {
    switch (static_cast<messages::PopupMenuRunner>(message.name())) {
      case messages::PopupMenuRunner::kHide:
            return "Receive reply remote_cocoa::mojom::PopupMenuRunner::Hide";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PopupMenuRunner::Hide_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1bf370ad;  // IPCStableHash for remote_cocoa::mojom::PopupMenuRunner::Hide
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PopupMenuRunnerProxy::PopupMenuRunnerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PopupMenuRunnerProxy::Hide(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::PopupMenuRunner::Hide");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupMenuRunner::kHide), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::PopupMenuRunner_Hide_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupMenuRunner::Name_);
  message.set_method_name("Hide");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PopupMenuRunnerStubDispatch::Accept(
    PopupMenuRunner* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PopupMenuRunner>(message->header()->name)) {
    case messages::PopupMenuRunner::kHide: {
      DCHECK(message->is_serialized());
      internal::PopupMenuRunner_Hide_Params_Data* params =
          reinterpret_cast<internal::PopupMenuRunner_Hide_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PopupMenuRunner.0
      bool success = true;
      PopupMenuRunner_Hide_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupMenuRunner::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hide(        );
      return true;
    }
  }
  return false;
}

// static
bool PopupMenuRunnerStubDispatch::AcceptWithResponder(
    PopupMenuRunner* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PopupMenuRunner>(message->header()->name)) {
    case messages::PopupMenuRunner::kHide: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPopupMenuRunnerValidationInfo[] = {
    { &internal::PopupMenuRunner_Hide_Params_Data::Validate,
     nullptr /* no response */},
};

bool PopupMenuRunnerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::PopupMenuRunner::Name_,
    kPopupMenuRunnerValidationInfo);
}

// The declaration includes the definition on other builds.

RenderWidgetHostNSView::IPCStableHashFunction RenderWidgetHostNSView::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderWidgetHostNSView>(message.name())) {
    case messages::RenderWidgetHostNSView::kInitAsPopup: {
      return &RenderWidgetHostNSView::InitAsPopup_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetParentWebContentsNSView: {
      return &RenderWidgetHostNSView::SetParentWebContentsNSView_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kDisableDisplay: {
      return &RenderWidgetHostNSView::DisableDisplay_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kMakeFirstResponder: {
      return &RenderWidgetHostNSView::MakeFirstResponder_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetBounds: {
      return &RenderWidgetHostNSView::SetBounds_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetCALayerParams: {
      return &RenderWidgetHostNSView::SetCALayerParams_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetBackgroundColor: {
      return &RenderWidgetHostNSView::SetBackgroundColor_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetVisible: {
      return &RenderWidgetHostNSView::SetVisible_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetTooltipText: {
      return &RenderWidgetHostNSView::SetTooltipText_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetTextInputState: {
      return &RenderWidgetHostNSView::SetTextInputState_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetTextSelection: {
      return &RenderWidgetHostNSView::SetTextSelection_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetCompositionRangeInfo: {
      return &RenderWidgetHostNSView::SetCompositionRangeInfo_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kCancelComposition: {
      return &RenderWidgetHostNSView::CancelComposition_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetShowingContextMenu: {
      return &RenderWidgetHostNSView::SetShowingContextMenu_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kDisplayCursor: {
      return &RenderWidgetHostNSView::DisplayCursor_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLocked: {
      return &RenderWidgetHostNSView::SetCursorLocked_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement: {
      return &RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection: {
      return &RenderWidgetHostNSView::ShowDictionaryOverlayForSelection_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlay: {
      return &RenderWidgetHostNSView::ShowDictionaryOverlay_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kLockKeyboard: {
      return &RenderWidgetHostNSView::LockKeyboard_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kUnlockKeyboard: {
      return &RenderWidgetHostNSView::UnlockKeyboard_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kShowSharingServicePicker: {
      return &RenderWidgetHostNSView::ShowSharingServicePicker_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kDestroy: {
      return &RenderWidgetHostNSView::Destroy_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kGestureScrollEventAck: {
      return &RenderWidgetHostNSView::GestureScrollEventAck_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kDidOverscroll: {
      return &RenderWidgetHostNSView::DidOverscroll_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSView::kDisplayPopupMenu: {
      return &RenderWidgetHostNSView::DisplayPopupMenu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderWidgetHostNSView::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderWidgetHostNSView>(message.name())) {
      case messages::RenderWidgetHostNSView::kInitAsPopup:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::InitAsPopup";
      case messages::RenderWidgetHostNSView::kSetParentWebContentsNSView:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetParentWebContentsNSView";
      case messages::RenderWidgetHostNSView::kDisableDisplay:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::DisableDisplay";
      case messages::RenderWidgetHostNSView::kMakeFirstResponder:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::MakeFirstResponder";
      case messages::RenderWidgetHostNSView::kSetBounds:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetBounds";
      case messages::RenderWidgetHostNSView::kSetCALayerParams:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetCALayerParams";
      case messages::RenderWidgetHostNSView::kSetBackgroundColor:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetBackgroundColor";
      case messages::RenderWidgetHostNSView::kSetVisible:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetVisible";
      case messages::RenderWidgetHostNSView::kSetTooltipText:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetTooltipText";
      case messages::RenderWidgetHostNSView::kSetTextInputState:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetTextInputState";
      case messages::RenderWidgetHostNSView::kSetTextSelection:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetTextSelection";
      case messages::RenderWidgetHostNSView::kSetCompositionRangeInfo:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetCompositionRangeInfo";
      case messages::RenderWidgetHostNSView::kCancelComposition:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::CancelComposition";
      case messages::RenderWidgetHostNSView::kSetShowingContextMenu:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetShowingContextMenu";
      case messages::RenderWidgetHostNSView::kDisplayCursor:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::DisplayCursor";
      case messages::RenderWidgetHostNSView::kSetCursorLocked:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLocked";
      case messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement";
      case messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlayForSelection";
      case messages::RenderWidgetHostNSView::kShowDictionaryOverlay:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlay";
      case messages::RenderWidgetHostNSView::kLockKeyboard:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::LockKeyboard";
      case messages::RenderWidgetHostNSView::kUnlockKeyboard:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::UnlockKeyboard";
      case messages::RenderWidgetHostNSView::kShowSharingServicePicker:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::ShowSharingServicePicker";
      case messages::RenderWidgetHostNSView::kDestroy:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::Destroy";
      case messages::RenderWidgetHostNSView::kGestureScrollEventAck:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::GestureScrollEventAck";
      case messages::RenderWidgetHostNSView::kDidOverscroll:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::DidOverscroll";
      case messages::RenderWidgetHostNSView::kDisplayPopupMenu:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSView::DisplayPopupMenu";
    }
  } else {
    switch (static_cast<messages::RenderWidgetHostNSView>(message.name())) {
      case messages::RenderWidgetHostNSView::kInitAsPopup:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::InitAsPopup";
      case messages::RenderWidgetHostNSView::kSetParentWebContentsNSView:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetParentWebContentsNSView";
      case messages::RenderWidgetHostNSView::kDisableDisplay:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::DisableDisplay";
      case messages::RenderWidgetHostNSView::kMakeFirstResponder:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::MakeFirstResponder";
      case messages::RenderWidgetHostNSView::kSetBounds:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetBounds";
      case messages::RenderWidgetHostNSView::kSetCALayerParams:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetCALayerParams";
      case messages::RenderWidgetHostNSView::kSetBackgroundColor:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetBackgroundColor";
      case messages::RenderWidgetHostNSView::kSetVisible:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetVisible";
      case messages::RenderWidgetHostNSView::kSetTooltipText:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetTooltipText";
      case messages::RenderWidgetHostNSView::kSetTextInputState:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetTextInputState";
      case messages::RenderWidgetHostNSView::kSetTextSelection:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetTextSelection";
      case messages::RenderWidgetHostNSView::kSetCompositionRangeInfo:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetCompositionRangeInfo";
      case messages::RenderWidgetHostNSView::kCancelComposition:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::CancelComposition";
      case messages::RenderWidgetHostNSView::kSetShowingContextMenu:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetShowingContextMenu";
      case messages::RenderWidgetHostNSView::kDisplayCursor:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::DisplayCursor";
      case messages::RenderWidgetHostNSView::kSetCursorLocked:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLocked";
      case messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement";
      case messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlayForSelection";
      case messages::RenderWidgetHostNSView::kShowDictionaryOverlay:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlay";
      case messages::RenderWidgetHostNSView::kLockKeyboard:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::LockKeyboard";
      case messages::RenderWidgetHostNSView::kUnlockKeyboard:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::UnlockKeyboard";
      case messages::RenderWidgetHostNSView::kShowSharingServicePicker:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::ShowSharingServicePicker";
      case messages::RenderWidgetHostNSView::kDestroy:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::Destroy";
      case messages::RenderWidgetHostNSView::kGestureScrollEventAck:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::GestureScrollEventAck";
      case messages::RenderWidgetHostNSView::kDidOverscroll:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::DidOverscroll";
      case messages::RenderWidgetHostNSView::kDisplayPopupMenu:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSView::DisplayPopupMenu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderWidgetHostNSView::InitAsPopup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99c6d296;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::InitAsPopup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetParentWebContentsNSView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56d9ee8d;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetParentWebContentsNSView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::DisableDisplay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe74ffdf4;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::DisableDisplay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::MakeFirstResponder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4808c485;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::MakeFirstResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56363dcd;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetCALayerParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43ea2315;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetCALayerParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetBackgroundColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd0cdcd1;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetBackgroundColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x005ee15d;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetTooltipText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x582dc455;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetTooltipText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetTextInputState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c1bb209;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetTextInputState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetTextSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa99b1b66;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetTextSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetCompositionRangeInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x794372bd;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetCompositionRangeInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::CancelComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65468807;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::CancelComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetShowingContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9db0f1b4;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetShowingContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::DisplayCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x797def58;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::DisplayCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetCursorLocked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x165f09ce;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLocked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59138f26;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::ShowDictionaryOverlayForSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff69b35d;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlayForSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::ShowDictionaryOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaad60156;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::LockKeyboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8389c6d2;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::LockKeyboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::UnlockKeyboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x739b2c37;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::UnlockKeyboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::ShowSharingServicePicker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb26dcef0;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::ShowSharingServicePicker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec83226d;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::GestureScrollEventAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3d4c3d2;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::GestureScrollEventAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::DidOverscroll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x449e1528;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::DidOverscroll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSView::DisplayPopupMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b254f6e;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSView::DisplayPopupMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback(
      RenderWidgetHostNSView::ShowSharingServicePickerCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback(const RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback&) = delete;
  RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback& operator=(const RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSView::ShowSharingServicePickerCallback callback_;
};

class RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback(
      RenderWidgetHostNSView::DisplayPopupMenuCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback(const RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback&) = delete;
  RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback& operator=(const RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSView::DisplayPopupMenuCallback callback_;
};

RenderWidgetHostNSViewProxy::RenderWidgetHostNSViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderWidgetHostNSViewProxy::InitAsPopup(
    const ::gfx::Rect& in_content_rect, uint64_t in_popup_parent_ns_view_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::InitAsPopup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_rect"), in_content_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_parent_ns_view_id"), in_popup_parent_ns_view_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kInitAsPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_InitAsPopup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_rect)::BaseType> content_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_content_rect,
    content_rect_fragment);

  params->content_rect.Set(
      content_rect_fragment.is_null() ? nullptr : content_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_rect in RenderWidgetHostNSView.InitAsPopup request");

  params->popup_parent_ns_view_id = in_popup_parent_ns_view_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("InitAsPopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetParentWebContentsNSView(
    uint64_t in_parent_ns_view_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetParentWebContentsNSView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_ns_view_id"), in_parent_ns_view_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetParentWebContentsNSView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data> params(
          message);
  params.Allocate();

  params->parent_ns_view_id = in_parent_ns_view_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetParentWebContentsNSView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::DisableDisplay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::DisableDisplay");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDisableDisplay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_DisableDisplay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("DisableDisplay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::MakeFirstResponder(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::MakeFirstResponder");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kMakeFirstResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_MakeFirstResponder_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("MakeFirstResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetBounds(
    const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in RenderWidgetHostNSView.SetBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetCALayerParams(
    const ::gfx::CALayerParams& in_ca_layer_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetCALayerParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ca_layer_params"), in_ca_layer_params,
                        "<value of type const ::gfx::CALayerParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetCALayerParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetCALayerParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ca_layer_params)::BaseType> ca_layer_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::CALayerParamsDataView>(
    in_ca_layer_params,
    ca_layer_params_fragment);

  params->ca_layer_params.Set(
      ca_layer_params_fragment.is_null() ? nullptr : ca_layer_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ca_layer_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ca_layer_params in RenderWidgetHostNSView.SetCALayerParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetCALayerParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetBackgroundColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetBackgroundColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetBackgroundColor_Params_Data> params(
          message);
  params.Allocate();

  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetTooltipText(
    const ::std::u16string& in_display_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetTooltipText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_text"), in_display_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetTooltipText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetTooltipText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display_text)::BaseType> display_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_display_text,
    display_text_fragment);

  params->display_text.Set(
      display_text_fragment.is_null() ? nullptr : display_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->display_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null display_text in RenderWidgetHostNSView.SetTooltipText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetTooltipText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetTextInputState(
    ::ui::TextInputType in_text_input_type, uint32_t in_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetTextInputState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_input_type"), in_text_input_type,
                        "<value of type ::ui::TextInputType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flags"), in_flags,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetTextInputState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetTextInputState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::TextInputType>(
    in_text_input_type,
    &params->text_input_type);

  params->flags = in_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetTextInputState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetTextSelection(
    const ::std::u16string& in_text, uint64_t in_offset, const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetTextSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetTextSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetTextSelection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in RenderWidgetHostNSView.SetTextSelection request");

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in RenderWidgetHostNSView.SetTextSelection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetTextSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetCompositionRangeInfo(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetCompositionRangeInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetCompositionRangeInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in RenderWidgetHostNSView.SetCompositionRangeInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetCompositionRangeInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::CancelComposition(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::CancelComposition");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kCancelComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_CancelComposition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("CancelComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetShowingContextMenu(
    bool in_showing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetShowingContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("showing"), in_showing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetShowingContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetShowingContextMenu_Params_Data> params(
          message);
  params.Allocate();

  params->showing = in_showing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetShowingContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::DisplayCursor(
    const ::ui::Cursor& in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::DisplayCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor"), in_cursor,
                        "<value of type const ::ui::Cursor&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDisplayCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_DisplayCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cursor)::BaseType> cursor_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::CursorDataView>(
    in_cursor,
    cursor_fragment);

  params->cursor.Set(
      cursor_fragment.is_null() ? nullptr : cursor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor in RenderWidgetHostNSView.DisplayCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("DisplayCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetCursorLocked(
    bool in_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locked"), in_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetCursorLocked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetCursorLocked_Params_Data> params(
          message);
  params.Allocate();

  params->locked = in_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetCursorLocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::SetCursorLockedUnacceleratedMovement(
    bool in_unaccelerated_movement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::SetCursorLockedUnacceleratedMovement", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unaccelerated_movement"), in_unaccelerated_movement,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data> params(
          message);
  params.Allocate();

  params->unaccelerated_movement = in_unaccelerated_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("SetCursorLockedUnacceleratedMovement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::ShowDictionaryOverlayForSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlayForSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("ShowDictionaryOverlayForSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::ShowDictionaryOverlay(
    ::ui::mojom::AttributedStringPtr in_attributed_string, const ::gfx::Point& in_baseline_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::ShowDictionaryOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributed_string"), in_attributed_string,
                        "<value of type ::ui::mojom::AttributedStringPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("baseline_point"), in_baseline_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kShowDictionaryOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->attributed_string)::BaseType> attributed_string_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::AttributedStringDataView>(
    in_attributed_string,
    attributed_string_fragment);

  params->attributed_string.Set(
      attributed_string_fragment.is_null() ? nullptr : attributed_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attributed_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attributed_string in RenderWidgetHostNSView.ShowDictionaryOverlay request");
  mojo::internal::MessageFragment<
      typename decltype(params->baseline_point)::BaseType> baseline_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_baseline_point,
    baseline_point_fragment);

  params->baseline_point.Set(
      baseline_point_fragment.is_null() ? nullptr : baseline_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->baseline_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null baseline_point in RenderWidgetHostNSView.ShowDictionaryOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("ShowDictionaryOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::LockKeyboard(
    const std::optional<std::vector<uint32_t>>& in_dom_codes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::LockKeyboard", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_codes"), in_dom_codes,
                        "<value of type const std::optional<std::vector<uint32_t>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kLockKeyboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_LockKeyboard_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dom_codes)::BaseType>
      dom_codes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dom_codes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_dom_codes,
    dom_codes_fragment,
    &dom_codes_validate_params);

  params->dom_codes.Set(
      dom_codes_fragment.is_null() ? nullptr : dom_codes_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("LockKeyboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::UnlockKeyboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::UnlockKeyboard");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kUnlockKeyboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_UnlockKeyboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("UnlockKeyboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::ShowSharingServicePicker(
    const std::string& in_title, const std::string& in_text, const ::GURL& in_url, const std::vector<std::string>& in_file_paths, ShowSharingServicePickerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::ShowSharingServicePicker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_paths"), in_file_paths,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kShowSharingServicePicker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in RenderWidgetHostNSView.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in RenderWidgetHostNSView.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RenderWidgetHostNSView.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->file_paths)::BaseType>
      file_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& file_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_file_paths,
    file_paths_fragment,
    &file_paths_validate_params);

  params->file_paths.Set(
      file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_paths in RenderWidgetHostNSView.ShowSharingServicePicker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("ShowSharingServicePicker");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderWidgetHostNSViewProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::GestureScrollEventAck(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_consumed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::GestureScrollEventAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumed"), in_consumed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kGestureScrollEventAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_GestureScrollEventAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSView.GestureScrollEventAck request");

  params->consumed = in_consumed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("GestureScrollEventAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::DidOverscroll(
    ::blink::mojom::DidOverscrollParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::DidOverscroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::DidOverscrollParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDidOverscroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_DidOverscroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RenderWidgetHostNSView.DidOverscroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("DidOverscroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewProxy::DisplayPopupMenu(
    PopupMenuPtr in_menu, DisplayPopupMenuCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSView::DisplayPopupMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu"), in_menu,
                        "<value of type PopupMenuPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDisplayPopupMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_DisplayPopupMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->menu)::BaseType> menu_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::PopupMenuDataView>(
    in_menu,
    menu_fragment);

  params->menu.Set(
      menu_fragment.is_null() ? nullptr : menu_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->menu.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null menu in RenderWidgetHostNSView.DisplayPopupMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("DisplayPopupMenu");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSView::ShowSharingServicePickerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder> proxy(
        new RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSView::ShowSharingServicePickerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ShareError in_error);
};

bool RenderWidgetHostNSView_ShowSharingServicePicker_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSView.21
  bool success = true;
  ::blink::mojom::ShareError p_error{};
  RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSView::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder::Run(
    ::blink::mojom::ShareError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSView::ShowSharingServicePicker", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ShareError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kShowSharingServicePicker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ShareError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("ShowSharingServicePicker");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSView::DisplayPopupMenuCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder> proxy(
        new RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSView::DisplayPopupMenuCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_selected_item);
};

bool RenderWidgetHostNSView_DisplayPopupMenu_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSView.25
  bool success = true;
  std::optional<uint32_t> p_selected_item{};
  RenderWidgetHostNSView_DisplayPopupMenu_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_selected_item = input_data_view.selected_item();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSView::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_selected_item));
  }
  return true;
}

void RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder::Run(
    std::optional<uint32_t> in_selected_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSView::DisplayPopupMenu", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_item"), in_selected_item,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSView::kDisplayPopupMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->selected_item_$flag = in_selected_item.has_value();
  if (in_selected_item.has_value()) {
    params->selected_item_$value = in_selected_item.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSView::Name_);
  message.set_method_name("DisplayPopupMenu");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RenderWidgetHostNSViewStubDispatch::Accept(
    RenderWidgetHostNSView* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderWidgetHostNSView>(message->header()->name)) {
    case messages::RenderWidgetHostNSView::kInitAsPopup: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_InitAsPopup_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_InitAsPopup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.0
      bool success = true;
      ::gfx::Rect p_content_rect{};
      uint64_t p_popup_parent_ns_view_id{};
      RenderWidgetHostNSView_InitAsPopup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentRect(&p_content_rect))
        success = false;
      if (success)
        p_popup_parent_ns_view_id = input_data_view.popup_parent_ns_view_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitAsPopup(        
        std::move(p_content_rect), 
        std::move(p_popup_parent_ns_view_id));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetParentWebContentsNSView: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.1
      bool success = true;
      uint64_t p_parent_ns_view_id{};
      RenderWidgetHostNSView_SetParentWebContentsNSView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_parent_ns_view_id = input_data_view.parent_ns_view_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParentWebContentsNSView(        
        std::move(p_parent_ns_view_id));
      return true;
    }
    case messages::RenderWidgetHostNSView::kDisableDisplay: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_DisableDisplay_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_DisableDisplay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.2
      bool success = true;
      RenderWidgetHostNSView_DisableDisplay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableDisplay(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kMakeFirstResponder: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_MakeFirstResponder_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_MakeFirstResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.3
      bool success = true;
      RenderWidgetHostNSView_MakeFirstResponder_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeFirstResponder(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetBounds: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetBounds_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.4
      bool success = true;
      ::gfx::Rect p_rect{};
      RenderWidgetHostNSView_SetBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBounds(        
        std::move(p_rect));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetCALayerParams: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetCALayerParams_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetCALayerParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.5
      bool success = true;
      ::gfx::CALayerParams p_ca_layer_params{};
      RenderWidgetHostNSView_SetCALayerParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCaLayerParams(&p_ca_layer_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCALayerParams(        
        std::move(p_ca_layer_params));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetBackgroundColor: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetBackgroundColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.6
      bool success = true;
      uint32_t p_color{};
      RenderWidgetHostNSView_SetBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundColor(        
        std::move(p_color));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetVisible: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetVisible_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.7
      bool success = true;
      bool p_visible{};
      RenderWidgetHostNSView_SetVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetTooltipText: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetTooltipText_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetTooltipText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.8
      bool success = true;
      ::std::u16string p_display_text{};
      RenderWidgetHostNSView_SetTooltipText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplayText(&p_display_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTooltipText(        
        std::move(p_display_text));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetTextInputState: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetTextInputState_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetTextInputState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.9
      bool success = true;
      ::ui::TextInputType p_text_input_type{};
      uint32_t p_flags{};
      RenderWidgetHostNSView_SetTextInputState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTextInputType(&p_text_input_type))
        success = false;
      if (success)
        p_flags = input_data_view.flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextInputState(        
        std::move(p_text_input_type), 
        std::move(p_flags));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetTextSelection: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetTextSelection_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetTextSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.10
      bool success = true;
      ::std::u16string p_text{};
      uint64_t p_offset{};
      ::gfx::Range p_range{};
      RenderWidgetHostNSView_SetTextSelection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextSelection(        
        std::move(p_text), 
        std::move(p_offset), 
        std::move(p_range));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetCompositionRangeInfo: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.11
      bool success = true;
      ::gfx::Range p_range{};
      RenderWidgetHostNSView_SetCompositionRangeInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCompositionRangeInfo(        
        std::move(p_range));
      return true;
    }
    case messages::RenderWidgetHostNSView::kCancelComposition: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_CancelComposition_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_CancelComposition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.12
      bool success = true;
      RenderWidgetHostNSView_CancelComposition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelComposition(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetShowingContextMenu: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetShowingContextMenu_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetShowingContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.13
      bool success = true;
      bool p_showing{};
      RenderWidgetHostNSView_SetShowingContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_showing = input_data_view.showing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShowingContextMenu(        
        std::move(p_showing));
      return true;
    }
    case messages::RenderWidgetHostNSView::kDisplayCursor: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_DisplayCursor_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_DisplayCursor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.14
      bool success = true;
      ::ui::Cursor p_cursor{};
      RenderWidgetHostNSView_DisplayCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCursor(&p_cursor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayCursor(        
        std::move(p_cursor));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLocked: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetCursorLocked_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetCursorLocked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.15
      bool success = true;
      bool p_locked{};
      RenderWidgetHostNSView_SetCursorLocked_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_locked = input_data_view.locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursorLocked(        
        std::move(p_locked));
      return true;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.16
      bool success = true;
      bool p_unaccelerated_movement{};
      RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_unaccelerated_movement = input_data_view.unaccelerated_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursorLockedUnacceleratedMovement(        
        std::move(p_unaccelerated_movement));
      return true;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.17
      bool success = true;
      RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDictionaryOverlayForSelection(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlay: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.18
      bool success = true;
      ::ui::mojom::AttributedStringPtr p_attributed_string{};
      ::gfx::Point p_baseline_point{};
      RenderWidgetHostNSView_ShowDictionaryOverlay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttributedString(&p_attributed_string))
        success = false;
      if (success && !input_data_view.ReadBaselinePoint(&p_baseline_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDictionaryOverlay(        
        std::move(p_attributed_string), 
        std::move(p_baseline_point));
      return true;
    }
    case messages::RenderWidgetHostNSView::kLockKeyboard: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_LockKeyboard_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_LockKeyboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.19
      bool success = true;
      std::optional<std::vector<uint32_t>> p_dom_codes{};
      RenderWidgetHostNSView_LockKeyboard_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDomCodes(&p_dom_codes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockKeyboard(        
        std::move(p_dom_codes));
      return true;
    }
    case messages::RenderWidgetHostNSView::kUnlockKeyboard: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_UnlockKeyboard_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_UnlockKeyboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.20
      bool success = true;
      RenderWidgetHostNSView_UnlockKeyboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnlockKeyboard(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kShowSharingServicePicker: {
      break;
    }
    case messages::RenderWidgetHostNSView::kDestroy: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_Destroy_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.22
      bool success = true;
      RenderWidgetHostNSView_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
    case messages::RenderWidgetHostNSView::kGestureScrollEventAck: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_GestureScrollEventAck_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_GestureScrollEventAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.23
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_consumed{};
      RenderWidgetHostNSView_GestureScrollEventAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_consumed = input_data_view.consumed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GestureScrollEventAck(        
        std::move(p_event), 
        std::move(p_consumed));
      return true;
    }
    case messages::RenderWidgetHostNSView::kDidOverscroll: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSView_DidOverscroll_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSView_DidOverscroll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.24
      bool success = true;
      ::blink::mojom::DidOverscrollParamsPtr p_params{};
      RenderWidgetHostNSView_DidOverscroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidOverscroll(        
        std::move(p_params));
      return true;
    }
    case messages::RenderWidgetHostNSView::kDisplayPopupMenu: {
      break;
    }
  }
  return false;
}

// static
bool RenderWidgetHostNSViewStubDispatch::AcceptWithResponder(
    RenderWidgetHostNSView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderWidgetHostNSView>(message->header()->name)) {
    case messages::RenderWidgetHostNSView::kInitAsPopup: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetParentWebContentsNSView: {
      break;
    }
    case messages::RenderWidgetHostNSView::kDisableDisplay: {
      break;
    }
    case messages::RenderWidgetHostNSView::kMakeFirstResponder: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetBounds: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetCALayerParams: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetBackgroundColor: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetVisible: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetTooltipText: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetTextInputState: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetTextSelection: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetCompositionRangeInfo: {
      break;
    }
    case messages::RenderWidgetHostNSView::kCancelComposition: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetShowingContextMenu: {
      break;
    }
    case messages::RenderWidgetHostNSView::kDisplayCursor: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLocked: {
      break;
    }
    case messages::RenderWidgetHostNSView::kSetCursorLockedUnacceleratedMovement: {
      break;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlayForSelection: {
      break;
    }
    case messages::RenderWidgetHostNSView::kShowDictionaryOverlay: {
      break;
    }
    case messages::RenderWidgetHostNSView::kLockKeyboard: {
      break;
    }
    case messages::RenderWidgetHostNSView::kUnlockKeyboard: {
      break;
    }
    case messages::RenderWidgetHostNSView::kShowSharingServicePicker: {
      internal::RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.21
      bool success = true;
      std::string p_title{};
      std::string p_text{};
      ::GURL p_url{};
      std::vector<std::string> p_file_paths{};
      RenderWidgetHostNSView_ShowSharingServicePicker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 21, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSView_ShowSharingServicePicker_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSharingServicePicker(        
        std::move(p_title), 
        std::move(p_text), 
        std::move(p_url), 
        std::move(p_file_paths), std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSView::kDestroy: {
      break;
    }
    case messages::RenderWidgetHostNSView::kGestureScrollEventAck: {
      break;
    }
    case messages::RenderWidgetHostNSView::kDidOverscroll: {
      break;
    }
    case messages::RenderWidgetHostNSView::kDisplayPopupMenu: {
      internal::RenderWidgetHostNSView_DisplayPopupMenu_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSView_DisplayPopupMenu_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSView.25
      bool success = true;
      PopupMenuPtr p_menu{};
      RenderWidgetHostNSView_DisplayPopupMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMenu(&p_menu))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSView::Name_, 25, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSView_DisplayPopupMenu_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayPopupMenu(        
        std::move(p_menu), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderWidgetHostNSViewValidationInfo[] = {
    { &internal::RenderWidgetHostNSView_InitAsPopup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_DisableDisplay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_MakeFirstResponder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetCALayerParams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetBackgroundColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetTooltipText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetTextInputState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetTextSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_CancelComposition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetShowingContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_DisplayCursor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetCursorLocked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_LockKeyboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_UnlockKeyboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data::Validate,
     &internal::RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSView_Destroy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_GestureScrollEventAck_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_DidOverscroll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSView_DisplayPopupMenu_Params_Data::Validate,
     &internal::RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data::Validate},
};

bool RenderWidgetHostNSViewRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::RenderWidgetHostNSView::Name_,
    kRenderWidgetHostNSViewValidationInfo);
}

bool RenderWidgetHostNSViewResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::RenderWidgetHostNSView::Name_,
    kRenderWidgetHostNSViewValidationInfo);
}
// The declaration includes the definition on other builds.

RenderWidgetHostNSViewHost::IPCStableHashFunction RenderWidgetHostNSViewHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderWidgetHostNSViewHost>(message.name())) {
    case messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame: {
      return &RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kRequestShutdown: {
      return &RenderWidgetHostNSViewHost::RequestShutdown_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged: {
      return &RenderWidgetHostNSViewHost::OnFirstResponderChanged_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged: {
      return &RenderWidgetHostNSViewHost::OnWindowIsKeyChanged_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged: {
      return &RenderWidgetHostNSViewHost::OnBoundsInWindowChanged_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged: {
      return &RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged: {
      return &RenderWidgetHostNSViewHost::OnScreenInfosChanged_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent: {
      return &RenderWidgetHostNSViewHost::BeginKeyboardEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent: {
      return &RenderWidgetHostNSViewHost::EndKeyboardEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands: {
      return &RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent: {
      return &RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent: {
      return &RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent: {
      return &RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardMouseEvent: {
      return &RenderWidgetHostNSViewHost::ForwardMouseEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardWheelEvent: {
      return &RenderWidgetHostNSViewHost::ForwardWheelEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kPinchEvent: {
      return &RenderWidgetHostNSViewHost::PinchEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent: {
      return &RenderWidgetHostNSViewHost::SmartMagnifyEvent_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kImeSetComposition: {
      return &RenderWidgetHostNSViewHost::ImeSetComposition_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCommitText: {
      return &RenderWidgetHostNSViewHost::ImeCommitText_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kImeFinishComposingText: {
      return &RenderWidgetHostNSViewHost::ImeFinishComposingText_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa: {
      return &RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint: {
      return &RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange: {
      return &RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint: {
      return &RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange: {
      return &RenderWidgetHostNSViewHost::SyncGetFirstRectForRange_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kExecuteEditCommand: {
      return &RenderWidgetHostNSViewHost::ExecuteEditCommand_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kUndo: {
      return &RenderWidgetHostNSViewHost::Undo_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kRedo: {
      return &RenderWidgetHostNSViewHost::Redo_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kCut: {
      return &RenderWidgetHostNSViewHost::Cut_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kCopy: {
      return &RenderWidgetHostNSViewHost::Copy_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kCopyToFindPboard: {
      return &RenderWidgetHostNSViewHost::CopyToFindPboard_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kCenterSelection: {
      return &RenderWidgetHostNSViewHost::CenterSelection_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kPaste: {
      return &RenderWidgetHostNSViewHost::Paste_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle: {
      return &RenderWidgetHostNSViewHost::PasteAndMatchStyle_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSelectAll: {
      return &RenderWidgetHostNSViewHost::SelectAll_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kStartSpeaking: {
      return &RenderWidgetHostNSViewHost::StartSpeaking_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kStopSpeaking: {
      return &RenderWidgetHostNSViewHost::StopSpeaking_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking: {
      return &RenderWidgetHostNSViewHost::SyncIsSpeaking_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken: {
      return &RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken_Sym::IPCStableHash;
    }
    case messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken: {
      return &RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderWidgetHostNSViewHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderWidgetHostNSViewHost>(message.name())) {
      case messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame";
      case messages::RenderWidgetHostNSViewHost::kRequestShutdown:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::RequestShutdown";
      case messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnFirstResponderChanged";
      case messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowIsKeyChanged";
      case messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnBoundsInWindowChanged";
      case messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged";
      case messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnScreenInfosChanged";
      case messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::BeginKeyboardEvent";
      case messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::EndKeyboardEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardMouseEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardMouseEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardWheelEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardWheelEvent";
      case messages::RenderWidgetHostNSViewHost::kPinchEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::PinchEvent";
      case messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SmartMagnifyEvent";
      case messages::RenderWidgetHostNSViewHost::kImeSetComposition:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeSetComposition";
      case messages::RenderWidgetHostNSViewHost::kImeCommitText:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCommitText";
      case messages::RenderWidgetHostNSViewHost::kImeFinishComposingText:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeFinishComposingText";
      case messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa";
      case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint";
      case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange";
      case messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint";
      case messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange";
      case messages::RenderWidgetHostNSViewHost::kExecuteEditCommand:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::ExecuteEditCommand";
      case messages::RenderWidgetHostNSViewHost::kUndo:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::Undo";
      case messages::RenderWidgetHostNSViewHost::kRedo:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::Redo";
      case messages::RenderWidgetHostNSViewHost::kCut:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::Cut";
      case messages::RenderWidgetHostNSViewHost::kCopy:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::Copy";
      case messages::RenderWidgetHostNSViewHost::kCopyToFindPboard:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::CopyToFindPboard";
      case messages::RenderWidgetHostNSViewHost::kCenterSelection:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::CenterSelection";
      case messages::RenderWidgetHostNSViewHost::kPaste:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::Paste";
      case messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::PasteAndMatchStyle";
      case messages::RenderWidgetHostNSViewHost::kSelectAll:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SelectAll";
      case messages::RenderWidgetHostNSViewHost::kStartSpeaking:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::StartSpeaking";
      case messages::RenderWidgetHostNSViewHost::kStopSpeaking:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::StopSpeaking";
      case messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking";
      case messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken";
      case messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken:
            return "Receive remote_cocoa::mojom::RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken";
    }
  } else {
    switch (static_cast<messages::RenderWidgetHostNSViewHost>(message.name())) {
      case messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame";
      case messages::RenderWidgetHostNSViewHost::kRequestShutdown:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::RequestShutdown";
      case messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnFirstResponderChanged";
      case messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowIsKeyChanged";
      case messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnBoundsInWindowChanged";
      case messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged";
      case messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnScreenInfosChanged";
      case messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::BeginKeyboardEvent";
      case messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::EndKeyboardEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent";
      case messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardMouseEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardMouseEvent";
      case messages::RenderWidgetHostNSViewHost::kForwardWheelEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardWheelEvent";
      case messages::RenderWidgetHostNSViewHost::kPinchEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::PinchEvent";
      case messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SmartMagnifyEvent";
      case messages::RenderWidgetHostNSViewHost::kImeSetComposition:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeSetComposition";
      case messages::RenderWidgetHostNSViewHost::kImeCommitText:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCommitText";
      case messages::RenderWidgetHostNSViewHost::kImeFinishComposingText:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeFinishComposingText";
      case messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa";
      case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint";
      case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange";
      case messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint";
      case messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange";
      case messages::RenderWidgetHostNSViewHost::kExecuteEditCommand:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::ExecuteEditCommand";
      case messages::RenderWidgetHostNSViewHost::kUndo:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::Undo";
      case messages::RenderWidgetHostNSViewHost::kRedo:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::Redo";
      case messages::RenderWidgetHostNSViewHost::kCut:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::Cut";
      case messages::RenderWidgetHostNSViewHost::kCopy:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::Copy";
      case messages::RenderWidgetHostNSViewHost::kCopyToFindPboard:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::CopyToFindPboard";
      case messages::RenderWidgetHostNSViewHost::kCenterSelection:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::CenterSelection";
      case messages::RenderWidgetHostNSViewHost::kPaste:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::Paste";
      case messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::PasteAndMatchStyle";
      case messages::RenderWidgetHostNSViewHost::kSelectAll:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SelectAll";
      case messages::RenderWidgetHostNSViewHost::kStartSpeaking:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::StartSpeaking";
      case messages::RenderWidgetHostNSViewHost::kStopSpeaking:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::StopSpeaking";
      case messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking";
      case messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken";
      case messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken:
            return "Receive reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe82ab855;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::RequestShutdown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3241444;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::RequestShutdown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::OnFirstResponderChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15183535;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnFirstResponderChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::OnWindowIsKeyChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd9a7109;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowIsKeyChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::OnBoundsInWindowChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14bdcd82;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnBoundsInWindowChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7414189a;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::OnScreenInfosChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3957ca5;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnScreenInfosChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::BeginKeyboardEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8e56f5f;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::BeginKeyboardEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::EndKeyboardEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e0dd50c;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::EndKeyboardEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3822f957;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb98a980;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61d8217a;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9274245f;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ForwardMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaeb51476;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ForwardWheelEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x311043f9;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardWheelEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::PinchEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03c60563;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::PinchEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SmartMagnifyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x726a64f7;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SmartMagnifyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ImeSetComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe37e4c4c;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeSetComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ImeCommitText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x709ce542;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCommitText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ImeFinishComposingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8609aae;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeFinishComposingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5217ac4f;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc81e5280;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc733bb64;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x575afd27;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SyncGetFirstRectForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7b59d78;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::ExecuteEditCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19102e67;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::ExecuteEditCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cbbfa04;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::Redo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34138f87;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::Redo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::Cut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b412d02;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::Cut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::Copy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c5f4a6d;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::Copy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::CopyToFindPboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0421bee4;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::CopyToFindPboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::CenterSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09ea490a;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::CenterSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::Paste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc776bdaa;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::Paste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::PasteAndMatchStyle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b766d02;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::PasteAndMatchStyle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SelectAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45176117;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SelectAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::StartSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfaf1b028;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::StartSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::StopSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00968956;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::StopSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SyncIsSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3125c72b;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0b6807a;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4aa182a;  // IPCStableHash for remote_cocoa::mojom::RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame(bool* out_is_for_main_frame) {
  NOTREACHED();
}
bool RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint(const ::gfx::PointF& root_point, uint32_t* out_index) {
  NOTREACHED();
}
bool RenderWidgetHostNSViewHost::SyncGetFirstRectForRange(const ::gfx::Range& requested_range, ::gfx::Rect* out_out_rect, ::gfx::Range* out_out_actual_range, bool* out_success) {
  NOTREACHED();
}
bool RenderWidgetHostNSViewHost::SyncIsSpeaking(bool* out_is_speaking) {
  NOTREACHED();
}
bool RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken(::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token) {
  NOTREACHED();
}
class RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse(
      bool* result, bool* out_is_for_main_frame)
      : result_(result), out_is_for_main_frame_(out_is_for_main_frame) {
    DCHECK(!*result_);
  }

  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse(const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse&) = delete;
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse& operator=(const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_for_main_frame_;};

class RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback(
      RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback(const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback&) = delete;
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback& operator=(const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrameCallback callback_;
};
class RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse(
      bool* result, uint32_t* out_index)
      : result_(result), out_index_(out_index) {
    DCHECK(!*result_);
  }

  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse(const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse&) = delete;
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse& operator=(const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint32_t* out_index_;};

class RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback(
      RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPointCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback(const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback&) = delete;
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback& operator=(const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPointCallback callback_;
};
class RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse(
      bool* result, ::gfx::Rect* out_out_rect, ::gfx::Range* out_out_actual_range, bool* out_success)
      : result_(result), out_out_rect_(out_out_rect), out_out_actual_range_(out_out_actual_range), out_success_(out_success) {
    DCHECK(!*result_);
  }

  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse(const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse&) = delete;
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse& operator=(const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::Rect* out_out_rect_;
  ::gfx::Range* out_out_actual_range_;
  bool* out_success_;};

class RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback(
      RenderWidgetHostNSViewHost::SyncGetFirstRectForRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback(const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback&) = delete;
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback& operator=(const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSViewHost::SyncGetFirstRectForRangeCallback callback_;
};
class RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse(
      bool* result, bool* out_is_speaking)
      : result_(result), out_is_speaking_(out_is_speaking) {
    DCHECK(!*result_);
  }

  RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse(const RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse&) = delete;
  RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse& operator=(const RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_speaking_;};

class RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback(
      RenderWidgetHostNSViewHost::SyncIsSpeakingCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback(const RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback&) = delete;
  RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback& operator=(const RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSViewHost::SyncIsSpeakingCallback callback_;
};
class RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse(
      bool* result, ::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token)
      : result_(result), out_host_pid_(out_host_pid), out_element_token_(out_element_token) {
    DCHECK(!*result_);
  }

  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse(const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse&) = delete;
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse& operator=(const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::ProcessId* out_host_pid_;
  std::vector<uint8_t>* out_element_token_;};

class RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback(
      RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback(const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback&) = delete;
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback& operator=(const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityTokenCallback callback_;
};

RenderWidgetHostNSViewHostProxy::RenderWidgetHostNSViewHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool RenderWidgetHostNSViewHostProxy::SyncIsWidgetForMainFrame(
    bool* out_param_is_for_main_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame (sync)");
#else
  TRACE_EVENT0("mojom", "RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsWidgetForMainFrame");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse(
          &result, out_param_is_for_main_frame));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_main_frame"), out_param_is_for_main_frame,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RenderWidgetHostNSViewHostProxy::SyncIsWidgetForMainFrame(
    SyncIsWidgetForMainFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsWidgetForMainFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderWidgetHostNSViewHostProxy::RequestShutdown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::RequestShutdown");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kRequestShutdown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_RequestShutdown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("RequestShutdown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::OnFirstResponderChanged(
    bool in_is_first_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnFirstResponderChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_first_responder"), in_is_first_responder,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_first_responder = in_is_first_responder;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("OnFirstResponderChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::OnWindowIsKeyChanged(
    bool in_is_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowIsKeyChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_key"), in_is_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_key = in_is_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("OnWindowIsKeyChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::OnBoundsInWindowChanged(
    const ::gfx::Rect& in_view_bounds_in_window_dip, bool in_attached_to_window) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnBoundsInWindowChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_bounds_in_window_dip"), in_view_bounds_in_window_dip,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attached_to_window"), in_attached_to_window,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->view_bounds_in_window_dip)::BaseType> view_bounds_in_window_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_view_bounds_in_window_dip,
    view_bounds_in_window_dip_fragment);

  params->view_bounds_in_window_dip.Set(
      view_bounds_in_window_dip_fragment.is_null() ? nullptr : view_bounds_in_window_dip_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->view_bounds_in_window_dip.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null view_bounds_in_window_dip in RenderWidgetHostNSViewHost.OnBoundsInWindowChanged request");

  params->attached_to_window = in_attached_to_window;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("OnBoundsInWindowChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::OnWindowFrameInScreenChanged(
    const ::gfx::Rect& in_window_frame_in_screen_dip) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnWindowFrameInScreenChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_frame_in_screen_dip"), in_window_frame_in_screen_dip,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_frame_in_screen_dip)::BaseType> window_frame_in_screen_dip_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_window_frame_in_screen_dip,
    window_frame_in_screen_dip_fragment);

  params->window_frame_in_screen_dip.Set(
      window_frame_in_screen_dip_fragment.is_null() ? nullptr : window_frame_in_screen_dip_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_frame_in_screen_dip.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_frame_in_screen_dip in RenderWidgetHostNSViewHost.OnWindowFrameInScreenChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("OnWindowFrameInScreenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::OnScreenInfosChanged(
    const ::display::ScreenInfos& in_screen_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::OnScreenInfosChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_infos"), in_screen_infos,
                        "<value of type const ::display::ScreenInfos&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->screen_infos)::BaseType> screen_infos_fragment(
          params.message());
  
  mojo::internal::Serialize<::display::mojom::ScreenInfosDataView>(
    in_screen_infos,
    screen_infos_fragment);

  params->screen_infos.Set(
      screen_infos_fragment.is_null() ? nullptr : screen_infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_infos in RenderWidgetHostNSViewHost.OnScreenInfosChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("OnScreenInfosChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::BeginKeyboardEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::BeginKeyboardEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("BeginKeyboardEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::EndKeyboardEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::EndKeyboardEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("EndKeyboardEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ForwardKeyboardEventWithCommands(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, const std::vector<uint8_t>& in_native_event_data, bool in_skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> in_commands) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardKeyboardEventWithCommands", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_event_data"), in_native_event_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("skip_if_unhandled"), in_skip_if_unhandled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commands"), in_commands,
                        "<value of type std::vector<::blink::mojom::EditCommandPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.ForwardKeyboardEventWithCommands request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_event_data)::BaseType>
      native_event_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_native_event_data,
    native_event_data_fragment,
    &native_event_data_validate_params);

  params->native_event_data.Set(
      native_event_data_fragment.is_null() ? nullptr : native_event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_event_data in RenderWidgetHostNSViewHost.ForwardKeyboardEventWithCommands request");

  params->skip_if_unhandled = in_skip_if_unhandled;
  mojo::internal::MessageFragment<
      typename decltype(params->commands)::BaseType>
      commands_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::EditCommandDataView>>(
    in_commands,
    commands_fragment,
    &commands_validate_params);

  params->commands.Set(
      commands_fragment.is_null() ? nullptr : commands_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->commands.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null commands in RenderWidgetHostNSViewHost.ForwardKeyboardEventWithCommands request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ForwardKeyboardEventWithCommands");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::RouteOrProcessMouseEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.RouteOrProcessMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("RouteOrProcessMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::RouteOrProcessTouchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessTouchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.RouteOrProcessTouchEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("RouteOrProcessTouchEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::RouteOrProcessWheelEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::RouteOrProcessWheelEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.RouteOrProcessWheelEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("RouteOrProcessWheelEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ForwardMouseEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kForwardMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.ForwardMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ForwardMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ForwardWheelEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ForwardWheelEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kForwardWheelEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.ForwardWheelEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ForwardWheelEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::PinchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_is_synthetically_injected) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::PinchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_synthetically_injected"), in_is_synthetically_injected,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kPinchEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_PinchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.PinchEvent request");

  params->is_synthetically_injected = in_is_synthetically_injected;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("PinchEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::SmartMagnifyEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SmartMagnifyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in RenderWidgetHostNSViewHost.SmartMagnifyEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SmartMagnifyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ImeSetComposition(
    const ::std::u16string& in_text, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_replacement_range, int32_t in_selection_start, int32_t in_selection_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeSetComposition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_range"), in_replacement_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start"), in_selection_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end"), in_selection_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kImeSetComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in RenderWidgetHostNSViewHost.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in RenderWidgetHostNSViewHost.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_range)::BaseType> replacement_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_replacement_range,
    replacement_range_fragment);

  params->replacement_range.Set(
      replacement_range_fragment.is_null() ? nullptr : replacement_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_range in RenderWidgetHostNSViewHost.ImeSetComposition request");

  params->selection_start = in_selection_start;

  params->selection_end = in_selection_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ImeSetComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ImeCommitText(
    const ::std::u16string& in_text, const ::gfx::Range& in_replacement_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCommitText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_range"), in_replacement_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kImeCommitText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ImeCommitText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in RenderWidgetHostNSViewHost.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_range)::BaseType> replacement_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_replacement_range,
    replacement_range_fragment);

  params->replacement_range.Set(
      replacement_range_fragment.is_null() ? nullptr : replacement_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_range in RenderWidgetHostNSViewHost.ImeCommitText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ImeCommitText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ImeFinishComposingText(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeFinishComposingText");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kImeFinishComposingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ImeFinishComposingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::ImeCancelCompositionFromCocoa(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ImeCancelCompositionFromCocoa");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ImeCancelCompositionFromCocoa");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::LookUpDictionaryOverlayAtPoint(
    const ::gfx::PointF& in_root_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), in_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in RenderWidgetHostNSViewHost.LookUpDictionaryOverlayAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("LookUpDictionaryOverlayAtPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::LookUpDictionaryOverlayFromRange(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::LookUpDictionaryOverlayFromRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in RenderWidgetHostNSViewHost.LookUpDictionaryOverlayFromRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("LookUpDictionaryOverlayFromRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool RenderWidgetHostNSViewHostProxy::SyncGetCharacterIndexAtPoint(
    const ::gfx::PointF& param_root_point, uint32_t* out_param_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), param_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#else
  TRACE_EVENT0("mojom", "RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    param_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in RenderWidgetHostNSViewHost.SyncGetCharacterIndexAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetCharacterIndexAtPoint");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse(
          &result, out_param_index));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), out_param_index,
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void RenderWidgetHostNSViewHostProxy::SyncGetCharacterIndexAtPoint(
    const ::gfx::PointF& in_root_point, SyncGetCharacterIndexAtPointCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), in_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in RenderWidgetHostNSViewHost.SyncGetCharacterIndexAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetCharacterIndexAtPoint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool RenderWidgetHostNSViewHostProxy::SyncGetFirstRectForRange(
    const ::gfx::Range& param_requested_range, ::gfx::Rect* out_param_out_rect, ::gfx::Range* out_param_out_actual_range, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), param_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#else
  TRACE_EVENT0("mojom", "RenderWidgetHostNSViewHost::SyncGetFirstRectForRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    param_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in RenderWidgetHostNSViewHost.SyncGetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetFirstRectForRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse(
          &result, out_param_out_rect, out_param_out_actual_range, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RenderWidgetHostNSViewHost::SyncGetFirstRectForRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out_rect"), out_param_out_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out_actual_range"), out_param_out_actual_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RenderWidgetHostNSViewHostProxy::SyncGetFirstRectForRange(
    const ::gfx::Range& in_requested_range, SyncGetFirstRectForRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), in_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in RenderWidgetHostNSViewHost.SyncGetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetFirstRectForRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderWidgetHostNSViewHostProxy::ExecuteEditCommand(
    const std::string& in_command) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::ExecuteEditCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kExecuteEditCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->command)::BaseType> command_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_command,
    command_fragment);

  params->command.Set(
      command_fragment.is_null() ? nullptr : command_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->command.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null command in RenderWidgetHostNSViewHost.ExecuteEditCommand request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("ExecuteEditCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::Redo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::Redo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("Redo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::Cut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::Cut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kCut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_Cut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("Cut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::Copy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::Copy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_Copy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("Copy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::CopyToFindPboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::CopyToFindPboard");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kCopyToFindPboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("CopyToFindPboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::CenterSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::CenterSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kCenterSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_CenterSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("CenterSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::Paste(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::Paste");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_Paste_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("Paste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::PasteAndMatchStyle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::PasteAndMatchStyle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("PasteAndMatchStyle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::SelectAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SelectAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSelectAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SelectAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SelectAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::StartSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::StartSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kStartSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_StartSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("StartSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderWidgetHostNSViewHostProxy::StopSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::StopSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kStopSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_StopSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("StopSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool RenderWidgetHostNSViewHostProxy::SyncIsSpeaking(
    bool* out_param_is_speaking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking (sync)");
#else
  TRACE_EVENT0("mojom", "RenderWidgetHostNSViewHost::SyncIsSpeaking");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsSpeaking");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse(
          &result, out_param_is_speaking));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RenderWidgetHostNSViewHost::SyncIsSpeaking", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speaking"), out_param_is_speaking,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RenderWidgetHostNSViewHostProxy::SyncIsSpeaking(
    SyncIsSpeakingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsSpeaking");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool RenderWidgetHostNSViewHostProxy::GetRenderWidgetAccessibilityToken(
    ::base::ProcessId* out_param_host_pid, std::vector<uint8_t>* out_param_element_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken (sync)");
#else
  TRACE_EVENT0("mojom", "RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("GetRenderWidgetAccessibilityToken");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse(
          &result, out_param_host_pid, out_param_element_token));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_pid"), out_param_host_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_token"), out_param_element_token,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  return result;
}

void RenderWidgetHostNSViewHostProxy::GetRenderWidgetAccessibilityToken(
    GetRenderWidgetAccessibilityTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("GetRenderWidgetAccessibilityToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderWidgetHostNSViewHostProxy::SetRemoteAccessibilityWindowToken(
    const std::vector<uint8_t>& in_window_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::RenderWidgetHostNSViewHost::SetRemoteAccessibilityWindowToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_token"), in_window_token,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_token)::BaseType>
      window_token_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& window_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_window_token,
    window_token_fragment,
    &window_token_validate_params);

  params->window_token.Set(
      window_token_fragment.is_null() ? nullptr : window_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_token in RenderWidgetHostNSViewHost.SetRemoteAccessibilityWindowToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SetRemoteAccessibilityWindowToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder> proxy(
        new RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_for_main_frame);
};

bool RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.0
  bool success = true;
  bool p_is_for_main_frame{};
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_for_main_frame = input_data_view.is_for_main_frame();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_for_main_frame));
  }
  return true;
}

void RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder::Run(
    bool in_is_for_main_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsWidgetForMainFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_main_frame"), in_is_for_main_frame,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_for_main_frame = in_is_for_main_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsWidgetForMainFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.0
  bool success = true;
  bool p_is_for_main_frame{};
  RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_for_main_frame = input_data_view.is_for_main_frame();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 0, true);
    return false;
  }
  *out_is_for_main_frame_ = std::move(p_is_for_main_frame);
  *result_ = true;
  return true;
}
class RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPointCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder> proxy(
        new RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPointCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_index);
};

bool RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.23
  bool success = true;
  uint32_t p_index{};
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_index = input_data_view.index();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_index));
  }
  return true;
}

void RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder::Run(
    uint32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetCharacterIndexAtPoint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetCharacterIndexAtPoint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.23
  bool success = true;
  uint32_t p_index{};
  RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_index = input_data_view.index();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 23, true);
    return false;
  }
  *out_index_ = std::move(p_index);
  *result_ = true;
  return true;
}
class RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSViewHost::SyncGetFirstRectForRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder> proxy(
        new RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSViewHost::SyncGetFirstRectForRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Rect& in_out_rect, const ::gfx::Range& in_out_actual_range, bool in_success);
};

bool RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.24
  bool success = true;
  ::gfx::Rect p_out_rect{};
  ::gfx::Range p_out_actual_range{};
  bool p_success{};
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOutRect(&p_out_rect))
    success = false;
  if (success && !input_data_view.ReadOutActualRange(&p_out_actual_range))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_out_rect), 
std::move(p_out_actual_range), 
std::move(p_success));
  }
  return true;
}

void RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder::Run(
    const ::gfx::Rect& in_out_rect, const ::gfx::Range& in_out_actual_range, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncGetFirstRectForRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out_rect"), in_out_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out_actual_range"), in_out_actual_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->out_rect)::BaseType> out_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_out_rect,
    out_rect_fragment);

  params->out_rect.Set(
      out_rect_fragment.is_null() ? nullptr : out_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->out_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null out_rect in ");
  mojo::internal::MessageFragment<
      typename decltype(params->out_actual_range)::BaseType> out_actual_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_out_actual_range,
    out_actual_range_fragment);

  params->out_actual_range.Set(
      out_actual_range_fragment.is_null() ? nullptr : out_actual_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->out_actual_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null out_actual_range in ");

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncGetFirstRectForRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.24
  bool success = true;
  ::gfx::Rect p_out_rect{};
  ::gfx::Range p_out_actual_range{};
  bool p_success{};
  RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOutRect(&p_out_rect))
    success = false;
  if (success && !input_data_view.ReadOutActualRange(&p_out_actual_range))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 24, true);
    return false;
  }
  *out_out_rect_ = std::move(p_out_rect);
  *out_out_actual_range_ = std::move(p_out_actual_range);
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSViewHost::SyncIsSpeakingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder> proxy(
        new RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSViewHost::SyncIsSpeakingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_speaking);
};

bool RenderWidgetHostNSViewHost_SyncIsSpeaking_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.37
  bool success = true;
  bool p_is_speaking{};
  RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_speaking = input_data_view.is_speaking();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_speaking));
  }
  return true;
}

void RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder::Run(
    bool in_is_speaking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::SyncIsSpeaking", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speaking"), in_is_speaking,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_speaking = in_is_speaking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("SyncIsSpeaking");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderWidgetHostNSViewHost_SyncIsSpeaking_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.37
  bool success = true;
  bool p_is_speaking{};
  RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_speaking = input_data_view.is_speaking();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 37, true);
    return false;
  }
  *out_is_speaking_ = std::move(p_is_speaking);
  *result_ = true;
  return true;
}
class RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder> proxy(
        new RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityTokenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ProcessId in_host_pid, const std::vector<uint8_t>& in_element_token);
};

bool RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.38
  bool success = true;
  ::base::ProcessId p_host_pid{};
  std::vector<uint8_t> p_element_token{};
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHostPid(&p_host_pid))
    success = false;
  if (success && !input_data_view.ReadElementToken(&p_element_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_host_pid), 
std::move(p_element_token));
  }
  return true;
}

void RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder::Run(
    ::base::ProcessId in_host_pid, const std::vector<uint8_t>& in_element_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::RenderWidgetHostNSViewHost::GetRenderWidgetAccessibilityToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_pid"), in_host_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_token"), in_element_token,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_pid)::BaseType> host_pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_host_pid,
    host_pid_fragment);

  params->host_pid.Set(
      host_pid_fragment.is_null() ? nullptr : host_pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_pid in ");
  mojo::internal::MessageFragment<
      typename decltype(params->element_token)::BaseType>
      element_token_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& element_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_element_token,
    element_token_fragment,
    &element_token_validate_params);

  params->element_token.Set(
      element_token_fragment.is_null() ? nullptr : element_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->element_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null element_token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderWidgetHostNSViewHost::Name_);
  message.set_method_name("GetRenderWidgetAccessibilityToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RenderWidgetHostNSViewHost.38
  bool success = true;
  ::base::ProcessId p_host_pid{};
  std::vector<uint8_t> p_element_token{};
  RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHostPid(&p_host_pid))
    success = false;
  if (success && !input_data_view.ReadElementToken(&p_element_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderWidgetHostNSViewHost::Name_, 38, true);
    return false;
  }
  *out_host_pid_ = std::move(p_host_pid);
  *out_element_token_ = std::move(p_element_token);
  *result_ = true;
  return true;
}

// static
bool RenderWidgetHostNSViewHostStubDispatch::Accept(
    RenderWidgetHostNSViewHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderWidgetHostNSViewHost>(message->header()->name)) {
    case messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kRequestShutdown: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_RequestShutdown_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_RequestShutdown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.1
      bool success = true;
      RenderWidgetHostNSViewHost_RequestShutdown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestShutdown(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.2
      bool success = true;
      bool p_is_first_responder{};
      RenderWidgetHostNSViewHost_OnFirstResponderChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_first_responder = input_data_view.is_first_responder();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstResponderChanged(        
        std::move(p_is_first_responder));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.3
      bool success = true;
      bool p_is_key{};
      RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_key = input_data_view.is_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowIsKeyChanged(        
        std::move(p_is_key));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.4
      bool success = true;
      ::gfx::Rect p_view_bounds_in_window_dip{};
      bool p_attached_to_window{};
      RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViewBoundsInWindowDip(&p_view_bounds_in_window_dip))
        success = false;
      if (success)
        p_attached_to_window = input_data_view.attached_to_window();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBoundsInWindowChanged(        
        std::move(p_view_bounds_in_window_dip), 
        std::move(p_attached_to_window));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.5
      bool success = true;
      ::gfx::Rect p_window_frame_in_screen_dip{};
      RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowFrameInScreenDip(&p_window_frame_in_screen_dip))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowFrameInScreenChanged(        
        std::move(p_window_frame_in_screen_dip));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.6
      bool success = true;
      ::display::ScreenInfos p_screen_infos{};
      RenderWidgetHostNSViewHost_OnScreenInfosChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScreenInfos(&p_screen_infos))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreenInfosChanged(        
        std::move(p_screen_infos));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.7
      bool success = true;
      RenderWidgetHostNSViewHost_BeginKeyboardEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginKeyboardEvent(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.8
      bool success = true;
      RenderWidgetHostNSViewHost_EndKeyboardEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndKeyboardEvent(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.9
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      std::vector<uint8_t> p_native_event_data{};
      bool p_skip_if_unhandled{};
      std::vector<::blink::mojom::EditCommandPtr> p_commands{};
      RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadNativeEventData(&p_native_event_data))
        success = false;
      if (success)
        p_skip_if_unhandled = input_data_view.skip_if_unhandled();
      if (success && !input_data_view.ReadCommands(&p_commands))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardKeyboardEventWithCommands(        
        std::move(p_event), 
        std::move(p_native_event_data), 
        std::move(p_skip_if_unhandled), 
        std::move(p_commands));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.10
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.11
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessTouchEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.12
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessWheelEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardMouseEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.13
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_ForwardMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardWheelEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.14
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_ForwardWheelEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardWheelEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kPinchEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_PinchEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_PinchEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.15
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_is_synthetically_injected{};
      RenderWidgetHostNSViewHost_PinchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_is_synthetically_injected = input_data_view.is_synthetically_injected();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PinchEvent(        
        std::move(p_event), 
        std::move(p_is_synthetically_injected));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.16
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderWidgetHostNSViewHost_SmartMagnifyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SmartMagnifyEvent(        
        std::move(p_event));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kImeSetComposition: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.17
      bool success = true;
      ::std::u16string p_text{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_replacement_range{};
      int32_t p_selection_start{};
      int32_t p_selection_end{};
      RenderWidgetHostNSViewHost_ImeSetComposition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadReplacementRange(&p_replacement_range))
        success = false;
      if (success)
        p_selection_start = input_data_view.selection_start();
      if (success)
        p_selection_end = input_data_view.selection_end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeSetComposition(        
        std::move(p_text), 
        std::move(p_ime_text_spans), 
        std::move(p_replacement_range), 
        std::move(p_selection_start), 
        std::move(p_selection_end));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCommitText: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ImeCommitText_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ImeCommitText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.18
      bool success = true;
      ::std::u16string p_text{};
      ::gfx::Range p_replacement_range{};
      RenderWidgetHostNSViewHost_ImeCommitText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadReplacementRange(&p_replacement_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCommitText(        
        std::move(p_text), 
        std::move(p_replacement_range));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kImeFinishComposingText: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.19
      bool success = true;
      RenderWidgetHostNSViewHost_ImeFinishComposingText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeFinishComposingText(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.20
      bool success = true;
      RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCancelCompositionFromCocoa(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.21
      bool success = true;
      ::gfx::PointF p_root_point{};
      RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootPoint(&p_root_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpDictionaryOverlayAtPoint(        
        std::move(p_root_point));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.22
      bool success = true;
      ::gfx::Range p_range{};
      RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpDictionaryOverlayFromRange(        
        std::move(p_range));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kExecuteEditCommand: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.25
      bool success = true;
      std::string p_command{};
      RenderWidgetHostNSViewHost_ExecuteEditCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteEditCommand(        
        std::move(p_command));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kUndo: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_Undo_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.26
      bool success = true;
      RenderWidgetHostNSViewHost_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kRedo: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_Redo_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_Redo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.27
      bool success = true;
      RenderWidgetHostNSViewHost_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kCut: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_Cut_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_Cut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.28
      bool success = true;
      RenderWidgetHostNSViewHost_Cut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cut(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kCopy: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_Copy_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_Copy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.29
      bool success = true;
      RenderWidgetHostNSViewHost_Copy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kCopyToFindPboard: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.30
      bool success = true;
      RenderWidgetHostNSViewHost_CopyToFindPboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyToFindPboard(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kCenterSelection: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_CenterSelection_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_CenterSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.31
      bool success = true;
      RenderWidgetHostNSViewHost_CenterSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CenterSelection(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kPaste: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_Paste_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_Paste_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.32
      bool success = true;
      RenderWidgetHostNSViewHost_Paste_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Paste(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.33
      bool success = true;
      RenderWidgetHostNSViewHost_PasteAndMatchStyle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasteAndMatchStyle(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSelectAll: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_SelectAll_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_SelectAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.34
      bool success = true;
      RenderWidgetHostNSViewHost_SelectAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAll(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kStartSpeaking: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_StartSpeaking_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_StartSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.35
      bool success = true;
      RenderWidgetHostNSViewHost_StartSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSpeaking(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kStopSpeaking: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_StopSpeaking_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_StopSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.36
      bool success = true;
      RenderWidgetHostNSViewHost_StopSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopSpeaking(        );
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken: {
      DCHECK(message->is_serialized());
      internal::RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data* params =
          reinterpret_cast<internal::RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.39
      bool success = true;
      std::vector<uint8_t> p_window_token{};
      RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowToken(&p_window_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRemoteAccessibilityWindowToken(        
        std::move(p_window_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderWidgetHostNSViewHostStubDispatch::AcceptWithResponder(
    RenderWidgetHostNSViewHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderWidgetHostNSViewHost>(message->header()->name)) {
    case messages::RenderWidgetHostNSViewHost::kSyncIsWidgetForMainFrame: {
      internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.0
      bool success = true;
      RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 0, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SyncIsWidgetForMainFrame(std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kRequestShutdown: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kOnFirstResponderChanged: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowIsKeyChanged: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kOnBoundsInWindowChanged: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kOnWindowFrameInScreenChanged: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kOnScreenInfosChanged: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kBeginKeyboardEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kEndKeyboardEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardKeyboardEventWithCommands: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessMouseEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessTouchEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kRouteOrProcessWheelEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardMouseEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kForwardWheelEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kPinchEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSmartMagnifyEvent: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kImeSetComposition: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCommitText: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kImeFinishComposingText: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kImeCancelCompositionFromCocoa: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayAtPoint: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kLookUpDictionaryOverlayFromRange: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetCharacterIndexAtPoint: {
      internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.23
      bool success = true;
      ::gfx::PointF p_root_point{};
      RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootPoint(&p_root_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 23, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SyncGetCharacterIndexAtPoint(        
        std::move(p_root_point), std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncGetFirstRectForRange: {
      internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.24
      bool success = true;
      ::gfx::Range p_requested_range{};
      RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestedRange(&p_requested_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 24, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SyncGetFirstRectForRange(        
        std::move(p_requested_range), std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kExecuteEditCommand: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kUndo: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kRedo: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kCut: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kCopy: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kCopyToFindPboard: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kCenterSelection: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kPaste: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kPasteAndMatchStyle: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSelectAll: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kStartSpeaking: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kStopSpeaking: {
      break;
    }
    case messages::RenderWidgetHostNSViewHost::kSyncIsSpeaking: {
      internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.37
      bool success = true;
      RenderWidgetHostNSViewHost_SyncIsSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 37, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSViewHost_SyncIsSpeaking_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SyncIsSpeaking(std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kGetRenderWidgetAccessibilityToken: {
      internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data* params =
          reinterpret_cast<
              internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderWidgetHostNSViewHost.38
      bool success = true;
      RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderWidgetHostNSViewHost::Name_, 38, false);
        return false;
      }
      auto callback =
          RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRenderWidgetAccessibilityToken(std::move(callback));
      return true;
    }
    case messages::RenderWidgetHostNSViewHost::kSetRemoteAccessibilityWindowToken: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderWidgetHostNSViewHostValidationInfo[] = {
    { &internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data::Validate,
     &internal::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSViewHost_RequestShutdown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_PinchEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ImeCommitText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data::Validate,
     &internal::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data::Validate,
     &internal::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_Redo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_Cut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_Copy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_CenterSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_Paste_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_SelectAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_StartSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_StopSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data::Validate,
     &internal::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data::Validate,
     &internal::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data::Validate},
    { &internal::RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderWidgetHostNSViewHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::RenderWidgetHostNSViewHost::Name_,
    kRenderWidgetHostNSViewHostValidationInfo);
}

bool RenderWidgetHostNSViewHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::RenderWidgetHostNSViewHost::Name_,
    kRenderWidgetHostNSViewHostValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::PopupMenu::DataView, ::remote_cocoa::mojom::PopupMenuPtr>::Read(
    ::remote_cocoa::mojom::PopupMenu::DataView input,
    ::remote_cocoa::mojom::PopupMenuPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::PopupMenuPtr result(::remote_cocoa::mojom::PopupMenu::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success)
        result->item_font_size = input.item_font_size();
      if (success)
        result->right_aligned = input.right_aligned();
      if (success)
        result->selected_item = input.selected_item();
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void PopupMenuRunnerInterceptorForTesting::Hide() {
  GetForwardingInterface()->Hide();
}
PopupMenuRunnerAsyncWaiter::PopupMenuRunnerAsyncWaiter(
    PopupMenuRunner* proxy) : proxy_(proxy) {}

PopupMenuRunnerAsyncWaiter::~PopupMenuRunnerAsyncWaiter() = default;





void RenderWidgetHostNSViewInterceptorForTesting::InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_ns_view_id) {
  GetForwardingInterface()->InitAsPopup(
    std::move(content_rect)
    , 
    std::move(popup_parent_ns_view_id)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetParentWebContentsNSView(uint64_t parent_ns_view_id) {
  GetForwardingInterface()->SetParentWebContentsNSView(
    std::move(parent_ns_view_id)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::DisableDisplay() {
  GetForwardingInterface()->DisableDisplay();
}
void RenderWidgetHostNSViewInterceptorForTesting::MakeFirstResponder() {
  GetForwardingInterface()->MakeFirstResponder();
}
void RenderWidgetHostNSViewInterceptorForTesting::SetBounds(const ::gfx::Rect& rect) {
  GetForwardingInterface()->SetBounds(
    std::move(rect)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) {
  GetForwardingInterface()->SetCALayerParams(
    std::move(ca_layer_params)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetBackgroundColor(uint32_t color) {
  GetForwardingInterface()->SetBackgroundColor(
    std::move(color)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetVisible(bool visible) {
  GetForwardingInterface()->SetVisible(
    std::move(visible)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetTooltipText(const ::std::u16string& display_text) {
  GetForwardingInterface()->SetTooltipText(
    std::move(display_text)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags) {
  GetForwardingInterface()->SetTextInputState(
    std::move(text_input_type)
    , 
    std::move(flags)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) {
  GetForwardingInterface()->SetTextSelection(
    std::move(text)
    , 
    std::move(offset)
    , 
    std::move(range)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetCompositionRangeInfo(const ::gfx::Range& range) {
  GetForwardingInterface()->SetCompositionRangeInfo(
    std::move(range)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::CancelComposition() {
  GetForwardingInterface()->CancelComposition();
}
void RenderWidgetHostNSViewInterceptorForTesting::SetShowingContextMenu(bool showing) {
  GetForwardingInterface()->SetShowingContextMenu(
    std::move(showing)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::DisplayCursor(const ::ui::Cursor& cursor) {
  GetForwardingInterface()->DisplayCursor(
    std::move(cursor)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetCursorLocked(bool locked) {
  GetForwardingInterface()->SetCursorLocked(
    std::move(locked)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) {
  GetForwardingInterface()->SetCursorLockedUnacceleratedMovement(
    std::move(unaccelerated_movement)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::ShowDictionaryOverlayForSelection() {
  GetForwardingInterface()->ShowDictionaryOverlayForSelection();
}
void RenderWidgetHostNSViewInterceptorForTesting::ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) {
  GetForwardingInterface()->ShowDictionaryOverlay(
    std::move(attributed_string)
    , 
    std::move(baseline_point)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) {
  GetForwardingInterface()->LockKeyboard(
    std::move(dom_codes)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::UnlockKeyboard() {
  GetForwardingInterface()->UnlockKeyboard();
}
void RenderWidgetHostNSViewInterceptorForTesting::ShowSharingServicePicker(const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) {
  GetForwardingInterface()->ShowSharingServicePicker(
    std::move(title)
    , 
    std::move(text)
    , 
    std::move(url)
    , 
    std::move(file_paths)
    , std::move(callback));
}
void RenderWidgetHostNSViewInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
void RenderWidgetHostNSViewInterceptorForTesting::GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) {
  GetForwardingInterface()->GestureScrollEventAck(
    std::move(event)
    , 
    std::move(consumed)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::DidOverscroll(::blink::mojom::DidOverscrollParamsPtr params) {
  GetForwardingInterface()->DidOverscroll(
    std::move(params)
    );
}
void RenderWidgetHostNSViewInterceptorForTesting::DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) {
  GetForwardingInterface()->DisplayPopupMenu(
    std::move(menu)
    , std::move(callback));
}
RenderWidgetHostNSViewAsyncWaiter::RenderWidgetHostNSViewAsyncWaiter(
    RenderWidgetHostNSView* proxy) : proxy_(proxy) {}

RenderWidgetHostNSViewAsyncWaiter::~RenderWidgetHostNSViewAsyncWaiter() = default;


void RenderWidgetHostNSViewAsyncWaiter::ShowSharingServicePicker(
    const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths, ::blink::mojom::ShareError* out_error) {
  base::RunLoop loop;
  proxy_->ShowSharingServicePicker(
      std::move(title),
      std::move(text),
      std::move(url),
      std::move(file_paths),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ShareError* out_error
,
             ::blink::mojom::ShareError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::blink::mojom::ShareError RenderWidgetHostNSViewAsyncWaiter::ShowSharingServicePicker(
    const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths) {
  ::blink::mojom::ShareError async_wait_result;
  ShowSharingServicePicker(std::move(title),std::move(text),std::move(url),std::move(file_paths),&async_wait_result);
  return async_wait_result;
}

void RenderWidgetHostNSViewAsyncWaiter::DisplayPopupMenu(
    PopupMenuPtr menu, std::optional<uint32_t>* out_selected_item) {
  base::RunLoop loop;
  proxy_->DisplayPopupMenu(
      std::move(menu),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_selected_item
,
             std::optional<uint32_t> selected_item) {*out_selected_item = std::move(selected_item);
            loop->Quit();
          },
          &loop,
          out_selected_item));
  loop.Run();
}

std::optional<uint32_t> RenderWidgetHostNSViewAsyncWaiter::DisplayPopupMenu(
    PopupMenuPtr menu) {
  std::optional<uint32_t> async_wait_result;
  DisplayPopupMenu(std::move(menu),&async_wait_result);
  return async_wait_result;
}




void RenderWidgetHostNSViewHostInterceptorForTesting::SyncIsWidgetForMainFrame(SyncIsWidgetForMainFrameCallback callback) {
  GetForwardingInterface()->SyncIsWidgetForMainFrame(std::move(callback));
}
void RenderWidgetHostNSViewHostInterceptorForTesting::RequestShutdown() {
  GetForwardingInterface()->RequestShutdown();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::OnFirstResponderChanged(bool is_first_responder) {
  GetForwardingInterface()->OnFirstResponderChanged(
    std::move(is_first_responder)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::OnWindowIsKeyChanged(bool is_key) {
  GetForwardingInterface()->OnWindowIsKeyChanged(
    std::move(is_key)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::OnBoundsInWindowChanged(const ::gfx::Rect& view_bounds_in_window_dip, bool attached_to_window) {
  GetForwardingInterface()->OnBoundsInWindowChanged(
    std::move(view_bounds_in_window_dip)
    , 
    std::move(attached_to_window)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::OnWindowFrameInScreenChanged(const ::gfx::Rect& window_frame_in_screen_dip) {
  GetForwardingInterface()->OnWindowFrameInScreenChanged(
    std::move(window_frame_in_screen_dip)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::OnScreenInfosChanged(const ::display::ScreenInfos& screen_infos) {
  GetForwardingInterface()->OnScreenInfosChanged(
    std::move(screen_infos)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::BeginKeyboardEvent() {
  GetForwardingInterface()->BeginKeyboardEvent();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::EndKeyboardEvent() {
  GetForwardingInterface()->EndKeyboardEvent();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) {
  GetForwardingInterface()->ForwardKeyboardEventWithCommands(
    std::move(event)
    , 
    std::move(native_event_data)
    , 
    std::move(skip_if_unhandled)
    , 
    std::move(commands)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessMouseEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessTouchEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessWheelEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ForwardMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->ForwardMouseEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ForwardWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->ForwardWheelEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::PinchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) {
  GetForwardingInterface()->PinchEvent(
    std::move(event)
    , 
    std::move(is_synthetically_injected)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SmartMagnifyEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->SmartMagnifyEvent(
    std::move(event)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) {
  GetForwardingInterface()->ImeSetComposition(
    std::move(text)
    , 
    std::move(ime_text_spans)
    , 
    std::move(replacement_range)
    , 
    std::move(selection_start)
    , 
    std::move(selection_end)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) {
  GetForwardingInterface()->ImeCommitText(
    std::move(text)
    , 
    std::move(replacement_range)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ImeFinishComposingText() {
  GetForwardingInterface()->ImeFinishComposingText();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ImeCancelCompositionFromCocoa() {
  GetForwardingInterface()->ImeCancelCompositionFromCocoa();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) {
  GetForwardingInterface()->LookUpDictionaryOverlayAtPoint(
    std::move(root_point)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) {
  GetForwardingInterface()->LookUpDictionaryOverlayFromRange(
    std::move(range)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SyncGetCharacterIndexAtPoint(const ::gfx::PointF& root_point, SyncGetCharacterIndexAtPointCallback callback) {
  GetForwardingInterface()->SyncGetCharacterIndexAtPoint(
    std::move(root_point)
    , std::move(callback));
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SyncGetFirstRectForRange(const ::gfx::Range& requested_range, SyncGetFirstRectForRangeCallback callback) {
  GetForwardingInterface()->SyncGetFirstRectForRange(
    std::move(requested_range)
    , std::move(callback));
}
void RenderWidgetHostNSViewHostInterceptorForTesting::ExecuteEditCommand(const std::string& command) {
  GetForwardingInterface()->ExecuteEditCommand(
    std::move(command)
    );
}
void RenderWidgetHostNSViewHostInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::Redo() {
  GetForwardingInterface()->Redo();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::Cut() {
  GetForwardingInterface()->Cut();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::Copy() {
  GetForwardingInterface()->Copy();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::CopyToFindPboard() {
  GetForwardingInterface()->CopyToFindPboard();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::CenterSelection() {
  GetForwardingInterface()->CenterSelection();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::Paste() {
  GetForwardingInterface()->Paste();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::PasteAndMatchStyle() {
  GetForwardingInterface()->PasteAndMatchStyle();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SelectAll() {
  GetForwardingInterface()->SelectAll();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::StartSpeaking() {
  GetForwardingInterface()->StartSpeaking();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::StopSpeaking() {
  GetForwardingInterface()->StopSpeaking();
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SyncIsSpeaking(SyncIsSpeakingCallback callback) {
  GetForwardingInterface()->SyncIsSpeaking(std::move(callback));
}
void RenderWidgetHostNSViewHostInterceptorForTesting::GetRenderWidgetAccessibilityToken(GetRenderWidgetAccessibilityTokenCallback callback) {
  GetForwardingInterface()->GetRenderWidgetAccessibilityToken(std::move(callback));
}
void RenderWidgetHostNSViewHostInterceptorForTesting::SetRemoteAccessibilityWindowToken(const std::vector<uint8_t>& window_token) {
  GetForwardingInterface()->SetRemoteAccessibilityWindowToken(
    std::move(window_token)
    );
}
RenderWidgetHostNSViewHostAsyncWaiter::RenderWidgetHostNSViewHostAsyncWaiter(
    RenderWidgetHostNSViewHost* proxy) : proxy_(proxy) {}

RenderWidgetHostNSViewHostAsyncWaiter::~RenderWidgetHostNSViewHostAsyncWaiter() = default;


void RenderWidgetHostNSViewHostAsyncWaiter::SyncIsWidgetForMainFrame(
    bool* out_is_for_main_frame) {
  base::RunLoop loop;
  proxy_->SyncIsWidgetForMainFrame(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_for_main_frame
,
             bool is_for_main_frame) {*out_is_for_main_frame = std::move(is_for_main_frame);
            loop->Quit();
          },
          &loop,
          out_is_for_main_frame));
  loop.Run();
}

bool RenderWidgetHostNSViewHostAsyncWaiter::SyncIsWidgetForMainFrame(
    ) {
  bool async_wait_result;
  SyncIsWidgetForMainFrame(&async_wait_result);
  return async_wait_result;
}

void RenderWidgetHostNSViewHostAsyncWaiter::SyncGetCharacterIndexAtPoint(
    const ::gfx::PointF& root_point, uint32_t* out_index) {
  base::RunLoop loop;
  proxy_->SyncGetCharacterIndexAtPoint(
      std::move(root_point),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_index
,
             uint32_t index) {*out_index = std::move(index);
            loop->Quit();
          },
          &loop,
          out_index));
  loop.Run();
}

uint32_t RenderWidgetHostNSViewHostAsyncWaiter::SyncGetCharacterIndexAtPoint(
    const ::gfx::PointF& root_point) {
  uint32_t async_wait_result;
  SyncGetCharacterIndexAtPoint(std::move(root_point),&async_wait_result);
  return async_wait_result;
}

void RenderWidgetHostNSViewHostAsyncWaiter::SyncGetFirstRectForRange(
    const ::gfx::Range& requested_range, ::gfx::Rect* out_out_rect, ::gfx::Range* out_out_actual_range, bool* out_success) {
  base::RunLoop loop;
  proxy_->SyncGetFirstRectForRange(
      std::move(requested_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::Rect* out_out_rect
,
             ::gfx::Range* out_out_actual_range
,
             bool* out_success
,
             const ::gfx::Rect& out_rect,
             const ::gfx::Range& out_actual_range,
             bool success) {*out_out_rect = std::move(out_rect);*out_out_actual_range = std::move(out_actual_range);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_out_rect,
          out_out_actual_range,
          out_success));
  loop.Run();
}



void RenderWidgetHostNSViewHostAsyncWaiter::SyncIsSpeaking(
    bool* out_is_speaking) {
  base::RunLoop loop;
  proxy_->SyncIsSpeaking(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_speaking
,
             bool is_speaking) {*out_is_speaking = std::move(is_speaking);
            loop->Quit();
          },
          &loop,
          out_is_speaking));
  loop.Run();
}

bool RenderWidgetHostNSViewHostAsyncWaiter::SyncIsSpeaking(
    ) {
  bool async_wait_result;
  SyncIsSpeaking(&async_wait_result);
  return async_wait_result;
}

void RenderWidgetHostNSViewHostAsyncWaiter::GetRenderWidgetAccessibilityToken(
    ::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token) {
  base::RunLoop loop;
  proxy_->GetRenderWidgetAccessibilityToken(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ProcessId* out_host_pid
,
             std::vector<uint8_t>* out_element_token
,
             ::base::ProcessId host_pid,
             const std::vector<uint8_t>& element_token) {*out_host_pid = std::move(host_pid);*out_element_token = std::move(element_token);
            loop->Quit();
          },
          &loop,
          out_host_pid,
          out_element_token));
  loop.Run();
}








}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif