// content/common/navigation_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/navigation_client.mojom-features.h"  // IWYU pragma: export
#include "content/common/navigation_client.mojom-shared.h"  // IWYU pragma: export
#include "content/common/navigation_client.mojom-forward.h"  // IWYU pragma: export
#include "content/common/frame_messages.mojom-forward.h"
#include "content/public/common/alternative_error_page_override_info.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-forward.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/same_document_navigation_type.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-forward.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/frame_owner_element_type_mojom_traits.h"
#include "content/common/input/input_injector_mojom_traits.h"
#include "content/common/input/synthetic_pinch_gesture_params.h"
#include "content/common/input/synthetic_pointer_action_list_params.h"
#include "content/common/input/synthetic_smooth_drag_gesture_params.h"
#include "content/common/input/synthetic_smooth_scroll_gesture_params.h"
#include "content/common/input/synthetic_tap_gesture_params.h"
#include "content/common/navigation_gesture.h"
#include "content/public/common/common_param_traits.h"
#include "net/base/network_change_notifier.h"
#include "third_party/blink/public/common/navigation/impression.h"
#include "third_party/blink/public/common/page_state/page_state.h"
#include "third_party/blink/public/common/widget/visual_properties.h"
#include "ui/base/page_transition_types.h"
#include "ui/events/types/scroll_types.h"
#include "ui/native_theme/native_theme.h"
#include "content/common/content_export.h"




namespace content::mojom {

class NavigationClientProxy;

template <typename ImplRefTraits>
class NavigationClientStub;

class NavigationClientRequestValidator;
class NavigationClientResponseValidator;


class CONTENT_EXPORT NavigationClient
    : public NavigationClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.NavigationClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NavigationClientInterfaceBase;
  using Proxy_ = NavigationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigationClientStub<ImplRefTraits>;

  using RequestValidator_ = NavigationClientRequestValidator;
  using ResponseValidator_ = NavigationClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitNavigationMinVersion = 0,
    kCommitFailedNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CommitNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CommitFailedNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NavigationClient() = default;

  using CommitNavigationCallback = base::OnceCallback<void(DidCommitProvisionalLoadParamsPtr, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;
  using CommitNavigationMojoCallback = base::OnceCallback<void(DidCommitProvisionalLoadParamsPtr, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;

  virtual void CommitNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> subresource_proxying_loader_factory, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> keep_alive_loader_factory, ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> fetch_later_loader_factory, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, const ::base::Uuid& base_auction_nonce, const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>& permissions_policy, ::blink::mojom::PolicyContainerPtr policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host_for_background, CookieManagerInfoPtr cookie_manager_info, StorageInfoPtr storage_info, CommitNavigationCallback callback) = 0;

  using CommitFailedNavigationCallback = base::OnceCallback<void(DidCommitProvisionalLoadParamsPtr, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;
  using CommitFailedNavigationMojoCallback = base::OnceCallback<void(DidCommitProvisionalLoadParamsPtr, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;

  virtual void CommitFailedNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, int32_t extended_error_code, const ::net::ResolveErrorInfo& resolve_error_info, const std::optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, ::blink::mojom::PolicyContainerPtr policy_container, ::content::mojom::AlternativeErrorPageOverrideInfoPtr alternative_error_page_info, CommitFailedNavigationCallback callback) = 0;
};



class CONTENT_EXPORT NavigationClientProxy
    : public NavigationClient {
 public:
  using InterfaceType = NavigationClient;

  explicit NavigationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> subresource_proxying_loader_factory, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> keep_alive_loader_factory, ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> fetch_later_loader_factory, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, const ::base::Uuid& base_auction_nonce, const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>& permissions_policy, ::blink::mojom::PolicyContainerPtr policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host_for_background, CookieManagerInfoPtr cookie_manager_info, StorageInfoPtr storage_info, CommitNavigationCallback callback) final;
  
  void CommitFailedNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, int32_t extended_error_code, const ::net::ResolveErrorInfo& resolve_error_info, const std::optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, ::blink::mojom::PolicyContainerPtr policy_container, ::content::mojom::AlternativeErrorPageOverrideInfoPtr alternative_error_page_info, CommitFailedNavigationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT NavigationClientStubDispatch {
 public:
  static bool Accept(NavigationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigationClient>>
class NavigationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigationClientStub() = default;
  ~NavigationClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT NavigationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT NavigationClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};













class CONTENT_EXPORT DidCommitProvisionalLoadParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidCommitProvisionalLoadParams, T>::value>;
  using DataView = DidCommitProvisionalLoadParamsDataView;
  using Data_ = internal::DidCommitProvisionalLoadParams_Data;

  template <typename... Args>
  static DidCommitProvisionalLoadParamsPtr New(Args&&... args) {
    return DidCommitProvisionalLoadParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidCommitProvisionalLoadParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidCommitProvisionalLoadParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidCommitProvisionalLoadParams>::Convert(*this);
  }


  DidCommitProvisionalLoadParams();

  DidCommitProvisionalLoadParams(
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      const std::string& navigation_api_key,
      const ::GURL& url,
      ::blink::mojom::ReferrerPtr referrer,
      ::ui::PageTransition transition,
      bool should_update_history,
      const std::string& contents_mime_type,
      bool did_create_new_entry,
      const std::string& method,
      int64_t post_id,
      int32_t http_status_code,
      bool url_is_unreachable,
      const std::optional<::blink::PageState>& previous_page_state,
      const ::blink::PageState& page_state,
      bool is_overriding_user_agent,
      bool history_list_was_cleared,
      const ::url::Origin& origin,
      const std::optional<::GURL>& initiator_base_url,
      std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy_header,
      const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& document_policy_header,
      ::blink::mojom::InsecureRequestPolicy insecure_request_policy,
      std::vector<uint32_t> insecure_navigations_set,
      bool has_potentially_trustworthy_unique_origin,
      int32_t request_id,
      const ::base::UnguessableToken& navigation_token,
      const std::optional<::base::UnguessableToken>& embedding_token,
      std::optional<::base::TimeTicks> unload_start,
      std::optional<::base::TimeTicks> unload_end,
      ::base::TimeTicks commit_navigation_start,
      std::optional<::base::TimeTicks> commit_navigation_end,
      ::base::TimeTicks commit_reply_sent);

DidCommitProvisionalLoadParams(const DidCommitProvisionalLoadParams&) = delete;
DidCommitProvisionalLoadParams& operator=(const DidCommitProvisionalLoadParams&) = delete;

  ~DidCommitProvisionalLoadParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidCommitProvisionalLoadParamsPtr>
  DidCommitProvisionalLoadParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidCommitProvisionalLoadParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidCommitProvisionalLoadParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidCommitProvisionalLoadParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidCommitProvisionalLoadParams_UnserializedMessageContext<
            UserType, DidCommitProvisionalLoadParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidCommitProvisionalLoadParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidCommitProvisionalLoadParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidCommitProvisionalLoadParams_UnserializedMessageContext<
            UserType, DidCommitProvisionalLoadParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidCommitProvisionalLoadParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t item_sequence_number;
  
  int64_t document_sequence_number;
  
  std::string navigation_api_key;
  
  ::GURL url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::ui::PageTransition transition;
  
  bool should_update_history;
  
  std::string contents_mime_type;
  
  bool did_create_new_entry;
  
  std::string method;
  
  int64_t post_id;
  
  int32_t http_status_code;
  
  bool url_is_unreachable;
  
  std::optional<::blink::PageState> previous_page_state;
  
  ::blink::PageState page_state;
  
  bool is_overriding_user_agent;
  
  bool history_list_was_cleared;
  
  ::url::Origin origin;
  
  std::optional<::GURL> initiator_base_url;
  
  std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy_header;
  
  base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue> document_policy_header;
  
  ::blink::mojom::InsecureRequestPolicy insecure_request_policy;
  
  std::vector<uint32_t> insecure_navigations_set;
  
  bool has_potentially_trustworthy_unique_origin;
  
  int32_t request_id;
  
  ::base::UnguessableToken navigation_token;
  
  std::optional<::base::UnguessableToken> embedding_token;
  
  std::optional<::base::TimeTicks> unload_start;
  
  std::optional<::base::TimeTicks> unload_end;
  
  ::base::TimeTicks commit_navigation_start;
  
  std::optional<::base::TimeTicks> commit_navigation_end;
  
  ::base::TimeTicks commit_reply_sent;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT DidCommitSameDocumentNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidCommitSameDocumentNavigationParams, T>::value>;
  using DataView = DidCommitSameDocumentNavigationParamsDataView;
  using Data_ = internal::DidCommitSameDocumentNavigationParams_Data;

  template <typename... Args>
  static DidCommitSameDocumentNavigationParamsPtr New(Args&&... args) {
    return DidCommitSameDocumentNavigationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidCommitSameDocumentNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidCommitSameDocumentNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidCommitSameDocumentNavigationParams>::Convert(*this);
  }


  DidCommitSameDocumentNavigationParams();

  DidCommitSameDocumentNavigationParams(
      ::blink::mojom::SameDocumentNavigationType same_document_navigation_type,
      bool is_client_redirect,
      bool started_with_transient_activation,
      bool should_replace_current_entry,
      const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>& navigation_entry_screenshot_destination);


  ~DidCommitSameDocumentNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidCommitSameDocumentNavigationParamsPtr>
  DidCommitSameDocumentNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidCommitSameDocumentNavigationParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidCommitSameDocumentNavigationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidCommitSameDocumentNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidCommitSameDocumentNavigationParams_UnserializedMessageContext<
            UserType, DidCommitSameDocumentNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidCommitSameDocumentNavigationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidCommitSameDocumentNavigationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidCommitSameDocumentNavigationParams_UnserializedMessageContext<
            UserType, DidCommitSameDocumentNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidCommitSameDocumentNavigationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::SameDocumentNavigationType same_document_navigation_type;
  
  bool is_client_redirect;
  
  bool started_with_transient_activation;
  
  bool should_replace_current_entry;
  
  std::optional<::blink::SameDocNavigationScreenshotDestinationToken> navigation_entry_screenshot_destination;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CookieManagerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieManagerInfo, T>::value>;
  using DataView = CookieManagerInfoDataView;
  using Data_ = internal::CookieManagerInfo_Data;

  template <typename... Args>
  static CookieManagerInfoPtr New(Args&&... args) {
    return CookieManagerInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieManagerInfoPtr From(const U& u) {
    return mojo::TypeConverter<CookieManagerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieManagerInfo>::Convert(*this);
  }


  CookieManagerInfo();

  CookieManagerInfo(
      const ::url::Origin& origin,
      ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager> cookie_manager);

CookieManagerInfo(const CookieManagerInfo&) = delete;
CookieManagerInfo& operator=(const CookieManagerInfo&) = delete;

  ~CookieManagerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieManagerInfoPtr>
  CookieManagerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieManagerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieManagerInfo_UnserializedMessageContext<
            UserType, CookieManagerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieManagerInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieManagerInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieManagerInfo_UnserializedMessageContext<
            UserType, CookieManagerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieManagerInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager> cookie_manager;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieManagerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT StorageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StorageInfo, T>::value>;
  using DataView = StorageInfoDataView;
  using Data_ = internal::StorageInfo_Data;

  template <typename... Args>
  static StorageInfoPtr New(Args&&... args) {
    return StorageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StorageInfoPtr From(const U& u) {
    return mojo::TypeConverter<StorageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StorageInfo>::Convert(*this);
  }


  StorageInfo();

  StorageInfo(
      ::mojo::PendingRemote<::blink::mojom::StorageArea> local_storage_area,
      ::mojo::PendingRemote<::blink::mojom::StorageArea> session_storage_area);

StorageInfo(const StorageInfo&) = delete;
StorageInfo& operator=(const StorageInfo&) = delete;

  ~StorageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StorageInfoPtr>
  StorageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StorageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StorageInfo_UnserializedMessageContext<
            UserType, StorageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StorageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StorageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StorageInfo_UnserializedMessageContext<
            UserType, StorageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StorageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::StorageArea> local_storage_area;
  
  ::mojo::PendingRemote<::blink::mojom::StorageArea> session_storage_area;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StorageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DidCommitProvisionalLoadParamsPtr DidCommitProvisionalLoadParams::Clone() const {
  return New(
      mojo::Clone(item_sequence_number),
      mojo::Clone(document_sequence_number),
      mojo::Clone(navigation_api_key),
      mojo::Clone(url),
      mojo::Clone(referrer),
      mojo::Clone(transition),
      mojo::Clone(should_update_history),
      mojo::Clone(contents_mime_type),
      mojo::Clone(did_create_new_entry),
      mojo::Clone(method),
      mojo::Clone(post_id),
      mojo::Clone(http_status_code),
      mojo::Clone(url_is_unreachable),
      mojo::Clone(previous_page_state),
      mojo::Clone(page_state),
      mojo::Clone(is_overriding_user_agent),
      mojo::Clone(history_list_was_cleared),
      mojo::Clone(origin),
      mojo::Clone(initiator_base_url),
      mojo::Clone(permissions_policy_header),
      mojo::Clone(document_policy_header),
      mojo::Clone(insecure_request_policy),
      mojo::Clone(insecure_navigations_set),
      mojo::Clone(has_potentially_trustworthy_unique_origin),
      mojo::Clone(request_id),
      mojo::Clone(navigation_token),
      mojo::Clone(embedding_token),
      mojo::Clone(unload_start),
      mojo::Clone(unload_end),
      mojo::Clone(commit_navigation_start),
      mojo::Clone(commit_navigation_end),
      mojo::Clone(commit_reply_sent)
  );
}

template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>*>
bool DidCommitProvisionalLoadParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->item_sequence_number, other_struct.item_sequence_number))
    return false;
  if (!mojo::Equals(this->document_sequence_number, other_struct.document_sequence_number))
    return false;
  if (!mojo::Equals(this->navigation_api_key, other_struct.navigation_api_key))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->transition, other_struct.transition))
    return false;
  if (!mojo::Equals(this->should_update_history, other_struct.should_update_history))
    return false;
  if (!mojo::Equals(this->contents_mime_type, other_struct.contents_mime_type))
    return false;
  if (!mojo::Equals(this->did_create_new_entry, other_struct.did_create_new_entry))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->post_id, other_struct.post_id))
    return false;
  if (!mojo::Equals(this->http_status_code, other_struct.http_status_code))
    return false;
  if (!mojo::Equals(this->url_is_unreachable, other_struct.url_is_unreachable))
    return false;
  if (!mojo::Equals(this->previous_page_state, other_struct.previous_page_state))
    return false;
  if (!mojo::Equals(this->page_state, other_struct.page_state))
    return false;
  if (!mojo::Equals(this->is_overriding_user_agent, other_struct.is_overriding_user_agent))
    return false;
  if (!mojo::Equals(this->history_list_was_cleared, other_struct.history_list_was_cleared))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->initiator_base_url, other_struct.initiator_base_url))
    return false;
  if (!mojo::Equals(this->permissions_policy_header, other_struct.permissions_policy_header))
    return false;
  if (!mojo::Equals(this->document_policy_header, other_struct.document_policy_header))
    return false;
  if (!mojo::Equals(this->insecure_request_policy, other_struct.insecure_request_policy))
    return false;
  if (!mojo::Equals(this->insecure_navigations_set, other_struct.insecure_navigations_set))
    return false;
  if (!mojo::Equals(this->has_potentially_trustworthy_unique_origin, other_struct.has_potentially_trustworthy_unique_origin))
    return false;
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->navigation_token, other_struct.navigation_token))
    return false;
  if (!mojo::Equals(this->embedding_token, other_struct.embedding_token))
    return false;
  if (!mojo::Equals(this->unload_start, other_struct.unload_start))
    return false;
  if (!mojo::Equals(this->unload_end, other_struct.unload_end))
    return false;
  if (!mojo::Equals(this->commit_navigation_start, other_struct.commit_navigation_start))
    return false;
  if (!mojo::Equals(this->commit_navigation_end, other_struct.commit_navigation_end))
    return false;
  if (!mojo::Equals(this->commit_reply_sent, other_struct.commit_reply_sent))
    return false;
  return true;
}

template <typename T, DidCommitProvisionalLoadParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.item_sequence_number < rhs.item_sequence_number)
    return true;
  if (rhs.item_sequence_number < lhs.item_sequence_number)
    return false;
  if (lhs.document_sequence_number < rhs.document_sequence_number)
    return true;
  if (rhs.document_sequence_number < lhs.document_sequence_number)
    return false;
  if (lhs.navigation_api_key < rhs.navigation_api_key)
    return true;
  if (rhs.navigation_api_key < lhs.navigation_api_key)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.transition < rhs.transition)
    return true;
  if (rhs.transition < lhs.transition)
    return false;
  if (lhs.should_update_history < rhs.should_update_history)
    return true;
  if (rhs.should_update_history < lhs.should_update_history)
    return false;
  if (lhs.contents_mime_type < rhs.contents_mime_type)
    return true;
  if (rhs.contents_mime_type < lhs.contents_mime_type)
    return false;
  if (lhs.did_create_new_entry < rhs.did_create_new_entry)
    return true;
  if (rhs.did_create_new_entry < lhs.did_create_new_entry)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.post_id < rhs.post_id)
    return true;
  if (rhs.post_id < lhs.post_id)
    return false;
  if (lhs.http_status_code < rhs.http_status_code)
    return true;
  if (rhs.http_status_code < lhs.http_status_code)
    return false;
  if (lhs.url_is_unreachable < rhs.url_is_unreachable)
    return true;
  if (rhs.url_is_unreachable < lhs.url_is_unreachable)
    return false;
  if (lhs.previous_page_state < rhs.previous_page_state)
    return true;
  if (rhs.previous_page_state < lhs.previous_page_state)
    return false;
  if (lhs.page_state < rhs.page_state)
    return true;
  if (rhs.page_state < lhs.page_state)
    return false;
  if (lhs.is_overriding_user_agent < rhs.is_overriding_user_agent)
    return true;
  if (rhs.is_overriding_user_agent < lhs.is_overriding_user_agent)
    return false;
  if (lhs.history_list_was_cleared < rhs.history_list_was_cleared)
    return true;
  if (rhs.history_list_was_cleared < lhs.history_list_was_cleared)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.initiator_base_url < rhs.initiator_base_url)
    return true;
  if (rhs.initiator_base_url < lhs.initiator_base_url)
    return false;
  if (lhs.permissions_policy_header < rhs.permissions_policy_header)
    return true;
  if (rhs.permissions_policy_header < lhs.permissions_policy_header)
    return false;
  if (lhs.document_policy_header < rhs.document_policy_header)
    return true;
  if (rhs.document_policy_header < lhs.document_policy_header)
    return false;
  if (lhs.insecure_request_policy < rhs.insecure_request_policy)
    return true;
  if (rhs.insecure_request_policy < lhs.insecure_request_policy)
    return false;
  if (lhs.insecure_navigations_set < rhs.insecure_navigations_set)
    return true;
  if (rhs.insecure_navigations_set < lhs.insecure_navigations_set)
    return false;
  if (lhs.has_potentially_trustworthy_unique_origin < rhs.has_potentially_trustworthy_unique_origin)
    return true;
  if (rhs.has_potentially_trustworthy_unique_origin < lhs.has_potentially_trustworthy_unique_origin)
    return false;
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.navigation_token < rhs.navigation_token)
    return true;
  if (rhs.navigation_token < lhs.navigation_token)
    return false;
  if (lhs.embedding_token < rhs.embedding_token)
    return true;
  if (rhs.embedding_token < lhs.embedding_token)
    return false;
  if (lhs.unload_start < rhs.unload_start)
    return true;
  if (rhs.unload_start < lhs.unload_start)
    return false;
  if (lhs.unload_end < rhs.unload_end)
    return true;
  if (rhs.unload_end < lhs.unload_end)
    return false;
  if (lhs.commit_navigation_start < rhs.commit_navigation_start)
    return true;
  if (rhs.commit_navigation_start < lhs.commit_navigation_start)
    return false;
  if (lhs.commit_navigation_end < rhs.commit_navigation_end)
    return true;
  if (rhs.commit_navigation_end < lhs.commit_navigation_end)
    return false;
  if (lhs.commit_reply_sent < rhs.commit_reply_sent)
    return true;
  if (rhs.commit_reply_sent < lhs.commit_reply_sent)
    return false;
  return false;
}
template <typename StructPtrType>
DidCommitSameDocumentNavigationParamsPtr DidCommitSameDocumentNavigationParams::Clone() const {
  return New(
      mojo::Clone(same_document_navigation_type),
      mojo::Clone(is_client_redirect),
      mojo::Clone(started_with_transient_activation),
      mojo::Clone(should_replace_current_entry),
      mojo::Clone(navigation_entry_screenshot_destination)
  );
}

template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>*>
bool DidCommitSameDocumentNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->same_document_navigation_type, other_struct.same_document_navigation_type))
    return false;
  if (!mojo::Equals(this->is_client_redirect, other_struct.is_client_redirect))
    return false;
  if (!mojo::Equals(this->started_with_transient_activation, other_struct.started_with_transient_activation))
    return false;
  if (!mojo::Equals(this->should_replace_current_entry, other_struct.should_replace_current_entry))
    return false;
  if (!mojo::Equals(this->navigation_entry_screenshot_destination, other_struct.navigation_entry_screenshot_destination))
    return false;
  return true;
}

template <typename T, DidCommitSameDocumentNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.same_document_navigation_type < rhs.same_document_navigation_type)
    return true;
  if (rhs.same_document_navigation_type < lhs.same_document_navigation_type)
    return false;
  if (lhs.is_client_redirect < rhs.is_client_redirect)
    return true;
  if (rhs.is_client_redirect < lhs.is_client_redirect)
    return false;
  if (lhs.started_with_transient_activation < rhs.started_with_transient_activation)
    return true;
  if (rhs.started_with_transient_activation < lhs.started_with_transient_activation)
    return false;
  if (lhs.should_replace_current_entry < rhs.should_replace_current_entry)
    return true;
  if (rhs.should_replace_current_entry < lhs.should_replace_current_entry)
    return false;
  if (lhs.navigation_entry_screenshot_destination < rhs.navigation_entry_screenshot_destination)
    return true;
  if (rhs.navigation_entry_screenshot_destination < lhs.navigation_entry_screenshot_destination)
    return false;
  return false;
}
template <typename StructPtrType>
CookieManagerInfoPtr CookieManagerInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(cookie_manager)
  );
}

template <typename T, CookieManagerInfo::EnableIfSame<T>*>
bool CookieManagerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->cookie_manager, other_struct.cookie_manager))
    return false;
  return true;
}

template <typename T, CookieManagerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.cookie_manager < rhs.cookie_manager)
    return true;
  if (rhs.cookie_manager < lhs.cookie_manager)
    return false;
  return false;
}
template <typename StructPtrType>
StorageInfoPtr StorageInfo::Clone() const {
  return New(
      mojo::Clone(local_storage_area),
      mojo::Clone(session_storage_area)
  );
}

template <typename T, StorageInfo::EnableIfSame<T>*>
bool StorageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_storage_area, other_struct.local_storage_area))
    return false;
  if (!mojo::Equals(this->session_storage_area, other_struct.session_storage_area))
    return false;
  return true;
}

template <typename T, StorageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.local_storage_area < rhs.local_storage_area)
    return true;
  if (rhs.local_storage_area < lhs.local_storage_area)
    return false;
  if (lhs.session_storage_area < rhs.session_storage_area)
    return true;
  if (rhs.session_storage_area < lhs.session_storage_area)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::DidCommitProvisionalLoadParams::DataView,
                                         ::content::mojom::DidCommitProvisionalLoadParamsPtr> {
  static bool IsNull(const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::DidCommitProvisionalLoadParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::item_sequence_number) item_sequence_number(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->item_sequence_number;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::document_sequence_number) document_sequence_number(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->document_sequence_number;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::navigation_api_key)& navigation_api_key(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->navigation_api_key;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::url)& url(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->url;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::referrer)& referrer(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->referrer;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::transition) transition(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->transition;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::should_update_history) should_update_history(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->should_update_history;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::contents_mime_type)& contents_mime_type(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->contents_mime_type;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::did_create_new_entry) did_create_new_entry(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->did_create_new_entry;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::method)& method(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->method;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::post_id) post_id(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->post_id;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::http_status_code) http_status_code(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->http_status_code;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::url_is_unreachable) url_is_unreachable(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->url_is_unreachable;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::previous_page_state)& previous_page_state(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->previous_page_state;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::page_state)& page_state(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->page_state;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::is_overriding_user_agent) is_overriding_user_agent(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->is_overriding_user_agent;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::history_list_was_cleared) history_list_was_cleared(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->history_list_was_cleared;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::origin)& origin(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->origin;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::initiator_base_url)& initiator_base_url(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->initiator_base_url;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::permissions_policy_header)& permissions_policy_header(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->permissions_policy_header;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::document_policy_header)& document_policy_header(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->document_policy_header;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::insecure_request_policy) insecure_request_policy(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->insecure_request_policy;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::insecure_navigations_set)& insecure_navigations_set(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->insecure_navigations_set;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::has_potentially_trustworthy_unique_origin) has_potentially_trustworthy_unique_origin(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->has_potentially_trustworthy_unique_origin;
  }

  static decltype(::content::mojom::DidCommitProvisionalLoadParams::request_id) request_id(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->request_id;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::navigation_token)& navigation_token(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->navigation_token;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::embedding_token)& embedding_token(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->embedding_token;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::unload_start)& unload_start(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->unload_start;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::unload_end)& unload_end(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->unload_end;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::commit_navigation_start)& commit_navigation_start(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->commit_navigation_start;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::commit_navigation_end)& commit_navigation_end(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->commit_navigation_end;
  }

  static const decltype(::content::mojom::DidCommitProvisionalLoadParams::commit_reply_sent)& commit_reply_sent(
      const ::content::mojom::DidCommitProvisionalLoadParamsPtr& input) {
    return input->commit_reply_sent;
  }

  static bool Read(::content::mojom::DidCommitProvisionalLoadParams::DataView input, ::content::mojom::DidCommitProvisionalLoadParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::DidCommitSameDocumentNavigationParams::DataView,
                                         ::content::mojom::DidCommitSameDocumentNavigationParamsPtr> {
  static bool IsNull(const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::DidCommitSameDocumentNavigationParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::DidCommitSameDocumentNavigationParams::same_document_navigation_type) same_document_navigation_type(
      const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) {
    return input->same_document_navigation_type;
  }

  static decltype(::content::mojom::DidCommitSameDocumentNavigationParams::is_client_redirect) is_client_redirect(
      const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) {
    return input->is_client_redirect;
  }

  static decltype(::content::mojom::DidCommitSameDocumentNavigationParams::started_with_transient_activation) started_with_transient_activation(
      const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) {
    return input->started_with_transient_activation;
  }

  static decltype(::content::mojom::DidCommitSameDocumentNavigationParams::should_replace_current_entry) should_replace_current_entry(
      const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) {
    return input->should_replace_current_entry;
  }

  static const decltype(::content::mojom::DidCommitSameDocumentNavigationParams::navigation_entry_screenshot_destination)& navigation_entry_screenshot_destination(
      const ::content::mojom::DidCommitSameDocumentNavigationParamsPtr& input) {
    return input->navigation_entry_screenshot_destination;
  }

  static bool Read(::content::mojom::DidCommitSameDocumentNavigationParams::DataView input, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CookieManagerInfo::DataView,
                                         ::content::mojom::CookieManagerInfoPtr> {
  static bool IsNull(const ::content::mojom::CookieManagerInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CookieManagerInfoPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CookieManagerInfo::origin)& origin(
      const ::content::mojom::CookieManagerInfoPtr& input) {
    return input->origin;
  }

  static  decltype(::content::mojom::CookieManagerInfo::cookie_manager)& cookie_manager(
       ::content::mojom::CookieManagerInfoPtr& input) {
    return input->cookie_manager;
  }

  static bool Read(::content::mojom::CookieManagerInfo::DataView input, ::content::mojom::CookieManagerInfoPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::StorageInfo::DataView,
                                         ::content::mojom::StorageInfoPtr> {
  static bool IsNull(const ::content::mojom::StorageInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::StorageInfoPtr* output) { output->reset(); }

  static  decltype(::content::mojom::StorageInfo::local_storage_area)& local_storage_area(
       ::content::mojom::StorageInfoPtr& input) {
    return input->local_storage_area;
  }

  static  decltype(::content::mojom::StorageInfo::session_storage_area)& session_storage_area(
       ::content::mojom::StorageInfoPtr& input) {
    return input->session_storage_area;
  }

  static bool Read(::content::mojom::StorageInfo::DataView input, ::content::mojom::StorageInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_