// content/common/navigation_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/navigation_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/navigation_client.mojom-params-data.h"
#include "content/common/navigation_client.mojom-shared-message-ids.h"

#include "content/common/navigation_client.mojom-import-headers.h"
#include "content/common/navigation_client.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/public/common/frame/view_transition_state_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_embedded_worker_status_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace content::mojom {
DidCommitProvisionalLoadParams::DidCommitProvisionalLoadParams()
    : item_sequence_number(-1),
      document_sequence_number(-1),
      navigation_api_key(),
      url(),
      referrer(),
      transition(),
      should_update_history(false),
      contents_mime_type(),
      did_create_new_entry(),
      method(),
      post_id(),
      http_status_code(),
      url_is_unreachable(),
      previous_page_state(),
      page_state(),
      is_overriding_user_agent(),
      history_list_was_cleared(),
      origin(),
      initiator_base_url(),
      permissions_policy_header(),
      document_policy_header(),
      insecure_request_policy(),
      insecure_navigations_set(),
      has_potentially_trustworthy_unique_origin(),
      request_id(),
      navigation_token(),
      embedding_token(),
      unload_start(),
      unload_end(),
      commit_navigation_start(),
      commit_navigation_end(),
      commit_reply_sent() {}

DidCommitProvisionalLoadParams::DidCommitProvisionalLoadParams(
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    const std::string& navigation_api_key_in,
    const ::GURL& url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::ui::PageTransition transition_in,
    bool should_update_history_in,
    const std::string& contents_mime_type_in,
    bool did_create_new_entry_in,
    const std::string& method_in,
    int64_t post_id_in,
    int32_t http_status_code_in,
    bool url_is_unreachable_in,
    const std::optional<::blink::PageState>& previous_page_state_in,
    const ::blink::PageState& page_state_in,
    bool is_overriding_user_agent_in,
    bool history_list_was_cleared_in,
    const ::url::Origin& origin_in,
    const std::optional<::GURL>& initiator_base_url_in,
    std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy_header_in,
    const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& document_policy_header_in,
    ::blink::mojom::InsecureRequestPolicy insecure_request_policy_in,
    std::vector<uint32_t> insecure_navigations_set_in,
    bool has_potentially_trustworthy_unique_origin_in,
    int32_t request_id_in,
    const ::base::UnguessableToken& navigation_token_in,
    const std::optional<::base::UnguessableToken>& embedding_token_in,
    std::optional<::base::TimeTicks> unload_start_in,
    std::optional<::base::TimeTicks> unload_end_in,
    ::base::TimeTicks commit_navigation_start_in,
    std::optional<::base::TimeTicks> commit_navigation_end_in,
    ::base::TimeTicks commit_reply_sent_in)
    : item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      navigation_api_key(std::move(navigation_api_key_in)),
      url(std::move(url_in)),
      referrer(std::move(referrer_in)),
      transition(std::move(transition_in)),
      should_update_history(std::move(should_update_history_in)),
      contents_mime_type(std::move(contents_mime_type_in)),
      did_create_new_entry(std::move(did_create_new_entry_in)),
      method(std::move(method_in)),
      post_id(std::move(post_id_in)),
      http_status_code(std::move(http_status_code_in)),
      url_is_unreachable(std::move(url_is_unreachable_in)),
      previous_page_state(std::move(previous_page_state_in)),
      page_state(std::move(page_state_in)),
      is_overriding_user_agent(std::move(is_overriding_user_agent_in)),
      history_list_was_cleared(std::move(history_list_was_cleared_in)),
      origin(std::move(origin_in)),
      initiator_base_url(std::move(initiator_base_url_in)),
      permissions_policy_header(std::move(permissions_policy_header_in)),
      document_policy_header(std::move(document_policy_header_in)),
      insecure_request_policy(std::move(insecure_request_policy_in)),
      insecure_navigations_set(std::move(insecure_navigations_set_in)),
      has_potentially_trustworthy_unique_origin(std::move(has_potentially_trustworthy_unique_origin_in)),
      request_id(std::move(request_id_in)),
      navigation_token(std::move(navigation_token_in)),
      embedding_token(std::move(embedding_token_in)),
      unload_start(std::move(unload_start_in)),
      unload_end(std::move(unload_end_in)),
      commit_navigation_start(std::move(commit_navigation_start_in)),
      commit_navigation_end(std::move(commit_navigation_end_in)),
      commit_reply_sent(std::move(commit_reply_sent_in)) {}

DidCommitProvisionalLoadParams::~DidCommitProvisionalLoadParams() = default;

void DidCommitProvisionalLoadParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_sequence_number"), this->item_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_sequence_number"), this->document_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_api_key"), this->navigation_api_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition"), this->transition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::PageTransition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_update_history"), this->should_update_history,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_mime_type"), this->contents_mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_create_new_entry"), this->did_create_new_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_id"), this->post_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_status_code"), this->http_status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_is_unreachable"), this->url_is_unreachable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_page_state"), this->previous_page_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::PageState>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_state"), this->page_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::PageState&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overriding_user_agent"), this->is_overriding_user_agent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history_list_was_cleared"), this->history_list_was_cleared,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_base_url"), this->initiator_base_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions_policy_header"), this->permissions_policy_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::network::ParsedPermissionsPolicyDeclaration>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_policy_header"), this->document_policy_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_request_policy"), this->insecure_request_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InsecureRequestPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_navigations_set"), this->insecure_navigations_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potentially_trustworthy_unique_origin"), this->has_potentially_trustworthy_unique_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_token"), this->navigation_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedding_token"), this->embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unload_start"), this->unload_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unload_end"), this->unload_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "commit_navigation_start"), this->commit_navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "commit_navigation_end"), this->commit_navigation_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "commit_reply_sent"), this->commit_reply_sent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidCommitProvisionalLoadParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidCommitSameDocumentNavigationParams::DidCommitSameDocumentNavigationParams()
    : same_document_navigation_type(),
      is_client_redirect(false),
      started_with_transient_activation(false),
      should_replace_current_entry(),
      navigation_entry_screenshot_destination() {}

DidCommitSameDocumentNavigationParams::DidCommitSameDocumentNavigationParams(
    ::blink::mojom::SameDocumentNavigationType same_document_navigation_type_in,
    bool is_client_redirect_in,
    bool started_with_transient_activation_in,
    bool should_replace_current_entry_in,
    const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>& navigation_entry_screenshot_destination_in)
    : same_document_navigation_type(std::move(same_document_navigation_type_in)),
      is_client_redirect(std::move(is_client_redirect_in)),
      started_with_transient_activation(std::move(started_with_transient_activation_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      navigation_entry_screenshot_destination(std::move(navigation_entry_screenshot_destination_in)) {}

DidCommitSameDocumentNavigationParams::~DidCommitSameDocumentNavigationParams() = default;

void DidCommitSameDocumentNavigationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_document_navigation_type"), this->same_document_navigation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::SameDocumentNavigationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_client_redirect"), this->is_client_redirect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "started_with_transient_activation"), this->started_with_transient_activation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_entry_screenshot_destination"), this->navigation_entry_screenshot_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidCommitSameDocumentNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieManagerInfo::CookieManagerInfo()
    : origin(),
      cookie_manager() {}

CookieManagerInfo::CookieManagerInfo(
    const ::url::Origin& origin_in,
    ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager> cookie_manager_in)
    : origin(std::move(origin_in)),
      cookie_manager(std::move(cookie_manager_in)) {}

CookieManagerInfo::~CookieManagerInfo() = default;

void CookieManagerInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_manager"), this->cookie_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieManagerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StorageInfo::StorageInfo()
    : local_storage_area(),
      session_storage_area() {}

StorageInfo::StorageInfo(
    ::mojo::PendingRemote<::blink::mojom::StorageArea> local_storage_area_in,
    ::mojo::PendingRemote<::blink::mojom::StorageArea> session_storage_area_in)
    : local_storage_area(std::move(local_storage_area_in)),
      session_storage_area(std::move(session_storage_area_in)) {}

StorageInfo::~StorageInfo() = default;

void StorageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_storage_area"), this->local_storage_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::StorageArea>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_area"), this->session_storage_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::StorageArea>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StorageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NavigationClient::IPCStableHashFunction NavigationClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NavigationClient>(message.name())) {
    case messages::NavigationClient::kCommitNavigation: {
      return &NavigationClient::CommitNavigation_Sym::IPCStableHash;
    }
    case messages::NavigationClient::kCommitFailedNavigation: {
      return &NavigationClient::CommitFailedNavigation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NavigationClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NavigationClient>(message.name())) {
      case messages::NavigationClient::kCommitNavigation:
            return "Receive content::mojom::NavigationClient::CommitNavigation";
      case messages::NavigationClient::kCommitFailedNavigation:
            return "Receive content::mojom::NavigationClient::CommitFailedNavigation";
    }
  } else {
    switch (static_cast<messages::NavigationClient>(message.name())) {
      case messages::NavigationClient::kCommitNavigation:
            return "Receive reply content::mojom::NavigationClient::CommitNavigation";
      case messages::NavigationClient::kCommitFailedNavigation:
            return "Receive reply content::mojom::NavigationClient::CommitFailedNavigation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NavigationClient::CommitNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43d9fa21;  // IPCStableHash for content::mojom::NavigationClient::CommitNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NavigationClient::CommitFailedNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f2e62f1;  // IPCStableHash for content::mojom::NavigationClient::CommitFailedNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NavigationClient_CommitNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitNavigation_ForwardToCallback(
      NavigationClient::CommitNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }

  NavigationClient_CommitNavigation_ForwardToCallback(const NavigationClient_CommitNavigation_ForwardToCallback&) = delete;
  NavigationClient_CommitNavigation_ForwardToCallback& operator=(const NavigationClient_CommitNavigation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitNavigationCallback callback_;
};

class NavigationClient_CommitFailedNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitFailedNavigation_ForwardToCallback(
      NavigationClient::CommitFailedNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }

  NavigationClient_CommitFailedNavigation_ForwardToCallback(const NavigationClient_CommitFailedNavigation_ForwardToCallback&) = delete;
  NavigationClient_CommitFailedNavigation_ForwardToCallback& operator=(const NavigationClient_CommitFailedNavigation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitFailedNavigationCallback callback_;
};

NavigationClientProxy::NavigationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigationClientProxy::CommitNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::CommitNavigationParamsPtr in_request_params, ::network::mojom::URLResponseHeadPtr in_response_head, ::mojo::ScopedDataPipeConsumerHandle in_response_body, ::network::mojom::URLLoaderClientEndpointsPtr in_url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> in_subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr in_container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_subresource_proxying_loader_factory, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_keep_alive_loader_factory, ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> in_fetch_later_loader_factory, const ::blink::DocumentToken& in_document_token, const ::base::UnguessableToken& in_devtools_navigation_token, const ::base::Uuid& in_base_auction_nonce, const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>& in_permissions_policy, ::blink::mojom::PolicyContainerPtr in_policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> in_code_cache_host, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> in_code_cache_host_for_background, CookieManagerInfoPtr in_cookie_manager_info, StorageInfoPtr in_storage_info, CommitNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::NavigationClient::CommitNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params,
                        "<value of type ::blink::mojom::CommitNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_body"), in_response_body,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_client_endpoints"), in_url_loader_client_endpoints,
                        "<value of type ::network::mojom::URLLoaderClientEndpointsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_overrides"), in_subresource_overrides,
                        "<value of type std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_service_worker_info"), in_controller_service_worker_info,
                        "<value of type ::blink::mojom::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_info"), in_container_info,
                        "<value of type ::blink::mojom::ServiceWorkerContainerInfoForClientPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_proxying_loader_factory"), in_subresource_proxying_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_alive_loader_factory"), in_keep_alive_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_later_loader_factory"), in_fetch_later_loader_factory,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_token"), in_document_token,
                        "<value of type const ::blink::DocumentToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_navigation_token"), in_devtools_navigation_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base_auction_nonce"), in_base_auction_nonce,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions_policy"), in_permissions_policy,
                        "<value of type const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container"), in_policy_container,
                        "<value of type ::blink::mojom::PolicyContainerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code_cache_host"), in_code_cache_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::CodeCacheHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code_cache_host_for_background"), in_code_cache_host_for_background,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::CodeCacheHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_manager_info"), in_cookie_manager_info,
                        "<value of type CookieManagerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_info"), in_storage_info,
                        "<value of type StorageInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = mojo::UrgentMessageScope::IsInUrgentScope();


  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NavigationClient::kCommitNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
    in_common_params,
    common_params_fragment);

  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->common_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null common_params in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommitNavigationParamsDataView>(
    in_request_params,
    request_params_fragment);

  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_params in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_response_head,
    response_head_fragment);

  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_head in NavigationClient.CommitNavigation request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_response_body,
    &params->response_body,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->url_loader_client_endpoints)::BaseType> url_loader_client_endpoints_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderClientEndpointsDataView>(
    in_url_loader_client_endpoints,
    url_loader_client_endpoints_fragment);

  params->url_loader_client_endpoints.Set(
      url_loader_client_endpoints_fragment.is_null() ? nullptr : url_loader_client_endpoints_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_overrides)::BaseType>
      subresource_overrides_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subresource_overrides_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>>(
    in_subresource_overrides,
    subresource_overrides_fragment,
    &subresource_overrides_validate_params);

  params->subresource_overrides.Set(
      subresource_overrides_fragment.is_null() ? nullptr : subresource_overrides_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->controller_service_worker_info)::BaseType> controller_service_worker_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
    in_controller_service_worker_info,
    controller_service_worker_info_fragment);

  params->controller_service_worker_info.Set(
      controller_service_worker_info_fragment.is_null() ? nullptr : controller_service_worker_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->container_info)::BaseType> container_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
    in_container_info,
    container_info_fragment);

  params->container_info.Set(
      container_info_fragment.is_null() ? nullptr : container_info_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_subresource_proxying_loader_factory,
    &params->subresource_proxying_loader_factory,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_keep_alive_loader_factory,
    &params->keep_alive_loader_factory,
    &params.message());

  
  mojo::internal::Serialize<::blink::mojom::FetchLaterLoaderFactoryAssociatedPtrInfoDataView>(
    in_fetch_later_loader_factory,
    &params->fetch_later_loader_factory,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->document_token)::BaseType> document_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
    in_document_token,
    document_token_fragment);

  params->document_token.Set(
      document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_token in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_navigation_token)::BaseType> devtools_navigation_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_navigation_token,
    devtools_navigation_token_fragment);

  params->devtools_navigation_token.Set(
      devtools_navigation_token_fragment.is_null() ? nullptr : devtools_navigation_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_navigation_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_navigation_token in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->base_auction_nonce)::BaseType> base_auction_nonce_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_base_auction_nonce,
    base_auction_nonce_fragment);

  params->base_auction_nonce.Set(
      base_auction_nonce_fragment.is_null() ? nullptr : base_auction_nonce_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->base_auction_nonce.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null base_auction_nonce in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions_policy)::BaseType>
      permissions_policy_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& permissions_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
    in_permissions_policy,
    permissions_policy_fragment,
    &permissions_policy_validate_params);

  params->permissions_policy.Set(
      permissions_policy_fragment.is_null() ? nullptr : permissions_policy_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container)::BaseType> policy_container_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
    in_policy_container,
    policy_container_fragment);

  params->policy_container.Set(
      policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_container.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_container in NavigationClient.CommitNavigation request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
    in_code_cache_host,
    &params->code_cache_host,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
    in_code_cache_host_for_background,
    &params->code_cache_host_for_background,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_manager_info)::BaseType> cookie_manager_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CookieManagerInfoDataView>(
    in_cookie_manager_info,
    cookie_manager_info_fragment);

  params->cookie_manager_info.Set(
      cookie_manager_info_fragment.is_null() ? nullptr : cookie_manager_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->storage_info)::BaseType> storage_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::StorageInfoDataView>(
    in_storage_info,
    storage_info_fragment);

  params->storage_info.Set(
      storage_info_fragment.is_null() ? nullptr : storage_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitNavigation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NavigationClientProxy::CommitFailedNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::CommitNavigationParamsPtr in_request_params, bool in_has_stale_copy_in_cache, int32_t in_error_code, int32_t in_extended_error_code, const ::net::ResolveErrorInfo& in_resolve_error_info, const std::optional<std::string>& in_error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, const ::blink::DocumentToken& in_document_token, const ::base::UnguessableToken& in_devtools_navigation_token, ::blink::mojom::PolicyContainerPtr in_policy_container, ::content::mojom::AlternativeErrorPageOverrideInfoPtr in_alternative_error_page_info, CommitFailedNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::NavigationClient::CommitFailedNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params,
                        "<value of type ::blink::mojom::CommitNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_stale_copy_in_cache"), in_has_stale_copy_in_cache,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extended_error_code"), in_extended_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolve_error_info"), in_resolve_error_info,
                        "<value of type const ::net::ResolveErrorInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_page_content"), in_error_page_content,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_token"), in_document_token,
                        "<value of type const ::blink::DocumentToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_navigation_token"), in_devtools_navigation_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container"), in_policy_container,
                        "<value of type ::blink::mojom::PolicyContainerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alternative_error_page_info"), in_alternative_error_page_info,
                        "<value of type ::content::mojom::AlternativeErrorPageOverrideInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = mojo::UrgentMessageScope::IsInUrgentScope();


  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NavigationClient::kCommitFailedNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitFailedNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
    in_common_params,
    common_params_fragment);

  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->common_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null common_params in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommitNavigationParamsDataView>(
    in_request_params,
    request_params_fragment);

  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_params in NavigationClient.CommitFailedNavigation request");

  params->has_stale_copy_in_cache = in_has_stale_copy_in_cache;

  params->error_code = in_error_code;

  params->extended_error_code = in_extended_error_code;
  mojo::internal::MessageFragment<
      typename decltype(params->resolve_error_info)::BaseType> resolve_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
    in_resolve_error_info,
    resolve_error_info_fragment);

  params->resolve_error_info.Set(
      resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resolve_error_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resolve_error_info in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_page_content)::BaseType> error_page_content_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_page_content,
    error_page_content_fragment);

  params->error_page_content.Set(
      error_page_content_fragment.is_null() ? nullptr : error_page_content_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->document_token)::BaseType> document_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
    in_document_token,
    document_token_fragment);

  params->document_token.Set(
      document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_token in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_navigation_token)::BaseType> devtools_navigation_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_navigation_token,
    devtools_navigation_token_fragment);

  params->devtools_navigation_token.Set(
      devtools_navigation_token_fragment.is_null() ? nullptr : devtools_navigation_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_navigation_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_navigation_token in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container)::BaseType> policy_container_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
    in_policy_container,
    policy_container_fragment);

  params->policy_container.Set(
      policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_container.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_container in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->alternative_error_page_info)::BaseType> alternative_error_page_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::AlternativeErrorPageOverrideInfoDataView>(
    in_alternative_error_page_info,
    alternative_error_page_info_fragment);

  params->alternative_error_page_info.Set(
      alternative_error_page_info_fragment.is_null() ? nullptr : alternative_error_page_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitFailedNavigation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NavigationClient_CommitNavigation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NavigationClient::CommitNavigationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NavigationClient_CommitNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitNavigation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NavigationClient_CommitNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NavigationClient_CommitNavigation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NavigationClient::CommitNavigationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);
};

bool NavigationClient_CommitNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NavigationClient.0
  bool success = true;
  DidCommitProvisionalLoadParamsPtr p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  }
  return true;
}

void NavigationClient_CommitNavigation_ProxyToResponder::Run(
    DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::NavigationClient::CommitNavigation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NavigationClient::kCommitNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
    in_interface_params,
    interface_params_fragment);

  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NavigationClient_CommitFailedNavigation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NavigationClient::CommitFailedNavigationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NavigationClient_CommitFailedNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitFailedNavigation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NavigationClient_CommitFailedNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitFailedNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NavigationClient_CommitFailedNavigation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NavigationClient::CommitFailedNavigationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);
};

bool NavigationClient_CommitFailedNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NavigationClient.1
  bool success = true;
  DidCommitProvisionalLoadParamsPtr p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitFailedNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  }
  return true;
}

void NavigationClient_CommitFailedNavigation_ProxyToResponder::Run(
    DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::NavigationClient::CommitFailedNavigation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NavigationClient::kCommitFailedNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
    in_interface_params,
    interface_params_fragment);

  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NavigationClientStubDispatch::Accept(
    NavigationClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NavigationClient>(message->header()->name)) {
    case messages::NavigationClient::kCommitNavigation: {
      break;
    }
    case messages::NavigationClient::kCommitFailedNavigation: {
      break;
    }
  }
  return false;
}

// static
bool NavigationClientStubDispatch::AcceptWithResponder(
    NavigationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NavigationClient>(message->header()->name)) {
    case messages::NavigationClient::kCommitNavigation: {
      internal::NavigationClient_CommitNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitNavigation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NavigationClient.0
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::CommitNavigationParamsPtr p_request_params{};
      ::network::mojom::URLResponseHeadPtr p_response_head{};
      ::mojo::ScopedDataPipeConsumerHandle p_response_body{};
      ::network::mojom::URLLoaderClientEndpointsPtr p_url_loader_client_endpoints{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> p_subresource_overrides{};
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_service_worker_info{};
      ::blink::mojom::ServiceWorkerContainerInfoForClientPtr p_container_info{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_subresource_proxying_loader_factory{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_keep_alive_loader_factory{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> p_fetch_later_loader_factory{};
      ::blink::DocumentToken p_document_token{};
      ::base::UnguessableToken p_devtools_navigation_token{};
      ::base::Uuid p_base_auction_nonce{};
      std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>> p_permissions_policy{};
      ::blink::mojom::PolicyContainerPtr p_policy_container{};
      ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> p_code_cache_host{};
      ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> p_code_cache_host_for_background{};
      CookieManagerInfoPtr p_cookie_manager_info{};
      StorageInfoPtr p_storage_info{};
      NavigationClient_CommitNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success && !input_data_view.ReadResponseHead(&p_response_head))
        success = false;
      if (success)
        p_response_body = input_data_view.TakeResponseBody();
      if (success && !input_data_view.ReadUrlLoaderClientEndpoints(&p_url_loader_client_endpoints))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadSubresourceOverrides(&p_subresource_overrides))
        success = false;
      if (success && !input_data_view.ReadControllerServiceWorkerInfo(&p_controller_service_worker_info))
        success = false;
      if (success && !input_data_view.ReadContainerInfo(&p_container_info))
        success = false;
      if (success) {
        p_subresource_proxying_loader_factory =
            input_data_view.TakeSubresourceProxyingLoaderFactory<decltype(p_subresource_proxying_loader_factory)>();
      }
      if (success) {
        p_keep_alive_loader_factory =
            input_data_view.TakeKeepAliveLoaderFactory<decltype(p_keep_alive_loader_factory)>();
      }
      if (success) {
        p_fetch_later_loader_factory =
            input_data_view.TakeFetchLaterLoaderFactory<decltype(p_fetch_later_loader_factory)>();
      }
      if (success && !input_data_view.ReadDocumentToken(&p_document_token))
        success = false;
      if (success && !input_data_view.ReadDevtoolsNavigationToken(&p_devtools_navigation_token))
        success = false;
      if (success && !input_data_view.ReadBaseAuctionNonce(&p_base_auction_nonce))
        success = false;
      if (success && !input_data_view.ReadPermissionsPolicy(&p_permissions_policy))
        success = false;
      if (success && !input_data_view.ReadPolicyContainer(&p_policy_container))
        success = false;
      if (success) {
        p_code_cache_host =
            input_data_view.TakeCodeCacheHost<decltype(p_code_cache_host)>();
      }
      if (success) {
        p_code_cache_host_for_background =
            input_data_view.TakeCodeCacheHostForBackground<decltype(p_code_cache_host_for_background)>();
      }
      if (success && !input_data_view.ReadCookieManagerInfo(&p_cookie_manager_info))
        success = false;
      if (success && !input_data_view.ReadStorageInfo(&p_storage_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 0, false);
        return false;
      }
      auto callback =
          NavigationClient_CommitNavigation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitNavigation(        
        std::move(p_common_params), 
        std::move(p_request_params), 
        std::move(p_response_head), 
        std::move(p_response_body), 
        std::move(p_url_loader_client_endpoints), 
        std::move(p_subresource_loader_factories), 
        std::move(p_subresource_overrides), 
        std::move(p_controller_service_worker_info), 
        std::move(p_container_info), 
        std::move(p_subresource_proxying_loader_factory), 
        std::move(p_keep_alive_loader_factory), 
        std::move(p_fetch_later_loader_factory), 
        std::move(p_document_token), 
        std::move(p_devtools_navigation_token), 
        std::move(p_base_auction_nonce), 
        std::move(p_permissions_policy), 
        std::move(p_policy_container), 
        std::move(p_code_cache_host), 
        std::move(p_code_cache_host_for_background), 
        std::move(p_cookie_manager_info), 
        std::move(p_storage_info), std::move(callback));
      return true;
    }
    case messages::NavigationClient::kCommitFailedNavigation: {
      internal::NavigationClient_CommitFailedNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitFailedNavigation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NavigationClient.1
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::CommitNavigationParamsPtr p_request_params{};
      bool p_has_stale_copy_in_cache{};
      int32_t p_error_code{};
      int32_t p_extended_error_code{};
      ::net::ResolveErrorInfo p_resolve_error_info{};
      std::optional<std::string> p_error_page_content{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::blink::DocumentToken p_document_token{};
      ::base::UnguessableToken p_devtools_navigation_token{};
      ::blink::mojom::PolicyContainerPtr p_policy_container{};
      ::content::mojom::AlternativeErrorPageOverrideInfoPtr p_alternative_error_page_info{};
      NavigationClient_CommitFailedNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success)
        p_has_stale_copy_in_cache = input_data_view.has_stale_copy_in_cache();
      if (success)
        p_error_code = input_data_view.error_code();
      if (success)
        p_extended_error_code = input_data_view.extended_error_code();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadErrorPageContent(&p_error_page_content))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadDocumentToken(&p_document_token))
        success = false;
      if (success && !input_data_view.ReadDevtoolsNavigationToken(&p_devtools_navigation_token))
        success = false;
      if (success && !input_data_view.ReadPolicyContainer(&p_policy_container))
        success = false;
      if (success && !input_data_view.ReadAlternativeErrorPageInfo(&p_alternative_error_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 1, false);
        return false;
      }
      auto callback =
          NavigationClient_CommitFailedNavigation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitFailedNavigation(        
        std::move(p_common_params), 
        std::move(p_request_params), 
        std::move(p_has_stale_copy_in_cache), 
        std::move(p_error_code), 
        std::move(p_extended_error_code), 
        std::move(p_resolve_error_info), 
        std::move(p_error_page_content), 
        std::move(p_subresource_loader_factories), 
        std::move(p_document_token), 
        std::move(p_devtools_navigation_token), 
        std::move(p_policy_container), 
        std::move(p_alternative_error_page_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNavigationClientValidationInfo[] = {
    { &internal::NavigationClient_CommitNavigation_Params_Data::Validate,
     &internal::NavigationClient_CommitNavigation_ResponseParams_Data::Validate},
    { &internal::NavigationClient_CommitFailedNavigation_Params_Data::Validate,
     &internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data::Validate},
};

bool NavigationClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::NavigationClient::Name_,
    kNavigationClientValidationInfo);
}

bool NavigationClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::content::mojom::NavigationClient::Name_,
    kNavigationClientValidationInfo);
}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::DidCommitProvisionalLoadParams::DataView, ::content::mojom::DidCommitProvisionalLoadParamsPtr>::Read(
    ::content::mojom::DidCommitProvisionalLoadParams::DataView input,
    ::content::mojom::DidCommitProvisionalLoadParamsPtr* output) {
  bool success = true;
  ::content::mojom::DidCommitProvisionalLoadParamsPtr result(::content::mojom::DidCommitProvisionalLoadParams::New());
  
      if (success)
        result->item_sequence_number = input.item_sequence_number();
      if (success)
        result->document_sequence_number = input.document_sequence_number();
      if (success && !input.ReadNavigationApiKey(&result->navigation_api_key))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadTransition(&result->transition))
        success = false;
      if (success)
        result->should_update_history = input.should_update_history();
      if (success && !input.ReadContentsMimeType(&result->contents_mime_type))
        success = false;
      if (success)
        result->did_create_new_entry = input.did_create_new_entry();
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success)
        result->post_id = input.post_id();
      if (success)
        result->http_status_code = input.http_status_code();
      if (success)
        result->url_is_unreachable = input.url_is_unreachable();
      if (success && !input.ReadPreviousPageState(&result->previous_page_state))
        success = false;
      if (success && !input.ReadPageState(&result->page_state))
        success = false;
      if (success)
        result->is_overriding_user_agent = input.is_overriding_user_agent();
      if (success)
        result->history_list_was_cleared = input.history_list_was_cleared();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadInitiatorBaseUrl(&result->initiator_base_url))
        success = false;
      if (success && !input.ReadPermissionsPolicyHeader(&result->permissions_policy_header))
        success = false;
      if (success && !input.ReadDocumentPolicyHeader(&result->document_policy_header))
        success = false;
      if (success && !input.ReadInsecureRequestPolicy(&result->insecure_request_policy))
        success = false;
      if (success && !input.ReadInsecureNavigationsSet(&result->insecure_navigations_set))
        success = false;
      if (success)
        result->has_potentially_trustworthy_unique_origin = input.has_potentially_trustworthy_unique_origin();
      if (success)
        result->request_id = input.request_id();
      if (success && !input.ReadNavigationToken(&result->navigation_token))
        success = false;
      if (success && !input.ReadEmbeddingToken(&result->embedding_token))
        success = false;
      if (success && !input.ReadUnloadStart(&result->unload_start))
        success = false;
      if (success && !input.ReadUnloadEnd(&result->unload_end))
        success = false;
      if (success && !input.ReadCommitNavigationStart(&result->commit_navigation_start))
        success = false;
      if (success && !input.ReadCommitNavigationEnd(&result->commit_navigation_end))
        success = false;
      if (success && !input.ReadCommitReplySent(&result->commit_reply_sent))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::DidCommitSameDocumentNavigationParams::DataView, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr>::Read(
    ::content::mojom::DidCommitSameDocumentNavigationParams::DataView input,
    ::content::mojom::DidCommitSameDocumentNavigationParamsPtr* output) {
  bool success = true;
  ::content::mojom::DidCommitSameDocumentNavigationParamsPtr result(::content::mojom::DidCommitSameDocumentNavigationParams::New());
  
      if (success && !input.ReadSameDocumentNavigationType(&result->same_document_navigation_type))
        success = false;
      if (success)
        result->is_client_redirect = input.is_client_redirect();
      if (success)
        result->started_with_transient_activation = input.started_with_transient_activation();
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success && !input.ReadNavigationEntryScreenshotDestination(&result->navigation_entry_screenshot_destination))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CookieManagerInfo::DataView, ::content::mojom::CookieManagerInfoPtr>::Read(
    ::content::mojom::CookieManagerInfo::DataView input,
    ::content::mojom::CookieManagerInfoPtr* output) {
  bool success = true;
  ::content::mojom::CookieManagerInfoPtr result(::content::mojom::CookieManagerInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success) {
        result->cookie_manager =
            input.TakeCookieManager<decltype(result->cookie_manager)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::StorageInfo::DataView, ::content::mojom::StorageInfoPtr>::Read(
    ::content::mojom::StorageInfo::DataView input,
    ::content::mojom::StorageInfoPtr* output) {
  bool success = true;
  ::content::mojom::StorageInfoPtr result(::content::mojom::StorageInfo::New());
  
      if (success) {
        result->local_storage_area =
            input.TakeLocalStorageArea<decltype(result->local_storage_area)>();
      }
      if (success) {
        result->session_storage_area =
            input.TakeSessionStorageArea<decltype(result->session_storage_area)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void NavigationClientInterceptorForTesting::CommitNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> subresource_proxying_loader_factory, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> keep_alive_loader_factory, ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> fetch_later_loader_factory, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, const ::base::Uuid& base_auction_nonce, const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>& permissions_policy, ::blink::mojom::PolicyContainerPtr policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host_for_background, CookieManagerInfoPtr cookie_manager_info, StorageInfoPtr storage_info, CommitNavigationCallback callback) {
  GetForwardingInterface()->CommitNavigation(
    std::move(common_params)
    , 
    std::move(request_params)
    , 
    std::move(response_head)
    , 
    std::move(response_body)
    , 
    std::move(url_loader_client_endpoints)
    , 
    std::move(subresource_loader_factories)
    , 
    std::move(subresource_overrides)
    , 
    std::move(controller_service_worker_info)
    , 
    std::move(container_info)
    , 
    std::move(subresource_proxying_loader_factory)
    , 
    std::move(keep_alive_loader_factory)
    , 
    std::move(fetch_later_loader_factory)
    , 
    std::move(document_token)
    , 
    std::move(devtools_navigation_token)
    , 
    std::move(base_auction_nonce)
    , 
    std::move(permissions_policy)
    , 
    std::move(policy_container)
    , 
    std::move(code_cache_host)
    , 
    std::move(code_cache_host_for_background)
    , 
    std::move(cookie_manager_info)
    , 
    std::move(storage_info)
    , std::move(callback));
}
void NavigationClientInterceptorForTesting::CommitFailedNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, int32_t extended_error_code, const ::net::ResolveErrorInfo& resolve_error_info, const std::optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, ::blink::mojom::PolicyContainerPtr policy_container, ::content::mojom::AlternativeErrorPageOverrideInfoPtr alternative_error_page_info, CommitFailedNavigationCallback callback) {
  GetForwardingInterface()->CommitFailedNavigation(
    std::move(common_params)
    , 
    std::move(request_params)
    , 
    std::move(has_stale_copy_in_cache)
    , 
    std::move(error_code)
    , 
    std::move(extended_error_code)
    , 
    std::move(resolve_error_info)
    , 
    std::move(error_page_content)
    , 
    std::move(subresource_loader_factories)
    , 
    std::move(document_token)
    , 
    std::move(devtools_navigation_token)
    , 
    std::move(policy_container)
    , 
    std::move(alternative_error_page_info)
    , std::move(callback));
}
NavigationClientAsyncWaiter::NavigationClientAsyncWaiter(
    NavigationClient* proxy) : proxy_(proxy) {}

NavigationClientAsyncWaiter::~NavigationClientAsyncWaiter() = default;


void NavigationClientAsyncWaiter::CommitNavigation(
    ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, std::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> subresource_proxying_loader_factory, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> keep_alive_loader_factory, ::mojo::PendingAssociatedRemote<::blink::mojom::FetchLaterLoaderFactory> fetch_later_loader_factory, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, const ::base::Uuid& base_auction_nonce, const std::optional<std::vector<::network::ParsedPermissionsPolicyDeclaration>>& permissions_policy, ::blink::mojom::PolicyContainerPtr policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host_for_background, CookieManagerInfoPtr cookie_manager_info, StorageInfoPtr storage_info, DidCommitProvisionalLoadParamsPtr* out_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* out_interface_params) {
  base::RunLoop loop;
  proxy_->CommitNavigation(
      std::move(common_params),
      std::move(request_params),
      std::move(response_head),
      std::move(response_body),
      std::move(url_loader_client_endpoints),
      std::move(subresource_loader_factories),
      std::move(subresource_overrides),
      std::move(controller_service_worker_info),
      std::move(container_info),
      std::move(subresource_proxying_loader_factory),
      std::move(keep_alive_loader_factory),
      std::move(fetch_later_loader_factory),
      std::move(document_token),
      std::move(devtools_navigation_token),
      std::move(base_auction_nonce),
      std::move(permissions_policy),
      std::move(policy_container),
      std::move(code_cache_host),
      std::move(code_cache_host_for_background),
      std::move(cookie_manager_info),
      std::move(storage_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             DidCommitProvisionalLoadParamsPtr* out_params
,
             ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* out_interface_params
,
             DidCommitProvisionalLoadParamsPtr params,
             ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) {*out_params = std::move(params);*out_interface_params = std::move(interface_params);
            loop->Quit();
          },
          &loop,
          out_params,
          out_interface_params));
  loop.Run();
}



void NavigationClientAsyncWaiter::CommitFailedNavigation(
    ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, int32_t extended_error_code, const ::net::ResolveErrorInfo& resolve_error_info, const std::optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, const ::blink::DocumentToken& document_token, const ::base::UnguessableToken& devtools_navigation_token, ::blink::mojom::PolicyContainerPtr policy_container, ::content::mojom::AlternativeErrorPageOverrideInfoPtr alternative_error_page_info, DidCommitProvisionalLoadParamsPtr* out_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* out_interface_params) {
  base::RunLoop loop;
  proxy_->CommitFailedNavigation(
      std::move(common_params),
      std::move(request_params),
      std::move(has_stale_copy_in_cache),
      std::move(error_code),
      std::move(extended_error_code),
      std::move(resolve_error_info),
      std::move(error_page_content),
      std::move(subresource_loader_factories),
      std::move(document_token),
      std::move(devtools_navigation_token),
      std::move(policy_container),
      std::move(alternative_error_page_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             DidCommitProvisionalLoadParamsPtr* out_params
,
             ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* out_interface_params
,
             DidCommitProvisionalLoadParamsPtr params,
             ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) {*out_params = std::move(params);*out_interface_params = std::move(interface_params);
            loop->Quit();
          },
          &loop,
          out_params,
          out_interface_params));
  loop.Run();
}








}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif