// content/common/navigation_client.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/common/navigation_client.mojom-shared-internal.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/public/common/alternative_error_page_override_info.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/same_document_navigation_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace content::mojom {
using PageStateDataView = mojo::native::NativeStructDataView;

class DidCommitProvisionalLoadParamsDataView;

class DidCommitSameDocumentNavigationParamsDataView;

class CookieManagerInfoDataView;

class StorageInfoDataView;



}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::DidCommitProvisionalLoadParamsDataView> {
  using Data = ::content::mojom::internal::DidCommitProvisionalLoadParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::DidCommitSameDocumentNavigationParamsDataView> {
  using Data = ::content::mojom::internal::DidCommitSameDocumentNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CookieManagerInfoDataView> {
  using Data = ::content::mojom::internal::CookieManagerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::StorageInfoDataView> {
  using Data = ::content::mojom::internal::StorageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {
using NavigationGesture = mojo::NativeEnum;
using PageTransition = mojo::NativeEnum;


enum class NavigationClientDisconnectReason : int32_t {
  
  kNoExplicitReason = 0,
  
  kResetForSwap = 1,
  
  kResetForAbort = 2,
  
  kResetForNewNavigation = 3,
  
  kResetForDuplicateNavigation = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationClientDisconnectReason value);
inline bool IsKnownEnumValue(NavigationClientDisconnectReason value) {
  return internal::NavigationClientDisconnectReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class NavigationClientInterfaceBase {};

using NavigationClientPtrDataView =
    mojo::InterfacePtrDataView<NavigationClientInterfaceBase>;
using NavigationClientRequestDataView =
    mojo::InterfaceRequestDataView<NavigationClientInterfaceBase>;
using NavigationClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigationClientInterfaceBase>;
using NavigationClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigationClientInterfaceBase>;


class DidCommitProvisionalLoadParamsDataView {
 public:
  DidCommitProvisionalLoadParamsDataView() = default;

  DidCommitProvisionalLoadParamsDataView(
      internal::DidCommitProvisionalLoadParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t item_sequence_number() const {
    return data_->item_sequence_number;
  }
  int64_t document_sequence_number() const {
    return data_->document_sequence_number;
  }
  inline void GetNavigationApiKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiKey(UserType* output) {
    
    auto* pointer = data_->navigation_api_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTransition(UserType* output) const {
    auto data_value = data_->transition;
    return mojo::internal::Deserialize<::content::mojom::PageTransition>(
        data_value, output);
  }
  PageTransition transition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::PageTransition>(data_->transition));
  }
  bool should_update_history() const {
    return data_->should_update_history;
  }
  inline void GetContentsMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentsMimeType(UserType* output) {
    
    auto* pointer = data_->contents_mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool did_create_new_entry() const {
    return data_->did_create_new_entry;
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t post_id() const {
    return data_->post_id;
  }
  int32_t http_status_code() const {
    return data_->http_status_code;
  }
  bool url_is_unreachable() const {
    return data_->url_is_unreachable;
  }
  inline void GetPreviousPageStateDataView(
      PageStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousPageState(UserType* output) {
    
    auto* pointer = data_->previous_page_state.Get();
    return mojo::internal::Deserialize<::content::mojom::PageStateDataView>(
        pointer, output, message_);
  }
  inline void GetPageStateDataView(
      PageStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::content::mojom::PageStateDataView>(
        pointer, output, message_);
  }
  bool is_overriding_user_agent() const {
    return data_->is_overriding_user_agent;
  }
  bool history_list_was_cleared() const {
    return data_->history_list_was_cleared;
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `initiator_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrl` instead "
    "of `ReadInitiatorBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsPolicyHeaderDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicyHeader(UserType* output) {
    
    auto* pointer = data_->permissions_policy_header.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetDocumentPolicyHeaderDataView(
      mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentPolicyHeader(UserType* output) {
    
    auto* pointer = data_->document_policy_header.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInsecureRequestPolicy(UserType* output) const {
    auto data_value = data_->insecure_request_policy;
    return mojo::internal::Deserialize<::blink::mojom::InsecureRequestPolicy>(
        data_value, output);
  }
  ::blink::mojom::InsecureRequestPolicy insecure_request_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InsecureRequestPolicy>(data_->insecure_request_policy));
  }
  inline void GetInsecureNavigationsSetDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInsecureNavigationsSet(UserType* output) {
    
    auto* pointer = data_->insecure_navigations_set.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  bool has_potentially_trustworthy_unique_origin() const {
    return data_->has_potentially_trustworthy_unique_origin;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationToken(UserType* output) {
    
    auto* pointer = data_->navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetEmbeddingTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddingToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `embedding_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmbeddingToken` instead "
    "of `ReadEmbeddingToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->embedding_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetUnloadStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnloadStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `unload_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnloadStart` instead "
    "of `ReadUnloadStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unload_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetUnloadEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnloadEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `unload_end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnloadEnd` instead "
    "of `ReadUnloadEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unload_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetCommitNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitNavigationStart(UserType* output) {
    
    auto* pointer = data_->commit_navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetCommitNavigationEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitNavigationEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `commit_navigation_end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCommitNavigationEnd` instead "
    "of `ReadCommitNavigationEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->commit_navigation_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetCommitReplySentDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitReplySent(UserType* output) {
    
    auto* pointer = data_->commit_reply_sent.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::DidCommitProvisionalLoadParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidCommitSameDocumentNavigationParamsDataView {
 public:
  DidCommitSameDocumentNavigationParamsDataView() = default;

  DidCommitSameDocumentNavigationParamsDataView(
      internal::DidCommitSameDocumentNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSameDocumentNavigationType(UserType* output) const {
    auto data_value = data_->same_document_navigation_type;
    return mojo::internal::Deserialize<::blink::mojom::SameDocumentNavigationType>(
        data_value, output);
  }
  ::blink::mojom::SameDocumentNavigationType same_document_navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SameDocumentNavigationType>(data_->same_document_navigation_type));
  }
  bool is_client_redirect() const {
    return data_->is_client_redirect;
  }
  bool started_with_transient_activation() const {
    return data_->started_with_transient_activation;
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  inline void GetNavigationEntryScreenshotDestinationDataView(
      ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationEntryScreenshotDestination(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView, UserType>(),
    "Attempting to read the optional `navigation_entry_screenshot_destination` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationEntryScreenshotDestination` instead "
    "of `ReadNavigationEntryScreenshotDestination if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->navigation_entry_screenshot_destination.Get();
    return mojo::internal::Deserialize<::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::DidCommitSameDocumentNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManagerInfoDataView {
 public:
  CookieManagerInfoDataView() = default;

  CookieManagerInfoDataView(
      internal::CookieManagerInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::RestrictedCookieManagerInterfaceBase>>(
            &data_->cookie_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CookieManagerInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StorageInfoDataView {
 public:
  StorageInfoDataView() = default;

  StorageInfoDataView(
      internal::StorageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeLocalStorageArea() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaInterfaceBase>>(
            &data_->local_storage_area, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSessionStorageArea() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaInterfaceBase>>(
            &data_->session_storage_area, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StorageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content::mojom

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_DATA_VIEW_H_