// content/common/frame_messages.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MESSAGES_MOJOM_H_
#define CONTENT_COMMON_FRAME_MESSAGES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/frame_messages.mojom-features.h"  // IWYU pragma: export
#include "content/common/frame_messages.mojom-shared.h"  // IWYU pragma: export
#include "content/common/frame_messages.mojom-forward.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/interface_provider.mojom-forward.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {








class CONTENT_EXPORT DidCommitProvisionalLoadInterfaceParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidCommitProvisionalLoadInterfaceParams, T>::value>;
  using DataView = DidCommitProvisionalLoadInterfaceParamsDataView;
  using Data_ = internal::DidCommitProvisionalLoadInterfaceParams_Data;

  template <typename... Args>
  static DidCommitProvisionalLoadInterfaceParamsPtr New(Args&&... args) {
    return DidCommitProvisionalLoadInterfaceParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidCommitProvisionalLoadInterfaceParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidCommitProvisionalLoadInterfaceParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidCommitProvisionalLoadInterfaceParams>::Convert(*this);
  }


  DidCommitProvisionalLoadInterfaceParams();

  explicit DidCommitProvisionalLoadInterfaceParams(
      ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker_receiver);

DidCommitProvisionalLoadInterfaceParams(const DidCommitProvisionalLoadInterfaceParams&) = delete;
DidCommitProvisionalLoadInterfaceParams& operator=(const DidCommitProvisionalLoadInterfaceParams&) = delete;

  ~DidCommitProvisionalLoadInterfaceParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidCommitProvisionalLoadInterfaceParamsPtr>
  DidCommitProvisionalLoadInterfaceParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidCommitProvisionalLoadInterfaceParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidCommitProvisionalLoadInterfaceParams_UnserializedMessageContext<
            UserType, DidCommitProvisionalLoadInterfaceParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidCommitProvisionalLoadInterfaceParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidCommitProvisionalLoadInterfaceParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidCommitProvisionalLoadInterfaceParams_UnserializedMessageContext<
            UserType, DidCommitProvisionalLoadInterfaceParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidCommitProvisionalLoadInterfaceParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DidCommitProvisionalLoadInterfaceParamsPtr DidCommitProvisionalLoadInterfaceParams::Clone() const {
  return New(
      mojo::Clone(browser_interface_broker_receiver)
  );
}

template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>*>
bool DidCommitProvisionalLoadInterfaceParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->browser_interface_broker_receiver, other_struct.browser_interface_broker_receiver))
    return false;
  return true;
}

template <typename T, DidCommitProvisionalLoadInterfaceParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.browser_interface_broker_receiver < rhs.browser_interface_broker_receiver)
    return true;
  if (rhs.browser_interface_broker_receiver < lhs.browser_interface_broker_receiver)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::DidCommitProvisionalLoadInterfaceParams::DataView,
                                         ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr> {
  static bool IsNull(const ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* output) { output->reset(); }

  static  decltype(::content::mojom::DidCommitProvisionalLoadInterfaceParams::browser_interface_broker_receiver)& browser_interface_broker_receiver(
       ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr& input) {
    return input->browser_interface_broker_receiver;
  }

  static bool Read(::content::mojom::DidCommitProvisionalLoadInterfaceParams::DataView input, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_FRAME_MESSAGES_MOJOM_H_