/* Copyright 2025 The Chromium Authors
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file. */
import{assert}from"//resources/js/assert.js";export function getTokenAsUuidString(uuid){const highHex=uuid.high.toString(16).padStart(16,"0");const lowHex=uuid.low.toString(16).padStart(16,"0");return`${lowHex.slice(0,8)}-${lowHex.slice(8,12)}-${lowHex.slice(12,16)}-${highHex.slice(0,4)}-${highHex.slice(4)}`}function getArrayFromBigBuffer(bigBuffer){if(Array.isArray(bigBuffer.bytes)){return new Uint8Array(bigBuffer.bytes)}assert(!!bigBuffer.sharedMemory,"sharedMemory must be defined here");const sharedMemory=bigBuffer.sharedMemory;const{buffer:buffer,result:result}=sharedMemory.bufferHandle.mapBuffer(0,sharedMemory.size);assert(result===Mojo.RESULT_OK,"Could not map buffer");return new Uint8Array(buffer)}function downloadUrl(fileName,url){const a=document.createElement("a");a.href=url;a.download=fileName;a.click()}export function downloadTraceData(data,uuid){const bytes=getArrayFromBigBuffer(data);const blob=new Blob([bytes],{type:"application/octet-stream"});downloadUrl(`${getTokenAsUuidString(uuid)}.gz`,URL.createObjectURL(blob))}