// content/browser/process_internals/process_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class ProcessInternalsHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mojom.ProcessInternalsHandler', scope);
    }
}
export class ProcessInternalsHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ProcessInternalsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getProcessCountInfo() {
        return this.proxy.sendMessage(0, ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$, ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$, [], false);
    }
    getIsolationMode() {
        return this.proxy.sendMessage(1, ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$, ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$, [], false);
    }
    getProcessPerSiteMode() {
        return this.proxy.sendMessage(2, ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$, ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$, [], false);
    }
    getUserTriggeredIsolatedOrigins() {
        return this.proxy.sendMessage(3, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$, [], false);
    }
    getWebTriggeredIsolatedOrigins() {
        return this.proxy.sendMessage(4, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$, [], false);
    }
    getGloballyIsolatedOrigins() {
        return this.proxy.sendMessage(5, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$, [], false);
    }
    getAllWebContentsInfo() {
        return this.proxy.sendMessage(6, ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$, ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the ProcessInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProcessInternalsHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ProcessInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$, ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$, impl.getProcessCountInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$, ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$, impl.getIsolationMode.bind(impl), false);
        this.helper_internal_.registerHandler(2, ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$, ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$, impl.getProcessPerSiteMode.bind(impl), false);
        this.helper_internal_.registerHandler(3, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$, impl.getUserTriggeredIsolatedOrigins.bind(impl), false);
        this.helper_internal_.registerHandler(4, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$, impl.getWebTriggeredIsolatedOrigins.bind(impl), false);
        this.helper_internal_.registerHandler(5, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$, impl.getGloballyIsolatedOrigins.bind(impl), false);
        this.helper_internal_.registerHandler(6, ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$, ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$, impl.getAllWebContentsInfo.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ProcessInternalsHandler {
    static get $interfaceName() {
        return "mojom.ProcessInternalsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ProcessInternalsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ProcessInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProcessInternalsHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getProcessCountInfo;
    getIsolationMode;
    getProcessPerSiteMode;
    getUserTriggeredIsolatedOrigins;
    getWebTriggeredIsolatedOrigins;
    getGloballyIsolatedOrigins;
    getAllWebContentsInfo;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ProcessInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getProcessCountInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$, ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$, this.getProcessCountInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getIsolationMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$, ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$, this.getIsolationMode.createReceiverHandler(true /* expectsResponse */), false);
        this.getProcessPerSiteMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$, ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$, this.getProcessPerSiteMode.createReceiverHandler(true /* expectsResponse */), false);
        this.getUserTriggeredIsolatedOrigins =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$, this.getUserTriggeredIsolatedOrigins.createReceiverHandler(true /* expectsResponse */), false);
        this.getWebTriggeredIsolatedOrigins =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$, this.getWebTriggeredIsolatedOrigins.createReceiverHandler(true /* expectsResponse */), false);
        this.getGloballyIsolatedOrigins =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$, ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$, this.getGloballyIsolatedOrigins.createReceiverHandler(true /* expectsResponse */), false);
        this.getAllWebContentsInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$, ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$, this.getAllWebContentsInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ProcessCountInfoSpec = { $: {} };
export const SiteInstanceInfoSpec = { $: {} };
export const FrameInfoSpec = { $: {} };
export const WebContentsInfoSpec = { $: {} };
export const IsolatedOriginInfoSpec = { $: {} };
export const ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetIsolationMode_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec = { $: {} };
export const ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(ProcessCountInfoSpec.$, 'ProcessCountInfo', [
    mojo.internal.StructField('rendererProcessLimit', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rendererProcessCountTotal', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('liveRendererProcessesCountTotal', 16, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rendererProcessCountForLimit', 24, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(SiteInstanceInfoSpec.$, 'SiteInstanceInfo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('siteInstanceGroupId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browsingInstanceId', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locked', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('siteUrl', 16, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('processLockUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('requiresOriginKeyedProcess', 12, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSandboxForIframes', 12, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isGuest', 12, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPdf', 12, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('areJavascriptOptimizersEnabled', 12, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('storagePartition', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
export const FrameInfo_TypeSpec = { $: mojo.internal.Enum() };
export var FrameInfo_Type;
(function (FrameInfo_Type) {
    FrameInfo_Type[FrameInfo_Type["MIN_VALUE"] = 0] = "MIN_VALUE";
    FrameInfo_Type[FrameInfo_Type["MAX_VALUE"] = 2] = "MAX_VALUE";
    FrameInfo_Type[FrameInfo_Type["kActive"] = 0] = "kActive";
    FrameInfo_Type[FrameInfo_Type["kBackForwardCache"] = 1] = "kBackForwardCache";
    FrameInfo_Type[FrameInfo_Type["kPrerender"] = 2] = "kPrerender";
})(FrameInfo_Type || (FrameInfo_Type = {}));
mojo.internal.Struct(FrameInfoSpec.$, 'FrameInfo', [
    mojo.internal.StructField('routingId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('agentSchedulingGroupId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('processId', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('siteInstance', 16, 0, SiteInstanceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastCommittedUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('subframes', 32, 0, mojo.internal.Array(FrameInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 12, 0, FrameInfo_TypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(WebContentsInfoSpec.$, 'WebContentsInfo', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rootFrame', 8, 0, FrameInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bfcachedRootFrames', 16, 0, mojo.internal.Array(FrameInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('prerenderRootFrames', 24, 0, mojo.internal.Array(FrameInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(IsolatedOriginInfoSpec.$, 'IsolatedOriginInfo', [
    mojo.internal.StructField('origin', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('source', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$, 'ProcessInternalsHandler_GetProcessCountInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetProcessCountInfo_ResponseParams', [
    mojo.internal.StructField('info', 0, 0, ProcessCountInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$, 'ProcessInternalsHandler_GetIsolationMode_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetIsolationMode_ResponseParams', [
    mojo.internal.StructField('mode', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$, 'ProcessInternalsHandler_GetProcessPerSiteMode_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams', [
    mojo.internal.StructField('mode', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$, 'ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams', [
    mojo.internal.StructField('isolatedOrigins', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$, 'ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams', [
    mojo.internal.StructField('isolatedOrigins', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$, 'ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams', [
    mojo.internal.StructField('isolatedOrigins', 0, 0, mojo.internal.Array(IsolatedOriginInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$, 'ProcessInternalsHandler_GetAllWebContentsInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$, 'ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams', [
    mojo.internal.StructField('infos', 0, 0, mojo.internal.Array(WebContentsInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
