// content/browser/indexed_db/indexed_db_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BucketClientInfoSpec as storage_mojom_BucketClientInfoSpec,
  BucketClientInfo as storage_mojom_BucketClientInfo
} from './bucket_client_info.mojom-webui.js';
import {
  BucketIdSpec as storage_mojom_BucketIdSpec,
  BucketId as storage_mojom_BucketId
} from './bucket_id.mojom-webui.js';
import {
  IdbBucketMetadataSpec as storage_mojom_IdbBucketMetadataSpec,
  IdbBucketMetadata as storage_mojom_IdbBucketMetadata,
  IdbOriginMetadataSpec as storage_mojom_IdbOriginMetadataSpec,
  IdbOriginMetadata as storage_mojom_IdbOriginMetadata
} from './indexed_db_internals_types.mojom-webui.js';
import {
  FilePathSpec as mojoBase_mojom_FilePathSpec,
  FilePath as mojoBase_mojom_FilePath
} from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';







export type IdbInternalsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<IdbInternalsHandlerPendingReceiver>;

export class IdbInternalsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<IdbInternalsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<IdbInternalsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|IdbInternalsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'storage.mojom.IdbInternalsHandler',
        scope);
  }
}

export interface IdbInternalsHandlerInterface {
  getAllBucketsAcrossAllStorageKeys(): Promise<{
        error: (string | null),
        partitions: IdbPartitionMetadata[], }>;
  downloadBucketData(bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }>;
  forceClose(bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }>;
  startMetadataRecording(bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }>;
  stopMetadataRecording(bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null),
        metadata: storage_mojom_IdbBucketMetadata[], }>;
  inspectClient(clientInfo: storage_mojom_BucketClientInfo): Promise<{
        error: (string | null), }>;
}

export class IdbInternalsHandlerRemote implements IdbInternalsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<IdbInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<IdbInternalsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|IdbInternalsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IdbInternalsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getAllBucketsAcrossAllStorageKeys(): Promise<{
        error: (string | null),
        partitions: IdbPartitionMetadata[], }> {
    return this.proxy.sendMessage(
        0,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  downloadBucketData(
      bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }> {
    return this.proxy.sendMessage(
        1,
        IdbInternalsHandler_DownloadBucketData_ParamsSpec.$,
        IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$,
        [
          bucketId
        ],
        false);
  }

  forceClose(
      bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }> {
    return this.proxy.sendMessage(
        2,
        IdbInternalsHandler_ForceClose_ParamsSpec.$,
        IdbInternalsHandler_ForceClose_ResponseParamsSpec.$,
        [
          bucketId
        ],
        false);
  }

  startMetadataRecording(
      bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null), }> {
    return this.proxy.sendMessage(
        3,
        IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$,
        [
          bucketId
        ],
        false);
  }

  stopMetadataRecording(
      bucketId: storage_mojom_BucketId): Promise<{
        error: (string | null),
        metadata: storage_mojom_IdbBucketMetadata[], }> {
    return this.proxy.sendMessage(
        4,
        IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$,
        [
          bucketId
        ],
        false);
  }

  inspectClient(
      clientInfo: storage_mojom_BucketClientInfo): Promise<{
        error: (string | null), }> {
    return this.proxy.sendMessage(
        5,
        IdbInternalsHandler_InspectClient_ParamsSpec.$,
        IdbInternalsHandler_InspectClient_ResponseParamsSpec.$,
        [
          clientInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IdbInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IdbInternalsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    IdbInternalsHandlerRemote, IdbInternalsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    IdbInternalsHandlerRemote, IdbInternalsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: IdbInternalsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IdbInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$,
        impl.getAllBucketsAcrossAllStorageKeys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IdbInternalsHandler_DownloadBucketData_ParamsSpec.$,
        IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$,
        impl.downloadBucketData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IdbInternalsHandler_ForceClose_ParamsSpec.$,
        IdbInternalsHandler_ForceClose_ResponseParamsSpec.$,
        impl.forceClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$,
        impl.startMetadataRecording.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$,
        impl.stopMetadataRecording.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        IdbInternalsHandler_InspectClient_ParamsSpec.$,
        IdbInternalsHandler_InspectClient_ResponseParamsSpec.$,
        impl.inspectClient.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IdbInternalsHandler {
  static get $interfaceName(): string {
    return "storage.mojom.IdbInternalsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): IdbInternalsHandlerRemote {
    let remote = new IdbInternalsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the IdbInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IdbInternalsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    IdbInternalsHandlerRemote, IdbInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    IdbInternalsHandlerRemote, IdbInternalsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getAllBucketsAcrossAllStorageKeys: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  downloadBucketData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  forceClose: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startMetadataRecording: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopMetadataRecording: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  inspectClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IdbInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getAllBucketsAcrossAllStorageKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$,
        IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$,
        this.getAllBucketsAcrossAllStorageKeys.createReceiverHandler(true /* expectsResponse */),
        false);
    this.downloadBucketData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IdbInternalsHandler_DownloadBucketData_ParamsSpec.$,
        IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$,
        this.downloadBucketData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.forceClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IdbInternalsHandler_ForceClose_ParamsSpec.$,
        IdbInternalsHandler_ForceClose_ResponseParamsSpec.$,
        this.forceClose.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startMetadataRecording =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$,
        this.startMetadataRecording.createReceiverHandler(true /* expectsResponse */),
        false);
    this.stopMetadataRecording =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$,
        IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$,
        this.stopMetadataRecording.createReceiverHandler(true /* expectsResponse */),
        false);
    this.inspectClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        IdbInternalsHandler_InspectClient_ParamsSpec.$,
        IdbInternalsHandler_InspectClient_ResponseParamsSpec.$,
        this.inspectClient.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const IdbPartitionMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_DownloadBucketData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_ForceClose_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_ForceClose_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_StartMetadataRecording_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_StopMetadataRecording_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_InspectClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IdbInternalsHandler_InspectClient_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface IdbPartitionMetadataMojoType {
  partitionPath: mojoBase_mojom_FilePath;
  originList: storage_mojom_IdbOriginMetadata[];
}


export type IdbPartitionMetadata = IdbPartitionMetadataMojoType;
mojo.internal.Struct<IdbPartitionMetadataMojoType>(
    IdbPartitionMetadataSpec.$,
    'IdbPartitionMetadata',
    [
      mojo.internal.StructField<IdbPartitionMetadataMojoType, mojoBase_mojom_FilePath>(
        'partitionPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IdbPartitionMetadataMojoType, storage_mojom_IdbOriginMetadata[]>(
        'originList', 8,
        0,
        mojo.internal.Array(storage_mojom_IdbOriginMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsMojoType {
}


export type IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params = IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsMojoType>(
    IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsSpec.$,
    'IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params',
    [
    ],
    [[0, 8],]);





export interface IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsMojoType {
  error: (string | null);
  partitions: IdbPartitionMetadata[];
}


export type IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams = IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsMojoType>(
    IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsSpec.$,
    'IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsMojoType, IdbPartitionMetadata[]>(
        'partitions', 8,
        0,
        mojo.internal.Array(IdbPartitionMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface IdbInternalsHandler_DownloadBucketData_ParamsMojoType {
  bucketId: storage_mojom_BucketId;
}


export type IdbInternalsHandler_DownloadBucketData_Params = IdbInternalsHandler_DownloadBucketData_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_DownloadBucketData_ParamsMojoType>(
    IdbInternalsHandler_DownloadBucketData_ParamsSpec.$,
    'IdbInternalsHandler_DownloadBucketData_Params',
    [
      mojo.internal.StructField<IdbInternalsHandler_DownloadBucketData_ParamsMojoType, storage_mojom_BucketId>(
        'bucketId', 0,
        0,
        storage_mojom_BucketIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_DownloadBucketData_ResponseParamsMojoType {
  error: (string | null);
}


export type IdbInternalsHandler_DownloadBucketData_ResponseParams = IdbInternalsHandler_DownloadBucketData_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_DownloadBucketData_ResponseParamsMojoType>(
    IdbInternalsHandler_DownloadBucketData_ResponseParamsSpec.$,
    'IdbInternalsHandler_DownloadBucketData_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_DownloadBucketData_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_ForceClose_ParamsMojoType {
  bucketId: storage_mojom_BucketId;
}


export type IdbInternalsHandler_ForceClose_Params = IdbInternalsHandler_ForceClose_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_ForceClose_ParamsMojoType>(
    IdbInternalsHandler_ForceClose_ParamsSpec.$,
    'IdbInternalsHandler_ForceClose_Params',
    [
      mojo.internal.StructField<IdbInternalsHandler_ForceClose_ParamsMojoType, storage_mojom_BucketId>(
        'bucketId', 0,
        0,
        storage_mojom_BucketIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_ForceClose_ResponseParamsMojoType {
  error: (string | null);
}


export type IdbInternalsHandler_ForceClose_ResponseParams = IdbInternalsHandler_ForceClose_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_ForceClose_ResponseParamsMojoType>(
    IdbInternalsHandler_ForceClose_ResponseParamsSpec.$,
    'IdbInternalsHandler_ForceClose_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_ForceClose_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_StartMetadataRecording_ParamsMojoType {
  bucketId: storage_mojom_BucketId;
}


export type IdbInternalsHandler_StartMetadataRecording_Params = IdbInternalsHandler_StartMetadataRecording_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_StartMetadataRecording_ParamsMojoType>(
    IdbInternalsHandler_StartMetadataRecording_ParamsSpec.$,
    'IdbInternalsHandler_StartMetadataRecording_Params',
    [
      mojo.internal.StructField<IdbInternalsHandler_StartMetadataRecording_ParamsMojoType, storage_mojom_BucketId>(
        'bucketId', 0,
        0,
        storage_mojom_BucketIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_StartMetadataRecording_ResponseParamsMojoType {
  error: (string | null);
}


export type IdbInternalsHandler_StartMetadataRecording_ResponseParams = IdbInternalsHandler_StartMetadataRecording_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_StartMetadataRecording_ResponseParamsMojoType>(
    IdbInternalsHandler_StartMetadataRecording_ResponseParamsSpec.$,
    'IdbInternalsHandler_StartMetadataRecording_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_StartMetadataRecording_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_StopMetadataRecording_ParamsMojoType {
  bucketId: storage_mojom_BucketId;
}


export type IdbInternalsHandler_StopMetadataRecording_Params = IdbInternalsHandler_StopMetadataRecording_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_StopMetadataRecording_ParamsMojoType>(
    IdbInternalsHandler_StopMetadataRecording_ParamsSpec.$,
    'IdbInternalsHandler_StopMetadataRecording_Params',
    [
      mojo.internal.StructField<IdbInternalsHandler_StopMetadataRecording_ParamsMojoType, storage_mojom_BucketId>(
        'bucketId', 0,
        0,
        storage_mojom_BucketIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_StopMetadataRecording_ResponseParamsMojoType {
  error: (string | null);
  metadata: storage_mojom_IdbBucketMetadata[];
}


export type IdbInternalsHandler_StopMetadataRecording_ResponseParams = IdbInternalsHandler_StopMetadataRecording_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_StopMetadataRecording_ResponseParamsMojoType>(
    IdbInternalsHandler_StopMetadataRecording_ResponseParamsSpec.$,
    'IdbInternalsHandler_StopMetadataRecording_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_StopMetadataRecording_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IdbInternalsHandler_StopMetadataRecording_ResponseParamsMojoType, storage_mojom_IdbBucketMetadata[]>(
        'metadata', 8,
        0,
        mojo.internal.Array(storage_mojom_IdbBucketMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface IdbInternalsHandler_InspectClient_ParamsMojoType {
  clientInfo: storage_mojom_BucketClientInfo;
}


export type IdbInternalsHandler_InspectClient_Params = IdbInternalsHandler_InspectClient_ParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_InspectClient_ParamsMojoType>(
    IdbInternalsHandler_InspectClient_ParamsSpec.$,
    'IdbInternalsHandler_InspectClient_Params',
    [
      mojo.internal.StructField<IdbInternalsHandler_InspectClient_ParamsMojoType, storage_mojom_BucketClientInfo>(
        'clientInfo', 0,
        0,
        storage_mojom_BucketClientInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface IdbInternalsHandler_InspectClient_ResponseParamsMojoType {
  error: (string | null);
}


export type IdbInternalsHandler_InspectClient_ResponseParams = IdbInternalsHandler_InspectClient_ResponseParamsMojoType;
mojo.internal.Struct<IdbInternalsHandler_InspectClient_ResponseParamsMojoType>(
    IdbInternalsHandler_InspectClient_ResponseParamsSpec.$,
    'IdbInternalsHandler_InspectClient_ResponseParams',
    [
      mojo.internal.StructField<IdbInternalsHandler_InspectClient_ResponseParamsMojoType, string>(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



