// content/browser/process_internals/process_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "content/browser/process_internals/process_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/browser/process_internals/process_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::ProcessCountInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::ProcessCountInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::ProcessCountInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->renderer_process_limit = Traits::renderer_process_limit(input);

      fragment->renderer_process_count_total = Traits::renderer_process_count_total(input);

      fragment->live_renderer_processes_count_total = Traits::live_renderer_processes_count_total(input);

      fragment->renderer_process_count_for_limit = Traits::renderer_process_count_for_limit(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::SiteInstanceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::SiteInstanceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::SiteInstanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->site_instance_group_id = Traits::site_instance_group_id(input);

      fragment->browsing_instance_id = Traits::browsing_instance_id(input);

      fragment->locked = Traits::locked(input);

      decltype(Traits::site_url(input)) in_site_url = Traits::site_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site_url)::BaseType> site_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_site_url,
        site_url_fragment);

      fragment->site_url.Set(
          site_url_fragment.is_null() ? nullptr : site_url_fragment.data());

      decltype(Traits::process_lock_url(input)) in_process_lock_url = Traits::process_lock_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->process_lock_url)::BaseType> process_lock_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_process_lock_url,
        process_lock_url_fragment);

      fragment->process_lock_url.Set(
          process_lock_url_fragment.is_null() ? nullptr : process_lock_url_fragment.data());

      fragment->requires_origin_keyed_process = Traits::requires_origin_keyed_process(input);

      fragment->is_sandbox_for_iframes = Traits::is_sandbox_for_iframes(input);

      fragment->is_guest = Traits::is_guest(input);

      fragment->is_pdf = Traits::is_pdf(input);

      fragment->are_javascript_optimizers_enabled = Traits::are_javascript_optimizers_enabled(input);

      decltype(Traits::storage_partition(input)) in_storage_partition = Traits::storage_partition(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage_partition)::BaseType> storage_partition_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_storage_partition,
        storage_partition_fragment);

      fragment->storage_partition.Set(
          storage_partition_fragment.is_null() ? nullptr : storage_partition_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::FrameInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::FrameInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::FrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->routing_id = Traits::routing_id(input);

      fragment->agent_scheduling_group_id = Traits::agent_scheduling_group_id(input);

      fragment->process_id = Traits::process_id(input);

      decltype(Traits::site_instance(input)) in_site_instance = Traits::site_instance(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site_instance)::BaseType> site_instance_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojom::SiteInstanceInfoDataView, send_validation>(
        in_site_instance,
        site_instance_fragment);

      fragment->site_instance.Set(
          site_instance_fragment.is_null() ? nullptr : site_instance_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site_instance.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_instance in FrameInfo struct");

      decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_last_committed_url,
        last_committed_url_fragment);

      fragment->last_committed_url.Set(
          last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());

      decltype(Traits::subframes(input)) in_subframes = Traits::subframes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subframes)::BaseType>
          subframes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& subframes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>, send_validation>(
        in_subframes,
        subframes_fragment,
        &subframes_validate_params);

      fragment->subframes.Set(
          subframes_fragment.is_null() ? nullptr : subframes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subframes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframes in FrameInfo struct");

      
      mojo::internal::Serialize<::mojom::FrameInfo_Type>(
        Traits::type(input),
        &fragment->type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::WebContentsInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::WebContentsInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::WebContentsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in WebContentsInfo struct");

      decltype(Traits::root_frame(input)) in_root_frame = Traits::root_frame(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->root_frame)::BaseType> root_frame_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojom::FrameInfoDataView, send_validation>(
        in_root_frame,
        root_frame_fragment);

      fragment->root_frame.Set(
          root_frame_fragment.is_null() ? nullptr : root_frame_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->root_frame.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_frame in WebContentsInfo struct");

      decltype(Traits::bfcached_root_frames(input)) in_bfcached_root_frames = Traits::bfcached_root_frames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bfcached_root_frames)::BaseType>
          bfcached_root_frames_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bfcached_root_frames_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>, send_validation>(
        in_bfcached_root_frames,
        bfcached_root_frames_fragment,
        &bfcached_root_frames_validate_params);

      fragment->bfcached_root_frames.Set(
          bfcached_root_frames_fragment.is_null() ? nullptr : bfcached_root_frames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bfcached_root_frames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bfcached_root_frames in WebContentsInfo struct");

      decltype(Traits::prerender_root_frames(input)) in_prerender_root_frames = Traits::prerender_root_frames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->prerender_root_frames)::BaseType>
          prerender_root_frames_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& prerender_root_frames_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>, send_validation>(
        in_prerender_root_frames,
        prerender_root_frames_fragment,
        &prerender_root_frames_validate_params);

      fragment->prerender_root_frames.Set(
          prerender_root_frames_fragment.is_null() ? nullptr : prerender_root_frames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->prerender_root_frames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prerender_root_frames in WebContentsInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojom::IsolatedOriginInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::IsolatedOriginInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::IsolatedOriginInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IsolatedOriginInfo struct");

      decltype(Traits::source(input)) in_source = Traits::source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source)::BaseType> source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_source,
        source_fragment);

      fragment->source.Set(
          source_fragment.is_null() ? nullptr : source_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in IsolatedOriginInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SEND_VALIDATION_H_