// content/browser/private_aggregation/private_aggregation_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-features.h"  // IWYU pragma: export
#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/private_aggregation/private_aggregation_internals.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/int128.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/browser/aggregation_service/aggregatable_report_request_storage_id.h"
#include "content/browser/private_aggregation/private_aggregation_internals_mojom_traits.h"
#include "content/common/content_export.h"




namespace private_aggregation_internals::mojom {

class ObserverProxy;

template <typename ImplRefTraits>
class ObserverStub;

class ObserverRequestValidator;


class CONTENT_EXPORT Observer
    : public ObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "private_aggregation_internals.mojom.Observer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ObserverInterfaceBase;
  using Proxy_ = ObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ObserverStub<ImplRefTraits>;

  using RequestValidator_ = ObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRequestStorageModifiedMinVersion = 0,
    kOnReportHandledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRequestStorageModified_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportHandled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Observer() = default;

  virtual void OnRequestStorageModified() = 0;

  virtual void OnReportHandled(WebUIAggregatableReportPtr report) = 0;
};

class HandlerProxy;

template <typename ImplRefTraits>
class HandlerStub;

class HandlerRequestValidator;
class HandlerResponseValidator;


class CONTENT_EXPORT Handler
    : public HandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "private_aggregation_internals.mojom.Handler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HandlerInterfaceBase;
  using Proxy_ = HandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HandlerStub<ImplRefTraits>;

  using RequestValidator_ = HandlerRequestValidator;
  using ResponseValidator_ = HandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetReportsMinVersion = 0,
    kSendReportsMinVersion = 0,
    kClearStorageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Handler() = default;

  using GetReportsCallback = base::OnceCallback<void(std::vector<WebUIAggregatableReportPtr>)>;
  using GetReportsMojoCallback = base::OnceCallback<void(std::vector<WebUIAggregatableReportPtr>)>;

  virtual void GetReports(GetReportsCallback callback) = 0;

  using SendReportsCallback = base::OnceCallback<void()>;
  using SendReportsMojoCallback = base::OnceCallback<void()>;

  virtual void SendReports(const std::vector<::content::AggregatableReportRequestStorageId>& ids, SendReportsCallback callback) = 0;

  using ClearStorageCallback = base::OnceCallback<void()>;
  using ClearStorageMojoCallback = base::OnceCallback<void()>;

  virtual void ClearStorage(ClearStorageCallback callback) = 0;
};

class FactoryProxy;

template <typename ImplRefTraits>
class FactoryStub;

class FactoryRequestValidator;


class CONTENT_EXPORT Factory
    : public FactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "private_aggregation_internals.mojom.Factory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FactoryInterfaceBase;
  using Proxy_ = FactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FactoryStub<ImplRefTraits>;

  using RequestValidator_ = FactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Factory() = default;

  virtual void Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) = 0;
};



class CONTENT_EXPORT ObserverProxy
    : public Observer {
 public:
  using InterfaceType = Observer;

  explicit ObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRequestStorageModified() final;
  
  void OnReportHandled(WebUIAggregatableReportPtr report) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT HandlerProxy
    : public Handler {
 public:
  using InterfaceType = Handler;

  explicit HandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetReports(GetReportsCallback callback) final;
  
  void SendReports(const std::vector<::content::AggregatableReportRequestStorageId>& ids, SendReportsCallback callback) final;
  
  void ClearStorage(ClearStorageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FactoryProxy
    : public Factory {
 public:
  using InterfaceType = Factory;

  explicit FactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT ObserverStubDispatch {
 public:
  static bool Accept(Observer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Observer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Observer>>
class ObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ObserverStub() = default;
  ~ObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT HandlerStubDispatch {
 public:
  static bool Accept(Handler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Handler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Handler>>
class HandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HandlerStub() = default;
  ~HandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FactoryStubDispatch {
 public:
  static bool Accept(Factory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Factory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Factory>>
class FactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FactoryStub() = default;
  ~FactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT HandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT HandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class CONTENT_EXPORT AggregatableReportRequestID {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableReportRequestID, T>::value>;
  using DataView = AggregatableReportRequestIDDataView;
  using Data_ = internal::AggregatableReportRequestID_Data;

  template <typename... Args>
  static AggregatableReportRequestIDPtr New(Args&&... args) {
    return AggregatableReportRequestIDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableReportRequestIDPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableReportRequestIDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableReportRequestID>::Convert(*this);
  }


  AggregatableReportRequestID();

  explicit AggregatableReportRequestID(
      int64_t value);


  ~AggregatableReportRequestID();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableReportRequestIDPtr>
  AggregatableReportRequestIDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableReportRequestID::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableReportRequestID::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableReportRequestID::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableReportRequestID_UnserializedMessageContext<
            UserType, AggregatableReportRequestID::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableReportRequestID::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableReportRequestID::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableReportRequestID_UnserializedMessageContext<
            UserType, AggregatableReportRequestID::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableReportRequestID::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableReportRequestID::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class CONTENT_EXPORT AggregatableHistogramContribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableHistogramContribution, T>::value>;
  using DataView = AggregatableHistogramContributionDataView;
  using Data_ = internal::AggregatableHistogramContribution_Data;

  template <typename... Args>
  static AggregatableHistogramContributionPtr New(Args&&... args) {
    return AggregatableHistogramContributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableHistogramContributionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableHistogramContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableHistogramContribution>::Convert(*this);
  }


  AggregatableHistogramContribution();

  AggregatableHistogramContribution(
      const ::absl::uint128& bucket,
      int32_t value);


  ~AggregatableHistogramContribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableHistogramContributionPtr>
  AggregatableHistogramContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableHistogramContribution::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableHistogramContribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableHistogramContribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableHistogramContribution_UnserializedMessageContext<
            UserType, AggregatableHistogramContribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableHistogramContribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableHistogramContribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableHistogramContribution_UnserializedMessageContext<
            UserType, AggregatableHistogramContribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableHistogramContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 bucket;
  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT WebUIAggregatableReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIAggregatableReport, T>::value>;
  using DataView = WebUIAggregatableReportDataView;
  using Data_ = internal::WebUIAggregatableReport_Data;

  template <typename... Args>
  static WebUIAggregatableReportPtr New(Args&&... args) {
    return WebUIAggregatableReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIAggregatableReportPtr From(const U& u) {
    return mojo::TypeConverter<WebUIAggregatableReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIAggregatableReport>::Convert(*this);
  }


  WebUIAggregatableReport();

  WebUIAggregatableReport(
      const std::optional<::content::AggregatableReportRequestStorageId>& id,
      double report_time,
      const std::string& api_identifier,
      const std::string& api_version,
      const ::GURL& report_url,
      std::vector<AggregatableHistogramContributionPtr> contributions,
      ReportStatus status,
      const std::string& report_body);

WebUIAggregatableReport(const WebUIAggregatableReport&) = delete;
WebUIAggregatableReport& operator=(const WebUIAggregatableReport&) = delete;

  ~WebUIAggregatableReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIAggregatableReportPtr>
  WebUIAggregatableReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIAggregatableReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIAggregatableReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIAggregatableReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIAggregatableReport_UnserializedMessageContext<
            UserType, WebUIAggregatableReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIAggregatableReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIAggregatableReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIAggregatableReport_UnserializedMessageContext<
            UserType, WebUIAggregatableReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIAggregatableReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::content::AggregatableReportRequestStorageId> id;
  
  double report_time;
  
  std::string api_identifier;
  
  std::string api_version;
  
  ::GURL report_url;
  
  std::vector<AggregatableHistogramContributionPtr> contributions;
  
  ReportStatus status;
  
  std::string report_body;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIAggregatableReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AggregatableReportRequestIDPtr AggregatableReportRequestID::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, AggregatableReportRequestID::EnableIfSame<T>*>
bool AggregatableReportRequestID::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AggregatableReportRequestID::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableHistogramContributionPtr AggregatableHistogramContribution::Clone() const {
  return New(
      mojo::Clone(bucket),
      mojo::Clone(value)
  );
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>*>
bool AggregatableHistogramContribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket, other_struct.bucket))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket < rhs.bucket)
    return true;
  if (rhs.bucket < lhs.bucket)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIAggregatableReportPtr WebUIAggregatableReport::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(report_time),
      mojo::Clone(api_identifier),
      mojo::Clone(api_version),
      mojo::Clone(report_url),
      mojo::Clone(contributions),
      mojo::Clone(status),
      mojo::Clone(report_body)
  );
}

template <typename T, WebUIAggregatableReport::EnableIfSame<T>*>
bool WebUIAggregatableReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->report_time, other_struct.report_time))
    return false;
  if (!mojo::Equals(this->api_identifier, other_struct.api_identifier))
    return false;
  if (!mojo::Equals(this->api_version, other_struct.api_version))
    return false;
  if (!mojo::Equals(this->report_url, other_struct.report_url))
    return false;
  if (!mojo::Equals(this->contributions, other_struct.contributions))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->report_body, other_struct.report_body))
    return false;
  return true;
}

template <typename T, WebUIAggregatableReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.report_time < rhs.report_time)
    return true;
  if (rhs.report_time < lhs.report_time)
    return false;
  if (lhs.api_identifier < rhs.api_identifier)
    return true;
  if (rhs.api_identifier < lhs.api_identifier)
    return false;
  if (lhs.api_version < rhs.api_version)
    return true;
  if (rhs.api_version < lhs.api_version)
    return false;
  if (lhs.report_url < rhs.report_url)
    return true;
  if (rhs.report_url < lhs.report_url)
    return false;
  if (lhs.contributions < rhs.contributions)
    return true;
  if (rhs.contributions < lhs.contributions)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.report_body < rhs.report_body)
    return true;
  if (rhs.report_body < lhs.report_body)
    return false;
  return false;
}


}  // private_aggregation_internals::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::private_aggregation_internals::mojom::AggregatableReportRequestID::DataView,
                                         ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr> {
  static bool IsNull(const ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr& input) { return !input; }
  static void SetToNull(::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr* output) { output->reset(); }

  static decltype(::private_aggregation_internals::mojom::AggregatableReportRequestID::value) value(
      const ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr& input) {
    return input->value;
  }

  static bool Read(::private_aggregation_internals::mojom::AggregatableReportRequestID::DataView input, ::private_aggregation_internals::mojom::AggregatableReportRequestIDPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::private_aggregation_internals::mojom::AggregatableHistogramContribution::DataView,
                                         ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr> {
  static bool IsNull(const ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr& input) { return !input; }
  static void SetToNull(::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr* output) { output->reset(); }

  static const decltype(::private_aggregation_internals::mojom::AggregatableHistogramContribution::bucket)& bucket(
      const ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr& input) {
    return input->bucket;
  }

  static decltype(::private_aggregation_internals::mojom::AggregatableHistogramContribution::value) value(
      const ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr& input) {
    return input->value;
  }

  static bool Read(::private_aggregation_internals::mojom::AggregatableHistogramContribution::DataView input, ::private_aggregation_internals::mojom::AggregatableHistogramContributionPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::private_aggregation_internals::mojom::WebUIAggregatableReport::DataView,
                                         ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr> {
  static bool IsNull(const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) { return !input; }
  static void SetToNull(::private_aggregation_internals::mojom::WebUIAggregatableReportPtr* output) { output->reset(); }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::id)& id(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->id;
  }

  static decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::report_time) report_time(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->report_time;
  }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::api_identifier)& api_identifier(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->api_identifier;
  }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::api_version)& api_version(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->api_version;
  }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::report_url)& report_url(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->report_url;
  }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::contributions)& contributions(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->contributions;
  }

  static decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::status) status(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->status;
  }

  static const decltype(::private_aggregation_internals::mojom::WebUIAggregatableReport::report_body)& report_body(
      const ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr& input) {
    return input->report_body;
  }

  static bool Read(::private_aggregation_internals::mojom::WebUIAggregatableReport::DataView input, ::private_aggregation_internals::mojom::WebUIAggregatableReportPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_H_