// content/browser/private_aggregation/private_aggregation_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  Uint128Spec as mojoBase_mojom_Uint128Spec,
  Uint128 as mojoBase_mojom_Uint128
} from '//resources/mojo/mojo/public/mojom/base/int128.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ReportStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ReportStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kPending = 0,
  kSent = 1,
  kFailedToAssemble = 2,
  kFailedToSend = 3,
}



export type ObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ObserverPendingReceiver>;

export class ObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Observer> {

  handle: mojo.internal.interfaceSupport.Endpoint<ObserverPendingReceiver>;
  constructor(handle: MojoHandle|ObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'private_aggregation_internals.mojom.Observer',
        scope);
  }
}

export interface ObserverInterface {
  onRequestStorageModified(): void;
  onReportHandled(report: WebUIAggregatableReport): void;
}

export class ObserverRemote implements ObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onRequestStorageModified(): void {
    this.proxy.sendMessage(
        0,
        Observer_OnRequestStorageModified_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onReportHandled(
      report: WebUIAggregatableReport): void {
    this.proxy.sendMessage(
        1,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Observer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ObserverRemote, ObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ObserverRemote, ObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Observer_OnRequestStorageModified_ParamsSpec.$,
        null,
        impl.onRequestStorageModified.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        impl.onReportHandled.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Observer {
  static get $interfaceName(): string {
    return "private_aggregation_internals.mojom.Observer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ObserverRemote {
    let remote = new ObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Observer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ObserverRemote, ObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ObserverRemote, ObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onRequestStorageModified: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onReportHandled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onRequestStorageModified =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Observer_OnRequestStorageModified_ParamsSpec.$,
        null,
        this.onRequestStorageModified.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onReportHandled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Observer_OnReportHandled_ParamsSpec.$,
        null,
        this.onReportHandled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type HandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<HandlerPendingReceiver>;

export class HandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Handler> {

  handle: mojo.internal.interfaceSupport.Endpoint<HandlerPendingReceiver>;
  constructor(handle: MojoHandle|HandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'private_aggregation_internals.mojom.Handler',
        scope);
  }
}

export interface HandlerInterface {
  getReports(): Promise<{
        reports: WebUIAggregatableReport[], }>;
  sendReports(ids: AggregatableReportRequestID[]): Promise<void>;
  clearStorage(): Promise<void>;
}

export class HandlerRemote implements HandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<HandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<HandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|HandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getReports(): Promise<{
        reports: WebUIAggregatableReport[], }> {
    return this.proxy.sendMessage(
        0,
        Handler_GetReports_ParamsSpec.$,
        Handler_GetReports_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  sendReports(
      ids: AggregatableReportRequestID[]): Promise<void> {
    return this.proxy.sendMessage(
        1,
        Handler_SendReports_ParamsSpec.$,
        Handler_SendReports_ResponseParamsSpec.$,
        [
          ids
        ],
        false);
  }

  clearStorage(): Promise<void> {
    return this.proxy.sendMessage(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Handler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HandlerRemote, HandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HandlerRemote, HandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: HandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Handler_GetReports_ParamsSpec.$,
        Handler_GetReports_ResponseParamsSpec.$,
        impl.getReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Handler_SendReports_ParamsSpec.$,
        Handler_SendReports_ResponseParamsSpec.$,
        impl.sendReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        impl.clearStorage.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Handler {
  static get $interfaceName(): string {
    return "private_aggregation_internals.mojom.Handler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): HandlerRemote {
    let remote = new HandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Handler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    HandlerRemote, HandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    HandlerRemote, HandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getReports: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendReports: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearStorage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Handler_GetReports_ParamsSpec.$,
        Handler_GetReports_ResponseParamsSpec.$,
        this.getReports.createReceiverHandler(true /* expectsResponse */),
        false);
    this.sendReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Handler_SendReports_ParamsSpec.$,
        Handler_SendReports_ResponseParamsSpec.$,
        this.sendReports.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Handler_ClearStorage_ParamsSpec.$,
        Handler_ClearStorage_ResponseParamsSpec.$,
        this.clearStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type FactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<FactoryPendingReceiver>;

export class FactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Factory> {

  handle: mojo.internal.interfaceSupport.Endpoint<FactoryPendingReceiver>;
  constructor(handle: MojoHandle|FactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'private_aggregation_internals.mojom.Factory',
        scope);
  }
}

export interface FactoryInterface {
  create(observer: ObserverRemote, handler: HandlerPendingReceiver): void;
}

export class FactoryRemote implements FactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<FactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|FactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  create(
      observer: ObserverRemote,
      handler: HandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        [
          observer,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Factory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FactoryRemote, FactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FactoryRemote, FactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: FactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        impl.create.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Factory {
  static get $interfaceName(): string {
    return "private_aggregation_internals.mojom.Factory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): FactoryRemote {
    let remote = new FactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Factory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FactoryRemote, FactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FactoryRemote, FactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  create: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Factory_Create_ParamsSpec.$,
        null,
        this.create.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AggregatableReportRequestIDSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AggregatableHistogramContributionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIAggregatableReportSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnRequestStorageModified_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Observer_OnReportHandled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_GetReports_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_GetReports_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_SendReports_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_SendReports_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_ClearStorage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Handler_ClearStorage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Factory_Create_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AggregatableReportRequestIDMojoType {
  value: bigint;
}


export type AggregatableReportRequestID = AggregatableReportRequestIDMojoType;
mojo.internal.Struct<AggregatableReportRequestIDMojoType>(
    AggregatableReportRequestIDSpec.$,
    'AggregatableReportRequestID',
    [
      mojo.internal.StructField<AggregatableReportRequestIDMojoType, bigint>(
        'value', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AggregatableHistogramContributionMojoType {
  bucket: mojoBase_mojom_Uint128;
  value: number;
}


export type AggregatableHistogramContribution = AggregatableHistogramContributionMojoType;
mojo.internal.Struct<AggregatableHistogramContributionMojoType>(
    AggregatableHistogramContributionSpec.$,
    'AggregatableHistogramContribution',
    [
      mojo.internal.StructField<AggregatableHistogramContributionMojoType, mojoBase_mojom_Uint128>(
        'bucket', 0,
        0,
        mojoBase_mojom_Uint128Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AggregatableHistogramContributionMojoType, number>(
        'value', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebUIAggregatableReportMojoType {
  id: (AggregatableReportRequestID | null);
  reportTime: number;
  apiIdentifier: string;
  apiVersion: string;
  reportUrl: url_mojom_Url;
  contributions: AggregatableHistogramContribution[];
  status: ReportStatus;
  reportBody: string;
}


export type WebUIAggregatableReport = WebUIAggregatableReportMojoType;
mojo.internal.Struct<WebUIAggregatableReportMojoType>(
    WebUIAggregatableReportSpec.$,
    'WebUIAggregatableReport',
    [
      mojo.internal.StructField<WebUIAggregatableReportMojoType, AggregatableReportRequestID>(
        'id', 0,
        0,
        AggregatableReportRequestIDSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, number>(
        'reportTime', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, string>(
        'apiIdentifier', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, string>(
        'apiVersion', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, url_mojom_Url>(
        'reportUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, AggregatableHistogramContribution[]>(
        'contributions', 40,
        0,
        mojo.internal.Array(AggregatableHistogramContributionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, ReportStatus>(
        'status', 48,
        0,
        ReportStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIAggregatableReportMojoType, string>(
        'reportBody', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface Observer_OnRequestStorageModified_ParamsMojoType {
}


export type Observer_OnRequestStorageModified_Params = Observer_OnRequestStorageModified_ParamsMojoType;
mojo.internal.Struct<Observer_OnRequestStorageModified_ParamsMojoType>(
    Observer_OnRequestStorageModified_ParamsSpec.$,
    'Observer_OnRequestStorageModified_Params',
    [
    ],
    [[0, 8],]);





export interface Observer_OnReportHandled_ParamsMojoType {
  report: WebUIAggregatableReport;
}


export type Observer_OnReportHandled_Params = Observer_OnReportHandled_ParamsMojoType;
mojo.internal.Struct<Observer_OnReportHandled_ParamsMojoType>(
    Observer_OnReportHandled_ParamsSpec.$,
    'Observer_OnReportHandled_Params',
    [
      mojo.internal.StructField<Observer_OnReportHandled_ParamsMojoType, WebUIAggregatableReport>(
        'report', 0,
        0,
        WebUIAggregatableReportSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_GetReports_ParamsMojoType {
}


export type Handler_GetReports_Params = Handler_GetReports_ParamsMojoType;
mojo.internal.Struct<Handler_GetReports_ParamsMojoType>(
    Handler_GetReports_ParamsSpec.$,
    'Handler_GetReports_Params',
    [
    ],
    [[0, 8],]);





export interface Handler_GetReports_ResponseParamsMojoType {
  reports: WebUIAggregatableReport[];
}


export type Handler_GetReports_ResponseParams = Handler_GetReports_ResponseParamsMojoType;
mojo.internal.Struct<Handler_GetReports_ResponseParamsMojoType>(
    Handler_GetReports_ResponseParamsSpec.$,
    'Handler_GetReports_ResponseParams',
    [
      mojo.internal.StructField<Handler_GetReports_ResponseParamsMojoType, WebUIAggregatableReport[]>(
        'reports', 0,
        0,
        mojo.internal.Array(WebUIAggregatableReportSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_SendReports_ParamsMojoType {
  ids: AggregatableReportRequestID[];
}


export type Handler_SendReports_Params = Handler_SendReports_ParamsMojoType;
mojo.internal.Struct<Handler_SendReports_ParamsMojoType>(
    Handler_SendReports_ParamsSpec.$,
    'Handler_SendReports_Params',
    [
      mojo.internal.StructField<Handler_SendReports_ParamsMojoType, AggregatableReportRequestID[]>(
        'ids', 0,
        0,
        mojo.internal.Array(AggregatableReportRequestIDSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Handler_SendReports_ResponseParamsMojoType {
}


export type Handler_SendReports_ResponseParams = Handler_SendReports_ResponseParamsMojoType;
mojo.internal.Struct<Handler_SendReports_ResponseParamsMojoType>(
    Handler_SendReports_ResponseParamsSpec.$,
    'Handler_SendReports_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface Handler_ClearStorage_ParamsMojoType {
}


export type Handler_ClearStorage_Params = Handler_ClearStorage_ParamsMojoType;
mojo.internal.Struct<Handler_ClearStorage_ParamsMojoType>(
    Handler_ClearStorage_ParamsSpec.$,
    'Handler_ClearStorage_Params',
    [
    ],
    [[0, 8],]);





export interface Handler_ClearStorage_ResponseParamsMojoType {
}


export type Handler_ClearStorage_ResponseParams = Handler_ClearStorage_ResponseParamsMojoType;
mojo.internal.Struct<Handler_ClearStorage_ResponseParamsMojoType>(
    Handler_ClearStorage_ResponseParamsSpec.$,
    'Handler_ClearStorage_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface Factory_Create_ParamsMojoType {
  observer: ObserverRemote;
  handler: HandlerPendingReceiver;
}


export type Factory_Create_Params = Factory_Create_ParamsMojoType;
mojo.internal.Struct<Factory_Create_ParamsMojoType>(
    Factory_Create_ParamsSpec.$,
    'Factory_Create_Params',
    [
      mojo.internal.StructField<Factory_Create_ParamsMojoType, ObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Factory_Create_ParamsMojoType, HandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(HandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



