// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Security_h
#define content_protocol_Security_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Security {
using CertificateId = int;
using MixedContentType = String;
using SecurityState = String;
class CertificateSecurityState;
using SafetyTipStatus = String;
class SafetyTipInfo;
class VisibleSecurityState;
class SecurityStateExplanation;
class InsecureContentStatus;
using CertificateErrorAction = String;

// ------------- Forward and enum declarations.

namespace MixedContentTypeEnum {
CONTENT_EXPORT extern const char Blockable[];
CONTENT_EXPORT extern const char OptionallyBlockable[];
CONTENT_EXPORT extern const char None[];
} // namespace MixedContentTypeEnum

namespace SecurityStateEnum {
CONTENT_EXPORT extern const char Unknown[];
CONTENT_EXPORT extern const char Neutral[];
CONTENT_EXPORT extern const char Insecure[];
CONTENT_EXPORT extern const char Secure[];
CONTENT_EXPORT extern const char Info[];
CONTENT_EXPORT extern const char InsecureBroken[];
} // namespace SecurityStateEnum

namespace SafetyTipStatusEnum {
CONTENT_EXPORT extern const char BadReputation[];
CONTENT_EXPORT extern const char Lookalike[];
} // namespace SafetyTipStatusEnum

namespace CertificateErrorActionEnum {
CONTENT_EXPORT extern const char Continue[];
CONTENT_EXPORT extern const char Cancel[];
} // namespace CertificateErrorActionEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT CertificateSecurityState : public ::crdtp::ProtocolObject<CertificateSecurityState> {
public:
    ~CertificateSecurityState() override;  // Defined below

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value);  // Defined below

    String GetKeyExchange() { return m_keyExchange; }
    void SetKeyExchange(const String& value);  // Defined below

    bool HasKeyExchangeGroup() { return !!m_keyExchangeGroup; }
    String GetKeyExchangeGroup(const String& defaultValue) const {
       return m_keyExchangeGroup.value_or(defaultValue);
    }
    const std::optional<String>& GetKeyExchangeGroup() const {
       return m_keyExchangeGroup;
    }
    void SetKeyExchangeGroup(const String& value);  // Defined below

    String GetCipher() { return m_cipher; }
    void SetCipher(const String& value);  // Defined below

    bool HasMac() { return !!m_mac; }
    String GetMac(const String& defaultValue) const {
       return m_mac.value_or(defaultValue);
    }
    const std::optional<String>& GetMac() const {
       return m_mac;
    }
    void SetMac(const String& value);  // Defined below

    protocol::Array<String>* GetCertificate() { return m_certificate.get(); }
    void SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String GetSubjectName() { return m_subjectName; }
    void SetSubjectName(const String& value);  // Defined below

    String GetIssuer() { return m_issuer; }
    void SetIssuer(const String& value);  // Defined below

    double GetValidFrom() { return m_validFrom; }
    void SetValidFrom(double value);  // Defined below

    double GetValidTo() { return m_validTo; }
    void SetValidTo(double value);  // Defined below

    bool HasCertificateNetworkError() { return !!m_certificateNetworkError; }
    String GetCertificateNetworkError(const String& defaultValue) const {
       return m_certificateNetworkError.value_or(defaultValue);
    }
    const std::optional<String>& GetCertificateNetworkError() const {
       return m_certificateNetworkError;
    }
    void SetCertificateNetworkError(const String& value);  // Defined below

    bool GetCertificateHasWeakSignature() { return m_certificateHasWeakSignature; }
    void SetCertificateHasWeakSignature(bool value);  // Defined below

    bool GetCertificateHasSha1Signature() { return m_certificateHasSha1Signature; }
    void SetCertificateHasSha1Signature(bool value);  // Defined below

    bool GetModernSSL() { return m_modernSSL; }
    void SetModernSSL(bool value);  // Defined below

    bool GetObsoleteSslProtocol() { return m_obsoleteSslProtocol; }
    void SetObsoleteSslProtocol(bool value);  // Defined below

    bool GetObsoleteSslKeyExchange() { return m_obsoleteSslKeyExchange; }
    void SetObsoleteSslKeyExchange(bool value);  // Defined below

    bool GetObsoleteSslCipher() { return m_obsoleteSslCipher; }
    void SetObsoleteSslCipher(bool value);  // Defined below

    bool GetObsoleteSslSignature() { return m_obsoleteSslSignature; }
    void SetObsoleteSslSignature(bool value);  // Defined below

    template<int STATE>
    class CertificateSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            IssuerSet = 1 << 6,
            ValidFromSet = 1 << 7,
            ValidToSet = 1 << 8,
            CertificateHasWeakSignatureSet = 1 << 9,
            CertificateHasSha1SignatureSet = 1 << 10,
            ModernSSLSet = 1 << 11,
            ObsoleteSslProtocolSet = 1 << 12,
            ObsoleteSslKeyExchangeSet = 1 << 13,
            ObsoleteSslCipherSet = 1 << 14,
            ObsoleteSslSignatureSet = 1 << 15,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateSet | SubjectNameSet | IssuerSet | ValidFromSet | ValidToSet | CertificateHasWeakSignatureSet | CertificateHasSha1SignatureSet | ModernSSLSet | ObsoleteSslProtocolSet | ObsoleteSslKeyExchangeSet | ObsoleteSslCipherSet | ObsoleteSslSignatureSet | 0)};


        CertificateSecurityStateBuilder<STATE | ProtocolSet>& SetProtocol(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | KeyExchangeSet>& SetKeyExchange(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetKeyExchangeGroup(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CipherSet>& SetCipher(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetMac(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateSet>& SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CertificateSecurityStateBuilder<STATE | SubjectNameSet>& SetSubjectName(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | IssuerSet>& SetIssuer(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidFromSet>& SetValidFrom(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidToSet>& SetValidTo(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetCertificateNetworkError(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasWeakSignatureSet>& SetCertificateHasWeakSignature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasSha1SignatureSet>& SetCertificateHasSha1Signature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ModernSSLSet>& SetModernSSL(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslProtocolSet>& SetObsoleteSslProtocol(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslKeyExchangeSet>& SetObsoleteSslKeyExchange(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslCipherSet>& SetObsoleteSslCipher(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslSignatureSet>& SetObsoleteSslSignature(bool value);  // Defined below

        std::unique_ptr<CertificateSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CertificateSecurityState;
        CertificateSecurityStateBuilder() : m_result(new CertificateSecurityState()) { }

        template<int STEP> CertificateSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CertificateSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::CertificateSecurityState> m_result;
    };

    static CertificateSecurityStateBuilder<0> Create()
    {
        return CertificateSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CertificateSecurityState();  // Defined below

    String m_protocol;
    String m_keyExchange;
    std::optional<String> m_keyExchangeGroup;
    String m_cipher;
    std::optional<String> m_mac;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    String m_subjectName;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    std::optional<String> m_certificateNetworkError;
    bool m_certificateHasWeakSignature;
    bool m_certificateHasSha1Signature;
    bool m_modernSSL;
    bool m_obsoleteSslProtocol;
    bool m_obsoleteSslKeyExchange;
    bool m_obsoleteSslCipher;
    bool m_obsoleteSslSignature;
};


class CONTENT_EXPORT SafetyTipInfo : public ::crdtp::ProtocolObject<SafetyTipInfo> {
public:
    ~SafetyTipInfo() override;  // Defined below

    String GetSafetyTipStatus() { return m_safetyTipStatus; }
    void SetSafetyTipStatus(const String& value);  // Defined below

    bool HasSafeUrl() { return !!m_safeUrl; }
    String GetSafeUrl(const String& defaultValue) const {
       return m_safeUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetSafeUrl() const {
       return m_safeUrl;
    }
    void SetSafeUrl(const String& value);  // Defined below

    template<int STATE>
    class SafetyTipInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SafetyTipStatusSet = 1 << 1,
            AllFieldsSet = (SafetyTipStatusSet | 0)};


        SafetyTipInfoBuilder<STATE | SafetyTipStatusSet>& SetSafetyTipStatus(const String& value);  // Defined below

        SafetyTipInfoBuilder<STATE>& SetSafeUrl(const String& value);  // Defined below

        std::unique_ptr<SafetyTipInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SafetyTipInfo;
        SafetyTipInfoBuilder() : m_result(new SafetyTipInfo()) { }

        template<int STEP> SafetyTipInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SafetyTipInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SafetyTipInfo> m_result;
    };

    static SafetyTipInfoBuilder<0> Create()
    {
        return SafetyTipInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SafetyTipInfo();  // Defined below

    String m_safetyTipStatus;
    std::optional<String> m_safeUrl;
};


class CONTENT_EXPORT VisibleSecurityState : public ::crdtp::ProtocolObject<VisibleSecurityState> {
public:
    ~VisibleSecurityState() override;  // Defined below

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value);  // Defined below

    bool HasCertificateSecurityState() { return !!m_certificateSecurityState; }
    protocol::Security::CertificateSecurityState* GetCertificateSecurityState(protocol::Security::CertificateSecurityState* defaultValue) {
       return m_certificateSecurityState ? m_certificateSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::CertificateSecurityState>& GetCertificateSecurityState() const {
       return m_certificateSecurityState;
    }
    void SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

    bool HasSafetyTipInfo() { return !!m_safetyTipInfo; }
    protocol::Security::SafetyTipInfo* GetSafetyTipInfo(protocol::Security::SafetyTipInfo* defaultValue) {
       return m_safetyTipInfo ? m_safetyTipInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::SafetyTipInfo>& GetSafetyTipInfo() const {
       return m_safetyTipInfo;
    }
    void SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

    protocol::Array<String>* GetSecurityStateIssueIds() { return m_securityStateIssueIds.get(); }
    void SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class VisibleSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            SecurityStateIssueIdsSet = 1 << 2,
            AllFieldsSet = (SecurityStateSet | SecurityStateIssueIdsSet | 0)};


        VisibleSecurityStateBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

        VisibleSecurityStateBuilder<STATE | SecurityStateIssueIdsSet>& SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<VisibleSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VisibleSecurityState;
        VisibleSecurityStateBuilder() : m_result(new VisibleSecurityState()) { }

        template<int STEP> VisibleSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VisibleSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::VisibleSecurityState> m_result;
    };

    static VisibleSecurityStateBuilder<0> Create()
    {
        return VisibleSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VisibleSecurityState();  // Defined below

    String m_securityState;
    std::unique_ptr<protocol::Security::CertificateSecurityState> m_certificateSecurityState;
    std::unique_ptr<protocol::Security::SafetyTipInfo> m_safetyTipInfo;
    std::unique_ptr<protocol::Array<String>> m_securityStateIssueIds;
};


class CONTENT_EXPORT SecurityStateExplanation : public ::crdtp::ProtocolObject<SecurityStateExplanation> {
public:
    ~SecurityStateExplanation() override;  // Defined below

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value);  // Defined below

    String GetTitle() { return m_title; }
    void SetTitle(const String& value);  // Defined below

    String GetSummary() { return m_summary; }
    void SetSummary(const String& value);  // Defined below

    String GetDescription() { return m_description; }
    void SetDescription(const String& value);  // Defined below

    String GetMixedContentType() { return m_mixedContentType; }
    void SetMixedContentType(const String& value);  // Defined below

    protocol::Array<String>* GetCertificate() { return m_certificate.get(); }
    void SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    bool HasRecommendations() { return !!m_recommendations; }
    protocol::Array<String>* GetRecommendations(protocol::Array<String>* defaultValue) {
       return m_recommendations ? m_recommendations.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetRecommendations() const {
       return m_recommendations;
    }
    void SetRecommendations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class SecurityStateExplanationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            TitleSet = 1 << 2,
            SummarySet = 1 << 3,
            DescriptionSet = 1 << 4,
            MixedContentTypeSet = 1 << 5,
            CertificateSet = 1 << 6,
            AllFieldsSet = (SecurityStateSet | TitleSet | SummarySet | DescriptionSet | MixedContentTypeSet | CertificateSet | 0)};


        SecurityStateExplanationBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | TitleSet>& SetTitle(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | SummarySet>& SetSummary(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | DescriptionSet>& SetDescription(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | MixedContentTypeSet>& SetMixedContentType(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | CertificateSet>& SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        SecurityStateExplanationBuilder<STATE>& SetRecommendations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<SecurityStateExplanation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityStateExplanation;
        SecurityStateExplanationBuilder() : m_result(new SecurityStateExplanation()) { }

        template<int STEP> SecurityStateExplanationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityStateExplanationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SecurityStateExplanation> m_result;
    };

    static SecurityStateExplanationBuilder<0> Create()
    {
        return SecurityStateExplanationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityStateExplanation();  // Defined below

    String m_securityState;
    String m_title;
    String m_summary;
    String m_description;
    String m_mixedContentType;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    std::unique_ptr<protocol::Array<String>> m_recommendations;
};


class CONTENT_EXPORT InsecureContentStatus : public ::crdtp::ProtocolObject<InsecureContentStatus> {
public:
    ~InsecureContentStatus() override;  // Defined below

    bool GetRanMixedContent() { return m_ranMixedContent; }
    void SetRanMixedContent(bool value);  // Defined below

    bool GetDisplayedMixedContent() { return m_displayedMixedContent; }
    void SetDisplayedMixedContent(bool value);  // Defined below

    bool GetContainedMixedForm() { return m_containedMixedForm; }
    void SetContainedMixedForm(bool value);  // Defined below

    bool GetRanContentWithCertErrors() { return m_ranContentWithCertErrors; }
    void SetRanContentWithCertErrors(bool value);  // Defined below

    bool GetDisplayedContentWithCertErrors() { return m_displayedContentWithCertErrors; }
    void SetDisplayedContentWithCertErrors(bool value);  // Defined below

    String GetRanInsecureContentStyle() { return m_ranInsecureContentStyle; }
    void SetRanInsecureContentStyle(const String& value);  // Defined below

    String GetDisplayedInsecureContentStyle() { return m_displayedInsecureContentStyle; }
    void SetDisplayedInsecureContentStyle(const String& value);  // Defined below

    template<int STATE>
    class InsecureContentStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RanMixedContentSet = 1 << 1,
            DisplayedMixedContentSet = 1 << 2,
            ContainedMixedFormSet = 1 << 3,
            RanContentWithCertErrorsSet = 1 << 4,
            DisplayedContentWithCertErrorsSet = 1 << 5,
            RanInsecureContentStyleSet = 1 << 6,
            DisplayedInsecureContentStyleSet = 1 << 7,
            AllFieldsSet = (RanMixedContentSet | DisplayedMixedContentSet | ContainedMixedFormSet | RanContentWithCertErrorsSet | DisplayedContentWithCertErrorsSet | RanInsecureContentStyleSet | DisplayedInsecureContentStyleSet | 0)};


        InsecureContentStatusBuilder<STATE | RanMixedContentSet>& SetRanMixedContent(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedMixedContentSet>& SetDisplayedMixedContent(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | ContainedMixedFormSet>& SetContainedMixedForm(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | RanContentWithCertErrorsSet>& SetRanContentWithCertErrors(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedContentWithCertErrorsSet>& SetDisplayedContentWithCertErrors(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | RanInsecureContentStyleSet>& SetRanInsecureContentStyle(const String& value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedInsecureContentStyleSet>& SetDisplayedInsecureContentStyle(const String& value);  // Defined below

        std::unique_ptr<InsecureContentStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InsecureContentStatus;
        InsecureContentStatusBuilder() : m_result(new InsecureContentStatus()) { }

        template<int STEP> InsecureContentStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InsecureContentStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::InsecureContentStatus> m_result;
    };

    static InsecureContentStatusBuilder<0> Create()
    {
        return InsecureContentStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InsecureContentStatus();  // Defined below

    bool m_ranMixedContent;
    bool m_displayedMixedContent;
    bool m_containedMixedForm;
    bool m_ranContentWithCertErrors;
    bool m_displayedContentWithCertErrors;
    String m_ranInsecureContentStyle;
    String m_displayedInsecureContentStyle;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline CertificateSecurityState::~CertificateSecurityState() = default;
inline void CertificateSecurityState::SetProtocol(const String& value) { m_protocol = value; }
inline void CertificateSecurityState::SetKeyExchange(const String& value) { m_keyExchange = value; }
inline void CertificateSecurityState::SetKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }
inline void CertificateSecurityState::SetCipher(const String& value) { m_cipher = value; }
inline void CertificateSecurityState::SetMac(const String& value) { m_mac = value; }
inline void CertificateSecurityState::SetCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }
inline void CertificateSecurityState::SetSubjectName(const String& value) { m_subjectName = value; }
inline void CertificateSecurityState::SetIssuer(const String& value) { m_issuer = value; }
inline void CertificateSecurityState::SetValidFrom(double value) { m_validFrom = value; }
inline void CertificateSecurityState::SetValidTo(double value) { m_validTo = value; }
inline void CertificateSecurityState::SetCertificateNetworkError(const String& value) { m_certificateNetworkError = value; }
inline void CertificateSecurityState::SetCertificateHasWeakSignature(bool value) { m_certificateHasWeakSignature = value; }
inline void CertificateSecurityState::SetCertificateHasSha1Signature(bool value) { m_certificateHasSha1Signature = value; }
inline void CertificateSecurityState::SetModernSSL(bool value) { m_modernSSL = value; }
inline void CertificateSecurityState::SetObsoleteSslProtocol(bool value) { m_obsoleteSslProtocol = value; }
inline void CertificateSecurityState::SetObsoleteSslKeyExchange(bool value) { m_obsoleteSslKeyExchange = value; }
inline void CertificateSecurityState::SetObsoleteSslCipher(bool value) { m_obsoleteSslCipher = value; }
inline void CertificateSecurityState::SetObsoleteSslSignature(bool value) { m_obsoleteSslSignature = value; }

template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetProtocol(const String& value) {
  static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
  m_result->SetProtocol(value);
  return castState<ProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::KeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetKeyExchange(const String& value) {
  static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
  m_result->SetKeyExchange(value);
  return castState<KeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetKeyExchangeGroup(const String& value) {
  m_result->SetKeyExchangeGroup(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCipher(const String& value) {
  static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
  m_result->SetCipher(value);
  return castState<CipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetMac(const String& value) {
  m_result->SetMac(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificate(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
  m_result->SetCertificate(std::move(value));
  return castState<CertificateSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SubjectNameSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetSubjectName(const String& value) {
  static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
  m_result->SetSubjectName(value);
  return castState<SubjectNameSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::IssuerSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetIssuer(const String& value) {
  static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
  m_result->SetIssuer(value);
  return castState<IssuerSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidFromSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetValidFrom(double value) {
  static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
  m_result->SetValidFrom(value);
  return castState<ValidFromSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidToSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetValidTo(double value) {
  static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
  m_result->SetValidTo(value);
  return castState<ValidToSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateNetworkError(const String& value) {
  m_result->SetCertificateNetworkError(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasWeakSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateHasWeakSignature(bool value) {
  static_assert(!(STATE & CertificateHasWeakSignatureSet), "property certificateHasWeakSignature should not be set yet");
  m_result->SetCertificateHasWeakSignature(value);
  return castState<CertificateHasWeakSignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasSha1SignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateHasSha1Signature(bool value) {
  static_assert(!(STATE & CertificateHasSha1SignatureSet), "property certificateHasSha1Signature should not be set yet");
  m_result->SetCertificateHasSha1Signature(value);
  return castState<CertificateHasSha1SignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ModernSSLSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetModernSSL(bool value) {
  static_assert(!(STATE & ModernSSLSet), "property modernSSL should not be set yet");
  m_result->SetModernSSL(value);
  return castState<ModernSSLSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslProtocol(bool value) {
  static_assert(!(STATE & ObsoleteSslProtocolSet), "property obsoleteSslProtocol should not be set yet");
  m_result->SetObsoleteSslProtocol(value);
  return castState<ObsoleteSslProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslKeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslKeyExchange(bool value) {
  static_assert(!(STATE & ObsoleteSslKeyExchangeSet), "property obsoleteSslKeyExchange should not be set yet");
  m_result->SetObsoleteSslKeyExchange(value);
  return castState<ObsoleteSslKeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslCipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslCipher(bool value) {
  static_assert(!(STATE & ObsoleteSslCipherSet), "property obsoleteSslCipher should not be set yet");
  m_result->SetObsoleteSslCipher(value);
  return castState<ObsoleteSslCipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslSignature(bool value) {
  static_assert(!(STATE & ObsoleteSslSignatureSet), "property obsoleteSslSignature should not be set yet");
  m_result->SetObsoleteSslSignature(value);
  return castState<ObsoleteSslSignatureSet>();
}

inline CertificateSecurityState::CertificateSecurityState() {
  m_validFrom = 0;
  m_validTo = 0;
  m_certificateHasWeakSignature = false;
  m_certificateHasSha1Signature = false;
  m_modernSSL = false;
  m_obsoleteSslProtocol = false;
  m_obsoleteSslKeyExchange = false;
  m_obsoleteSslCipher = false;
  m_obsoleteSslSignature = false;
}
inline SafetyTipInfo::~SafetyTipInfo() = default;
inline void SafetyTipInfo::SetSafetyTipStatus(const String& value) { m_safetyTipStatus = value; }
inline void SafetyTipInfo::SetSafeUrl(const String& value) { m_safeUrl = value; }

template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE | SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SafetyTipStatusSet>&
SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SetSafetyTipStatus(const String& value) {
  static_assert(!(STATE & SafetyTipStatusSet), "property safetyTipStatus should not be set yet");
  m_result->SetSafetyTipStatus(value);
  return castState<SafetyTipStatusSet>();
}
template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE>& SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SetSafeUrl(const String& value) {
  m_result->SetSafeUrl(value);
  return *this;
}

inline SafetyTipInfo::SafetyTipInfo() {
}
inline VisibleSecurityState::~VisibleSecurityState() = default;
inline void VisibleSecurityState::SetSecurityState(const String& value) { m_securityState = value; }
inline void VisibleSecurityState::SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) { m_certificateSecurityState = std::move(value); }
inline void VisibleSecurityState::SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) { m_safetyTipInfo = std::move(value); }
inline void VisibleSecurityState::SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) { m_securityStateIssueIds = std::move(value); }

template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSecurityState(const String& value) {
  static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
  m_result->SetSecurityState(value);
  return castState<SecurityStateSet>();
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) {
  m_result->SetCertificateSecurityState(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) {
  m_result->SetSafetyTipInfo(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateIssueIdsSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & SecurityStateIssueIdsSet), "property securityStateIssueIds should not be set yet");
  m_result->SetSecurityStateIssueIds(std::move(value));
  return castState<SecurityStateIssueIdsSet>();
}

inline VisibleSecurityState::VisibleSecurityState() {
}
inline SecurityStateExplanation::~SecurityStateExplanation() = default;
inline void SecurityStateExplanation::SetSecurityState(const String& value) { m_securityState = value; }
inline void SecurityStateExplanation::SetTitle(const String& value) { m_title = value; }
inline void SecurityStateExplanation::SetSummary(const String& value) { m_summary = value; }
inline void SecurityStateExplanation::SetDescription(const String& value) { m_description = value; }
inline void SecurityStateExplanation::SetMixedContentType(const String& value) { m_mixedContentType = value; }
inline void SecurityStateExplanation::SetCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }
inline void SecurityStateExplanation::SetRecommendations(std::unique_ptr<protocol::Array<String>> value) { m_recommendations = std::move(value); }

template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SecurityStateSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetSecurityState(const String& value) {
  static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
  m_result->SetSecurityState(value);
  return castState<SecurityStateSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::TitleSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetTitle(const String& value) {
  static_assert(!(STATE & TitleSet), "property title should not be set yet");
  m_result->SetTitle(value);
  return castState<TitleSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SummarySet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetSummary(const String& value) {
  static_assert(!(STATE & SummarySet), "property summary should not be set yet");
  m_result->SetSummary(value);
  return castState<SummarySet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::DescriptionSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetDescription(const String& value) {
  static_assert(!(STATE & DescriptionSet), "property description should not be set yet");
  m_result->SetDescription(value);
  return castState<DescriptionSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::MixedContentTypeSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetMixedContentType(const String& value) {
  static_assert(!(STATE & MixedContentTypeSet), "property mixedContentType should not be set yet");
  m_result->SetMixedContentType(value);
  return castState<MixedContentTypeSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::CertificateSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetCertificate(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
  m_result->SetCertificate(std::move(value));
  return castState<CertificateSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>& SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SetRecommendations(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetRecommendations(std::move(value));
  return *this;
}

inline SecurityStateExplanation::SecurityStateExplanation() {
}
inline InsecureContentStatus::~InsecureContentStatus() = default;
inline void InsecureContentStatus::SetRanMixedContent(bool value) { m_ranMixedContent = value; }
inline void InsecureContentStatus::SetDisplayedMixedContent(bool value) { m_displayedMixedContent = value; }
inline void InsecureContentStatus::SetContainedMixedForm(bool value) { m_containedMixedForm = value; }
inline void InsecureContentStatus::SetRanContentWithCertErrors(bool value) { m_ranContentWithCertErrors = value; }
inline void InsecureContentStatus::SetDisplayedContentWithCertErrors(bool value) { m_displayedContentWithCertErrors = value; }
inline void InsecureContentStatus::SetRanInsecureContentStyle(const String& value) { m_ranInsecureContentStyle = value; }
inline void InsecureContentStatus::SetDisplayedInsecureContentStyle(const String& value) { m_displayedInsecureContentStyle = value; }

template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanMixedContentSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetRanMixedContent(bool value) {
  static_assert(!(STATE & RanMixedContentSet), "property ranMixedContent should not be set yet");
  m_result->SetRanMixedContent(value);
  return castState<RanMixedContentSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedMixedContentSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetDisplayedMixedContent(bool value) {
  static_assert(!(STATE & DisplayedMixedContentSet), "property displayedMixedContent should not be set yet");
  m_result->SetDisplayedMixedContent(value);
  return castState<DisplayedMixedContentSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::ContainedMixedFormSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetContainedMixedForm(bool value) {
  static_assert(!(STATE & ContainedMixedFormSet), "property containedMixedForm should not be set yet");
  m_result->SetContainedMixedForm(value);
  return castState<ContainedMixedFormSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanContentWithCertErrorsSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetRanContentWithCertErrors(bool value) {
  static_assert(!(STATE & RanContentWithCertErrorsSet), "property ranContentWithCertErrors should not be set yet");
  m_result->SetRanContentWithCertErrors(value);
  return castState<RanContentWithCertErrorsSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedContentWithCertErrorsSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetDisplayedContentWithCertErrors(bool value) {
  static_assert(!(STATE & DisplayedContentWithCertErrorsSet), "property displayedContentWithCertErrors should not be set yet");
  m_result->SetDisplayedContentWithCertErrors(value);
  return castState<DisplayedContentWithCertErrorsSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanInsecureContentStyleSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetRanInsecureContentStyle(const String& value) {
  static_assert(!(STATE & RanInsecureContentStyleSet), "property ranInsecureContentStyle should not be set yet");
  m_result->SetRanInsecureContentStyle(value);
  return castState<RanInsecureContentStyleSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedInsecureContentStyleSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::SetDisplayedInsecureContentStyle(const String& value) {
  static_assert(!(STATE & DisplayedInsecureContentStyleSet), "property displayedInsecureContentStyle should not be set yet");
  m_result->SetDisplayedInsecureContentStyle(value);
  return castState<DisplayedInsecureContentStyleSet>();
}

inline InsecureContentStatus::InsecureContentStatus() {
  m_ranMixedContent = false;
  m_displayedMixedContent = false;
  m_containedMixedForm = false;
  m_ranContentWithCertErrors = false;
  m_displayedContentWithCertErrors = false;
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse SetIgnoreCertificateErrors(bool in_ignore) = 0;
    virtual DispatchResponse HandleCertificateError(int in_eventId, const String& in_action) = 0;
    virtual DispatchResponse SetOverrideCertificateErrors(bool in_override) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CertificateError(int eventId, const String& errorType, const String& requestURL);
    void VisibleSecurityStateChanged(std::unique_ptr<protocol::Security::VisibleSecurityState> visibleSecurityState);
    void SecurityStateChanged(const String& securityState, bool schemeIsCryptographic, std::unique_ptr<protocol::Array<protocol::Security::SecurityStateExplanation>> explanations, std::unique_ptr<protocol::Security::InsecureContentStatus> insecureContentStatus, std::optional<String> summary = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Security
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Security_h)
