// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_FedCm_h
#define content_protocol_FedCm_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace FedCm {
using LoginState = String;
using DialogType = String;
using DialogButton = String;
using AccountUrlType = String;
class Account;

// ------------- Forward and enum declarations.

namespace LoginStateEnum {
CONTENT_EXPORT extern const char SignIn[];
CONTENT_EXPORT extern const char SignUp[];
} // namespace LoginStateEnum

namespace DialogTypeEnum {
CONTENT_EXPORT extern const char AccountChooser[];
CONTENT_EXPORT extern const char AutoReauthn[];
CONTENT_EXPORT extern const char ConfirmIdpLogin[];
CONTENT_EXPORT extern const char Error[];
} // namespace DialogTypeEnum

namespace DialogButtonEnum {
CONTENT_EXPORT extern const char ConfirmIdpLoginContinue[];
CONTENT_EXPORT extern const char ErrorGotIt[];
CONTENT_EXPORT extern const char ErrorMoreDetails[];
} // namespace DialogButtonEnum

namespace AccountUrlTypeEnum {
CONTENT_EXPORT extern const char TermsOfService[];
CONTENT_EXPORT extern const char PrivacyPolicy[];
} // namespace AccountUrlTypeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT Account : public ::crdtp::ProtocolObject<Account> {
public:
    ~Account() override;  // Defined below

    String GetAccountId() { return m_accountId; }
    void SetAccountId(const String& value);  // Defined below

    String GetEmail() { return m_email; }
    void SetEmail(const String& value);  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetGivenName() { return m_givenName; }
    void SetGivenName(const String& value);  // Defined below

    String GetPictureUrl() { return m_pictureUrl; }
    void SetPictureUrl(const String& value);  // Defined below

    String GetIdpConfigUrl() { return m_idpConfigUrl; }
    void SetIdpConfigUrl(const String& value);  // Defined below

    String GetIdpLoginUrl() { return m_idpLoginUrl; }
    void SetIdpLoginUrl(const String& value);  // Defined below

    String GetLoginState() { return m_loginState; }
    void SetLoginState(const String& value);  // Defined below

    bool HasTermsOfServiceUrl() { return !!m_termsOfServiceUrl; }
    String GetTermsOfServiceUrl(const String& defaultValue) const {
       return m_termsOfServiceUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetTermsOfServiceUrl() const {
       return m_termsOfServiceUrl;
    }
    void SetTermsOfServiceUrl(const String& value);  // Defined below

    bool HasPrivacyPolicyUrl() { return !!m_privacyPolicyUrl; }
    String GetPrivacyPolicyUrl(const String& defaultValue) const {
       return m_privacyPolicyUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetPrivacyPolicyUrl() const {
       return m_privacyPolicyUrl;
    }
    void SetPrivacyPolicyUrl(const String& value);  // Defined below

    template<int STATE>
    class AccountBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AccountIdSet = 1 << 1,
            EmailSet = 1 << 2,
            NameSet = 1 << 3,
            GivenNameSet = 1 << 4,
            PictureUrlSet = 1 << 5,
            IdpConfigUrlSet = 1 << 6,
            IdpLoginUrlSet = 1 << 7,
            LoginStateSet = 1 << 8,
            AllFieldsSet = (AccountIdSet | EmailSet | NameSet | GivenNameSet | PictureUrlSet | IdpConfigUrlSet | IdpLoginUrlSet | LoginStateSet | 0)};


        AccountBuilder<STATE | AccountIdSet>& SetAccountId(const String& value);  // Defined below

        AccountBuilder<STATE | EmailSet>& SetEmail(const String& value);  // Defined below

        AccountBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        AccountBuilder<STATE | GivenNameSet>& SetGivenName(const String& value);  // Defined below

        AccountBuilder<STATE | PictureUrlSet>& SetPictureUrl(const String& value);  // Defined below

        AccountBuilder<STATE | IdpConfigUrlSet>& SetIdpConfigUrl(const String& value);  // Defined below

        AccountBuilder<STATE | IdpLoginUrlSet>& SetIdpLoginUrl(const String& value);  // Defined below

        AccountBuilder<STATE | LoginStateSet>& SetLoginState(const String& value);  // Defined below

        AccountBuilder<STATE>& SetTermsOfServiceUrl(const String& value);  // Defined below

        AccountBuilder<STATE>& SetPrivacyPolicyUrl(const String& value);  // Defined below

        std::unique_ptr<Account> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Account;
        AccountBuilder() : m_result(new Account()) { }

        template<int STEP> AccountBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AccountBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::FedCm::Account> m_result;
    };

    static AccountBuilder<0> Create()
    {
        return AccountBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Account();  // Defined below

    String m_accountId;
    String m_email;
    String m_name;
    String m_givenName;
    String m_pictureUrl;
    String m_idpConfigUrl;
    String m_idpLoginUrl;
    String m_loginState;
    std::optional<String> m_termsOfServiceUrl;
    std::optional<String> m_privacyPolicyUrl;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Account::~Account() = default;
inline void Account::SetAccountId(const String& value) { m_accountId = value; }
inline void Account::SetEmail(const String& value) { m_email = value; }
inline void Account::SetName(const String& value) { m_name = value; }
inline void Account::SetGivenName(const String& value) { m_givenName = value; }
inline void Account::SetPictureUrl(const String& value) { m_pictureUrl = value; }
inline void Account::SetIdpConfigUrl(const String& value) { m_idpConfigUrl = value; }
inline void Account::SetIdpLoginUrl(const String& value) { m_idpLoginUrl = value; }
inline void Account::SetLoginState(const String& value) { m_loginState = value; }
inline void Account::SetTermsOfServiceUrl(const String& value) { m_termsOfServiceUrl = value; }
inline void Account::SetPrivacyPolicyUrl(const String& value) { m_privacyPolicyUrl = value; }

template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::AccountIdSet>&
Account::AccountBuilder<STATE>::SetAccountId(const String& value) {
  static_assert(!(STATE & AccountIdSet), "property accountId should not be set yet");
  m_result->SetAccountId(value);
  return castState<AccountIdSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::EmailSet>&
Account::AccountBuilder<STATE>::SetEmail(const String& value) {
  static_assert(!(STATE & EmailSet), "property email should not be set yet");
  m_result->SetEmail(value);
  return castState<EmailSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::NameSet>&
Account::AccountBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::GivenNameSet>&
Account::AccountBuilder<STATE>::SetGivenName(const String& value) {
  static_assert(!(STATE & GivenNameSet), "property givenName should not be set yet");
  m_result->SetGivenName(value);
  return castState<GivenNameSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::PictureUrlSet>&
Account::AccountBuilder<STATE>::SetPictureUrl(const String& value) {
  static_assert(!(STATE & PictureUrlSet), "property pictureUrl should not be set yet");
  m_result->SetPictureUrl(value);
  return castState<PictureUrlSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::IdpConfigUrlSet>&
Account::AccountBuilder<STATE>::SetIdpConfigUrl(const String& value) {
  static_assert(!(STATE & IdpConfigUrlSet), "property idpConfigUrl should not be set yet");
  m_result->SetIdpConfigUrl(value);
  return castState<IdpConfigUrlSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::IdpLoginUrlSet>&
Account::AccountBuilder<STATE>::SetIdpLoginUrl(const String& value) {
  static_assert(!(STATE & IdpLoginUrlSet), "property idpLoginUrl should not be set yet");
  m_result->SetIdpLoginUrl(value);
  return castState<IdpLoginUrlSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE | Account::AccountBuilder<STATE>::LoginStateSet>&
Account::AccountBuilder<STATE>::SetLoginState(const String& value) {
  static_assert(!(STATE & LoginStateSet), "property loginState should not be set yet");
  m_result->SetLoginState(value);
  return castState<LoginStateSet>();
}
template<int STATE>
inline Account::AccountBuilder<STATE>& Account::AccountBuilder<STATE>::SetTermsOfServiceUrl(const String& value) {
  m_result->SetTermsOfServiceUrl(value);
  return *this;
}
template<int STATE>
inline Account::AccountBuilder<STATE>& Account::AccountBuilder<STATE>::SetPrivacyPolicyUrl(const String& value) {
  m_result->SetPrivacyPolicyUrl(value);
  return *this;
}

inline Account::Account() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable(std::optional<bool> in_disableRejectionDelay) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse SelectAccount(const String& in_dialogId, int in_accountIndex) = 0;
    virtual DispatchResponse ClickDialogButton(const String& in_dialogId, const String& in_dialogButton) = 0;
    virtual DispatchResponse OpenUrl(const String& in_dialogId, int in_accountIndex, const String& in_accountUrlType) = 0;
    virtual DispatchResponse DismissDialog(const String& in_dialogId, std::optional<bool> in_triggerCooldown) = 0;
    virtual DispatchResponse ResetCooldown() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void DialogShown(const String& dialogId, const String& dialogType, std::unique_ptr<protocol::Array<protocol::FedCm::Account>> accounts, const String& title, std::optional<String> subtitle = {});
    void DialogClosed(const String& dialogId);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace FedCm
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_FedCm_h)
