// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Emulation_h
#define content_protocol_Emulation_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/page.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Emulation {
class ScreenOrientation;
class DisplayFeature;
class DevicePosture;
class MediaFeature;
class UserAgentBrandVersion;
class UserAgentMetadata;
using SensorType = String;
class SensorMetadata;
class SensorReadingSingle;
class SensorReadingXYZ;
class SensorReadingQuaternion;
class SensorReading;
using PressureSource = String;
using PressureState = String;
class PressureMetadata;

// ------------- Forward and enum declarations.

namespace SensorTypeEnum {
CONTENT_EXPORT extern const char AbsoluteOrientation[];
CONTENT_EXPORT extern const char Accelerometer[];
CONTENT_EXPORT extern const char AmbientLight[];
CONTENT_EXPORT extern const char Gravity[];
CONTENT_EXPORT extern const char Gyroscope[];
CONTENT_EXPORT extern const char LinearAcceleration[];
CONTENT_EXPORT extern const char Magnetometer[];
CONTENT_EXPORT extern const char RelativeOrientation[];
} // namespace SensorTypeEnum

namespace PressureSourceEnum {
CONTENT_EXPORT extern const char Cpu[];
} // namespace PressureSourceEnum

namespace PressureStateEnum {
CONTENT_EXPORT extern const char Nominal[];
CONTENT_EXPORT extern const char Fair[];
CONTENT_EXPORT extern const char Serious[];
CONTENT_EXPORT extern const char Critical[];
} // namespace PressureStateEnum

namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
CONTENT_EXPORT extern const char* Mobile;
CONTENT_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
CONTENT_EXPORT extern const char* None;
CONTENT_EXPORT extern const char* BlurredVision;
CONTENT_EXPORT extern const char* ReducedContrast;
CONTENT_EXPORT extern const char* Achromatopsia;
CONTENT_EXPORT extern const char* Deuteranopia;
CONTENT_EXPORT extern const char* Protanopia;
CONTENT_EXPORT extern const char* Tritanopia;
} // TypeEnum
} // SetEmulatedVisionDeficiency

// ------------- Type and builder declarations.

class CONTENT_EXPORT ScreenOrientation : public ::crdtp::ProtocolObject<ScreenOrientation> {
public:
    ~ScreenOrientation() override;  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* PortraitPrimary;
        static const char* PortraitSecondary;
        static const char* LandscapePrimary;
        static const char* LandscapeSecondary;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    int GetAngle() { return m_angle; }
    void SetAngle(int value);  // Defined below

    template<int STATE>
    class ScreenOrientationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AngleSet = 1 << 2,
            AllFieldsSet = (TypeSet | AngleSet | 0)};


        ScreenOrientationBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        ScreenOrientationBuilder<STATE | AngleSet>& SetAngle(int value);  // Defined below

        std::unique_ptr<ScreenOrientation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenOrientation;
        ScreenOrientationBuilder() : m_result(new ScreenOrientation()) { }

        template<int STEP> ScreenOrientationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenOrientationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenOrientation> m_result;
    };

    static ScreenOrientationBuilder<0> Create()
    {
        return ScreenOrientationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenOrientation();  // Defined below

    String m_type;
    int m_angle;
};


class CONTENT_EXPORT DisplayFeature : public ::crdtp::ProtocolObject<DisplayFeature> {
public:
    ~DisplayFeature() override;  // Defined below

    struct CONTENT_EXPORT OrientationEnum {
        static const char* Vertical;
        static const char* Horizontal;
    }; // OrientationEnum

    String GetOrientation() { return m_orientation; }
    void SetOrientation(const String& value);  // Defined below

    int GetOffset() { return m_offset; }
    void SetOffset(int value);  // Defined below

    int GetMaskLength() { return m_maskLength; }
    void SetMaskLength(int value);  // Defined below

    template<int STATE>
    class DisplayFeatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OrientationSet = 1 << 1,
            OffsetSet = 1 << 2,
            MaskLengthSet = 1 << 3,
            AllFieldsSet = (OrientationSet | OffsetSet | MaskLengthSet | 0)};


        DisplayFeatureBuilder<STATE | OrientationSet>& SetOrientation(const String& value);  // Defined below

        DisplayFeatureBuilder<STATE | OffsetSet>& SetOffset(int value);  // Defined below

        DisplayFeatureBuilder<STATE | MaskLengthSet>& SetMaskLength(int value);  // Defined below

        std::unique_ptr<DisplayFeature> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DisplayFeature;
        DisplayFeatureBuilder() : m_result(new DisplayFeature()) { }

        template<int STEP> DisplayFeatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DisplayFeatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::DisplayFeature> m_result;
    };

    static DisplayFeatureBuilder<0> Create()
    {
        return DisplayFeatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DisplayFeature();  // Defined below

    String m_orientation;
    int m_offset;
    int m_maskLength;
};


class CONTENT_EXPORT DevicePosture : public ::crdtp::ProtocolObject<DevicePosture> {
public:
    ~DevicePosture() override;  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* Continuous;
        static const char* Folded;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    template<int STATE>
    class DevicePostureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        DevicePostureBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        std::unique_ptr<DevicePosture> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DevicePosture;
        DevicePostureBuilder() : m_result(new DevicePosture()) { }

        template<int STEP> DevicePostureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DevicePostureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::DevicePosture> m_result;
    };

    static DevicePostureBuilder<0> Create()
    {
        return DevicePostureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DevicePosture();  // Defined below

    String m_type;
};


class CONTENT_EXPORT MediaFeature : public ::crdtp::ProtocolObject<MediaFeature> {
public:
    ~MediaFeature() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetValue() { return m_value; }
    void SetValue(const String& value);  // Defined below

    template<int STATE>
    class MediaFeatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        MediaFeatureBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        MediaFeatureBuilder<STATE | ValueSet>& SetValue(const String& value);  // Defined below

        std::unique_ptr<MediaFeature> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MediaFeature;
        MediaFeatureBuilder() : m_result(new MediaFeature()) { }

        template<int STEP> MediaFeatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MediaFeatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::MediaFeature> m_result;
    };

    static MediaFeatureBuilder<0> Create()
    {
        return MediaFeatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MediaFeature();  // Defined below

    String m_name;
    String m_value;
};


class CONTENT_EXPORT UserAgentBrandVersion : public ::crdtp::ProtocolObject<UserAgentBrandVersion> {
public:
    ~UserAgentBrandVersion() override;  // Defined below

    String GetBrand() { return m_brand; }
    void SetBrand(const String& value);  // Defined below

    String GetVersion() { return m_version; }
    void SetVersion(const String& value);  // Defined below

    template<int STATE>
    class UserAgentBrandVersionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BrandSet = 1 << 1,
            VersionSet = 1 << 2,
            AllFieldsSet = (BrandSet | VersionSet | 0)};


        UserAgentBrandVersionBuilder<STATE | BrandSet>& SetBrand(const String& value);  // Defined below

        UserAgentBrandVersionBuilder<STATE | VersionSet>& SetVersion(const String& value);  // Defined below

        std::unique_ptr<UserAgentBrandVersion> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentBrandVersion;
        UserAgentBrandVersionBuilder() : m_result(new UserAgentBrandVersion()) { }

        template<int STEP> UserAgentBrandVersionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentBrandVersionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentBrandVersion> m_result;
    };

    static UserAgentBrandVersionBuilder<0> Create()
    {
        return UserAgentBrandVersionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentBrandVersion();  // Defined below

    String m_brand;
    String m_version;
};


class CONTENT_EXPORT UserAgentMetadata : public ::crdtp::ProtocolObject<UserAgentMetadata> {
public:
    ~UserAgentMetadata() override;  // Defined below

    bool HasBrands() { return !!m_brands; }
    protocol::Array<protocol::Emulation::UserAgentBrandVersion>* GetBrands(protocol::Array<protocol::Emulation::UserAgentBrandVersion>* defaultValue) {
       return m_brands ? m_brands.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>>& GetBrands() const {
       return m_brands;
    }
    void SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value);  // Defined below

    bool HasFullVersionList() { return !!m_fullVersionList; }
    protocol::Array<protocol::Emulation::UserAgentBrandVersion>* GetFullVersionList(protocol::Array<protocol::Emulation::UserAgentBrandVersion>* defaultValue) {
       return m_fullVersionList ? m_fullVersionList.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>>& GetFullVersionList() const {
       return m_fullVersionList;
    }
    void SetFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value);  // Defined below

    bool HasFullVersion() { return !!m_fullVersion; }
    String GetFullVersion(const String& defaultValue) const {
       return m_fullVersion.value_or(defaultValue);
    }
    const std::optional<String>& GetFullVersion() const {
       return m_fullVersion;
    }
    void SetFullVersion(const String& value);  // Defined below

    String GetPlatform() { return m_platform; }
    void SetPlatform(const String& value);  // Defined below

    String GetPlatformVersion() { return m_platformVersion; }
    void SetPlatformVersion(const String& value);  // Defined below

    String GetArchitecture() { return m_architecture; }
    void SetArchitecture(const String& value);  // Defined below

    String GetModel() { return m_model; }
    void SetModel(const String& value);  // Defined below

    bool GetMobile() { return m_mobile; }
    void SetMobile(bool value);  // Defined below

    bool HasBitness() { return !!m_bitness; }
    String GetBitness(const String& defaultValue) const {
       return m_bitness.value_or(defaultValue);
    }
    const std::optional<String>& GetBitness() const {
       return m_bitness;
    }
    void SetBitness(const String& value);  // Defined below

    bool HasWow64() { return !!m_wow64; }
    bool GetWow64(bool defaultValue) const {
       return m_wow64.value_or(defaultValue);
    }
    const std::optional<bool>& GetWow64() const {
       return m_wow64;
    }
    void SetWow64(bool value);  // Defined below

    bool HasFormFactors() { return !!m_formFactors; }
    protocol::Array<String>* GetFormFactors(protocol::Array<String>* defaultValue) {
       return m_formFactors ? m_formFactors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetFormFactors() const {
       return m_formFactors;
    }
    void SetFormFactors(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class UserAgentMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PlatformSet = 1 << 1,
            PlatformVersionSet = 1 << 2,
            ArchitectureSet = 1 << 3,
            ModelSet = 1 << 4,
            MobileSet = 1 << 5,
            AllFieldsSet = (PlatformSet | PlatformVersionSet | ArchitectureSet | ModelSet | MobileSet | 0)};


        UserAgentMetadataBuilder<STATE>& SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value);  // Defined below

        UserAgentMetadataBuilder<STATE>& SetFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value);  // Defined below

        UserAgentMetadataBuilder<STATE>& SetFullVersion(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE | PlatformSet>& SetPlatform(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE | PlatformVersionSet>& SetPlatformVersion(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE | ArchitectureSet>& SetArchitecture(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE | ModelSet>& SetModel(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE | MobileSet>& SetMobile(bool value);  // Defined below

        UserAgentMetadataBuilder<STATE>& SetBitness(const String& value);  // Defined below

        UserAgentMetadataBuilder<STATE>& SetWow64(bool value);  // Defined below

        UserAgentMetadataBuilder<STATE>& SetFormFactors(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<UserAgentMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentMetadata;
        UserAgentMetadataBuilder() : m_result(new UserAgentMetadata()) { }

        template<int STEP> UserAgentMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentMetadata> m_result;
    };

    static UserAgentMetadataBuilder<0> Create()
    {
        return UserAgentMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentMetadata();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> m_brands;
    std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> m_fullVersionList;
    std::optional<String> m_fullVersion;
    String m_platform;
    String m_platformVersion;
    String m_architecture;
    String m_model;
    bool m_mobile;
    std::optional<String> m_bitness;
    std::optional<bool> m_wow64;
    std::unique_ptr<protocol::Array<String>> m_formFactors;
};


class CONTENT_EXPORT SensorMetadata : public ::crdtp::ProtocolObject<SensorMetadata> {
public:
    ~SensorMetadata() override;  // Defined below

    bool HasAvailable() { return !!m_available; }
    bool GetAvailable(bool defaultValue) const {
       return m_available.value_or(defaultValue);
    }
    const std::optional<bool>& GetAvailable() const {
       return m_available;
    }
    void SetAvailable(bool value);  // Defined below

    bool HasMinimumFrequency() { return !!m_minimumFrequency; }
    double GetMinimumFrequency(double defaultValue) const {
       return m_minimumFrequency.value_or(defaultValue);
    }
    const std::optional<double>& GetMinimumFrequency() const {
       return m_minimumFrequency;
    }
    void SetMinimumFrequency(double value);  // Defined below

    bool HasMaximumFrequency() { return !!m_maximumFrequency; }
    double GetMaximumFrequency(double defaultValue) const {
       return m_maximumFrequency.value_or(defaultValue);
    }
    const std::optional<double>& GetMaximumFrequency() const {
       return m_maximumFrequency;
    }
    void SetMaximumFrequency(double value);  // Defined below

    template<int STATE>
    class SensorMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SensorMetadataBuilder<STATE>& SetAvailable(bool value);  // Defined below

        SensorMetadataBuilder<STATE>& SetMinimumFrequency(double value);  // Defined below

        SensorMetadataBuilder<STATE>& SetMaximumFrequency(double value);  // Defined below

        std::unique_ptr<SensorMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SensorMetadata;
        SensorMetadataBuilder() : m_result(new SensorMetadata()) { }

        template<int STEP> SensorMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SensorMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SensorMetadata> m_result;
    };

    static SensorMetadataBuilder<0> Create()
    {
        return SensorMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SensorMetadata();  // Defined below

    std::optional<bool> m_available;
    std::optional<double> m_minimumFrequency;
    std::optional<double> m_maximumFrequency;
};


class CONTENT_EXPORT SensorReadingSingle : public ::crdtp::ProtocolObject<SensorReadingSingle> {
public:
    ~SensorReadingSingle() override;  // Defined below

    double GetValue() { return m_value; }
    void SetValue(double value);  // Defined below

    template<int STATE>
    class SensorReadingSingleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            AllFieldsSet = (ValueSet | 0)};


        SensorReadingSingleBuilder<STATE | ValueSet>& SetValue(double value);  // Defined below

        std::unique_ptr<SensorReadingSingle> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SensorReadingSingle;
        SensorReadingSingleBuilder() : m_result(new SensorReadingSingle()) { }

        template<int STEP> SensorReadingSingleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SensorReadingSingleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SensorReadingSingle> m_result;
    };

    static SensorReadingSingleBuilder<0> Create()
    {
        return SensorReadingSingleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SensorReadingSingle();  // Defined below

    double m_value;
};


class CONTENT_EXPORT SensorReadingXYZ : public ::crdtp::ProtocolObject<SensorReadingXYZ> {
public:
    ~SensorReadingXYZ() override;  // Defined below

    double GetX() { return m_x; }
    void SetX(double value);  // Defined below

    double GetY() { return m_y; }
    void SetY(double value);  // Defined below

    double GetZ() { return m_z; }
    void SetZ(double value);  // Defined below

    template<int STATE>
    class SensorReadingXYZBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            ZSet = 1 << 3,
            AllFieldsSet = (XSet | YSet | ZSet | 0)};


        SensorReadingXYZBuilder<STATE | XSet>& SetX(double value);  // Defined below

        SensorReadingXYZBuilder<STATE | YSet>& SetY(double value);  // Defined below

        SensorReadingXYZBuilder<STATE | ZSet>& SetZ(double value);  // Defined below

        std::unique_ptr<SensorReadingXYZ> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SensorReadingXYZ;
        SensorReadingXYZBuilder() : m_result(new SensorReadingXYZ()) { }

        template<int STEP> SensorReadingXYZBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SensorReadingXYZBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SensorReadingXYZ> m_result;
    };

    static SensorReadingXYZBuilder<0> Create()
    {
        return SensorReadingXYZBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SensorReadingXYZ();  // Defined below

    double m_x;
    double m_y;
    double m_z;
};


class CONTENT_EXPORT SensorReadingQuaternion : public ::crdtp::ProtocolObject<SensorReadingQuaternion> {
public:
    ~SensorReadingQuaternion() override;  // Defined below

    double GetX() { return m_x; }
    void SetX(double value);  // Defined below

    double GetY() { return m_y; }
    void SetY(double value);  // Defined below

    double GetZ() { return m_z; }
    void SetZ(double value);  // Defined below

    double GetW() { return m_w; }
    void SetW(double value);  // Defined below

    template<int STATE>
    class SensorReadingQuaternionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            ZSet = 1 << 3,
            WSet = 1 << 4,
            AllFieldsSet = (XSet | YSet | ZSet | WSet | 0)};


        SensorReadingQuaternionBuilder<STATE | XSet>& SetX(double value);  // Defined below

        SensorReadingQuaternionBuilder<STATE | YSet>& SetY(double value);  // Defined below

        SensorReadingQuaternionBuilder<STATE | ZSet>& SetZ(double value);  // Defined below

        SensorReadingQuaternionBuilder<STATE | WSet>& SetW(double value);  // Defined below

        std::unique_ptr<SensorReadingQuaternion> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SensorReadingQuaternion;
        SensorReadingQuaternionBuilder() : m_result(new SensorReadingQuaternion()) { }

        template<int STEP> SensorReadingQuaternionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SensorReadingQuaternionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> m_result;
    };

    static SensorReadingQuaternionBuilder<0> Create()
    {
        return SensorReadingQuaternionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SensorReadingQuaternion();  // Defined below

    double m_x;
    double m_y;
    double m_z;
    double m_w;
};


class CONTENT_EXPORT SensorReading : public ::crdtp::ProtocolObject<SensorReading> {
public:
    ~SensorReading() override;  // Defined below

    bool HasSingle() { return !!m_single; }
    protocol::Emulation::SensorReadingSingle* GetSingle(protocol::Emulation::SensorReadingSingle* defaultValue) {
       return m_single ? m_single.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Emulation::SensorReadingSingle>& GetSingle() const {
       return m_single;
    }
    void SetSingle(std::unique_ptr<protocol::Emulation::SensorReadingSingle> value);  // Defined below

    bool HasXyz() { return !!m_xyz; }
    protocol::Emulation::SensorReadingXYZ* GetXyz(protocol::Emulation::SensorReadingXYZ* defaultValue) {
       return m_xyz ? m_xyz.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Emulation::SensorReadingXYZ>& GetXyz() const {
       return m_xyz;
    }
    void SetXyz(std::unique_ptr<protocol::Emulation::SensorReadingXYZ> value);  // Defined below

    bool HasQuaternion() { return !!m_quaternion; }
    protocol::Emulation::SensorReadingQuaternion* GetQuaternion(protocol::Emulation::SensorReadingQuaternion* defaultValue) {
       return m_quaternion ? m_quaternion.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Emulation::SensorReadingQuaternion>& GetQuaternion() const {
       return m_quaternion;
    }
    void SetQuaternion(std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> value);  // Defined below

    template<int STATE>
    class SensorReadingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SensorReadingBuilder<STATE>& SetSingle(std::unique_ptr<protocol::Emulation::SensorReadingSingle> value);  // Defined below

        SensorReadingBuilder<STATE>& SetXyz(std::unique_ptr<protocol::Emulation::SensorReadingXYZ> value);  // Defined below

        SensorReadingBuilder<STATE>& SetQuaternion(std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> value);  // Defined below

        std::unique_ptr<SensorReading> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SensorReading;
        SensorReadingBuilder() : m_result(new SensorReading()) { }

        template<int STEP> SensorReadingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SensorReadingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SensorReading> m_result;
    };

    static SensorReadingBuilder<0> Create()
    {
        return SensorReadingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SensorReading();  // Defined below

    std::unique_ptr<protocol::Emulation::SensorReadingSingle> m_single;
    std::unique_ptr<protocol::Emulation::SensorReadingXYZ> m_xyz;
    std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> m_quaternion;
};


class CONTENT_EXPORT PressureMetadata : public ::crdtp::ProtocolObject<PressureMetadata> {
public:
    ~PressureMetadata() override;  // Defined below

    bool HasAvailable() { return !!m_available; }
    bool GetAvailable(bool defaultValue) const {
       return m_available.value_or(defaultValue);
    }
    const std::optional<bool>& GetAvailable() const {
       return m_available;
    }
    void SetAvailable(bool value);  // Defined below

    template<int STATE>
    class PressureMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        PressureMetadataBuilder<STATE>& SetAvailable(bool value);  // Defined below

        std::unique_ptr<PressureMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PressureMetadata;
        PressureMetadataBuilder() : m_result(new PressureMetadata()) { }

        template<int STEP> PressureMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PressureMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::PressureMetadata> m_result;
    };

    static PressureMetadataBuilder<0> Create()
    {
        return PressureMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PressureMetadata();  // Defined below

    std::optional<bool> m_available;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ScreenOrientation::~ScreenOrientation() = default;
inline void ScreenOrientation::SetType(const String& value) { m_type = value; }
inline void ScreenOrientation::SetAngle(int value) { m_angle = value; }

template<int STATE>
inline ScreenOrientation::ScreenOrientationBuilder<STATE | ScreenOrientation::ScreenOrientationBuilder<STATE>::TypeSet>&
ScreenOrientation::ScreenOrientationBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline ScreenOrientation::ScreenOrientationBuilder<STATE | ScreenOrientation::ScreenOrientationBuilder<STATE>::AngleSet>&
ScreenOrientation::ScreenOrientationBuilder<STATE>::SetAngle(int value) {
  static_assert(!(STATE & AngleSet), "property angle should not be set yet");
  m_result->SetAngle(value);
  return castState<AngleSet>();
}

inline ScreenOrientation::ScreenOrientation() {
  m_angle = 0;
}
inline DisplayFeature::~DisplayFeature() = default;
inline void DisplayFeature::SetOrientation(const String& value) { m_orientation = value; }
inline void DisplayFeature::SetOffset(int value) { m_offset = value; }
inline void DisplayFeature::SetMaskLength(int value) { m_maskLength = value; }

template<int STATE>
inline DisplayFeature::DisplayFeatureBuilder<STATE | DisplayFeature::DisplayFeatureBuilder<STATE>::OrientationSet>&
DisplayFeature::DisplayFeatureBuilder<STATE>::SetOrientation(const String& value) {
  static_assert(!(STATE & OrientationSet), "property orientation should not be set yet");
  m_result->SetOrientation(value);
  return castState<OrientationSet>();
}
template<int STATE>
inline DisplayFeature::DisplayFeatureBuilder<STATE | DisplayFeature::DisplayFeatureBuilder<STATE>::OffsetSet>&
DisplayFeature::DisplayFeatureBuilder<STATE>::SetOffset(int value) {
  static_assert(!(STATE & OffsetSet), "property offset should not be set yet");
  m_result->SetOffset(value);
  return castState<OffsetSet>();
}
template<int STATE>
inline DisplayFeature::DisplayFeatureBuilder<STATE | DisplayFeature::DisplayFeatureBuilder<STATE>::MaskLengthSet>&
DisplayFeature::DisplayFeatureBuilder<STATE>::SetMaskLength(int value) {
  static_assert(!(STATE & MaskLengthSet), "property maskLength should not be set yet");
  m_result->SetMaskLength(value);
  return castState<MaskLengthSet>();
}

inline DisplayFeature::DisplayFeature() {
  m_offset = 0;
  m_maskLength = 0;
}
inline DevicePosture::~DevicePosture() = default;
inline void DevicePosture::SetType(const String& value) { m_type = value; }

template<int STATE>
inline DevicePosture::DevicePostureBuilder<STATE | DevicePosture::DevicePostureBuilder<STATE>::TypeSet>&
DevicePosture::DevicePostureBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}

inline DevicePosture::DevicePosture() {
}
inline MediaFeature::~MediaFeature() = default;
inline void MediaFeature::SetName(const String& value) { m_name = value; }
inline void MediaFeature::SetValue(const String& value) { m_value = value; }

template<int STATE>
inline MediaFeature::MediaFeatureBuilder<STATE | MediaFeature::MediaFeatureBuilder<STATE>::NameSet>&
MediaFeature::MediaFeatureBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline MediaFeature::MediaFeatureBuilder<STATE | MediaFeature::MediaFeatureBuilder<STATE>::ValueSet>&
MediaFeature::MediaFeatureBuilder<STATE>::SetValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(value);
  return castState<ValueSet>();
}

inline MediaFeature::MediaFeature() {
}
inline UserAgentBrandVersion::~UserAgentBrandVersion() = default;
inline void UserAgentBrandVersion::SetBrand(const String& value) { m_brand = value; }
inline void UserAgentBrandVersion::SetVersion(const String& value) { m_version = value; }

template<int STATE>
inline UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE | UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE>::BrandSet>&
UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE>::SetBrand(const String& value) {
  static_assert(!(STATE & BrandSet), "property brand should not be set yet");
  m_result->SetBrand(value);
  return castState<BrandSet>();
}
template<int STATE>
inline UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE | UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE>::VersionSet>&
UserAgentBrandVersion::UserAgentBrandVersionBuilder<STATE>::SetVersion(const String& value) {
  static_assert(!(STATE & VersionSet), "property version should not be set yet");
  m_result->SetVersion(value);
  return castState<VersionSet>();
}

inline UserAgentBrandVersion::UserAgentBrandVersion() {
}
inline UserAgentMetadata::~UserAgentMetadata() = default;
inline void UserAgentMetadata::SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) { m_brands = std::move(value); }
inline void UserAgentMetadata::SetFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) { m_fullVersionList = std::move(value); }
inline void UserAgentMetadata::SetFullVersion(const String& value) { m_fullVersion = value; }
inline void UserAgentMetadata::SetPlatform(const String& value) { m_platform = value; }
inline void UserAgentMetadata::SetPlatformVersion(const String& value) { m_platformVersion = value; }
inline void UserAgentMetadata::SetArchitecture(const String& value) { m_architecture = value; }
inline void UserAgentMetadata::SetModel(const String& value) { m_model = value; }
inline void UserAgentMetadata::SetMobile(bool value) { m_mobile = value; }
inline void UserAgentMetadata::SetBitness(const String& value) { m_bitness = value; }
inline void UserAgentMetadata::SetWow64(bool value) { m_wow64 = value; }
inline void UserAgentMetadata::SetFormFactors(std::unique_ptr<protocol::Array<String>> value) { m_formFactors = std::move(value); }

template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) {
  m_result->SetBrands(std::move(value));
  return *this;
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) {
  m_result->SetFullVersionList(std::move(value));
  return *this;
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetFullVersion(const String& value) {
  m_result->SetFullVersion(value);
  return *this;
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE | UserAgentMetadata::UserAgentMetadataBuilder<STATE>::PlatformSet>&
UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetPlatform(const String& value) {
  static_assert(!(STATE & PlatformSet), "property platform should not be set yet");
  m_result->SetPlatform(value);
  return castState<PlatformSet>();
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE | UserAgentMetadata::UserAgentMetadataBuilder<STATE>::PlatformVersionSet>&
UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetPlatformVersion(const String& value) {
  static_assert(!(STATE & PlatformVersionSet), "property platformVersion should not be set yet");
  m_result->SetPlatformVersion(value);
  return castState<PlatformVersionSet>();
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE | UserAgentMetadata::UserAgentMetadataBuilder<STATE>::ArchitectureSet>&
UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetArchitecture(const String& value) {
  static_assert(!(STATE & ArchitectureSet), "property architecture should not be set yet");
  m_result->SetArchitecture(value);
  return castState<ArchitectureSet>();
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE | UserAgentMetadata::UserAgentMetadataBuilder<STATE>::ModelSet>&
UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetModel(const String& value) {
  static_assert(!(STATE & ModelSet), "property model should not be set yet");
  m_result->SetModel(value);
  return castState<ModelSet>();
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE | UserAgentMetadata::UserAgentMetadataBuilder<STATE>::MobileSet>&
UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetMobile(bool value) {
  static_assert(!(STATE & MobileSet), "property mobile should not be set yet");
  m_result->SetMobile(value);
  return castState<MobileSet>();
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetBitness(const String& value) {
  m_result->SetBitness(value);
  return *this;
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetWow64(bool value) {
  m_result->SetWow64(value);
  return *this;
}
template<int STATE>
inline UserAgentMetadata::UserAgentMetadataBuilder<STATE>& UserAgentMetadata::UserAgentMetadataBuilder<STATE>::SetFormFactors(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetFormFactors(std::move(value));
  return *this;
}

inline UserAgentMetadata::UserAgentMetadata() {
  m_mobile = false;
}
inline SensorMetadata::~SensorMetadata() = default;
inline void SensorMetadata::SetAvailable(bool value) { m_available = value; }
inline void SensorMetadata::SetMinimumFrequency(double value) { m_minimumFrequency = value; }
inline void SensorMetadata::SetMaximumFrequency(double value) { m_maximumFrequency = value; }

template<int STATE>
inline SensorMetadata::SensorMetadataBuilder<STATE>& SensorMetadata::SensorMetadataBuilder<STATE>::SetAvailable(bool value) {
  m_result->SetAvailable(value);
  return *this;
}
template<int STATE>
inline SensorMetadata::SensorMetadataBuilder<STATE>& SensorMetadata::SensorMetadataBuilder<STATE>::SetMinimumFrequency(double value) {
  m_result->SetMinimumFrequency(value);
  return *this;
}
template<int STATE>
inline SensorMetadata::SensorMetadataBuilder<STATE>& SensorMetadata::SensorMetadataBuilder<STATE>::SetMaximumFrequency(double value) {
  m_result->SetMaximumFrequency(value);
  return *this;
}

inline SensorMetadata::SensorMetadata() {
}
inline SensorReadingSingle::~SensorReadingSingle() = default;
inline void SensorReadingSingle::SetValue(double value) { m_value = value; }

template<int STATE>
inline SensorReadingSingle::SensorReadingSingleBuilder<STATE | SensorReadingSingle::SensorReadingSingleBuilder<STATE>::ValueSet>&
SensorReadingSingle::SensorReadingSingleBuilder<STATE>::SetValue(double value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(value);
  return castState<ValueSet>();
}

inline SensorReadingSingle::SensorReadingSingle() {
  m_value = 0;
}
inline SensorReadingXYZ::~SensorReadingXYZ() = default;
inline void SensorReadingXYZ::SetX(double value) { m_x = value; }
inline void SensorReadingXYZ::SetY(double value) { m_y = value; }
inline void SensorReadingXYZ::SetZ(double value) { m_z = value; }

template<int STATE>
inline SensorReadingXYZ::SensorReadingXYZBuilder<STATE | SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::XSet>&
SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::SetX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->SetX(value);
  return castState<XSet>();
}
template<int STATE>
inline SensorReadingXYZ::SensorReadingXYZBuilder<STATE | SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::YSet>&
SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::SetY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->SetY(value);
  return castState<YSet>();
}
template<int STATE>
inline SensorReadingXYZ::SensorReadingXYZBuilder<STATE | SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::ZSet>&
SensorReadingXYZ::SensorReadingXYZBuilder<STATE>::SetZ(double value) {
  static_assert(!(STATE & ZSet), "property z should not be set yet");
  m_result->SetZ(value);
  return castState<ZSet>();
}

inline SensorReadingXYZ::SensorReadingXYZ() {
  m_x = 0;
  m_y = 0;
  m_z = 0;
}
inline SensorReadingQuaternion::~SensorReadingQuaternion() = default;
inline void SensorReadingQuaternion::SetX(double value) { m_x = value; }
inline void SensorReadingQuaternion::SetY(double value) { m_y = value; }
inline void SensorReadingQuaternion::SetZ(double value) { m_z = value; }
inline void SensorReadingQuaternion::SetW(double value) { m_w = value; }

template<int STATE>
inline SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE | SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::XSet>&
SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::SetX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->SetX(value);
  return castState<XSet>();
}
template<int STATE>
inline SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE | SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::YSet>&
SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::SetY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->SetY(value);
  return castState<YSet>();
}
template<int STATE>
inline SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE | SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::ZSet>&
SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::SetZ(double value) {
  static_assert(!(STATE & ZSet), "property z should not be set yet");
  m_result->SetZ(value);
  return castState<ZSet>();
}
template<int STATE>
inline SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE | SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::WSet>&
SensorReadingQuaternion::SensorReadingQuaternionBuilder<STATE>::SetW(double value) {
  static_assert(!(STATE & WSet), "property w should not be set yet");
  m_result->SetW(value);
  return castState<WSet>();
}

inline SensorReadingQuaternion::SensorReadingQuaternion() {
  m_x = 0;
  m_y = 0;
  m_z = 0;
  m_w = 0;
}
inline SensorReading::~SensorReading() = default;
inline void SensorReading::SetSingle(std::unique_ptr<protocol::Emulation::SensorReadingSingle> value) { m_single = std::move(value); }
inline void SensorReading::SetXyz(std::unique_ptr<protocol::Emulation::SensorReadingXYZ> value) { m_xyz = std::move(value); }
inline void SensorReading::SetQuaternion(std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> value) { m_quaternion = std::move(value); }

template<int STATE>
inline SensorReading::SensorReadingBuilder<STATE>& SensorReading::SensorReadingBuilder<STATE>::SetSingle(std::unique_ptr<protocol::Emulation::SensorReadingSingle> value) {
  m_result->SetSingle(std::move(value));
  return *this;
}
template<int STATE>
inline SensorReading::SensorReadingBuilder<STATE>& SensorReading::SensorReadingBuilder<STATE>::SetXyz(std::unique_ptr<protocol::Emulation::SensorReadingXYZ> value) {
  m_result->SetXyz(std::move(value));
  return *this;
}
template<int STATE>
inline SensorReading::SensorReadingBuilder<STATE>& SensorReading::SensorReadingBuilder<STATE>::SetQuaternion(std::unique_ptr<protocol::Emulation::SensorReadingQuaternion> value) {
  m_result->SetQuaternion(std::move(value));
  return *this;
}

inline SensorReading::SensorReading() {
}
inline PressureMetadata::~PressureMetadata() = default;
inline void PressureMetadata::SetAvailable(bool value) { m_available = value; }

template<int STATE>
inline PressureMetadata::PressureMetadataBuilder<STATE>& PressureMetadata::PressureMetadataBuilder<STATE>::SetAvailable(bool value) {
  m_result->SetAvailable(value);
  return *this;
}

inline PressureMetadata::PressureMetadata() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse CanEmulate(bool* out_result) = 0;
    virtual DispatchResponse ClearDeviceMetricsOverride() = 0;
    virtual DispatchResponse ClearGeolocationOverride() = 0;
    virtual DispatchResponse SetFocusEmulationEnabled(bool in_enabled) = 0;
    virtual DispatchResponse SetDeviceMetricsOverride(int in_width, int in_height, double in_deviceScaleFactor, bool in_mobile, std::optional<double> in_scale, std::optional<int> in_screenWidth, std::optional<int> in_screenHeight, std::optional<int> in_positionX, std::optional<int> in_positionY, std::optional<bool> in_dontSetVisibleSize, std::unique_ptr<protocol::Emulation::ScreenOrientation> in_screenOrientation, std::unique_ptr<protocol::Page::Viewport> in_viewport, std::unique_ptr<protocol::Emulation::DisplayFeature> in_displayFeature, std::unique_ptr<protocol::Emulation::DevicePosture> in_devicePosture) = 0;
    virtual DispatchResponse SetDevicePostureOverride(std::unique_ptr<protocol::Emulation::DevicePosture> in_posture) = 0;
    virtual DispatchResponse ClearDevicePostureOverride() = 0;
    virtual DispatchResponse SetDisplayFeaturesOverride(std::unique_ptr<protocol::Array<protocol::Emulation::DisplayFeature>> in_features) = 0;
    virtual DispatchResponse ClearDisplayFeaturesOverride() = 0;
    virtual DispatchResponse SetEmitTouchEventsForMouse(bool in_enabled, std::optional<String> in_configuration) = 0;
    virtual DispatchResponse SetEmulatedMedia(std::optional<String> in_media, std::unique_ptr<protocol::Array<protocol::Emulation::MediaFeature>> in_features) = 0;
    virtual DispatchResponse SetGeolocationOverride(std::optional<double> in_latitude, std::optional<double> in_longitude, std::optional<double> in_accuracy, std::optional<double> in_altitude, std::optional<double> in_altitudeAccuracy, std::optional<double> in_heading, std::optional<double> in_speed) = 0;
    class CONTENT_EXPORT GetOverriddenSensorInformationCallback {
    public:
        virtual void sendSuccess(double requestedSamplingFrequency) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetOverriddenSensorInformationCallback() { }
    };
    virtual void GetOverriddenSensorInformation(const String& in_type, std::unique_ptr<GetOverriddenSensorInformationCallback> callback) = 0;
    virtual DispatchResponse SetSensorOverrideEnabled(bool in_enabled, const String& in_type, std::unique_ptr<protocol::Emulation::SensorMetadata> in_metadata) = 0;
    class CONTENT_EXPORT SetSensorOverrideReadingsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetSensorOverrideReadingsCallback() { }
    };
    virtual void SetSensorOverrideReadings(const String& in_type, std::unique_ptr<protocol::Emulation::SensorReading> in_reading, std::unique_ptr<SetSensorOverrideReadingsCallback> callback) = 0;
    virtual DispatchResponse SetPressureSourceOverrideEnabled(bool in_enabled, const String& in_source, std::unique_ptr<protocol::Emulation::PressureMetadata> in_metadata) = 0;
    class CONTENT_EXPORT SetPressureStateOverrideCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetPressureStateOverrideCallback() { }
    };
    virtual void SetPressureStateOverride(const String& in_source, const String& in_state, std::unique_ptr<SetPressureStateOverrideCallback> callback) = 0;
    class CONTENT_EXPORT SetPressureDataOverrideCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetPressureDataOverrideCallback() { }
    };
    virtual void SetPressureDataOverride(const String& in_source, const String& in_state, std::optional<double> in_ownContributionEstimate, std::unique_ptr<SetPressureDataOverrideCallback> callback) = 0;
    virtual DispatchResponse SetIdleOverride(bool in_isUserActive, bool in_isScreenUnlocked) = 0;
    virtual DispatchResponse ClearIdleOverride() = 0;
    virtual DispatchResponse SetVisibleSize(int in_width, int in_height) = 0;
    virtual DispatchResponse SetUserAgentOverride(const String& in_userAgent, std::optional<String> in_acceptLanguage, std::optional<String> in_platform, std::unique_ptr<protocol::Emulation::UserAgentMetadata> in_userAgentMetadata) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void VirtualTimeBudgetExpired();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Emulation
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Emulation_h)
