// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_BluetoothEmulation_h
#define content_protocol_BluetoothEmulation_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace BluetoothEmulation {
using CentralState = String;
using GATTOperationType = String;
using CharacteristicWriteType = String;
using CharacteristicOperationType = String;
using DescriptorOperationType = String;
class ManufacturerData;
class ScanRecord;
class ScanEntry;
class CharacteristicProperties;

// ------------- Forward and enum declarations.

namespace CentralStateEnum {
CONTENT_EXPORT extern const char Absent[];
CONTENT_EXPORT extern const char PoweredOff[];
CONTENT_EXPORT extern const char PoweredOn[];
} // namespace CentralStateEnum

namespace GATTOperationTypeEnum {
CONTENT_EXPORT extern const char Connection[];
CONTENT_EXPORT extern const char Discovery[];
} // namespace GATTOperationTypeEnum

namespace CharacteristicWriteTypeEnum {
CONTENT_EXPORT extern const char WriteDefaultDeprecated[];
CONTENT_EXPORT extern const char WriteWithResponse[];
CONTENT_EXPORT extern const char WriteWithoutResponse[];
} // namespace CharacteristicWriteTypeEnum

namespace CharacteristicOperationTypeEnum {
CONTENT_EXPORT extern const char Read[];
CONTENT_EXPORT extern const char Write[];
CONTENT_EXPORT extern const char SubscribeToNotifications[];
CONTENT_EXPORT extern const char UnsubscribeFromNotifications[];
} // namespace CharacteristicOperationTypeEnum

namespace DescriptorOperationTypeEnum {
CONTENT_EXPORT extern const char Read[];
CONTENT_EXPORT extern const char Write[];
} // namespace DescriptorOperationTypeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT ManufacturerData : public ::crdtp::ProtocolObject<ManufacturerData> {
public:
    ~ManufacturerData() override;  // Defined below

    int GetKey() { return m_key; }
    void SetKey(int value);  // Defined below

    Binary GetData() { return m_data; }
    void SetData(const Binary& value);  // Defined below

    template<int STATE>
    class ManufacturerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            DataSet = 1 << 2,
            AllFieldsSet = (KeySet | DataSet | 0)};


        ManufacturerDataBuilder<STATE | KeySet>& SetKey(int value);  // Defined below

        ManufacturerDataBuilder<STATE | DataSet>& SetData(const Binary& value);  // Defined below

        std::unique_ptr<ManufacturerData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ManufacturerData;
        ManufacturerDataBuilder() : m_result(new ManufacturerData()) { }

        template<int STEP> ManufacturerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ManufacturerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BluetoothEmulation::ManufacturerData> m_result;
    };

    static ManufacturerDataBuilder<0> Create()
    {
        return ManufacturerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ManufacturerData();  // Defined below

    int m_key;
    Binary m_data;
};


class CONTENT_EXPORT ScanRecord : public ::crdtp::ProtocolObject<ScanRecord> {
public:
    ~ScanRecord() override;  // Defined below

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value);  // Defined below

    bool HasUuids() { return !!m_uuids; }
    protocol::Array<String>* GetUuids(protocol::Array<String>* defaultValue) {
       return m_uuids ? m_uuids.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetUuids() const {
       return m_uuids;
    }
    void SetUuids(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    bool HasAppearance() { return !!m_appearance; }
    int GetAppearance(int defaultValue) const {
       return m_appearance.value_or(defaultValue);
    }
    const std::optional<int>& GetAppearance() const {
       return m_appearance;
    }
    void SetAppearance(int value);  // Defined below

    bool HasTxPower() { return !!m_txPower; }
    int GetTxPower(int defaultValue) const {
       return m_txPower.value_or(defaultValue);
    }
    const std::optional<int>& GetTxPower() const {
       return m_txPower;
    }
    void SetTxPower(int value);  // Defined below

    bool HasManufacturerData() { return !!m_manufacturerData; }
    protocol::Array<protocol::BluetoothEmulation::ManufacturerData>* GetManufacturerData(protocol::Array<protocol::BluetoothEmulation::ManufacturerData>* defaultValue) {
       return m_manufacturerData ? m_manufacturerData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>>& GetManufacturerData() const {
       return m_manufacturerData;
    }
    void SetManufacturerData(std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> value);  // Defined below

    template<int STATE>
    class ScanRecordBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ScanRecordBuilder<STATE>& SetName(const String& value);  // Defined below

        ScanRecordBuilder<STATE>& SetUuids(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        ScanRecordBuilder<STATE>& SetAppearance(int value);  // Defined below

        ScanRecordBuilder<STATE>& SetTxPower(int value);  // Defined below

        ScanRecordBuilder<STATE>& SetManufacturerData(std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> value);  // Defined below

        std::unique_ptr<ScanRecord> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScanRecord;
        ScanRecordBuilder() : m_result(new ScanRecord()) { }

        template<int STEP> ScanRecordBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScanRecordBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> m_result;
    };

    static ScanRecordBuilder<0> Create()
    {
        return ScanRecordBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScanRecord();  // Defined below

    std::optional<String> m_name;
    std::unique_ptr<protocol::Array<String>> m_uuids;
    std::optional<int> m_appearance;
    std::optional<int> m_txPower;
    std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> m_manufacturerData;
};


class CONTENT_EXPORT ScanEntry : public ::crdtp::ProtocolObject<ScanEntry> {
public:
    ~ScanEntry() override;  // Defined below

    String GetDeviceAddress() { return m_deviceAddress; }
    void SetDeviceAddress(const String& value);  // Defined below

    int GetRssi() { return m_rssi; }
    void SetRssi(int value);  // Defined below

    protocol::BluetoothEmulation::ScanRecord* GetScanRecord() { return m_scanRecord.get(); }
    void SetScanRecord(std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> value);  // Defined below

    template<int STATE>
    class ScanEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DeviceAddressSet = 1 << 1,
            RssiSet = 1 << 2,
            ScanRecordSet = 1 << 3,
            AllFieldsSet = (DeviceAddressSet | RssiSet | ScanRecordSet | 0)};


        ScanEntryBuilder<STATE | DeviceAddressSet>& SetDeviceAddress(const String& value);  // Defined below

        ScanEntryBuilder<STATE | RssiSet>& SetRssi(int value);  // Defined below

        ScanEntryBuilder<STATE | ScanRecordSet>& SetScanRecord(std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> value);  // Defined below

        std::unique_ptr<ScanEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScanEntry;
        ScanEntryBuilder() : m_result(new ScanEntry()) { }

        template<int STEP> ScanEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScanEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BluetoothEmulation::ScanEntry> m_result;
    };

    static ScanEntryBuilder<0> Create()
    {
        return ScanEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScanEntry();  // Defined below

    String m_deviceAddress;
    int m_rssi;
    std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> m_scanRecord;
};


class CONTENT_EXPORT CharacteristicProperties : public ::crdtp::ProtocolObject<CharacteristicProperties> {
public:
    ~CharacteristicProperties() override;  // Defined below

    bool HasBroadcast() { return !!m_broadcast; }
    bool GetBroadcast(bool defaultValue) const {
       return m_broadcast.value_or(defaultValue);
    }
    const std::optional<bool>& GetBroadcast() const {
       return m_broadcast;
    }
    void SetBroadcast(bool value);  // Defined below

    bool HasRead() { return !!m_read; }
    bool GetRead(bool defaultValue) const {
       return m_read.value_or(defaultValue);
    }
    const std::optional<bool>& GetRead() const {
       return m_read;
    }
    void SetRead(bool value);  // Defined below

    bool HasWriteWithoutResponse() { return !!m_writeWithoutResponse; }
    bool GetWriteWithoutResponse(bool defaultValue) const {
       return m_writeWithoutResponse.value_or(defaultValue);
    }
    const std::optional<bool>& GetWriteWithoutResponse() const {
       return m_writeWithoutResponse;
    }
    void SetWriteWithoutResponse(bool value);  // Defined below

    bool HasWrite() { return !!m_write; }
    bool GetWrite(bool defaultValue) const {
       return m_write.value_or(defaultValue);
    }
    const std::optional<bool>& GetWrite() const {
       return m_write;
    }
    void SetWrite(bool value);  // Defined below

    bool HasNotify() { return !!m_notify; }
    bool GetNotify(bool defaultValue) const {
       return m_notify.value_or(defaultValue);
    }
    const std::optional<bool>& GetNotify() const {
       return m_notify;
    }
    void SetNotify(bool value);  // Defined below

    bool HasIndicate() { return !!m_indicate; }
    bool GetIndicate(bool defaultValue) const {
       return m_indicate.value_or(defaultValue);
    }
    const std::optional<bool>& GetIndicate() const {
       return m_indicate;
    }
    void SetIndicate(bool value);  // Defined below

    bool HasAuthenticatedSignedWrites() { return !!m_authenticatedSignedWrites; }
    bool GetAuthenticatedSignedWrites(bool defaultValue) const {
       return m_authenticatedSignedWrites.value_or(defaultValue);
    }
    const std::optional<bool>& GetAuthenticatedSignedWrites() const {
       return m_authenticatedSignedWrites;
    }
    void SetAuthenticatedSignedWrites(bool value);  // Defined below

    bool HasExtendedProperties() { return !!m_extendedProperties; }
    bool GetExtendedProperties(bool defaultValue) const {
       return m_extendedProperties.value_or(defaultValue);
    }
    const std::optional<bool>& GetExtendedProperties() const {
       return m_extendedProperties;
    }
    void SetExtendedProperties(bool value);  // Defined below

    template<int STATE>
    class CharacteristicPropertiesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        CharacteristicPropertiesBuilder<STATE>& SetBroadcast(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetRead(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetWriteWithoutResponse(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetWrite(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetNotify(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetIndicate(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetAuthenticatedSignedWrites(bool value);  // Defined below

        CharacteristicPropertiesBuilder<STATE>& SetExtendedProperties(bool value);  // Defined below

        std::unique_ptr<CharacteristicProperties> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CharacteristicProperties;
        CharacteristicPropertiesBuilder() : m_result(new CharacteristicProperties()) { }

        template<int STEP> CharacteristicPropertiesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CharacteristicPropertiesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::BluetoothEmulation::CharacteristicProperties> m_result;
    };

    static CharacteristicPropertiesBuilder<0> Create()
    {
        return CharacteristicPropertiesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CharacteristicProperties();  // Defined below

    std::optional<bool> m_broadcast;
    std::optional<bool> m_read;
    std::optional<bool> m_writeWithoutResponse;
    std::optional<bool> m_write;
    std::optional<bool> m_notify;
    std::optional<bool> m_indicate;
    std::optional<bool> m_authenticatedSignedWrites;
    std::optional<bool> m_extendedProperties;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ManufacturerData::~ManufacturerData() = default;
inline void ManufacturerData::SetKey(int value) { m_key = value; }
inline void ManufacturerData::SetData(const Binary& value) { m_data = value; }

template<int STATE>
inline ManufacturerData::ManufacturerDataBuilder<STATE | ManufacturerData::ManufacturerDataBuilder<STATE>::KeySet>&
ManufacturerData::ManufacturerDataBuilder<STATE>::SetKey(int value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->SetKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline ManufacturerData::ManufacturerDataBuilder<STATE | ManufacturerData::ManufacturerDataBuilder<STATE>::DataSet>&
ManufacturerData::ManufacturerDataBuilder<STATE>::SetData(const Binary& value) {
  static_assert(!(STATE & DataSet), "property data should not be set yet");
  m_result->SetData(value);
  return castState<DataSet>();
}

inline ManufacturerData::ManufacturerData() {
  m_key = 0;
}
inline ScanRecord::~ScanRecord() = default;
inline void ScanRecord::SetName(const String& value) { m_name = value; }
inline void ScanRecord::SetUuids(std::unique_ptr<protocol::Array<String>> value) { m_uuids = std::move(value); }
inline void ScanRecord::SetAppearance(int value) { m_appearance = value; }
inline void ScanRecord::SetTxPower(int value) { m_txPower = value; }
inline void ScanRecord::SetManufacturerData(std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> value) { m_manufacturerData = std::move(value); }

template<int STATE>
inline ScanRecord::ScanRecordBuilder<STATE>& ScanRecord::ScanRecordBuilder<STATE>::SetName(const String& value) {
  m_result->SetName(value);
  return *this;
}
template<int STATE>
inline ScanRecord::ScanRecordBuilder<STATE>& ScanRecord::ScanRecordBuilder<STATE>::SetUuids(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetUuids(std::move(value));
  return *this;
}
template<int STATE>
inline ScanRecord::ScanRecordBuilder<STATE>& ScanRecord::ScanRecordBuilder<STATE>::SetAppearance(int value) {
  m_result->SetAppearance(value);
  return *this;
}
template<int STATE>
inline ScanRecord::ScanRecordBuilder<STATE>& ScanRecord::ScanRecordBuilder<STATE>::SetTxPower(int value) {
  m_result->SetTxPower(value);
  return *this;
}
template<int STATE>
inline ScanRecord::ScanRecordBuilder<STATE>& ScanRecord::ScanRecordBuilder<STATE>::SetManufacturerData(std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> value) {
  m_result->SetManufacturerData(std::move(value));
  return *this;
}

inline ScanRecord::ScanRecord() {
}
inline ScanEntry::~ScanEntry() = default;
inline void ScanEntry::SetDeviceAddress(const String& value) { m_deviceAddress = value; }
inline void ScanEntry::SetRssi(int value) { m_rssi = value; }
inline void ScanEntry::SetScanRecord(std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> value) { m_scanRecord = std::move(value); }

template<int STATE>
inline ScanEntry::ScanEntryBuilder<STATE | ScanEntry::ScanEntryBuilder<STATE>::DeviceAddressSet>&
ScanEntry::ScanEntryBuilder<STATE>::SetDeviceAddress(const String& value) {
  static_assert(!(STATE & DeviceAddressSet), "property deviceAddress should not be set yet");
  m_result->SetDeviceAddress(value);
  return castState<DeviceAddressSet>();
}
template<int STATE>
inline ScanEntry::ScanEntryBuilder<STATE | ScanEntry::ScanEntryBuilder<STATE>::RssiSet>&
ScanEntry::ScanEntryBuilder<STATE>::SetRssi(int value) {
  static_assert(!(STATE & RssiSet), "property rssi should not be set yet");
  m_result->SetRssi(value);
  return castState<RssiSet>();
}
template<int STATE>
inline ScanEntry::ScanEntryBuilder<STATE | ScanEntry::ScanEntryBuilder<STATE>::ScanRecordSet>&
ScanEntry::ScanEntryBuilder<STATE>::SetScanRecord(std::unique_ptr<protocol::BluetoothEmulation::ScanRecord> value) {
  static_assert(!(STATE & ScanRecordSet), "property scanRecord should not be set yet");
  m_result->SetScanRecord(std::move(value));
  return castState<ScanRecordSet>();
}

inline ScanEntry::ScanEntry() {
  m_rssi = 0;
}
inline CharacteristicProperties::~CharacteristicProperties() = default;
inline void CharacteristicProperties::SetBroadcast(bool value) { m_broadcast = value; }
inline void CharacteristicProperties::SetRead(bool value) { m_read = value; }
inline void CharacteristicProperties::SetWriteWithoutResponse(bool value) { m_writeWithoutResponse = value; }
inline void CharacteristicProperties::SetWrite(bool value) { m_write = value; }
inline void CharacteristicProperties::SetNotify(bool value) { m_notify = value; }
inline void CharacteristicProperties::SetIndicate(bool value) { m_indicate = value; }
inline void CharacteristicProperties::SetAuthenticatedSignedWrites(bool value) { m_authenticatedSignedWrites = value; }
inline void CharacteristicProperties::SetExtendedProperties(bool value) { m_extendedProperties = value; }

template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetBroadcast(bool value) {
  m_result->SetBroadcast(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetRead(bool value) {
  m_result->SetRead(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetWriteWithoutResponse(bool value) {
  m_result->SetWriteWithoutResponse(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetWrite(bool value) {
  m_result->SetWrite(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetNotify(bool value) {
  m_result->SetNotify(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetIndicate(bool value) {
  m_result->SetIndicate(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetAuthenticatedSignedWrites(bool value) {
  m_result->SetAuthenticatedSignedWrites(value);
  return *this;
}
template<int STATE>
inline CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>& CharacteristicProperties::CharacteristicPropertiesBuilder<STATE>::SetExtendedProperties(bool value) {
  m_result->SetExtendedProperties(value);
  return *this;
}

inline CharacteristicProperties::CharacteristicProperties() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable(const String& in_state, bool in_leSupported) = 0;
    class CONTENT_EXPORT SetSimulatedCentralStateCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetSimulatedCentralStateCallback() { }
    };
    virtual void SetSimulatedCentralState(const String& in_state, std::unique_ptr<SetSimulatedCentralStateCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    class CONTENT_EXPORT SimulatePreconnectedPeripheralCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulatePreconnectedPeripheralCallback() { }
    };
    virtual void SimulatePreconnectedPeripheral(const String& in_address, const String& in_name, std::unique_ptr<protocol::Array<protocol::BluetoothEmulation::ManufacturerData>> in_manufacturerData, std::unique_ptr<protocol::Array<String>> in_knownServiceUuids, std::unique_ptr<SimulatePreconnectedPeripheralCallback> callback) = 0;
    class CONTENT_EXPORT SimulateAdvertisementCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulateAdvertisementCallback() { }
    };
    virtual void SimulateAdvertisement(std::unique_ptr<protocol::BluetoothEmulation::ScanEntry> in_entry, std::unique_ptr<SimulateAdvertisementCallback> callback) = 0;
    class CONTENT_EXPORT SimulateGATTOperationResponseCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulateGATTOperationResponseCallback() { }
    };
    virtual void SimulateGATTOperationResponse(const String& in_address, const String& in_type, int in_code, std::unique_ptr<SimulateGATTOperationResponseCallback> callback) = 0;
    class CONTENT_EXPORT SimulateCharacteristicOperationResponseCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulateCharacteristicOperationResponseCallback() { }
    };
    virtual void SimulateCharacteristicOperationResponse(const String& in_characteristicId, const String& in_type, int in_code, std::optional<Binary> in_data, std::unique_ptr<SimulateCharacteristicOperationResponseCallback> callback) = 0;
    class CONTENT_EXPORT SimulateDescriptorOperationResponseCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulateDescriptorOperationResponseCallback() { }
    };
    virtual void SimulateDescriptorOperationResponse(const String& in_descriptorId, const String& in_type, int in_code, std::optional<Binary> in_data, std::unique_ptr<SimulateDescriptorOperationResponseCallback> callback) = 0;
    class CONTENT_EXPORT AddServiceCallback {
    public:
        virtual void sendSuccess(const String& serviceId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AddServiceCallback() { }
    };
    virtual void AddService(const String& in_address, const String& in_serviceUuid, std::unique_ptr<AddServiceCallback> callback) = 0;
    class CONTENT_EXPORT RemoveServiceCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RemoveServiceCallback() { }
    };
    virtual void RemoveService(const String& in_serviceId, std::unique_ptr<RemoveServiceCallback> callback) = 0;
    class CONTENT_EXPORT AddCharacteristicCallback {
    public:
        virtual void sendSuccess(const String& characteristicId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AddCharacteristicCallback() { }
    };
    virtual void AddCharacteristic(const String& in_serviceId, const String& in_characteristicUuid, std::unique_ptr<protocol::BluetoothEmulation::CharacteristicProperties> in_properties, std::unique_ptr<AddCharacteristicCallback> callback) = 0;
    class CONTENT_EXPORT RemoveCharacteristicCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RemoveCharacteristicCallback() { }
    };
    virtual void RemoveCharacteristic(const String& in_characteristicId, std::unique_ptr<RemoveCharacteristicCallback> callback) = 0;
    class CONTENT_EXPORT AddDescriptorCallback {
    public:
        virtual void sendSuccess(const String& descriptorId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AddDescriptorCallback() { }
    };
    virtual void AddDescriptor(const String& in_characteristicId, const String& in_descriptorUuid, std::unique_ptr<AddDescriptorCallback> callback) = 0;
    class CONTENT_EXPORT RemoveDescriptorCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RemoveDescriptorCallback() { }
    };
    virtual void RemoveDescriptor(const String& in_descriptorId, std::unique_ptr<RemoveDescriptorCallback> callback) = 0;
    class CONTENT_EXPORT SimulateGATTDisconnectionCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SimulateGATTDisconnectionCallback() { }
    };
    virtual void SimulateGATTDisconnection(const String& in_address, std::unique_ptr<SimulateGATTDisconnectionCallback> callback) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void GattOperationReceived(const String& address, const String& type);
    void CharacteristicOperationReceived(const String& characteristicId, const String& type, std::optional<Binary> data = {}, std::optional<String> writeType = {});
    void DescriptorOperationReceived(const String& descriptorId, const String& type, std::optional<Binary> data = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace BluetoothEmulation
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_BluetoothEmulation_h)
