// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Audits_h
#define content_protocol_Audits_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Audits {
class AffectedCookie;
class AffectedRequest;
class AffectedFrame;
using CookieExclusionReason = String;
using CookieWarningReason = String;
using CookieOperation = String;
using InsightType = String;
class CookieIssueInsight;
class CookieIssueDetails;
using MixedContentResolutionStatus = String;
using MixedContentResourceType = String;
class MixedContentIssueDetails;
using BlockedByResponseReason = String;
class BlockedByResponseIssueDetails;
using HeavyAdResolutionStatus = String;
using HeavyAdReason = String;
class HeavyAdIssueDetails;
using ContentSecurityPolicyViolationType = String;
class SourceCodeLocation;
class ContentSecurityPolicyIssueDetails;
using SharedArrayBufferIssueType = String;
class SharedArrayBufferIssueDetails;
class LowTextContrastIssueDetails;
class CorsIssueDetails;
using AttributionReportingIssueType = String;
using SharedDictionaryError = String;
using SRIMessageSignatureError = String;
using UnencodedDigestError = String;
class AttributionReportingIssueDetails;
class QuirksModeIssueDetails;
class NavigatorUserAgentIssueDetails;
class SharedDictionaryIssueDetails;
class SRIMessageSignatureIssueDetails;
class UnencodedDigestIssueDetails;
using GenericIssueErrorType = String;
class GenericIssueDetails;
class DeprecationIssueDetails;
class BounceTrackingIssueDetails;
class CookieDeprecationMetadataIssueDetails;
using ClientHintIssueReason = String;
class FederatedAuthRequestIssueDetails;
using FederatedAuthRequestIssueReason = String;
class FederatedAuthUserInfoRequestIssueDetails;
using FederatedAuthUserInfoRequestIssueReason = String;
class ClientHintIssueDetails;
class FailedRequestInfo;
using PartitioningBlobURLInfo = String;
class PartitioningBlobURLIssueDetails;
using ElementAccessibilityIssueReason = String;
class ElementAccessibilityIssueDetails;
using StyleSheetLoadingIssueReason = String;
class StylesheetLoadingIssueDetails;
using PropertyRuleIssueReason = String;
class PropertyRuleIssueDetails;
using UserReidentificationIssueType = String;
class UserReidentificationIssueDetails;
using InspectorIssueCode = String;
class InspectorIssueDetails;
using IssueId = String;
class InspectorIssue;

// ------------- Forward and enum declarations.

namespace CookieExclusionReasonEnum {
CONTENT_EXPORT extern const char ExcludeSameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char ExcludeSameSiteLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteStrict[];
CONTENT_EXPORT extern const char ExcludeInvalidSameParty[];
CONTENT_EXPORT extern const char ExcludeSamePartyCrossPartyContext[];
CONTENT_EXPORT extern const char ExcludeDomainNonASCII[];
CONTENT_EXPORT extern const char ExcludeThirdPartyCookieBlockedInFirstPartySet[];
CONTENT_EXPORT extern const char ExcludeThirdPartyPhaseout[];
CONTENT_EXPORT extern const char ExcludePortMismatch[];
CONTENT_EXPORT extern const char ExcludeSchemeMismatch[];
} // namespace CookieExclusionReasonEnum

namespace CookieWarningReasonEnum {
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedCrossSiteContext[];
CONTENT_EXPORT extern const char WarnSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedLaxAllowUnsafe[];
CONTENT_EXPORT extern const char WarnSameSiteStrictLaxDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeLax[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeLax[];
CONTENT_EXPORT extern const char WarnAttributeValueExceedsMaxSize[];
CONTENT_EXPORT extern const char WarnDomainNonASCII[];
CONTENT_EXPORT extern const char WarnThirdPartyPhaseout[];
CONTENT_EXPORT extern const char WarnCrossSiteRedirectDowngradeChangesInclusion[];
CONTENT_EXPORT extern const char WarnDeprecationTrialMetadata[];
CONTENT_EXPORT extern const char WarnThirdPartyCookieHeuristic[];
} // namespace CookieWarningReasonEnum

namespace CookieOperationEnum {
CONTENT_EXPORT extern const char SetCookie[];
CONTENT_EXPORT extern const char ReadCookie[];
} // namespace CookieOperationEnum

namespace InsightTypeEnum {
CONTENT_EXPORT extern const char GitHubResource[];
CONTENT_EXPORT extern const char GracePeriod[];
CONTENT_EXPORT extern const char Heuristics[];
} // namespace InsightTypeEnum

namespace MixedContentResolutionStatusEnum {
CONTENT_EXPORT extern const char MixedContentBlocked[];
CONTENT_EXPORT extern const char MixedContentAutomaticallyUpgraded[];
CONTENT_EXPORT extern const char MixedContentWarning[];
} // namespace MixedContentResolutionStatusEnum

namespace MixedContentResourceTypeEnum {
CONTENT_EXPORT extern const char AttributionSrc[];
CONTENT_EXPORT extern const char Audio[];
CONTENT_EXPORT extern const char Beacon[];
CONTENT_EXPORT extern const char CSPReport[];
CONTENT_EXPORT extern const char Download[];
CONTENT_EXPORT extern const char EventSource[];
CONTENT_EXPORT extern const char Favicon[];
CONTENT_EXPORT extern const char Font[];
CONTENT_EXPORT extern const char Form[];
CONTENT_EXPORT extern const char Frame[];
CONTENT_EXPORT extern const char Image[];
CONTENT_EXPORT extern const char Import[];
CONTENT_EXPORT extern const char JSON[];
CONTENT_EXPORT extern const char Manifest[];
CONTENT_EXPORT extern const char Ping[];
CONTENT_EXPORT extern const char PluginData[];
CONTENT_EXPORT extern const char PluginResource[];
CONTENT_EXPORT extern const char Prefetch[];
CONTENT_EXPORT extern const char Resource[];
CONTENT_EXPORT extern const char Script[];
CONTENT_EXPORT extern const char ServiceWorker[];
CONTENT_EXPORT extern const char SharedWorker[];
CONTENT_EXPORT extern const char SpeculationRules[];
CONTENT_EXPORT extern const char Stylesheet[];
CONTENT_EXPORT extern const char Track[];
CONTENT_EXPORT extern const char Video[];
CONTENT_EXPORT extern const char Worker[];
CONTENT_EXPORT extern const char XMLHttpRequest[];
CONTENT_EXPORT extern const char XSLT[];
} // namespace MixedContentResourceTypeEnum

namespace BlockedByResponseReasonEnum {
CONTENT_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CONTENT_EXPORT extern const char CoopSandboxedIFrameCannotNavigateToCoopPage[];
CONTENT_EXPORT extern const char CorpNotSameOrigin[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CONTENT_EXPORT extern const char CorpNotSameSite[];
CONTENT_EXPORT extern const char SRIMessageSignatureMismatch[];
} // namespace BlockedByResponseReasonEnum

namespace HeavyAdResolutionStatusEnum {
CONTENT_EXPORT extern const char HeavyAdBlocked[];
CONTENT_EXPORT extern const char HeavyAdWarning[];
} // namespace HeavyAdResolutionStatusEnum

namespace HeavyAdReasonEnum {
CONTENT_EXPORT extern const char NetworkTotalLimit[];
CONTENT_EXPORT extern const char CpuTotalLimit[];
CONTENT_EXPORT extern const char CpuPeakLimit[];
} // namespace HeavyAdReasonEnum

namespace ContentSecurityPolicyViolationTypeEnum {
CONTENT_EXPORT extern const char KInlineViolation[];
CONTENT_EXPORT extern const char KEvalViolation[];
CONTENT_EXPORT extern const char KURLViolation[];
CONTENT_EXPORT extern const char KSRIViolation[];
CONTENT_EXPORT extern const char KTrustedTypesSinkViolation[];
CONTENT_EXPORT extern const char KTrustedTypesPolicyViolation[];
CONTENT_EXPORT extern const char KWasmEvalViolation[];
} // namespace ContentSecurityPolicyViolationTypeEnum

namespace SharedArrayBufferIssueTypeEnum {
CONTENT_EXPORT extern const char TransferIssue[];
CONTENT_EXPORT extern const char CreationIssue[];
} // namespace SharedArrayBufferIssueTypeEnum

namespace AttributionReportingIssueTypeEnum {
CONTENT_EXPORT extern const char PermissionPolicyDisabled[];
CONTENT_EXPORT extern const char UntrustworthyReportingOrigin[];
CONTENT_EXPORT extern const char InsecureContext[];
CONTENT_EXPORT extern const char InvalidHeader[];
CONTENT_EXPORT extern const char InvalidRegisterTriggerHeader[];
CONTENT_EXPORT extern const char SourceAndTriggerHeaders[];
CONTENT_EXPORT extern const char SourceIgnored[];
CONTENT_EXPORT extern const char TriggerIgnored[];
CONTENT_EXPORT extern const char OsSourceIgnored[];
CONTENT_EXPORT extern const char OsTriggerIgnored[];
CONTENT_EXPORT extern const char InvalidRegisterOsSourceHeader[];
CONTENT_EXPORT extern const char InvalidRegisterOsTriggerHeader[];
CONTENT_EXPORT extern const char WebAndOsHeaders[];
CONTENT_EXPORT extern const char NoWebOrOsSupport[];
CONTENT_EXPORT extern const char NavigationRegistrationWithoutTransientUserActivation[];
CONTENT_EXPORT extern const char InvalidInfoHeader[];
CONTENT_EXPORT extern const char NoRegisterSourceHeader[];
CONTENT_EXPORT extern const char NoRegisterTriggerHeader[];
CONTENT_EXPORT extern const char NoRegisterOsSourceHeader[];
CONTENT_EXPORT extern const char NoRegisterOsTriggerHeader[];
CONTENT_EXPORT extern const char NavigationRegistrationUniqueScopeAlreadySet[];
} // namespace AttributionReportingIssueTypeEnum

namespace SharedDictionaryErrorEnum {
CONTENT_EXPORT extern const char UseErrorCrossOriginNoCorsRequest[];
CONTENT_EXPORT extern const char UseErrorDictionaryLoadFailure[];
CONTENT_EXPORT extern const char UseErrorMatchingDictionaryNotUsed[];
CONTENT_EXPORT extern const char UseErrorUnexpectedContentDictionaryHeader[];
CONTENT_EXPORT extern const char WriteErrorCossOriginNoCorsRequest[];
CONTENT_EXPORT extern const char WriteErrorDisallowedBySettings[];
CONTENT_EXPORT extern const char WriteErrorExpiredResponse[];
CONTENT_EXPORT extern const char WriteErrorFeatureDisabled[];
CONTENT_EXPORT extern const char WriteErrorInsufficientResources[];
CONTENT_EXPORT extern const char WriteErrorInvalidMatchField[];
CONTENT_EXPORT extern const char WriteErrorInvalidStructuredHeader[];
CONTENT_EXPORT extern const char WriteErrorInvalidTTLField[];
CONTENT_EXPORT extern const char WriteErrorNavigationRequest[];
CONTENT_EXPORT extern const char WriteErrorNoMatchField[];
CONTENT_EXPORT extern const char WriteErrorNonIntegerTTLField[];
CONTENT_EXPORT extern const char WriteErrorNonListMatchDestField[];
CONTENT_EXPORT extern const char WriteErrorNonSecureContext[];
CONTENT_EXPORT extern const char WriteErrorNonStringIdField[];
CONTENT_EXPORT extern const char WriteErrorNonStringInMatchDestList[];
CONTENT_EXPORT extern const char WriteErrorNonStringMatchField[];
CONTENT_EXPORT extern const char WriteErrorNonTokenTypeField[];
CONTENT_EXPORT extern const char WriteErrorRequestAborted[];
CONTENT_EXPORT extern const char WriteErrorShuttingDown[];
CONTENT_EXPORT extern const char WriteErrorTooLongIdField[];
CONTENT_EXPORT extern const char WriteErrorUnsupportedType[];
} // namespace SharedDictionaryErrorEnum

namespace SRIMessageSignatureErrorEnum {
CONTENT_EXPORT extern const char MissingSignatureHeader[];
CONTENT_EXPORT extern const char MissingSignatureInputHeader[];
CONTENT_EXPORT extern const char InvalidSignatureHeader[];
CONTENT_EXPORT extern const char InvalidSignatureInputHeader[];
CONTENT_EXPORT extern const char SignatureHeaderValueIsNotByteSequence[];
CONTENT_EXPORT extern const char SignatureHeaderValueIsParameterized[];
CONTENT_EXPORT extern const char SignatureHeaderValueIsIncorrectLength[];
CONTENT_EXPORT extern const char SignatureInputHeaderMissingLabel[];
CONTENT_EXPORT extern const char SignatureInputHeaderValueNotInnerList[];
CONTENT_EXPORT extern const char SignatureInputHeaderValueMissingComponents[];
CONTENT_EXPORT extern const char SignatureInputHeaderInvalidComponentType[];
CONTENT_EXPORT extern const char SignatureInputHeaderInvalidComponentName[];
CONTENT_EXPORT extern const char SignatureInputHeaderInvalidHeaderComponentParameter[];
CONTENT_EXPORT extern const char SignatureInputHeaderInvalidDerivedComponentParameter[];
CONTENT_EXPORT extern const char SignatureInputHeaderKeyIdLength[];
CONTENT_EXPORT extern const char SignatureInputHeaderInvalidParameter[];
CONTENT_EXPORT extern const char SignatureInputHeaderMissingRequiredParameters[];
CONTENT_EXPORT extern const char ValidationFailedSignatureExpired[];
CONTENT_EXPORT extern const char ValidationFailedInvalidLength[];
CONTENT_EXPORT extern const char ValidationFailedSignatureMismatch[];
CONTENT_EXPORT extern const char ValidationFailedIntegrityMismatch[];
} // namespace SRIMessageSignatureErrorEnum

namespace UnencodedDigestErrorEnum {
CONTENT_EXPORT extern const char MalformedDictionary[];
CONTENT_EXPORT extern const char UnknownAlgorithm[];
CONTENT_EXPORT extern const char IncorrectDigestType[];
CONTENT_EXPORT extern const char IncorrectDigestLength[];
} // namespace UnencodedDigestErrorEnum

namespace GenericIssueErrorTypeEnum {
CONTENT_EXPORT extern const char FormLabelForNameError[];
CONTENT_EXPORT extern const char FormDuplicateIdForInputError[];
CONTENT_EXPORT extern const char FormInputWithNoLabelError[];
CONTENT_EXPORT extern const char FormAutocompleteAttributeEmptyError[];
CONTENT_EXPORT extern const char FormEmptyIdAndNameAttributesForInputError[];
CONTENT_EXPORT extern const char FormAriaLabelledByToNonExistingId[];
CONTENT_EXPORT extern const char FormInputAssignedAutocompleteValueToIdOrNameAttributeError[];
CONTENT_EXPORT extern const char FormLabelHasNeitherForNorNestedInput[];
CONTENT_EXPORT extern const char FormLabelForMatchesNonExistingIdError[];
CONTENT_EXPORT extern const char FormInputHasWrongButWellIntendedAutocompleteValueError[];
CONTENT_EXPORT extern const char ResponseWasBlockedByORB[];
} // namespace GenericIssueErrorTypeEnum

namespace ClientHintIssueReasonEnum {
CONTENT_EXPORT extern const char MetaTagAllowListInvalidOrigin[];
CONTENT_EXPORT extern const char MetaTagModifiedHTML[];
} // namespace ClientHintIssueReasonEnum

namespace FederatedAuthRequestIssueReasonEnum {
CONTENT_EXPORT extern const char ShouldEmbargo[];
CONTENT_EXPORT extern const char TooManyRequests[];
CONTENT_EXPORT extern const char WellKnownHttpNotFound[];
CONTENT_EXPORT extern const char WellKnownNoResponse[];
CONTENT_EXPORT extern const char WellKnownInvalidResponse[];
CONTENT_EXPORT extern const char WellKnownListEmpty[];
CONTENT_EXPORT extern const char WellKnownInvalidContentType[];
CONTENT_EXPORT extern const char ConfigNotInWellKnown[];
CONTENT_EXPORT extern const char WellKnownTooBig[];
CONTENT_EXPORT extern const char ConfigHttpNotFound[];
CONTENT_EXPORT extern const char ConfigNoResponse[];
CONTENT_EXPORT extern const char ConfigInvalidResponse[];
CONTENT_EXPORT extern const char ConfigInvalidContentType[];
CONTENT_EXPORT extern const char ClientMetadataHttpNotFound[];
CONTENT_EXPORT extern const char ClientMetadataNoResponse[];
CONTENT_EXPORT extern const char ClientMetadataInvalidResponse[];
CONTENT_EXPORT extern const char ClientMetadataInvalidContentType[];
CONTENT_EXPORT extern const char IdpNotPotentiallyTrustworthy[];
CONTENT_EXPORT extern const char DisabledInSettings[];
CONTENT_EXPORT extern const char DisabledInFlags[];
CONTENT_EXPORT extern const char ErrorFetchingSignin[];
CONTENT_EXPORT extern const char InvalidSigninResponse[];
CONTENT_EXPORT extern const char AccountsHttpNotFound[];
CONTENT_EXPORT extern const char AccountsNoResponse[];
CONTENT_EXPORT extern const char AccountsInvalidResponse[];
CONTENT_EXPORT extern const char AccountsListEmpty[];
CONTENT_EXPORT extern const char AccountsInvalidContentType[];
CONTENT_EXPORT extern const char IdTokenHttpNotFound[];
CONTENT_EXPORT extern const char IdTokenNoResponse[];
CONTENT_EXPORT extern const char IdTokenInvalidResponse[];
CONTENT_EXPORT extern const char IdTokenIdpErrorResponse[];
CONTENT_EXPORT extern const char IdTokenCrossSiteIdpErrorResponse[];
CONTENT_EXPORT extern const char IdTokenInvalidRequest[];
CONTENT_EXPORT extern const char IdTokenInvalidContentType[];
CONTENT_EXPORT extern const char ErrorIdToken[];
CONTENT_EXPORT extern const char Canceled[];
CONTENT_EXPORT extern const char RpPageNotVisible[];
CONTENT_EXPORT extern const char SilentMediationFailure[];
CONTENT_EXPORT extern const char ThirdPartyCookiesBlocked[];
CONTENT_EXPORT extern const char NotSignedInWithIdp[];
CONTENT_EXPORT extern const char MissingTransientUserActivation[];
CONTENT_EXPORT extern const char ReplacedByActiveMode[];
CONTENT_EXPORT extern const char InvalidFieldsSpecified[];
CONTENT_EXPORT extern const char RelyingPartyOriginIsOpaque[];
CONTENT_EXPORT extern const char TypeNotMatching[];
CONTENT_EXPORT extern const char UiDismissedNoEmbargo[];
CONTENT_EXPORT extern const char CorsError[];
CONTENT_EXPORT extern const char SuppressedBySegmentationPlatform[];
} // namespace FederatedAuthRequestIssueReasonEnum

namespace FederatedAuthUserInfoRequestIssueReasonEnum {
CONTENT_EXPORT extern const char NotSameOrigin[];
CONTENT_EXPORT extern const char NotIframe[];
CONTENT_EXPORT extern const char NotPotentiallyTrustworthy[];
CONTENT_EXPORT extern const char NoApiPermission[];
CONTENT_EXPORT extern const char NotSignedInWithIdp[];
CONTENT_EXPORT extern const char NoAccountSharingPermission[];
CONTENT_EXPORT extern const char InvalidConfigOrWellKnown[];
CONTENT_EXPORT extern const char InvalidAccountsResponse[];
CONTENT_EXPORT extern const char NoReturningUserFromFetchedAccounts[];
} // namespace FederatedAuthUserInfoRequestIssueReasonEnum

namespace PartitioningBlobURLInfoEnum {
CONTENT_EXPORT extern const char BlockedCrossPartitionFetching[];
CONTENT_EXPORT extern const char EnforceNoopenerForNavigation[];
} // namespace PartitioningBlobURLInfoEnum

namespace ElementAccessibilityIssueReasonEnum {
CONTENT_EXPORT extern const char DisallowedSelectChild[];
CONTENT_EXPORT extern const char DisallowedOptGroupChild[];
CONTENT_EXPORT extern const char NonPhrasingContentOptionChild[];
CONTENT_EXPORT extern const char InteractiveContentOptionChild[];
CONTENT_EXPORT extern const char InteractiveContentLegendChild[];
CONTENT_EXPORT extern const char InteractiveContentSummaryDescendant[];
} // namespace ElementAccessibilityIssueReasonEnum

namespace StyleSheetLoadingIssueReasonEnum {
CONTENT_EXPORT extern const char LateImportRule[];
CONTENT_EXPORT extern const char RequestFailed[];
} // namespace StyleSheetLoadingIssueReasonEnum

namespace PropertyRuleIssueReasonEnum {
CONTENT_EXPORT extern const char InvalidSyntax[];
CONTENT_EXPORT extern const char InvalidInitialValue[];
CONTENT_EXPORT extern const char InvalidInherits[];
CONTENT_EXPORT extern const char InvalidName[];
} // namespace PropertyRuleIssueReasonEnum

namespace UserReidentificationIssueTypeEnum {
CONTENT_EXPORT extern const char BlockedFrameNavigation[];
CONTENT_EXPORT extern const char BlockedSubresource[];
CONTENT_EXPORT extern const char NoisedCanvasReadback[];
} // namespace UserReidentificationIssueTypeEnum

namespace InspectorIssueCodeEnum {
CONTENT_EXPORT extern const char CookieIssue[];
CONTENT_EXPORT extern const char MixedContentIssue[];
CONTENT_EXPORT extern const char BlockedByResponseIssue[];
CONTENT_EXPORT extern const char HeavyAdIssue[];
CONTENT_EXPORT extern const char ContentSecurityPolicyIssue[];
CONTENT_EXPORT extern const char SharedArrayBufferIssue[];
CONTENT_EXPORT extern const char LowTextContrastIssue[];
CONTENT_EXPORT extern const char CorsIssue[];
CONTENT_EXPORT extern const char AttributionReportingIssue[];
CONTENT_EXPORT extern const char QuirksModeIssue[];
CONTENT_EXPORT extern const char PartitioningBlobURLIssue[];
CONTENT_EXPORT extern const char NavigatorUserAgentIssue[];
CONTENT_EXPORT extern const char GenericIssue[];
CONTENT_EXPORT extern const char DeprecationIssue[];
CONTENT_EXPORT extern const char ClientHintIssue[];
CONTENT_EXPORT extern const char FederatedAuthRequestIssue[];
CONTENT_EXPORT extern const char BounceTrackingIssue[];
CONTENT_EXPORT extern const char CookieDeprecationMetadataIssue[];
CONTENT_EXPORT extern const char StylesheetLoadingIssue[];
CONTENT_EXPORT extern const char FederatedAuthUserInfoRequestIssue[];
CONTENT_EXPORT extern const char PropertyRuleIssue[];
CONTENT_EXPORT extern const char SharedDictionaryIssue[];
CONTENT_EXPORT extern const char ElementAccessibilityIssue[];
CONTENT_EXPORT extern const char SRIMessageSignatureIssue[];
CONTENT_EXPORT extern const char UnencodedDigestIssue[];
CONTENT_EXPORT extern const char UserReidentificationIssue[];
} // namespace InspectorIssueCodeEnum

namespace GetEncodedResponse {
namespace EncodingEnum {
CONTENT_EXPORT extern const char* Webp;
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // EncodingEnum
} // GetEncodedResponse

// ------------- Type and builder declarations.

class CONTENT_EXPORT AffectedCookie : public ::crdtp::ProtocolObject<AffectedCookie> {
public:
    ~AffectedCookie() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetPath() { return m_path; }
    void SetPath(const String& value);  // Defined below

    String GetDomain() { return m_domain; }
    void SetDomain(const String& value);  // Defined below

    template<int STATE>
    class AffectedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            PathSet = 1 << 2,
            DomainSet = 1 << 3,
            AllFieldsSet = (NameSet | PathSet | DomainSet | 0)};


        AffectedCookieBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        AffectedCookieBuilder<STATE | PathSet>& SetPath(const String& value);  // Defined below

        AffectedCookieBuilder<STATE | DomainSet>& SetDomain(const String& value);  // Defined below

        std::unique_ptr<AffectedCookie> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedCookie;
        AffectedCookieBuilder() : m_result(new AffectedCookie()) { }

        template<int STEP> AffectedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedCookie> m_result;
    };

    static AffectedCookieBuilder<0> Create()
    {
        return AffectedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedCookie();  // Defined below

    String m_name;
    String m_path;
    String m_domain;
};


class CONTENT_EXPORT AffectedRequest : public ::crdtp::ProtocolObject<AffectedRequest> {
public:
    ~AffectedRequest() override;  // Defined below

    bool HasRequestId() { return !!m_requestId; }
    String GetRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestId() const {
       return m_requestId;
    }
    void SetRequestId(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    template<int STATE>
    class AffectedRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        AffectedRequestBuilder<STATE>& SetRequestId(const String& value);  // Defined below

        AffectedRequestBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        std::unique_ptr<AffectedRequest> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedRequest;
        AffectedRequestBuilder() : m_result(new AffectedRequest()) { }

        template<int STEP> AffectedRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedRequest> m_result;
    };

    static AffectedRequestBuilder<0> Create()
    {
        return AffectedRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedRequest();  // Defined below

    std::optional<String> m_requestId;
    String m_url;
};


class CONTENT_EXPORT AffectedFrame : public ::crdtp::ProtocolObject<AffectedFrame> {
public:
    ~AffectedFrame() override;  // Defined below

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value);  // Defined below

    template<int STATE>
    class AffectedFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            AllFieldsSet = (FrameIdSet | 0)};


        AffectedFrameBuilder<STATE | FrameIdSet>& SetFrameId(const String& value);  // Defined below

        std::unique_ptr<AffectedFrame> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedFrame;
        AffectedFrameBuilder() : m_result(new AffectedFrame()) { }

        template<int STEP> AffectedFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedFrame> m_result;
    };

    static AffectedFrameBuilder<0> Create()
    {
        return AffectedFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedFrame();  // Defined below

    String m_frameId;
};


class CONTENT_EXPORT CookieIssueInsight : public ::crdtp::ProtocolObject<CookieIssueInsight> {
public:
    ~CookieIssueInsight() override;  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    bool HasTableEntryUrl() { return !!m_tableEntryUrl; }
    String GetTableEntryUrl(const String& defaultValue) const {
       return m_tableEntryUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetTableEntryUrl() const {
       return m_tableEntryUrl;
    }
    void SetTableEntryUrl(const String& value);  // Defined below

    template<int STATE>
    class CookieIssueInsightBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        CookieIssueInsightBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        CookieIssueInsightBuilder<STATE>& SetTableEntryUrl(const String& value);  // Defined below

        std::unique_ptr<CookieIssueInsight> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueInsight;
        CookieIssueInsightBuilder() : m_result(new CookieIssueInsight()) { }

        template<int STEP> CookieIssueInsightBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueInsightBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueInsight> m_result;
    };

    static CookieIssueInsightBuilder<0> Create()
    {
        return CookieIssueInsightBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueInsight();  // Defined below

    String m_type;
    std::optional<String> m_tableEntryUrl;
};


class CONTENT_EXPORT CookieIssueDetails : public ::crdtp::ProtocolObject<CookieIssueDetails> {
public:
    ~CookieIssueDetails() override;  // Defined below

    bool HasCookie() { return !!m_cookie; }
    protocol::Audits::AffectedCookie* GetCookie(protocol::Audits::AffectedCookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedCookie>& GetCookie() const {
       return m_cookie;
    }
    void SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value);  // Defined below

    bool HasRawCookieLine() { return !!m_rawCookieLine; }
    String GetRawCookieLine(const String& defaultValue) const {
       return m_rawCookieLine.value_or(defaultValue);
    }
    const std::optional<String>& GetRawCookieLine() const {
       return m_rawCookieLine;
    }
    void SetRawCookieLine(const String& value);  // Defined below

    protocol::Array<String>* GetCookieWarningReasons() { return m_cookieWarningReasons.get(); }
    void SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<String>* GetCookieExclusionReasons() { return m_cookieExclusionReasons.get(); }
    void SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value);  // Defined below

    bool HasSiteForCookies() { return !!m_siteForCookies; }
    String GetSiteForCookies(const String& defaultValue) const {
       return m_siteForCookies.value_or(defaultValue);
    }
    const std::optional<String>& GetSiteForCookies() const {
       return m_siteForCookies;
    }
    void SetSiteForCookies(const String& value);  // Defined below

    bool HasCookieUrl() { return !!m_cookieUrl; }
    String GetCookieUrl(const String& defaultValue) const {
       return m_cookieUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetCookieUrl() const {
       return m_cookieUrl;
    }
    void SetCookieUrl(const String& value);  // Defined below

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasInsight() { return !!m_insight; }
    protocol::Audits::CookieIssueInsight* GetInsight(protocol::Audits::CookieIssueInsight* defaultValue) {
       return m_insight ? m_insight.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueInsight>& GetInsight() const {
       return m_insight;
    }
    void SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value);  // Defined below

    template<int STATE>
    class CookieIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieWarningReasonsSet = 1 << 1,
            CookieExclusionReasonsSet = 1 << 2,
            OperationSet = 1 << 3,
            AllFieldsSet = (CookieWarningReasonsSet | CookieExclusionReasonsSet | OperationSet | 0)};


        CookieIssueDetailsBuilder<STATE>& SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& SetRawCookieLine(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE | CookieWarningReasonsSet>& SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieIssueDetailsBuilder<STATE | CookieExclusionReasonsSet>& SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieIssueDetailsBuilder<STATE | OperationSet>& SetOperation(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& SetSiteForCookies(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& SetCookieUrl(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value);  // Defined below

        std::unique_ptr<CookieIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueDetails;
        CookieIssueDetailsBuilder() : m_result(new CookieIssueDetails()) { }

        template<int STEP> CookieIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueDetails> m_result;
    };

    static CookieIssueDetailsBuilder<0> Create()
    {
        return CookieIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedCookie> m_cookie;
    std::optional<String> m_rawCookieLine;
    std::unique_ptr<protocol::Array<String>> m_cookieWarningReasons;
    std::unique_ptr<protocol::Array<String>> m_cookieExclusionReasons;
    String m_operation;
    std::optional<String> m_siteForCookies;
    std::optional<String> m_cookieUrl;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::CookieIssueInsight> m_insight;
};


class CONTENT_EXPORT MixedContentIssueDetails : public ::crdtp::ProtocolObject<MixedContentIssueDetails> {
public:
    ~MixedContentIssueDetails() override;  // Defined below

    bool HasResourceType() { return !!m_resourceType; }
    String GetResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceType() const {
       return m_resourceType;
    }
    void SetResourceType(const String& value);  // Defined below

    String GetResolutionStatus() { return m_resolutionStatus; }
    void SetResolutionStatus(const String& value);  // Defined below

    String GetInsecureURL() { return m_insecureURL; }
    void SetInsecureURL(const String& value);  // Defined below

    String GetMainResourceURL() { return m_mainResourceURL; }
    void SetMainResourceURL(const String& value);  // Defined below

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasFrame() { return !!m_frame; }
    protocol::Audits::AffectedFrame* GetFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frame ? m_frame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetFrame() const {
       return m_frame;
    }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    template<int STATE>
    class MixedContentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionStatusSet = 1 << 1,
            InsecureURLSet = 1 << 2,
            MainResourceURLSet = 1 << 3,
            AllFieldsSet = (ResolutionStatusSet | InsecureURLSet | MainResourceURLSet | 0)};


        MixedContentIssueDetailsBuilder<STATE>& SetResourceType(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | ResolutionStatusSet>& SetResolutionStatus(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | InsecureURLSet>& SetInsecureURL(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | MainResourceURLSet>& SetMainResourceURL(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        std::unique_ptr<MixedContentIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MixedContentIssueDetails;
        MixedContentIssueDetailsBuilder() : m_result(new MixedContentIssueDetails()) { }

        template<int STEP> MixedContentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MixedContentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_result;
    };

    static MixedContentIssueDetailsBuilder<0> Create()
    {
        return MixedContentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MixedContentIssueDetails();  // Defined below

    std::optional<String> m_resourceType;
    String m_resolutionStatus;
    String m_insecureURL;
    String m_mainResourceURL;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT BlockedByResponseIssueDetails : public ::crdtp::ProtocolObject<BlockedByResponseIssueDetails> {
public:
    ~BlockedByResponseIssueDetails() override;  // Defined below

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasParentFrame() { return !!m_parentFrame; }
    protocol::Audits::AffectedFrame* GetParentFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_parentFrame ? m_parentFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetParentFrame() const {
       return m_parentFrame;
    }
    void SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    bool HasBlockedFrame() { return !!m_blockedFrame; }
    protocol::Audits::AffectedFrame* GetBlockedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_blockedFrame ? m_blockedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetBlockedFrame() const {
       return m_blockedFrame;
    }
    void SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    String GetReason() { return m_reason; }
    void SetReason(const String& value);  // Defined below

    template<int STATE>
    class BlockedByResponseIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (RequestSet | ReasonSet | 0)};


        BlockedByResponseIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE>& SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE>& SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value);  // Defined below

        std::unique_ptr<BlockedByResponseIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedByResponseIssueDetails;
        BlockedByResponseIssueDetailsBuilder() : m_result(new BlockedByResponseIssueDetails()) { }

        template<int STEP> BlockedByResponseIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedByResponseIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_result;
    };

    static BlockedByResponseIssueDetailsBuilder<0> Create()
    {
        return BlockedByResponseIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedByResponseIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_parentFrame;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_blockedFrame;
    String m_reason;
};


class CONTENT_EXPORT HeavyAdIssueDetails : public ::crdtp::ProtocolObject<HeavyAdIssueDetails> {
public:
    ~HeavyAdIssueDetails() override;  // Defined below

    String GetResolution() { return m_resolution; }
    void SetResolution(const String& value);  // Defined below

    String GetReason() { return m_reason; }
    void SetReason(const String& value);  // Defined below

    protocol::Audits::AffectedFrame* GetFrame() { return m_frame.get(); }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    template<int STATE>
    class HeavyAdIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionSet = 1 << 1,
            ReasonSet = 1 << 2,
            FrameSet = 1 << 3,
            AllFieldsSet = (ResolutionSet | ReasonSet | FrameSet | 0)};


        HeavyAdIssueDetailsBuilder<STATE | ResolutionSet>& SetResolution(const String& value);  // Defined below

        HeavyAdIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value);  // Defined below

        HeavyAdIssueDetailsBuilder<STATE | FrameSet>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        std::unique_ptr<HeavyAdIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeavyAdIssueDetails;
        HeavyAdIssueDetailsBuilder() : m_result(new HeavyAdIssueDetails()) { }

        template<int STEP> HeavyAdIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeavyAdIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_result;
    };

    static HeavyAdIssueDetailsBuilder<0> Create()
    {
        return HeavyAdIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeavyAdIssueDetails();  // Defined below

    String m_resolution;
    String m_reason;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT SourceCodeLocation : public ::crdtp::ProtocolObject<SourceCodeLocation> {
public:
    ~SourceCodeLocation() override;  // Defined below

    bool HasScriptId() { return !!m_scriptId; }
    String GetScriptId(const String& defaultValue) const {
       return m_scriptId.value_or(defaultValue);
    }
    const std::optional<String>& GetScriptId() const {
       return m_scriptId;
    }
    void SetScriptId(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value);  // Defined below

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value);  // Defined below

    template<int STATE>
    class SourceCodeLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            LineNumberSet = 1 << 2,
            ColumnNumberSet = 1 << 3,
            AllFieldsSet = (UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        SourceCodeLocationBuilder<STATE>& SetScriptId(const String& value);  // Defined below

        SourceCodeLocationBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        SourceCodeLocationBuilder<STATE | LineNumberSet>& SetLineNumber(int value);  // Defined below

        SourceCodeLocationBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value);  // Defined below

        std::unique_ptr<SourceCodeLocation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceCodeLocation;
        SourceCodeLocationBuilder() : m_result(new SourceCodeLocation()) { }

        template<int STEP> SourceCodeLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceCodeLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SourceCodeLocation> m_result;
    };

    static SourceCodeLocationBuilder<0> Create()
    {
        return SourceCodeLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceCodeLocation();  // Defined below

    std::optional<String> m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CONTENT_EXPORT ContentSecurityPolicyIssueDetails : public ::crdtp::ProtocolObject<ContentSecurityPolicyIssueDetails> {
public:
    ~ContentSecurityPolicyIssueDetails() override;  // Defined below

    bool HasBlockedURL() { return !!m_blockedURL; }
    String GetBlockedURL(const String& defaultValue) const {
       return m_blockedURL.value_or(defaultValue);
    }
    const std::optional<String>& GetBlockedURL() const {
       return m_blockedURL;
    }
    void SetBlockedURL(const String& value);  // Defined below

    String GetViolatedDirective() { return m_violatedDirective; }
    void SetViolatedDirective(const String& value);  // Defined below

    bool GetIsReportOnly() { return m_isReportOnly; }
    void SetIsReportOnly(bool value);  // Defined below

    String GetContentSecurityPolicyViolationType() { return m_contentSecurityPolicyViolationType; }
    void SetContentSecurityPolicyViolationType(const String& value);  // Defined below

    bool HasFrameAncestor() { return !!m_frameAncestor; }
    protocol::Audits::AffectedFrame* GetFrameAncestor(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frameAncestor ? m_frameAncestor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetFrameAncestor() const {
       return m_frameAncestor;
    }
    void SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    bool HasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value);  // Defined below

    template<int STATE>
    class ContentSecurityPolicyIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatedDirectiveSet = 1 << 1,
            IsReportOnlySet = 1 << 2,
            ContentSecurityPolicyViolationTypeSet = 1 << 3,
            AllFieldsSet = (ViolatedDirectiveSet | IsReportOnlySet | ContentSecurityPolicyViolationTypeSet | 0)};


        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetBlockedURL(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ViolatedDirectiveSet>& SetViolatedDirective(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | IsReportOnlySet>& SetIsReportOnly(bool value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyViolationTypeSet>& SetContentSecurityPolicyViolationType(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value);  // Defined below

        std::unique_ptr<ContentSecurityPolicyIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyIssueDetails;
        ContentSecurityPolicyIssueDetailsBuilder() : m_result(new ContentSecurityPolicyIssueDetails()) { }

        template<int STEP> ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_result;
    };

    static ContentSecurityPolicyIssueDetailsBuilder<0> Create()
    {
        return ContentSecurityPolicyIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyIssueDetails();  // Defined below

    std::optional<String> m_blockedURL;
    String m_violatedDirective;
    bool m_isReportOnly;
    String m_contentSecurityPolicyViolationType;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frameAncestor;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    std::optional<int> m_violatingNodeId;
};


class CONTENT_EXPORT SharedArrayBufferIssueDetails : public ::crdtp::ProtocolObject<SharedArrayBufferIssueDetails> {
public:
    ~SharedArrayBufferIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool GetIsWarning() { return m_isWarning; }
    void SetIsWarning(bool value);  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    template<int STATE>
    class SharedArrayBufferIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            IsWarningSet = 1 << 2,
            TypeSet = 1 << 3,
            AllFieldsSet = (SourceCodeLocationSet | IsWarningSet | TypeSet | 0)};


        SharedArrayBufferIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        SharedArrayBufferIssueDetailsBuilder<STATE | IsWarningSet>& SetIsWarning(bool value);  // Defined below

        SharedArrayBufferIssueDetailsBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        std::unique_ptr<SharedArrayBufferIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedArrayBufferIssueDetails;
        SharedArrayBufferIssueDetailsBuilder() : m_result(new SharedArrayBufferIssueDetails()) { }

        template<int STEP> SharedArrayBufferIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedArrayBufferIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_result;
    };

    static SharedArrayBufferIssueDetailsBuilder<0> Create()
    {
        return SharedArrayBufferIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedArrayBufferIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    bool m_isWarning;
    String m_type;
};


class CONTENT_EXPORT LowTextContrastIssueDetails : public ::crdtp::ProtocolObject<LowTextContrastIssueDetails> {
public:
    ~LowTextContrastIssueDetails() override;  // Defined below

    int GetViolatingNodeId() { return m_violatingNodeId; }
    void SetViolatingNodeId(int value);  // Defined below

    String GetViolatingNodeSelector() { return m_violatingNodeSelector; }
    void SetViolatingNodeSelector(const String& value);  // Defined below

    double GetContrastRatio() { return m_contrastRatio; }
    void SetContrastRatio(double value);  // Defined below

    double GetThresholdAA() { return m_thresholdAA; }
    void SetThresholdAA(double value);  // Defined below

    double GetThresholdAAA() { return m_thresholdAAA; }
    void SetThresholdAAA(double value);  // Defined below

    String GetFontSize() { return m_fontSize; }
    void SetFontSize(const String& value);  // Defined below

    String GetFontWeight() { return m_fontWeight; }
    void SetFontWeight(const String& value);  // Defined below

    template<int STATE>
    class LowTextContrastIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatingNodeIdSet = 1 << 1,
            ViolatingNodeSelectorSet = 1 << 2,
            ContrastRatioSet = 1 << 3,
            ThresholdAASet = 1 << 4,
            ThresholdAAASet = 1 << 5,
            FontSizeSet = 1 << 6,
            FontWeightSet = 1 << 7,
            AllFieldsSet = (ViolatingNodeIdSet | ViolatingNodeSelectorSet | ContrastRatioSet | ThresholdAASet | ThresholdAAASet | FontSizeSet | FontWeightSet | 0)};


        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeIdSet>& SetViolatingNodeId(int value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeSelectorSet>& SetViolatingNodeSelector(const String& value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ContrastRatioSet>& SetContrastRatio(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAASet>& SetThresholdAA(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAAASet>& SetThresholdAAA(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | FontSizeSet>& SetFontSize(const String& value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | FontWeightSet>& SetFontWeight(const String& value);  // Defined below

        std::unique_ptr<LowTextContrastIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LowTextContrastIssueDetails;
        LowTextContrastIssueDetailsBuilder() : m_result(new LowTextContrastIssueDetails()) { }

        template<int STEP> LowTextContrastIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LowTextContrastIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_result;
    };

    static LowTextContrastIssueDetailsBuilder<0> Create()
    {
        return LowTextContrastIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LowTextContrastIssueDetails();  // Defined below

    int m_violatingNodeId;
    String m_violatingNodeSelector;
    double m_contrastRatio;
    double m_thresholdAA;
    double m_thresholdAAA;
    String m_fontSize;
    String m_fontWeight;
};


class CONTENT_EXPORT CorsIssueDetails : public ::crdtp::ProtocolObject<CorsIssueDetails> {
public:
    ~CorsIssueDetails() override;  // Defined below

    protocol::Network::CorsErrorStatus* GetCorsErrorStatus() { return m_corsErrorStatus.get(); }
    void SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value);  // Defined below

    bool GetIsWarning() { return m_isWarning; }
    void SetIsWarning(bool value);  // Defined below

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* GetLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetLocation() const {
       return m_location;
    }
    void SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool HasInitiatorOrigin() { return !!m_initiatorOrigin; }
    String GetInitiatorOrigin(const String& defaultValue) const {
       return m_initiatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetInitiatorOrigin() const {
       return m_initiatorOrigin;
    }
    void SetInitiatorOrigin(const String& value);  // Defined below

    bool HasResourceIPAddressSpace() { return !!m_resourceIPAddressSpace; }
    String GetResourceIPAddressSpace(const String& defaultValue) const {
       return m_resourceIPAddressSpace.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceIPAddressSpace() const {
       return m_resourceIPAddressSpace;
    }
    void SetResourceIPAddressSpace(const String& value);  // Defined below

    bool HasClientSecurityState() { return !!m_clientSecurityState; }
    protocol::Network::ClientSecurityState* GetClientSecurityState(protocol::Network::ClientSecurityState* defaultValue) {
       return m_clientSecurityState ? m_clientSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ClientSecurityState>& GetClientSecurityState() const {
       return m_clientSecurityState;
    }
    void SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value);  // Defined below

    template<int STATE>
    class CorsIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorStatusSet = 1 << 1,
            IsWarningSet = 1 << 2,
            RequestSet = 1 << 3,
            AllFieldsSet = (CorsErrorStatusSet | IsWarningSet | RequestSet | 0)};


        CorsIssueDetailsBuilder<STATE | CorsErrorStatusSet>& SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value);  // Defined below

        CorsIssueDetailsBuilder<STATE | IsWarningSet>& SetIsWarning(bool value);  // Defined below

        CorsIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& SetInitiatorOrigin(const String& value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& SetResourceIPAddressSpace(const String& value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value);  // Defined below

        std::unique_ptr<CorsIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsIssueDetails;
        CorsIssueDetailsBuilder() : m_result(new CorsIssueDetails()) { }

        template<int STEP> CorsIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CorsIssueDetails> m_result;
    };

    static CorsIssueDetailsBuilder<0> Create()
    {
        return CorsIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsIssueDetails();  // Defined below

    std::unique_ptr<protocol::Network::CorsErrorStatus> m_corsErrorStatus;
    bool m_isWarning;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
    std::optional<String> m_initiatorOrigin;
    std::optional<String> m_resourceIPAddressSpace;
    std::unique_ptr<protocol::Network::ClientSecurityState> m_clientSecurityState;
};


class CONTENT_EXPORT AttributionReportingIssueDetails : public ::crdtp::ProtocolObject<AttributionReportingIssueDetails> {
public:
    ~AttributionReportingIssueDetails() override;  // Defined below

    String GetViolationType() { return m_violationType; }
    void SetViolationType(const String& value);  // Defined below

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value);  // Defined below

    bool HasInvalidParameter() { return !!m_invalidParameter; }
    String GetInvalidParameter(const String& defaultValue) const {
       return m_invalidParameter.value_or(defaultValue);
    }
    const std::optional<String>& GetInvalidParameter() const {
       return m_invalidParameter;
    }
    void SetInvalidParameter(const String& value);  // Defined below

    template<int STATE>
    class AttributionReportingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolationTypeSet = 1 << 1,
            AllFieldsSet = (ViolationTypeSet | 0)};


        AttributionReportingIssueDetailsBuilder<STATE | ViolationTypeSet>& SetViolationType(const String& value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& SetInvalidParameter(const String& value);  // Defined below

        std::unique_ptr<AttributionReportingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingIssueDetails;
        AttributionReportingIssueDetailsBuilder() : m_result(new AttributionReportingIssueDetails()) { }

        template<int STEP> AttributionReportingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_result;
    };

    static AttributionReportingIssueDetailsBuilder<0> Create()
    {
        return AttributionReportingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingIssueDetails();  // Defined below

    String m_violationType;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_invalidParameter;
};


class CONTENT_EXPORT QuirksModeIssueDetails : public ::crdtp::ProtocolObject<QuirksModeIssueDetails> {
public:
    ~QuirksModeIssueDetails() override;  // Defined below

    bool GetIsLimitedQuirksMode() { return m_isLimitedQuirksMode; }
    void SetIsLimitedQuirksMode(bool value);  // Defined below

    int GetDocumentNodeId() { return m_documentNodeId; }
    void SetDocumentNodeId(int value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value);  // Defined below

    String GetLoaderId() { return m_loaderId; }
    void SetLoaderId(const String& value);  // Defined below

    template<int STATE>
    class QuirksModeIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsLimitedQuirksModeSet = 1 << 1,
            DocumentNodeIdSet = 1 << 2,
            UrlSet = 1 << 3,
            FrameIdSet = 1 << 4,
            LoaderIdSet = 1 << 5,
            AllFieldsSet = (IsLimitedQuirksModeSet | DocumentNodeIdSet | UrlSet | FrameIdSet | LoaderIdSet | 0)};


        QuirksModeIssueDetailsBuilder<STATE | IsLimitedQuirksModeSet>& SetIsLimitedQuirksMode(bool value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | DocumentNodeIdSet>& SetDocumentNodeId(int value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | FrameIdSet>& SetFrameId(const String& value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | LoaderIdSet>& SetLoaderId(const String& value);  // Defined below

        std::unique_ptr<QuirksModeIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class QuirksModeIssueDetails;
        QuirksModeIssueDetailsBuilder() : m_result(new QuirksModeIssueDetails()) { }

        template<int STEP> QuirksModeIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<QuirksModeIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_result;
    };

    static QuirksModeIssueDetailsBuilder<0> Create()
    {
        return QuirksModeIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    QuirksModeIssueDetails();  // Defined below

    bool m_isLimitedQuirksMode;
    int m_documentNodeId;
    String m_url;
    String m_frameId;
    String m_loaderId;
};


class CONTENT_EXPORT NavigatorUserAgentIssueDetails : public ::crdtp::ProtocolObject<NavigatorUserAgentIssueDetails> {
public:
    ~NavigatorUserAgentIssueDetails() override;  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    bool HasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* GetLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetLocation() const {
       return m_location;
    }
    void SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    template<int STATE>
    class NavigatorUserAgentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        NavigatorUserAgentIssueDetailsBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        NavigatorUserAgentIssueDetailsBuilder<STATE>& SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        std::unique_ptr<NavigatorUserAgentIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigatorUserAgentIssueDetails;
        NavigatorUserAgentIssueDetailsBuilder() : m_result(new NavigatorUserAgentIssueDetails()) { }

        template<int STEP> NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_result;
    };

    static NavigatorUserAgentIssueDetailsBuilder<0> Create()
    {
        return NavigatorUserAgentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigatorUserAgentIssueDetails();  // Defined below

    String m_url;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
};


class CONTENT_EXPORT SharedDictionaryIssueDetails : public ::crdtp::ProtocolObject<SharedDictionaryIssueDetails> {
public:
    ~SharedDictionaryIssueDetails() override;  // Defined below

    String GetSharedDictionaryError() { return m_sharedDictionaryError; }
    void SetSharedDictionaryError(const String& value);  // Defined below

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class SharedDictionaryIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SharedDictionaryErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (SharedDictionaryErrorSet | RequestSet | 0)};


        SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryErrorSet>& SetSharedDictionaryError(const String& value);  // Defined below

        SharedDictionaryIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<SharedDictionaryIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedDictionaryIssueDetails;
        SharedDictionaryIssueDetailsBuilder() : m_result(new SharedDictionaryIssueDetails()) { }

        template<int STEP> SharedDictionaryIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedDictionaryIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_result;
    };

    static SharedDictionaryIssueDetailsBuilder<0> Create()
    {
        return SharedDictionaryIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedDictionaryIssueDetails();  // Defined below

    String m_sharedDictionaryError;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT SRIMessageSignatureIssueDetails : public ::crdtp::ProtocolObject<SRIMessageSignatureIssueDetails> {
public:
    ~SRIMessageSignatureIssueDetails() override;  // Defined below

    String GetError() { return m_error; }
    void SetError(const String& value);  // Defined below

    String GetSignatureBase() { return m_signatureBase; }
    void SetSignatureBase(const String& value);  // Defined below

    protocol::Array<String>* GetIntegrityAssertions() { return m_integrityAssertions.get(); }
    void SetIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class SRIMessageSignatureIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            SignatureBaseSet = 1 << 2,
            IntegrityAssertionsSet = 1 << 3,
            RequestSet = 1 << 4,
            AllFieldsSet = (ErrorSet | SignatureBaseSet | IntegrityAssertionsSet | RequestSet | 0)};


        SRIMessageSignatureIssueDetailsBuilder<STATE | ErrorSet>& SetError(const String& value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | SignatureBaseSet>& SetSignatureBase(const String& value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | IntegrityAssertionsSet>& SetIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<SRIMessageSignatureIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SRIMessageSignatureIssueDetails;
        SRIMessageSignatureIssueDetailsBuilder() : m_result(new SRIMessageSignatureIssueDetails()) { }

        template<int STEP> SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_result;
    };

    static SRIMessageSignatureIssueDetailsBuilder<0> Create()
    {
        return SRIMessageSignatureIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SRIMessageSignatureIssueDetails();  // Defined below

    String m_error;
    String m_signatureBase;
    std::unique_ptr<protocol::Array<String>> m_integrityAssertions;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT UnencodedDigestIssueDetails : public ::crdtp::ProtocolObject<UnencodedDigestIssueDetails> {
public:
    ~UnencodedDigestIssueDetails() override;  // Defined below

    String GetError() { return m_error; }
    void SetError(const String& value);  // Defined below

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class UnencodedDigestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (ErrorSet | RequestSet | 0)};


        UnencodedDigestIssueDetailsBuilder<STATE | ErrorSet>& SetError(const String& value);  // Defined below

        UnencodedDigestIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<UnencodedDigestIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UnencodedDigestIssueDetails;
        UnencodedDigestIssueDetailsBuilder() : m_result(new UnencodedDigestIssueDetails()) { }

        template<int STEP> UnencodedDigestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UnencodedDigestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_result;
    };

    static UnencodedDigestIssueDetailsBuilder<0> Create()
    {
        return UnencodedDigestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UnencodedDigestIssueDetails();  // Defined below

    String m_error;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT GenericIssueDetails : public ::crdtp::ProtocolObject<GenericIssueDetails> {
public:
    ~GenericIssueDetails() override;  // Defined below

    String GetErrorType() { return m_errorType; }
    void SetErrorType(const String& value);  // Defined below

    bool HasFrameId() { return !!m_frameId; }
    String GetFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& GetFrameId() const {
       return m_frameId;
    }
    void SetFrameId(const String& value);  // Defined below

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value);  // Defined below

    bool HasViolatingNodeAttribute() { return !!m_violatingNodeAttribute; }
    String GetViolatingNodeAttribute(const String& defaultValue) const {
       return m_violatingNodeAttribute.value_or(defaultValue);
    }
    const std::optional<String>& GetViolatingNodeAttribute() const {
       return m_violatingNodeAttribute;
    }
    void SetViolatingNodeAttribute(const String& value);  // Defined below

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class GenericIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorTypeSet = 1 << 1,
            AllFieldsSet = (ErrorTypeSet | 0)};


        GenericIssueDetailsBuilder<STATE | ErrorTypeSet>& SetErrorType(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& SetFrameId(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& SetViolatingNodeAttribute(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<GenericIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GenericIssueDetails;
        GenericIssueDetailsBuilder() : m_result(new GenericIssueDetails()) { }

        template<int STEP> GenericIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GenericIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::GenericIssueDetails> m_result;
    };

    static GenericIssueDetailsBuilder<0> Create()
    {
        return GenericIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GenericIssueDetails();  // Defined below

    String m_errorType;
    std::optional<String> m_frameId;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_violatingNodeAttribute;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT DeprecationIssueDetails : public ::crdtp::ProtocolObject<DeprecationIssueDetails> {
public:
    ~DeprecationIssueDetails() override;  // Defined below

    bool HasAffectedFrame() { return !!m_affectedFrame; }
    protocol::Audits::AffectedFrame* GetAffectedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_affectedFrame ? m_affectedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetAffectedFrame() const {
       return m_affectedFrame;
    }
    void SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    template<int STATE>
    class DeprecationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | TypeSet | 0)};


        DeprecationIssueDetailsBuilder<STATE>& SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        DeprecationIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        DeprecationIssueDetailsBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        std::unique_ptr<DeprecationIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeprecationIssueDetails;
        DeprecationIssueDetailsBuilder() : m_result(new DeprecationIssueDetails()) { }

        template<int STEP> DeprecationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeprecationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_result;
    };

    static DeprecationIssueDetailsBuilder<0> Create()
    {
        return DeprecationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeprecationIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedFrame> m_affectedFrame;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_type;
};


class CONTENT_EXPORT BounceTrackingIssueDetails : public ::crdtp::ProtocolObject<BounceTrackingIssueDetails> {
public:
    ~BounceTrackingIssueDetails() override;  // Defined below

    protocol::Array<String>* GetTrackingSites() { return m_trackingSites.get(); }
    void SetTrackingSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class BounceTrackingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TrackingSitesSet = 1 << 1,
            AllFieldsSet = (TrackingSitesSet | 0)};


        BounceTrackingIssueDetailsBuilder<STATE | TrackingSitesSet>& SetTrackingSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<BounceTrackingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BounceTrackingIssueDetails;
        BounceTrackingIssueDetailsBuilder() : m_result(new BounceTrackingIssueDetails()) { }

        template<int STEP> BounceTrackingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BounceTrackingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_result;
    };

    static BounceTrackingIssueDetailsBuilder<0> Create()
    {
        return BounceTrackingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BounceTrackingIssueDetails();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_trackingSites;
};


class CONTENT_EXPORT CookieDeprecationMetadataIssueDetails : public ::crdtp::ProtocolObject<CookieDeprecationMetadataIssueDetails> {
public:
    ~CookieDeprecationMetadataIssueDetails() override;  // Defined below

    protocol::Array<String>* GetAllowedSites() { return m_allowedSites.get(); }
    void SetAllowedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    double GetOptOutPercentage() { return m_optOutPercentage; }
    void SetOptOutPercentage(double value);  // Defined below

    bool GetIsOptOutTopLevel() { return m_isOptOutTopLevel; }
    void SetIsOptOutTopLevel(bool value);  // Defined below

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value);  // Defined below

    template<int STATE>
    class CookieDeprecationMetadataIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllowedSitesSet = 1 << 1,
            OptOutPercentageSet = 1 << 2,
            IsOptOutTopLevelSet = 1 << 3,
            OperationSet = 1 << 4,
            AllFieldsSet = (AllowedSitesSet | OptOutPercentageSet | IsOptOutTopLevelSet | OperationSet | 0)};


        CookieDeprecationMetadataIssueDetailsBuilder<STATE | AllowedSitesSet>& SetAllowedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OptOutPercentageSet>& SetOptOutPercentage(double value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | IsOptOutTopLevelSet>& SetIsOptOutTopLevel(bool value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OperationSet>& SetOperation(const String& value);  // Defined below

        std::unique_ptr<CookieDeprecationMetadataIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieDeprecationMetadataIssueDetails;
        CookieDeprecationMetadataIssueDetailsBuilder() : m_result(new CookieDeprecationMetadataIssueDetails()) { }

        template<int STEP> CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_result;
    };

    static CookieDeprecationMetadataIssueDetailsBuilder<0> Create()
    {
        return CookieDeprecationMetadataIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieDeprecationMetadataIssueDetails();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_allowedSites;
    double m_optOutPercentage;
    bool m_isOptOutTopLevel;
    String m_operation;
};


class CONTENT_EXPORT FederatedAuthRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthRequestIssueDetails> {
public:
    ~FederatedAuthRequestIssueDetails() override;  // Defined below

    String GetFederatedAuthRequestIssueReason() { return m_federatedAuthRequestIssueReason; }
    void SetFederatedAuthRequestIssueReason(const String& value);  // Defined below

    template<int STATE>
    class FederatedAuthRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthRequestIssueReasonSet | 0)};


        FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueReasonSet>& SetFederatedAuthRequestIssueReason(const String& value);  // Defined below

        std::unique_ptr<FederatedAuthRequestIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthRequestIssueDetails;
        FederatedAuthRequestIssueDetailsBuilder() : m_result(new FederatedAuthRequestIssueDetails()) { }

        template<int STEP> FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_result;
    };

    static FederatedAuthRequestIssueDetailsBuilder<0> Create()
    {
        return FederatedAuthRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthRequestIssueDetails();  // Defined below

    String m_federatedAuthRequestIssueReason;
};


class CONTENT_EXPORT FederatedAuthUserInfoRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthUserInfoRequestIssueDetails> {
public:
    ~FederatedAuthUserInfoRequestIssueDetails() override;  // Defined below

    String GetFederatedAuthUserInfoRequestIssueReason() { return m_federatedAuthUserInfoRequestIssueReason; }
    void SetFederatedAuthUserInfoRequestIssueReason(const String& value);  // Defined below

    template<int STATE>
    class FederatedAuthUserInfoRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthUserInfoRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthUserInfoRequestIssueReasonSet | 0)};


        FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueReasonSet>& SetFederatedAuthUserInfoRequestIssueReason(const String& value);  // Defined below

        std::unique_ptr<FederatedAuthUserInfoRequestIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthUserInfoRequestIssueDetails;
        FederatedAuthUserInfoRequestIssueDetailsBuilder() : m_result(new FederatedAuthUserInfoRequestIssueDetails()) { }

        template<int STEP> FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_result;
    };

    static FederatedAuthUserInfoRequestIssueDetailsBuilder<0> Create()
    {
        return FederatedAuthUserInfoRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthUserInfoRequestIssueDetails();  // Defined below

    String m_federatedAuthUserInfoRequestIssueReason;
};


class CONTENT_EXPORT ClientHintIssueDetails : public ::crdtp::ProtocolObject<ClientHintIssueDetails> {
public:
    ~ClientHintIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String GetClientHintIssueReason() { return m_clientHintIssueReason; }
    void SetClientHintIssueReason(const String& value);  // Defined below

    template<int STATE>
    class ClientHintIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            ClientHintIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | ClientHintIssueReasonSet | 0)};


        ClientHintIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        ClientHintIssueDetailsBuilder<STATE | ClientHintIssueReasonSet>& SetClientHintIssueReason(const String& value);  // Defined below

        std::unique_ptr<ClientHintIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientHintIssueDetails;
        ClientHintIssueDetailsBuilder() : m_result(new ClientHintIssueDetails()) { }

        template<int STEP> ClientHintIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientHintIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_result;
    };

    static ClientHintIssueDetailsBuilder<0> Create()
    {
        return ClientHintIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientHintIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_clientHintIssueReason;
};


class CONTENT_EXPORT FailedRequestInfo : public ::crdtp::ProtocolObject<FailedRequestInfo> {
public:
    ~FailedRequestInfo() override;  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    String GetFailureMessage() { return m_failureMessage; }
    void SetFailureMessage(const String& value);  // Defined below

    bool HasRequestId() { return !!m_requestId; }
    String GetRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestId() const {
       return m_requestId;
    }
    void SetRequestId(const String& value);  // Defined below

    template<int STATE>
    class FailedRequestInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            FailureMessageSet = 1 << 2,
            AllFieldsSet = (UrlSet | FailureMessageSet | 0)};


        FailedRequestInfoBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        FailedRequestInfoBuilder<STATE | FailureMessageSet>& SetFailureMessage(const String& value);  // Defined below

        FailedRequestInfoBuilder<STATE>& SetRequestId(const String& value);  // Defined below

        std::unique_ptr<FailedRequestInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FailedRequestInfo;
        FailedRequestInfoBuilder() : m_result(new FailedRequestInfo()) { }

        template<int STEP> FailedRequestInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FailedRequestInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FailedRequestInfo> m_result;
    };

    static FailedRequestInfoBuilder<0> Create()
    {
        return FailedRequestInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FailedRequestInfo();  // Defined below

    String m_url;
    String m_failureMessage;
    std::optional<String> m_requestId;
};


class CONTENT_EXPORT PartitioningBlobURLIssueDetails : public ::crdtp::ProtocolObject<PartitioningBlobURLIssueDetails> {
public:
    ~PartitioningBlobURLIssueDetails() override;  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    String GetPartitioningBlobURLInfo() { return m_partitioningBlobURLInfo; }
    void SetPartitioningBlobURLInfo(const String& value);  // Defined below

    template<int STATE>
    class PartitioningBlobURLIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            PartitioningBlobURLInfoSet = 1 << 2,
            AllFieldsSet = (UrlSet | PartitioningBlobURLInfoSet | 0)};


        PartitioningBlobURLIssueDetailsBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLInfoSet>& SetPartitioningBlobURLInfo(const String& value);  // Defined below

        std::unique_ptr<PartitioningBlobURLIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PartitioningBlobURLIssueDetails;
        PartitioningBlobURLIssueDetailsBuilder() : m_result(new PartitioningBlobURLIssueDetails()) { }

        template<int STEP> PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_result;
    };

    static PartitioningBlobURLIssueDetailsBuilder<0> Create()
    {
        return PartitioningBlobURLIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PartitioningBlobURLIssueDetails();  // Defined below

    String m_url;
    String m_partitioningBlobURLInfo;
};


class CONTENT_EXPORT ElementAccessibilityIssueDetails : public ::crdtp::ProtocolObject<ElementAccessibilityIssueDetails> {
public:
    ~ElementAccessibilityIssueDetails() override;  // Defined below

    int GetNodeId() { return m_nodeId; }
    void SetNodeId(int value);  // Defined below

    String GetElementAccessibilityIssueReason() { return m_elementAccessibilityIssueReason; }
    void SetElementAccessibilityIssueReason(const String& value);  // Defined below

    bool GetHasDisallowedAttributes() { return m_hasDisallowedAttributes; }
    void SetHasDisallowedAttributes(bool value);  // Defined below

    template<int STATE>
    class ElementAccessibilityIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            ElementAccessibilityIssueReasonSet = 1 << 2,
            HasDisallowedAttributesSet = 1 << 3,
            AllFieldsSet = (NodeIdSet | ElementAccessibilityIssueReasonSet | HasDisallowedAttributesSet | 0)};


        ElementAccessibilityIssueDetailsBuilder<STATE | NodeIdSet>& SetNodeId(int value);  // Defined below

        ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueReasonSet>& SetElementAccessibilityIssueReason(const String& value);  // Defined below

        ElementAccessibilityIssueDetailsBuilder<STATE | HasDisallowedAttributesSet>& SetHasDisallowedAttributes(bool value);  // Defined below

        std::unique_ptr<ElementAccessibilityIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ElementAccessibilityIssueDetails;
        ElementAccessibilityIssueDetailsBuilder() : m_result(new ElementAccessibilityIssueDetails()) { }

        template<int STEP> ElementAccessibilityIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ElementAccessibilityIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_result;
    };

    static ElementAccessibilityIssueDetailsBuilder<0> Create()
    {
        return ElementAccessibilityIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ElementAccessibilityIssueDetails();  // Defined below

    int m_nodeId;
    String m_elementAccessibilityIssueReason;
    bool m_hasDisallowedAttributes;
};


class CONTENT_EXPORT StylesheetLoadingIssueDetails : public ::crdtp::ProtocolObject<StylesheetLoadingIssueDetails> {
public:
    ~StylesheetLoadingIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String GetStyleSheetLoadingIssueReason() { return m_styleSheetLoadingIssueReason; }
    void SetStyleSheetLoadingIssueReason(const String& value);  // Defined below

    bool HasFailedRequestInfo() { return !!m_failedRequestInfo; }
    protocol::Audits::FailedRequestInfo* GetFailedRequestInfo(protocol::Audits::FailedRequestInfo* defaultValue) {
       return m_failedRequestInfo ? m_failedRequestInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FailedRequestInfo>& GetFailedRequestInfo() const {
       return m_failedRequestInfo;
    }
    void SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value);  // Defined below

    template<int STATE>
    class StylesheetLoadingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            StyleSheetLoadingIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | StyleSheetLoadingIssueReasonSet | 0)};


        StylesheetLoadingIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        StylesheetLoadingIssueDetailsBuilder<STATE | StyleSheetLoadingIssueReasonSet>& SetStyleSheetLoadingIssueReason(const String& value);  // Defined below

        StylesheetLoadingIssueDetailsBuilder<STATE>& SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value);  // Defined below

        std::unique_ptr<StylesheetLoadingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StylesheetLoadingIssueDetails;
        StylesheetLoadingIssueDetailsBuilder() : m_result(new StylesheetLoadingIssueDetails()) { }

        template<int STEP> StylesheetLoadingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StylesheetLoadingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_result;
    };

    static StylesheetLoadingIssueDetailsBuilder<0> Create()
    {
        return StylesheetLoadingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StylesheetLoadingIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_styleSheetLoadingIssueReason;
    std::unique_ptr<protocol::Audits::FailedRequestInfo> m_failedRequestInfo;
};


class CONTENT_EXPORT PropertyRuleIssueDetails : public ::crdtp::ProtocolObject<PropertyRuleIssueDetails> {
public:
    ~PropertyRuleIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String GetPropertyRuleIssueReason() { return m_propertyRuleIssueReason; }
    void SetPropertyRuleIssueReason(const String& value);  // Defined below

    bool HasPropertyValue() { return !!m_propertyValue; }
    String GetPropertyValue(const String& defaultValue) const {
       return m_propertyValue.value_or(defaultValue);
    }
    const std::optional<String>& GetPropertyValue() const {
       return m_propertyValue;
    }
    void SetPropertyValue(const String& value);  // Defined below

    template<int STATE>
    class PropertyRuleIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            PropertyRuleIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | PropertyRuleIssueReasonSet | 0)};


        PropertyRuleIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueReasonSet>& SetPropertyRuleIssueReason(const String& value);  // Defined below

        PropertyRuleIssueDetailsBuilder<STATE>& SetPropertyValue(const String& value);  // Defined below

        std::unique_ptr<PropertyRuleIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyRuleIssueDetails;
        PropertyRuleIssueDetailsBuilder() : m_result(new PropertyRuleIssueDetails()) { }

        template<int STEP> PropertyRuleIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyRuleIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_result;
    };

    static PropertyRuleIssueDetailsBuilder<0> Create()
    {
        return PropertyRuleIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyRuleIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_propertyRuleIssueReason;
    std::optional<String> m_propertyValue;
};


class CONTENT_EXPORT UserReidentificationIssueDetails : public ::crdtp::ProtocolObject<UserReidentificationIssueDetails> {
public:
    ~UserReidentificationIssueDetails() override;  // Defined below

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool HasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    template<int STATE>
    class UserReidentificationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        UserReidentificationIssueDetailsBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        UserReidentificationIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        UserReidentificationIssueDetailsBuilder<STATE>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        std::unique_ptr<UserReidentificationIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserReidentificationIssueDetails;
        UserReidentificationIssueDetailsBuilder() : m_result(new UserReidentificationIssueDetails()) { }

        template<int STEP> UserReidentificationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserReidentificationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_result;
    };

    static UserReidentificationIssueDetailsBuilder<0> Create()
    {
        return UserReidentificationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserReidentificationIssueDetails();  // Defined below

    String m_type;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
};


class CONTENT_EXPORT InspectorIssueDetails : public ::crdtp::ProtocolObject<InspectorIssueDetails> {
public:
    ~InspectorIssueDetails() override;  // Defined below

    bool HasCookieIssueDetails() { return !!m_cookieIssueDetails; }
    protocol::Audits::CookieIssueDetails* GetCookieIssueDetails(protocol::Audits::CookieIssueDetails* defaultValue) {
       return m_cookieIssueDetails ? m_cookieIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueDetails>& GetCookieIssueDetails() const {
       return m_cookieIssueDetails;
    }
    void SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value);  // Defined below

    bool HasMixedContentIssueDetails() { return !!m_mixedContentIssueDetails; }
    protocol::Audits::MixedContentIssueDetails* GetMixedContentIssueDetails(protocol::Audits::MixedContentIssueDetails* defaultValue) {
       return m_mixedContentIssueDetails ? m_mixedContentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::MixedContentIssueDetails>& GetMixedContentIssueDetails() const {
       return m_mixedContentIssueDetails;
    }
    void SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value);  // Defined below

    bool HasBlockedByResponseIssueDetails() { return !!m_blockedByResponseIssueDetails; }
    protocol::Audits::BlockedByResponseIssueDetails* GetBlockedByResponseIssueDetails(protocol::Audits::BlockedByResponseIssueDetails* defaultValue) {
       return m_blockedByResponseIssueDetails ? m_blockedByResponseIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails>& GetBlockedByResponseIssueDetails() const {
       return m_blockedByResponseIssueDetails;
    }
    void SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value);  // Defined below

    bool HasHeavyAdIssueDetails() { return !!m_heavyAdIssueDetails; }
    protocol::Audits::HeavyAdIssueDetails* GetHeavyAdIssueDetails(protocol::Audits::HeavyAdIssueDetails* defaultValue) {
       return m_heavyAdIssueDetails ? m_heavyAdIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::HeavyAdIssueDetails>& GetHeavyAdIssueDetails() const {
       return m_heavyAdIssueDetails;
    }
    void SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value);  // Defined below

    bool HasContentSecurityPolicyIssueDetails() { return !!m_contentSecurityPolicyIssueDetails; }
    protocol::Audits::ContentSecurityPolicyIssueDetails* GetContentSecurityPolicyIssueDetails(protocol::Audits::ContentSecurityPolicyIssueDetails* defaultValue) {
       return m_contentSecurityPolicyIssueDetails ? m_contentSecurityPolicyIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails>& GetContentSecurityPolicyIssueDetails() const {
       return m_contentSecurityPolicyIssueDetails;
    }
    void SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value);  // Defined below

    bool HasSharedArrayBufferIssueDetails() { return !!m_sharedArrayBufferIssueDetails; }
    protocol::Audits::SharedArrayBufferIssueDetails* GetSharedArrayBufferIssueDetails(protocol::Audits::SharedArrayBufferIssueDetails* defaultValue) {
       return m_sharedArrayBufferIssueDetails ? m_sharedArrayBufferIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails>& GetSharedArrayBufferIssueDetails() const {
       return m_sharedArrayBufferIssueDetails;
    }
    void SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value);  // Defined below

    bool HasLowTextContrastIssueDetails() { return !!m_lowTextContrastIssueDetails; }
    protocol::Audits::LowTextContrastIssueDetails* GetLowTextContrastIssueDetails(protocol::Audits::LowTextContrastIssueDetails* defaultValue) {
       return m_lowTextContrastIssueDetails ? m_lowTextContrastIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails>& GetLowTextContrastIssueDetails() const {
       return m_lowTextContrastIssueDetails;
    }
    void SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value);  // Defined below

    bool HasCorsIssueDetails() { return !!m_corsIssueDetails; }
    protocol::Audits::CorsIssueDetails* GetCorsIssueDetails(protocol::Audits::CorsIssueDetails* defaultValue) {
       return m_corsIssueDetails ? m_corsIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CorsIssueDetails>& GetCorsIssueDetails() const {
       return m_corsIssueDetails;
    }
    void SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value);  // Defined below

    bool HasAttributionReportingIssueDetails() { return !!m_attributionReportingIssueDetails; }
    protocol::Audits::AttributionReportingIssueDetails* GetAttributionReportingIssueDetails(protocol::Audits::AttributionReportingIssueDetails* defaultValue) {
       return m_attributionReportingIssueDetails ? m_attributionReportingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails>& GetAttributionReportingIssueDetails() const {
       return m_attributionReportingIssueDetails;
    }
    void SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value);  // Defined below

    bool HasQuirksModeIssueDetails() { return !!m_quirksModeIssueDetails; }
    protocol::Audits::QuirksModeIssueDetails* GetQuirksModeIssueDetails(protocol::Audits::QuirksModeIssueDetails* defaultValue) {
       return m_quirksModeIssueDetails ? m_quirksModeIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::QuirksModeIssueDetails>& GetQuirksModeIssueDetails() const {
       return m_quirksModeIssueDetails;
    }
    void SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value);  // Defined below

    bool HasPartitioningBlobURLIssueDetails() { return !!m_partitioningBlobURLIssueDetails; }
    protocol::Audits::PartitioningBlobURLIssueDetails* GetPartitioningBlobURLIssueDetails(protocol::Audits::PartitioningBlobURLIssueDetails* defaultValue) {
       return m_partitioningBlobURLIssueDetails ? m_partitioningBlobURLIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails>& GetPartitioningBlobURLIssueDetails() const {
       return m_partitioningBlobURLIssueDetails;
    }
    void SetPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value);  // Defined below

    bool HasNavigatorUserAgentIssueDetails() { return !!m_navigatorUserAgentIssueDetails; }
    protocol::Audits::NavigatorUserAgentIssueDetails* GetNavigatorUserAgentIssueDetails(protocol::Audits::NavigatorUserAgentIssueDetails* defaultValue) {
       return m_navigatorUserAgentIssueDetails ? m_navigatorUserAgentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails>& GetNavigatorUserAgentIssueDetails() const {
       return m_navigatorUserAgentIssueDetails;
    }
    void SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value);  // Defined below

    bool HasGenericIssueDetails() { return !!m_genericIssueDetails; }
    protocol::Audits::GenericIssueDetails* GetGenericIssueDetails(protocol::Audits::GenericIssueDetails* defaultValue) {
       return m_genericIssueDetails ? m_genericIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::GenericIssueDetails>& GetGenericIssueDetails() const {
       return m_genericIssueDetails;
    }
    void SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value);  // Defined below

    bool HasDeprecationIssueDetails() { return !!m_deprecationIssueDetails; }
    protocol::Audits::DeprecationIssueDetails* GetDeprecationIssueDetails(protocol::Audits::DeprecationIssueDetails* defaultValue) {
       return m_deprecationIssueDetails ? m_deprecationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::DeprecationIssueDetails>& GetDeprecationIssueDetails() const {
       return m_deprecationIssueDetails;
    }
    void SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value);  // Defined below

    bool HasClientHintIssueDetails() { return !!m_clientHintIssueDetails; }
    protocol::Audits::ClientHintIssueDetails* GetClientHintIssueDetails(protocol::Audits::ClientHintIssueDetails* defaultValue) {
       return m_clientHintIssueDetails ? m_clientHintIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ClientHintIssueDetails>& GetClientHintIssueDetails() const {
       return m_clientHintIssueDetails;
    }
    void SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value);  // Defined below

    bool HasFederatedAuthRequestIssueDetails() { return !!m_federatedAuthRequestIssueDetails; }
    protocol::Audits::FederatedAuthRequestIssueDetails* GetFederatedAuthRequestIssueDetails(protocol::Audits::FederatedAuthRequestIssueDetails* defaultValue) {
       return m_federatedAuthRequestIssueDetails ? m_federatedAuthRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails>& GetFederatedAuthRequestIssueDetails() const {
       return m_federatedAuthRequestIssueDetails;
    }
    void SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value);  // Defined below

    bool HasBounceTrackingIssueDetails() { return !!m_bounceTrackingIssueDetails; }
    protocol::Audits::BounceTrackingIssueDetails* GetBounceTrackingIssueDetails(protocol::Audits::BounceTrackingIssueDetails* defaultValue) {
       return m_bounceTrackingIssueDetails ? m_bounceTrackingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails>& GetBounceTrackingIssueDetails() const {
       return m_bounceTrackingIssueDetails;
    }
    void SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value);  // Defined below

    bool HasCookieDeprecationMetadataIssueDetails() { return !!m_cookieDeprecationMetadataIssueDetails; }
    protocol::Audits::CookieDeprecationMetadataIssueDetails* GetCookieDeprecationMetadataIssueDetails(protocol::Audits::CookieDeprecationMetadataIssueDetails* defaultValue) {
       return m_cookieDeprecationMetadataIssueDetails ? m_cookieDeprecationMetadataIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails>& GetCookieDeprecationMetadataIssueDetails() const {
       return m_cookieDeprecationMetadataIssueDetails;
    }
    void SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value);  // Defined below

    bool HasStylesheetLoadingIssueDetails() { return !!m_stylesheetLoadingIssueDetails; }
    protocol::Audits::StylesheetLoadingIssueDetails* GetStylesheetLoadingIssueDetails(protocol::Audits::StylesheetLoadingIssueDetails* defaultValue) {
       return m_stylesheetLoadingIssueDetails ? m_stylesheetLoadingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails>& GetStylesheetLoadingIssueDetails() const {
       return m_stylesheetLoadingIssueDetails;
    }
    void SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value);  // Defined below

    bool HasPropertyRuleIssueDetails() { return !!m_propertyRuleIssueDetails; }
    protocol::Audits::PropertyRuleIssueDetails* GetPropertyRuleIssueDetails(protocol::Audits::PropertyRuleIssueDetails* defaultValue) {
       return m_propertyRuleIssueDetails ? m_propertyRuleIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails>& GetPropertyRuleIssueDetails() const {
       return m_propertyRuleIssueDetails;
    }
    void SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value);  // Defined below

    bool HasFederatedAuthUserInfoRequestIssueDetails() { return !!m_federatedAuthUserInfoRequestIssueDetails; }
    protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* GetFederatedAuthUserInfoRequestIssueDetails(protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* defaultValue) {
       return m_federatedAuthUserInfoRequestIssueDetails ? m_federatedAuthUserInfoRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails>& GetFederatedAuthUserInfoRequestIssueDetails() const {
       return m_federatedAuthUserInfoRequestIssueDetails;
    }
    void SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value);  // Defined below

    bool HasSharedDictionaryIssueDetails() { return !!m_sharedDictionaryIssueDetails; }
    protocol::Audits::SharedDictionaryIssueDetails* GetSharedDictionaryIssueDetails(protocol::Audits::SharedDictionaryIssueDetails* defaultValue) {
       return m_sharedDictionaryIssueDetails ? m_sharedDictionaryIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails>& GetSharedDictionaryIssueDetails() const {
       return m_sharedDictionaryIssueDetails;
    }
    void SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value);  // Defined below

    bool HasElementAccessibilityIssueDetails() { return !!m_elementAccessibilityIssueDetails; }
    protocol::Audits::ElementAccessibilityIssueDetails* GetElementAccessibilityIssueDetails(protocol::Audits::ElementAccessibilityIssueDetails* defaultValue) {
       return m_elementAccessibilityIssueDetails ? m_elementAccessibilityIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails>& GetElementAccessibilityIssueDetails() const {
       return m_elementAccessibilityIssueDetails;
    }
    void SetElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value);  // Defined below

    bool HasSriMessageSignatureIssueDetails() { return !!m_sriMessageSignatureIssueDetails; }
    protocol::Audits::SRIMessageSignatureIssueDetails* GetSriMessageSignatureIssueDetails(protocol::Audits::SRIMessageSignatureIssueDetails* defaultValue) {
       return m_sriMessageSignatureIssueDetails ? m_sriMessageSignatureIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails>& GetSriMessageSignatureIssueDetails() const {
       return m_sriMessageSignatureIssueDetails;
    }
    void SetSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value);  // Defined below

    bool HasUnencodedDigestIssueDetails() { return !!m_unencodedDigestIssueDetails; }
    protocol::Audits::UnencodedDigestIssueDetails* GetUnencodedDigestIssueDetails(protocol::Audits::UnencodedDigestIssueDetails* defaultValue) {
       return m_unencodedDigestIssueDetails ? m_unencodedDigestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails>& GetUnencodedDigestIssueDetails() const {
       return m_unencodedDigestIssueDetails;
    }
    void SetUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value);  // Defined below

    bool HasUserReidentificationIssueDetails() { return !!m_userReidentificationIssueDetails; }
    protocol::Audits::UserReidentificationIssueDetails* GetUserReidentificationIssueDetails(protocol::Audits::UserReidentificationIssueDetails* defaultValue) {
       return m_userReidentificationIssueDetails ? m_userReidentificationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails>& GetUserReidentificationIssueDetails() const {
       return m_userReidentificationIssueDetails;
    }
    void SetUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value);  // Defined below

    template<int STATE>
    class InspectorIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InspectorIssueDetailsBuilder<STATE>& SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& SetUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value);  // Defined below

        std::unique_ptr<InspectorIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssueDetails;
        InspectorIssueDetailsBuilder() : m_result(new InspectorIssueDetails()) { }

        template<int STEP> InspectorIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_result;
    };

    static InspectorIssueDetailsBuilder<0> Create()
    {
        return InspectorIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::CookieIssueDetails> m_cookieIssueDetails;
    std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_mixedContentIssueDetails;
    std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_blockedByResponseIssueDetails;
    std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_heavyAdIssueDetails;
    std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_contentSecurityPolicyIssueDetails;
    std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_sharedArrayBufferIssueDetails;
    std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_lowTextContrastIssueDetails;
    std::unique_ptr<protocol::Audits::CorsIssueDetails> m_corsIssueDetails;
    std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_attributionReportingIssueDetails;
    std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_quirksModeIssueDetails;
    std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_partitioningBlobURLIssueDetails;
    std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_navigatorUserAgentIssueDetails;
    std::unique_ptr<protocol::Audits::GenericIssueDetails> m_genericIssueDetails;
    std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_deprecationIssueDetails;
    std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_clientHintIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_federatedAuthRequestIssueDetails;
    std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_bounceTrackingIssueDetails;
    std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_cookieDeprecationMetadataIssueDetails;
    std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_stylesheetLoadingIssueDetails;
    std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_propertyRuleIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_federatedAuthUserInfoRequestIssueDetails;
    std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_sharedDictionaryIssueDetails;
    std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_elementAccessibilityIssueDetails;
    std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_sriMessageSignatureIssueDetails;
    std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_unencodedDigestIssueDetails;
    std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_userReidentificationIssueDetails;
};


class CONTENT_EXPORT InspectorIssue : public ::crdtp::ProtocolObject<InspectorIssue> {
public:
    ~InspectorIssue() override;  // Defined below

    String GetCode() { return m_code; }
    void SetCode(const String& value);  // Defined below

    protocol::Audits::InspectorIssueDetails* GetDetails() { return m_details.get(); }
    void SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value);  // Defined below

    bool HasIssueId() { return !!m_issueId; }
    String GetIssueId(const String& defaultValue) const {
       return m_issueId.value_or(defaultValue);
    }
    const std::optional<String>& GetIssueId() const {
       return m_issueId;
    }
    void SetIssueId(const String& value);  // Defined below

    template<int STATE>
    class InspectorIssueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CodeSet = 1 << 1,
            DetailsSet = 1 << 2,
            AllFieldsSet = (CodeSet | DetailsSet | 0)};


        InspectorIssueBuilder<STATE | CodeSet>& SetCode(const String& value);  // Defined below

        InspectorIssueBuilder<STATE | DetailsSet>& SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value);  // Defined below

        InspectorIssueBuilder<STATE>& SetIssueId(const String& value);  // Defined below

        std::unique_ptr<InspectorIssue> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssue;
        InspectorIssueBuilder() : m_result(new InspectorIssue()) { }

        template<int STEP> InspectorIssueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssue> m_result;
    };

    static InspectorIssueBuilder<0> Create()
    {
        return InspectorIssueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssue();  // Defined below

    String m_code;
    std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_details;
    std::optional<String> m_issueId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline AffectedCookie::~AffectedCookie() = default;
inline void AffectedCookie::SetName(const String& value) { m_name = value; }
inline void AffectedCookie::SetPath(const String& value) { m_path = value; }
inline void AffectedCookie::SetDomain(const String& value) { m_domain = value; }

template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::NameSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::PathSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::SetPath(const String& value) {
  static_assert(!(STATE & PathSet), "property path should not be set yet");
  m_result->SetPath(value);
  return castState<PathSet>();
}
template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::DomainSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::SetDomain(const String& value) {
  static_assert(!(STATE & DomainSet), "property domain should not be set yet");
  m_result->SetDomain(value);
  return castState<DomainSet>();
}

inline AffectedCookie::AffectedCookie() {
}
inline AffectedRequest::~AffectedRequest() = default;
inline void AffectedRequest::SetRequestId(const String& value) { m_requestId = value; }
inline void AffectedRequest::SetUrl(const String& value) { m_url = value; }

template<int STATE>
inline AffectedRequest::AffectedRequestBuilder<STATE>& AffectedRequest::AffectedRequestBuilder<STATE>::SetRequestId(const String& value) {
  m_result->SetRequestId(value);
  return *this;
}
template<int STATE>
inline AffectedRequest::AffectedRequestBuilder<STATE | AffectedRequest::AffectedRequestBuilder<STATE>::UrlSet>&
AffectedRequest::AffectedRequestBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}

inline AffectedRequest::AffectedRequest() {
}
inline AffectedFrame::~AffectedFrame() = default;
inline void AffectedFrame::SetFrameId(const String& value) { m_frameId = value; }

template<int STATE>
inline AffectedFrame::AffectedFrameBuilder<STATE | AffectedFrame::AffectedFrameBuilder<STATE>::FrameIdSet>&
AffectedFrame::AffectedFrameBuilder<STATE>::SetFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->SetFrameId(value);
  return castState<FrameIdSet>();
}

inline AffectedFrame::AffectedFrame() {
}
inline CookieIssueInsight::~CookieIssueInsight() = default;
inline void CookieIssueInsight::SetType(const String& value) { m_type = value; }
inline void CookieIssueInsight::SetTableEntryUrl(const String& value) { m_tableEntryUrl = value; }

template<int STATE>
inline CookieIssueInsight::CookieIssueInsightBuilder<STATE | CookieIssueInsight::CookieIssueInsightBuilder<STATE>::TypeSet>&
CookieIssueInsight::CookieIssueInsightBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline CookieIssueInsight::CookieIssueInsightBuilder<STATE>& CookieIssueInsight::CookieIssueInsightBuilder<STATE>::SetTableEntryUrl(const String& value) {
  m_result->SetTableEntryUrl(value);
  return *this;
}

inline CookieIssueInsight::CookieIssueInsight() {
}
inline CookieIssueDetails::~CookieIssueDetails() = default;
inline void CookieIssueDetails::SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) { m_cookie = std::move(value); }
inline void CookieIssueDetails::SetRawCookieLine(const String& value) { m_rawCookieLine = value; }
inline void CookieIssueDetails::SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieWarningReasons = std::move(value); }
inline void CookieIssueDetails::SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieExclusionReasons = std::move(value); }
inline void CookieIssueDetails::SetOperation(const String& value) { m_operation = value; }
inline void CookieIssueDetails::SetSiteForCookies(const String& value) { m_siteForCookies = value; }
inline void CookieIssueDetails::SetCookieUrl(const String& value) { m_cookieUrl = value; }
inline void CookieIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void CookieIssueDetails::SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) { m_insight = std::move(value); }

template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) {
  m_result->SetCookie(std::move(value));
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetRawCookieLine(const String& value) {
  m_result->SetRawCookieLine(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::CookieWarningReasonsSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CookieWarningReasonsSet), "property cookieWarningReasons should not be set yet");
  m_result->SetCookieWarningReasons(std::move(value));
  return castState<CookieWarningReasonsSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::CookieExclusionReasonsSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CookieExclusionReasonsSet), "property cookieExclusionReasons should not be set yet");
  m_result->SetCookieExclusionReasons(std::move(value));
  return castState<CookieExclusionReasonsSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::OperationSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetOperation(const String& value) {
  static_assert(!(STATE & OperationSet), "property operation should not be set yet");
  m_result->SetOperation(value);
  return castState<OperationSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetSiteForCookies(const String& value) {
  m_result->SetSiteForCookies(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetCookieUrl(const String& value) {
  m_result->SetCookieUrl(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->SetRequest(std::move(value));
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) {
  m_result->SetInsight(std::move(value));
  return *this;
}

inline CookieIssueDetails::CookieIssueDetails() {
}
inline MixedContentIssueDetails::~MixedContentIssueDetails() = default;
inline void MixedContentIssueDetails::SetResourceType(const String& value) { m_resourceType = value; }
inline void MixedContentIssueDetails::SetResolutionStatus(const String& value) { m_resolutionStatus = value; }
inline void MixedContentIssueDetails::SetInsecureURL(const String& value) { m_insecureURL = value; }
inline void MixedContentIssueDetails::SetMainResourceURL(const String& value) { m_mainResourceURL = value; }
inline void MixedContentIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void MixedContentIssueDetails::SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetResourceType(const String& value) {
  m_result->SetResourceType(value);
  return *this;
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::ResolutionStatusSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetResolutionStatus(const String& value) {
  static_assert(!(STATE & ResolutionStatusSet), "property resolutionStatus should not be set yet");
  m_result->SetResolutionStatus(value);
  return castState<ResolutionStatusSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::InsecureURLSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetInsecureURL(const String& value) {
  static_assert(!(STATE & InsecureURLSet), "property insecureURL should not be set yet");
  m_result->SetInsecureURL(value);
  return castState<InsecureURLSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::MainResourceURLSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetMainResourceURL(const String& value) {
  static_assert(!(STATE & MainResourceURLSet), "property mainResourceURL should not be set yet");
  m_result->SetMainResourceURL(value);
  return castState<MainResourceURLSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->SetRequest(std::move(value));
  return *this;
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->SetFrame(std::move(value));
  return *this;
}

inline MixedContentIssueDetails::MixedContentIssueDetails() {
}
inline BlockedByResponseIssueDetails::~BlockedByResponseIssueDetails() = default;
inline void BlockedByResponseIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void BlockedByResponseIssueDetails::SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_parentFrame = std::move(value); }
inline void BlockedByResponseIssueDetails::SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_blockedFrame = std::move(value); }
inline void BlockedByResponseIssueDetails::SetReason(const String& value) { m_reason = value; }

template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE | BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::RequestSet>&
BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->SetRequest(std::move(value));
  return castState<RequestSet>();
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>& BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->SetParentFrame(std::move(value));
  return *this;
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>& BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->SetBlockedFrame(std::move(value));
  return *this;
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE | BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::ReasonSet>&
BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::SetReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->SetReason(value);
  return castState<ReasonSet>();
}

inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetails() {
}
inline HeavyAdIssueDetails::~HeavyAdIssueDetails() = default;
inline void HeavyAdIssueDetails::SetResolution(const String& value) { m_resolution = value; }
inline void HeavyAdIssueDetails::SetReason(const String& value) { m_reason = value; }
inline void HeavyAdIssueDetails::SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::ResolutionSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::SetResolution(const String& value) {
  static_assert(!(STATE & ResolutionSet), "property resolution should not be set yet");
  m_result->SetResolution(value);
  return castState<ResolutionSet>();
}
template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::ReasonSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::SetReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->SetReason(value);
  return castState<ReasonSet>();
}
template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::FrameSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  static_assert(!(STATE & FrameSet), "property frame should not be set yet");
  m_result->SetFrame(std::move(value));
  return castState<FrameSet>();
}

inline HeavyAdIssueDetails::HeavyAdIssueDetails() {
}
inline SourceCodeLocation::~SourceCodeLocation() = default;
inline void SourceCodeLocation::SetScriptId(const String& value) { m_scriptId = value; }
inline void SourceCodeLocation::SetUrl(const String& value) { m_url = value; }
inline void SourceCodeLocation::SetLineNumber(int value) { m_lineNumber = value; }
inline void SourceCodeLocation::SetColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE>& SourceCodeLocation::SourceCodeLocationBuilder<STATE>::SetScriptId(const String& value) {
  m_result->SetScriptId(value);
  return *this;
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::UrlSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::LineNumberSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::SetLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->SetLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::ColumnNumberSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::SetColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->SetColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline SourceCodeLocation::SourceCodeLocation() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline ContentSecurityPolicyIssueDetails::~ContentSecurityPolicyIssueDetails() = default;
inline void ContentSecurityPolicyIssueDetails::SetBlockedURL(const String& value) { m_blockedURL = value; }
inline void ContentSecurityPolicyIssueDetails::SetViolatedDirective(const String& value) { m_violatedDirective = value; }
inline void ContentSecurityPolicyIssueDetails::SetIsReportOnly(bool value) { m_isReportOnly = value; }
inline void ContentSecurityPolicyIssueDetails::SetContentSecurityPolicyViolationType(const String& value) { m_contentSecurityPolicyViolationType = value; }
inline void ContentSecurityPolicyIssueDetails::SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frameAncestor = std::move(value); }
inline void ContentSecurityPolicyIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void ContentSecurityPolicyIssueDetails::SetViolatingNodeId(int value) { m_violatingNodeId = value; }

template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetBlockedURL(const String& value) {
  m_result->SetBlockedURL(value);
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::ViolatedDirectiveSet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetViolatedDirective(const String& value) {
  static_assert(!(STATE & ViolatedDirectiveSet), "property violatedDirective should not be set yet");
  m_result->SetViolatedDirective(value);
  return castState<ViolatedDirectiveSet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::IsReportOnlySet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetIsReportOnly(bool value) {
  static_assert(!(STATE & IsReportOnlySet), "property isReportOnly should not be set yet");
  m_result->SetIsReportOnly(value);
  return castState<IsReportOnlySet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::ContentSecurityPolicyViolationTypeSet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetContentSecurityPolicyViolationType(const String& value) {
  static_assert(!(STATE & ContentSecurityPolicyViolationTypeSet), "property contentSecurityPolicyViolationType should not be set yet");
  m_result->SetContentSecurityPolicyViolationType(value);
  return castState<ContentSecurityPolicyViolationTypeSet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->SetFrameAncestor(std::move(value));
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->SetSourceCodeLocation(std::move(value));
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::SetViolatingNodeId(int value) {
  m_result->SetViolatingNodeId(value);
  return *this;
}

inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails() {
  m_isReportOnly = false;
}
inline SharedArrayBufferIssueDetails::~SharedArrayBufferIssueDetails() = default;
inline void SharedArrayBufferIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void SharedArrayBufferIssueDetails::SetIsWarning(bool value) { m_isWarning = value; }
inline void SharedArrayBufferIssueDetails::SetType(const String& value) { m_type = value; }

template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->SetSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::IsWarningSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::SetIsWarning(bool value) {
  static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
  m_result->SetIsWarning(value);
  return castState<IsWarningSet>();
}
template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::TypeSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}

inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetails() {
  m_isWarning = false;
}
inline LowTextContrastIssueDetails::~LowTextContrastIssueDetails() = default;
inline void LowTextContrastIssueDetails::SetViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void LowTextContrastIssueDetails::SetViolatingNodeSelector(const String& value) { m_violatingNodeSelector = value; }
inline void LowTextContrastIssueDetails::SetContrastRatio(double value) { m_contrastRatio = value; }
inline void LowTextContrastIssueDetails::SetThresholdAA(double value) { m_thresholdAA = value; }
inline void LowTextContrastIssueDetails::SetThresholdAAA(double value) { m_thresholdAAA = value; }
inline void LowTextContrastIssueDetails::SetFontSize(const String& value) { m_fontSize = value; }
inline void LowTextContrastIssueDetails::SetFontWeight(const String& value) { m_fontWeight = value; }

template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ViolatingNodeIdSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetViolatingNodeId(int value) {
  static_assert(!(STATE & ViolatingNodeIdSet), "property violatingNodeId should not be set yet");
  m_result->SetViolatingNodeId(value);
  return castState<ViolatingNodeIdSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ViolatingNodeSelectorSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetViolatingNodeSelector(const String& value) {
  static_assert(!(STATE & ViolatingNodeSelectorSet), "property violatingNodeSelector should not be set yet");
  m_result->SetViolatingNodeSelector(value);
  return castState<ViolatingNodeSelectorSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ContrastRatioSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetContrastRatio(double value) {
  static_assert(!(STATE & ContrastRatioSet), "property contrastRatio should not be set yet");
  m_result->SetContrastRatio(value);
  return castState<ContrastRatioSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ThresholdAASet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetThresholdAA(double value) {
  static_assert(!(STATE & ThresholdAASet), "property thresholdAA should not be set yet");
  m_result->SetThresholdAA(value);
  return castState<ThresholdAASet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ThresholdAAASet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetThresholdAAA(double value) {
  static_assert(!(STATE & ThresholdAAASet), "property thresholdAAA should not be set yet");
  m_result->SetThresholdAAA(value);
  return castState<ThresholdAAASet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::FontSizeSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetFontSize(const String& value) {
  static_assert(!(STATE & FontSizeSet), "property fontSize should not be set yet");
  m_result->SetFontSize(value);
  return castState<FontSizeSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::FontWeightSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::SetFontWeight(const String& value) {
  static_assert(!(STATE & FontWeightSet), "property fontWeight should not be set yet");
  m_result->SetFontWeight(value);
  return castState<FontWeightSet>();
}

inline LowTextContrastIssueDetails::LowTextContrastIssueDetails() {
  m_violatingNodeId = 0;
  m_contrastRatio = 0;
  m_thresholdAA = 0;
  m_thresholdAAA = 0;
}
inline CorsIssueDetails::~CorsIssueDetails() = default;
inline void CorsIssueDetails::SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) { m_corsErrorStatus = std::move(value); }
inline void CorsIssueDetails::SetIsWarning(bool value) { m_isWarning = value; }
inline void CorsIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void CorsIssueDetails::SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }
inline void CorsIssueDetails::SetInitiatorOrigin(const String& value) { m_initiatorOrigin = value; }
inline void CorsIssueDetails::SetResourceIPAddressSpace(const String& value) { m_resourceIPAddressSpace = value; }
inline void CorsIssueDetails::SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) { m_clientSecurityState = std::move(value); }

template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::CorsErrorStatusSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) {
  static_assert(!(STATE & CorsErrorStatusSet), "property corsErrorStatus should not be set yet");
  m_result->SetCorsErrorStatus(std::move(value));
  return castState<CorsErrorStatusSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::IsWarningSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetIsWarning(bool value) {
  static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
  m_result->SetIsWarning(value);
  return castState<IsWarningSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::RequestSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->SetRequest(std::move(value));
  return castState<RequestSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->SetLocation(std::move(value));
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetInitiatorOrigin(const String& value) {
  m_result->SetInitiatorOrigin(value);
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetResourceIPAddressSpace(const String& value) {
  m_result->SetResourceIPAddressSpace(value);
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) {
  m_result->SetClientSecurityState(std::move(value));
  return *this;
}

inline CorsIssueDetails::CorsIssueDetails() {
  m_isWarning = false;
}
inline AttributionReportingIssueDetails::~AttributionReportingIssueDetails() = default;
inline void AttributionReportingIssueDetails::SetViolationType(const String& value) { m_violationType = value; }
inline void AttributionReportingIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void AttributionReportingIssueDetails::SetViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void AttributionReportingIssueDetails::SetInvalidParameter(const String& value) { m_invalidParameter = value; }

template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE | AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::ViolationTypeSet>&
AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::SetViolationType(const String& value) {
  static_assert(!(STATE & ViolationTypeSet), "property violationType should not be set yet");
  m_result->SetViolationType(value);
  return castState<ViolationTypeSet>();
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->SetRequest(std::move(value));
  return *this;
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::SetViolatingNodeId(int value) {
  m_result->SetViolatingNodeId(value);
  return *this;
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::SetInvalidParameter(const String& value) {
  m_result->SetInvalidParameter(value);
  return *this;
}

inline AttributionReportingIssueDetails::AttributionReportingIssueDetails() {
}
inline QuirksModeIssueDetails::~QuirksModeIssueDetails() = default;
inline void QuirksModeIssueDetails::SetIsLimitedQuirksMode(bool value) { m_isLimitedQuirksMode = value; }
inline void QuirksModeIssueDetails::SetDocumentNodeId(int value) { m_documentNodeId = value; }
inline void QuirksModeIssueDetails::SetUrl(const String& value) { m_url = value; }
inline void QuirksModeIssueDetails::SetFrameId(const String& value) { m_frameId = value; }
inline void QuirksModeIssueDetails::SetLoaderId(const String& value) { m_loaderId = value; }

template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::IsLimitedQuirksModeSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::SetIsLimitedQuirksMode(bool value) {
  static_assert(!(STATE & IsLimitedQuirksModeSet), "property isLimitedQuirksMode should not be set yet");
  m_result->SetIsLimitedQuirksMode(value);
  return castState<IsLimitedQuirksModeSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::DocumentNodeIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::SetDocumentNodeId(int value) {
  static_assert(!(STATE & DocumentNodeIdSet), "property documentNodeId should not be set yet");
  m_result->SetDocumentNodeId(value);
  return castState<DocumentNodeIdSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::UrlSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::FrameIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::SetFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->SetFrameId(value);
  return castState<FrameIdSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::LoaderIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::SetLoaderId(const String& value) {
  static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
  m_result->SetLoaderId(value);
  return castState<LoaderIdSet>();
}

inline QuirksModeIssueDetails::QuirksModeIssueDetails() {
  m_isLimitedQuirksMode = false;
  m_documentNodeId = 0;
}
inline NavigatorUserAgentIssueDetails::~NavigatorUserAgentIssueDetails() = default;
inline void NavigatorUserAgentIssueDetails::SetUrl(const String& value) { m_url = value; }
inline void NavigatorUserAgentIssueDetails::SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

template<int STATE>
inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE | NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::UrlSet>&
NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>& NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->SetLocation(std::move(value));
  return *this;
}

inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetails() {
}
inline SharedDictionaryIssueDetails::~SharedDictionaryIssueDetails() = default;
inline void SharedDictionaryIssueDetails::SetSharedDictionaryError(const String& value) { m_sharedDictionaryError = value; }
inline void SharedDictionaryIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::SharedDictionaryErrorSet>&
SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::SetSharedDictionaryError(const String& value) {
  static_assert(!(STATE & SharedDictionaryErrorSet), "property sharedDictionaryError should not be set yet");
  m_result->SetSharedDictionaryError(value);
  return castState<SharedDictionaryErrorSet>();
}
template<int STATE>
inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::RequestSet>&
SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->SetRequest(std::move(value));
  return castState<RequestSet>();
}

inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetails() {
}
inline SRIMessageSignatureIssueDetails::~SRIMessageSignatureIssueDetails() = default;
inline void SRIMessageSignatureIssueDetails::SetError(const String& value) { m_error = value; }
inline void SRIMessageSignatureIssueDetails::SetSignatureBase(const String& value) { m_signatureBase = value; }
inline void SRIMessageSignatureIssueDetails::SetIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value) { m_integrityAssertions = std::move(value); }
inline void SRIMessageSignatureIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::ErrorSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SetError(const String& value) {
  static_assert(!(STATE & ErrorSet), "property error should not be set yet");
  m_result->SetError(value);
  return castState<ErrorSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SignatureBaseSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SetSignatureBase(const String& value) {
  static_assert(!(STATE & SignatureBaseSet), "property signatureBase should not be set yet");
  m_result->SetSignatureBase(value);
  return castState<SignatureBaseSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::IntegrityAssertionsSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SetIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & IntegrityAssertionsSet), "property integrityAssertions should not be set yet");
  m_result->SetIntegrityAssertions(std::move(value));
  return castState<IntegrityAssertionsSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::RequestSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->SetRequest(std::move(value));
  return castState<RequestSet>();
}

inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetails() {
}
inline UnencodedDigestIssueDetails::~UnencodedDigestIssueDetails() = default;
inline void UnencodedDigestIssueDetails::SetError(const String& value) { m_error = value; }
inline void UnencodedDigestIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE | UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::ErrorSet>&
UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::SetError(const String& value) {
  static_assert(!(STATE & ErrorSet), "property error should not be set yet");
  m_result->SetError(value);
  return castState<ErrorSet>();
}
template<int STATE>
inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE | UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::RequestSet>&
UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->SetRequest(std::move(value));
  return castState<RequestSet>();
}

inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetails() {
}
inline GenericIssueDetails::~GenericIssueDetails() = default;
inline void GenericIssueDetails::SetErrorType(const String& value) { m_errorType = value; }
inline void GenericIssueDetails::SetFrameId(const String& value) { m_frameId = value; }
inline void GenericIssueDetails::SetViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void GenericIssueDetails::SetViolatingNodeAttribute(const String& value) { m_violatingNodeAttribute = value; }
inline void GenericIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE | GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::ErrorTypeSet>&
GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::SetErrorType(const String& value) {
  static_assert(!(STATE & ErrorTypeSet), "property errorType should not be set yet");
  m_result->SetErrorType(value);
  return castState<ErrorTypeSet>();
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::SetFrameId(const String& value) {
  m_result->SetFrameId(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::SetViolatingNodeId(int value) {
  m_result->SetViolatingNodeId(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::SetViolatingNodeAttribute(const String& value) {
  m_result->SetViolatingNodeAttribute(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->SetRequest(std::move(value));
  return *this;
}

inline GenericIssueDetails::GenericIssueDetails() {
}
inline DeprecationIssueDetails::~DeprecationIssueDetails() = default;
inline void DeprecationIssueDetails::SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_affectedFrame = std::move(value); }
inline void DeprecationIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void DeprecationIssueDetails::SetType(const String& value) { m_type = value; }

template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>& DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->SetAffectedFrame(std::move(value));
  return *this;
}
template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE | DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->SetSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE | DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::TypeSet>&
DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}

inline DeprecationIssueDetails::DeprecationIssueDetails() {
}
inline BounceTrackingIssueDetails::~BounceTrackingIssueDetails() = default;
inline void BounceTrackingIssueDetails::SetTrackingSites(std::unique_ptr<protocol::Array<String>> value) { m_trackingSites = std::move(value); }

template<int STATE>
inline BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE | BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE>::TrackingSitesSet>&
BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE>::SetTrackingSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & TrackingSitesSet), "property trackingSites should not be set yet");
  m_result->SetTrackingSites(std::move(value));
  return castState<TrackingSitesSet>();
}

inline BounceTrackingIssueDetails::BounceTrackingIssueDetails() {
}
inline CookieDeprecationMetadataIssueDetails::~CookieDeprecationMetadataIssueDetails() = default;
inline void CookieDeprecationMetadataIssueDetails::SetAllowedSites(std::unique_ptr<protocol::Array<String>> value) { m_allowedSites = std::move(value); }
inline void CookieDeprecationMetadataIssueDetails::SetOptOutPercentage(double value) { m_optOutPercentage = value; }
inline void CookieDeprecationMetadataIssueDetails::SetIsOptOutTopLevel(bool value) { m_isOptOutTopLevel = value; }
inline void CookieDeprecationMetadataIssueDetails::SetOperation(const String& value) { m_operation = value; }

template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::AllowedSitesSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::SetAllowedSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & AllowedSitesSet), "property allowedSites should not be set yet");
  m_result->SetAllowedSites(std::move(value));
  return castState<AllowedSitesSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::OptOutPercentageSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::SetOptOutPercentage(double value) {
  static_assert(!(STATE & OptOutPercentageSet), "property optOutPercentage should not be set yet");
  m_result->SetOptOutPercentage(value);
  return castState<OptOutPercentageSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::IsOptOutTopLevelSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::SetIsOptOutTopLevel(bool value) {
  static_assert(!(STATE & IsOptOutTopLevelSet), "property isOptOutTopLevel should not be set yet");
  m_result->SetIsOptOutTopLevel(value);
  return castState<IsOptOutTopLevelSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::OperationSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::SetOperation(const String& value) {
  static_assert(!(STATE & OperationSet), "property operation should not be set yet");
  m_result->SetOperation(value);
  return castState<OperationSet>();
}

inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetails() {
  m_optOutPercentage = 0;
  m_isOptOutTopLevel = false;
}
inline FederatedAuthRequestIssueDetails::~FederatedAuthRequestIssueDetails() = default;
inline void FederatedAuthRequestIssueDetails::SetFederatedAuthRequestIssueReason(const String& value) { m_federatedAuthRequestIssueReason = value; }

template<int STATE>
inline FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE>::FederatedAuthRequestIssueReasonSet>&
FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE>::SetFederatedAuthRequestIssueReason(const String& value) {
  static_assert(!(STATE & FederatedAuthRequestIssueReasonSet), "property federatedAuthRequestIssueReason should not be set yet");
  m_result->SetFederatedAuthRequestIssueReason(value);
  return castState<FederatedAuthRequestIssueReasonSet>();
}

inline FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetails() {
}
inline FederatedAuthUserInfoRequestIssueDetails::~FederatedAuthUserInfoRequestIssueDetails() = default;
inline void FederatedAuthUserInfoRequestIssueDetails::SetFederatedAuthUserInfoRequestIssueReason(const String& value) { m_federatedAuthUserInfoRequestIssueReason = value; }

template<int STATE>
inline FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE>::FederatedAuthUserInfoRequestIssueReasonSet>&
FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE>::SetFederatedAuthUserInfoRequestIssueReason(const String& value) {
  static_assert(!(STATE & FederatedAuthUserInfoRequestIssueReasonSet), "property federatedAuthUserInfoRequestIssueReason should not be set yet");
  m_result->SetFederatedAuthUserInfoRequestIssueReason(value);
  return castState<FederatedAuthUserInfoRequestIssueReasonSet>();
}

inline FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetails() {
}
inline ClientHintIssueDetails::~ClientHintIssueDetails() = default;
inline void ClientHintIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void ClientHintIssueDetails::SetClientHintIssueReason(const String& value) { m_clientHintIssueReason = value; }

template<int STATE>
inline ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE | ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->SetSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE | ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::ClientHintIssueReasonSet>&
ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::SetClientHintIssueReason(const String& value) {
  static_assert(!(STATE & ClientHintIssueReasonSet), "property clientHintIssueReason should not be set yet");
  m_result->SetClientHintIssueReason(value);
  return castState<ClientHintIssueReasonSet>();
}

inline ClientHintIssueDetails::ClientHintIssueDetails() {
}
inline FailedRequestInfo::~FailedRequestInfo() = default;
inline void FailedRequestInfo::SetUrl(const String& value) { m_url = value; }
inline void FailedRequestInfo::SetFailureMessage(const String& value) { m_failureMessage = value; }
inline void FailedRequestInfo::SetRequestId(const String& value) { m_requestId = value; }

template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE | FailedRequestInfo::FailedRequestInfoBuilder<STATE>::UrlSet>&
FailedRequestInfo::FailedRequestInfoBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE | FailedRequestInfo::FailedRequestInfoBuilder<STATE>::FailureMessageSet>&
FailedRequestInfo::FailedRequestInfoBuilder<STATE>::SetFailureMessage(const String& value) {
  static_assert(!(STATE & FailureMessageSet), "property failureMessage should not be set yet");
  m_result->SetFailureMessage(value);
  return castState<FailureMessageSet>();
}
template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE>& FailedRequestInfo::FailedRequestInfoBuilder<STATE>::SetRequestId(const String& value) {
  m_result->SetRequestId(value);
  return *this;
}

inline FailedRequestInfo::FailedRequestInfo() {
}
inline PartitioningBlobURLIssueDetails::~PartitioningBlobURLIssueDetails() = default;
inline void PartitioningBlobURLIssueDetails::SetUrl(const String& value) { m_url = value; }
inline void PartitioningBlobURLIssueDetails::SetPartitioningBlobURLInfo(const String& value) { m_partitioningBlobURLInfo = value; }

template<int STATE>
inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::UrlSet>&
PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::PartitioningBlobURLInfoSet>&
PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::SetPartitioningBlobURLInfo(const String& value) {
  static_assert(!(STATE & PartitioningBlobURLInfoSet), "property partitioningBlobURLInfo should not be set yet");
  m_result->SetPartitioningBlobURLInfo(value);
  return castState<PartitioningBlobURLInfoSet>();
}

inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetails() {
}
inline ElementAccessibilityIssueDetails::~ElementAccessibilityIssueDetails() = default;
inline void ElementAccessibilityIssueDetails::SetNodeId(int value) { m_nodeId = value; }
inline void ElementAccessibilityIssueDetails::SetElementAccessibilityIssueReason(const String& value) { m_elementAccessibilityIssueReason = value; }
inline void ElementAccessibilityIssueDetails::SetHasDisallowedAttributes(bool value) { m_hasDisallowedAttributes = value; }

template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::NodeIdSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::SetNodeId(int value) {
  static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
  m_result->SetNodeId(value);
  return castState<NodeIdSet>();
}
template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::ElementAccessibilityIssueReasonSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::SetElementAccessibilityIssueReason(const String& value) {
  static_assert(!(STATE & ElementAccessibilityIssueReasonSet), "property elementAccessibilityIssueReason should not be set yet");
  m_result->SetElementAccessibilityIssueReason(value);
  return castState<ElementAccessibilityIssueReasonSet>();
}
template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::HasDisallowedAttributesSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::SetHasDisallowedAttributes(bool value) {
  static_assert(!(STATE & HasDisallowedAttributesSet), "property hasDisallowedAttributes should not be set yet");
  m_result->SetHasDisallowedAttributes(value);
  return castState<HasDisallowedAttributesSet>();
}

inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetails() {
  m_nodeId = 0;
  m_hasDisallowedAttributes = false;
}
inline StylesheetLoadingIssueDetails::~StylesheetLoadingIssueDetails() = default;
inline void StylesheetLoadingIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void StylesheetLoadingIssueDetails::SetStyleSheetLoadingIssueReason(const String& value) { m_styleSheetLoadingIssueReason = value; }
inline void StylesheetLoadingIssueDetails::SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) { m_failedRequestInfo = std::move(value); }

template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE | StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->SetSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE | StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::StyleSheetLoadingIssueReasonSet>&
StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::SetStyleSheetLoadingIssueReason(const String& value) {
  static_assert(!(STATE & StyleSheetLoadingIssueReasonSet), "property styleSheetLoadingIssueReason should not be set yet");
  m_result->SetStyleSheetLoadingIssueReason(value);
  return castState<StyleSheetLoadingIssueReasonSet>();
}
template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>& StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) {
  m_result->SetFailedRequestInfo(std::move(value));
  return *this;
}

inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetails() {
}
inline PropertyRuleIssueDetails::~PropertyRuleIssueDetails() = default;
inline void PropertyRuleIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void PropertyRuleIssueDetails::SetPropertyRuleIssueReason(const String& value) { m_propertyRuleIssueReason = value; }
inline void PropertyRuleIssueDetails::SetPropertyValue(const String& value) { m_propertyValue = value; }

template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->SetSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::PropertyRuleIssueReasonSet>&
PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::SetPropertyRuleIssueReason(const String& value) {
  static_assert(!(STATE & PropertyRuleIssueReasonSet), "property propertyRuleIssueReason should not be set yet");
  m_result->SetPropertyRuleIssueReason(value);
  return castState<PropertyRuleIssueReasonSet>();
}
template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>& PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::SetPropertyValue(const String& value) {
  m_result->SetPropertyValue(value);
  return *this;
}

inline PropertyRuleIssueDetails::PropertyRuleIssueDetails() {
}
inline UserReidentificationIssueDetails::~UserReidentificationIssueDetails() = default;
inline void UserReidentificationIssueDetails::SetType(const String& value) { m_type = value; }
inline void UserReidentificationIssueDetails::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void UserReidentificationIssueDetails::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE | UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::TypeSet>&
UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>& UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->SetRequest(std::move(value));
  return *this;
}
template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>& UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->SetSourceCodeLocation(std::move(value));
  return *this;
}

inline UserReidentificationIssueDetails::UserReidentificationIssueDetails() {
}
inline InspectorIssueDetails::~InspectorIssueDetails() = default;
inline void InspectorIssueDetails::SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) { m_cookieIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) { m_mixedContentIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) { m_blockedByResponseIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) { m_heavyAdIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) { m_contentSecurityPolicyIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) { m_sharedArrayBufferIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) { m_lowTextContrastIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) { m_corsIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) { m_attributionReportingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) { m_quirksModeIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value) { m_partitioningBlobURLIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) { m_navigatorUserAgentIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) { m_genericIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) { m_deprecationIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) { m_clientHintIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) { m_federatedAuthRequestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) { m_bounceTrackingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) { m_cookieDeprecationMetadataIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) { m_stylesheetLoadingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) { m_propertyRuleIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) { m_federatedAuthUserInfoRequestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) { m_sharedDictionaryIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value) { m_elementAccessibilityIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value) { m_sriMessageSignatureIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value) { m_unencodedDigestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::SetUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value) { m_userReidentificationIssueDetails = std::move(value); }

template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) {
  m_result->SetCookieIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) {
  m_result->SetMixedContentIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) {
  m_result->SetBlockedByResponseIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) {
  m_result->SetHeavyAdIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) {
  m_result->SetContentSecurityPolicyIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) {
  m_result->SetSharedArrayBufferIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) {
  m_result->SetLowTextContrastIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) {
  m_result->SetCorsIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) {
  m_result->SetAttributionReportingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) {
  m_result->SetQuirksModeIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value) {
  m_result->SetPartitioningBlobURLIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) {
  m_result->SetNavigatorUserAgentIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) {
  m_result->SetGenericIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) {
  m_result->SetDeprecationIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) {
  m_result->SetClientHintIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) {
  m_result->SetFederatedAuthRequestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) {
  m_result->SetBounceTrackingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) {
  m_result->SetCookieDeprecationMetadataIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) {
  m_result->SetStylesheetLoadingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) {
  m_result->SetPropertyRuleIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) {
  m_result->SetFederatedAuthUserInfoRequestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) {
  m_result->SetSharedDictionaryIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value) {
  m_result->SetElementAccessibilityIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value) {
  m_result->SetSriMessageSignatureIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value) {
  m_result->SetUnencodedDigestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::SetUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value) {
  m_result->SetUserReidentificationIssueDetails(std::move(value));
  return *this;
}

inline InspectorIssueDetails::InspectorIssueDetails() {
}
inline InspectorIssue::~InspectorIssue() = default;
inline void InspectorIssue::SetCode(const String& value) { m_code = value; }
inline void InspectorIssue::SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) { m_details = std::move(value); }
inline void InspectorIssue::SetIssueId(const String& value) { m_issueId = value; }

template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE | InspectorIssue::InspectorIssueBuilder<STATE>::CodeSet>&
InspectorIssue::InspectorIssueBuilder<STATE>::SetCode(const String& value) {
  static_assert(!(STATE & CodeSet), "property code should not be set yet");
  m_result->SetCode(value);
  return castState<CodeSet>();
}
template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE | InspectorIssue::InspectorIssueBuilder<STATE>::DetailsSet>&
InspectorIssue::InspectorIssueBuilder<STATE>::SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) {
  static_assert(!(STATE & DetailsSet), "property details should not be set yet");
  m_result->SetDetails(std::move(value));
  return castState<DetailsSet>();
}
template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE>& InspectorIssue::InspectorIssueBuilder<STATE>::SetIssueId(const String& value) {
  m_result->SetIssueId(value);
  return *this;
}

inline InspectorIssue::InspectorIssue() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void IssueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Audits
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Audits_h)
