// content/browser/attribution_reporting/attribution_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-features.h"  // IWYU pragma: export
#include "content/browser/attribution_reporting/attribution_internals.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/attribution_reporting/attribution_internals.mojom-forward.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration.mojom.h"
#include "components/attribution_reporting/source_type.mojom-forward.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-forward.h"
#include "content/browser/attribution_reporting/aggregatable_result.mojom-forward.h"
#include "content/browser/attribution_reporting/process_aggregatable_debug_report_result.mojom-forward.h"
#include "content/browser/attribution_reporting/attribution_reporting.mojom-forward.h"
#include "content/browser/attribution_reporting/event_level_result.mojom-forward.h"
#include "content/browser/attribution_reporting/store_source_result.mojom-forward.h"
#include "services/network/public/mojom/attribution.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/browser/attribution_reporting/attribution_internals_mojom_traits.h"
#include "content/browser/attribution_reporting/attribution_report.h"


namespace attribution_reporting { class DestinationSet; }
namespace attribution_reporting { class EventReportWindows; }
namespace attribution_reporting { class FilterData; }


namespace attribution_internals::mojom {

class ObserverProxy;

template <typename ImplRefTraits>
class ObserverStub;

class ObserverRequestValidator;


class Observer
    : public ObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "attribution_internals.mojom.Observer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ObserverInterfaceBase;
  using Proxy_ = ObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ObserverStub<ImplRefTraits>;

  using RequestValidator_ = ObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSourcesChangedMinVersion = 0,
    kOnReportsChangedMinVersion = 0,
    kOnSourceHandledMinVersion = 0,
    kOnReportHandledMinVersion = 0,
    kOnDebugReportSentMinVersion = 0,
    kOnAggregatableDebugReportSentMinVersion = 0,
    kOnTriggerHandledMinVersion = 0,
    kOnOsRegistrationMinVersion = 0,
    kOnDebugModeChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSourcesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSourceHandled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportHandled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDebugReportSent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAggregatableDebugReportSent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTriggerHandled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOsRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDebugModeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Observer() = default;

  virtual void OnSourcesChanged(std::vector<WebUISourcePtr> sources) = 0;

  virtual void OnReportsChanged(std::vector<WebUIReportPtr> reports) = 0;

  virtual void OnSourceHandled(WebUISourceRegistrationPtr source) = 0;

  virtual void OnReportHandled(WebUIReportPtr report) = 0;

  virtual void OnDebugReportSent(WebUIDebugReportPtr report) = 0;

  virtual void OnAggregatableDebugReportSent(WebUIAggregatableDebugReportPtr report) = 0;

  virtual void OnTriggerHandled(WebUITriggerPtr trigger) = 0;

  virtual void OnOsRegistration(WebUIOsRegistrationPtr registration) = 0;

  virtual void OnDebugModeChanged(bool debug_mode) = 0;
};

class HandlerProxy;

template <typename ImplRefTraits>
class HandlerStub;

class HandlerRequestValidator;
class HandlerResponseValidator;


class Handler
    : public HandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "attribution_internals.mojom.Handler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HandlerInterfaceBase;
  using Proxy_ = HandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HandlerStub<ImplRefTraits>;

  using RequestValidator_ = HandlerRequestValidator;
  using ResponseValidator_ = HandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsAttributionReportingEnabledMinVersion = 0,
    kSendReportMinVersion = 0,
    kClearStorageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IsAttributionReportingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Handler() = default;

  using IsAttributionReportingEnabledCallback = base::OnceCallback<void(bool, ::network::mojom::AttributionSupport)>;
  using IsAttributionReportingEnabledMojoCallback = base::OnceCallback<void(bool, ::network::mojom::AttributionSupport)>;

  virtual void IsAttributionReportingEnabled(IsAttributionReportingEnabledCallback callback) = 0;

  using SendReportCallback = base::OnceCallback<void()>;
  using SendReportMojoCallback = base::OnceCallback<void()>;

  virtual void SendReport(::content::AttributionReport::Id id, SendReportCallback callback) = 0;

  using ClearStorageCallback = base::OnceCallback<void()>;
  using ClearStorageMojoCallback = base::OnceCallback<void()>;

  virtual void ClearStorage(ClearStorageCallback callback) = 0;
};

class FactoryProxy;

template <typename ImplRefTraits>
class FactoryStub;

class FactoryRequestValidator;


class Factory
    : public FactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "attribution_internals.mojom.Factory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FactoryInterfaceBase;
  using Proxy_ = FactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FactoryStub<ImplRefTraits>;

  using RequestValidator_ = FactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Factory() = default;

  virtual void Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) = 0;
};



class  ObserverProxy
    : public Observer {
 public:
  using InterfaceType = Observer;

  explicit ObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSourcesChanged(std::vector<WebUISourcePtr> sources) final;
  
  void OnReportsChanged(std::vector<WebUIReportPtr> reports) final;
  
  void OnSourceHandled(WebUISourceRegistrationPtr source) final;
  
  void OnReportHandled(WebUIReportPtr report) final;
  
  void OnDebugReportSent(WebUIDebugReportPtr report) final;
  
  void OnAggregatableDebugReportSent(WebUIAggregatableDebugReportPtr report) final;
  
  void OnTriggerHandled(WebUITriggerPtr trigger) final;
  
  void OnOsRegistration(WebUIOsRegistrationPtr registration) final;
  
  void OnDebugModeChanged(bool debug_mode) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HandlerProxy
    : public Handler {
 public:
  using InterfaceType = Handler;

  explicit HandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void IsAttributionReportingEnabled(IsAttributionReportingEnabledCallback callback) final;
  
  void SendReport(::content::AttributionReport::Id id, SendReportCallback callback) final;
  
  void ClearStorage(ClearStorageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FactoryProxy
    : public Factory {
 public:
  using InterfaceType = Factory;

  explicit FactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ObserverStubDispatch {
 public:
  static bool Accept(Observer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Observer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Observer>>
class ObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ObserverStub() = default;
  ~ObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HandlerStubDispatch {
 public:
  static bool Accept(Handler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Handler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Handler>>
class HandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HandlerStub() = default;
  ~HandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FactoryStubDispatch {
 public:
  static bool Accept(Factory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Factory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Factory>>
class FactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FactoryStub() = default;
  ~FactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ReportID {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReportID, T>::value>;
  using DataView = ReportIDDataView;
  using Data_ = internal::ReportID_Data;

  template <typename... Args>
  static ReportIDPtr New(Args&&... args) {
    return ReportIDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReportIDPtr From(const U& u) {
    return mojo::TypeConverter<ReportIDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReportID>::Convert(*this);
  }


  ReportID();

  explicit ReportID(
      int64_t value);


  ~ReportID();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReportIDPtr>
  ReportIDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReportID::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReportID::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReportID::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReportID::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReportID::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReportID::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReportID_UnserializedMessageContext<
            UserType, ReportID::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReportID::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReportID::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReportID_UnserializedMessageContext<
            UserType, ReportID::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReportID::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReportID::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReportID::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReportID::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReportID::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIReportEventLevelData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIReportEventLevelData, T>::value>;
  using DataView = WebUIReportEventLevelDataDataView;
  using Data_ = internal::WebUIReportEventLevelData_Data;

  template <typename... Args>
  static WebUIReportEventLevelDataPtr New(Args&&... args) {
    return WebUIReportEventLevelDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIReportEventLevelDataPtr From(const U& u) {
    return mojo::TypeConverter<WebUIReportEventLevelDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIReportEventLevelData>::Convert(*this);
  }


  WebUIReportEventLevelData();

  WebUIReportEventLevelData(
      int64_t priority,
      bool attributed_truthfully);


  ~WebUIReportEventLevelData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIReportEventLevelDataPtr>
  WebUIReportEventLevelDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReportEventLevelData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReportEventLevelData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIReportEventLevelData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIReportEventLevelData_UnserializedMessageContext<
            UserType, WebUIReportEventLevelData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIReportEventLevelData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIReportEventLevelData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIReportEventLevelData_UnserializedMessageContext<
            UserType, WebUIReportEventLevelData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIReportEventLevelData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t priority;
  
  bool attributed_truthfully;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIReportEventLevelData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AggregatableHistogramContribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableHistogramContribution, T>::value>;
  using DataView = AggregatableHistogramContributionDataView;
  using Data_ = internal::AggregatableHistogramContribution_Data;

  template <typename... Args>
  static AggregatableHistogramContributionPtr New(Args&&... args) {
    return AggregatableHistogramContributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableHistogramContributionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableHistogramContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableHistogramContribution>::Convert(*this);
  }


  AggregatableHistogramContribution();

  AggregatableHistogramContribution(
      const std::string& key,
      uint32_t value,
      uint64_t filtering_id);


  ~AggregatableHistogramContribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableHistogramContributionPtr>
  AggregatableHistogramContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableHistogramContribution::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableHistogramContribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableHistogramContribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableHistogramContribution_UnserializedMessageContext<
            UserType, AggregatableHistogramContribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableHistogramContribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableHistogramContribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableHistogramContribution_UnserializedMessageContext<
            UserType, AggregatableHistogramContribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableHistogramContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  uint32_t value;
  
  uint64_t filtering_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Empty {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Empty, T>::value>;
  using DataView = EmptyDataView;
  using Data_ = internal::Empty_Data;

  template <typename... Args>
  static EmptyPtr New(Args&&... args) {
    return EmptyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmptyPtr From(const U& u) {
    return mojo::TypeConverter<EmptyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Empty>::Convert(*this);
  }


  Empty();


  ~Empty();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmptyPtr>
  EmptyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Empty::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Empty::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Empty::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Empty_UnserializedMessageContext<
            UserType, Empty::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Empty::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Empty::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Empty_UnserializedMessageContext<
            UserType, Empty::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Empty::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  WebUIReportData {
 public:
  using DataView = WebUIReportDataDataView;
  using Data_ = internal::WebUIReportData_Data;
  using Tag = Data_::WebUIReportData_Tag;

  template <typename... Args>
  static WebUIReportDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |event_level_data|.
  static WebUIReportDataPtr NewEventLevelData(
      WebUIReportEventLevelDataPtr value);
  // Construct an instance holding |aggregatable_attribution_data|.
  static WebUIReportDataPtr NewAggregatableAttributionData(
      WebUIReportAggregatableAttributionDataPtr value);

  template <typename U>
  static WebUIReportDataPtr From(const U& u) {
    return mojo::TypeConverter<WebUIReportDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIReportData>::Convert(*this);
  }
  ~WebUIReportData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebUIReportData(const WebUIReportData& other) = delete;
  WebUIReportData& operator=(const WebUIReportData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebUIReportDataPtr>
  WebUIReportDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIReportData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIReportData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_event_level_data() const { return tag_ == Tag::kEventLevelData; }
  const WebUIReportEventLevelDataPtr& get_event_level_data() const {
    CHECK(tag_ == Tag::kEventLevelData);
    return data_.event_level_data;
  }
  WebUIReportEventLevelDataPtr& get_event_level_data() {
    CHECK(tag_ == Tag::kEventLevelData);
    return data_.event_level_data;
  }
  void set_event_level_data(WebUIReportEventLevelDataPtr event_level_data);

  bool is_aggregatable_attribution_data() const { return tag_ == Tag::kAggregatableAttributionData; }
  const WebUIReportAggregatableAttributionDataPtr& get_aggregatable_attribution_data() const {
    CHECK(tag_ == Tag::kAggregatableAttributionData);
    return data_.aggregatable_attribution_data;
  }
  WebUIReportAggregatableAttributionDataPtr& get_aggregatable_attribution_data() {
    CHECK(tag_ == Tag::kAggregatableAttributionData);
    return data_.aggregatable_attribution_data;
  }
  void set_aggregatable_attribution_data(WebUIReportAggregatableAttributionDataPtr aggregatable_attribution_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIReportData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebUIReportData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEventLevelData)>,
        WebUIReportEventLevelDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
        WebUIReportAggregatableAttributionDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WebUIReportEventLevelDataPtr event_level_data;
    WebUIReportAggregatableAttributionDataPtr aggregatable_attribution_data;
  };

  WebUIReportData(
      std::in_place_index_t<static_cast<size_t>(Tag::kEventLevelData)>,
      WebUIReportEventLevelDataPtr value);
  WebUIReportData(
      std::in_place_index_t<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
      WebUIReportAggregatableAttributionDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  NetworkStatus {
 public:
  using DataView = NetworkStatusDataView;
  using Data_ = internal::NetworkStatus_Data;
  using Tag = Data_::NetworkStatus_Tag;

  template <typename... Args>
  static NetworkStatusPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |http_response_code|.
  static NetworkStatusPtr NewHttpResponseCode(
      int32_t value);
  // Construct an instance holding |network_error|.
  static NetworkStatusPtr NewNetworkError(
      const std::string& value);

  template <typename U>
  static NetworkStatusPtr From(const U& u) {
    return mojo::TypeConverter<NetworkStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkStatus>::Convert(*this);
  }
  ~NetworkStatus();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  NetworkStatus(const NetworkStatus& other) = delete;
  NetworkStatus& operator=(const NetworkStatus& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NetworkStatusPtr>
  NetworkStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkStatus>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkStatus>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_http_response_code() const { return tag_ == Tag::kHttpResponseCode; }
  int32_t get_http_response_code() const {
    CHECK(tag_ == Tag::kHttpResponseCode);
    return data_.http_response_code;
  }
  void set_http_response_code(int32_t http_response_code);

  bool is_network_error() const { return tag_ == Tag::kNetworkError; }
  const std::string& get_network_error() const {
    CHECK(tag_ == Tag::kNetworkError);
    return data_.network_error;
  }
  std::string& get_network_error() {
    CHECK(tag_ == Tag::kNetworkError);
    return data_.network_error;
  }
  void set_network_error(const std::string& network_error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkStatus::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHttpResponseCode)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNetworkError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t http_response_code;
    std::string network_error;
  };

  NetworkStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kHttpResponseCode)>,
      int32_t value);
  NetworkStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kNetworkError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ReportStatus {
 public:
  using DataView = ReportStatusDataView;
  using Data_ = internal::ReportStatus_Data;
  using Tag = Data_::ReportStatus_Tag;

  template <typename... Args>
  static ReportStatusPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |pending|.
  static ReportStatusPtr NewPending(
      EmptyPtr value);
  // Construct an instance holding |replaced_by_higher_priority_report|.
  static ReportStatusPtr NewReplacedByHigherPriorityReport(
      const std::string& value);
  // Construct an instance holding |prohibited_by_browser_policy|.
  static ReportStatusPtr NewProhibitedByBrowserPolicy(
      EmptyPtr value);
  // Construct an instance holding |expired|.
  static ReportStatusPtr NewExpired(
      EmptyPtr value);
  // Construct an instance holding |network_status|.
  static ReportStatusPtr NewNetworkStatus(
      NetworkStatusPtr value);
  // Construct an instance holding |failed_to_assemble|.
  static ReportStatusPtr NewFailedToAssemble(
      EmptyPtr value);

  template <typename U>
  static ReportStatusPtr From(const U& u) {
    return mojo::TypeConverter<ReportStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReportStatus>::Convert(*this);
  }
  ~ReportStatus();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ReportStatus(const ReportStatus& other) = delete;
  ReportStatus& operator=(const ReportStatus& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ReportStatusPtr>
  ReportStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ReportStatus>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ReportStatus>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_pending() const { return tag_ == Tag::kPending; }
  const EmptyPtr& get_pending() const {
    CHECK(tag_ == Tag::kPending);
    return data_.pending;
  }
  EmptyPtr& get_pending() {
    CHECK(tag_ == Tag::kPending);
    return data_.pending;
  }
  void set_pending(EmptyPtr pending);

  bool is_replaced_by_higher_priority_report() const { return tag_ == Tag::kReplacedByHigherPriorityReport; }
  const std::string& get_replaced_by_higher_priority_report() const {
    CHECK(tag_ == Tag::kReplacedByHigherPriorityReport);
    return data_.replaced_by_higher_priority_report;
  }
  std::string& get_replaced_by_higher_priority_report() {
    CHECK(tag_ == Tag::kReplacedByHigherPriorityReport);
    return data_.replaced_by_higher_priority_report;
  }
  void set_replaced_by_higher_priority_report(const std::string& replaced_by_higher_priority_report);

  bool is_prohibited_by_browser_policy() const { return tag_ == Tag::kProhibitedByBrowserPolicy; }
  const EmptyPtr& get_prohibited_by_browser_policy() const {
    CHECK(tag_ == Tag::kProhibitedByBrowserPolicy);
    return data_.prohibited_by_browser_policy;
  }
  EmptyPtr& get_prohibited_by_browser_policy() {
    CHECK(tag_ == Tag::kProhibitedByBrowserPolicy);
    return data_.prohibited_by_browser_policy;
  }
  void set_prohibited_by_browser_policy(EmptyPtr prohibited_by_browser_policy);

  bool is_expired() const { return tag_ == Tag::kExpired; }
  const EmptyPtr& get_expired() const {
    CHECK(tag_ == Tag::kExpired);
    return data_.expired;
  }
  EmptyPtr& get_expired() {
    CHECK(tag_ == Tag::kExpired);
    return data_.expired;
  }
  void set_expired(EmptyPtr expired);

  bool is_network_status() const { return tag_ == Tag::kNetworkStatus; }
  const NetworkStatusPtr& get_network_status() const {
    CHECK(tag_ == Tag::kNetworkStatus);
    return data_.network_status;
  }
  NetworkStatusPtr& get_network_status() {
    CHECK(tag_ == Tag::kNetworkStatus);
    return data_.network_status;
  }
  void set_network_status(NetworkStatusPtr network_status);

  bool is_failed_to_assemble() const { return tag_ == Tag::kFailedToAssemble; }
  const EmptyPtr& get_failed_to_assemble() const {
    CHECK(tag_ == Tag::kFailedToAssemble);
    return data_.failed_to_assemble;
  }
  EmptyPtr& get_failed_to_assemble() {
    CHECK(tag_ == Tag::kFailedToAssemble);
    return data_.failed_to_assemble;
  }
  void set_failed_to_assemble(EmptyPtr failed_to_assemble);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReportStatus::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ReportStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPending)>,
        EmptyPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
        EmptyPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kExpired)>,
        EmptyPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
        NetworkStatusPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailedToAssemble)>,
        EmptyPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    EmptyPtr pending;
    std::string replaced_by_higher_priority_report;
    EmptyPtr prohibited_by_browser_policy;
    EmptyPtr expired;
    NetworkStatusPtr network_status;
    EmptyPtr failed_to_assemble;
  };

  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kPending)>,
      EmptyPtr value);
  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
      const std::string& value);
  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
      EmptyPtr value);
  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kExpired)>,
      EmptyPtr value);
  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
      NetworkStatusPtr value);
  ReportStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailedToAssemble)>,
      EmptyPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SendAggregatableDebugReportResult {
 public:
  using DataView = SendAggregatableDebugReportResultDataView;
  using Data_ = internal::SendAggregatableDebugReportResult_Data;
  using Tag = Data_::SendAggregatableDebugReportResult_Tag;

  template <typename... Args>
  static SendAggregatableDebugReportResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |assembly_failed|.
  static SendAggregatableDebugReportResultPtr NewAssemblyFailed(
      EmptyPtr value);
  // Construct an instance holding |network_status|.
  static SendAggregatableDebugReportResultPtr NewNetworkStatus(
      NetworkStatusPtr value);

  template <typename U>
  static SendAggregatableDebugReportResultPtr From(const U& u) {
    return mojo::TypeConverter<SendAggregatableDebugReportResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SendAggregatableDebugReportResult>::Convert(*this);
  }
  ~SendAggregatableDebugReportResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SendAggregatableDebugReportResult(const SendAggregatableDebugReportResult& other) = delete;
  SendAggregatableDebugReportResult& operator=(const SendAggregatableDebugReportResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SendAggregatableDebugReportResultPtr>
  SendAggregatableDebugReportResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SendAggregatableDebugReportResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SendAggregatableDebugReportResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_assembly_failed() const { return tag_ == Tag::kAssemblyFailed; }
  const EmptyPtr& get_assembly_failed() const {
    CHECK(tag_ == Tag::kAssemblyFailed);
    return data_.assembly_failed;
  }
  EmptyPtr& get_assembly_failed() {
    CHECK(tag_ == Tag::kAssemblyFailed);
    return data_.assembly_failed;
  }
  void set_assembly_failed(EmptyPtr assembly_failed);

  bool is_network_status() const { return tag_ == Tag::kNetworkStatus; }
  const NetworkStatusPtr& get_network_status() const {
    CHECK(tag_ == Tag::kNetworkStatus);
    return data_.network_status;
  }
  NetworkStatusPtr& get_network_status() {
    CHECK(tag_ == Tag::kNetworkStatus);
    return data_.network_status;
  }
  void set_network_status(NetworkStatusPtr network_status);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SendAggregatableDebugReportResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SendAggregatableDebugReportResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAssemblyFailed)>,
        EmptyPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
        NetworkStatusPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    EmptyPtr assembly_failed;
    NetworkStatusPtr network_status;
  };

  SendAggregatableDebugReportResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kAssemblyFailed)>,
      EmptyPtr value);
  SendAggregatableDebugReportResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
      NetworkStatusPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};








class  WebUIReportAggregatableAttributionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIReportAggregatableAttributionData, T>::value>;
  using DataView = WebUIReportAggregatableAttributionDataDataView;
  using Data_ = internal::WebUIReportAggregatableAttributionData_Data;

  template <typename... Args>
  static WebUIReportAggregatableAttributionDataPtr New(Args&&... args) {
    return WebUIReportAggregatableAttributionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIReportAggregatableAttributionDataPtr From(const U& u) {
    return mojo::TypeConverter<WebUIReportAggregatableAttributionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIReportAggregatableAttributionData>::Convert(*this);
  }


  WebUIReportAggregatableAttributionData();

  WebUIReportAggregatableAttributionData(
      std::vector<AggregatableHistogramContributionPtr> contributions,
      const std::string& aggregation_coordinator,
      bool is_null_report);

WebUIReportAggregatableAttributionData(const WebUIReportAggregatableAttributionData&) = delete;
WebUIReportAggregatableAttributionData& operator=(const WebUIReportAggregatableAttributionData&) = delete;

  ~WebUIReportAggregatableAttributionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIReportAggregatableAttributionDataPtr>
  WebUIReportAggregatableAttributionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReportAggregatableAttributionData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReportAggregatableAttributionData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIReportAggregatableAttributionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIReportAggregatableAttributionData_UnserializedMessageContext<
            UserType, WebUIReportAggregatableAttributionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIReportAggregatableAttributionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIReportAggregatableAttributionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIReportAggregatableAttributionData_UnserializedMessageContext<
            UserType, WebUIReportAggregatableAttributionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIReportAggregatableAttributionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<AggregatableHistogramContributionPtr> contributions;
  
  std::string aggregation_coordinator;
  
  bool is_null_report;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  WebUIReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIReport, T>::value>;
  using DataView = WebUIReportDataView;
  using Data_ = internal::WebUIReport_Data;

  template <typename... Args>
  static WebUIReportPtr New(Args&&... args) {
    return WebUIReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIReportPtr From(const U& u) {
    return mojo::TypeConverter<WebUIReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIReport>::Convert(*this);
  }


  WebUIReport();

  WebUIReport(
      ::content::AttributionReport::Id id,
      const ::GURL& report_url,
      double trigger_time,
      double report_time,
      const std::string& report_body,
      ReportStatusPtr status,
      WebUIReportDataPtr data);

WebUIReport(const WebUIReport&) = delete;
WebUIReport& operator=(const WebUIReport&) = delete;

  ~WebUIReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIReportPtr>
  WebUIReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIReport_UnserializedMessageContext<
            UserType, WebUIReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIReport_UnserializedMessageContext<
            UserType, WebUIReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::content::AttributionReport::Id id;
  
  ::GURL report_url;
  
  double trigger_time;
  
  double report_time;
  
  std::string report_body;
  
  ReportStatusPtr status;
  
  WebUIReportDataPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIDebugReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIDebugReport, T>::value>;
  using DataView = WebUIDebugReportDataView;
  using Data_ = internal::WebUIDebugReport_Data;

  template <typename... Args>
  static WebUIDebugReportPtr New(Args&&... args) {
    return WebUIDebugReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIDebugReportPtr From(const U& u) {
    return mojo::TypeConverter<WebUIDebugReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIDebugReport>::Convert(*this);
  }


  WebUIDebugReport();

  WebUIDebugReport(
      const ::GURL& url,
      double time,
      const std::string& body,
      NetworkStatusPtr status);

WebUIDebugReport(const WebUIDebugReport&) = delete;
WebUIDebugReport& operator=(const WebUIDebugReport&) = delete;

  ~WebUIDebugReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIDebugReportPtr>
  WebUIDebugReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIDebugReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIDebugReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIDebugReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIDebugReport_UnserializedMessageContext<
            UserType, WebUIDebugReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIDebugReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIDebugReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIDebugReport_UnserializedMessageContext<
            UserType, WebUIDebugReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIDebugReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  double time;
  
  std::string body;
  
  NetworkStatusPtr status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIDebugReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIAggregatableDebugReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIAggregatableDebugReport, T>::value>;
  using DataView = WebUIAggregatableDebugReportDataView;
  using Data_ = internal::WebUIAggregatableDebugReport_Data;

  template <typename... Args>
  static WebUIAggregatableDebugReportPtr New(Args&&... args) {
    return WebUIAggregatableDebugReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIAggregatableDebugReportPtr From(const U& u) {
    return mojo::TypeConverter<WebUIAggregatableDebugReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIAggregatableDebugReport>::Convert(*this);
  }


  WebUIAggregatableDebugReport();

  WebUIAggregatableDebugReport(
      const ::GURL& url,
      double time,
      const std::string& body,
      ::attribution_reporting::mojom::ProcessAggregatableDebugReportResult process_result,
      SendAggregatableDebugReportResultPtr send_result);

WebUIAggregatableDebugReport(const WebUIAggregatableDebugReport&) = delete;
WebUIAggregatableDebugReport& operator=(const WebUIAggregatableDebugReport&) = delete;

  ~WebUIAggregatableDebugReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIAggregatableDebugReportPtr>
  WebUIAggregatableDebugReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIAggregatableDebugReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIAggregatableDebugReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIAggregatableDebugReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIAggregatableDebugReport_UnserializedMessageContext<
            UserType, WebUIAggregatableDebugReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIAggregatableDebugReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIAggregatableDebugReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIAggregatableDebugReport_UnserializedMessageContext<
            UserType, WebUIAggregatableDebugReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIAggregatableDebugReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  double time;
  
  std::string body;
  
  ::attribution_reporting::mojom::ProcessAggregatableDebugReportResult process_result;
  
  SendAggregatableDebugReportResultPtr send_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUISource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUISource, T>::value>;
  using DataView = WebUISourceDataView;
  using Data_ = internal::WebUISource_Data;
  using Attributability = WebUISource_Attributability;

  template <typename... Args>
  static WebUISourcePtr New(Args&&... args) {
    return WebUISourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUISourcePtr From(const U& u) {
    return mojo::TypeConverter<WebUISourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUISource>::Convert(*this);
  }


  WebUISource();

  WebUISource(
      int64_t id,
      uint64_t source_event_id,
      const ::url::Origin& source_origin,
      const ::attribution_reporting::DestinationSet& destinations,
      const ::url::Origin& reporting_origin,
      double source_time,
      double expiry_time,
      const ::attribution_reporting::EventReportWindows& event_report_windows,
      std::vector<uint32_t> trigger_data,
      int32_t max_event_level_reports,
      double aggregatable_report_window_time,
      ::attribution_reporting::mojom::SourceType source_type,
      int64_t priority,
      std::optional<uint64_t> debug_key,
      std::vector<uint64_t> dedup_keys,
      const ::attribution_reporting::FilterData& filter_data,
      const base::flat_map<std::string, std::string>& aggregation_keys,
      int32_t remaining_aggregatable_attribution_budget,
      std::vector<uint64_t> aggregatable_dedup_keys,
      ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching,
      double event_level_epsilon,
      bool cookie_based_debug_allowed,
      int32_t remaining_aggregatable_debug_budget,
      const std::string& aggregatable_debug_key_piece,
      const std::string& attribution_scopes_data_json,
      const std::string& aggregatable_named_budgets,
      WebUISource::Attributability attributability);


  ~WebUISource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUISourcePtr>
  WebUISourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUISource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUISource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUISource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUISource_UnserializedMessageContext<
            UserType, WebUISource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUISource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUISource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUISource_UnserializedMessageContext<
            UserType, WebUISource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUISource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  uint64_t source_event_id;
  
  ::url::Origin source_origin;
  
  ::attribution_reporting::DestinationSet destinations;
  
  ::url::Origin reporting_origin;
  
  double source_time;
  
  double expiry_time;
  
  ::attribution_reporting::EventReportWindows event_report_windows;
  
  std::vector<uint32_t> trigger_data;
  
  int32_t max_event_level_reports;
  
  double aggregatable_report_window_time;
  
  ::attribution_reporting::mojom::SourceType source_type;
  
  int64_t priority;
  
  std::optional<uint64_t> debug_key;
  
  std::vector<uint64_t> dedup_keys;
  
  ::attribution_reporting::FilterData filter_data;
  
  base::flat_map<std::string, std::string> aggregation_keys;
  
  int32_t remaining_aggregatable_attribution_budget;
  
  std::vector<uint64_t> aggregatable_dedup_keys;
  
  ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching;
  
  double event_level_epsilon;
  
  bool cookie_based_debug_allowed;
  
  int32_t remaining_aggregatable_debug_budget;
  
  std::string aggregatable_debug_key_piece;
  
  std::string attribution_scopes_data_json;
  
  std::string aggregatable_named_budgets;
  
  WebUISource::Attributability attributability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUISource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIRegistration, T>::value>;
  using DataView = WebUIRegistrationDataView;
  using Data_ = internal::WebUIRegistration_Data;

  template <typename... Args>
  static WebUIRegistrationPtr New(Args&&... args) {
    return WebUIRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<WebUIRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIRegistration>::Convert(*this);
  }


  WebUIRegistration();

  WebUIRegistration(
      double time,
      const ::url::Origin& context_origin,
      const ::url::Origin& reporting_origin,
      const std::string& registration_json,
      std::optional<uint64_t> cleared_debug_key);


  ~WebUIRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIRegistrationPtr>
  WebUIRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIRegistration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIRegistration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIRegistration_UnserializedMessageContext<
            UserType, WebUIRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIRegistration_UnserializedMessageContext<
            UserType, WebUIRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double time;
  
  ::url::Origin context_origin;
  
  ::url::Origin reporting_origin;
  
  std::string registration_json;
  
  std::optional<uint64_t> cleared_debug_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUITrigger {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUITrigger, T>::value>;
  using DataView = WebUITriggerDataView;
  using Data_ = internal::WebUITrigger_Data;

  template <typename... Args>
  static WebUITriggerPtr New(Args&&... args) {
    return WebUITriggerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUITriggerPtr From(const U& u) {
    return mojo::TypeConverter<WebUITriggerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUITrigger>::Convert(*this);
  }


  WebUITrigger();

  WebUITrigger(
      WebUIRegistrationPtr registration,
      ::attribution_reporting::mojom::EventLevelResult event_level_result,
      ::attribution_reporting::mojom::AggregatableResult aggregatable_result);

WebUITrigger(const WebUITrigger&) = delete;
WebUITrigger& operator=(const WebUITrigger&) = delete;

  ~WebUITrigger();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUITriggerPtr>
  WebUITriggerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUITrigger::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUITrigger::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUITrigger::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUITrigger_UnserializedMessageContext<
            UserType, WebUITrigger::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUITrigger::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUITrigger::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUITrigger_UnserializedMessageContext<
            UserType, WebUITrigger::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUITrigger::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebUIRegistrationPtr registration;
  
  ::attribution_reporting::mojom::EventLevelResult event_level_result;
  
  ::attribution_reporting::mojom::AggregatableResult aggregatable_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUITrigger::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUISourceRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUISourceRegistration, T>::value>;
  using DataView = WebUISourceRegistrationDataView;
  using Data_ = internal::WebUISourceRegistration_Data;

  template <typename... Args>
  static WebUISourceRegistrationPtr New(Args&&... args) {
    return WebUISourceRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUISourceRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<WebUISourceRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUISourceRegistration>::Convert(*this);
  }


  WebUISourceRegistration();

  WebUISourceRegistration(
      WebUIRegistrationPtr registration,
      ::attribution_reporting::mojom::SourceType type,
      ::attribution_reporting::mojom::StoreSourceResult status);

WebUISourceRegistration(const WebUISourceRegistration&) = delete;
WebUISourceRegistration& operator=(const WebUISourceRegistration&) = delete;

  ~WebUISourceRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUISourceRegistrationPtr>
  WebUISourceRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUISourceRegistration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUISourceRegistration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUISourceRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUISourceRegistration_UnserializedMessageContext<
            UserType, WebUISourceRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUISourceRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUISourceRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUISourceRegistration_UnserializedMessageContext<
            UserType, WebUISourceRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUISourceRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebUIRegistrationPtr registration;
  
  ::attribution_reporting::mojom::SourceType type;
  
  ::attribution_reporting::mojom::StoreSourceResult status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUISourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIOsRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIOsRegistration, T>::value>;
  using DataView = WebUIOsRegistrationDataView;
  using Data_ = internal::WebUIOsRegistration_Data;

  template <typename... Args>
  static WebUIOsRegistrationPtr New(Args&&... args) {
    return WebUIOsRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIOsRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<WebUIOsRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIOsRegistration>::Convert(*this);
  }


  WebUIOsRegistration();

  WebUIOsRegistration(
      double time,
      const ::GURL& registration_url,
      const ::url::Origin& top_level_origin,
      bool is_debug_key_allowed,
      bool debug_reporting,
      ::attribution_reporting::mojom::RegistrationType type,
      ::attribution_reporting::mojom::OsRegistrationResult result);


  ~WebUIOsRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIOsRegistrationPtr>
  WebUIOsRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIOsRegistration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIOsRegistration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIOsRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIOsRegistration_UnserializedMessageContext<
            UserType, WebUIOsRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIOsRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIOsRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIOsRegistration_UnserializedMessageContext<
            UserType, WebUIOsRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIOsRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double time;
  
  ::GURL registration_url;
  
  ::url::Origin top_level_origin;
  
  bool is_debug_key_allowed;
  
  bool debug_reporting;
  
  ::attribution_reporting::mojom::RegistrationType type;
  
  ::attribution_reporting::mojom::OsRegistrationResult result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIOsRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
WebUIReportDataPtr WebUIReportData::Clone() const {
  switch (tag_) {
    case Tag::kEventLevelData:
      return NewEventLevelData(
          mojo::Clone(data_.event_level_data));
    case Tag::kAggregatableAttributionData:
      return NewAggregatableAttributionData(
          mojo::Clone(data_.aggregatable_attribution_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebUIReportData>::value>::type*>
bool WebUIReportData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEventLevelData:
      return mojo::Equals(data_.event_level_data, other.data_.event_level_data);
    case Tag::kAggregatableAttributionData:
      return mojo::Equals(data_.aggregatable_attribution_data, other.data_.aggregatable_attribution_data);
  }

  return false;
}
template <typename UnionPtrType>
NetworkStatusPtr NetworkStatus::Clone() const {
  switch (tag_) {
    case Tag::kHttpResponseCode:
      return NewHttpResponseCode(
          mojo::Clone(data_.http_response_code));
    case Tag::kNetworkError:
      return NewNetworkError(
          mojo::Clone(data_.network_error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, NetworkStatus>::value>::type*>
bool NetworkStatus::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kHttpResponseCode:
      return mojo::Equals(data_.http_response_code, other.data_.http_response_code);
    case Tag::kNetworkError:
      return mojo::Equals(data_.network_error, other.data_.network_error);
  }

  return false;
}
template <typename UnionPtrType>
ReportStatusPtr ReportStatus::Clone() const {
  switch (tag_) {
    case Tag::kPending:
      return NewPending(
          mojo::Clone(data_.pending));
    case Tag::kReplacedByHigherPriorityReport:
      return NewReplacedByHigherPriorityReport(
          mojo::Clone(data_.replaced_by_higher_priority_report));
    case Tag::kProhibitedByBrowserPolicy:
      return NewProhibitedByBrowserPolicy(
          mojo::Clone(data_.prohibited_by_browser_policy));
    case Tag::kExpired:
      return NewExpired(
          mojo::Clone(data_.expired));
    case Tag::kNetworkStatus:
      return NewNetworkStatus(
          mojo::Clone(data_.network_status));
    case Tag::kFailedToAssemble:
      return NewFailedToAssemble(
          mojo::Clone(data_.failed_to_assemble));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ReportStatus>::value>::type*>
bool ReportStatus::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPending:
      return mojo::Equals(data_.pending, other.data_.pending);
    case Tag::kReplacedByHigherPriorityReport:
      return mojo::Equals(data_.replaced_by_higher_priority_report, other.data_.replaced_by_higher_priority_report);
    case Tag::kProhibitedByBrowserPolicy:
      return mojo::Equals(data_.prohibited_by_browser_policy, other.data_.prohibited_by_browser_policy);
    case Tag::kExpired:
      return mojo::Equals(data_.expired, other.data_.expired);
    case Tag::kNetworkStatus:
      return mojo::Equals(data_.network_status, other.data_.network_status);
    case Tag::kFailedToAssemble:
      return mojo::Equals(data_.failed_to_assemble, other.data_.failed_to_assemble);
  }

  return false;
}
template <typename UnionPtrType>
SendAggregatableDebugReportResultPtr SendAggregatableDebugReportResult::Clone() const {
  switch (tag_) {
    case Tag::kAssemblyFailed:
      return NewAssemblyFailed(
          mojo::Clone(data_.assembly_failed));
    case Tag::kNetworkStatus:
      return NewNetworkStatus(
          mojo::Clone(data_.network_status));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SendAggregatableDebugReportResult>::value>::type*>
bool SendAggregatableDebugReportResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAssemblyFailed:
      return mojo::Equals(data_.assembly_failed, other.data_.assembly_failed);
    case Tag::kNetworkStatus:
      return mojo::Equals(data_.network_status, other.data_.network_status);
  }

  return false;
}
template <typename StructPtrType>
ReportIDPtr ReportID::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ReportID::EnableIfSame<T>*>
bool ReportID::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ReportID::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIReportEventLevelDataPtr WebUIReportEventLevelData::Clone() const {
  return New(
      mojo::Clone(priority),
      mojo::Clone(attributed_truthfully)
  );
}

template <typename T, WebUIReportEventLevelData::EnableIfSame<T>*>
bool WebUIReportEventLevelData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->attributed_truthfully, other_struct.attributed_truthfully))
    return false;
  return true;
}

template <typename T, WebUIReportEventLevelData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.attributed_truthfully < rhs.attributed_truthfully)
    return true;
  if (rhs.attributed_truthfully < lhs.attributed_truthfully)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableHistogramContributionPtr AggregatableHistogramContribution::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value),
      mojo::Clone(filtering_id)
  );
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>*>
bool AggregatableHistogramContribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->filtering_id, other_struct.filtering_id))
    return false;
  return true;
}

template <typename T, AggregatableHistogramContribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.filtering_id < rhs.filtering_id)
    return true;
  if (rhs.filtering_id < lhs.filtering_id)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIReportAggregatableAttributionDataPtr WebUIReportAggregatableAttributionData::Clone() const {
  return New(
      mojo::Clone(contributions),
      mojo::Clone(aggregation_coordinator),
      mojo::Clone(is_null_report)
  );
}

template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>*>
bool WebUIReportAggregatableAttributionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contributions, other_struct.contributions))
    return false;
  if (!mojo::Equals(this->aggregation_coordinator, other_struct.aggregation_coordinator))
    return false;
  if (!mojo::Equals(this->is_null_report, other_struct.is_null_report))
    return false;
  return true;
}

template <typename T, WebUIReportAggregatableAttributionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contributions < rhs.contributions)
    return true;
  if (rhs.contributions < lhs.contributions)
    return false;
  if (lhs.aggregation_coordinator < rhs.aggregation_coordinator)
    return true;
  if (rhs.aggregation_coordinator < lhs.aggregation_coordinator)
    return false;
  if (lhs.is_null_report < rhs.is_null_report)
    return true;
  if (rhs.is_null_report < lhs.is_null_report)
    return false;
  return false;
}
template <typename StructPtrType>
EmptyPtr Empty::Clone() const {
  return New(
  );
}

template <typename T, Empty::EnableIfSame<T>*>
bool Empty::Equals(const T& other_struct) const {
  return true;
}

template <typename T, Empty::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
WebUIReportPtr WebUIReport::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(report_url),
      mojo::Clone(trigger_time),
      mojo::Clone(report_time),
      mojo::Clone(report_body),
      mojo::Clone(status),
      mojo::Clone(data)
  );
}

template <typename T, WebUIReport::EnableIfSame<T>*>
bool WebUIReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->report_url, other_struct.report_url))
    return false;
  if (!mojo::Equals(this->trigger_time, other_struct.trigger_time))
    return false;
  if (!mojo::Equals(this->report_time, other_struct.report_time))
    return false;
  if (!mojo::Equals(this->report_body, other_struct.report_body))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, WebUIReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.report_url < rhs.report_url)
    return true;
  if (rhs.report_url < lhs.report_url)
    return false;
  if (lhs.trigger_time < rhs.trigger_time)
    return true;
  if (rhs.trigger_time < lhs.trigger_time)
    return false;
  if (lhs.report_time < rhs.report_time)
    return true;
  if (rhs.report_time < lhs.report_time)
    return false;
  if (lhs.report_body < rhs.report_body)
    return true;
  if (rhs.report_body < lhs.report_body)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIDebugReportPtr WebUIDebugReport::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(time),
      mojo::Clone(body),
      mojo::Clone(status)
  );
}

template <typename T, WebUIDebugReport::EnableIfSame<T>*>
bool WebUIDebugReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, WebUIDebugReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIAggregatableDebugReportPtr WebUIAggregatableDebugReport::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(time),
      mojo::Clone(body),
      mojo::Clone(process_result),
      mojo::Clone(send_result)
  );
}

template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>*>
bool WebUIAggregatableDebugReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->process_result, other_struct.process_result))
    return false;
  if (!mojo::Equals(this->send_result, other_struct.send_result))
    return false;
  return true;
}

template <typename T, WebUIAggregatableDebugReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.process_result < rhs.process_result)
    return true;
  if (rhs.process_result < lhs.process_result)
    return false;
  if (lhs.send_result < rhs.send_result)
    return true;
  if (rhs.send_result < lhs.send_result)
    return false;
  return false;
}
template <typename StructPtrType>
WebUISourcePtr WebUISource::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(source_event_id),
      mojo::Clone(source_origin),
      mojo::Clone(destinations),
      mojo::Clone(reporting_origin),
      mojo::Clone(source_time),
      mojo::Clone(expiry_time),
      mojo::Clone(event_report_windows),
      mojo::Clone(trigger_data),
      mojo::Clone(max_event_level_reports),
      mojo::Clone(aggregatable_report_window_time),
      mojo::Clone(source_type),
      mojo::Clone(priority),
      mojo::Clone(debug_key),
      mojo::Clone(dedup_keys),
      mojo::Clone(filter_data),
      mojo::Clone(aggregation_keys),
      mojo::Clone(remaining_aggregatable_attribution_budget),
      mojo::Clone(aggregatable_dedup_keys),
      mojo::Clone(trigger_data_matching),
      mojo::Clone(event_level_epsilon),
      mojo::Clone(cookie_based_debug_allowed),
      mojo::Clone(remaining_aggregatable_debug_budget),
      mojo::Clone(aggregatable_debug_key_piece),
      mojo::Clone(attribution_scopes_data_json),
      mojo::Clone(aggregatable_named_budgets),
      mojo::Clone(attributability)
  );
}

template <typename T, WebUISource::EnableIfSame<T>*>
bool WebUISource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->source_event_id, other_struct.source_event_id))
    return false;
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  if (!mojo::Equals(this->destinations, other_struct.destinations))
    return false;
  if (!mojo::Equals(this->reporting_origin, other_struct.reporting_origin))
    return false;
  if (!mojo::Equals(this->source_time, other_struct.source_time))
    return false;
  if (!mojo::Equals(this->expiry_time, other_struct.expiry_time))
    return false;
  if (!mojo::Equals(this->event_report_windows, other_struct.event_report_windows))
    return false;
  if (!mojo::Equals(this->trigger_data, other_struct.trigger_data))
    return false;
  if (!mojo::Equals(this->max_event_level_reports, other_struct.max_event_level_reports))
    return false;
  if (!mojo::Equals(this->aggregatable_report_window_time, other_struct.aggregatable_report_window_time))
    return false;
  if (!mojo::Equals(this->source_type, other_struct.source_type))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->debug_key, other_struct.debug_key))
    return false;
  if (!mojo::Equals(this->dedup_keys, other_struct.dedup_keys))
    return false;
  if (!mojo::Equals(this->filter_data, other_struct.filter_data))
    return false;
  if (!mojo::Equals(this->aggregation_keys, other_struct.aggregation_keys))
    return false;
  if (!mojo::Equals(this->remaining_aggregatable_attribution_budget, other_struct.remaining_aggregatable_attribution_budget))
    return false;
  if (!mojo::Equals(this->aggregatable_dedup_keys, other_struct.aggregatable_dedup_keys))
    return false;
  if (!mojo::Equals(this->trigger_data_matching, other_struct.trigger_data_matching))
    return false;
  if (!mojo::Equals(this->event_level_epsilon, other_struct.event_level_epsilon))
    return false;
  if (!mojo::Equals(this->cookie_based_debug_allowed, other_struct.cookie_based_debug_allowed))
    return false;
  if (!mojo::Equals(this->remaining_aggregatable_debug_budget, other_struct.remaining_aggregatable_debug_budget))
    return false;
  if (!mojo::Equals(this->aggregatable_debug_key_piece, other_struct.aggregatable_debug_key_piece))
    return false;
  if (!mojo::Equals(this->attribution_scopes_data_json, other_struct.attribution_scopes_data_json))
    return false;
  if (!mojo::Equals(this->aggregatable_named_budgets, other_struct.aggregatable_named_budgets))
    return false;
  if (!mojo::Equals(this->attributability, other_struct.attributability))
    return false;
  return true;
}

template <typename T, WebUISource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.source_event_id < rhs.source_event_id)
    return true;
  if (rhs.source_event_id < lhs.source_event_id)
    return false;
  if (lhs.source_origin < rhs.source_origin)
    return true;
  if (rhs.source_origin < lhs.source_origin)
    return false;
  if (lhs.destinations < rhs.destinations)
    return true;
  if (rhs.destinations < lhs.destinations)
    return false;
  if (lhs.reporting_origin < rhs.reporting_origin)
    return true;
  if (rhs.reporting_origin < lhs.reporting_origin)
    return false;
  if (lhs.source_time < rhs.source_time)
    return true;
  if (rhs.source_time < lhs.source_time)
    return false;
  if (lhs.expiry_time < rhs.expiry_time)
    return true;
  if (rhs.expiry_time < lhs.expiry_time)
    return false;
  if (lhs.event_report_windows < rhs.event_report_windows)
    return true;
  if (rhs.event_report_windows < lhs.event_report_windows)
    return false;
  if (lhs.trigger_data < rhs.trigger_data)
    return true;
  if (rhs.trigger_data < lhs.trigger_data)
    return false;
  if (lhs.max_event_level_reports < rhs.max_event_level_reports)
    return true;
  if (rhs.max_event_level_reports < lhs.max_event_level_reports)
    return false;
  if (lhs.aggregatable_report_window_time < rhs.aggregatable_report_window_time)
    return true;
  if (rhs.aggregatable_report_window_time < lhs.aggregatable_report_window_time)
    return false;
  if (lhs.source_type < rhs.source_type)
    return true;
  if (rhs.source_type < lhs.source_type)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.debug_key < rhs.debug_key)
    return true;
  if (rhs.debug_key < lhs.debug_key)
    return false;
  if (lhs.dedup_keys < rhs.dedup_keys)
    return true;
  if (rhs.dedup_keys < lhs.dedup_keys)
    return false;
  if (lhs.filter_data < rhs.filter_data)
    return true;
  if (rhs.filter_data < lhs.filter_data)
    return false;
  if (lhs.aggregation_keys < rhs.aggregation_keys)
    return true;
  if (rhs.aggregation_keys < lhs.aggregation_keys)
    return false;
  if (lhs.remaining_aggregatable_attribution_budget < rhs.remaining_aggregatable_attribution_budget)
    return true;
  if (rhs.remaining_aggregatable_attribution_budget < lhs.remaining_aggregatable_attribution_budget)
    return false;
  if (lhs.aggregatable_dedup_keys < rhs.aggregatable_dedup_keys)
    return true;
  if (rhs.aggregatable_dedup_keys < lhs.aggregatable_dedup_keys)
    return false;
  if (lhs.trigger_data_matching < rhs.trigger_data_matching)
    return true;
  if (rhs.trigger_data_matching < lhs.trigger_data_matching)
    return false;
  if (lhs.event_level_epsilon < rhs.event_level_epsilon)
    return true;
  if (rhs.event_level_epsilon < lhs.event_level_epsilon)
    return false;
  if (lhs.cookie_based_debug_allowed < rhs.cookie_based_debug_allowed)
    return true;
  if (rhs.cookie_based_debug_allowed < lhs.cookie_based_debug_allowed)
    return false;
  if (lhs.remaining_aggregatable_debug_budget < rhs.remaining_aggregatable_debug_budget)
    return true;
  if (rhs.remaining_aggregatable_debug_budget < lhs.remaining_aggregatable_debug_budget)
    return false;
  if (lhs.aggregatable_debug_key_piece < rhs.aggregatable_debug_key_piece)
    return true;
  if (rhs.aggregatable_debug_key_piece < lhs.aggregatable_debug_key_piece)
    return false;
  if (lhs.attribution_scopes_data_json < rhs.attribution_scopes_data_json)
    return true;
  if (rhs.attribution_scopes_data_json < lhs.attribution_scopes_data_json)
    return false;
  if (lhs.aggregatable_named_budgets < rhs.aggregatable_named_budgets)
    return true;
  if (rhs.aggregatable_named_budgets < lhs.aggregatable_named_budgets)
    return false;
  if (lhs.attributability < rhs.attributability)
    return true;
  if (rhs.attributability < lhs.attributability)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIRegistrationPtr WebUIRegistration::Clone() const {
  return New(
      mojo::Clone(time),
      mojo::Clone(context_origin),
      mojo::Clone(reporting_origin),
      mojo::Clone(registration_json),
      mojo::Clone(cleared_debug_key)
  );
}

template <typename T, WebUIRegistration::EnableIfSame<T>*>
bool WebUIRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->context_origin, other_struct.context_origin))
    return false;
  if (!mojo::Equals(this->reporting_origin, other_struct.reporting_origin))
    return false;
  if (!mojo::Equals(this->registration_json, other_struct.registration_json))
    return false;
  if (!mojo::Equals(this->cleared_debug_key, other_struct.cleared_debug_key))
    return false;
  return true;
}

template <typename T, WebUIRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.context_origin < rhs.context_origin)
    return true;
  if (rhs.context_origin < lhs.context_origin)
    return false;
  if (lhs.reporting_origin < rhs.reporting_origin)
    return true;
  if (rhs.reporting_origin < lhs.reporting_origin)
    return false;
  if (lhs.registration_json < rhs.registration_json)
    return true;
  if (rhs.registration_json < lhs.registration_json)
    return false;
  if (lhs.cleared_debug_key < rhs.cleared_debug_key)
    return true;
  if (rhs.cleared_debug_key < lhs.cleared_debug_key)
    return false;
  return false;
}
template <typename StructPtrType>
WebUITriggerPtr WebUITrigger::Clone() const {
  return New(
      mojo::Clone(registration),
      mojo::Clone(event_level_result),
      mojo::Clone(aggregatable_result)
  );
}

template <typename T, WebUITrigger::EnableIfSame<T>*>
bool WebUITrigger::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration, other_struct.registration))
    return false;
  if (!mojo::Equals(this->event_level_result, other_struct.event_level_result))
    return false;
  if (!mojo::Equals(this->aggregatable_result, other_struct.aggregatable_result))
    return false;
  return true;
}

template <typename T, WebUITrigger::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration < rhs.registration)
    return true;
  if (rhs.registration < lhs.registration)
    return false;
  if (lhs.event_level_result < rhs.event_level_result)
    return true;
  if (rhs.event_level_result < lhs.event_level_result)
    return false;
  if (lhs.aggregatable_result < rhs.aggregatable_result)
    return true;
  if (rhs.aggregatable_result < lhs.aggregatable_result)
    return false;
  return false;
}
template <typename StructPtrType>
WebUISourceRegistrationPtr WebUISourceRegistration::Clone() const {
  return New(
      mojo::Clone(registration),
      mojo::Clone(type),
      mojo::Clone(status)
  );
}

template <typename T, WebUISourceRegistration::EnableIfSame<T>*>
bool WebUISourceRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration, other_struct.registration))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, WebUISourceRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration < rhs.registration)
    return true;
  if (rhs.registration < lhs.registration)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIOsRegistrationPtr WebUIOsRegistration::Clone() const {
  return New(
      mojo::Clone(time),
      mojo::Clone(registration_url),
      mojo::Clone(top_level_origin),
      mojo::Clone(is_debug_key_allowed),
      mojo::Clone(debug_reporting),
      mojo::Clone(type),
      mojo::Clone(result)
  );
}

template <typename T, WebUIOsRegistration::EnableIfSame<T>*>
bool WebUIOsRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->registration_url, other_struct.registration_url))
    return false;
  if (!mojo::Equals(this->top_level_origin, other_struct.top_level_origin))
    return false;
  if (!mojo::Equals(this->is_debug_key_allowed, other_struct.is_debug_key_allowed))
    return false;
  if (!mojo::Equals(this->debug_reporting, other_struct.debug_reporting))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, WebUIOsRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.registration_url < rhs.registration_url)
    return true;
  if (rhs.registration_url < lhs.registration_url)
    return false;
  if (lhs.top_level_origin < rhs.top_level_origin)
    return true;
  if (rhs.top_level_origin < lhs.top_level_origin)
    return false;
  if (lhs.is_debug_key_allowed < rhs.is_debug_key_allowed)
    return true;
  if (rhs.is_debug_key_allowed < lhs.is_debug_key_allowed)
    return false;
  if (lhs.debug_reporting < rhs.debug_reporting)
    return true;
  if (rhs.debug_reporting < lhs.debug_reporting)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}


}  // attribution_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::attribution_internals::mojom::ReportID::DataView,
                                         ::attribution_internals::mojom::ReportIDPtr> {
  static bool IsNull(const ::attribution_internals::mojom::ReportIDPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::ReportIDPtr* output) { output->reset(); }

  static decltype(::attribution_internals::mojom::ReportID::value) value(
      const ::attribution_internals::mojom::ReportIDPtr& input) {
    return input->value;
  }

  static bool Read(::attribution_internals::mojom::ReportID::DataView input, ::attribution_internals::mojom::ReportIDPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIReportEventLevelData::DataView,
                                         ::attribution_internals::mojom::WebUIReportEventLevelDataPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIReportEventLevelDataPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIReportEventLevelDataPtr* output) { output->reset(); }

  static decltype(::attribution_internals::mojom::WebUIReportEventLevelData::priority) priority(
      const ::attribution_internals::mojom::WebUIReportEventLevelDataPtr& input) {
    return input->priority;
  }

  static decltype(::attribution_internals::mojom::WebUIReportEventLevelData::attributed_truthfully) attributed_truthfully(
      const ::attribution_internals::mojom::WebUIReportEventLevelDataPtr& input) {
    return input->attributed_truthfully;
  }

  static bool Read(::attribution_internals::mojom::WebUIReportEventLevelData::DataView input, ::attribution_internals::mojom::WebUIReportEventLevelDataPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::AggregatableHistogramContribution::DataView,
                                         ::attribution_internals::mojom::AggregatableHistogramContributionPtr> {
  static bool IsNull(const ::attribution_internals::mojom::AggregatableHistogramContributionPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::AggregatableHistogramContributionPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::AggregatableHistogramContribution::key)& key(
      const ::attribution_internals::mojom::AggregatableHistogramContributionPtr& input) {
    return input->key;
  }

  static decltype(::attribution_internals::mojom::AggregatableHistogramContribution::value) value(
      const ::attribution_internals::mojom::AggregatableHistogramContributionPtr& input) {
    return input->value;
  }

  static decltype(::attribution_internals::mojom::AggregatableHistogramContribution::filtering_id) filtering_id(
      const ::attribution_internals::mojom::AggregatableHistogramContributionPtr& input) {
    return input->filtering_id;
  }

  static bool Read(::attribution_internals::mojom::AggregatableHistogramContribution::DataView input, ::attribution_internals::mojom::AggregatableHistogramContributionPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIReportAggregatableAttributionData::DataView,
                                         ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUIReportAggregatableAttributionData::contributions)& contributions(
      const ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr& input) {
    return input->contributions;
  }

  static const decltype(::attribution_internals::mojom::WebUIReportAggregatableAttributionData::aggregation_coordinator)& aggregation_coordinator(
      const ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr& input) {
    return input->aggregation_coordinator;
  }

  static decltype(::attribution_internals::mojom::WebUIReportAggregatableAttributionData::is_null_report) is_null_report(
      const ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr& input) {
    return input->is_null_report;
  }

  static bool Read(::attribution_internals::mojom::WebUIReportAggregatableAttributionData::DataView input, ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::Empty::DataView,
                                         ::attribution_internals::mojom::EmptyPtr> {
  static bool IsNull(const ::attribution_internals::mojom::EmptyPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::EmptyPtr* output) { output->reset(); }

  static bool Read(::attribution_internals::mojom::Empty::DataView input, ::attribution_internals::mojom::EmptyPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIReport::DataView,
                                         ::attribution_internals::mojom::WebUIReportPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIReportPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIReportPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUIReport::id)& id(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->id;
  }

  static const decltype(::attribution_internals::mojom::WebUIReport::report_url)& report_url(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->report_url;
  }

  static decltype(::attribution_internals::mojom::WebUIReport::trigger_time) trigger_time(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->trigger_time;
  }

  static decltype(::attribution_internals::mojom::WebUIReport::report_time) report_time(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->report_time;
  }

  static const decltype(::attribution_internals::mojom::WebUIReport::report_body)& report_body(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->report_body;
  }

  static const decltype(::attribution_internals::mojom::WebUIReport::status)& status(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->status;
  }

  static const decltype(::attribution_internals::mojom::WebUIReport::data)& data(
      const ::attribution_internals::mojom::WebUIReportPtr& input) {
    return input->data;
  }

  static bool Read(::attribution_internals::mojom::WebUIReport::DataView input, ::attribution_internals::mojom::WebUIReportPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIDebugReport::DataView,
                                         ::attribution_internals::mojom::WebUIDebugReportPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIDebugReportPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIDebugReportPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUIDebugReport::url)& url(
      const ::attribution_internals::mojom::WebUIDebugReportPtr& input) {
    return input->url;
  }

  static decltype(::attribution_internals::mojom::WebUIDebugReport::time) time(
      const ::attribution_internals::mojom::WebUIDebugReportPtr& input) {
    return input->time;
  }

  static const decltype(::attribution_internals::mojom::WebUIDebugReport::body)& body(
      const ::attribution_internals::mojom::WebUIDebugReportPtr& input) {
    return input->body;
  }

  static const decltype(::attribution_internals::mojom::WebUIDebugReport::status)& status(
      const ::attribution_internals::mojom::WebUIDebugReportPtr& input) {
    return input->status;
  }

  static bool Read(::attribution_internals::mojom::WebUIDebugReport::DataView input, ::attribution_internals::mojom::WebUIDebugReportPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIAggregatableDebugReport::DataView,
                                         ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIAggregatableDebugReportPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUIAggregatableDebugReport::url)& url(
      const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) {
    return input->url;
  }

  static decltype(::attribution_internals::mojom::WebUIAggregatableDebugReport::time) time(
      const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) {
    return input->time;
  }

  static const decltype(::attribution_internals::mojom::WebUIAggregatableDebugReport::body)& body(
      const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) {
    return input->body;
  }

  static decltype(::attribution_internals::mojom::WebUIAggregatableDebugReport::process_result) process_result(
      const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) {
    return input->process_result;
  }

  static const decltype(::attribution_internals::mojom::WebUIAggregatableDebugReport::send_result)& send_result(
      const ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr& input) {
    return input->send_result;
  }

  static bool Read(::attribution_internals::mojom::WebUIAggregatableDebugReport::DataView input, ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUISource::DataView,
                                         ::attribution_internals::mojom::WebUISourcePtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUISourcePtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUISourcePtr* output) { output->reset(); }

  static decltype(::attribution_internals::mojom::WebUISource::id) id(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->id;
  }

  static decltype(::attribution_internals::mojom::WebUISource::source_event_id) source_event_id(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->source_event_id;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::source_origin)& source_origin(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->source_origin;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::destinations)& destinations(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->destinations;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::reporting_origin)& reporting_origin(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->reporting_origin;
  }

  static decltype(::attribution_internals::mojom::WebUISource::source_time) source_time(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->source_time;
  }

  static decltype(::attribution_internals::mojom::WebUISource::expiry_time) expiry_time(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->expiry_time;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::event_report_windows)& event_report_windows(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->event_report_windows;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::trigger_data)& trigger_data(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->trigger_data;
  }

  static decltype(::attribution_internals::mojom::WebUISource::max_event_level_reports) max_event_level_reports(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->max_event_level_reports;
  }

  static decltype(::attribution_internals::mojom::WebUISource::aggregatable_report_window_time) aggregatable_report_window_time(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->aggregatable_report_window_time;
  }

  static decltype(::attribution_internals::mojom::WebUISource::source_type) source_type(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->source_type;
  }

  static decltype(::attribution_internals::mojom::WebUISource::priority) priority(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->priority;
  }

  static decltype(::attribution_internals::mojom::WebUISource::debug_key) debug_key(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->debug_key;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::dedup_keys)& dedup_keys(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->dedup_keys;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::filter_data)& filter_data(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->filter_data;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::aggregation_keys)& aggregation_keys(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->aggregation_keys;
  }

  static decltype(::attribution_internals::mojom::WebUISource::remaining_aggregatable_attribution_budget) remaining_aggregatable_attribution_budget(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->remaining_aggregatable_attribution_budget;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::aggregatable_dedup_keys)& aggregatable_dedup_keys(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->aggregatable_dedup_keys;
  }

  static decltype(::attribution_internals::mojom::WebUISource::trigger_data_matching) trigger_data_matching(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->trigger_data_matching;
  }

  static decltype(::attribution_internals::mojom::WebUISource::event_level_epsilon) event_level_epsilon(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->event_level_epsilon;
  }

  static decltype(::attribution_internals::mojom::WebUISource::cookie_based_debug_allowed) cookie_based_debug_allowed(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->cookie_based_debug_allowed;
  }

  static decltype(::attribution_internals::mojom::WebUISource::remaining_aggregatable_debug_budget) remaining_aggregatable_debug_budget(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->remaining_aggregatable_debug_budget;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::aggregatable_debug_key_piece)& aggregatable_debug_key_piece(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->aggregatable_debug_key_piece;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::attribution_scopes_data_json)& attribution_scopes_data_json(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->attribution_scopes_data_json;
  }

  static const decltype(::attribution_internals::mojom::WebUISource::aggregatable_named_budgets)& aggregatable_named_budgets(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->aggregatable_named_budgets;
  }

  static decltype(::attribution_internals::mojom::WebUISource::attributability) attributability(
      const ::attribution_internals::mojom::WebUISourcePtr& input) {
    return input->attributability;
  }

  static bool Read(::attribution_internals::mojom::WebUISource::DataView input, ::attribution_internals::mojom::WebUISourcePtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIRegistration::DataView,
                                         ::attribution_internals::mojom::WebUIRegistrationPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIRegistrationPtr* output) { output->reset(); }

  static decltype(::attribution_internals::mojom::WebUIRegistration::time) time(
      const ::attribution_internals::mojom::WebUIRegistrationPtr& input) {
    return input->time;
  }

  static const decltype(::attribution_internals::mojom::WebUIRegistration::context_origin)& context_origin(
      const ::attribution_internals::mojom::WebUIRegistrationPtr& input) {
    return input->context_origin;
  }

  static const decltype(::attribution_internals::mojom::WebUIRegistration::reporting_origin)& reporting_origin(
      const ::attribution_internals::mojom::WebUIRegistrationPtr& input) {
    return input->reporting_origin;
  }

  static const decltype(::attribution_internals::mojom::WebUIRegistration::registration_json)& registration_json(
      const ::attribution_internals::mojom::WebUIRegistrationPtr& input) {
    return input->registration_json;
  }

  static decltype(::attribution_internals::mojom::WebUIRegistration::cleared_debug_key) cleared_debug_key(
      const ::attribution_internals::mojom::WebUIRegistrationPtr& input) {
    return input->cleared_debug_key;
  }

  static bool Read(::attribution_internals::mojom::WebUIRegistration::DataView input, ::attribution_internals::mojom::WebUIRegistrationPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUITrigger::DataView,
                                         ::attribution_internals::mojom::WebUITriggerPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUITriggerPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUITriggerPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUITrigger::registration)& registration(
      const ::attribution_internals::mojom::WebUITriggerPtr& input) {
    return input->registration;
  }

  static decltype(::attribution_internals::mojom::WebUITrigger::event_level_result) event_level_result(
      const ::attribution_internals::mojom::WebUITriggerPtr& input) {
    return input->event_level_result;
  }

  static decltype(::attribution_internals::mojom::WebUITrigger::aggregatable_result) aggregatable_result(
      const ::attribution_internals::mojom::WebUITriggerPtr& input) {
    return input->aggregatable_result;
  }

  static bool Read(::attribution_internals::mojom::WebUITrigger::DataView input, ::attribution_internals::mojom::WebUITriggerPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUISourceRegistration::DataView,
                                         ::attribution_internals::mojom::WebUISourceRegistrationPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUISourceRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUISourceRegistrationPtr* output) { output->reset(); }

  static const decltype(::attribution_internals::mojom::WebUISourceRegistration::registration)& registration(
      const ::attribution_internals::mojom::WebUISourceRegistrationPtr& input) {
    return input->registration;
  }

  static decltype(::attribution_internals::mojom::WebUISourceRegistration::type) type(
      const ::attribution_internals::mojom::WebUISourceRegistrationPtr& input) {
    return input->type;
  }

  static decltype(::attribution_internals::mojom::WebUISourceRegistration::status) status(
      const ::attribution_internals::mojom::WebUISourceRegistrationPtr& input) {
    return input->status;
  }

  static bool Read(::attribution_internals::mojom::WebUISourceRegistration::DataView input, ::attribution_internals::mojom::WebUISourceRegistrationPtr* output);
};


template <>
struct  StructTraits<::attribution_internals::mojom::WebUIOsRegistration::DataView,
                                         ::attribution_internals::mojom::WebUIOsRegistrationPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIOsRegistrationPtr* output) { output->reset(); }

  static decltype(::attribution_internals::mojom::WebUIOsRegistration::time) time(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->time;
  }

  static const decltype(::attribution_internals::mojom::WebUIOsRegistration::registration_url)& registration_url(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->registration_url;
  }

  static const decltype(::attribution_internals::mojom::WebUIOsRegistration::top_level_origin)& top_level_origin(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->top_level_origin;
  }

  static decltype(::attribution_internals::mojom::WebUIOsRegistration::is_debug_key_allowed) is_debug_key_allowed(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->is_debug_key_allowed;
  }

  static decltype(::attribution_internals::mojom::WebUIOsRegistration::debug_reporting) debug_reporting(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->debug_reporting;
  }

  static decltype(::attribution_internals::mojom::WebUIOsRegistration::type) type(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->type;
  }

  static decltype(::attribution_internals::mojom::WebUIOsRegistration::result) result(
      const ::attribution_internals::mojom::WebUIOsRegistrationPtr& input) {
    return input->result;
  }

  static bool Read(::attribution_internals::mojom::WebUIOsRegistration::DataView input, ::attribution_internals::mojom::WebUIOsRegistrationPtr* output);
};


template <>
struct  UnionTraits<::attribution_internals::mojom::WebUIReportData::DataView,
                                        ::attribution_internals::mojom::WebUIReportDataPtr> {
  static bool IsNull(const ::attribution_internals::mojom::WebUIReportDataPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::WebUIReportDataPtr* output) { output->reset(); }

  static ::attribution_internals::mojom::WebUIReportData::Tag GetTag(const ::attribution_internals::mojom::WebUIReportDataPtr& input) {
    return input->which();
  }

  static const ::attribution_internals::mojom::WebUIReportEventLevelDataPtr& event_level_data(const ::attribution_internals::mojom::WebUIReportDataPtr& input) {
    return input->get_event_level_data();
  }

  static const ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr& aggregatable_attribution_data(const ::attribution_internals::mojom::WebUIReportDataPtr& input) {
    return input->get_aggregatable_attribution_data();
  }

  static bool Read(::attribution_internals::mojom::WebUIReportData::DataView input, ::attribution_internals::mojom::WebUIReportDataPtr* output);
};


template <>
struct  UnionTraits<::attribution_internals::mojom::NetworkStatus::DataView,
                                        ::attribution_internals::mojom::NetworkStatusPtr> {
  static bool IsNull(const ::attribution_internals::mojom::NetworkStatusPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::NetworkStatusPtr* output) { output->reset(); }

  static ::attribution_internals::mojom::NetworkStatus::Tag GetTag(const ::attribution_internals::mojom::NetworkStatusPtr& input) {
    return input->which();
  }

  static  int32_t http_response_code(const ::attribution_internals::mojom::NetworkStatusPtr& input) {
    return input->get_http_response_code();
  }

  static const std::string& network_error(const ::attribution_internals::mojom::NetworkStatusPtr& input) {
    return input->get_network_error();
  }

  static bool Read(::attribution_internals::mojom::NetworkStatus::DataView input, ::attribution_internals::mojom::NetworkStatusPtr* output);
};


template <>
struct  UnionTraits<::attribution_internals::mojom::ReportStatus::DataView,
                                        ::attribution_internals::mojom::ReportStatusPtr> {
  static bool IsNull(const ::attribution_internals::mojom::ReportStatusPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::ReportStatusPtr* output) { output->reset(); }

  static ::attribution_internals::mojom::ReportStatus::Tag GetTag(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->which();
  }

  static const ::attribution_internals::mojom::EmptyPtr& pending(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_pending();
  }

  static const std::string& replaced_by_higher_priority_report(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_replaced_by_higher_priority_report();
  }

  static const ::attribution_internals::mojom::EmptyPtr& prohibited_by_browser_policy(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_prohibited_by_browser_policy();
  }

  static const ::attribution_internals::mojom::EmptyPtr& expired(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_expired();
  }

  static const ::attribution_internals::mojom::NetworkStatusPtr& network_status(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_network_status();
  }

  static const ::attribution_internals::mojom::EmptyPtr& failed_to_assemble(const ::attribution_internals::mojom::ReportStatusPtr& input) {
    return input->get_failed_to_assemble();
  }

  static bool Read(::attribution_internals::mojom::ReportStatus::DataView input, ::attribution_internals::mojom::ReportStatusPtr* output);
};


template <>
struct  UnionTraits<::attribution_internals::mojom::SendAggregatableDebugReportResult::DataView,
                                        ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr> {
  static bool IsNull(const ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr& input) { return !input; }
  static void SetToNull(::attribution_internals::mojom::SendAggregatableDebugReportResultPtr* output) { output->reset(); }

  static ::attribution_internals::mojom::SendAggregatableDebugReportResult::Tag GetTag(const ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr& input) {
    return input->which();
  }

  static const ::attribution_internals::mojom::EmptyPtr& assembly_failed(const ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr& input) {
    return input->get_assembly_failed();
  }

  static const ::attribution_internals::mojom::NetworkStatusPtr& network_status(const ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr& input) {
    return input->get_network_status();
  }

  static bool Read(::attribution_internals::mojom::SendAggregatableDebugReportResult::DataView input, ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_H_