// content/browser/attribution_reporting/attribution_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/attribution_reporting/attribution_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-params-data.h"
#include "content/browser/attribution_reporting/attribution_internals.mojom-shared-message-ids.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-import-headers.h"
#include "content/browser/attribution_reporting/attribution_internals.mojom-test-utils.h"


namespace attribution_internals::mojom {
ReportID::ReportID()
    : value() {}

ReportID::ReportID(
    int64_t value_in)
    : value(std::move(value_in)) {}

ReportID::~ReportID() = default;

void ReportID::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportID::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIReportEventLevelData::WebUIReportEventLevelData()
    : priority(),
      attributed_truthfully() {}

WebUIReportEventLevelData::WebUIReportEventLevelData(
    int64_t priority_in,
    bool attributed_truthfully_in)
    : priority(std::move(priority_in)),
      attributed_truthfully(std::move(attributed_truthfully_in)) {}

WebUIReportEventLevelData::~WebUIReportEventLevelData() = default;
size_t WebUIReportEventLevelData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->priority);
  seed = mojo::internal::Hash(seed, this->attributed_truthfully);
  return seed;
}

void WebUIReportEventLevelData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributed_truthfully"), this->attributed_truthfully,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIReportEventLevelData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableHistogramContribution::AggregatableHistogramContribution()
    : key(),
      value(),
      filtering_id() {}

AggregatableHistogramContribution::AggregatableHistogramContribution(
    const std::string& key_in,
    uint32_t value_in,
    uint64_t filtering_id_in)
    : key(std::move(key_in)),
      value(std::move(value_in)),
      filtering_id(std::move(filtering_id_in)) {}

AggregatableHistogramContribution::~AggregatableHistogramContribution() = default;
size_t AggregatableHistogramContribution::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->value);
  seed = mojo::internal::Hash(seed, this->filtering_id);
  return seed;
}

void AggregatableHistogramContribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id"), this->filtering_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableHistogramContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIReportAggregatableAttributionData::WebUIReportAggregatableAttributionData()
    : contributions(),
      aggregation_coordinator(),
      is_null_report() {}

WebUIReportAggregatableAttributionData::WebUIReportAggregatableAttributionData(
    std::vector<AggregatableHistogramContributionPtr> contributions_in,
    const std::string& aggregation_coordinator_in,
    bool is_null_report_in)
    : contributions(std::move(contributions_in)),
      aggregation_coordinator(std::move(aggregation_coordinator_in)),
      is_null_report(std::move(is_null_report_in)) {}

WebUIReportAggregatableAttributionData::~WebUIReportAggregatableAttributionData() = default;

void WebUIReportAggregatableAttributionData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contributions"), this->contributions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AggregatableHistogramContributionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator"), this->aggregation_coordinator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_null_report"), this->is_null_report,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIReportAggregatableAttributionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Empty::Empty() {}

Empty::~Empty() = default;
size_t Empty::Hash(size_t seed) const {
  return seed;
}

void Empty::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool Empty::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIReport::WebUIReport()
    : id(),
      report_url(),
      trigger_time(),
      report_time(),
      report_body(),
      status(),
      data() {}

WebUIReport::WebUIReport(
    ::content::AttributionReport::Id id_in,
    const ::GURL& report_url_in,
    double trigger_time_in,
    double report_time_in,
    const std::string& report_body_in,
    ReportStatusPtr status_in,
    WebUIReportDataPtr data_in)
    : id(std::move(id_in)),
      report_url(std::move(report_url_in)),
      trigger_time(std::move(trigger_time_in)),
      report_time(std::move(report_time_in)),
      report_body(std::move(report_body_in)),
      status(std::move(status_in)),
      data(std::move(data_in)) {}

WebUIReport::~WebUIReport() = default;

void WebUIReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::AttributionReport::Id>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_url"), this->report_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_time"), this->trigger_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_time"), this->report_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_body"), this->report_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ReportStatusPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebUIReportDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIDebugReport::WebUIDebugReport()
    : url(),
      time(),
      body(),
      status() {}

WebUIDebugReport::WebUIDebugReport(
    const ::GURL& url_in,
    double time_in,
    const std::string& body_in,
    NetworkStatusPtr status_in)
    : url(std::move(url_in)),
      time(std::move(time_in)),
      body(std::move(body_in)),
      status(std::move(status_in)) {}

WebUIDebugReport::~WebUIDebugReport() = default;

void WebUIDebugReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkStatusPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIDebugReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIAggregatableDebugReport::WebUIAggregatableDebugReport()
    : url(),
      time(),
      body(),
      process_result(),
      send_result() {}

WebUIAggregatableDebugReport::WebUIAggregatableDebugReport(
    const ::GURL& url_in,
    double time_in,
    const std::string& body_in,
    ::attribution_reporting::mojom::ProcessAggregatableDebugReportResult process_result_in,
    SendAggregatableDebugReportResultPtr send_result_in)
    : url(std::move(url_in)),
      time(std::move(time_in)),
      body(std::move(body_in)),
      process_result(std::move(process_result_in)),
      send_result(std::move(send_result_in)) {}

WebUIAggregatableDebugReport::~WebUIAggregatableDebugReport() = default;

void WebUIAggregatableDebugReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_result"), this->process_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::ProcessAggregatableDebugReportResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_result"), this->send_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SendAggregatableDebugReportResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIAggregatableDebugReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUISource::WebUISource()
    : id(),
      source_event_id(),
      source_origin(),
      destinations(mojo::internal::DefaultConstructTag()),
      reporting_origin(),
      source_time(),
      expiry_time(),
      event_report_windows(),
      trigger_data(),
      max_event_level_reports(),
      aggregatable_report_window_time(),
      source_type(),
      priority(),
      debug_key(),
      dedup_keys(),
      filter_data(),
      aggregation_keys(),
      remaining_aggregatable_attribution_budget(),
      aggregatable_dedup_keys(),
      trigger_data_matching(),
      event_level_epsilon(),
      cookie_based_debug_allowed(),
      remaining_aggregatable_debug_budget(),
      aggregatable_debug_key_piece(),
      attribution_scopes_data_json(),
      aggregatable_named_budgets(),
      attributability() {}

WebUISource::WebUISource(
    int64_t id_in,
    uint64_t source_event_id_in,
    const ::url::Origin& source_origin_in,
    const ::attribution_reporting::DestinationSet& destinations_in,
    const ::url::Origin& reporting_origin_in,
    double source_time_in,
    double expiry_time_in,
    const ::attribution_reporting::EventReportWindows& event_report_windows_in,
    std::vector<uint32_t> trigger_data_in,
    int32_t max_event_level_reports_in,
    double aggregatable_report_window_time_in,
    ::attribution_reporting::mojom::SourceType source_type_in,
    int64_t priority_in,
    std::optional<uint64_t> debug_key_in,
    std::vector<uint64_t> dedup_keys_in,
    const ::attribution_reporting::FilterData& filter_data_in,
    const base::flat_map<std::string, std::string>& aggregation_keys_in,
    int32_t remaining_aggregatable_attribution_budget_in,
    std::vector<uint64_t> aggregatable_dedup_keys_in,
    ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching_in,
    double event_level_epsilon_in,
    bool cookie_based_debug_allowed_in,
    int32_t remaining_aggregatable_debug_budget_in,
    const std::string& aggregatable_debug_key_piece_in,
    const std::string& attribution_scopes_data_json_in,
    const std::string& aggregatable_named_budgets_in,
    WebUISource::Attributability attributability_in)
    : id(std::move(id_in)),
      source_event_id(std::move(source_event_id_in)),
      source_origin(std::move(source_origin_in)),
      destinations(std::move(destinations_in)),
      reporting_origin(std::move(reporting_origin_in)),
      source_time(std::move(source_time_in)),
      expiry_time(std::move(expiry_time_in)),
      event_report_windows(std::move(event_report_windows_in)),
      trigger_data(std::move(trigger_data_in)),
      max_event_level_reports(std::move(max_event_level_reports_in)),
      aggregatable_report_window_time(std::move(aggregatable_report_window_time_in)),
      source_type(std::move(source_type_in)),
      priority(std::move(priority_in)),
      debug_key(std::move(debug_key_in)),
      dedup_keys(std::move(dedup_keys_in)),
      filter_data(std::move(filter_data_in)),
      aggregation_keys(std::move(aggregation_keys_in)),
      remaining_aggregatable_attribution_budget(std::move(remaining_aggregatable_attribution_budget_in)),
      aggregatable_dedup_keys(std::move(aggregatable_dedup_keys_in)),
      trigger_data_matching(std::move(trigger_data_matching_in)),
      event_level_epsilon(std::move(event_level_epsilon_in)),
      cookie_based_debug_allowed(std::move(cookie_based_debug_allowed_in)),
      remaining_aggregatable_debug_budget(std::move(remaining_aggregatable_debug_budget_in)),
      aggregatable_debug_key_piece(std::move(aggregatable_debug_key_piece_in)),
      attribution_scopes_data_json(std::move(attribution_scopes_data_json_in)),
      aggregatable_named_budgets(std::move(aggregatable_named_budgets_in)),
      attributability(std::move(attributability_in)) {}

WebUISource::~WebUISource() = default;

void WebUISource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_event_id"), this->source_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destinations"), this->destinations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::DestinationSet&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_time"), this->source_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry_time"), this->expiry_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_report_windows"), this->event_report_windows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::EventReportWindows&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_data"), this->trigger_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_event_level_reports"), this->max_event_level_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_report_window_time"), this->aggregatable_report_window_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::SourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_key"), this->debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dedup_keys"), this->dedup_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_data"), this->filter_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_keys"), this->aggregation_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remaining_aggregatable_attribution_budget"), this->remaining_aggregatable_attribution_budget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_dedup_keys"), this->aggregatable_dedup_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_data_matching"), this->trigger_data_matching,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::TriggerDataMatching>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_level_epsilon"), this->event_level_epsilon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_based_debug_allowed"), this->cookie_based_debug_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remaining_aggregatable_debug_budget"), this->remaining_aggregatable_debug_budget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_debug_key_piece"), this->aggregatable_debug_key_piece,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_scopes_data_json"), this->attribution_scopes_data_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_named_budgets"), this->aggregatable_named_budgets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributability"), this->attributability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebUISource::Attributability>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUISource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIRegistration::WebUIRegistration()
    : time(),
      context_origin(),
      reporting_origin(),
      registration_json(),
      cleared_debug_key() {}

WebUIRegistration::WebUIRegistration(
    double time_in,
    const ::url::Origin& context_origin_in,
    const ::url::Origin& reporting_origin_in,
    const std::string& registration_json_in,
    std::optional<uint64_t> cleared_debug_key_in)
    : time(std::move(time_in)),
      context_origin(std::move(context_origin_in)),
      reporting_origin(std::move(reporting_origin_in)),
      registration_json(std::move(registration_json_in)),
      cleared_debug_key(std::move(cleared_debug_key_in)) {}

WebUIRegistration::~WebUIRegistration() = default;

void WebUIRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_origin"), this->context_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_json"), this->registration_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cleared_debug_key"), this->cleared_debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUITrigger::WebUITrigger()
    : registration(),
      event_level_result(),
      aggregatable_result() {}

WebUITrigger::WebUITrigger(
    WebUIRegistrationPtr registration_in,
    ::attribution_reporting::mojom::EventLevelResult event_level_result_in,
    ::attribution_reporting::mojom::AggregatableResult aggregatable_result_in)
    : registration(std::move(registration_in)),
      event_level_result(std::move(event_level_result_in)),
      aggregatable_result(std::move(aggregatable_result_in)) {}

WebUITrigger::~WebUITrigger() = default;

void WebUITrigger::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration"), this->registration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebUIRegistrationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_level_result"), this->event_level_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::EventLevelResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_result"), this->aggregatable_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::AggregatableResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUITrigger::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUISourceRegistration::WebUISourceRegistration()
    : registration(),
      type(),
      status() {}

WebUISourceRegistration::WebUISourceRegistration(
    WebUIRegistrationPtr registration_in,
    ::attribution_reporting::mojom::SourceType type_in,
    ::attribution_reporting::mojom::StoreSourceResult status_in)
    : registration(std::move(registration_in)),
      type(std::move(type_in)),
      status(std::move(status_in)) {}

WebUISourceRegistration::~WebUISourceRegistration() = default;

void WebUISourceRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration"), this->registration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebUIRegistrationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::SourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::StoreSourceResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUISourceRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIOsRegistration::WebUIOsRegistration()
    : time(),
      registration_url(),
      top_level_origin(),
      is_debug_key_allowed(),
      debug_reporting(),
      type(),
      result() {}

WebUIOsRegistration::WebUIOsRegistration(
    double time_in,
    const ::GURL& registration_url_in,
    const ::url::Origin& top_level_origin_in,
    bool is_debug_key_allowed_in,
    bool debug_reporting_in,
    ::attribution_reporting::mojom::RegistrationType type_in,
    ::attribution_reporting::mojom::OsRegistrationResult result_in)
    : time(std::move(time_in)),
      registration_url(std::move(registration_url_in)),
      top_level_origin(std::move(top_level_origin_in)),
      is_debug_key_allowed(std::move(is_debug_key_allowed_in)),
      debug_reporting(std::move(debug_reporting_in)),
      type(std::move(type_in)),
      result(std::move(result_in)) {}

WebUIOsRegistration::~WebUIOsRegistration() = default;

void WebUIOsRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_url"), this->registration_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_origin"), this->top_level_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_debug_key_allowed"), this->is_debug_key_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_reporting"), this->debug_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::RegistrationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::OsRegistrationResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIOsRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIReportDataPtr
WebUIReportData::NewEventLevelData(
    WebUIReportEventLevelDataPtr value) {
  return WebUIReportDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEventLevelData)>,
      std::move(value));
}

WebUIReportDataPtr
WebUIReportData::NewAggregatableAttributionData(
    WebUIReportAggregatableAttributionDataPtr value) {
  return WebUIReportDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
      std::move(value));
}

WebUIReportData::WebUIReportData(
    std::in_place_index_t<static_cast<size_t>(Tag::kEventLevelData)>,
    WebUIReportEventLevelDataPtr value)
    : tag_(Tag::kEventLevelData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEventLevelData)>,
            std::move(value)) {}

WebUIReportData::WebUIReportData(
    std::in_place_index_t<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
    WebUIReportAggregatableAttributionDataPtr value)
    : tag_(Tag::kAggregatableAttributionData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
            std::move(value)) {}
WebUIReportData::~WebUIReportData() {
  DestroyActive();
}

void WebUIReportData::set_event_level_data(WebUIReportEventLevelDataPtr event_level_data) {
  if (tag_ == Tag::kEventLevelData) {
    data_.event_level_data = std::move(event_level_data);
  } else {
    DestroyActive();
    tag_ = Tag::kEventLevelData;
    new (&data_.event_level_data) WebUIReportEventLevelDataPtr(
        std::move(event_level_data));
  }
}

void WebUIReportData::set_aggregatable_attribution_data(WebUIReportAggregatableAttributionDataPtr aggregatable_attribution_data) {
  if (tag_ == Tag::kAggregatableAttributionData) {
    data_.aggregatable_attribution_data = std::move(aggregatable_attribution_data);
  } else {
    DestroyActive();
    tag_ = Tag::kAggregatableAttributionData;
    new (&data_.aggregatable_attribution_data) WebUIReportAggregatableAttributionDataPtr(
        std::move(aggregatable_attribution_data));
  }
}


WebUIReportData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEventLevelData)>,
    WebUIReportEventLevelDataPtr value)
    : event_level_data(std::move(value)) {}

WebUIReportData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAggregatableAttributionData)>,
    WebUIReportAggregatableAttributionDataPtr value)
    : aggregatable_attribution_data(std::move(value)) {}

void WebUIReportData::DestroyActive() {
  switch (tag_) {

    case Tag::kEventLevelData:
      std::destroy_at(&data_.event_level_data);
      break;
    case Tag::kAggregatableAttributionData:
      std::destroy_at(&data_.aggregatable_attribution_data);
      break;
  }
}

bool WebUIReportData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
NetworkStatusPtr
NetworkStatus::NewHttpResponseCode(
    int32_t value) {
  return NetworkStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHttpResponseCode)>,
      std::move(value));
}

NetworkStatusPtr
NetworkStatus::NewNetworkError(
    const std::string& value) {
  return NetworkStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNetworkError)>,
      std::move(value));
}

NetworkStatus::NetworkStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kHttpResponseCode)>,
    int32_t value)
    : tag_(Tag::kHttpResponseCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHttpResponseCode)>,
            std::move(value)) {}

NetworkStatus::NetworkStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkError)>,
    const std::string& value)
    : tag_(Tag::kNetworkError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNetworkError)>,
            std::move(value)) {}
NetworkStatus::~NetworkStatus() {
  DestroyActive();
}

void NetworkStatus::set_http_response_code(int32_t http_response_code) {
  if (tag_ != Tag::kHttpResponseCode) {
    DestroyActive();
    tag_ = Tag::kHttpResponseCode;
  }
  data_.http_response_code = http_response_code;
}

void NetworkStatus::set_network_error(const std::string& network_error) {
  if (tag_ == Tag::kNetworkError) {
    data_.network_error = std::move(network_error);
  } else {
    DestroyActive();
    tag_ = Tag::kNetworkError;
    new (&data_.network_error) std::string(
        std::move(network_error));
  }
}


NetworkStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHttpResponseCode)>,
    int32_t value)
    : http_response_code(std::move(value)) {}

NetworkStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkError)>,
    const std::string& value)
    : network_error(std::move(value)) {}

void NetworkStatus::DestroyActive() {
  switch (tag_) {

    case Tag::kHttpResponseCode:
      std::destroy_at(&data_.http_response_code);
      break;
    case Tag::kNetworkError:
      std::destroy_at(&data_.network_error);
      break;
  }
}
size_t NetworkStatus::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kHttpResponseCode:
      return mojo::internal::Hash(seed, data_.http_response_code);
    case Tag::kNetworkError:
      return mojo::internal::Hash(seed, data_.network_error);
    default:
      NOTREACHED();
  }
}

bool NetworkStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ReportStatusPtr
ReportStatus::NewPending(
    EmptyPtr value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPending)>,
      std::move(value));
}

ReportStatusPtr
ReportStatus::NewReplacedByHigherPriorityReport(
    const std::string& value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
      std::move(value));
}

ReportStatusPtr
ReportStatus::NewProhibitedByBrowserPolicy(
    EmptyPtr value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
      std::move(value));
}

ReportStatusPtr
ReportStatus::NewExpired(
    EmptyPtr value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExpired)>,
      std::move(value));
}

ReportStatusPtr
ReportStatus::NewNetworkStatus(
    NetworkStatusPtr value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNetworkStatus)>,
      std::move(value));
}

ReportStatusPtr
ReportStatus::NewFailedToAssemble(
    EmptyPtr value) {
  return ReportStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailedToAssemble)>,
      std::move(value));
}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kPending)>,
    EmptyPtr value)
    : tag_(Tag::kPending),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPending)>,
            std::move(value)) {}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
    const std::string& value)
    : tag_(Tag::kReplacedByHigherPriorityReport),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
            std::move(value)) {}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
    EmptyPtr value)
    : tag_(Tag::kProhibitedByBrowserPolicy),
      data_(std::in_place_index<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
            std::move(value)) {}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kExpired)>,
    EmptyPtr value)
    : tag_(Tag::kExpired),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExpired)>,
            std::move(value)) {}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
    NetworkStatusPtr value)
    : tag_(Tag::kNetworkStatus),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNetworkStatus)>,
            std::move(value)) {}

ReportStatus::ReportStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailedToAssemble)>,
    EmptyPtr value)
    : tag_(Tag::kFailedToAssemble),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailedToAssemble)>,
            std::move(value)) {}
ReportStatus::~ReportStatus() {
  DestroyActive();
}

void ReportStatus::set_pending(EmptyPtr pending) {
  if (tag_ == Tag::kPending) {
    data_.pending = std::move(pending);
  } else {
    DestroyActive();
    tag_ = Tag::kPending;
    new (&data_.pending) EmptyPtr(
        std::move(pending));
  }
}

void ReportStatus::set_replaced_by_higher_priority_report(const std::string& replaced_by_higher_priority_report) {
  if (tag_ == Tag::kReplacedByHigherPriorityReport) {
    data_.replaced_by_higher_priority_report = std::move(replaced_by_higher_priority_report);
  } else {
    DestroyActive();
    tag_ = Tag::kReplacedByHigherPriorityReport;
    new (&data_.replaced_by_higher_priority_report) std::string(
        std::move(replaced_by_higher_priority_report));
  }
}

void ReportStatus::set_prohibited_by_browser_policy(EmptyPtr prohibited_by_browser_policy) {
  if (tag_ == Tag::kProhibitedByBrowserPolicy) {
    data_.prohibited_by_browser_policy = std::move(prohibited_by_browser_policy);
  } else {
    DestroyActive();
    tag_ = Tag::kProhibitedByBrowserPolicy;
    new (&data_.prohibited_by_browser_policy) EmptyPtr(
        std::move(prohibited_by_browser_policy));
  }
}

void ReportStatus::set_expired(EmptyPtr expired) {
  if (tag_ == Tag::kExpired) {
    data_.expired = std::move(expired);
  } else {
    DestroyActive();
    tag_ = Tag::kExpired;
    new (&data_.expired) EmptyPtr(
        std::move(expired));
  }
}

void ReportStatus::set_network_status(NetworkStatusPtr network_status) {
  if (tag_ == Tag::kNetworkStatus) {
    data_.network_status = std::move(network_status);
  } else {
    DestroyActive();
    tag_ = Tag::kNetworkStatus;
    new (&data_.network_status) NetworkStatusPtr(
        std::move(network_status));
  }
}

void ReportStatus::set_failed_to_assemble(EmptyPtr failed_to_assemble) {
  if (tag_ == Tag::kFailedToAssemble) {
    data_.failed_to_assemble = std::move(failed_to_assemble);
  } else {
    DestroyActive();
    tag_ = Tag::kFailedToAssemble;
    new (&data_.failed_to_assemble) EmptyPtr(
        std::move(failed_to_assemble));
  }
}


ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPending)>,
    EmptyPtr value)
    : pending(std::move(value)) {}

ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReplacedByHigherPriorityReport)>,
    const std::string& value)
    : replaced_by_higher_priority_report(std::move(value)) {}

ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kProhibitedByBrowserPolicy)>,
    EmptyPtr value)
    : prohibited_by_browser_policy(std::move(value)) {}

ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExpired)>,
    EmptyPtr value)
    : expired(std::move(value)) {}

ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
    NetworkStatusPtr value)
    : network_status(std::move(value)) {}

ReportStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailedToAssemble)>,
    EmptyPtr value)
    : failed_to_assemble(std::move(value)) {}

void ReportStatus::DestroyActive() {
  switch (tag_) {

    case Tag::kPending:
      std::destroy_at(&data_.pending);
      break;
    case Tag::kReplacedByHigherPriorityReport:
      std::destroy_at(&data_.replaced_by_higher_priority_report);
      break;
    case Tag::kProhibitedByBrowserPolicy:
      std::destroy_at(&data_.prohibited_by_browser_policy);
      break;
    case Tag::kExpired:
      std::destroy_at(&data_.expired);
      break;
    case Tag::kNetworkStatus:
      std::destroy_at(&data_.network_status);
      break;
    case Tag::kFailedToAssemble:
      std::destroy_at(&data_.failed_to_assemble);
      break;
  }
}
size_t ReportStatus::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPending:
      return mojo::internal::Hash(seed, data_.pending);
    case Tag::kReplacedByHigherPriorityReport:
      return mojo::internal::Hash(seed, data_.replaced_by_higher_priority_report);
    case Tag::kProhibitedByBrowserPolicy:
      return mojo::internal::Hash(seed, data_.prohibited_by_browser_policy);
    case Tag::kExpired:
      return mojo::internal::Hash(seed, data_.expired);
    case Tag::kNetworkStatus:
      return mojo::internal::Hash(seed, data_.network_status);
    case Tag::kFailedToAssemble:
      return mojo::internal::Hash(seed, data_.failed_to_assemble);
    default:
      NOTREACHED();
  }
}

bool ReportStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SendAggregatableDebugReportResultPtr
SendAggregatableDebugReportResult::NewAssemblyFailed(
    EmptyPtr value) {
  return SendAggregatableDebugReportResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAssemblyFailed)>,
      std::move(value));
}

SendAggregatableDebugReportResultPtr
SendAggregatableDebugReportResult::NewNetworkStatus(
    NetworkStatusPtr value) {
  return SendAggregatableDebugReportResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNetworkStatus)>,
      std::move(value));
}

SendAggregatableDebugReportResult::SendAggregatableDebugReportResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kAssemblyFailed)>,
    EmptyPtr value)
    : tag_(Tag::kAssemblyFailed),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAssemblyFailed)>,
            std::move(value)) {}

SendAggregatableDebugReportResult::SendAggregatableDebugReportResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
    NetworkStatusPtr value)
    : tag_(Tag::kNetworkStatus),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNetworkStatus)>,
            std::move(value)) {}
SendAggregatableDebugReportResult::~SendAggregatableDebugReportResult() {
  DestroyActive();
}

void SendAggregatableDebugReportResult::set_assembly_failed(EmptyPtr assembly_failed) {
  if (tag_ == Tag::kAssemblyFailed) {
    data_.assembly_failed = std::move(assembly_failed);
  } else {
    DestroyActive();
    tag_ = Tag::kAssemblyFailed;
    new (&data_.assembly_failed) EmptyPtr(
        std::move(assembly_failed));
  }
}

void SendAggregatableDebugReportResult::set_network_status(NetworkStatusPtr network_status) {
  if (tag_ == Tag::kNetworkStatus) {
    data_.network_status = std::move(network_status);
  } else {
    DestroyActive();
    tag_ = Tag::kNetworkStatus;
    new (&data_.network_status) NetworkStatusPtr(
        std::move(network_status));
  }
}


SendAggregatableDebugReportResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAssemblyFailed)>,
    EmptyPtr value)
    : assembly_failed(std::move(value)) {}

SendAggregatableDebugReportResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkStatus)>,
    NetworkStatusPtr value)
    : network_status(std::move(value)) {}

void SendAggregatableDebugReportResult::DestroyActive() {
  switch (tag_) {

    case Tag::kAssemblyFailed:
      std::destroy_at(&data_.assembly_failed);
      break;
    case Tag::kNetworkStatus:
      std::destroy_at(&data_.network_status);
      break;
  }
}
size_t SendAggregatableDebugReportResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kAssemblyFailed:
      return mojo::internal::Hash(seed, data_.assembly_failed);
    case Tag::kNetworkStatus:
      return mojo::internal::Hash(seed, data_.network_status);
    default:
      NOTREACHED();
  }
}

bool SendAggregatableDebugReportResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

Observer::IPCStableHashFunction Observer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Observer>(message.name())) {
    case messages::Observer::kOnSourcesChanged: {
      return &Observer::OnSourcesChanged_Sym::IPCStableHash;
    }
    case messages::Observer::kOnReportsChanged: {
      return &Observer::OnReportsChanged_Sym::IPCStableHash;
    }
    case messages::Observer::kOnSourceHandled: {
      return &Observer::OnSourceHandled_Sym::IPCStableHash;
    }
    case messages::Observer::kOnReportHandled: {
      return &Observer::OnReportHandled_Sym::IPCStableHash;
    }
    case messages::Observer::kOnDebugReportSent: {
      return &Observer::OnDebugReportSent_Sym::IPCStableHash;
    }
    case messages::Observer::kOnAggregatableDebugReportSent: {
      return &Observer::OnAggregatableDebugReportSent_Sym::IPCStableHash;
    }
    case messages::Observer::kOnTriggerHandled: {
      return &Observer::OnTriggerHandled_Sym::IPCStableHash;
    }
    case messages::Observer::kOnOsRegistration: {
      return &Observer::OnOsRegistration_Sym::IPCStableHash;
    }
    case messages::Observer::kOnDebugModeChanged: {
      return &Observer::OnDebugModeChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Observer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Observer>(message.name())) {
      case messages::Observer::kOnSourcesChanged:
            return "Receive attribution_internals::mojom::Observer::OnSourcesChanged";
      case messages::Observer::kOnReportsChanged:
            return "Receive attribution_internals::mojom::Observer::OnReportsChanged";
      case messages::Observer::kOnSourceHandled:
            return "Receive attribution_internals::mojom::Observer::OnSourceHandled";
      case messages::Observer::kOnReportHandled:
            return "Receive attribution_internals::mojom::Observer::OnReportHandled";
      case messages::Observer::kOnDebugReportSent:
            return "Receive attribution_internals::mojom::Observer::OnDebugReportSent";
      case messages::Observer::kOnAggregatableDebugReportSent:
            return "Receive attribution_internals::mojom::Observer::OnAggregatableDebugReportSent";
      case messages::Observer::kOnTriggerHandled:
            return "Receive attribution_internals::mojom::Observer::OnTriggerHandled";
      case messages::Observer::kOnOsRegistration:
            return "Receive attribution_internals::mojom::Observer::OnOsRegistration";
      case messages::Observer::kOnDebugModeChanged:
            return "Receive attribution_internals::mojom::Observer::OnDebugModeChanged";
    }
  } else {
    switch (static_cast<messages::Observer>(message.name())) {
      case messages::Observer::kOnSourcesChanged:
            return "Receive reply attribution_internals::mojom::Observer::OnSourcesChanged";
      case messages::Observer::kOnReportsChanged:
            return "Receive reply attribution_internals::mojom::Observer::OnReportsChanged";
      case messages::Observer::kOnSourceHandled:
            return "Receive reply attribution_internals::mojom::Observer::OnSourceHandled";
      case messages::Observer::kOnReportHandled:
            return "Receive reply attribution_internals::mojom::Observer::OnReportHandled";
      case messages::Observer::kOnDebugReportSent:
            return "Receive reply attribution_internals::mojom::Observer::OnDebugReportSent";
      case messages::Observer::kOnAggregatableDebugReportSent:
            return "Receive reply attribution_internals::mojom::Observer::OnAggregatableDebugReportSent";
      case messages::Observer::kOnTriggerHandled:
            return "Receive reply attribution_internals::mojom::Observer::OnTriggerHandled";
      case messages::Observer::kOnOsRegistration:
            return "Receive reply attribution_internals::mojom::Observer::OnOsRegistration";
      case messages::Observer::kOnDebugModeChanged:
            return "Receive reply attribution_internals::mojom::Observer::OnDebugModeChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Observer::OnSourcesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea43e420;  // IPCStableHash for attribution_internals::mojom::Observer::OnSourcesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnReportsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa035fa13;  // IPCStableHash for attribution_internals::mojom::Observer::OnReportsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnSourceHandled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1235e23f;  // IPCStableHash for attribution_internals::mojom::Observer::OnSourceHandled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnReportHandled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98922aab;  // IPCStableHash for attribution_internals::mojom::Observer::OnReportHandled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnDebugReportSent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec73f92f;  // IPCStableHash for attribution_internals::mojom::Observer::OnDebugReportSent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnAggregatableDebugReportSent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04caf62b;  // IPCStableHash for attribution_internals::mojom::Observer::OnAggregatableDebugReportSent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnTriggerHandled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e5acd41;  // IPCStableHash for attribution_internals::mojom::Observer::OnTriggerHandled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnOsRegistration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f7dcaf6;  // IPCStableHash for attribution_internals::mojom::Observer::OnOsRegistration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Observer::OnDebugModeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23734f5c;  // IPCStableHash for attribution_internals::mojom::Observer::OnDebugModeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ObserverProxy::ObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ObserverProxy::OnSourcesChanged(
    std::vector<WebUISourcePtr> in_sources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnSourcesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sources"), in_sources,
                        "<value of type std::vector<WebUISourcePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnSourcesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnSourcesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sources)::BaseType>
      sources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::attribution_internals::mojom::WebUISourceDataView>>(
    in_sources,
    sources_fragment,
    &sources_validate_params);

  params->sources.Set(
      sources_fragment.is_null() ? nullptr : sources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sources in Observer.OnSourcesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnSourcesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnReportsChanged(
    std::vector<WebUIReportPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnReportsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports,
                        "<value of type std::vector<WebUIReportPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnReportsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnReportsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::attribution_internals::mojom::WebUIReportDataView>>(
    in_reports,
    reports_fragment,
    &reports_validate_params);

  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reports.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reports in Observer.OnReportsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnReportsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnSourceHandled(
    WebUISourceRegistrationPtr in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnSourceHandled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type WebUISourceRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnSourceHandled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnSourceHandled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUISourceRegistrationDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in Observer.OnSourceHandled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnSourceHandled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnReportHandled(
    WebUIReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnReportHandled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type WebUIReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnReportHandled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnReportHandled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUIReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in Observer.OnReportHandled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnReportHandled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnDebugReportSent(
    WebUIDebugReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnDebugReportSent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type WebUIDebugReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnDebugReportSent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnDebugReportSent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUIDebugReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in Observer.OnDebugReportSent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnDebugReportSent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnAggregatableDebugReportSent(
    WebUIAggregatableDebugReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnAggregatableDebugReportSent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type WebUIAggregatableDebugReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnAggregatableDebugReportSent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnAggregatableDebugReportSent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUIAggregatableDebugReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in Observer.OnAggregatableDebugReportSent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnAggregatableDebugReportSent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnTriggerHandled(
    WebUITriggerPtr in_trigger) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnTriggerHandled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trigger"), in_trigger,
                        "<value of type WebUITriggerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnTriggerHandled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnTriggerHandled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trigger)::BaseType> trigger_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUITriggerDataView>(
    in_trigger,
    trigger_fragment);

  params->trigger.Set(
      trigger_fragment.is_null() ? nullptr : trigger_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->trigger.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null trigger in Observer.OnTriggerHandled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnTriggerHandled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnOsRegistration(
    WebUIOsRegistrationPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnOsRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type WebUIOsRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnOsRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnOsRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::WebUIOsRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in Observer.OnOsRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnOsRegistration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ObserverProxy::OnDebugModeChanged(
    bool in_debug_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Observer::OnDebugModeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_mode"), in_debug_mode,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Observer::kOnDebugModeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Observer_OnDebugModeChanged_Params_Data> params(
          message);
  params.Allocate();

  params->debug_mode = in_debug_mode;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Observer::Name_);
  message.set_method_name("OnDebugModeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ObserverStubDispatch::Accept(
    Observer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Observer>(message->header()->name)) {
    case messages::Observer::kOnSourcesChanged: {
      DCHECK(message->is_serialized());
      internal::Observer_OnSourcesChanged_Params_Data* params =
          reinterpret_cast<internal::Observer_OnSourcesChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.0
      bool success = true;
      std::vector<WebUISourcePtr> p_sources{};
      Observer_OnSourcesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSources(&p_sources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSourcesChanged(        
        std::move(p_sources));
      return true;
    }
    case messages::Observer::kOnReportsChanged: {
      DCHECK(message->is_serialized());
      internal::Observer_OnReportsChanged_Params_Data* params =
          reinterpret_cast<internal::Observer_OnReportsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.1
      bool success = true;
      std::vector<WebUIReportPtr> p_reports{};
      Observer_OnReportsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReports(&p_reports))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportsChanged(        
        std::move(p_reports));
      return true;
    }
    case messages::Observer::kOnSourceHandled: {
      DCHECK(message->is_serialized());
      internal::Observer_OnSourceHandled_Params_Data* params =
          reinterpret_cast<internal::Observer_OnSourceHandled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.2
      bool success = true;
      WebUISourceRegistrationPtr p_source{};
      Observer_OnSourceHandled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSourceHandled(        
        std::move(p_source));
      return true;
    }
    case messages::Observer::kOnReportHandled: {
      DCHECK(message->is_serialized());
      internal::Observer_OnReportHandled_Params_Data* params =
          reinterpret_cast<internal::Observer_OnReportHandled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.3
      bool success = true;
      WebUIReportPtr p_report{};
      Observer_OnReportHandled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportHandled(        
        std::move(p_report));
      return true;
    }
    case messages::Observer::kOnDebugReportSent: {
      DCHECK(message->is_serialized());
      internal::Observer_OnDebugReportSent_Params_Data* params =
          reinterpret_cast<internal::Observer_OnDebugReportSent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.4
      bool success = true;
      WebUIDebugReportPtr p_report{};
      Observer_OnDebugReportSent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDebugReportSent(        
        std::move(p_report));
      return true;
    }
    case messages::Observer::kOnAggregatableDebugReportSent: {
      DCHECK(message->is_serialized());
      internal::Observer_OnAggregatableDebugReportSent_Params_Data* params =
          reinterpret_cast<internal::Observer_OnAggregatableDebugReportSent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.5
      bool success = true;
      WebUIAggregatableDebugReportPtr p_report{};
      Observer_OnAggregatableDebugReportSent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAggregatableDebugReportSent(        
        std::move(p_report));
      return true;
    }
    case messages::Observer::kOnTriggerHandled: {
      DCHECK(message->is_serialized());
      internal::Observer_OnTriggerHandled_Params_Data* params =
          reinterpret_cast<internal::Observer_OnTriggerHandled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.6
      bool success = true;
      WebUITriggerPtr p_trigger{};
      Observer_OnTriggerHandled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrigger(&p_trigger))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTriggerHandled(        
        std::move(p_trigger));
      return true;
    }
    case messages::Observer::kOnOsRegistration: {
      DCHECK(message->is_serialized());
      internal::Observer_OnOsRegistration_Params_Data* params =
          reinterpret_cast<internal::Observer_OnOsRegistration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.7
      bool success = true;
      WebUIOsRegistrationPtr p_registration{};
      Observer_OnOsRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOsRegistration(        
        std::move(p_registration));
      return true;
    }
    case messages::Observer::kOnDebugModeChanged: {
      DCHECK(message->is_serialized());
      internal::Observer_OnDebugModeChanged_Params_Data* params =
          reinterpret_cast<internal::Observer_OnDebugModeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Observer.8
      bool success = true;
      bool p_debug_mode{};
      Observer_OnDebugModeChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_debug_mode = input_data_view.debug_mode();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Observer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDebugModeChanged(        
        std::move(p_debug_mode));
      return true;
    }
  }
  return false;
}

// static
bool ObserverStubDispatch::AcceptWithResponder(
    Observer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Observer>(message->header()->name)) {
    case messages::Observer::kOnSourcesChanged: {
      break;
    }
    case messages::Observer::kOnReportsChanged: {
      break;
    }
    case messages::Observer::kOnSourceHandled: {
      break;
    }
    case messages::Observer::kOnReportHandled: {
      break;
    }
    case messages::Observer::kOnDebugReportSent: {
      break;
    }
    case messages::Observer::kOnAggregatableDebugReportSent: {
      break;
    }
    case messages::Observer::kOnTriggerHandled: {
      break;
    }
    case messages::Observer::kOnOsRegistration: {
      break;
    }
    case messages::Observer::kOnDebugModeChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kObserverValidationInfo[] = {
    { &internal::Observer_OnSourcesChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnReportsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnSourceHandled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnReportHandled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnDebugReportSent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnAggregatableDebugReportSent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnTriggerHandled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnOsRegistration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Observer_OnDebugModeChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::attribution_internals::mojom::Observer::Name_,
    kObserverValidationInfo);
}

// The declaration includes the definition on other builds.

Handler::IPCStableHashFunction Handler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Handler>(message.name())) {
    case messages::Handler::kIsAttributionReportingEnabled: {
      return &Handler::IsAttributionReportingEnabled_Sym::IPCStableHash;
    }
    case messages::Handler::kSendReport: {
      return &Handler::SendReport_Sym::IPCStableHash;
    }
    case messages::Handler::kClearStorage: {
      return &Handler::ClearStorage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Handler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Handler>(message.name())) {
      case messages::Handler::kIsAttributionReportingEnabled:
            return "Receive attribution_internals::mojom::Handler::IsAttributionReportingEnabled";
      case messages::Handler::kSendReport:
            return "Receive attribution_internals::mojom::Handler::SendReport";
      case messages::Handler::kClearStorage:
            return "Receive attribution_internals::mojom::Handler::ClearStorage";
    }
  } else {
    switch (static_cast<messages::Handler>(message.name())) {
      case messages::Handler::kIsAttributionReportingEnabled:
            return "Receive reply attribution_internals::mojom::Handler::IsAttributionReportingEnabled";
      case messages::Handler::kSendReport:
            return "Receive reply attribution_internals::mojom::Handler::SendReport";
      case messages::Handler::kClearStorage:
            return "Receive reply attribution_internals::mojom::Handler::ClearStorage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Handler::IsAttributionReportingEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2762a92;  // IPCStableHash for attribution_internals::mojom::Handler::IsAttributionReportingEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Handler::SendReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc83f5ad;  // IPCStableHash for attribution_internals::mojom::Handler::SendReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Handler::ClearStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc0d5ca4;  // IPCStableHash for attribution_internals::mojom::Handler::ClearStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Handler_IsAttributionReportingEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_IsAttributionReportingEnabled_ForwardToCallback(
      Handler::IsAttributionReportingEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_IsAttributionReportingEnabled_ForwardToCallback(const Handler_IsAttributionReportingEnabled_ForwardToCallback&) = delete;
  Handler_IsAttributionReportingEnabled_ForwardToCallback& operator=(const Handler_IsAttributionReportingEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::IsAttributionReportingEnabledCallback callback_;
};

class Handler_SendReport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_SendReport_ForwardToCallback(
      Handler::SendReportCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_SendReport_ForwardToCallback(const Handler_SendReport_ForwardToCallback&) = delete;
  Handler_SendReport_ForwardToCallback& operator=(const Handler_SendReport_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::SendReportCallback callback_;
};

class Handler_ClearStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Handler_ClearStorage_ForwardToCallback(
      Handler::ClearStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  Handler_ClearStorage_ForwardToCallback(const Handler_ClearStorage_ForwardToCallback&) = delete;
  Handler_ClearStorage_ForwardToCallback& operator=(const Handler_ClearStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Handler::ClearStorageCallback callback_;
};

HandlerProxy::HandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandlerProxy::IsAttributionReportingEnabled(
    IsAttributionReportingEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send attribution_internals::mojom::Handler::IsAttributionReportingEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kIsAttributionReportingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_IsAttributionReportingEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("IsAttributionReportingEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_IsAttributionReportingEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HandlerProxy::SendReport(
    ::content::AttributionReport::Id in_id, SendReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Handler::SendReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type ::content::AttributionReport::Id>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kSendReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_SendReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_internals::mojom::ReportIDDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in Handler.SendReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("SendReport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_SendReport_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HandlerProxy::ClearStorage(
    ClearStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send attribution_internals::mojom::Handler::ClearStorage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kClearStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_ClearStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("ClearStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Handler_ClearStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Handler_IsAttributionReportingEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::IsAttributionReportingEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_IsAttributionReportingEnabled_ProxyToResponder> proxy(
        new Handler_IsAttributionReportingEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_IsAttributionReportingEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_IsAttributionReportingEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_IsAttributionReportingEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::IsAttributionReportingEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled, ::network::mojom::AttributionSupport in_attribution_support);
};

bool Handler_IsAttributionReportingEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.0
  bool success = true;
  bool p_enabled{};
  ::network::mojom::AttributionSupport p_attribution_support{};
  Handler_IsAttributionReportingEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (success && !input_data_view.ReadAttributionSupport(&p_attribution_support))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled), 
std::move(p_attribution_support));
  }
  return true;
}

void Handler_IsAttributionReportingEnabled_ProxyToResponder::Run(
    bool in_enabled, ::network::mojom::AttributionSupport in_attribution_support) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply attribution_internals::mojom::Handler::IsAttributionReportingEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_support"), in_attribution_support,
                        "<value of type ::network::mojom::AttributionSupport>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kIsAttributionReportingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

  
  mojo::internal::Serialize<::network::mojom::AttributionSupport>(
    in_attribution_support,
    &params->attribution_support);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("IsAttributionReportingEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Handler_SendReport_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::SendReportCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_SendReport_ProxyToResponder> proxy(
        new Handler_SendReport_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_SendReport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_SendReport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_SendReport_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::SendReportCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Handler_SendReport_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_SendReport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_SendReport_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.1
  bool success = true;
  Handler_SendReport_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Handler_SendReport_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply attribution_internals::mojom::Handler::SendReport");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kSendReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_SendReport_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("SendReport");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Handler_ClearStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Handler::ClearStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Handler_ClearStorage_ProxyToResponder> proxy(
        new Handler_ClearStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Handler_ClearStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Handler_ClearStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Handler_ClearStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Handler::ClearStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Handler_ClearStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Handler_ClearStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Handler_ClearStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Handler.2
  bool success = true;
  Handler_ClearStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Handler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Handler_ClearStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply attribution_internals::mojom::Handler::ClearStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Handler::kClearStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Handler_ClearStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Handler::Name_);
  message.set_method_name("ClearStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandlerStubDispatch::Accept(
    Handler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Handler>(message->header()->name)) {
    case messages::Handler::kIsAttributionReportingEnabled: {
      break;
    }
    case messages::Handler::kSendReport: {
      break;
    }
    case messages::Handler::kClearStorage: {
      break;
    }
  }
  return false;
}

// static
bool HandlerStubDispatch::AcceptWithResponder(
    Handler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Handler>(message->header()->name)) {
    case messages::Handler::kIsAttributionReportingEnabled: {
      internal::Handler_IsAttributionReportingEnabled_Params_Data* params =
          reinterpret_cast<
              internal::Handler_IsAttributionReportingEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.0
      bool success = true;
      Handler_IsAttributionReportingEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 0, false);
        return false;
      }
      auto callback =
          Handler_IsAttributionReportingEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsAttributionReportingEnabled(std::move(callback));
      return true;
    }
    case messages::Handler::kSendReport: {
      internal::Handler_SendReport_Params_Data* params =
          reinterpret_cast<
              internal::Handler_SendReport_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.1
      bool success = true;
      ::content::AttributionReport::Id p_id{};
      Handler_SendReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 1, false);
        return false;
      }
      auto callback =
          Handler_SendReport_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendReport(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::Handler::kClearStorage: {
      internal::Handler_ClearStorage_Params_Data* params =
          reinterpret_cast<
              internal::Handler_ClearStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Handler.2
      bool success = true;
      Handler_ClearStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Handler::Name_, 2, false);
        return false;
      }
      auto callback =
          Handler_ClearStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearStorage(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHandlerValidationInfo[] = {
    { &internal::Handler_IsAttributionReportingEnabled_Params_Data::Validate,
     &internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data::Validate},
    { &internal::Handler_SendReport_Params_Data::Validate,
     &internal::Handler_SendReport_ResponseParams_Data::Validate},
    { &internal::Handler_ClearStorage_Params_Data::Validate,
     &internal::Handler_ClearStorage_ResponseParams_Data::Validate},
};

bool HandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::attribution_internals::mojom::Handler::Name_,
    kHandlerValidationInfo);
}

bool HandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::attribution_internals::mojom::Handler::Name_,
    kHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Factory::IPCStableHashFunction Factory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Factory>(message.name())) {
    case messages::Factory::kCreate: {
      return &Factory::Create_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Factory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Factory>(message.name())) {
      case messages::Factory::kCreate:
            return "Receive attribution_internals::mojom::Factory::Create";
    }
  } else {
    switch (static_cast<messages::Factory>(message.name())) {
      case messages::Factory::kCreate:
            return "Receive reply attribution_internals::mojom::Factory::Create";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Factory::Create_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1bfbc39;  // IPCStableHash for attribution_internals::mojom::Factory::Create
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FactoryProxy::FactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FactoryProxy::Create(
    ::mojo::PendingRemote<Observer> in_observer, ::mojo::PendingReceiver<Handler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_internals::mojom::Factory::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<Observer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<Handler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Factory::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_internals::mojom::internal::Factory_Create_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::attribution_internals::mojom::ObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Factory.Create request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::attribution_internals::mojom::HandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in Factory.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Factory::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FactoryStubDispatch::Accept(
    Factory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Factory>(message->header()->name)) {
    case messages::Factory::kCreate: {
      DCHECK(message->is_serialized());
      internal::Factory_Create_Params_Data* params =
          reinterpret_cast<internal::Factory_Create_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Factory.0
      bool success = true;
      ::mojo::PendingRemote<Observer> p_observer{};
      ::mojo::PendingReceiver<Handler> p_handler{};
      Factory_Create_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Factory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_observer), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool FactoryStubDispatch::AcceptWithResponder(
    Factory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Factory>(message->header()->name)) {
    case messages::Factory::kCreate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFactoryValidationInfo[] = {
    { &internal::Factory_Create_Params_Data::Validate,
     nullptr /* no response */},
};

bool FactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::attribution_internals::mojom::Factory::Name_,
    kFactoryValidationInfo);
}



}  // attribution_internals::mojom


namespace mojo {


// static
bool StructTraits<::attribution_internals::mojom::ReportID::DataView, ::attribution_internals::mojom::ReportIDPtr>::Read(
    ::attribution_internals::mojom::ReportID::DataView input,
    ::attribution_internals::mojom::ReportIDPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::ReportIDPtr result(::attribution_internals::mojom::ReportID::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIReportEventLevelData::DataView, ::attribution_internals::mojom::WebUIReportEventLevelDataPtr>::Read(
    ::attribution_internals::mojom::WebUIReportEventLevelData::DataView input,
    ::attribution_internals::mojom::WebUIReportEventLevelDataPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIReportEventLevelDataPtr result(::attribution_internals::mojom::WebUIReportEventLevelData::New());
  
      if (success)
        result->priority = input.priority();
      if (success)
        result->attributed_truthfully = input.attributed_truthfully();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::AggregatableHistogramContribution::DataView, ::attribution_internals::mojom::AggregatableHistogramContributionPtr>::Read(
    ::attribution_internals::mojom::AggregatableHistogramContribution::DataView input,
    ::attribution_internals::mojom::AggregatableHistogramContributionPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::AggregatableHistogramContributionPtr result(::attribution_internals::mojom::AggregatableHistogramContribution::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success)
        result->value = input.value();
      if (success)
        result->filtering_id = input.filtering_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIReportAggregatableAttributionData::DataView, ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr>::Read(
    ::attribution_internals::mojom::WebUIReportAggregatableAttributionData::DataView input,
    ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr result(::attribution_internals::mojom::WebUIReportAggregatableAttributionData::New());
  
      if (success && !input.ReadContributions(&result->contributions))
        success = false;
      if (success && !input.ReadAggregationCoordinator(&result->aggregation_coordinator))
        success = false;
      if (success)
        result->is_null_report = input.is_null_report();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::Empty::DataView, ::attribution_internals::mojom::EmptyPtr>::Read(
    ::attribution_internals::mojom::Empty::DataView input,
    ::attribution_internals::mojom::EmptyPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::EmptyPtr result(::attribution_internals::mojom::Empty::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIReport::DataView, ::attribution_internals::mojom::WebUIReportPtr>::Read(
    ::attribution_internals::mojom::WebUIReport::DataView input,
    ::attribution_internals::mojom::WebUIReportPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIReportPtr result(::attribution_internals::mojom::WebUIReport::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadReportUrl(&result->report_url))
        success = false;
      if (success)
        result->trigger_time = input.trigger_time();
      if (success)
        result->report_time = input.report_time();
      if (success && !input.ReadReportBody(&result->report_body))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIDebugReport::DataView, ::attribution_internals::mojom::WebUIDebugReportPtr>::Read(
    ::attribution_internals::mojom::WebUIDebugReport::DataView input,
    ::attribution_internals::mojom::WebUIDebugReportPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIDebugReportPtr result(::attribution_internals::mojom::WebUIDebugReport::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->time = input.time();
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIAggregatableDebugReport::DataView, ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr>::Read(
    ::attribution_internals::mojom::WebUIAggregatableDebugReport::DataView input,
    ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIAggregatableDebugReportPtr result(::attribution_internals::mojom::WebUIAggregatableDebugReport::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->time = input.time();
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadProcessResult(&result->process_result))
        success = false;
      if (success && !input.ReadSendResult(&result->send_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUISource::DataView, ::attribution_internals::mojom::WebUISourcePtr>::Read(
    ::attribution_internals::mojom::WebUISource::DataView input,
    ::attribution_internals::mojom::WebUISourcePtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUISourcePtr result(::attribution_internals::mojom::WebUISource::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->source_event_id = input.source_event_id();
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
      if (success && !input.ReadDestinations(&result->destinations))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->source_time = input.source_time();
      if (success)
        result->expiry_time = input.expiry_time();
      if (success && !input.ReadEventReportWindows(&result->event_report_windows))
        success = false;
      if (success && !input.ReadTriggerData(&result->trigger_data))
        success = false;
      if (success)
        result->max_event_level_reports = input.max_event_level_reports();
      if (success)
        result->aggregatable_report_window_time = input.aggregatable_report_window_time();
      if (success && !input.ReadSourceType(&result->source_type))
        success = false;
      if (success)
        result->priority = input.priority();
      if (success) {
        result->debug_key = input.debug_key();
      }
      if (success && !input.ReadDedupKeys(&result->dedup_keys))
        success = false;
      if (success && !input.ReadFilterData(&result->filter_data))
        success = false;
      if (success && !input.ReadAggregationKeys(&result->aggregation_keys))
        success = false;
      if (success)
        result->remaining_aggregatable_attribution_budget = input.remaining_aggregatable_attribution_budget();
      if (success && !input.ReadAggregatableDedupKeys(&result->aggregatable_dedup_keys))
        success = false;
      if (success && !input.ReadTriggerDataMatching(&result->trigger_data_matching))
        success = false;
      if (success)
        result->event_level_epsilon = input.event_level_epsilon();
      if (success)
        result->cookie_based_debug_allowed = input.cookie_based_debug_allowed();
      if (success)
        result->remaining_aggregatable_debug_budget = input.remaining_aggregatable_debug_budget();
      if (success && !input.ReadAggregatableDebugKeyPiece(&result->aggregatable_debug_key_piece))
        success = false;
      if (success && !input.ReadAttributionScopesDataJson(&result->attribution_scopes_data_json))
        success = false;
      if (success && !input.ReadAggregatableNamedBudgets(&result->aggregatable_named_budgets))
        success = false;
      if (success && !input.ReadAttributability(&result->attributability))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIRegistration::DataView, ::attribution_internals::mojom::WebUIRegistrationPtr>::Read(
    ::attribution_internals::mojom::WebUIRegistration::DataView input,
    ::attribution_internals::mojom::WebUIRegistrationPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIRegistrationPtr result(::attribution_internals::mojom::WebUIRegistration::New());
  
      if (success)
        result->time = input.time();
      if (success && !input.ReadContextOrigin(&result->context_origin))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success && !input.ReadRegistrationJson(&result->registration_json))
        success = false;
      if (success) {
        result->cleared_debug_key = input.cleared_debug_key();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUITrigger::DataView, ::attribution_internals::mojom::WebUITriggerPtr>::Read(
    ::attribution_internals::mojom::WebUITrigger::DataView input,
    ::attribution_internals::mojom::WebUITriggerPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUITriggerPtr result(::attribution_internals::mojom::WebUITrigger::New());
  
      if (success && !input.ReadRegistration(&result->registration))
        success = false;
      if (success && !input.ReadEventLevelResult(&result->event_level_result))
        success = false;
      if (success && !input.ReadAggregatableResult(&result->aggregatable_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUISourceRegistration::DataView, ::attribution_internals::mojom::WebUISourceRegistrationPtr>::Read(
    ::attribution_internals::mojom::WebUISourceRegistration::DataView input,
    ::attribution_internals::mojom::WebUISourceRegistrationPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUISourceRegistrationPtr result(::attribution_internals::mojom::WebUISourceRegistration::New());
  
      if (success && !input.ReadRegistration(&result->registration))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_internals::mojom::WebUIOsRegistration::DataView, ::attribution_internals::mojom::WebUIOsRegistrationPtr>::Read(
    ::attribution_internals::mojom::WebUIOsRegistration::DataView input,
    ::attribution_internals::mojom::WebUIOsRegistrationPtr* output) {
  bool success = true;
  ::attribution_internals::mojom::WebUIOsRegistrationPtr result(::attribution_internals::mojom::WebUIOsRegistration::New());
  
      if (success)
        result->time = input.time();
      if (success && !input.ReadRegistrationUrl(&result->registration_url))
        success = false;
      if (success && !input.ReadTopLevelOrigin(&result->top_level_origin))
        success = false;
      if (success)
        result->is_debug_key_allowed = input.is_debug_key_allowed();
      if (success)
        result->debug_reporting = input.debug_reporting();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::attribution_internals::mojom::WebUIReportData::DataView, ::attribution_internals::mojom::WebUIReportDataPtr>::Read(
    ::attribution_internals::mojom::WebUIReportData::DataView input,
    ::attribution_internals::mojom::WebUIReportDataPtr* output) {
  using UnionType = ::attribution_internals::mojom::WebUIReportData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kEventLevelData: {
      ::attribution_internals::mojom::WebUIReportEventLevelDataPtr result_event_level_data{};
      if (!input.ReadEventLevelData(&result_event_level_data))
        return false;

      *output = UnionType::NewEventLevelData(
          std::move(result_event_level_data));
      break;
    }
    case Tag::kAggregatableAttributionData: {
      ::attribution_internals::mojom::WebUIReportAggregatableAttributionDataPtr result_aggregatable_attribution_data{};
      if (!input.ReadAggregatableAttributionData(&result_aggregatable_attribution_data))
        return false;

      *output = UnionType::NewAggregatableAttributionData(
          std::move(result_aggregatable_attribution_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::attribution_internals::mojom::NetworkStatus::DataView, ::attribution_internals::mojom::NetworkStatusPtr>::Read(
    ::attribution_internals::mojom::NetworkStatus::DataView input,
    ::attribution_internals::mojom::NetworkStatusPtr* output) {
  using UnionType = ::attribution_internals::mojom::NetworkStatus;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kHttpResponseCode: {
      *output = UnionType::NewHttpResponseCode(input.http_response_code());
      break;
    }
    case Tag::kNetworkError: {
      std::string result_network_error{};
      if (!input.ReadNetworkError(&result_network_error))
        return false;

      *output = UnionType::NewNetworkError(
          std::move(result_network_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::attribution_internals::mojom::ReportStatus::DataView, ::attribution_internals::mojom::ReportStatusPtr>::Read(
    ::attribution_internals::mojom::ReportStatus::DataView input,
    ::attribution_internals::mojom::ReportStatusPtr* output) {
  using UnionType = ::attribution_internals::mojom::ReportStatus;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPending: {
      ::attribution_internals::mojom::EmptyPtr result_pending{};
      if (!input.ReadPending(&result_pending))
        return false;

      *output = UnionType::NewPending(
          std::move(result_pending));
      break;
    }
    case Tag::kReplacedByHigherPriorityReport: {
      std::string result_replaced_by_higher_priority_report{};
      if (!input.ReadReplacedByHigherPriorityReport(&result_replaced_by_higher_priority_report))
        return false;

      *output = UnionType::NewReplacedByHigherPriorityReport(
          std::move(result_replaced_by_higher_priority_report));
      break;
    }
    case Tag::kProhibitedByBrowserPolicy: {
      ::attribution_internals::mojom::EmptyPtr result_prohibited_by_browser_policy{};
      if (!input.ReadProhibitedByBrowserPolicy(&result_prohibited_by_browser_policy))
        return false;

      *output = UnionType::NewProhibitedByBrowserPolicy(
          std::move(result_prohibited_by_browser_policy));
      break;
    }
    case Tag::kExpired: {
      ::attribution_internals::mojom::EmptyPtr result_expired{};
      if (!input.ReadExpired(&result_expired))
        return false;

      *output = UnionType::NewExpired(
          std::move(result_expired));
      break;
    }
    case Tag::kNetworkStatus: {
      ::attribution_internals::mojom::NetworkStatusPtr result_network_status{};
      if (!input.ReadNetworkStatus(&result_network_status))
        return false;

      *output = UnionType::NewNetworkStatus(
          std::move(result_network_status));
      break;
    }
    case Tag::kFailedToAssemble: {
      ::attribution_internals::mojom::EmptyPtr result_failed_to_assemble{};
      if (!input.ReadFailedToAssemble(&result_failed_to_assemble))
        return false;

      *output = UnionType::NewFailedToAssemble(
          std::move(result_failed_to_assemble));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::attribution_internals::mojom::SendAggregatableDebugReportResult::DataView, ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr>::Read(
    ::attribution_internals::mojom::SendAggregatableDebugReportResult::DataView input,
    ::attribution_internals::mojom::SendAggregatableDebugReportResultPtr* output) {
  using UnionType = ::attribution_internals::mojom::SendAggregatableDebugReportResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kAssemblyFailed: {
      ::attribution_internals::mojom::EmptyPtr result_assembly_failed{};
      if (!input.ReadAssemblyFailed(&result_assembly_failed))
        return false;

      *output = UnionType::NewAssemblyFailed(
          std::move(result_assembly_failed));
      break;
    }
    case Tag::kNetworkStatus: {
      ::attribution_internals::mojom::NetworkStatusPtr result_network_status{};
      if (!input.ReadNetworkStatus(&result_network_status))
        return false;

      *output = UnionType::NewNetworkStatus(
          std::move(result_network_status));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace attribution_internals::mojom {


void ObserverInterceptorForTesting::OnSourcesChanged(std::vector<WebUISourcePtr> sources) {
  GetForwardingInterface()->OnSourcesChanged(
    std::move(sources)
    );
}
void ObserverInterceptorForTesting::OnReportsChanged(std::vector<WebUIReportPtr> reports) {
  GetForwardingInterface()->OnReportsChanged(
    std::move(reports)
    );
}
void ObserverInterceptorForTesting::OnSourceHandled(WebUISourceRegistrationPtr source) {
  GetForwardingInterface()->OnSourceHandled(
    std::move(source)
    );
}
void ObserverInterceptorForTesting::OnReportHandled(WebUIReportPtr report) {
  GetForwardingInterface()->OnReportHandled(
    std::move(report)
    );
}
void ObserverInterceptorForTesting::OnDebugReportSent(WebUIDebugReportPtr report) {
  GetForwardingInterface()->OnDebugReportSent(
    std::move(report)
    );
}
void ObserverInterceptorForTesting::OnAggregatableDebugReportSent(WebUIAggregatableDebugReportPtr report) {
  GetForwardingInterface()->OnAggregatableDebugReportSent(
    std::move(report)
    );
}
void ObserverInterceptorForTesting::OnTriggerHandled(WebUITriggerPtr trigger) {
  GetForwardingInterface()->OnTriggerHandled(
    std::move(trigger)
    );
}
void ObserverInterceptorForTesting::OnOsRegistration(WebUIOsRegistrationPtr registration) {
  GetForwardingInterface()->OnOsRegistration(
    std::move(registration)
    );
}
void ObserverInterceptorForTesting::OnDebugModeChanged(bool debug_mode) {
  GetForwardingInterface()->OnDebugModeChanged(
    std::move(debug_mode)
    );
}
ObserverAsyncWaiter::ObserverAsyncWaiter(
    Observer* proxy) : proxy_(proxy) {}

ObserverAsyncWaiter::~ObserverAsyncWaiter() = default;





void HandlerInterceptorForTesting::IsAttributionReportingEnabled(IsAttributionReportingEnabledCallback callback) {
  GetForwardingInterface()->IsAttributionReportingEnabled(std::move(callback));
}
void HandlerInterceptorForTesting::SendReport(::content::AttributionReport::Id id, SendReportCallback callback) {
  GetForwardingInterface()->SendReport(
    std::move(id)
    , std::move(callback));
}
void HandlerInterceptorForTesting::ClearStorage(ClearStorageCallback callback) {
  GetForwardingInterface()->ClearStorage(std::move(callback));
}
HandlerAsyncWaiter::HandlerAsyncWaiter(
    Handler* proxy) : proxy_(proxy) {}

HandlerAsyncWaiter::~HandlerAsyncWaiter() = default;


void HandlerAsyncWaiter::IsAttributionReportingEnabled(
    bool* out_enabled, ::network::mojom::AttributionSupport* out_attribution_support) {
  base::RunLoop loop;
  proxy_->IsAttributionReportingEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             ::network::mojom::AttributionSupport* out_attribution_support
,
             bool enabled,
             ::network::mojom::AttributionSupport attribution_support) {*out_enabled = std::move(enabled);*out_attribution_support = std::move(attribution_support);
            loop->Quit();
          },
          &loop,
          out_enabled,
          out_attribution_support));
  loop.Run();
}



void HandlerAsyncWaiter::SendReport(
    ::content::AttributionReport::Id id) {
  base::RunLoop loop;
  proxy_->SendReport(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void HandlerAsyncWaiter::ClearStorage(
    ) {
  base::RunLoop loop;
  proxy_->ClearStorage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void FactoryInterceptorForTesting::Create(::mojo::PendingRemote<Observer> observer, ::mojo::PendingReceiver<Handler> handler) {
  GetForwardingInterface()->Create(
    std::move(observer)
    , 
    std::move(handler)
    );
}
FactoryAsyncWaiter::FactoryAsyncWaiter(
    Factory* proxy) : proxy_(proxy) {}

FactoryAsyncWaiter::~FactoryAsyncWaiter() = default;







}  // attribution_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif