// components/webapps/common/web_page_metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/webapps/common/web_page_metadata.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/webapps/common/web_page_metadata.mojom-params-data.h"
namespace webapps {
namespace mojom {

NOINLINE static const char* WebPageMobileCapableToStringHelper(WebPageMobileCapable value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPageMobileCapable::UNSPECIFIED:
      return "UNSPECIFIED";
    case WebPageMobileCapable::ENABLED:
      return "ENABLED";
    case WebPageMobileCapable::ENABLED_APPLE:
      return "ENABLED_APPLE";
    default:
      return nullptr;
  }
}

std::string WebPageMobileCapableToString(WebPageMobileCapable value) {
  const char *str = WebPageMobileCapableToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPageMobileCapable value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPageMobileCapable value) {
  return os << WebPageMobileCapableToString(value);
}

namespace internal {


// static
bool WebPageIconInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPageIconInfo_Data* object =
      static_cast<const WebPageIconInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebPageIconInfo_Data::WebPageIconInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPageMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPageMetadata_Data* object =
      static_cast<const WebPageMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->application_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->application_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->application_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->application_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }


  if (!::webapps::mojom::internal::WebPageMobileCapable_Data
        ::Validate(object->mobile_capable, validation_context))
    return false;

  return true;
}

WebPageMetadata_Data::WebPageMetadata_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webapps

namespace perfetto {

// static
void TraceFormatTraits<::webapps::mojom::WebPageMobileCapable>::WriteIntoTrace(
   perfetto::TracedValue context, ::webapps::mojom::WebPageMobileCapable value) {
  return std::move(context).WriteString(::webapps::mojom::WebPageMobileCapableToString(value));
}

} // namespace perfetto