// components/web_package/mojom/web_bundle_parser.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace web_package::mojom {
namespace internal {
class BundleIntegrityBlockParseError_Data;
class BundleMetadataParseError_Data;
class BundleResponseParseError_Data;
class BundleIntegrityBlockAttributes_Data;
class BundleIntegrityBlock_Data;
class Ed25519PublicKey_Data;
class Ed25519Signature_Data;
class SignatureInfoEd25519_Data;
class EcdsaP256PublicKey_Data;
class EcdsaP256SHA256Signature_Data;
class SignatureInfoEcdsaP256SHA256_Data;
class SignatureInfoUnknown_Data;
class BundleIntegrityBlockSignatureStackEntry_Data;
class BundleMetadata_Data;
class BundleResponseLocation_Data;
class BundleResponse_Data;
class SignatureInfo_Data;

struct BundleParseErrorType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct BundleFormatVersion_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  SignatureInfo_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  SignatureInfo_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~SignatureInfo_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<SignatureInfo_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class SignatureInfo_Tag : uint32_t {

    
    kUnknown,
    
    kEd25519,
    
    kEcdsaP256Sha256,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::SignatureInfoUnknown_Data> f_unknown;
    mojo::internal::Pointer<internal::SignatureInfoEd25519_Data> f_ed25519;
    mojo::internal::Pointer<internal::SignatureInfoEcdsaP256SHA256_Data> f_ecdsa_p256_sha256;
    uint64_t unknown;
  };

  uint32_t size;
  SignatureInfo_Tag tag;
  Union_ data;
};
static_assert(sizeof(SignatureInfo_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(SignatureInfo_Data)");
class  BundleIntegrityBlockParseError_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<BundleIntegrityBlockParseError_Data>;

  BundleIntegrityBlockParseError_Data();
  ~BundleIntegrityBlockParseError_Data() = delete;
};
static_assert(sizeof(BundleIntegrityBlockParseError_Data) == 24,
              "Bad sizeof(BundleIntegrityBlockParseError_Data)");
// Used by BundleIntegrityBlockParseError::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleIntegrityBlockParseError_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleIntegrityBlockParseError_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleIntegrityBlockParseError_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleIntegrityBlockParseError_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleIntegrityBlockParseError_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleMetadataParseError_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<BundleMetadataParseError_Data>;

  BundleMetadataParseError_Data();
  ~BundleMetadataParseError_Data() = delete;
};
static_assert(sizeof(BundleMetadataParseError_Data) == 24,
              "Bad sizeof(BundleMetadataParseError_Data)");
// Used by BundleMetadataParseError::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleMetadataParseError_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleMetadataParseError_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleMetadataParseError_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleMetadataParseError_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleMetadataParseError_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleResponseParseError_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<BundleResponseParseError_Data>;

  BundleResponseParseError_Data();
  ~BundleResponseParseError_Data() = delete;
};
static_assert(sizeof(BundleResponseParseError_Data) == 24,
              "Bad sizeof(BundleResponseParseError_Data)");
// Used by BundleResponseParseError::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleResponseParseError_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleResponseParseError_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleResponseParseError_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleResponseParseError_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleResponseParseError_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleIntegrityBlockAttributes_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> web_bundle_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> cbor;

 private:
  friend class mojo::internal::MessageFragment<BundleIntegrityBlockAttributes_Data>;

  BundleIntegrityBlockAttributes_Data();
  ~BundleIntegrityBlockAttributes_Data() = delete;
};
static_assert(sizeof(BundleIntegrityBlockAttributes_Data) == 24,
              "Bad sizeof(BundleIntegrityBlockAttributes_Data)");
// Used by BundleIntegrityBlockAttributes::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleIntegrityBlockAttributes_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleIntegrityBlockAttributes_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleIntegrityBlockAttributes_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleIntegrityBlockAttributes_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleIntegrityBlockAttributes_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleIntegrityBlock_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t size;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::BundleIntegrityBlockSignatureStackEntry_Data>>> signature_stack;
  mojo::internal::Pointer<internal::BundleIntegrityBlockAttributes_Data> attributes;

 private:
  friend class mojo::internal::MessageFragment<BundleIntegrityBlock_Data>;

  BundleIntegrityBlock_Data();
  ~BundleIntegrityBlock_Data() = delete;
};
static_assert(sizeof(BundleIntegrityBlock_Data) == 32,
              "Bad sizeof(BundleIntegrityBlock_Data)");
// Used by BundleIntegrityBlock::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleIntegrityBlock_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleIntegrityBlock_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleIntegrityBlock_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleIntegrityBlock_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleIntegrityBlock_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Ed25519PublicKey_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<Ed25519PublicKey_Data>;

  Ed25519PublicKey_Data();
  ~Ed25519PublicKey_Data() = delete;
};
static_assert(sizeof(Ed25519PublicKey_Data) == 16,
              "Bad sizeof(Ed25519PublicKey_Data)");
// Used by Ed25519PublicKey::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Ed25519PublicKey_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Ed25519PublicKey_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Ed25519PublicKey_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Ed25519PublicKey_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Ed25519PublicKey_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Ed25519Signature_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<Ed25519Signature_Data>;

  Ed25519Signature_Data();
  ~Ed25519Signature_Data() = delete;
};
static_assert(sizeof(Ed25519Signature_Data) == 16,
              "Bad sizeof(Ed25519Signature_Data)");
// Used by Ed25519Signature::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Ed25519Signature_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Ed25519Signature_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Ed25519Signature_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Ed25519Signature_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Ed25519Signature_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SignatureInfoEd25519_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Ed25519PublicKey_Data> public_key;
  mojo::internal::Pointer<internal::Ed25519Signature_Data> signature;

 private:
  friend class mojo::internal::MessageFragment<SignatureInfoEd25519_Data>;

  SignatureInfoEd25519_Data();
  ~SignatureInfoEd25519_Data() = delete;
};
static_assert(sizeof(SignatureInfoEd25519_Data) == 24,
              "Bad sizeof(SignatureInfoEd25519_Data)");
// Used by SignatureInfoEd25519::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SignatureInfoEd25519_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SignatureInfoEd25519_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SignatureInfoEd25519_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SignatureInfoEd25519_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SignatureInfoEd25519_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EcdsaP256PublicKey_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<EcdsaP256PublicKey_Data>;

  EcdsaP256PublicKey_Data();
  ~EcdsaP256PublicKey_Data() = delete;
};
static_assert(sizeof(EcdsaP256PublicKey_Data) == 16,
              "Bad sizeof(EcdsaP256PublicKey_Data)");
// Used by EcdsaP256PublicKey::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EcdsaP256PublicKey_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EcdsaP256PublicKey_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EcdsaP256PublicKey_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EcdsaP256PublicKey_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EcdsaP256PublicKey_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EcdsaP256SHA256Signature_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<EcdsaP256SHA256Signature_Data>;

  EcdsaP256SHA256Signature_Data();
  ~EcdsaP256SHA256Signature_Data() = delete;
};
static_assert(sizeof(EcdsaP256SHA256Signature_Data) == 16,
              "Bad sizeof(EcdsaP256SHA256Signature_Data)");
// Used by EcdsaP256SHA256Signature::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EcdsaP256SHA256Signature_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EcdsaP256SHA256Signature_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EcdsaP256SHA256Signature_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EcdsaP256SHA256Signature_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EcdsaP256SHA256Signature_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SignatureInfoEcdsaP256SHA256_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::EcdsaP256PublicKey_Data> public_key;
  mojo::internal::Pointer<internal::EcdsaP256SHA256Signature_Data> signature;

 private:
  friend class mojo::internal::MessageFragment<SignatureInfoEcdsaP256SHA256_Data>;

  SignatureInfoEcdsaP256SHA256_Data();
  ~SignatureInfoEcdsaP256SHA256_Data() = delete;
};
static_assert(sizeof(SignatureInfoEcdsaP256SHA256_Data) == 24,
              "Bad sizeof(SignatureInfoEcdsaP256SHA256_Data)");
// Used by SignatureInfoEcdsaP256SHA256::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SignatureInfoEcdsaP256SHA256_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SignatureInfoEcdsaP256SHA256_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SignatureInfoEcdsaP256SHA256_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SignatureInfoEcdsaP256SHA256_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SignatureInfoEcdsaP256SHA256_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SignatureInfoUnknown_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<SignatureInfoUnknown_Data>;

  SignatureInfoUnknown_Data();
  ~SignatureInfoUnknown_Data() = delete;
};
static_assert(sizeof(SignatureInfoUnknown_Data) == 8,
              "Bad sizeof(SignatureInfoUnknown_Data)");
// Used by SignatureInfoUnknown::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SignatureInfoUnknown_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SignatureInfoUnknown_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SignatureInfoUnknown_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SignatureInfoUnknown_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SignatureInfoUnknown_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleIntegrityBlockSignatureStackEntry_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> attributes_cbor;
  internal::SignatureInfo_Data signature_info;

 private:
  friend class mojo::internal::MessageFragment<BundleIntegrityBlockSignatureStackEntry_Data>;

  BundleIntegrityBlockSignatureStackEntry_Data();
  ~BundleIntegrityBlockSignatureStackEntry_Data() = delete;
};
static_assert(sizeof(BundleIntegrityBlockSignatureStackEntry_Data) == 32,
              "Bad sizeof(BundleIntegrityBlockSignatureStackEntry_Data)");
// Used by BundleIntegrityBlockSignatureStackEntry::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleIntegrityBlockSignatureStackEntry_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleIntegrityBlockSignatureStackEntry_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t version;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> primary_url;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>, mojo::internal::Pointer<internal::BundleResponseLocation_Data>>> requests;

 private:
  friend class mojo::internal::MessageFragment<BundleMetadata_Data>;

  BundleMetadata_Data();
  ~BundleMetadata_Data() = delete;
};
static_assert(sizeof(BundleMetadata_Data) == 32,
              "Bad sizeof(BundleMetadata_Data)");
// Used by BundleMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleResponseLocation_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t offset;
  uint64_t length;

 private:
  friend class mojo::internal::MessageFragment<BundleResponseLocation_Data>;

  BundleResponseLocation_Data();
  ~BundleResponseLocation_Data() = delete;
};
static_assert(sizeof(BundleResponseLocation_Data) == 24,
              "Bad sizeof(BundleResponseLocation_Data)");
// Used by BundleResponseLocation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleResponseLocation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleResponseLocation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleResponseLocation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleResponseLocation_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleResponseLocation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BundleResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t response_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::String_Data>>> response_headers;
  uint64_t payload_offset;
  uint64_t payload_length;

 private:
  friend class mojo::internal::MessageFragment<BundleResponse_Data>;

  BundleResponse_Data();
  ~BundleResponse_Data() = delete;
};
static_assert(sizeof(BundleResponse_Data) == 40,
              "Bad sizeof(BundleResponse_Data)");
// Used by BundleResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BundleResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BundleResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BundleResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BundleResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BundleResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // web_package::mojom

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SHARED_INTERNAL_H_