// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "components/vector_icons/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace vector_icons {

VECTOR_ICON_REP_TEMPLATE(kProductPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 7.5,
R_H_LINE_TO, 8.9,
CUBIC_TO, 19.3, 4.2, 15.9, 2, 12, 2,
CUBIC_TO, 8.9, 2, 6.1, 3.4, 4.3, 5.6,
R_LINE_TO, 3.3, 5.7,
R_CUBIC_TO, 0.3, -2.1, 2.2, -3.8, 4.4, -3.8,
CLOSE,
R_MOVE_TO, 0, 9,
R_CUBIC_TO, -1.7, 0, -3.1, -0.9, -3.9, -2.3,
LINE_TO, 3.6, 6.5,
CUBIC_TO, 2.6, 8.1, 2, 10, 2, 12,
R_CUBIC_TO, 0, 5, 3.6, 9.1, 8.4, 9.9,
R_LINE_TO, 3.3, -5.7,
R_CUBIC_TO, -0.6, 0.2, -1.1, 0.3, -1.7, 0.3,
CLOSE,
R_MOVE_TO, 4.5, -4.5,
R_CUBIC_TO, 0, 0.8, -0.2, 1.6, -0.6, 2.2,
LINE_TO, 11.4, 22,
R_H_LINE_TO, 0.6,
R_CUBIC_TO, 5.5, 0, 10, -4.5, 10, -10,
R_CUBIC_TO, 0, -1.2, -0.2, -2.4, -0.6, -3.5,
R_H_LINE_TO, -6.6,
R_CUBIC_TO, 1, 0.8, 1.7, 2.1, 1.7, 3.5,
CLOSE,
CIRCLE, 12, 12, 3.5)
VECTOR_ICON_TEMPLATE_CC(kProductRepList, kProductIcon, {kProductPath})
VECTOR_ICON_REP_TEMPLATE(kProductRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 12, 17.99,
CUBIC_TO, 15.31, 17.99, 18, 15.31, 18, 11.99,
CUBIC_TO, 18, 8.68, 15.31, 5.99, 12, 5.99,
CUBIC_TO, 8.69, 5.99, 6, 8.68, 6, 11.99,
CUBIC_TO, 6, 15.31, 8.69, 17.99, 12, 17.99,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0xAE, 0xCB, 0xFA,
MOVE_TO, 17.2, 15,
LINE_TO, 12.01, 23.99,
CUBIC_TO, 14.11, 23.99, 16.18, 23.44, 18, 22.39,
CUBIC_TO, 19.83, 21.33, 21.34, 19.82, 22.4, 18,
CUBIC_TO, 23.45, 16.17, 24, 14.1, 24, 12,
CUBIC_TO, 24, 9.89, 23.44, 7.82, 22.38, 6,
LINE_TO, 12, 6,
LINE_TO, 11.99, 6.01,
CUBIC_TO, 13.05, 6, 14.08, 6.28, 15, 6.8,
CUBIC_TO, 15.91, 7.33, 16.67, 8.08, 17.2, 9,
CUBIC_TO, 17.73, 9.91, 18, 10.94, 18, 12,
CUBIC_TO, 18, 13.05, 17.72, 14.09, 17.2, 15,
V_LINE_TO, 15,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0x66, 0x9D, 0xF6,
MOVE_TO, 6.8, 15,
LINE_TO, 1.61, 6.01,
CUBIC_TO, 0.56, 7.83, 0, 9.9, 0, 12.01,
CUBIC_TO, 0, 14.11, 0.56, 16.18, 1.61, 18.01,
CUBIC_TO, 2.66, 19.83, 4.18, 21.34, 6.01, 22.39,
CUBIC_TO, 7.83, 23.44, 9.9, 23.99, 12.01, 23.99,
LINE_TO, 17.2, 15,
V_LINE_TO, 14.99,
CUBIC_TO, 16.67, 15.9, 15.92, 16.66, 15, 17.19,
CUBIC_TO, 14.09, 17.72, 13.06, 18, 12, 18,
CUBIC_TO, 10.95, 18, 9.91, 17.73, 9, 17.2,
CUBIC_TO, 8.09, 16.67, 7.33, 15.91, 6.8, 15,
V_LINE_TO, 15,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0x1A, 0x73, 0xE8,
MOVE_TO, 12, 16.75,
CUBIC_TO, 14.62, 16.75, 16.75, 14.62, 16.75, 12,
CUBIC_TO, 16.75, 9.38, 14.62, 7.25, 12, 7.25,
CUBIC_TO, 9.38, 7.25, 7.25, 9.38, 7.25, 12,
CUBIC_TO, 7.25, 14.62, 9.38, 16.75, 12, 16.75,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0x19, 0x67, 0xD2,
MOVE_TO, 12, 6,
H_LINE_TO, 22.38,
CUBIC_TO, 21.33, 4.18, 19.82, 2.66, 17.99, 1.61,
CUBIC_TO, 16.17, 0.55, 14.1, 0, 11.99, 0,
CUBIC_TO, 9.89, 0, 7.82, 0.56, 6, 1.61,
CUBIC_TO, 4.17, 2.67, 2.66, 4.18, 1.61, 6.01,
LINE_TO, 6.8, 15,
LINE_TO, 6.81, 15,
CUBIC_TO, 6.28, 14.09, 6, 13.06, 6, 12,
CUBIC_TO, 6, 10.95, 6.27, 9.91, 6.8, 9,
CUBIC_TO, 7.33, 8.09, 8.08, 7.33, 9, 6.8,
CUBIC_TO, 9.91, 6.28, 10.95, 6, 12, 6,
V_LINE_TO, 6,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kProductRefreshRepList, kProductRefreshIcon, {kProductRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAccountCirclePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 5.85, 17.1,
R_QUADRATIC_TO, 1.27, -0.97, 2.85, -1.54,
QUADRATIC_TO, 10.28, 15, 12, 15,
R_QUADRATIC_TO, 1.73, 0, 3.3, 0.56,
R_QUADRATIC_TO, 1.58, 0.56, 2.85, 1.54,
R_QUADRATIC_TO, 0.88, -1.02, 1.36, -2.33,
QUADRATIC_TO, 20, 13.48, 20, 12,
R_QUADRATIC_TO, 0, -3.32, -2.34, -5.66,
QUADRATIC_TO, 15.33, 4, 12, 4,
QUADRATIC_TO_SHORTHAND, 6.34, 6.34,
QUADRATIC_TO, 4, 8.68, 4, 12,
R_QUADRATIC_TO, 0, 1.48, 0.49, 2.78,
R_QUADRATIC_TO, 0.49, 1.3, 1.36, 2.33,
CLOSE,
MOVE_TO, 12, 13,
R_QUADRATIC_TO, -1.47, 0, -2.49, -1.01,
QUADRATIC_TO, 8.5, 10.98, 8.5, 9.5,
R_QUADRATIC_TO, 0, -1.48, 1.01, -2.49,
QUADRATIC_TO, 10.53, 6, 12, 6,
R_QUADRATIC_TO, 1.47, 0, 2.49, 1.01,
QUADRATIC_TO, 15.5, 8.03, 15.5, 9.5,
R_QUADRATIC_TO, 0, 1.47, -1.01, 2.49,
QUADRATIC_TO, 13.48, 13, 12, 13,
CLOSE,
R_MOVE_TO, 0, 9,
R_QUADRATIC_TO, -2.08, 0, -3.9, -0.79,
R_QUADRATIC_TO, -1.82, -0.79, -3.17, -2.14,
R_QUADRATIC_TO, -1.35, -1.35, -2.14, -3.17,
QUADRATIC_TO, 2, 14.08, 2, 12,
R_QUADRATIC_TO, 0, -2.08, 0.79, -3.9,
R_QUADRATIC_TO, 0.79, -1.82, 2.14, -3.17,
R_QUADRATIC_TO, 1.35, -1.35, 3.18, -2.14,
QUADRATIC_TO, 9.93, 2, 12, 2,
R_QUADRATIC_TO, 2.07, 0, 3.9, 0.79,
R_QUADRATIC_TO, 1.83, 0.79, 3.18, 2.14,
R_QUADRATIC_TO, 1.35, 1.35, 2.14, 3.18,
QUADRATIC_TO, 22, 9.93, 22, 12,
R_QUADRATIC_TO, 0, 2.07, -0.79, 3.9,
R_QUADRATIC_TO, -0.79, 1.83, -2.14, 3.18,
R_QUADRATIC_TO, -1.35, 1.35, -3.17, 2.14,
QUADRATIC_TO, 14.08, 22, 12, 22,
CLOSE,
R_MOVE_TO, 0, -2,
R_QUADRATIC_TO, 1.33, 0, 2.5, -0.39,
R_QUADRATIC_TO, 1.18, -0.39, 2.15, -1.11,
R_QUADRATIC_TO, -0.97, -0.72, -2.15, -1.11,
QUADRATIC_TO, 13.33, 17, 12, 17,
R_QUADRATIC_TO, -1.33, 0, -2.5, 0.39,
R_QUADRATIC_TO, -1.17, 0.39, -2.15, 1.11,
R_QUADRATIC_TO, 0.98, 0.73, 2.15, 1.11,
QUADRATIC_TO, 10.68, 20, 12, 20,
CLOSE,
R_MOVE_TO, 0, -9,
R_QUADRATIC_TO, 0.65, 0, 1.08, -0.42,
R_QUADRATIC_TO, 0.43, -0.42, 0.43, -1.07,
R_QUADRATIC_TO, 0, -0.65, -0.42, -1.07,
QUADRATIC_TO, 12.65, 8, 12, 8,
R_QUADRATIC_TO, -0.65, 0, -1.07, 0.43,
QUADRATIC_TO, 10.5, 8.85, 10.5, 9.5,
R_QUADRATIC_TO, 0, 0.65, 0.43, 1.08,
QUADRATIC_TO, 11.35, 11, 12, 11,
CLOSE,
R_MOVE_TO, 0, -1.5,
CLOSE,
R_MOVE_TO, 0, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountCircleRepList, kAccountCircleIcon, {kAccountCirclePath})
VECTOR_ICON_REP_TEMPLATE(kAccountCircleChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.94, 14.06,
R_ARC_TO, 8.24, 8.24, 0, 0, 1, 2.41, -1.18,
ARC_TO, 9.14, 9.14, 0, 0, 1, 10, 12.5,
R_CUBIC_TO, 0.92, 0, 1.8, 0.13, 2.66, 0.39,
R_ARC_TO, 8.24, 8.24, 0, 0, 1, 2.41, 1.18,
R_ARC_TO, 5.78, 5.78, 0, 0, 0, 1.08, -1.89,
ARC_TO, 6.64, 6.64, 0, 0, 0, 16.5, 10,
R_CUBIC_TO, 0, -1.8, -0.63, -3.34, -1.9, -4.6,
CUBIC_TO, 13.33, 4.13, 11.8, 3.5, 10, 3.5,
R_CUBIC_TO, -1.8, 0, -3.34, 0.63, -4.6, 1.9,
CUBIC_TO, 4.13, 6.66, 3.5, 8.2, 3.5, 10,
R_CUBIC_TO, 0, 0.75, 0.12, 1.47, 0.36, 2.17,
R_ARC_TO, 5.78, 5.78, 0, 0, 0, 1.08, 1.9,
CLOSE,
MOVE_TO, 10, 11.5,
R_ARC_TO, 2.9, 2.9, 0, 0, 1, -2.12, -0.87,
ARC_TO, 2.9, 2.9, 0, 0, 1, 7, 8.5,
R_CUBIC_TO, 0, -0.83, 0.29, -1.54, 0.88, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 1, 10, 5.5,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
R_CUBIC_TO, 0.58, 0.58, 0.88, 1.29, 0.88, 2.13,
R_CUBIC_TO, 0, 0.83, -0.29, 1.54, -0.87, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 1, 10, 11.5,
CLOSE,
R_MOVE_TO, 0, 6.5,
R_ARC_TO, 7.8, 7.8, 0, 0, 1, -3.11, -0.62,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -2.55, -1.72,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -1.72, -2.55,
ARC_TO, 7.8, 7.8, 0, 0, 1, 2, 9.99,
R_CUBIC_TO, 0, -1.1, 0.21, -2.14, 0.63, -3.1,
R_ARC_TO, 8.12, 8.12, 0, 0, 1, 1.72, -2.54,
R_CUBIC_TO, 0.73, -0.73, 1.58, -1.3, 2.55, -1.72,
ARC_TO, 7.8, 7.8, 0, 0, 1, 10.01, 2,
R_CUBIC_TO, 1.11, 0, 2.14, 0.21, 3.11, 0.63,
R_ARC_TO, 8.12, 8.12, 0, 0, 1, 2.54, 1.72,
R_CUBIC_TO, 0.73, 0.73, 1.3, 1.58, 1.72, 2.55,
R_CUBIC_TO, 0.42, 0.97, 0.63, 2, 0.63, 3.11,
R_ARC_TO, 7.8, 7.8, 0, 0, 1, -0.62, 3.11,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -1.72, 2.55,
R_CUBIC_TO, -0.73, 0.73, -1.58, 1.3, -2.55, 1.72,
R_ARC_TO, 7.75, 7.75, 0, 0, 1, -3.1, 0.63,
CLOSE,
MOVE_TO, 10, 16.5,
R_CUBIC_TO, 0.72, 0, 1.42, -0.11, 2.08, -0.34,
R_ARC_TO, 6.62, 6.62, 0, 0, 0, 1.88, -1.01,
R_ARC_TO, 7.36, 7.36, 0, 0, 0, -1.89, -0.85,
ARC_TO, 7.31, 7.31, 0, 0, 0, 10, 14,
R_CUBIC_TO, -0.71, 0, -1.4, 0.09, -2.07, 0.28,
R_CUBIC_TO, -0.67, 0.19, -1.3, 0.48, -1.88, 0.86,
R_ARC_TO, 6.62, 6.62, 0, 0, 0, 1.88, 1.01,
R_CUBIC_TO, 0.66, 0.23, 1.36, 0.34, 2.08, 0.34,
CLOSE,
R_MOVE_TO, 0, -6.5,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.64, 0.44, -1.06,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 10, 7,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 8.5, 8.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.06, 0.44,
CLOSE,
R_MOVE_TO, 0, -1.5,
CLOSE,
R_MOVE_TO, 0, 6.65,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kAccountCircleChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.97, 11.19,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, 1.92, -0.92,
R_CUBIC_TO, 0.68, -0.2, 1.38, -0.3, 2.11, -0.3,
R_CUBIC_TO, 0.73, 0, 1.44, 0.1, 2.12, 0.31,
R_CUBIC_TO, 0.68, 0.21, 1.32, 0.51, 1.91, 0.93,
R_CUBIC_TO, 0.38, -0.46, 0.66, -0.96, 0.84, -1.5,
ARC_TO, 5.23, 5.23, 0, 0, 0, 13.15, 8,
R_CUBIC_TO, 0, -1.43, -0.5, -2.64, -1.51, -3.64,
R_CUBIC_TO, -1.01, -1, -2.22, -1.51, -3.65, -1.51,
R_CUBIC_TO, -1.43, 0, -2.64, 0.5, -3.64, 1.51,
CUBIC_TO, 3.35, 5.36, 2.85, 6.58, 2.85, 8,
R_CUBIC_TO, 0, 0.59, 0.09, 1.15, 0.27, 1.69,
R_CUBIC_TO, 0.18, 0.54, 0.47, 1.04, 0.85, 1.5,
CLOSE,
MOVE_TO, 8, 9.23,
R_CUBIC_TO, -0.68, 0, -1.25, -0.23, -1.72, -0.7,
R_ARC_TO, 2.35, 2.35, 0, 0, 1, -0.71, -1.72,
R_CUBIC_TO, 0, -0.68, 0.24, -1.25, 0.71, -1.72,
ARC_TO, 2.35, 2.35, 0, 0, 1, 8, 4.38,
R_CUBIC_TO, 0.68, 0, 1.25, 0.24, 1.72, 0.71,
R_CUBIC_TO, 0.47, 0.47, 0.71, 1.04, 0.71, 1.72,
R_CUBIC_TO, 0, 0.68, -0.24, 1.25, -0.71, 1.72,
ARC_TO, 2.36, 2.36, 0, 0, 1, 8, 9.23,
CLOSE,
R_MOVE_TO, 0, 5.3,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, -2.54, -0.51,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, -3.49, -3.49,
R_ARC_TO, 6.39, 6.39, 0, 0, 1, -0.51, -2.54,
R_CUBIC_TO, 0, -0.9, 0.17, -1.75, 0.51, -2.53,
R_ARC_TO, 6.6, 6.6, 0, 0, 1, 3.49, -3.48,
R_ARC_TO, 6.39, 6.39, 0, 0, 1, 2.54, -0.51,
R_CUBIC_TO, 0.9, 0, 1.75, 0.17, 2.54, 0.51,
R_ARC_TO, 6.6, 6.6, 0, 0, 1, 3.48, 3.49,
R_CUBIC_TO, 0.34, 0.79, 0.51, 1.64, 0.51, 2.54,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, -0.51, 2.54,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, -3.49, 3.49,
R_CUBIC_TO, -0.79, 0.34, -1.64, 0.51, -2.53, 0.51,
CLOSE,
MOVE_TO, 8, 13.15,
R_CUBIC_TO, 0.57, 0, 1.11, -0.09, 1.62, -0.26,
R_ARC_TO, 5.38, 5.38, 0, 0, 0, 1.48, -0.78,
R_ARC_TO, 6.2, 6.2, 0, 0, 0, -1.49, -0.66,
ARC_TO, 5.74, 5.74, 0, 0, 0, 8, 11.22,
R_CUBIC_TO, -0.56, 0, -1.1, 0.07, -1.61, 0.21,
R_ARC_TO, 5.29, 5.29, 0, 0, 0, -1.48, 0.67,
R_CUBIC_TO, 0.46, 0.34, 0.96, 0.61, 1.47, 0.78,
ARC_TO, 4.99, 4.99, 0, 0, 0, 8, 13.15,
CLOSE,
R_MOVE_TO, 0, -5.17,
R_CUBIC_TO, 0.32, 0, 0.6, -0.11, 0.82, -0.34,
R_CUBIC_TO, 0.23, -0.23, 0.34, -0.5, 0.34, -0.82,
R_CUBIC_TO, 0, -0.32, -0.11, -0.6, -0.34, -0.83,
R_CUBIC_TO, -0.23, -0.23, -0.5, -0.34, -0.82, -0.34,
R_CUBIC_TO, -0.32, 0, -0.6, 0.11, -0.82, 0.34,
R_CUBIC_TO, -0.23, 0.23, -0.34, 0.5, -0.34, 0.83,
R_CUBIC_TO, 0, 0.32, 0.11, 0.6, 0.34, 0.82,
R_CUBIC_TO, 0.23, 0.23, 0.5, 0.34, 0.82, 0.34,
CLOSE,
R_MOVE_TO, 0, -1.17,
CLOSE,
R_MOVE_TO, 0, 5.3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountCircleChromeRefreshRepList, kAccountCircleChromeRefreshIcon, {kAccountCircleChromeRefreshPath}, {kAccountCircleChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kAccountCircleOffChromeRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 13.55, 10.45,
CLOSE,
R_MOVE_TO, -2.97, 2.97,
CLOSE,
MOVE_TO, 12, 19.93,
R_CUBIC_TO, 0.82, 0, 1.62, -0.12, 2.39, -0.38,
R_ARC_TO, 8.23, 8.23, 0, 0, 0, 2.16, -1.07,
R_ARC_TO, 8.18, 8.18, 0, 0, 0, -2.16, -1.07,
ARC_TO, 7.67, 7.67, 0, 0, 0, 12, 17.04,
R_CUBIC_TO, -0.82, 0, -1.62, 0.13, -2.39, 0.38,
R_CUBIC_TO, -0.76, 0.25, -1.48, 0.61, -2.16, 1.07,
R_CUBIC_TO, 0.67, 0.47, 1.39, 0.82, 2.16, 1.07,
R_ARC_TO, 7.54, 7.54, 0, 0, 0, 2.39, 0.38,
CLOSE,
R_MOVE_TO, 2.78, -8.21,
R_LINE_TO, -1.53, -1.54,
R_ARC_TO, 1.51, 1.51, 0, 0, 0, 0.15, -0.32,
R_CUBIC_TO, 0.04, -0.12, 0.06, -0.23, 0.06, -0.34,
R_CUBIC_TO, 0, -0.41, -0.14, -0.75, -0.43, -1.03,
ARC_TO, 1.39, 1.39, 0, 0, 0, 12, 8.06,
R_CUBIC_TO, -0.12, 0, -0.23, 0.02, -0.35, 0.06,
R_CUBIC_TO, -0.11, 0.04, -0.22, 0.09, -0.32, 0.16,
LINE_TO, 9.8, 6.74,
R_ARC_TO, 3.12, 3.12, 0, 0, 1, 1.03, -0.58,
ARC_TO, 3.58, 3.58, 0, 0, 1, 12, 5.97,
R_CUBIC_TO, 0.98, 0, 1.82, 0.34, 2.51, 1.03,
R_CUBIC_TO, 0.69, 0.69, 1.03, 1.53, 1.03, 2.51,
R_CUBIC_TO, 0, 0.41, -0.06, 0.8, -0.19, 1.18,
R_CUBIC_TO, -0.12, 0.37, -0.32, 0.71, -0.58, 1.02,
CLOSE,
R_MOVE_TO, 5.8, 5.81,
R_LINE_TO, -1.67, -1.67,
R_ARC_TO, 7.47, 7.47, 0, 0, 0, 0.77, -1.86,
ARC_TO, 7.94, 7.94, 0, 0, 0, 19.93, 12,
R_CUBIC_TO, 0, -2.21, -0.77, -4.08, -2.31, -5.62,
CUBIC_TO, 16.08, 4.84, 14.21, 4.07, 12, 4.07,
R_CUBIC_TO, -0.68, 0, -1.35, 0.09, -2, 0.25,
R_ARC_TO, 7.66, 7.66, 0, 0, 0, -1.86, 0.76,
LINE_TO, 6.48, 3.42,
R_ARC_TO, 10.73, 10.73, 0, 0, 1, 2.64, -1.21,
ARC_TO, 10.07, 10.07, 0, 0, 1, 12, 1.8,
R_CUBIC_TO, 1.41, 0, 2.74, 0.27, 3.98, 0.8,
R_ARC_TO, 10.35, 10.35, 0, 0, 1, 3.24, 2.18,
R_CUBIC_TO, 0.92, 0.92, 1.65, 2, 2.18, 3.24,
R_CUBIC_TO, 0.54, 1.24, 0.8, 2.57, 0.8, 3.98,
R_CUBIC_TO, 0, 0.99, -0.14, 1.95, -0.42, 2.88,
R_CUBIC_TO, -0.28, 0.93, -0.68, 1.81, -1.21, 2.64,
CLOSE,
MOVE_TO, 12, 22.2,
R_ARC_TO, 9.92, 9.92, 0, 0, 1, -3.98, -0.8,
R_ARC_TO, 10.35, 10.35, 0, 0, 1, -3.24, -2.18,
R_CUBIC_TO, -0.92, -0.92, -1.65, -2, -2.18, -3.24,
ARC_TO, 9.92, 9.92, 0, 0, 1, 1.8, 12,
R_CUBIC_TO, 0, -1, 0.14, -1.98, 0.43, -2.94,
R_CUBIC_TO, 0.28, -0.96, 0.7, -1.86, 1.25, -2.71,
LINE_TO, 0.65, 3.5,
R_LINE_TO, 1.48, -1.48,
LINE_TO, 22.06, 21.94,
R_LINE_TO, -1.48, 1.49,
LINE_TO, 5.14, 8.02,
ARC_TO, 7.85, 7.85, 0, 0, 0, 4.07, 12,
R_CUBIC_TO, 0, 0.93, 0.16, 1.82, 0.47, 2.67,
R_ARC_TO, 7.95, 7.95, 0, 0, 0, 1.34, 2.34,
R_ARC_TO, 10.51, 10.51, 0, 0, 1, 2.9, -1.54,
ARC_TO, 9.99, 9.99, 0, 0, 1, 12, 14.95,
R_CUBIC_TO, 0.65, 0, 1.29, 0.07, 1.94, 0.2,
R_CUBIC_TO, 0.64, 0.14, 1.26, 0.33, 1.87, 0.57,
R_LINE_TO, 3.45, 3.45,
ARC_TO, 10.15, 10.15, 0, 0, 1, 12, 22.2,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kAccountCircleOffChromeRefresh20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 11.06, 8.77,
CLOSE,
R_MOVE_TO, -2.33, 2.5,
CLOSE,
MOVE_TO, 10, 16.44,
R_CUBIC_TO, 0.7, 0, 1.38, -0.11, 2.04, -0.34,
R_ARC_TO, 6.72, 6.72, 0, 0, 0, 1.84, -0.97,
R_ARC_TO, 7.35, 7.35, 0, 0, 0, -1.86, -0.82,
ARC_TO, 7.4, 7.4, 0, 0, 0, 10, 14.03,
R_CUBIC_TO, -0.69, 0, -1.36, 0.09, -2.02, 0.27,
R_CUBIC_TO, -0.66, 0.18, -1.28, 0.46, -1.85, 0.83,
R_CUBIC_TO, 0.57, 0.43, 1.18, 0.75, 1.84, 0.97,
R_ARC_TO, 6.24, 6.24, 0, 0, 0, 2.03, 0.34,
CLOSE,
R_MOVE_TO, 2.5, -6.22,
R_LINE_TO, -1.17, -1.18,
R_ARC_TO, 0.84, 0.84, 0, 0, 0, 0.11, -0.26,
R_CUBIC_TO, 0.02, -0.09, 0.03, -0.18, 0.03, -0.27,
R_CUBIC_TO, 0, -0.41, -0.14, -0.75, -0.43, -1.04,
R_ARC_TO, 1.41, 1.41, 0, 0, 0, -1.31, -0.4,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.26, 0.11,
LINE_TO, 8.29, 6.01,
R_CUBIC_TO, 0.26, -0.17, 0.53, -0.3, 0.82, -0.4,
R_CUBIC_TO, 0.29, -0.09, 0.59, -0.14, 0.89, -0.14,
R_CUBIC_TO, 0.84, 0, 1.56, 0.3, 2.15, 0.89,
R_CUBIC_TO, 0.59, 0.59, 0.89, 1.31, 0.89, 2.15,
R_ARC_TO, 3.02, 3.02, 0, 0, 1, -0.54, 1.71,
CLOSE,
R_MOVE_TO, 4.29, 4.29,
R_LINE_TO, -1.26, -1.26,
R_ARC_TO, 6.37, 6.37, 0, 0, 0, 0.68, -1.56,
ARC_TO, 6.16, 6.16, 0, 0, 0, 16.44, 10,
R_CUBIC_TO, 0, -1.78, -0.63, -3.3, -1.88, -4.56,
CUBIC_TO, 13.31, 4.19, 11.79, 3.56, 10, 3.56,
R_ARC_TO, 6.16, 6.16, 0, 0, 0, -1.69, 0.23,
R_ARC_TO, 6.51, 6.51, 0, 0, 0, -1.56, 0.67,
LINE_TO, 5.48, 3.21,
ARC_TO, 8.01, 8.01, 0, 0, 1, 10, 1.83,
R_ARC_TO, 7.93, 7.93, 0, 0, 1, 3.18, 0.64,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 2.6, 1.75,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 1.75, 2.6,
R_ARC_TO, 7.93, 7.93, 0, 0, 1, 0.64, 3.18,
R_ARC_TO, 8.01, 8.01, 0, 0, 1, -1.37, 4.52,
CLOSE,
MOVE_TO, 10, 18.17,
R_ARC_TO, 7.93, 7.93, 0, 0, 1, -3.17, -0.64,
R_ARC_TO, 8.23, 8.23, 0, 0, 1, -2.6, -1.75,
R_ARC_TO, 8.23, 8.23, 0, 0, 1, -1.75, -2.6,
ARC_TO, 7.93, 7.93, 0, 0, 1, 1.83, 10,
R_CUBIC_TO, 0, -0.82, 0.12, -1.62, 0.36, -2.39,
ARC_TO, 8.48, 8.48, 0, 0, 1, 3.25, 5.42,
LINE_TO, 1.85, 4,
LINE_TO, 2.96, 2.89,
R_LINE_TO, 14.23, 14.23,
R_LINE_TO, -1.11, 1.11,
LINE_TO, 4.49, 6.66,
R_ARC_TO, 6.37, 6.37, 0, 0, 0, -0.7, 1.6,
ARC_TO, 6.42, 6.42, 0, 0, 0, 3.56, 10,
R_CUBIC_TO, 0, 0.73, 0.12, 1.44, 0.35, 2.12,
R_CUBIC_TO, 0.23, 0.68, 0.58, 1.31, 1.06, 1.87,
R_ARC_TO, 8.37, 8.37, 0, 0, 1, 2.39, -1.16,
R_ARC_TO, 9.27, 9.27, 0, 0, 1, 2.64, -0.37,
R_CUBIC_TO, 0.53, 0, 1.05, 0.04, 1.56, 0.14,
R_CUBIC_TO, 0.51, 0.09, 1.01, 0.23, 1.5, 0.4,
R_LINE_TO, 2.75, 2.75,
R_ARC_TO, 8.05, 8.05, 0, 0, 1, -2.65, 1.79,
R_CUBIC_TO, -1, 0.42, -2.05, 0.63, -3.15, 0.63,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kAccountCircleOffChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8.95, 6.92,
CLOSE,
MOVE_TO, 6.97, 9.03,
CLOSE,
MOVE_TO, 8, 13.09,
R_CUBIC_TO, 0.54, 0, 1.06, -0.09, 1.57, -0.25,
R_ARC_TO, 5.39, 5.39, 0, 0, 0, 1.43, -0.74,
ARC_TO, 5.86, 5.86, 0, 0, 0, 8, 11.26,
R_ARC_TO, 6.01, 6.01, 0, 0, 0, -1.56, 0.2,
R_CUBIC_TO, -0.51, 0.14, -0.99, 0.35, -1.44, 0.63,
R_CUBIC_TO, 0.45, 0.32, 0.92, 0.57, 1.43, 0.74,
R_ARC_TO, 4.95, 4.95, 0, 0, 0, 1.57, 0.25,
CLOSE,
R_MOVE_TO, 2.11, -4.98,
LINE_TO, 9.08, 7.06,
R_ARC_TO, 0.29, 0.29, 0, 0, 0, 0.04, -0.12,
R_CUBIC_TO, 0, -0.04, 0, -0.08, 0, -0.12,
R_CUBIC_TO, 0, -0.32, -0.11, -0.59, -0.33, -0.8,
R_ARC_TO, 1.09, 1.09, 0, 0, 0, -0.93, -0.32,
R_ARC_TO, 0.31, 0.31, 0, 0, 0, -0.12, 0.05,
LINE_TO, 6.72, 4.7,
R_CUBIC_TO, 0.2, -0.12, 0.41, -0.21, 0.63, -0.27,
ARC_TO, 2.53, 2.53, 0, 0, 1, 8, 4.34,
R_CUBIC_TO, 0.69, 0, 1.27, 0.24, 1.75, 0.72,
R_CUBIC_TO, 0.48, 0.48, 0.72, 1.06, 0.72, 1.75,
R_CUBIC_TO, 0, 0.22, -0.03, 0.43, -0.09, 0.66,
R_ARC_TO, 2.68, 2.68, 0, 0, 1, -0.27, 0.63,
CLOSE,
R_MOVE_TO, 3.53, 3.53,
R_LINE_TO, -1.21, -1.21,
R_CUBIC_TO, 0.21, -0.36, 0.38, -0.75, 0.48, -1.16,
R_CUBIC_TO, 0.11, -0.41, 0.17, -0.83, 0.17, -1.26,
R_CUBIC_TO, 0, -1.41, -0.5, -2.6, -1.49, -3.6,
CUBIC_TO, 10.61, 3.41, 9.41, 2.91, 8, 2.91,
R_CUBIC_TO, -0.43, 0, -0.85, 0.06, -1.26, 0.17,
R_CUBIC_TO, -0.41, 0.11, -0.8, 0.27, -1.16, 0.47,
LINE_TO, 4.37, 2.36,
R_ARC_TO, 6.56, 6.56, 0, 0, 1, 1.74, -0.8,
ARC_TO, 6.53, 6.53, 0, 0, 1, 8, 1.28,
R_ARC_TO, 6.48, 6.48, 0, 0, 1, 2.61, 0.52,
ARC_TO, 6.69, 6.69, 0, 0, 1, 12.75, 3.25,
R_ARC_TO, 6.69, 6.69, 0, 0, 1, 1.45, 2.14,
ARC_TO, 6.48, 6.48, 0, 0, 1, 14.72, 8,
R_ARC_TO, 6.53, 6.53, 0, 0, 1, -0.27, 1.89,
R_ARC_TO, 6.56, 6.56, 0, 0, 1, -0.8, 1.74,
CLOSE,
MOVE_TO, 8, 14.72,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -2.61, -0.52,
R_ARC_TO, 6.7, 6.7, 0, 0, 1, -2.14, -1.44,
R_ARC_TO, 6.7, 6.7, 0, 0, 1, -1.44, -2.14,
ARC_TO, 6.52, 6.52, 0, 0, 1, 1.28, 8,
R_CUBIC_TO, 0, -0.68, 0.1, -1.33, 0.31, -1.97,
R_CUBIC_TO, 0.21, -0.64, 0.5, -1.24, 0.88, -1.8,
LINE_TO, 1.45, 3.2,
R_LINE_TO, 0.95, -0.94,
R_LINE_TO, 11.5, 11.5,
R_LINE_TO, -0.95, 0.95,
R_LINE_TO, -9.32, -9.3,
R_ARC_TO, 5.17, 5.17, 0, 0, 0, -0.54, 1.25,
R_CUBIC_TO, -0.12, 0.43, -0.18, 0.89, -0.18, 1.35,
R_CUBIC_TO, 0, 0.57, 0.09, 1.12, 0.27, 1.65,
R_CUBIC_TO, 0.18, 0.53, 0.45, 1.02, 0.81, 1.46,
R_ARC_TO, 6.58, 6.58, 0, 0, 1, 1.9, -0.9,
R_ARC_TO, 7.36, 7.36, 0, 0, 1, 2.1, -0.3,
R_CUBIC_TO, 0.44, 0, 0.86, 0.04, 1.28, 0.11,
R_CUBIC_TO, 0.42, 0.08, 0.82, 0.19, 1.22, 0.34,
R_LINE_TO, 2.31, 2.31,
R_ARC_TO, 6.71, 6.71, 0, 0, 1, -2.19, 1.51,
R_CUBIC_TO, -0.83, 0.35, -1.7, 0.53, -2.62, 0.53,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountCircleOffChromeRefreshRepList, kAccountCircleOffChromeRefreshIcon, {kAccountCircleOffChromeRefreshPath}, {kAccountCircleOffChromeRefresh20Path}, {kAccountCircleOffChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kAddPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 13, 7.2,
H_LINE_TO, 8.8,
V_LINE_TO, 3,
H_LINE_TO, 7.2,
R_V_LINE_TO, 4.2,
H_LINE_TO, 3,
R_V_LINE_TO, 1.7,
R_H_LINE_TO, 4.2,
V_LINE_TO, 13,
R_H_LINE_TO, 1.7,
V_LINE_TO, 8.8,
H_LINE_TO, 13,
V_LINE_TO, 7.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAddRepList, kAddIcon, {kAddPath})
VECTOR_ICON_REP_TEMPLATE(kAddLinkPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 17, 20,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
R_V_LINE_TO, -2,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
R_H_LINE_TO, -3,
R_V_LINE_TO, 3,
CLOSE,
R_MOVE_TO, -6, -3,
H_LINE_TO, 7,
R_CUBIC_TO, -1.38, 0, -2.56, -0.49, -3.54, -1.46,
CUBIC_TO, 2.49, 14.56, 2, 13.38, 2, 12,
R_CUBIC_TO, 0, -1.38, 0.49, -2.56, 1.46, -3.54,
CUBIC_TO, 4.44, 7.49, 5.62, 7, 7, 7,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
H_LINE_TO, 7,
R_CUBIC_TO, -0.83, 0, -1.54, 0.29, -2.12, 0.88,
ARC_TO, 2.9, 2.9, 0, 0, 0, 4, 12,
R_CUBIC_TO, 0, 0.83, 0.29, 1.54, 0.88, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 0, 7, 15,
R_H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, -3, -4,
R_V_LINE_TO, -2,
R_H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 14, -1,
R_H_LINE_TO, -2,
R_CUBIC_TO, 0, -0.83, -0.29, -1.54, -0.87, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 0, 17, 9,
R_H_LINE_TO, -4,
V_LINE_TO, 7,
R_H_LINE_TO, 4,
R_CUBIC_TO, 1.38, 0, 2.56, 0.49, 3.54, 1.46,
R_CUBIC_TO, 0.97, 0.98, 1.46, 2.16, 1.46, 3.54,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAddLinkRepList, kAddLinkIcon, {kAddLinkPath})
VECTOR_ICON_REP_TEMPLATE(kAdsPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4, 2,
R_ARC_TO, 2, 2, 0, 0, 0, -2, 2,
R_V_LINE_TO, 8,
R_ARC_TO, 2, 2, 0, 0, 0, 2, 2,
R_H_LINE_TO, 8,
R_ARC_TO, 2, 2, 0, 0, 0, 2, -2,
V_LINE_TO, 4,
R_ARC_TO, 2, 2, 0, 0, 0, -2, -2,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 8, 10,
H_LINE_TO, 4,
V_LINE_TO, 6,
R_H_LINE_TO, 8,
R_V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAdsRepList, kAdsIcon, {kAdsPath})
VECTOR_ICON_REP_TEMPLATE(kAdsChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_ARC_TO, 1.42, 1.42, 0, 0, 1, -1.06, -0.45,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.44, -1.05,
CUBIC_TO, 3.73, 3.15, 4.09, 3, 4.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.45,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.05,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
V_LINE_TO, 7,
R_H_LINE_TO, -11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAdsChromeRefreshRepList, kAdsChromeRefreshIcon, {kAdsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAdsClickPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11.71, 17.99,
CUBIC_TO, 8.53, 17.84, 6, 15.22, 6, 12,
R_CUBIC_TO, 0, -3.31, 2.69, -6, 6, -6,
R_CUBIC_TO, 3.22, 0, 5.84, 2.53, 5.99, 5.71,
R_LINE_TO, -2.1, -0.63,
CUBIC_TO, 15.48, 9.31, 13.89, 8, 12, 8,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_CUBIC_TO, 0, 1.89, 1.31, 3.48, 3.08, 3.89,
LINE_TO, 11.71, 17.99,
CLOSE,
MOVE_TO, 22, 12,
R_CUBIC_TO, 0, 0.3, -0.01, 0.6, -0.04, 0.9,
R_LINE_TO, -1.97, -0.59,
CUBIC_TO, 20, 12.21, 20, 12.1, 20, 12,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
R_CUBIC_TO, -4.42, 0, -8, 3.58, -8, 8,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 0.1, 0, 0.21, 0, 0.31, -0.01,
R_LINE_TO, 0.59, 1.97,
CUBIC_TO, 12.6, 21.99, 12.3, 22, 12, 22,
CUBIC_TO, 6.48, 22, 2, 17.52, 2, 12,
CUBIC_TO, 2, 6.48, 6.48, 2, 12, 2,
CUBIC_TO_SHORTHAND, 22, 6.48, 22, 12,
CLOSE,
MOVE_TO, 18.23, 16.26,
LINE_TO, 22, 15,
R_LINE_TO, -10, -3,
R_LINE_TO, 3, 10,
R_LINE_TO, 1.26, -3.77,
R_LINE_TO, 4.27, 4.27,
R_LINE_TO, 1.98, -1.98,
LINE_TO, 18.23, 16.26,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAdsClickRepList, kAdsClickIcon, {kAdsClickPath})
VECTOR_ICON_REP_TEMPLATE(kAdsOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.02, 18.13,
LINE_TO, 14.88, 17,
H_LINE_TO, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 5.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.15,
CLOSE,
MOVE_TO, 4.5, 15.5,
R_H_LINE_TO, 8.88,
LINE_TO, 4.5, 6.63,
CLOSE,
R_MOVE_TO, 12.5, -0.62,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 7,
H_LINE_TO, 9.13,
R_LINE_TO, -4, -4,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAdsOffChromeRefreshRepList, kAdsOffChromeRefreshIcon, {kAdsOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kArrowBackPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 13.33, 7.33,
H_LINE_TO, 5.22,
R_LINE_TO, 3.73, -3.73,
LINE_TO, 8, 2.67,
LINE_TO, 2.67, 8,
LINE_TO, 8, 13.33,
R_LINE_TO, 0.94, -0.94,
R_LINE_TO, -3.72, -3.73,
R_H_LINE_TO, 8.11,
V_LINE_TO, 7.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kArrowBackRepList, kArrowBackIcon, {kArrowBackPath})
VECTOR_ICON_REP_TEMPLATE(kArrowBackChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 6.88, 10.75,
R_LINE_TO, 4.19, 4.19,
LINE_TO, 10, 16,
R_LINE_TO, -6, -6,
R_LINE_TO, 6, -6,
R_LINE_TO, 1.06, 1.06,
LINE_TO, 6.88, 9.25,
H_LINE_TO, 16,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kArrowBackChromeRefreshRepList, kArrowBackChromeRefreshIcon, {kArrowBackChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kArrowRightAltPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 12, 14,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 13.13, 10.75,
H_LINE_TO, 4,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 9.13,
R_LINE_TO, -2.19, -2.19,
LINE_TO, 12, 6,
R_LINE_TO, 4, 4,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kArrowRightAltRepList, kArrowRightAltIcon, {kArrowRightAltPath})
VECTOR_ICON_REP_TEMPLATE(kBackArrowPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 4.22, 14.03,
CUBIC_TO, 3.53, 14.15, 3, 14.77, 3, 15.5,
CUBIC_TO, 3, 16.25, 3.53, 16.86, 4.24, 16.98,
LINE_TO, 4.02, 17.19,
LINE_TO, 14.36, 27.51,
CUBIC_TO, 14.65, 27.81, 15.05, 28, 15.5, 28,
CUBIC_TO, 16.33, 28, 17, 27.33, 17, 26.5,
CUBIC_TO, 17, 26.05, 16.8, 25.65, 16.49, 25.38,
LINE_TO, 16.55, 25.32,
LINE_TO, 8.22, 17,
LINE_TO, 27.51, 17,
CUBIC_TO, 28.33, 17, 29, 16.33, 29, 15.5,
CUBIC_TO, 29, 14.67, 28.33, 14, 27.51, 14,
LINE_TO, 8.2, 14,
LINE_TO, 16.55, 5.66,
CUBIC_TO, 16.81, 5.34, 17, 4.94, 17, 4.5,
CUBIC_TO, 17, 3.68, 16.33, 3, 15.5, 3,
CUBIC_TO, 15.06, 3, 14.66, 3.2, 14.39, 3.5,
LINE_TO, 14.36, 3.47,
LINE_TO, 4, 13.81,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kBackArrow16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 9, 13.51,
LINE_TO, 4.49, 9,
LINE_TO, 14, 9,
CUBIC_TO, 14.55, 9, 15, 8.55, 15, 8,
CUBIC_TO, 15, 7.45, 14.55, 7, 14, 7,
LINE_TO, 4.49, 7,
LINE_TO, 9, 2.49,
CUBIC_TO, 8.97, 2.28, 9, 2.14, 9, 2,
CUBIC_TO, 9, 1.45, 8.55, 1, 8, 1,
CUBIC_TO, 7.86, 1, 7.72, 1.03, 7.59, 1.09,
LINE_TO, 7.51, 1,
LINE_TO, 1, 7.51,
CUBIC_TO, 1.03, 7.72, 1, 7.85, 1, 8,
CUBIC_TO, 1, 8.15, 1.03, 8.28, 1.09, 8.41,
LINE_TO, 1, 8.49,
LINE_TO, 7.51, 15,
CUBIC_TO, 7.72, 14.97, 7.86, 15, 8, 15,
CUBIC_TO, 8.55, 15, 9, 14.55, 9, 14,
CUBIC_TO, 9, 13.86, 8.97, 13.72, 8.91, 13.59,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackArrowRepList, kBackArrowIcon, {kBackArrowPath}, {kBackArrow16Path})
VECTOR_ICON_REP_TEMPLATE(kBackArrowChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 6.88, 10.75,
R_LINE_TO, 4.19, 4.19,
LINE_TO, 10, 16,
R_LINE_TO, -6, -6,
R_LINE_TO, 6, -6,
R_LINE_TO, 1.06, 1.06,
LINE_TO, 6.88, 9.25,
H_LINE_TO, 16,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackArrowChromeRefreshRepList, kBackArrowChromeRefreshIcon, {kBackArrowChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBackToTabPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.2, 12.14,
V_LINE_TO, 13.4,
R_ARC_TO, 1, 1, 0, 0, 0, 1, 1,
R_H_LINE_TO, 6,
R_ARC_TO, 1, 1, 0, 0, 0, 1, -1,
V_LINE_TO, 9,
R_ARC_TO, 1, 1, 0, 0, 0, -1, -1,
R_H_LINE_TO, -6,
R_ARC_TO, 1, 1, 0, 0, 0, -1, 1,
R_V_LINE_TO, 1.84,
H_LINE_TO, 2.13,
V_LINE_TO, 7.6,
H_LINE_TO, 0.8,
R_V_LINE_TO, 3.21,
R_CUBIC_TO, 0, 0.73, 0.6, 1.33, 1.33, 1.33,
R_H_LINE_TO, 3.07,
CLOSE,
R_MOVE_TO, 6.67, -9.21,
V_LINE_TO, 6.8,
H_LINE_TO, 13.2,
V_LINE_TO, 2.93,
R_CUBIC_TO, 0, -0.73, -0.59, -1.33, -1.33, -1.33,
H_LINE_TO, 6.8,
R_V_LINE_TO, 1.33,
R_H_LINE_TO, 5.07,
CLOSE,
NEW_PATH,
MOVE_TO, 5.48, 2.93,
V_LINE_TO, 1.6,
H_LINE_TO, 0.82,
R_V_LINE_TO, 4.67,
H_LINE_TO, 2.15,
V_LINE_TO, 3.87,
R_LINE_TO, 4.05, 4.05,
R_CUBIC_TO, 0.2, -0.41, 0.53, -0.74, 0.95, -0.93,
LINE_TO, 3.09, 2.93,
R_H_LINE_TO, 2.39,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackToTabRepList, kBackToTabIcon, {kBackToTabPath})
VECTOR_ICON_REP_TEMPLATE(kBackToTabChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.67, 7.71,
LINE_TO, 2.33, 4.38,
LINE_TO, 2.33, 7.33,
LINE_TO, 1.33, 7.33,
LINE_TO, 1.33, 2.67,
LINE_TO, 6, 2.67,
LINE_TO, 6, 3.67,
LINE_TO, 3.04, 3.67,
LINE_TO, 6.38, 7,
CLOSE,
MOVE_TO, 2.33, 13.33,
CUBIC_TO, 2.07, 13.33, 1.83, 13.23, 1.63, 13.04,
CUBIC_TO, 1.43, 12.83, 1.33, 12.6, 1.33, 12.33,
LINE_TO, 1.33, 8.5,
LINE_TO, 2.33, 8.5,
LINE_TO, 2.33, 12.33,
LINE_TO, 8, 12.33,
LINE_TO, 8, 13.33,
CLOSE,
MOVE_TO, 13.67, 8.67,
LINE_TO, 13.67, 3.67,
LINE_TO, 7.17, 3.67,
LINE_TO, 7.17, 2.67,
LINE_TO, 13.67, 2.67,
CUBIC_TO, 13.93, 2.67, 14.17, 2.77, 14.37, 2.96,
CUBIC_TO, 14.57, 3.17, 14.67, 3.4, 14.67, 3.67,
LINE_TO, 14.67, 8.67,
CLOSE,
MOVE_TO, 14.67, 9.67,
LINE_TO, 14.67, 13.33,
LINE_TO, 9, 13.33,
LINE_TO, 9, 9.67,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackToTabChromeRefreshRepList, kBackToTabChromeRefreshIcon, {kBackToTabChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBlockedBadgePath, CANVAS_DIMENSIONS, 32,
PATH_MODE_CLEAR,
MOVE_TO, 32, 32,
LINE_TO, 16, 32,
LINE_TO, 16, 18,
CUBIC_TO, 16, 16.9, 16.9, 16, 18, 16,
LINE_TO, 32, 16,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDB, 0x44, 0x37,
MOVE_TO, 30, 32,
LINE_TO, 20, 32,
CUBIC_TO, 18.9, 32, 18, 31.1, 18, 30,
LINE_TO, 18, 20,
CUBIC_TO, 18, 18.9, 18.9, 18, 20, 18,
LINE_TO, 30, 18,
CUBIC_TO, 31.1, 18, 32, 18.9, 32, 20,
LINE_TO, 32, 30,
CUBIC_TO, 32, 31.1, 31.1, 32, 30, 32,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 26.8, 22,
LINE_TO, 25, 23.8,
LINE_TO, 23.2, 22,
CUBIC_TO, 22.87, 21.66, 22.33, 21.66, 22, 22,
CUBIC_TO, 21.66, 22.33, 21.66, 22.87, 22, 23.2,
LINE_TO, 23.8, 25,
LINE_TO, 22, 26.8,
CUBIC_TO, 21.66, 27.13, 21.66, 27.67, 22, 28,
CUBIC_TO, 22.33, 28.34, 22.87, 28.34, 23.2, 28,
LINE_TO, 25, 26.2,
LINE_TO, 26.8, 28,
CUBIC_TO, 27.13, 28.34, 27.67, 28.34, 28, 28,
CUBIC_TO, 28.34, 27.67, 28.34, 27.13, 28, 26.8,
LINE_TO, 26.2, 25,
LINE_TO, 28, 23.2,
CUBIC_TO, 28.34, 22.87, 28.34, 22.33, 28, 22,
CUBIC_TO, 27.67, 21.66, 27.13, 21.66, 26.8, 22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBlockedBadgeRepList, kBlockedBadgeIcon, {kBlockedBadgePath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.71, 7.71,
LINE_TO, 12, 2,
R_H_LINE_TO, -1,
R_V_LINE_TO, 7.59,
LINE_TO, 6.41, 5,
LINE_TO, 5, 6.41,
LINE_TO, 10.59, 12,
LINE_TO, 5, 17.59,
LINE_TO, 6.41, 19,
LINE_TO, 11, 14.41,
V_LINE_TO, 22,
R_H_LINE_TO, 1,
R_LINE_TO, 5.71, -5.71,
R_LINE_TO, -4.3, -4.29,
R_LINE_TO, 4.3, -4.29,
CLOSE,
MOVE_TO, 13, 5.83,
R_LINE_TO, 1.88, 1.88,
LINE_TO, 13, 9.59,
V_LINE_TO, 5.83,
CLOSE,
R_MOVE_TO, 1.88, 10.46,
LINE_TO, 13, 18.17,
R_V_LINE_TO, -3.76,
R_LINE_TO, 1.88, 1.88,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothRepList, kBluetoothIcon, {kBluetoothPath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 9, 18,
R_V_LINE_TO, -5.87,
R_LINE_TO, -3.56, 3.56,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 9, 10,
LINE_TO, 4.38, 5.38,
R_LINE_TO, 1.06, -1.06,
LINE_TO, 9, 7.88,
V_LINE_TO, 2,
R_H_LINE_TO, 1.13,
R_LINE_TO, 4.5, 4.5,
R_LINE_TO, -3.5, 3.5,
R_LINE_TO, 3.5, 3.5,
R_LINE_TO, -4.5, 4.5,
CLOSE,
R_MOVE_TO, 1.5, -9.5,
R_LINE_TO, 2, -2,
R_LINE_TO, -2, -2,
CLOSE,
R_MOVE_TO, 0, 7,
R_LINE_TO, 2, -2,
R_LINE_TO, -2, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothChromeRefreshRepList, kBluetoothChromeRefreshIcon, {kBluetoothChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothConnectedPath, MOVE_TO, 14, 24,
R_LINE_TO, -4, -4,
R_LINE_TO, -4, 4,
R_LINE_TO, 4, 4,
R_LINE_TO, 4, -4,
CLOSE,
R_MOVE_TO, 21.41, -8.59,
LINE_TO, 24, 4,
R_H_LINE_TO, -2,
R_V_LINE_TO, 15.17,
LINE_TO, 12.83, 10,
LINE_TO, 10, 12.83,
LINE_TO, 21.17, 24,
LINE_TO, 10, 35.17,
LINE_TO, 12.83, 38,
LINE_TO, 22, 28.83,
V_LINE_TO, 44,
R_H_LINE_TO, 2,
R_LINE_TO, 11.41, -11.41,
LINE_TO, 26.83, 24,
R_LINE_TO, 8.58, -8.59,
CLOSE,
MOVE_TO, 26, 11.66,
R_LINE_TO, 3.76, 3.76,
LINE_TO, 26, 19.17,
R_V_LINE_TO, -7.51,
CLOSE,
R_MOVE_TO, 3.76, 20.93,
LINE_TO, 26, 36.34,
R_V_LINE_TO, -7.52,
R_LINE_TO, 3.76, 3.77,
CLOSE,
MOVE_TO, 38, 20,
R_LINE_TO, -4, 4,
R_LINE_TO, 4, 4,
R_LINE_TO, 4, -4,
R_LINE_TO, -4, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothConnectedRepList, kBluetoothConnectedIcon, {kBluetoothConnectedPath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16, 18.13,
R_LINE_TO, -3, -3,
LINE_TO, 10.13, 18,
H_LINE_TO, 9,
R_V_LINE_TO, -5.87,
R_LINE_TO, -3.56, 3.56,
R_LINE_TO, -1.06, -1.06,
R_LINE_TO, 4.06, -4.06,
LINE_TO, 1.88, 3.98,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.15,
CLOSE,
MOVE_TO, 10.5, 15.5,
R_LINE_TO, 1.44, -1.44,
R_LINE_TO, -1.44, -1.44,
CLOSE,
R_MOVE_TO, 1.13, -6,
LINE_TO, 10.5, 8.38,
R_LINE_TO, 2, -1.87,
R_LINE_TO, -2, -2,
R_V_LINE_TO, 3.88,
LINE_TO, 9, 6.88,
V_LINE_TO, 2,
R_H_LINE_TO, 1.13,
R_LINE_TO, 4.5, 4.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothOffChromeRefreshRepList, kBluetoothOffChromeRefreshIcon, {kBluetoothOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothScanningPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 14.24, 12.01,
R_LINE_TO, 2.32, 2.32,
R_CUBIC_TO, 0.28, -0.72, 0.44, -1.51, 0.44, -2.33,
R_CUBIC_TO, 0, -0.82, -0.16, -1.59, -0.43, -2.31,
R_LINE_TO, -2.33, 2.32,
CLOSE,
R_MOVE_TO, 5.29, -5.3,
R_LINE_TO, -1.26, 1.26,
R_CUBIC_TO, 0.63, 1.21, 0.98, 2.57, 0.98, 4.02,
R_CUBIC_TO, 0, 1.45, -0.36, 2.82, -0.98, 4.02,
R_LINE_TO, 1.2, 1.2,
R_ARC_TO, 9.94, 9.94, 0, 0, 0, 1.54, -5.31,
R_CUBIC_TO, -0.01, -1.89, -0.55, -3.67, -1.48, -5.19,
CLOSE,
R_MOVE_TO, -3.82, 1,
LINE_TO, 10, 2,
H_LINE_TO, 9,
R_V_LINE_TO, 7.59,
LINE_TO, 4.41, 5,
LINE_TO, 3, 6.41,
LINE_TO, 8.59, 12,
LINE_TO, 3, 17.59,
LINE_TO, 4.41, 19,
LINE_TO, 9, 14.41,
V_LINE_TO, 22,
R_H_LINE_TO, 1,
R_LINE_TO, 5.71, -5.71,
R_LINE_TO, -4.3, -4.29,
R_LINE_TO, 4.3, -4.29,
CLOSE,
MOVE_TO, 11, 5.83,
R_LINE_TO, 1.88, 1.88,
LINE_TO, 11, 9.59,
V_LINE_TO, 5.83,
CLOSE,
R_MOVE_TO, 1.88, 10.46,
LINE_TO, 11, 18.17,
R_V_LINE_TO, -3.76,
R_LINE_TO, 1.88, 1.88,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothScanningRepList, kBluetoothScanningIcon, {kBluetoothScanningPath})
VECTOR_ICON_REP_TEMPLATE(kBluetoothScanningChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.5, 18,
R_V_LINE_TO, -5.87,
R_LINE_TO, -3.56, 3.56,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 7.5, 10,
LINE_TO, 2.88, 5.38,
R_LINE_TO, 1.06, -1.06,
LINE_TO, 7.5, 7.88,
V_LINE_TO, 2,
R_H_LINE_TO, 1.13,
R_LINE_TO, 4.5, 4.5,
R_LINE_TO, -3.5, 3.5,
R_LINE_TO, 3.5, 3.5,
R_LINE_TO, -4.5, 4.5,
CLOSE,
MOVE_TO, 9, 8.5,
R_LINE_TO, 2, -2,
R_LINE_TO, -2, -2,
CLOSE,
R_MOVE_TO, 0, 7,
R_LINE_TO, 2, -2,
R_LINE_TO, -2, -2,
CLOSE,
R_MOVE_TO, 4.69, -3.81,
LINE_TO, 12, 10,
R_LINE_TO, 1.69, -1.69,
R_CUBIC_TO, 0.11, 0.28, 0.19, 0.56, 0.24, 0.83,
R_CUBIC_TO, 0.05, 0.28, 0.07, 0.56, 0.07, 0.86,
R_CUBIC_TO, 0, 0.29, -0.02, 0.58, -0.07, 0.86,
R_ARC_TO, 4.17, 4.17, 0, 0, 1, -0.24, 0.83,
CLOSE,
R_MOVE_TO, 2.27, 2.27,
R_LINE_TO, -1.12, -1.12,
R_CUBIC_TO, 0.24, -0.44, 0.41, -0.91, 0.51, -1.38,
R_ARC_TO, 6.75, 6.75, 0, 0, 0, 0, -2.9,
R_ARC_TO, 5.32, 5.32, 0, 0, 0, -0.51, -1.38,
R_LINE_TO, 1.13, -1.12,
R_ARC_TO, 6.82, 6.82, 0, 0, 1, 0.79, 1.89,
R_CUBIC_TO, 0.17, 0.67, 0.25, 1.36, 0.25, 2.06,
R_CUBIC_TO, 0, 0.71, -0.08, 1.4, -0.25, 2.06,
R_ARC_TO, 6.82, 6.82, 0, 0, 1, -0.79, 1.89,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kBluetoothScanningChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 5.95, 14.45,
R_LINE_TO, 0, -4.67,
R_LINE_TO, -2.82, 2.82,
R_LINE_TO, -0.89, -0.89,
LINE_TO, 5.94, 8,
LINE_TO, 2.24, 4.3,
R_LINE_TO, 0.9, -0.89,
R_LINE_TO, 2.82, 2.82,
R_LINE_TO, 0, -4.67,
R_H_LINE_TO, 0.93,
R_LINE_TO, 3.64, 3.64,
LINE_TO, 7.73, 8,
R_LINE_TO, 2.8, 2.8,
R_LINE_TO, -3.64, 3.65,
CLOSE,
R_MOVE_TO, 1.26, -7.72,
R_LINE_TO, 1.52, -1.53,
R_LINE_TO, -1.52, -1.53,
CLOSE,
R_MOVE_TO, 0, 5.6,
R_LINE_TO, 1.52, -1.53,
R_LINE_TO, -1.52, -1.53,
CLOSE,
R_MOVE_TO, 3.77, -2.92,
LINE_TO, 9.59, 8,
R_LINE_TO, 1.4, -1.41,
R_CUBIC_TO, 0.1, 0.23, 0.16, 0.47, 0.2, 0.7,
R_ARC_TO, 4.34, 4.34, 0, 0, 1, 0, 1.43,
R_CUBIC_TO, -0.04, 0.23, -0.1, 0.46, -0.2, 0.69,
CLOSE,
R_MOVE_TO, 1.81, 1.81,
R_LINE_TO, -0.93, -0.94,
R_ARC_TO, 4.31, 4.31, 0, 0, 0, 0.41, -1.11,
R_CUBIC_TO, 0.09, -0.39, 0.13, -0.77, 0.13, -1.16,
R_CUBIC_TO, 0, -0.39, -0.04, -0.78, -0.12, -1.16,
R_ARC_TO, 4.28, 4.28, 0, 0, 0, -0.41, -1.11,
R_LINE_TO, 0.94, -0.95,
R_CUBIC_TO, 0.3, 0.49, 0.51, 1, 0.65, 1.54,
R_ARC_TO, 6.85, 6.85, 0, 0, 1, 0, 3.36,
R_ARC_TO, 5.62, 5.62, 0, 0, 1, -0.66, 1.55,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBluetoothScanningChromeRefreshRepList, kBluetoothScanningChromeRefreshIcon, {kBluetoothScanningChromeRefreshPath}, {kBluetoothScanningChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kBusinessPath, MOVE_TO, 24, 14,
V_LINE_TO, 6,
H_LINE_TO, 4,
R_V_LINE_TO, 36,
R_H_LINE_TO, 40,
V_LINE_TO, 14,
H_LINE_TO, 24,
CLOSE,
MOVE_TO, 12, 38,
H_LINE_TO, 8,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
H_LINE_TO, 8,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
H_LINE_TO, 8,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
H_LINE_TO, 8,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 8, 24,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 20, 24,
H_LINE_TO, 24,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -4,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -4,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 16,
R_V_LINE_TO, 20,
CLOSE,
R_MOVE_TO, -4, -16,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -4,
CLOSE,
R_MOVE_TO, 0, 8,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBusinessRepList, kBusinessIcon, {kBusinessPath})
VECTOR_ICON_REP_TEMPLATE(kBusinessChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 1.48, 13.79,
V_LINE_TO, 2.34,
R_H_LINE_TO, 6.65,
R_V_LINE_TO, 2.4,
R_H_LINE_TO, 6.4,
R_V_LINE_TO, 9.05,
CLOSE,
MOVE_TO, 2.8, 12.46,
H_LINE_TO, 4,
R_V_LINE_TO, -1.2,
H_LINE_TO, 2.8,
CLOSE,
R_MOVE_TO, 0, -2.53,
H_LINE_TO, 4,
R_V_LINE_TO, -1.2,
H_LINE_TO, 2.8,
CLOSE,
R_MOVE_TO, 0, -2.53,
H_LINE_TO, 4,
V_LINE_TO, 6.19,
H_LINE_TO, 2.8,
CLOSE,
R_MOVE_TO, 0, -2.54,
H_LINE_TO, 4,
V_LINE_TO, 3.66,
H_LINE_TO, 2.8,
CLOSE,
R_MOVE_TO, 2.8, 7.6,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, -1.2,
H_LINE_TO, 5.6,
CLOSE,
R_MOVE_TO, 0, -2.53,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, -1.2,
H_LINE_TO, 5.6,
CLOSE,
R_MOVE_TO, 0, -2.53,
R_H_LINE_TO, 1.2,
V_LINE_TO, 6.19,
H_LINE_TO, 5.6,
CLOSE,
R_MOVE_TO, 0, -2.54,
R_H_LINE_TO, 1.2,
V_LINE_TO, 3.66,
H_LINE_TO, 5.6,
CLOSE,
MOVE_TO, 8, 12.46,
R_H_LINE_TO, 5.2,
V_LINE_TO, 6.06,
H_LINE_TO, 8,
R_V_LINE_TO, 1.34,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, 1.2,
H_LINE_TO, 8,
R_V_LINE_TO, 1.33,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, 1.2,
H_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 2.8, -3.87,
R_V_LINE_TO, -1.2,
H_LINE_TO, 12,
R_V_LINE_TO, 1.2,
CLOSE,
R_MOVE_TO, 0, 2.53,
R_V_LINE_TO, -1.2,
H_LINE_TO, 12,
R_V_LINE_TO, 1.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBusinessChromeRefreshRepList, kBusinessChromeRefreshIcon, {kBusinessChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCallPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20.01, 15.38,
R_CUBIC_TO, -1.23, 0, -2.42, -0.2, -3.53, -0.56,
R_CUBIC_TO, -0.35, -0.12, -0.74, -0.03, -1.01, 0.24,
R_LINE_TO, -1.57, 1.97,
R_CUBIC_TO, -2.83, -1.35, -5.48, -3.9, -6.89, -6.83,
R_LINE_TO, 1.95, -1.66,
R_CUBIC_TO, 0.27, -0.28, 0.35, -0.67, 0.24, -1.02,
R_CUBIC_TO, -0.37, -1.11, -0.56, -2.3, -0.56, -3.53,
R_CUBIC_TO, 0, -0.54, -0.45, -0.99, -0.99, -0.99,
H_LINE_TO, 4.19,
CUBIC_TO, 3.65, 3, 3, 3.24, 3, 3.99,
CUBIC_TO, 3, 13.28, 10.73, 21, 20.01, 21,
R_CUBIC_TO, 0.71, 0, 0.99, -0.63, 0.99, -1.18,
R_V_LINE_TO, -3.45,
R_CUBIC_TO, 0, -0.54, -0.45, -0.99, -0.99, -0.99,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCallRepList, kCallIcon, {kCallPath})
VECTOR_ICON_REP_TEMPLATE(kCallEndPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 23.62, 11.27,
R_CUBIC_TO, -2.03, -1.72, -4.46, -3, -7.12, -3.69,
CUBIC_TO, 15.06, 7.21, 13.56, 7, 12, 7,
R_CUBIC_TO, -1.56, 0, -3.06, 0.21, -4.5, 0.58,
R_CUBIC_TO, -2.66, 0.69, -5.08, 1.96, -7.12, 3.69,
R_CUBIC_TO, -0.45, 0.38, -0.5, 1.07, -0.08, 1.49,
R_LINE_TO, 0.67, 0.67,
R_LINE_TO, 2.26, 2.26,
R_CUBIC_TO, 0.33, 0.33, 0.85, 0.39, 1.25, 0.13,
R_LINE_TO, 2.56, -1.64,
R_CUBIC_TO, 0.29, -0.18, 0.46, -0.5, 0.46, -0.84,
V_LINE_TO, 9.65,
CUBIC_TO, 8.93, 9.23, 10.44, 9, 12, 9,
R_CUBIC_TO, 1.56, 0, 3.07, 0.23, 4.5, 0.65,
R_V_LINE_TO, 3.68,
R_CUBIC_TO, 0, 0.34, 0.17, 0.66, 0.46, 0.84,
R_LINE_TO, 2.56, 1.64,
R_CUBIC_TO, 0.4, 0.25, 0.92, 0.2, 1.25, -0.13,
R_LINE_TO, 2.26, -2.26,
R_LINE_TO, 0.67, -0.67,
R_CUBIC_TO, 0.41, -0.41, 0.37, -1.1, -0.08, -1.48,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCallEndRepList, kCallEndIcon, {kCallEndPath})
VECTOR_ICON_REP_TEMPLATE(kCallRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15.9, 17.13,
R_ARC_TO, 13.89, 13.89, 0, 0, 1, -4.9, -1.3,
R_ARC_TO, 14.17, 14.17, 0, 0, 1, -4.04, -2.84,
R_ARC_TO, 14.69, 14.69, 0, 0, 1, -2.84, -4.05,
R_ARC_TO, 13.54, 13.54, 0, 0, 1, -1.28, -4.89,
R_ARC_TO, 1.11, 1.11, 0, 0, 1, 0.3, -0.87,
R_CUBIC_TO, 0.23, -0.25, 0.52, -0.37, 0.86, -0.37,
R_H_LINE_TO, 2.83,
R_CUBIC_TO, 0.31, 0, 0.57, 0.09, 0.79, 0.25,
R_CUBIC_TO, 0.21, 0.17, 0.36, 0.4, 0.43, 0.71,
R_LINE_TO, 0.49, 2.13,
R_CUBIC_TO, 0.04, 0.22, 0.04, 0.43, -0.02, 0.63,
R_ARC_TO, 1.11, 1.11, 0, 0, 1, -0.32, 0.53,
R_LINE_TO, -2.05, 2,
R_CUBIC_TO, 0.56, 1, 1.23, 1.89, 2.03, 2.69,
R_ARC_TO, 12.11, 12.11, 0, 0, 0, 2.67, 2.01,
R_LINE_TO, 2.1, -2.02,
R_CUBIC_TO, 0.18, -0.17, 0.36, -0.28, 0.56, -0.32,
R_CUBIC_TO, 0.2, -0.04, 0.4, -0.04, 0.61, 0,
R_LINE_TO, 2.09, 0.47,
R_CUBIC_TO, 0.31, 0.07, 0.54, 0.22, 0.71, 0.43,
R_CUBIC_TO, 0.17, 0.22, 0.25, 0.48, 0.25, 0.79,
R_V_LINE_TO, 2.87,
R_CUBIC_TO, 0, 0.42, -0.15, 0.73, -0.44, 0.91,
R_CUBIC_TO, -0.29, 0.18, -0.57, 0.27, -0.82, 0.25,
CLOSE,
MOVE_TO, 5.34, 7.41,
LINE_TO, 6.8, 6,
R_LINE_TO, -0.35, -1.46,
H_LINE_TO, 4.61,
R_CUBIC_TO, 0.06, 0.5, 0.15, 0.99, 0.27, 1.47,
R_CUBIC_TO, 0.12, 0.48, 0.27, 0.95, 0.46, 1.41,
CLOSE,
R_MOVE_TO, 7.18, 7.18,
R_CUBIC_TO, 0.47, 0.19, 0.95, 0.34, 1.43, 0.45,
R_CUBIC_TO, 0.49, 0.11, 0.98, 0.21, 1.48, 0.28,
V_LINE_TO, 13.48,
R_LINE_TO, -1.46, -0.32,
CLOSE,
R_MOVE_TO, -7.18, -7.18,
CLOSE,
R_MOVE_TO, 7.18, 7.18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCallRefreshRepList, kCallRefreshIcon, {kCallRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCancelPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 2,
CUBIC_TO, 6.47, 2, 2, 6.47, 2, 12,
R_CUBIC_TO, 0, 5.53, 4.47, 10, 10, 10,
R_CUBIC_TO, 5.53, 0, 10, -4.47, 10, -10,
CUBIC_TO, 22, 6.47, 17.53, 2, 12, 2,
CLOSE,
MOVE_TO, 17, 15.59,
LINE_TO, 15.59, 17,
LINE_TO, 12, 13.41,
LINE_TO, 8.41, 17,
LINE_TO, 7, 15.59,
LINE_TO, 10.59, 12,
LINE_TO, 7, 8.41,
LINE_TO, 8.41, 7,
LINE_TO, 12, 10.59,
LINE_TO, 15.59, 7,
LINE_TO, 17, 8.41,
LINE_TO, 13.41, 12,
LINE_TO, 17, 15.59,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCancelRepList, kCancelIcon, {kCancelPath})
VECTOR_ICON_REP_TEMPLATE(kCancelChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.06, 14,
LINE_TO, 10, 11.06,
LINE_TO, 12.94, 14,
LINE_TO, 14, 12.94,
LINE_TO, 11.06, 10,
LINE_TO, 14, 7.06,
LINE_TO, 12.94, 6,
LINE_TO, 10, 8.94,
LINE_TO, 7.06, 6,
LINE_TO, 6, 7.06,
LINE_TO, 8.94, 10,
LINE_TO, 6, 12.94,
CLOSE,
MOVE_TO, 10, 18,
R_ARC_TO, 7.78, 7.78, 0, 0, 1, -3.1, -0.62,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -2.55, -1.72,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -1.72, -2.55,
ARC_TO, 7.78, 7.78, 0, 0, 1, 2, 10,
R_CUBIC_TO, 0, -1.11, 0.21, -2.15, 0.63, -3.11,
R_ARC_TO, 8.12, 8.12, 0, 0, 1, 1.72, -2.54,
R_CUBIC_TO, 0.73, -0.73, 1.58, -1.3, 2.55, -1.72,
ARC_TO, 7.78, 7.78, 0, 0, 1, 10, 2,
R_ARC_TO, 7.75, 7.75, 0, 0, 1, 3.11, 0.63,
R_ARC_TO, 8.12, 8.12, 0, 0, 1, 2.54, 1.72,
R_CUBIC_TO, 0.73, 0.73, 1.3, 1.58, 1.72, 2.54,
ARC_TO, 7.75, 7.75, 0, 0, 1, 18, 10,
R_ARC_TO, 7.78, 7.78, 0, 0, 1, -0.62, 3.11,
R_ARC_TO, 8.07, 8.07, 0, 0, 1, -1.72, 2.55,
R_CUBIC_TO, -0.73, 0.73, -1.58, 1.3, -2.54, 1.72,
ARC_TO, 7.75, 7.75, 0, 0, 1, 10, 18,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_CUBIC_TO, 1.81, 0, 3.34, -0.63, 4.61, -1.89,
CUBIC_TO, 15.87, 13.34, 16.5, 11.81, 16.5, 10,
R_CUBIC_TO, 0, -1.8, -0.63, -3.34, -1.89, -4.61,
CUBIC_TO, 13.34, 4.13, 11.81, 3.5, 10, 3.5,
R_CUBIC_TO, -1.8, 0, -3.34, 0.63, -4.61, 1.9,
CUBIC_TO, 4.13, 6.66, 3.5, 8.2, 3.5, 10,
R_CUBIC_TO, 0, 1.81, 0.63, 3.34, 1.9, 4.61,
CUBIC_TO, 6.66, 15.87, 8.2, 16.5, 10, 16.5,
CLOSE,
R_MOVE_TO, 0, -6.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCancelChromeRefreshRepList, kCancelChromeRefreshIcon, {kCancelChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCapturePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 1.83, 16.17,
V_LINE_TO, 3.83,
R_H_LINE_TO, 16.34,
R_V_LINE_TO, 12.34,
CLOSE,
R_MOVE_TO, 1.73, -1.73,
H_LINE_TO, 16.44,
V_LINE_TO, 5.56,
H_LINE_TO, 3.56,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 9.88,
V_LINE_TO, 7.06,
H_LINE_TO, 5.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCaptureRepList, kCaptureIcon, {kCapturePath})
VECTOR_ICON_REP_TEMPLATE(kCardboardPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4.29, 13.12,
R_H_LINE_TO, 3.3,
R_V_LINE_TO, -0.01,
R_LINE_TO, 0.66, -1.26,
R_CUBIC_TO, 0.18, -0.33, 0.42, -0.6, 0.73, -0.79,
ARC_TO, 1.91, 1.91, 0, 0, 1, 10, 10.77,
R_CUBIC_TO, 0.38, 0, 0.72, 0.09, 1.03, 0.28,
R_CUBIC_TO, 0.31, 0.19, 0.56, 0.45, 0.73, 0.78,
R_LINE_TO, 0.66, 1.28,
R_V_LINE_TO, 0.01,
R_H_LINE_TO, 3.3,
V_LINE_TO, 6.88,
H_LINE_TO, 4.29,
CLOSE,
R_MOVE_TO, 2.1, -1.56,
R_CUBIC_TO, 0.43, 0, 0.8, -0.15, 1.1, -0.46,
R_CUBIC_TO, 0.31, -0.31, 0.46, -0.68, 0.46, -1.11,
R_CUBIC_TO, 0, -0.43, -0.16, -0.8, -0.46, -1.1,
R_ARC_TO, 1.52, 1.52, 0, 0, 0, -1.11, -0.45,
R_CUBIC_TO, -0.43, 0, -0.8, 0.15, -1.1, 0.46,
R_ARC_TO, 1.52, 1.52, 0, 0, 0, -0.46, 1.11,
R_CUBIC_TO, 0, 0.43, 0.15, 0.8, 0.46, 1.1,
R_CUBIC_TO, 0.31, 0.3, 0.68, 0.45, 1.11, 0.45,
CLOSE,
R_MOVE_TO, -2.1, 3.13,
R_ARC_TO, 1.51, 1.51, 0, 0, 1, -1.1, -0.46,
R_ARC_TO, 1.52, 1.52, 0, 0, 1, -0.46, -1.1,
V_LINE_TO, 6.88,
R_CUBIC_TO, 0, -0.42, 0.16, -0.78, 0.46, -1.09,
R_CUBIC_TO, 0.31, -0.31, 0.68, -0.47, 1.09, -0.47,
R_H_LINE_TO, 11.43,
R_CUBIC_TO, 0.42, 0, 0.79, 0.16, 1.09, 0.47,
R_CUBIC_TO, 0.31, 0.31, 0.46, 0.68, 0.46, 1.1,
R_V_LINE_TO, 6.24,
R_CUBIC_TO, 0, 0.42, -0.16, 0.79, -0.46, 1.09,
R_ARC_TO, 1.5, 1.5, 0, 0, 1, -1.1, 0.47,
R_H_LINE_TO, -3.29,
R_CUBIC_TO, -0.3, 0, -0.58, -0.08, -0.83, -0.24,
R_ARC_TO, 1.52, 1.52, 0, 0, 1, -0.57, -0.61,
R_LINE_TO, -0.66, -1.26,
R_ARC_TO, 0.54, 0.54, 0, 0, 0, -0.16, -0.17,
R_ARC_TO, 0.37, 0.37, 0, 0, 0, -0.21, -0.07,
R_ARC_TO, 0.46, 0.46, 0, 0, 0, -0.38, 0.24,
R_LINE_TO, -0.64, 1.27,
R_CUBIC_TO, -0.12, 0.25, -0.31, 0.46, -0.57, 0.61,
R_CUBIC_TO, -0.25, 0.16, -0.53, 0.24, -0.83, 0.24,
CLOSE,
R_MOVE_TO, 9.34, -3.12,
R_CUBIC_TO, 0.43, 0, 0.8, -0.15, 1.1, -0.46,
R_CUBIC_TO, 0.3, -0.31, 0.46, -0.68, 0.46, -1.11,
R_CUBIC_TO, 0, -0.43, -0.15, -0.8, -0.46, -1.1,
R_ARC_TO, 1.52, 1.52, 0, 0, 0, -1.11, -0.45,
R_CUBIC_TO, -0.43, 0, -0.8, 0.15, -1.1, 0.46,
R_ARC_TO, 1.52, 1.52, 0, 0, 0, -0.46, 1.11,
R_CUBIC_TO, 0, 0.43, 0.16, 0.8, 0.46, 1.1,
R_CUBIC_TO, 0.31, 0.3, 0.68, 0.45, 1.11, 0.45,
CLOSE,
MOVE_TO, 10, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCardboardRepList, kCardboardIcon, {kCardboardPath})
VECTOR_ICON_REP_TEMPLATE(kCaretDownPath, CANVAS_DIMENSIONS, 32,
STROKE, 3,
MOVE_TO, 8.5, 12.5,
R_LINE_TO, 7.5, 8,
R_LINE_TO, 7.5, -8,
CLIP, 7, 11, 18, 11,)
VECTOR_ICON_REP_TEMPLATE(kCaretDown16Path, CANVAS_DIMENSIONS, 16,
STROKE, 1.765,
MOVE_TO, 4, 6,
R_LINE_TO, 4, 4,
R_LINE_TO, 4, -4,)
VECTOR_ICON_TEMPLATE_CC(kCaretDownRepList, kCaretDownIcon, {kCaretDownPath}, {kCaretDown16Path})
VECTOR_ICON_REP_TEMPLATE(kCaretUpPath, CANVAS_DIMENSIONS, 32,
CLIP, 7, 10, 18, 11,
STROKE, 3,
MOVE_TO, 8.5, 19.5,
R_LINE_TO, 7.5, -8,
R_LINE_TO, 7.5, 8,)
VECTOR_ICON_REP_TEMPLATE(kCaretUp16Path, CANVAS_DIMENSIONS, 16,
STROKE, 1.765,
MOVE_TO, 4, 10,
R_LINE_TO, 4, -4,
R_LINE_TO, 4, 4,)
VECTOR_ICON_TEMPLATE_CC(kCaretUpRepList, kCaretUpIcon, {kCaretUpPath}, {kCaretUp16Path})
VECTOR_ICON_REP_TEMPLATE(kCastPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 480, 480,
CLOSE,
R_MOVE_TO, 320, 320,
H_LINE_TO, 600,
R_QUADRATIC_TO, 0, -20, -1.5, -40,
R_QUADRATIC_TO, -1.5, -20, -4.5, -40,
R_H_LINE_TO, 206,
R_V_LINE_TO, -480,
H_LINE_TO, 160,
R_V_LINE_TO, 46,
R_QUADRATIC_TO, -20, -3, -40, -4.5,
QUADRATIC_TO_SHORTHAND, 80, 280,
R_V_LINE_TO, -40,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 160,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 240,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 800,
CLOSE,
R_MOVE_TO, -720, 0,
R_V_LINE_TO, -120,
R_QUADRATIC_TO, 50, 0, 85, 35,
R_QUADRATIC_TO, 35, 35, 35, 85,
H_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 200, 0,
R_QUADRATIC_TO, 0, -83, -58.5, -141.5,
QUADRATIC_TO_SHORTHAND, 80, 600,
R_V_LINE_TO, -80,
R_QUADRATIC_TO, 117, 0, 198.5, 81.5,
QUADRATIC_TO_SHORTHAND, 360, 800,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 160, 0,
R_QUADRATIC_TO, 0, -75, -28.5, -140.5,
R_QUADRATIC_TO, -28.5, -65.5, -77, -114,
R_QUADRATIC_TO, -48.5, -48.5, -114, -77,
QUADRATIC_TO_SHORTHAND, 80, 440,
R_V_LINE_TO, -80,
R_QUADRATIC_TO, 91, 0, 171, 34.5,
QUADRATIC_TO_SHORTHAND, 391, 489,
R_QUADRATIC_TO, 60, 60, 94.5, 140,
QUADRATIC_TO_SHORTHAND, 520, 800,
R_H_LINE_TO, -80,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCastRepList, kCastIcon, {kCastPath})
VECTOR_ICON_REP_TEMPLATE(kCastWarningPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, -8, 4,
R_CUBIC_TO, 0.56, 0, 1.03, 0.2, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -3,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 6.52, 13.43, 7, 14.61, 7, 16,
H_LINE_TO, 5.5,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 2, 12.5,
CLOSE,
R_MOVE_TO, 0, -3,
R_CUBIC_TO, 1.11, 0, 2.15, 0.21, 3.12, 0.63,
ARC_TO, 8.09, 8.09, 0, 0, 1, 7.66, 10.34,
R_ARC_TO, 8.09, 8.09, 0, 0, 1, 1.72, 2.54,
CUBIC_TO, 9.79, 13.85, 10, 14.89, 10, 16,
H_LINE_TO, 8.5,
R_ARC_TO, 6.3, 6.3, 0, 0, 0, -0.51, -2.53,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -1.39, -2.07,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -2.07, -1.39,
ARC_TO, 6.3, 6.3, 0, 0, 0, 2, 9.5,
CLOSE,
R_MOVE_TO, 14.5, 8,
R_H_LINE_TO, -5,
R_CUBIC_TO, 0, -0.25, -0.01, -0.5, -0.03, -0.75,
R_CUBIC_TO, -0.02, -0.25, -0.05, -0.5, -0.09, -0.75,
H_LINE_TO, 16.5,
R_V_LINE_TO, -3.87,
R_CUBIC_TO, 0.28, -0.1, 0.54, -0.23, 0.79, -0.37,
ARC_TO, 4.05, 4.05, 0, 0, 0, 18, 9.75,
R_V_LINE_TO, 4.75,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 16,
CLOSE,
MOVE_TO, 2, 6.5,
R_V_LINE_TO, -1,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 5.71,
R_ARC_TO, 5.64, 5.64, 0, 0, 0, -0.16, 0.73,
CUBIC_TO, 9.02, 4.98, 9, 5.24, 9, 5.5,
H_LINE_TO, 3.5,
R_V_LINE_TO, 1.13,
R_CUBIC_TO, -0.25, -0.04, -0.5, -0.07, -0.75, -0.09,
R_CUBIC_TO, -0.25, -0.02, -0.5, -0.03, -0.75, -0.03,
CLOSE,
R_MOVE_TO, 12.5, 3,
R_CUBIC_TO, -1.11, 0, -2.05, -0.39, -2.83, -1.17,
ARC_TO, 3.87, 3.87, 0, 0, 1, 10.5, 5.5,
R_CUBIC_TO, 0, -1.11, 0.39, -2.05, 1.17, -2.83,
ARC_TO, 3.87, 3.87, 0, 0, 1, 14.5, 1.5,
R_CUBIC_TO, 1.11, 0, 2.05, 0.39, 2.83, 1.17,
ARC_TO, 3.87, 3.87, 0, 0, 1, 18.5, 5.5,
R_CUBIC_TO, 0, 1.11, -0.39, 2.05, -1.17, 2.83,
ARC_TO, 3.87, 3.87, 0, 0, 1, 14.5, 9.5,
CLOSE,
R_MOVE_TO, 0, -2,
R_CUBIC_TO, 0.13, 0, 0.25, -0.05, 0.35, -0.15,
ARC_TO, 0.49, 0.49, 0, 0, 0, 15, 7,
R_CUBIC_TO, 0, -0.13, -0.05, -0.25, -0.15, -0.35,
ARC_TO, 0.49, 0.49, 0, 0, 0, 14.5, 6.5,
R_CUBIC_TO, -0.13, 0, -0.25, 0.05, -0.35, 0.15,
ARC_TO, 0.49, 0.49, 0, 0, 0, 14, 7,
R_CUBIC_TO, 0, 0.13, 0.05, 0.25, 0.15, 0.35,
R_ARC_TO, 0.49, 0.49, 0, 0, 0, 0.35, 0.15,
CLOSE,
R_MOVE_TO, -0.5, -2,
R_H_LINE_TO, 1,
R_V_LINE_TO, -2,
R_H_LINE_TO, -1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCastWarningRepList, kCastWarningIcon, {kCastWarningPath})
VECTOR_ICON_REP_TEMPLATE(kCelebrationPath, CANVAS_DIMENSIONS, 24,
NEW_PATH,
MOVE_TO, 2, 22,
R_LINE_TO, 14, -5,
LINE_TO, 7, 8,
LINE_TO, 2, 22,
CLOSE,
MOVE_TO, 12.35, 16.18,
LINE_TO, 5.3, 18.7,
R_LINE_TO, 2.52, -7.05,
LINE_TO, 12.35, 16.18,
CLOSE,
NEW_PATH,
MOVE_TO, 14.53, 12.53,
R_LINE_TO, 5.59, -5.59,
R_CUBIC_TO, 0.49, -0.49, 1.28, -0.49, 1.77, 0,
R_LINE_TO, 0.59, 0.59,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, -0.59, -0.59,
R_CUBIC_TO, -1.07, -1.07, -2.82, -1.07, -3.89, 0,
R_LINE_TO, -5.59, 5.59,
LINE_TO, 14.53, 12.53,
CLOSE,
NEW_PATH,
MOVE_TO, 10.06, 6.88,
LINE_TO, 9.47, 7.47,
R_LINE_TO, 1.06, 1.06,
R_LINE_TO, 0.59, -0.59,
R_CUBIC_TO, 1.07, -1.07, 1.07, -2.82, 0, -3.89,
R_LINE_TO, -0.59, -0.59,
LINE_TO, 9.47, 4.53,
R_LINE_TO, 0.59, 0.59,
CUBIC_TO, 10.54, 5.6, 10.54, 6.4, 10.06, 6.88,
CLOSE,
NEW_PATH,
MOVE_TO, 17.06, 11.88,
R_LINE_TO, -1.59, 1.59,
R_LINE_TO, 1.06, 1.06,
R_LINE_TO, 1.59, -1.59,
R_CUBIC_TO, 0.49, -0.49, 1.28, -0.49, 1.77, 0,
R_LINE_TO, 1.61, 1.61,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, -1.61, -1.61,
CUBIC_TO, 19.87, 10.81, 18.13, 10.81, 17.06, 11.88,
CLOSE,
NEW_PATH,
MOVE_TO, 15.06, 5.88,
R_LINE_TO, -3.59, 3.59,
R_LINE_TO, 1.06, 1.06,
R_LINE_TO, 3.59, -3.59,
R_CUBIC_TO, 1.07, -1.07, 1.07, -2.82, 0, -3.89,
R_LINE_TO, -1.59, -1.59,
R_LINE_TO, -1.06, 1.06,
R_LINE_TO, 1.59, 1.59,
CUBIC_TO, 15.54, 4.6, 15.54, 5.4, 15.06, 5.88,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCelebrationRepList, kCelebrationIcon, {kCelebrationPath})
VECTOR_ICON_REP_TEMPLATE(kCertificatePath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 16,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 2, 14.5,
V_LINE_TO, 5.49,
R_CUBIC_TO, 0, -0.41, 0.15, -0.76, 0.44, -1.05,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9.01,
R_CUBIC_TO, 0, 0.41, -0.15, 0.76, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 16,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 13,
V_LINE_TO, 7,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 5.63, -0.83,
R_LINE_TO, -2.83, -2.84,
LINE_TO, 7.36, 9.77,
R_LINE_TO, 1.77, 1.77,
LINE_TO, 12.65, 8,
R_LINE_TO, 1.06, 1.06,
CLOSE,
MOVE_TO, 3.5, 14.5,
R_V_LINE_TO, -9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCertificateRepList, kCertificateIcon, {kCertificatePath})
VECTOR_ICON_REP_TEMPLATE(kCertificateOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.73, 18.83,
LINE_TO, 13.88, 16,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.42, 0, -0.77, -0.14, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 14.5,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.42, 0.15, -0.77, 0.46, -1.06,
ARC_TO, 1.55, 1.55, 0, 0, 1, 3.56, 4,
R_H_LINE_TO, 0.23,
R_V_LINE_TO, 1.9,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 3.5, 14.5,
R_H_LINE_TO, 8.88,
LINE_TO, 4.88, 7,
H_LINE_TO, 3.5,
CLOSE,
R_MOVE_TO, 14.13, 1,
LINE_TO, 16.5, 14.38,
V_LINE_TO, 7,
H_LINE_TO, 9.13,
R_LINE_TO, -3, -3,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.42, 0, 0.77, 0.14, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.64, 0.44, 1.06,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.2, -0.04, 0.38, -0.1, 0.56,
R_CUBIC_TO, -0.07, 0.18, -0.16, 0.33, -0.27, 0.44,
CLOSE,
R_MOVE_TO, -5.17, -5.17,
LINE_TO, 11.4, 9.27,
LINE_TO, 12.65, 8,
R_LINE_TO, 1.06, 1.06,
CLOSE,
R_MOVE_TO, -1.06, 1.06,
R_LINE_TO, -2.27, 2.27,
R_LINE_TO, -2.83, -2.84,
LINE_TO, 7.36, 9.77,
R_LINE_TO, 1.77, 1.77,
R_LINE_TO, 1.21, -1.21,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCertificateOffRepList, kCertificateOffIcon, {kCertificateOffPath})
VECTOR_ICON_REP_TEMPLATE(kChatPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 5, 12,
R_H_LINE_TO, 7,
R_V_LINE_TO, -1.5,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 0, -2.75,
R_H_LINE_TO, 10,
R_V_LINE_TO, -1.5,
H_LINE_TO, 5,
CLOSE,
MOVE_TO, 5, 6.5,
R_H_LINE_TO, 10,
V_LINE_TO, 5,
H_LINE_TO, 5,
CLOSE,
MOVE_TO, 2, 18,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 2,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 2.38, -4.5,
H_LINE_TO, 16.5,
R_V_LINE_TO, -10,
R_H_LINE_TO, -13,
R_V_LINE_TO, 10.88,
CLOSE,
R_MOVE_TO, -0.87, 0,
R_V_LINE_TO, -10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChatRepList, kChatIcon, {kChatPath})
VECTOR_ICON_REP_TEMPLATE(kChatSparkPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14.5, 10,
R_CUBIC_TO, 0, -1.25, -0.44, -2.32, -1.31, -3.19,
CUBIC_TO, 12.32, 5.94, 11.25, 5.5, 10, 5.5,
R_CUBIC_TO, 1.25, 0, 2.32, -0.44, 3.19, -1.31,
CUBIC_TO, 14.06, 3.32, 14.5, 2.25, 14.5, 1,
R_CUBIC_TO, 0, 1.25, 0.44, 2.32, 1.31, 3.19,
CUBIC_TO, 16.68, 5.06, 17.75, 5.5, 19, 5.5,
R_CUBIC_TO, -1.25, 0, -2.32, 0.44, -3.19, 1.31,
CUBIC_TO, 14.94, 7.68, 14.5, 8.75, 14.5, 10,
CLOSE,
MOVE_TO, 2, 18,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.44, -1.05,
CUBIC_TO, 2.73, 2.15, 3.09, 2, 3.5, 2,
H_LINE_TO, 11,
R_V_LINE_TO, 1.5,
H_LINE_TO, 3.5,
R_V_LINE_TO, 10.88,
R_LINE_TO, 0.88, -0.87,
H_LINE_TO, 16.5,
V_LINE_TO, 9,
H_LINE_TO, 18,
R_V_LINE_TO, 4.51,
R_CUBIC_TO, 0, 0.41, -0.15, 0.76, -0.45, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 16.5, 15,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 3, -6,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 8,
V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, 0, -2.75,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 7,
R_V_LINE_TO, 1.5,
CLOSE,
MOVE_TO, 5, 6.5,
V_LINE_TO, 5,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChatSparkRepList, kChatSparkIcon, {kChatSparkPath})
VECTOR_ICON_REP_TEMPLATE(kCheckCirclePath, CIRCLE, 24, 24, 20,
MOVE_TO, 20, 34,
LINE_TO, 10, 24,
R_LINE_TO, 2.83, -2.83,
LINE_TO, 20, 28.34,
R_LINE_TO, 15.17, -15.17,
LINE_TO, 38, 16,
LINE_TO, 20, 34)
VECTOR_ICON_TEMPLATE_CC(kCheckCircleRepList, kCheckCircleIcon, {kCheckCirclePath})
VECTOR_ICON_REP_TEMPLATE(kChecklistPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5.55, 19,
LINE_TO, 2, 15.45,
R_LINE_TO, 1.4, -1.4,
R_LINE_TO, 2.13, 2.13,
R_LINE_TO, 4.25, -4.25,
R_LINE_TO, 1.4, 1.43,
CLOSE,
R_MOVE_TO, 0, -8,
LINE_TO, 2, 7.45,
R_LINE_TO, 1.4, -1.4,
R_LINE_TO, 2.13, 2.13,
R_LINE_TO, 4.25, -4.25,
R_LINE_TO, 1.4, 1.43,
CLOSE,
MOVE_TO, 13, 17,
R_V_LINE_TO, -2,
R_H_LINE_TO, 9,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -8,
V_LINE_TO, 7,
R_H_LINE_TO, 9,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChecklistRepList, kChecklistIcon, {kChecklistPath})
VECTOR_ICON_REP_TEMPLATE(kClosePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 6.41,
LINE_TO, 17.59, 5,
LINE_TO, 12, 10.59,
LINE_TO, 6.41, 5,
LINE_TO, 5, 6.41,
LINE_TO, 10.59, 12,
LINE_TO, 5, 17.59,
LINE_TO, 6.41, 19,
LINE_TO, 12, 13.41,
LINE_TO, 17.59, 19,
LINE_TO, 19, 17.59,
LINE_TO, 13.41, 12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kClose16Path, CANVAS_DIMENSIONS, 16,
STROKE, 1.85,
MOVE_TO, 4, 4,
R_LINE_TO, 8, 8,
MOVE_TO, 4, 12,
R_LINE_TO, 8, -8)
VECTOR_ICON_TEMPLATE_CC(kCloseRepList, kCloseIcon, {kClosePath}, {kClose16Path})
VECTOR_ICON_REP_TEMPLATE(kCloseChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.06, 15,
LINE_TO, 5, 13.94,
LINE_TO, 8.94, 10,
LINE_TO, 5, 6.06,
LINE_TO, 6.06, 5,
LINE_TO, 10, 8.94,
LINE_TO, 13.94, 5,
LINE_TO, 15, 6.06,
LINE_TO, 11.06, 10,
LINE_TO, 15, 13.94,
LINE_TO, 13.94, 15,
LINE_TO, 10, 11.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCloseChromeRefreshRepList, kCloseChromeRefreshIcon, {kCloseChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCloseRoundedPath, CANVAS_DIMENSIONS, 32,
STROKE, 3.5,
MOVE_TO, 8.75, 8.75,
R_LINE_TO, 14.5, 14.5,
MOVE_TO, 8.75, 23.25,
R_LINE_TO, 14.5, -14.5)
VECTOR_ICON_REP_TEMPLATE(kCloseRounded16Path, CANVAS_DIMENSIONS, 16,
STROKE, 1.85,
MOVE_TO, 4, 4,
R_LINE_TO, 8, 8,
MOVE_TO, 4, 12,
R_LINE_TO, 8, -8)
VECTOR_ICON_TEMPLATE_CC(kCloseRoundedRepList, kCloseRoundedIcon, {kCloseRoundedPath}, {kCloseRounded16Path})
VECTOR_ICON_REP_TEMPLATE(kCloseSmallPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.04, 14,
LINE_TO, 6, 12.96,
LINE_TO, 8.94, 10,
LINE_TO, 6, 7.06,
LINE_TO, 7.04, 6.02,
LINE_TO, 10, 8.96,
R_LINE_TO, 2.94, -2.94,
R_LINE_TO, 1.04, 1.04,
LINE_TO, 11.04, 10,
R_LINE_TO, 2.94, 2.96,
LINE_TO, 12.94, 14,
LINE_TO, 10, 11.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCloseSmallRepList, kCloseSmallIcon, {kCloseSmallPath})
VECTOR_ICON_REP_TEMPLATE(kCodePath, MOVE_TO, 18.8, 33.2,
LINE_TO, 9.7, 24,
R_LINE_TO, 9.2, -9.2,
LINE_TO, 16, 12,
LINE_TO, 4, 24,
R_LINE_TO, 12, 12,
R_LINE_TO, 2.8, -2.8,
CLOSE,
R_MOVE_TO, 10.4, 0,
R_LINE_TO, 9.2, -9.2,
R_LINE_TO, -9.2, -9.2,
LINE_TO, 32, 12,
R_LINE_TO, 12, 12,
R_LINE_TO, -12, 12,
R_LINE_TO, -2.8, -2.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCodeRepList, kCodeIcon, {kCodePath})
VECTOR_ICON_REP_TEMPLATE(kCodeChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 7, 15,
R_LINE_TO, -5, -5,
R_LINE_TO, 5, -5,
R_LINE_TO, 1.06, 1.06,
LINE_TO, 4.12, 10,
R_LINE_TO, 3.94, 3.94,
CLOSE,
R_MOVE_TO, 6, 0,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 15.88, 10,
R_LINE_TO, -3.94, -3.94,
LINE_TO, 13, 5,
R_LINE_TO, 5, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCodeChromeRefreshRepList, kCodeChromeRefreshIcon, {kCodeChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCodeOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16, 18.13,
R_LINE_TO, -10, -10,
LINE_TO, 4.13, 10,
R_LINE_TO, 3.94, 3.94,
LINE_TO, 7, 15,
R_LINE_TO, -5, -5,
R_LINE_TO, 2.94, -2.94,
LINE_TO, 1.87, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -0.94, -5.19,
LINE_TO, 14, 11.88,
LINE_TO, 15.88, 10,
R_LINE_TO, -3.94, -3.94,
LINE_TO, 13, 5,
R_LINE_TO, 5, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCodeOffChromeRefreshRepList, kCodeOffChromeRefreshIcon, {kCodeOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kContentCopyPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9, 18,
R_QUADRATIC_TO, -0.82, 0, -1.41, -0.59,
QUADRATIC_TO, 7, 16.83, 7, 16,
V_LINE_TO, 4,
R_QUADRATIC_TO, 0, -0.82, 0.59, -1.41,
QUADRATIC_TO, 8.18, 2, 9, 2,
R_H_LINE_TO, 9,
R_QUADRATIC_TO, 0.83, 0, 1.41, 0.59,
QUADRATIC_TO, 20, 3.18, 20, 4,
R_V_LINE_TO, 12,
R_QUADRATIC_TO, 0, 0.83, -0.59, 1.41,
QUADRATIC_TO, 18.83, 18, 18, 18,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 9,
V_LINE_TO, 4,
H_LINE_TO, 9,
R_V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, -4, 6,
R_QUADRATIC_TO, -0.82, 0, -1.41, -0.59,
QUADRATIC_TO, 3, 20.83, 3, 20,
V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 14,
R_H_LINE_TO, 11,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 9, 4,
R_V_LINE_TO, 12,
V_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kContentCopyRepList, kContentCopyIcon, {kContentCopyPath})
VECTOR_ICON_REP_TEMPLATE(kContentPastePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 21,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 3, 19,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 3.98, 3.2, 4.45, 3, 5, 3,
R_H_LINE_TO, 4.18,
R_ARC_TO, 2.72, 2.72, 0, 0, 1, 1.07, -1.44,
ARC_TO, 2.98, 2.98, 0, 0, 1, 12, 1,
R_CUBIC_TO, 0.67, 0, 1.26, 0.19, 1.79, 0.56,
R_CUBIC_TO, 0.52, 0.38, 0.88, 0.86, 1.06, 1.44,
H_LINE_TO, 19,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
R_CUBIC_TO, -0.39, 0.39, -0.86, 0.59, -1.41, 0.59,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 14,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 3,
H_LINE_TO, 7,
V_LINE_TO, 5,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 7, -14,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 13, 4,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 0, 12, 3,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 11, 4,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kContentPaste20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
R_H_LINE_TO, 3.56,
R_CUBIC_TO, 0.11, -0.43, 0.34, -0.79, 0.7, -1.07,
ARC_TO, 1.91, 1.91, 0, 0, 1, 10, 1.5,
R_CUBIC_TO, 0.47, 0, 0.89, 0.14, 1.24, 0.43,
R_CUBIC_TO, 0.36, 0.28, 0.59, 0.64, 0.7, 1.07,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 15.5, 17,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
R_V_LINE_TO, -11,
H_LINE_TO, 14,
V_LINE_TO, 7,
H_LINE_TO, 6,
V_LINE_TO, 4.5,
H_LINE_TO, 4.5,
CLOSE,
R_MOVE_TO, 5.5, -11,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
ARC_TO, 0.72, 0.72, 0, 0, 0, 10, 3,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kContentPasteRepList, kContentPasteIcon, {kContentPastePath}, {kContentPaste20Path})
VECTOR_ICON_REP_TEMPLATE(kContentPasteOffPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
R_MOVE_TO, 21, 18.15,
R_LINE_TO, -2, -2,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 3,
R_H_LINE_TO, -6.15,
R_LINE_TO, -5, -5,
R_H_LINE_TO, 3.32,
R_ARC_TO, 2.72, 2.72, 0, 0, 1, 1.07, -1.44,
ARC_TO, 2.98, 2.98, 0, 0, 1, 12, 1,
R_CUBIC_TO, 0.67, 0, 1.26, 0.19, 1.79, 0.56,
R_CUBIC_TO, 0.52, 0.38, 0.88, 0.86, 1.06, 1.44,
H_LINE_TO, 19,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
CLOSE,
MOVE_TO, 12, 5,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 13, 4,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 0, 12, 3,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 11, 4,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, 4.15, 14,
LINE_TO, 5, 7.85,
V_LINE_TO, 19,
CLOSE,
MOVE_TO, 5, 21,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 3, 19,
V_LINE_TO, 5.85,
LINE_TO, 1.38, 4.23,
LINE_TO, 2.8, 2.8,
R_LINE_TO, 18.4, 18.4,
R_LINE_TO, -1.43, 1.43,
LINE_TO, 18.15, 21,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kContentPasteOff20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 17, 14.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 4.5,
H_LINE_TO, 14,
V_LINE_TO, 7,
H_LINE_TO, 9.13,
R_LINE_TO, -4, -4,
R_H_LINE_TO, 2.94,
R_CUBIC_TO, 0.15, -0.44, 0.39, -0.8, 0.72, -1.08,
CUBIC_TO, 9.11, 1.64, 9.52, 1.5, 10, 1.5,
R_CUBIC_TO, 0.48, 0, 0.9, 0.14, 1.23, 0.41,
R_CUBIC_TO, 0.33, 0.27, 0.57, 0.64, 0.71, 1.09,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE,
MOVE_TO, 10, 4.5,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
ARC_TO, 0.72, 0.72, 0, 0, 0, 10, 3,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
R_MOVE_TO, 3.38, 11,
LINE_TO, 4.5, 6.63,
V_LINE_TO, 15.5,
CLOSE,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 5.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
LINE_TO, 16, 18.13,
LINE_TO, 14.88, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kContentPasteOffRepList, kContentPasteOffIcon, {kContentPasteOffPath}, {kContentPasteOff20Path})
VECTOR_ICON_REP_TEMPLATE(kCookiePath, MOVE_TO, 31, 15,
LINE_TO, 31, 14,
CUBIC_TO, 31, 12.04, 30, 11, 28, 11,
LINE_TO, 27, 11,
CUBIC_TO, 26.45, 11, 26, 10.55, 26, 10,
LINE_TO, 26, 6,
CUBIC_TO, 26, 4.04, 24, 4, 24, 4,
CUBIC_TO, 12.6, 4, 3.42, 13.54, 4.03, 25.08,
CUBIC_TO, 4.56, 35.17, 12.83, 43.44, 22.92, 43.97,
CUBIC_TO, 34.46, 44.58, 44, 35.4, 44, 24,
LINE_TO, 44, 22,
CUBIC_TO, 44, 20.9, 43.11, 20, 42, 20,
LINE_TO, 38, 20,
CUBIC_TO, 37.45, 20, 37, 19.55, 37, 19,
LINE_TO, 37, 18,
CUBIC_TO, 37, 16.13, 36.04, 15.04, 34, 15,
LINE_TO, 31, 15,
LINE_TO, 31, 15,
CLOSE,
MOVE_TO, 11.59, 24.94,
CUBIC_TO, 9.47, 25.35, 7.66, 23.53, 8.06, 21.41,
CUBIC_TO, 8.28, 20.24, 9.24, 19.28, 10.41, 19.06,
CUBIC_TO, 12.53, 18.66, 14.35, 20.47, 13.94, 22.59,
CUBIC_TO, 13.72, 23.76, 12.76, 24.72, 11.59, 24.94,
LINE_TO, 11.59, 24.94,
CLOSE,
MOVE_TO, 15.06, 14.59,
CUBIC_TO, 14.66, 12.47, 16.47, 10.66, 18.59, 11.06,
CUBIC_TO, 19.76, 11.28, 20.72, 12.24, 20.94, 13.41,
CUBIC_TO, 21.35, 15.53, 19.53, 17.35, 17.41, 16.94,
CUBIC_TO, 16.24, 16.72, 15.28, 15.76, 15.06, 14.59,
LINE_TO, 15.06, 14.59,
CLOSE,
MOVE_TO, 22.59, 38.94,
CUBIC_TO, 20.47, 39.35, 18.66, 37.53, 19.06, 35.41,
CUBIC_TO, 19.28, 34.24, 20.24, 33.28, 21.41, 33.06,
CUBIC_TO, 23.53, 32.66, 25.35, 34.47, 24.94, 36.59,
CUBIC_TO, 24.72, 37.76, 23.76, 38.72, 22.59, 38.94,
LINE_TO, 22.59, 38.94,
CLOSE,
MOVE_TO, 23, 28,
CUBIC_TO, 21.34, 28, 20, 26.66, 20, 25,
CUBIC_TO, 20, 23.34, 21.34, 22, 23, 22,
CUBIC_TO, 24.66, 22, 26, 23.34, 26, 25,
CUBIC_TO, 26, 26.66, 24.66, 28, 23, 28,
LINE_TO, 23, 28,
CLOSE,
MOVE_TO, 33, 32,
CUBIC_TO, 31.34, 32, 30, 30.66, 30, 29,
CUBIC_TO, 30, 27.34, 31.34, 26, 33, 26,
CUBIC_TO, 34.66, 26, 36, 27.34, 36, 29,
CUBIC_TO, 36, 30.66, 34.66, 32, 33, 32,
LINE_TO, 33, 32,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCookieRepList, kCookieIcon, {kCookiePath})
VECTOR_ICON_REP_TEMPLATE(kCookieChromeRefreshPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 10.5, 10,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.64, 0.44, -1.06,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 10.5, 7,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 9, 8.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.06, 0.44,
CLOSE,
R_MOVE_TO, -2, 5,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.64, 0.44, -1.06,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 8.5, 12,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 7, 13.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.06, 0.44,
CLOSE,
R_MOVE_TO, 6.5, 1,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 16, 15,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 0, 15, 14,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, -3, 6.14,
R_ARC_TO, 9.89, 9.89, 0, 0, 1, -3.95, -0.8,
R_ARC_TO, 10.2, 10.2, 0, 0, 1, -3.22, -2.17,
R_ARC_TO, 10.2, 10.2, 0, 0, 1, -2.17, -3.22,
ARC_TO, 9.89, 9.89, 0, 0, 1, 1.86, 12,
R_CUBIC_TO, 0, -1.48, 0.32, -2.89, 0.95, -4.25,
R_ARC_TO, 10.3, 10.3, 0, 0, 1, 2.62, -3.48,
R_CUBIC_TO, 1.11, -0.96, 2.42, -1.66, 3.93, -2.1,
R_CUBIC_TO, 1.5, -0.43, 3.13, -0.46, 4.88, -0.08,
R_CUBIC_TO, -0.16, 0.76, -0.12, 1.47, 0.11, 2.13,
R_CUBIC_TO, 0.23, 0.66, 0.59, 1.21, 1.07, 1.65,
R_CUBIC_TO, 0.49, 0.45, 1.07, 0.75, 1.76, 0.91,
R_CUBIC_TO, 0.68, 0.16, 1.41, 0.13, 2.18, -0.12,
R_CUBIC_TO, -0.48, 1.15, -0.38, 2.14, 0.28, 2.95,
R_CUBIC_TO, 0.67, 0.82, 1.48, 1.23, 2.43, 1.24,
R_CUBIC_TO, 0.16, 1.51, 0.01, 2.95, -0.45, 4.32,
R_CUBIC_TO, -0.46, 1.36, -1.15, 2.56, -2.07, 3.59,
R_ARC_TO, 10.28, 10.28, 0, 0, 1, -3.32, 2.45,
R_CUBIC_TO, -1.3, 0.61, -2.71, 0.91, -4.23, 0.91,
CLOSE,
R_MOVE_TO, 0, -2.27,
R_CUBIC_TO, 1.98, 0, 3.75, -0.68, 5.29, -2.03,
R_CUBIC_TO, 1.54, -1.35, 2.39, -3.09, 2.56, -5.19,
R_CUBIC_TO, -0.81, -0.37, -1.45, -0.87, -1.92, -1.5,
R_ARC_TO, 5.38, 5.38, 0, 0, 1, -0.96, -2.09,
R_ARC_TO, 5.84, 5.84, 0, 0, 1, -3.28, -1.65,
R_ARC_TO, 5.97, 5.97, 0, 0, 1, -1.73, -3.27,
R_CUBIC_TO, -1.26, -0.02, -2.38, 0.23, -3.35, 0.72,
R_ARC_TO, 7.97, 7.97, 0, 0, 0, -2.45, 1.91,
R_ARC_TO, 8.47, 8.47, 0, 0, 0, -1.5, 2.56,
R_CUBIC_TO, -0.34, 0.93, -0.51, 1.82, -0.51, 2.68,
R_CUBIC_TO, 0, 2.18, 0.77, 4.04, 2.3, 5.57,
R_CUBIC_TO, 1.53, 1.53, 3.39, 2.3, 5.57, 2.3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCookieChromeRefresh20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 8.75, 8.5,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
ARC_TO, 1.22, 1.22, 0, 0, 0, 8.75, 6,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
R_MOVE_TO, -2, 4,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
ARC_TO, 1.22, 1.22, 0, 0, 0, 6.75, 10,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
R_MOVE_TO, 5.75, 0.75,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.53, -0.22,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
MOVE_TO, 10, 18.11,
R_ARC_TO, 7.92, 7.92, 0, 0, 1, -3.15, -0.63,
R_ARC_TO, 8.16, 8.16, 0, 0, 1, -4.33, -4.33,
ARC_TO, 7.92, 7.92, 0, 0, 1, 1.89, 10,
R_CUBIC_TO, 0, -1.35, 0.29, -2.59, 0.89, -3.72,
R_CUBIC_TO, 0.59, -1.12, 1.36, -2.05, 2.31, -2.79,
ARC_TO, 8.23, 8.23, 0, 0, 1, 8.27, 1.98,
R_ARC_TO, 6.82, 6.82, 0, 0, 1, 3.53, 0.1,
R_CUBIC_TO, -0.11, 0.62, -0.09, 1.19, 0.08, 1.7,
R_CUBIC_TO, 0.16, 0.51, 0.44, 0.94, 0.82, 1.27,
R_CUBIC_TO, 0.38, 0.33, 0.84, 0.57, 1.4, 0.7,
R_CUBIC_TO, 0.56, 0.13, 1.15, 0.13, 1.8, -0.02,
R_CUBIC_TO, -0.32, 0.79, -0.26, 1.55, 0.16, 2.27,
R_CUBIC_TO, 0.43, 0.72, 1.1, 1.08, 2.01, 1.09,
R_ARC_TO, 7.82, 7.82, 0, 0, 1, -0.36, 3.44,
R_ARC_TO, 8.37, 8.37, 0, 0, 1, -1.66, 2.88,
R_ARC_TO, 8.21, 8.21, 0, 0, 1, -2.66, 1.98,
R_CUBIC_TO, -1.04, 0.49, -2.17, 0.74, -3.39, 0.74,
CLOSE,
R_MOVE_TO, 0, -1.73,
R_CUBIC_TO, 1.7, 0, 3.15, -0.57, 4.36, -1.71,
R_CUBIC_TO, 1.21, -1.14, 1.88, -2.55, 2.01, -4.24,
R_ARC_TO, 3.8, 3.8, 0, 0, 1, -1.53, -1.16,
R_ARC_TO, 3.86, 3.86, 0, 0, 1, -0.79, -1.75,
R_ARC_TO, 4.86, 4.86, 0, 0, 1, -2.67, -1.31,
R_ARC_TO, 4.42, 4.42, 0, 0, 1, -1.34, -2.6,
R_ARC_TO, 5.58, 5.58, 0, 0, 0, -2.37, 0.41,
R_CUBIC_TO, -0.77, 0.31, -1.46, 0.75, -2.06, 1.32,
R_ARC_TO, 6.35, 6.35, 0, 0, 0, -1.45, 2.05,
ARC_TO, 6.23, 6.23, 0, 0, 0, 3.61, 10,
R_CUBIC_TO, 0, 1.77, 0.63, 3.28, 1.87, 4.52,
R_CUBIC_TO, 1.24, 1.24, 2.75, 1.87, 4.52, 1.87,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCookieChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7, 6.8,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 8, 5.8,
R_ARC_TO, 0.97, 0.97, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.97, 0.97, 0, 0, 0, 7, 4.8,
R_ARC_TO, 0.97, 0.97, 0, 0, 0, -0.71, 0.29,
ARC_TO, 0.97, 0.97, 0, 0, 0, 6, 5.8,
R_CUBIC_TO, 0, 0.28, 0.1, 0.51, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.2, 0.43, 0.29, 0.71, 0.29,
CLOSE,
MOVE_TO, 5.4, 10,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, 0.71, -0.29,
ARC_TO, 0.95, 0.95, 0, 0, 0, 6.4, 9,
R_ARC_TO, 0.95, 0.95, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 0, 5.4, 8,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.2, 0.2, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, 4.6, 0.6,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, 0.43, -0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, 0.18, -0.43,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.17, -0.43,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.43, -0.18,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.43, 0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.18, 0.43,
R_CUBIC_TO, 0, 0.17, 0.06, 0.31, 0.17, 0.43,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, 0.43, 0.18,
CLOSE,
MOVE_TO, 8, 14.62,
R_CUBIC_TO, -0.91, 0, -1.77, -0.17, -2.57, -0.51,
R_ARC_TO, 6.61, 6.61, 0, 0, 1, -2.11, -1.42,
R_ARC_TO, 6.61, 6.61, 0, 0, 1, -1.42, -2.11,
ARC_TO, 6.46, 6.46, 0, 0, 1, 1.38, 8,
R_CUBIC_TO, 0, -1.15, 0.25, -2.19, 0.75, -3.11,
ARC_TO, 6.85, 6.85, 0, 0, 1, 4.08, 2.63,
ARC_TO, 6.79, 6.79, 0, 0, 1, 6.73, 1.44,
R_ARC_TO, 5.67, 5.67, 0, 0, 1, 2.86, 0.12,
R_CUBIC_TO, -0.09, 0.51, -0.09, 0.97, 0.03, 1.38,
R_CUBIC_TO, 0.11, 0.41, 0.32, 0.75, 0.61, 1.01,
R_CUBIC_TO, 0.29, 0.26, 0.66, 0.45, 1.1, 0.55,
R_CUBIC_TO, 0.44, 0.1, 0.93, 0.1, 1.47, -0.01,
R_CUBIC_TO, -0.22, 0.64, -0.18, 1.24, 0.14, 1.82,
R_CUBIC_TO, 0.32, 0.57, 0.86, 0.86, 1.64, 0.84,
R_ARC_TO, 6.49, 6.49, 0, 0, 1, -0.26, 2.83,
R_ARC_TO, 6.79, 6.79, 0, 0, 1, -1.34, 2.38,
ARC_TO, 6.68, 6.68, 0, 0, 1, 10.79, 14,
R_CUBIC_TO, -0.85, 0.41, -1.78, 0.62, -2.79, 0.62,
CLOSE,
R_MOVE_TO, 0, -1.63,
R_CUBIC_TO, 1.31, 0, 2.44, -0.44, 3.37, -1.3,
R_CUBIC_TO, 0.94, -0.87, 1.47, -1.95, 1.58, -3.25,
R_ARC_TO, 3.13, 3.13, 0, 0, 1, -1.18, -0.92,
R_ARC_TO, 3.05, 3.05, 0, 0, 1, -0.63, -1.37,
ARC_TO, 4.05, 4.05, 0, 0, 1, 9.03, 5.09,
ARC_TO, 3.55, 3.55, 0, 0, 1, 7.93, 3.04,
R_ARC_TO, 4.47, 4.47, 0, 0, 0, -1.75, 0.32,
R_CUBIC_TO, -0.58, 0.23, -1.11, 0.56, -1.58, 0.99,
R_CUBIC_TO, -0.47, 0.43, -0.86, 0.95, -1.14, 1.57,
R_CUBIC_TO, -0.29, 0.62, -0.43, 1.31, -0.43, 2.07,
R_CUBIC_TO, 0, 1.38, 0.49, 2.56, 1.46, 3.53,
R_CUBIC_TO, 0.97, 0.97, 2.15, 1.46, 3.53, 1.46,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCookieChromeRefreshRepList, kCookieChromeRefreshIcon, {kCookieChromeRefreshPath}, {kCookieChromeRefresh20Path}, {kCookieChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kCookieOffChromeRefreshPath, CANVAS_DIMENSIONS, 24,
R_MOVE_TO, 20.55, 17.47,
R_LINE_TO, -1.66, -1.66,
R_CUBIC_TO, 0.26, -0.47, 0.48, -0.98, 0.64, -1.51,
R_CUBIC_TO, 0.16, -0.53, 0.27, -1.09, 0.32, -1.66,
R_CUBIC_TO, -0.81, -0.37, -1.45, -0.87, -1.92, -1.5,
R_ARC_TO, 5.38, 5.38, 0, 0, 1, -0.96, -2.09,
R_ARC_TO, 5.84, 5.84, 0, 0, 1, -3.28, -1.65,
R_ARC_TO, 5.97, 5.97, 0, 0, 1, -1.73, -3.27,
R_ARC_TO, 6.8, 6.8, 0, 0, 0, -2.04, 0.24,
R_ARC_TO, 7.57, 7.57, 0, 0, 0, -1.74, 0.73,
R_LINE_TO, -1.64, -1.64,
R_CUBIC_TO, 1.05, -0.7, 2.22, -1.18, 3.52, -1.44,
R_CUBIC_TO, 1.3, -0.26, 2.7, -0.23, 4.18, 0.08,
R_CUBIC_TO, -0.16, 0.76, -0.12, 1.47, 0.11, 2.13,
R_CUBIC_TO, 0.23, 0.66, 0.59, 1.21, 1.07, 1.65,
R_CUBIC_TO, 0.49, 0.45, 1.07, 0.75, 1.76, 0.91,
R_CUBIC_TO, 0.68, 0.16, 1.41, 0.13, 2.18, -0.12,
R_CUBIC_TO, -0.48, 1.15, -0.38, 2.14, 0.28, 2.95,
R_CUBIC_TO, 0.67, 0.82, 1.48, 1.23, 2.43, 1.24,
R_ARC_TO, 9.48, 9.48, 0, 0, 1, -0.21, 3.5,
R_ARC_TO, 10.67, 10.67, 0, 0, 1, -1.32, 3.1,
CLOSE,
MOVE_TO, 8.5, 15,
R_CUBIC_TO, -0.42, 0, -0.77, -0.14, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 7, 13.5,
R_CUBIC_TO, 0, -0.42, 0.14, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 12,
R_CUBIC_TO, 0.42, 0, 0.77, 0.14, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.64, 0.44, 1.06,
R_CUBIC_TO, 0, 0.42, -0.14, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 15,
CLOSE,
R_MOVE_TO, 12.07, 8.43,
R_LINE_TO, -2.92, -2.91,
R_CUBIC_TO, -0.82, 0.55, -1.7, 0.97, -2.64, 1.25,
R_CUBIC_TO, -0.95, 0.29, -1.95, 0.44, -3.01, 0.44,
R_CUBIC_TO, -1.41, 0, -2.74, -0.26, -3.98, -0.8,
R_ARC_TO, 10.38, 10.38, 0, 0, 1, -3.24, -2.17,
R_CUBIC_TO, -0.91, -0.92, -1.64, -2, -2.17, -3.24,
R_CUBIC_TO, -0.54, -1.24, -0.8, -2.57, -0.8, -3.98,
R_CUBIC_TO, 0, -1.06, 0.14, -2.06, 0.44, -3.01,
R_ARC_TO, 9.96, 9.96, 0, 0, 1, 1.25, -2.64,
LINE_TO, 0.65, 3.5,
R_LINE_TO, 1.48, -1.48,
LINE_TO, 22.06, 21.94,
CLOSE,
MOVE_TO, 12, 19.93,
R_CUBIC_TO, 0.73, 0, 1.43, -0.1, 2.1, -0.29,
R_ARC_TO, 8.27, 8.27, 0, 0, 0, 1.88, -0.8,
LINE_TO, 5.16, 8.02,
R_CUBIC_TO, -0.34, 0.59, -0.61, 1.21, -0.8, 1.88,
ARC_TO, 7.57, 7.57, 0, 0, 0, 4.07, 12,
R_CUBIC_TO, 0, 2.2, 0.77, 4.07, 2.32, 5.61,
CUBIC_TO, 7.93, 19.16, 9.81, 19.93, 12, 19.93,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCookieOffChromeRefresh20Path, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 16.77, 14.47,
R_LINE_TO, -1.28, -1.28,
R_CUBIC_TO, 0.24, -0.41, 0.44, -0.84, 0.59, -1.3,
R_ARC_TO, 6.24, 6.24, 0, 0, 0, 0.29, -1.45,
R_ARC_TO, 3.8, 3.8, 0, 0, 1, -1.53, -1.16,
R_ARC_TO, 3.86, 3.86, 0, 0, 1, -0.79, -1.75,
R_ARC_TO, 4.86, 4.86, 0, 0, 1, -2.67, -1.31,
R_ARC_TO, 4.42, 4.42, 0, 0, 1, -1.34, -2.6,
R_ARC_TO, 5.69, 5.69, 0, 0, 0, -1.71, 0.18,
R_ARC_TO, 5.89, 5.89, 0, 0, 0, -1.56, 0.67,
LINE_TO, 5.49, 3.19,
R_ARC_TO, 8, 8, 0, 0, 1, 3.02, -1.28,
R_ARC_TO, 6.69, 6.69, 0, 0, 1, 3.29, 0.17,
R_CUBIC_TO, -0.11, 0.62, -0.09, 1.19, 0.07, 1.7,
R_CUBIC_TO, 0.16, 0.51, 0.44, 0.94, 0.82, 1.27,
R_CUBIC_TO, 0.38, 0.33, 0.84, 0.57, 1.4, 0.7,
R_CUBIC_TO, 0.56, 0.13, 1.15, 0.13, 1.8, -0.02,
R_CUBIC_TO, -0.32, 0.79, -0.26, 1.55, 0.16, 2.27,
R_CUBIC_TO, 0.43, 0.72, 1.1, 1.08, 2.01, 1.09,
R_ARC_TO, 7.82, 7.82, 0, 0, 1, -0.18, 2.87,
R_ARC_TO, 8.05, 8.05, 0, 0, 1, -1.12, 2.52,
CLOSE,
MOVE_TO, 6.75, 12.5,
R_CUBIC_TO, -0.35, 0, -0.64, -0.12, -0.89, -0.36,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, -0.36, -0.89,
R_CUBIC_TO, 0, -0.35, 0.12, -0.64, 0.36, -0.89,
R_CUBIC_TO, 0.25, -0.24, 0.54, -0.36, 0.89, -0.36,
R_CUBIC_TO, 0.35, 0, 0.64, 0.12, 0.89, 0.36,
R_CUBIC_TO, 0.24, 0.25, 0.36, 0.54, 0.36, 0.89,
R_CUBIC_TO, 0, 0.35, -0.12, 0.64, -0.36, 0.89,
R_CUBIC_TO, -0.25, 0.24, -0.54, 0.36, -0.89, 0.36,
CLOSE,
R_MOVE_TO, 9.2, 5.61,
R_LINE_TO, -1.35, -1.35,
R_ARC_TO, 8.76, 8.76, 0, 0, 1, -2.2, 1.05,
R_ARC_TO, 8.01, 8.01, 0, 0, 1, -2.4, 0.36,
R_ARC_TO, 7.97, 7.97, 0, 0, 1, -3.18, -0.64,
R_ARC_TO, 8.2, 8.2, 0, 0, 1, -2.6, -1.75,
R_ARC_TO, 8.2, 8.2, 0, 0, 1, -1.75, -2.6,
ARC_TO, 7.97, 7.97, 0, 0, 1, 1.83, 10,
R_CUBIC_TO, 0, -0.83, 0.12, -1.62, 0.36, -2.4,
R_ARC_TO, 8.76, 8.76, 0, 0, 1, 1.05, -2.2,
R_LINE_TO, -1.26, -1.27,
R_LINE_TO, 1.11, -1.11,
R_LINE_TO, 13.98, 13.98,
CLOSE,
R_MOVE_TO, -5.95, -1.66,
R_CUBIC_TO, 0.6, 0, 1.17, -0.09, 1.74, -0.26,
R_ARC_TO, 8.67, 8.67, 0, 0, 0, 1.62, -0.69,
LINE_TO, 4.51, 6.64,
R_ARC_TO, 8.82, 8.82, 0, 0, 0, -0.69, 1.62,
R_ARC_TO, 5.89, 5.89, 0, 0, 0, -0.26, 1.74,
R_CUBIC_TO, 0, 1.79, 0.63, 3.31, 1.88, 4.56,
R_CUBIC_TO, 1.25, 1.25, 2.78, 1.88, 4.56, 1.88,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCookieOffChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 13.57, 11.54,
R_LINE_TO, -1.22, -1.21,
R_ARC_TO, 4.42, 4.42, 0, 0, 0, 0.4, -0.9,
R_CUBIC_TO, 0.1, -0.32, 0.17, -0.65, 0.2, -1,
R_ARC_TO, 3.13, 3.13, 0, 0, 1, -1.18, -0.92,
R_ARC_TO, 3.05, 3.05, 0, 0, 1, -0.63, -1.37,
ARC_TO, 4.05, 4.05, 0, 0, 1, 9.03, 5.09,
ARC_TO, 3.55, 3.55, 0, 0, 1, 7.93, 3.04,
R_ARC_TO, 4.42, 4.42, 0, 0, 0, -2.28, 0.58,
LINE_TO, 4.42, 2.4,
ARC_TO, 6.57, 6.57, 0, 0, 1, 6.92, 1.39,
R_ARC_TO, 5.42, 5.42, 0, 0, 1, 2.67, 0.17,
R_CUBIC_TO, -0.09, 0.51, -0.09, 0.97, 0.03, 1.38,
R_CUBIC_TO, 0.11, 0.41, 0.32, 0.75, 0.61, 1.01,
R_CUBIC_TO, 0.29, 0.26, 0.66, 0.45, 1.1, 0.55,
R_CUBIC_TO, 0.44, 0.1, 0.93, 0.1, 1.47, -0.01,
R_CUBIC_TO, -0.22, 0.64, -0.18, 1.24, 0.14, 1.82,
R_CUBIC_TO, 0.32, 0.57, 0.86, 0.85, 1.64, 0.84,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, -0.12, 2.34,
R_ARC_TO, 6.64, 6.64, 0, 0, 1, -0.87, 2.06,
CLOSE,
MOVE_TO, 5.4, 10,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 4.4, 9,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 5.4, 8,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.2, 0.19, 0.29, 0.43, 0.29, 0.71,
R_ARC_TO, 0.95, 0.95, 0, 0, 1, -0.29, 0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, 0.29,
CLOSE,
R_MOVE_TO, 7.45, 4.6,
R_LINE_TO, -1.05, -1.04,
R_ARC_TO, 7.28, 7.28, 0, 0, 1, -1.81, 0.86,
R_CUBIC_TO, -0.64, 0.2, -1.3, 0.3, -1.98, 0.3,
R_ARC_TO, 6.51, 6.51, 0, 0, 1, -2.62, -0.52,
R_ARC_TO, 6.7, 6.7, 0, 0, 1, -2.14, -1.44,
R_ARC_TO, 6.7, 6.7, 0, 0, 1, -1.44, -2.14,
ARC_TO, 6.51, 6.51, 0, 0, 1, 1.28, 8,
R_CUBIC_TO, 0, -0.68, 0.1, -1.34, 0.3, -1.98,
R_ARC_TO, 7.28, 7.28, 0, 0, 1, 0.86, -1.81,
R_LINE_TO, -0.89, -0.9,
R_LINE_TO, 0.94, -0.95,
R_LINE_TO, 11.3, 11.3,
CLOSE,
MOVE_TO, 8, 13.09,
R_ARC_TO, 4.8, 4.8, 0, 0, 0, 1.36, -0.19,
R_ARC_TO, 6.43, 6.43, 0, 0, 0, 1.27, -0.53,
R_LINE_TO, -6.98, -6.99,
R_ARC_TO, 6.5, 6.5, 0, 0, 0, -0.53, 1.26,
ARC_TO, 4.84, 4.84, 0, 0, 0, 2.91, 8,
R_CUBIC_TO, 0, 1.41, 0.5, 2.62, 1.48, 3.61,
R_CUBIC_TO, 0.99, 0.99, 2.2, 1.48, 3.6, 1.48,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCookieOffChromeRefreshRepList, kCookieOffChromeRefreshIcon, {kCookieOffChromeRefreshPath}, {kCookieOffChromeRefresh20Path}, {kCookieOffChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kDangerousPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.18, 19.24,
LINE_TO, 0.76, 13.8,
V_LINE_TO, 6.18,
LINE_TO, 6.18, 0.76,
R_H_LINE_TO, 7.65,
LINE_TO, 19.24, 6.18,
R_V_LINE_TO, 7.65,
LINE_TO, 13.8, 19.24,
CLOSE,
MOVE_TO, 7.06, 14.32,
LINE_TO, 10, 11.4,
LINE_TO, 12.94, 14.32,
LINE_TO, 14.32, 12.94,
LINE_TO, 11.4, 10,
LINE_TO, 14.32, 7.06,
LINE_TO, 12.94, 5.68,
LINE_TO, 10, 8.6,
LINE_TO, 7.06, 5.68,
LINE_TO, 5.68, 7.06,
LINE_TO, 8.6, 10,
LINE_TO, 5.68, 12.94,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDangerousRepList, kDangerousIcon, {kDangerousPath})
VECTOR_ICON_REP_TEMPLATE(kDangerousChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7.11, 17,
LINE_TO, 3, 12.88,
LINE_TO, 3, 7.11,
LINE_TO, 7.11, 3,
LINE_TO, 12.89, 3,
LINE_TO, 17, 7.11,
LINE_TO, 17, 12.89,
LINE_TO, 12.88, 17,
CLOSE,
MOVE_TO, 7.77, 13.27,
LINE_TO, 10, 11.06,
LINE_TO, 12.23, 13.27,
LINE_TO, 13.27, 12.23,
LINE_TO, 11.06, 10,
LINE_TO, 13.27, 7.77,
LINE_TO, 12.23, 6.73,
LINE_TO, 10, 8.94,
LINE_TO, 7.77, 6.73,
LINE_TO, 6.73, 7.77,
LINE_TO, 8.94, 10,
LINE_TO, 6.73, 12.23,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDangerousChromeRefreshRepList, kDangerousChromeRefreshIcon, {kDangerousChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kDatabasePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 12, 21,
R_CUBIC_TO, -2.52, 0, -4.64, -0.39, -6.39, -1.16,
CUBIC_TO, 3.87, 19.06, 3, 18.12, 3, 17,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -1.1, 0.88, -2.04, 2.64, -2.82,
CUBIC_TO, 7.4, 3.39, 9.52, 3, 12, 3,
R_CUBIC_TO, 2.48, 0, 4.61, 0.39, 6.36, 1.18,
CUBIC_TO, 20.12, 4.96, 21, 5.9, 21, 7,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 1.12, -0.87, 2.06, -2.61, 2.84,
CUBIC_TO, 16.65, 20.61, 14.52, 21, 12, 21,
CLOSE,
R_MOVE_TO, 0, -11.98,
R_CUBIC_TO, 1.48, 0, 2.98, -0.21, 4.48, -0.64,
R_CUBIC_TO, 1.5, -0.43, 2.34, -0.88, 2.52, -1.36,
R_CUBIC_TO, -0.18, -0.48, -1.02, -0.94, -2.51, -1.37,
ARC_TO, 16.01, 16.01, 0, 0, 0, 12, 5,
R_CUBIC_TO, -1.52, 0, -3, 0.21, -4.46, 0.64,
R_CUBIC_TO, -1.46, 0.43, -2.31, 0.89, -2.54, 1.39,
R_CUBIC_TO, 0.23, 0.5, 1.08, 0.96, 2.54, 1.38,
R_CUBIC_TO, 1.46, 0.42, 2.94, 0.63, 4.46, 0.63,
CLOSE,
MOVE_TO, 12, 14,
R_CUBIC_TO, 0.7, 0, 1.38, -0.04, 2.02, -0.1,
R_CUBIC_TO, 0.65, -0.07, 1.27, -0.16, 1.86, -0.28,
R_ARC_TO, 13.4, 13.4, 0, 0, 0, 1.68, -0.46,
ARC_TO, 9.95, 9.95, 0, 0, 0, 19, 12.52,
R_V_LINE_TO, -3,
R_ARC_TO, 9.95, 9.95, 0, 0, 1, -1.44, 0.63,
R_CUBIC_TO, -0.52, 0.18, -1.08, 0.34, -1.67, 0.47,
R_CUBIC_TO, -0.59, 0.13, -1.21, 0.22, -1.86, 0.28,
CUBIC_TO, 13.38, 10.97, 12.7, 11, 12, 11,
R_CUBIC_TO, -0.7, 0, -1.38, -0.04, -2.05, -0.1,
R_ARC_TO, 17.58, 17.58, 0, 0, 1, -1.89, -0.28,
R_ARC_TO, 13.21, 13.21, 0, 0, 1, -1.66, -0.46,
ARC_TO, 9.08, 9.08, 0, 0, 1, 5, 9.52,
R_V_LINE_TO, 3,
R_CUBIC_TO, 0.42, 0.24, 0.88, 0.44, 1.4, 0.63,
R_CUBIC_TO, 0.52, 0.18, 1.08, 0.34, 1.67, 0.47,
R_CUBIC_TO, 0.59, 0.13, 1.22, 0.22, 1.89, 0.28,
R_CUBIC_TO, 0.67, 0.07, 1.35, 0.1, 2.05, 0.1,
CLOSE,
R_MOVE_TO, 0, 5,
R_CUBIC_TO, 0.77, 0, 1.55, -0.06, 2.34, -0.18,
R_CUBIC_TO, 0.79, -0.12, 1.52, -0.27, 2.19, -0.46,
R_CUBIC_TO, 0.67, -0.19, 1.23, -0.41, 1.68, -0.65,
R_CUBIC_TO, 0.45, -0.24, 0.72, -0.48, 0.8, -0.73,
R_V_LINE_TO, -2.45,
R_ARC_TO, 9.95, 9.95, 0, 0, 1, -1.44, 0.63,
R_CUBIC_TO, -0.52, 0.18, -1.08, 0.34, -1.67, 0.47,
R_CUBIC_TO, -0.59, 0.13, -1.21, 0.22, -1.86, 0.28,
CUBIC_TO, 13.38, 15.97, 12.7, 16, 12, 16,
R_CUBIC_TO, -0.7, 0, -1.38, -0.04, -2.05, -0.1,
R_ARC_TO, 17.58, 17.58, 0, 0, 1, -1.89, -0.28,
R_ARC_TO, 13.21, 13.21, 0, 0, 1, -1.66, -0.46,
ARC_TO, 9.08, 9.08, 0, 0, 1, 5, 14.52,
V_LINE_TO, 17,
R_CUBIC_TO, 0.08, 0.25, 0.35, 0.49, 0.79, 0.73,
R_CUBIC_TO, 0.44, 0.23, 1, 0.45, 1.66, 0.64,
R_CUBIC_TO, 0.67, 0.19, 1.4, 0.34, 2.2, 0.46,
R_CUBIC_TO, 0.8, 0.12, 1.59, 0.18, 2.35, 0.18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDatabaseRepList, kDatabaseIcon, {kDatabasePath})
VECTOR_ICON_REP_TEMPLATE(kDatabaseOffPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 3.57, 2.56,
LINE_TO, 2.15, 3.98,
R_LINE_TO, 18.59, 18.59,
R_LINE_TO, 1.41, -1.41,
LINE_TO, 3.57, 2.56,
CLOSE,
NEW_PATH,
MOVE_TO, 5.31, 4.3,
CUBIC_TO, 4.27, 4.96, 3.75, 5.71, 3.75, 6.56,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 1.12, 0.87, 2.07, 2.6, 2.85,
R_CUBIC_TO, 1.75, 0.77, 3.88, 1.15, 6.4, 1.15,
R_CUBIC_TO, 2.52, 0, 4.64, -0.38, 6.38, -1.15,
R_CUBIC_TO, 0.32, -0.14, 0.6, -0.29, 0.86, -0.44,
R_LINE_TO, -1.48, -1.48,
R_CUBIC_TO, -0.36, 0.16, -0.77, 0.3, -1.23, 0.44,
R_CUBIC_TO, -0.67, 0.18, -1.4, 0.33, -2.2, 0.45,
R_ARC_TO, 15.76, 15.76, 0, 0, 1, -2.33, 0.17,
R_CUBIC_TO, -0.77, 0, -1.55, -0.06, -2.35, -0.17,
R_CUBIC_TO, -0.8, -0.12, -1.53, -0.27, -2.2, -0.45,
R_CUBIC_TO, -0.67, -0.2, -1.23, -0.42, -1.67, -0.65,
R_CUBIC_TO, -0.43, -0.23, -0.69, -0.47, -0.77, -0.72,
R_V_LINE_TO, -2.47,
R_CUBIC_TO, 0.42, 0.23, 0.88, 0.44, 1.4, 0.63,
R_CUBIC_TO, 0.52, 0.18, 1.07, 0.34, 1.65, 0.48,
R_ARC_TO, 20.81, 20.81, 0, 0, 0, 3.95, 0.37,
R_ARC_TO, 19.84, 19.84, 0, 0, 0, 3.52, -0.31,
LINE_TO, 14.5, 13.49,
R_CUBIC_TO, -0.56, 0.05, -1.15, 0.07, -1.75, 0.07,
R_ARC_TO, 20.81, 20.81, 0, 0, 1, -3.95, -0.37,
R_ARC_TO, 14.79, 14.79, 0, 0, 1, -1.65, -0.47,
R_ARC_TO, 9.07, 9.07, 0, 0, 1, -1.4, -0.62,
R_V_LINE_TO, -3,
R_CUBIC_TO, 0.42, 0.23, 0.88, 0.44, 1.4, 0.63,
R_CUBIC_TO, 0.52, 0.18, 1.07, 0.34, 1.65, 0.48,
R_ARC_TO, 20.81, 20.81, 0, 0, 0, 2.74, 0.34,
LINE_TO, 9.21, 8.2,
R_ARC_TO, 16.62, 16.62, 0, 0, 1, -0.94, -0.24,
R_CUBIC_TO, -1.45, -0.42, -2.29, -0.87, -2.52, -1.37,
R_CUBIC_TO, 0.14, -0.29, 0.48, -0.57, 1.02, -0.83,
LINE_TO, 5.31, 4.3,
CLOSE,
R_MOVE_TO, 3.57, 0.75,
LINE_TO, 7.24, 3.4,
R_CUBIC_TO, 1.58, -0.56, 3.42, -0.83, 5.51, -0.83,
R_CUBIC_TO, 2.48, 0, 4.6, 0.39, 6.35, 1.17,
R_CUBIC_TO, 1.77, 0.78, 2.65, 1.73, 2.65, 2.83,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.37, -0.1, 0.72, -0.29, 1.06,
R_LINE_TO, -1.71, -1.71,
R_V_LINE_TO, -1.82,
R_ARC_TO, 9.49, 9.49, 0, 0, 1, -1.26, 0.56,
R_LINE_TO, -1.53, -1.54,
R_CUBIC_TO, 0.48, -0.12, 0.93, -0.25, 1.35, -0.4,
R_ARC_TO, 9.73, 9.73, 0, 0, 0, 1.45, -0.62,
R_V_LINE_TO, -3,
R_ARC_TO, 9.73, 9.73, 0, 0, 1, -1.45, 0.63,
R_CUBIC_TO, -0.52, 0.18, -1.07, 0.34, -1.67, 0.48,
R_ARC_TO, 19.68, 19.68, 0, 0, 1, -2.28, 0.31,
R_LINE_TO, -1.92, -1.92,
R_CUBIC_TO, 0.11, 0, 0.22, 0, 0.33, 0,
R_CUBIC_TO, 1.48, 0, 2.98, -0.21, 4.47, -0.62,
R_CUBIC_TO, 1.5, -0.43, 2.34, -0.89, 2.53, -1.37,
R_CUBIC_TO, -0.18, -0.48, -1.02, -0.94, -2.52, -1.37,
R_ARC_TO, 15.89, 15.89, 0, 0, 0, -4.47, -0.65,
R_CUBIC_TO, -1.31, 0, -2.59, 0.16, -3.86, 0.48,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDatabaseOffRepList, kDatabaseOffIcon, {kDatabaseOffPath})
VECTOR_ICON_REP_TEMPLATE(kDescriptionPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 8, 16,
R_H_LINE_TO, 8,
R_V_LINE_TO, 2,
H_LINE_TO, 8,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, -4,
R_H_LINE_TO, 8,
R_V_LINE_TO, 2,
H_LINE_TO, 8,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 6, -10,
H_LINE_TO, 6,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 16,
R_CUBIC_TO, 0, 1.1, 0.89, 2, 1.99, 2,
H_LINE_TO, 18,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 8,
R_LINE_TO, -6, -6,
CLOSE,
R_MOVE_TO, 4, 18,
H_LINE_TO, 6,
V_LINE_TO, 4,
R_H_LINE_TO, 7,
R_V_LINE_TO, 5,
R_H_LINE_TO, 5,
R_V_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDescriptionRepList, kDescriptionIcon, {kDescriptionPath})
VECTOR_ICON_REP_TEMPLATE(kDevicesPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 1.91, 20.27,
V_LINE_TO, 17,
R_H_LINE_TO, 2,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.63, 0.22, -1.17, 0.66, -1.61,
R_CUBIC_TO, 0.45, -0.44, 0.98, -0.66, 1.61, -0.66,
H_LINE_TO, 21,
V_LINE_TO, 6,
H_LINE_TO, 6.18,
R_V_LINE_TO, 11,
R_H_LINE_TO, 5.73,
R_V_LINE_TO, 3.27,
CLOSE,
R_MOVE_TO, 12.95, 0,
R_CUBIC_TO, -0.3, 0, -0.55, -0.1, -0.75, -0.3,
R_CUBIC_TO, -0.2, -0.2, -0.3, -0.45, -0.3, -0.75,
V_LINE_TO, 8.95,
R_CUBIC_TO, 0, -0.3, 0.1, -0.54, 0.3, -0.74,
R_CUBIC_TO, 0.2, -0.2, 0.45, -0.3, 0.75, -0.3,
R_H_LINE_TO, 6.18,
R_CUBIC_TO, 0.3, 0, 0.54, 0.1, 0.74, 0.3,
R_CUBIC_TO, 0.2, 0.2, 0.3, 0.45, 0.3, 0.74,
R_V_LINE_TO, 10.27,
R_CUBIC_TO, 0, 0.3, -0.1, 0.55, -0.3, 0.75,
R_CUBIC_TO, -0.2, 0.2, -0.44, 0.3, -0.74, 0.3,
CLOSE,
MOVE_TO, 15.91, 17,
H_LINE_TO, 20,
R_V_LINE_TO, -7,
R_H_LINE_TO, -4.09,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kDevices20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 1.93, 16.23,
V_LINE_TO, 14,
R_H_LINE_TO, 2,
V_LINE_TO, 5.5,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_CUBIC_TO, 0.34, -0.34, 0.75, -0.51, 1.23, -0.51,
H_LINE_TO, 17,
V_LINE_TO, 5.5,
H_LINE_TO, 5.66,
V_LINE_TO, 14,
R_H_LINE_TO, 4.27,
R_V_LINE_TO, 2.23,
CLOSE,
R_MOVE_TO, 10.96, 0,
R_CUBIC_TO, -0.3, 0, -0.54, -0.1, -0.74, -0.3,
R_CUBIC_TO, -0.2, -0.2, -0.3, -0.45, -0.3, -0.74,
V_LINE_TO, 7.96,
R_CUBIC_TO, 0, -0.29, 0.1, -0.54, 0.3, -0.74,
R_CUBIC_TO, 0.2, -0.2, 0.45, -0.3, 0.74, -0.3,
R_H_LINE_TO, 4.15,
R_CUBIC_TO, 0.29, 0, 0.54, 0.1, 0.74, 0.3,
R_CUBIC_TO, 0.2, 0.2, 0.3, 0.45, 0.3, 0.74,
R_V_LINE_TO, 7.23,
R_CUBIC_TO, 0, 0.3, -0.1, 0.54, -0.3, 0.74,
R_CUBIC_TO, -0.2, 0.2, -0.44, 0.3, -0.74, 0.3,
CLOSE,
R_MOVE_TO, 0.54, -2.23,
H_LINE_TO, 16.5,
V_LINE_TO, 8.5,
R_H_LINE_TO, -3.07,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kDevices16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 1.46, 13.23,
V_LINE_TO, 11.2,
R_H_LINE_TO, 1.6,
V_LINE_TO, 4.4,
R_CUBIC_TO, 0, -0.45, 0.16, -0.84, 0.48, -1.16,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, 1.16, -0.48,
R_H_LINE_TO, 8.91,
R_V_LINE_TO, 1.63,
R_H_LINE_TO, -8.91,
V_LINE_TO, 11.2,
H_LINE_TO, 7.86,
R_V_LINE_TO, 2.04,
CLOSE,
R_MOVE_TO, 8.73, 0,
R_ARC_TO, 0.85, 0.85, 0, 0, 1, -0.62, -0.25,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, -0.25, -0.62,
V_LINE_TO, 6.32,
R_CUBIC_TO, 0, -0.25, 0.08, -0.45, 0.25, -0.62,
R_ARC_TO, 0.86, 0.86, 0, 0, 1, 0.63, -0.25,
R_H_LINE_TO, 3.49,
R_CUBIC_TO, 0.25, 0, 0.45, 0.09, 0.62, 0.25,
R_CUBIC_TO, 0.16, 0.17, 0.25, 0.37, 0.25, 0.62,
R_V_LINE_TO, 6.04,
R_ARC_TO, 0.86, 0.86, 0, 0, 1, -0.25, 0.62,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, -0.62, 0.25,
CLOSE,
R_MOVE_TO, 0.48, -2.03,
R_H_LINE_TO, 2.54,
V_LINE_TO, 6.8,
R_H_LINE_TO, -2.54,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDevicesRepList, kDevicesIcon, {kDevicesPath}, {kDevices20Path}, {kDevices16Path})
VECTOR_ICON_REP_TEMPLATE(kDevicesOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.63, 5.5,
LINE_TO, 6.13, 4,
H_LINE_TO, 17,
R_V_LINE_TO, 1.5,
CLOSE,
MOVE_TO, 18, 15.5,
LINE_TO, 16.5, 14,
V_LINE_TO, 8.5,
R_H_LINE_TO, -3,
R_V_LINE_TO, 2.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 7.75,
R_CUBIC_TO, 0, -0.21, 0.07, -0.39, 0.22, -0.53,
ARC_TO, 0.72, 0.72, 0, 0, 1, 12.75, 7,
R_H_LINE_TO, 4.49,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.54, 0.22,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.22, 0.54,
CLOSE,
R_MOVE_TO, -2, 2.63,
LINE_TO, 13.88, 16,
H_LINE_TO, 12.75,
R_CUBIC_TO, -0.21, 0, -0.39, -0.07, -0.53, -0.21,
ARC_TO, 0.73, 0.73, 0, 0, 1, 12, 15.25,
R_V_LINE_TO, -1.12,
R_LINE_TO, -6.5, -6.5,
V_LINE_TO, 14,
H_LINE_TO, 10,
R_V_LINE_TO, 2,
H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
V_LINE_TO, 6.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -1, -5.44,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDevicesOffRepList, kDevicesOffIcon, {kDevicesOffPath})
VECTOR_ICON_REP_TEMPLATE(kDirectionsCarPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 6, 19,
R_V_LINE_TO, 1,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 5, 21,
H_LINE_TO, 4,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 3, 20,
R_V_LINE_TO, -8,
R_LINE_TO, 2.1, -6,
R_CUBIC_TO, 0.1, -0.3, 0.28, -0.54, 0.54, -0.73,
CUBIC_TO, 5.9, 5.09, 6.18, 5, 6.5, 5,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.32, 0, 0.61, 0.09, 0.86, 0.27,
R_CUBIC_TO, 0.26, 0.18, 0.44, 0.43, 0.54, 0.73,
LINE_TO, 21, 12,
R_V_LINE_TO, 8,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 20, 21,
R_H_LINE_TO, -1,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 18, 20,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, -0.2, -9,
R_H_LINE_TO, 12.4,
R_LINE_TO, -1.05, -3,
H_LINE_TO, 6.85,
CLOSE,
MOVE_TO, 5, 12,
R_V_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 2.5, 4,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.64, 0.44, -1.06,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 7.5, 13,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 6, 14.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.06, 0.44,
CLOSE,
R_MOVE_TO, 9, 0,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.64, 0.44, -1.06,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 16.5, 13,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 15, 14.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 5, 17,
R_H_LINE_TO, 14,
R_V_LINE_TO, -5,
H_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDirectionsCarRepList, kDirectionsCarIcon, {kDirectionsCarPath})
VECTOR_ICON_REP_TEMPLATE(kDocumentScannerPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4.67, 2,
H_LINE_TO, 2.67,
V_LINE_TO, 4,
H_LINE_TO, 1.33,
V_LINE_TO, 0.67,
H_LINE_TO, 4.67,
V_LINE_TO, 2,
CLOSE,
MOVE_TO, 14.67, 4,
V_LINE_TO, 0.67,
H_LINE_TO, 11.33,
V_LINE_TO, 2,
H_LINE_TO, 13.33,
V_LINE_TO, 4,
H_LINE_TO, 14.67,
CLOSE,
MOVE_TO, 4.67, 14,
H_LINE_TO, 2.67,
V_LINE_TO, 12,
H_LINE_TO, 1.33,
V_LINE_TO, 15.33,
H_LINE_TO, 4.67,
V_LINE_TO, 14,
CLOSE,
MOVE_TO, 13.33, 12,
V_LINE_TO, 14,
H_LINE_TO, 11.33,
V_LINE_TO, 15.33,
H_LINE_TO, 14.67,
V_LINE_TO, 12,
H_LINE_TO, 13.33,
CLOSE,
MOVE_TO, 11.33, 4,
H_LINE_TO, 4.67,
V_LINE_TO, 12,
H_LINE_TO, 11.33,
V_LINE_TO, 4,
CLOSE,
MOVE_TO, 12.67, 12,
CUBIC_TO, 12.67, 12.73, 12.07, 13.33, 11.33, 13.33,
H_LINE_TO, 4.67,
CUBIC_TO, 3.93, 13.33, 3.33, 12.73, 3.33, 12,
V_LINE_TO, 4,
CUBIC_TO, 3.33, 3.27, 3.93, 2.67, 4.67, 2.67,
H_LINE_TO, 11.33,
CUBIC_TO, 12.07, 2.67, 12.67, 3.27, 12.67, 4,
V_LINE_TO, 12,
CLOSE,
MOVE_TO, 10, 5.33,
H_LINE_TO, 6,
V_LINE_TO, 6.67,
H_LINE_TO, 10,
V_LINE_TO, 5.33,
CLOSE,
MOVE_TO, 10, 7.33,
H_LINE_TO, 6,
V_LINE_TO, 8.67,
H_LINE_TO, 10,
V_LINE_TO, 7.33,
CLOSE,
MOVE_TO, 10, 9.33,
H_LINE_TO, 6,
V_LINE_TO, 10.67,
H_LINE_TO, 10,
V_LINE_TO, 9.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDocumentScannerRepList, kDocumentScannerIcon, {kDocumentScannerPath})
VECTOR_ICON_REP_TEMPLATE(kDogfoodPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9.75, 9.25,
CUBIC_TO, 10.72, 9.25, 11.5, 8.47, 11.5, 7.5,
CUBIC_TO, 11.5, 6.53, 10.72, 5.75, 9.75, 5.75,
CUBIC_TO, 8.78, 5.75, 8, 6.53, 8, 7.5,
CUBIC_TO, 8, 8.47, 8.78, 9.25, 9.75, 9.25,
CLOSE,
MOVE_TO, 6.88, 12.25,
CUBIC_TO, 7.85, 12.25, 8.63, 11.47, 8.63, 10.5,
CUBIC_TO, 8.63, 9.53, 7.85, 8.75, 6.88, 8.75,
CUBIC_TO, 5.91, 8.75, 5.13, 9.53, 5.13, 10.5,
CUBIC_TO, 5.13, 11.47, 5.91, 12.25, 6.88, 12.25,
CLOSE,
MOVE_TO, 15.75, 7.5,
CUBIC_TO, 15.75, 8.47, 14.97, 9.25, 14, 9.25,
CUBIC_TO, 13.03, 9.25, 12.25, 8.47, 12.25, 7.5,
CUBIC_TO, 12.25, 6.53, 13.03, 5.75, 14, 5.75,
CUBIC_TO, 14.97, 5.75, 15.75, 6.53, 15.75, 7.5,
CLOSE,
MOVE_TO, 17.12, 12.25,
CUBIC_TO, 18.09, 12.25, 18.87, 11.47, 18.87, 10.5,
CUBIC_TO, 18.87, 9.53, 18.09, 8.75, 17.12, 8.75,
CUBIC_TO, 16.15, 8.75, 15.37, 9.53, 15.37, 10.5,
CUBIC_TO, 15.37, 11.47, 16.15, 12.25, 17.12, 12.25,
CLOSE,
MOVE_TO, 12.63, 10.36,
CUBIC_TO, 13.17, 10.54, 13.54, 10.9, 13.89, 11.3,
CUBIC_TO, 14.07, 11.51, 14.24, 11.72, 14.42, 11.93,
CUBIC_TO, 14.79, 12.38, 15.16, 12.83, 15.58, 13.25,
CUBIC_TO, 15.67, 13.34, 15.76, 13.43, 15.85, 13.52,
CUBIC_TO, 16.7, 14.38, 17.59, 15.27, 17.34, 16.54,
CUBIC_TO, 17.18, 17.34, 16.65, 17.96, 15.81, 18.22,
CUBIC_TO, 15.58, 18.29, 15.05, 18.22, 14.35, 18.13,
CUBIC_TO, 13.62, 18.04, 12.72, 17.92, 11.81, 17.92,
CUBIC_TO, 10.88, 17.92, 10, 18.04, 9.31, 18.13,
CUBIC_TO, 8.68, 18.22, 8.19, 18.29, 7.97, 18.22,
CUBIC_TO, 7.13, 17.96, 6.59, 17.34, 6.43, 16.54,
CUBIC_TO, 6.18, 15.26, 7.07, 14.37, 7.92, 13.51,
CUBIC_TO, 8.01, 13.42, 8.09, 13.34, 8.18, 13.25,
CUBIC_TO, 8.56, 12.86, 8.91, 12.44, 9.25, 12.01,
CUBIC_TO, 9.45, 11.77, 9.64, 11.53, 9.84, 11.3,
CUBIC_TO, 10.19, 10.9, 10.52, 10.54, 11.06, 10.36,
CUBIC_TO, 11.3, 10.29, 11.55, 10.25, 11.8, 10.25,
CUBIC_TO, 11.8, 10.25, 12.39, 10.28, 12.63, 10.36,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDogfoodRepList, kDogfoodIcon, {kDogfoodPath})
VECTOR_ICON_REP_TEMPLATE(kEditPath, CANVAS_DIMENSIONS, 48,
MOVE_TO, 6, 34.51,
LINE_TO, 6, 42.01,
LINE_TO, 13.5, 42.01,
LINE_TO, 35.62, 19.89,
LINE_TO, 28.12, 12.39,
LINE_TO, 6, 34.51,
CLOSE,
MOVE_TO, 41.42, 14.09,
CUBIC_TO, 42.2, 13.31, 42.2, 12.05, 41.42, 11.27,
LINE_TO, 36.74, 6.59,
CUBIC_TO, 35.96, 5.81, 34.7, 5.81, 33.92, 6.59,
LINE_TO, 30.26, 10.25,
LINE_TO, 37.76, 17.75,
LINE_TO, 41.42, 14.09,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditRepList, kEditIcon, {kEditPath})
VECTOR_ICON_REP_TEMPLATE(kEditChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 15.5,
R_H_LINE_TO, 1.06,
R_LINE_TO, 7.81, -7.81,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 4.5, 14.44,
CLOSE,
MOVE_TO, 3, 17,
R_V_LINE_TO, -3.19,
LINE_TO, 13.38, 3.44,
R_CUBIC_TO, 0.15, -0.15, 0.32, -0.27, 0.5, -0.33,
R_ARC_TO, 1.55, 1.55, 0, 0, 1, 1.13, 0,
R_CUBIC_TO, 0.18, 0.07, 0.35, 0.18, 0.5, 0.33,
LINE_TO, 16.56, 4.5,
R_ARC_TO, 1.4, 1.4, 0, 0, 1, 0.33, 0.5,
R_ARC_TO, 1.56, 1.56, 0, 0, 1, 0, 1.13,
R_CUBIC_TO, -0.07, 0.18, -0.18, 0.35, -0.33, 0.5,
LINE_TO, 6.19, 17,
CLOSE,
MOVE_TO, 15.5, 5.56,
LINE_TO, 14.44, 4.5,
CLOSE,
R_MOVE_TO, -2.66, 1.6,
R_LINE_TO, -0.52, -0.54,
R_LINE_TO, 1.06, 1.06,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kEditChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.65, 12.35,
R_H_LINE_TO, 0.85,
R_LINE_TO, 5.98, -5.98,
R_LINE_TO, -0.85, -0.85,
R_LINE_TO, -5.98, 5.99,
CLOSE,
R_MOVE_TO, -1.38, 1.38,
V_LINE_TO, 10.93,
R_LINE_TO, 8.29, -8.3,
R_CUBIC_TO, 0.13, -0.13, 0.27, -0.22, 0.42, -0.28,
R_CUBIC_TO, 0.15, -0.06, 0.31, -0.09, 0.48, -0.09,
R_CUBIC_TO, 0.16, 0, 0.32, 0.03, 0.47, 0.09,
R_CUBIC_TO, 0.15, 0.06, 0.29, 0.15, 0.43, 0.28,
LINE_TO, 13.37, 3.64,
R_CUBIC_TO, 0.13, 0.13, 0.22, 0.27, 0.28, 0.43,
R_CUBIC_TO, 0.06, 0.15, 0.09, 0.31, 0.09, 0.47,
R_ARC_TO, 1.25, 1.25, 0, 0, 1, -0.37, 0.91,
R_LINE_TO, -8.29, 8.29,
CLOSE,
R_MOVE_TO, 10.05, -9.19,
R_LINE_TO, -0.85, -0.86,
CLOSE,
R_MOVE_TO, -2.26, 1.41,
R_LINE_TO, -0.42, -0.43,
R_LINE_TO, 0.85, 0.85,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditChromeRefreshRepList, kEditChromeRefreshIcon, {kEditChromeRefreshPath}, {kEditChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kEmailPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 4,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -1.99, 0.9, -1.99, 2,
LINE_TO, 2, 18,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 16,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, 0, 4,
R_LINE_TO, -8, 5,
R_LINE_TO, -8, -5,
V_LINE_TO, 6,
R_LINE_TO, 8, 5,
R_LINE_TO, 8, -5,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEmailRepList, kEmailIcon, {kEmailPath})
VECTOR_ICON_REP_TEMPLATE(kEmailOutlinePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 4,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 16,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, -0.8, 2,
LINE_TO, 12, 10.8,
LINE_TO, 4.8, 6,
R_H_LINE_TO, 14.4,
CLOSE,
MOVE_TO, 4, 18,
V_LINE_TO, 7.87,
R_LINE_TO, 8, 5.33,
R_LINE_TO, 8, -5.33,
V_LINE_TO, 18,
H_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEmailOutlineRepList, kEmailOutlineIcon, {kEmailOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kErrorPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 0.91,
CUBIC_TO, 4.07, 0.91, 0.89, 4.1, 0.89, 8.03,
CUBIC_TO, 0.89, 11.96, 4.07, 15.14, 8, 15.14,
CUBIC_TO, 11.93, 15.14, 15.11, 11.96, 15.11, 8.03,
CUBIC_TO, 15.11, 4.1, 11.93, 0.91, 8, 0.91,
CLOSE,
MOVE_TO, 8.89, 11.55,
LINE_TO, 7.11, 11.55,
LINE_TO, 7.11, 9.78,
LINE_TO, 8.89, 9.78,
CLOSE,
MOVE_TO, 8.89, 8.89,
LINE_TO, 7.11, 8.89,
LINE_TO, 7.11, 4.45,
LINE_TO, 8.89, 4.45,
CLOSE,
MOVE_TO, 8.89, 8.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kErrorRepList, kErrorIcon, {kErrorPath})
VECTOR_ICON_REP_TEMPLATE(kErrorOutlinePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11, 15,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, -8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 6,
R_H_LINE_TO, -2,
V_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 0.99, -5,
CUBIC_TO, 6.47, 2, 2, 6.48, 2, 12,
R_CUBIC_TO, 0, 5.52, 4.47, 10, 9.99, 10,
CUBIC_TO, 17.52, 22, 22, 17.52, 22, 12,
CUBIC_TO_SHORTHAND, 17.52, 2, 11.99, 2,
CLOSE,
MOVE_TO, 12, 20,
R_CUBIC_TO, -4.42, 0, -8, -3.58, -8, -8,
R_CUBIC_TO, 0, -4.42, 3.58, -8, 8, -8,
R_CUBIC_TO, 4.42, 0, 8, 3.58, 8, 8,
R_CUBIC_TO, 0, 4.42, -3.58, 8, -8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kErrorOutlineRepList, kErrorOutlineIcon, {kErrorOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kEthernetPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17, 6,
R_LINE_TO, -1.41, 1.41,
LINE_TO, 20.17, 12,
R_LINE_TO, -4.58, 4.59,
LINE_TO, 17, 18,
R_LINE_TO, 6, -6,
R_LINE_TO, -6, -6,
CLOSE,
MOVE_TO, 8.41, 7.41,
LINE_TO, 7, 6,
R_LINE_TO, -6, 6,
R_LINE_TO, 6, 6,
R_LINE_TO, 1.41, -1.41,
LINE_TO, 3.83, 12,
R_LINE_TO, 4.58, -4.59,
CLOSE,
MOVE_TO, 8, 13,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
R_CUBIC_TO, 0, -0.55, -0.45, -1, -1, -1,
R_CUBIC_TO, -0.55, 0, -1, 0.45, -1, 1,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
CLOSE,
R_MOVE_TO, 4, 0,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
R_CUBIC_TO, 0, -0.55, -0.45, -1, -1, -1,
R_CUBIC_TO, -0.55, 0, -1, 0.45, -1, 1,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
CLOSE,
R_MOVE_TO, 4, 0,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
R_CUBIC_TO, 0, -0.55, -0.45, -1, -1, -1,
R_CUBIC_TO, -0.55, 0, -1, 0.45, -1, 1,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEthernetRepList, kEthernetIcon, {kEthernetPath})
VECTOR_ICON_REP_TEMPLATE(kExpandMorePath, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 8, 10.74,
R_LINE_TO, -4.3, -4.3,
R_LINE_TO, 1.15, -1.15,
LINE_TO, 8, 8.44,
R_LINE_TO, 3.15, -3.15,
R_LINE_TO, 1.15, 1.15,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExpandMoreRepList, kExpandMoreIcon, {kExpandMorePath})
VECTOR_ICON_REP_TEMPLATE(kExtensionPath, MOVE_TO, 41, 22,
R_H_LINE_TO, -3,
R_V_LINE_TO, -8,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
R_H_LINE_TO, -8,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -2.76, -2.24, -5, -5, -5,
R_CUBIC_TO, -2.76, 0, -5, 2.24, -5, 5,
R_V_LINE_TO, 3,
H_LINE_TO, 8,
R_CUBIC_TO, -2.21, 0, -3.98, 1.79, -3.98, 4,
R_LINE_TO, -0.01, 7.6,
H_LINE_TO, 7,
R_CUBIC_TO, 2.98, 0, 5.4, 2.42, 5.4, 5.4,
R_CUBIC_TO, 0, 2.98, -2.42, 5.4, -5.4, 5.4,
H_LINE_TO, 4.01,
LINE_TO, 4, 40,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 7.6,
R_V_LINE_TO, -3,
R_CUBIC_TO, 0, -2.98, 2.42, -5.4, 5.4, -5.4,
R_CUBIC_TO, 2.98, 0, 5.4, 2.42, 5.4, 5.4,
R_V_LINE_TO, 3,
H_LINE_TO, 34,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
R_V_LINE_TO, -8,
R_H_LINE_TO, 3,
R_CUBIC_TO, 2.76, 0, 5, -2.24, 5, -5,
R_CUBIC_TO, 0, -2.76, -2.24, -5, -5, -5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionRepList, kExtensionIcon, {kExtensionPath})
VECTOR_ICON_REP_TEMPLATE(kExtensionChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 12,
R_ARC_TO, 2.12, 2.12, 0, 0, 0, 1.42, -0.61,
ARC_TO, 1.88, 1.88, 0, 0, 0, 5, 10,
R_ARC_TO, 1.88, 1.88, 0, 0, 0, -0.58, -1.39,
ARC_TO, 2.12, 2.12, 0, 0, 0, 3, 8,
V_LINE_TO, 4.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
H_LINE_TO, 8,
R_CUBIC_TO, 0, -0.56, 0.19, -1.03, 0.58, -1.42,
ARC_TO, 1.93, 1.93, 0, 0, 1, 10, 1,
R_CUBIC_TO, 0.56, 0, 1.03, 0.19, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_H_LINE_TO, 3.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 8,
R_ARC_TO, 1.94, 1.94, 0, 0, 1, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_CUBIC_TO, 0, 0.56, -0.19, 1.03, -0.58, 1.42,
ARC_TO, 1.94, 1.94, 0, 0, 1, 17, 12,
R_V_LINE_TO, 3.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 15.5, 17,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
R_V_LINE_TO, -11,
R_H_LINE_TO, -11,
R_V_LINE_TO, 2.33,
R_ARC_TO, 3.23, 3.23, 0, 0, 1, 1.47, 1.28,
CUBIC_TO, 6.32, 8.69, 6.5, 9.32, 6.5, 10,
R_CUBIC_TO, 0, 0.7, -0.18, 1.33, -0.53, 1.91,
ARC_TO, 3.12, 3.12, 0, 0, 1, 4.5, 13.17,
CLOSE,
MOVE_TO, 10, 10,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kExtensionChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.6, 13.73,
R_CUBIC_TO, -0.37, 0, -0.69, -0.13, -0.95, -0.39,
R_ARC_TO, 1.28, 1.28, 0, 0, 1, -0.39, -0.95,
R_V_LINE_TO, -2.87,
R_CUBIC_TO, 0.42, -0.02, 0.77, -0.18, 1.05, -0.47,
ARC_TO, 1.46, 1.46, 0, 0, 0, 3.75, 8,
R_CUBIC_TO, 0, -0.41, -0.14, -0.76, -0.43, -1.05,
R_ARC_TO, 1.51, 1.51, 0, 0, 0, -1.05, -0.47,
V_LINE_TO, 3.6,
R_CUBIC_TO, 0, -0.37, 0.13, -0.69, 0.39, -0.95,
R_CUBIC_TO, 0.26, -0.26, 0.57, -0.39, 0.95, -0.39,
R_H_LINE_TO, 2.68,
R_CUBIC_TO, 0.03, -0.46, 0.21, -0.84, 0.53, -1.16,
R_ARC_TO, 1.63, 1.63, 0, 0, 1, 1.18, -0.47,
R_CUBIC_TO, 0.46, 0, 0.86, 0.16, 1.18, 0.47,
R_CUBIC_TO, 0.33, 0.31, 0.51, 0.7, 0.54, 1.16,
R_H_LINE_TO, 2.68,
R_CUBIC_TO, 0.37, 0, 0.69, 0.13, 0.95, 0.39,
R_CUBIC_TO, 0.26, 0.26, 0.39, 0.57, 0.39, 0.95,
R_V_LINE_TO, 2.68,
R_CUBIC_TO, 0.46, 0.03, 0.84, 0.21, 1.16, 0.53,
R_CUBIC_TO, 0.32, 0.33, 0.47, 0.72, 0.47, 1.18,
R_CUBIC_TO, 0, 0.46, -0.16, 0.86, -0.47, 1.18,
R_CUBIC_TO, -0.31, 0.33, -0.7, 0.51, -1.16, 0.54,
R_V_LINE_TO, 2.68,
R_CUBIC_TO, 0, 0.37, -0.13, 0.69, -0.39, 0.95,
R_CUBIC_TO, -0.26, 0.26, -0.57, 0.39, -0.95, 0.39,
CLOSE,
R_MOVE_TO, 0.05, -1.38,
R_H_LINE_TO, 8.7,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
R_V_LINE_TO, 1.81,
R_CUBIC_TO, 0.47, 0.25, 0.83, 0.61, 1.09, 1.07,
R_CUBIC_TO, 0.26, 0.46, 0.39, 0.95, 0.39, 1.48,
R_CUBIC_TO, 0, 0.54, -0.13, 1.05, -0.39, 1.5,
R_ARC_TO, 2.58, 2.58, 0, 0, 1, -1.09, 1.04,
CLOSE,
MOVE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionChromeRefreshRepList, kExtensionChromeRefreshIcon, {kExtensionChromeRefreshPath}, {kExtensionChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kExtensionOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, 1, -3.25,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 4.5,
H_LINE_TO, 6.63,
LINE_TO, 5.13, 3,
H_LINE_TO, 8,
R_CUBIC_TO, 0, -0.56, 0.19, -1.03, 0.58, -1.42,
ARC_TO, 1.93, 1.93, 0, 0, 1, 10, 1,
R_CUBIC_TO, 0.56, 0, 1.03, 0.19, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_H_LINE_TO, 3.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 8,
R_ARC_TO, 1.94, 1.94, 0, 0, 1, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_CUBIC_TO, 0, 0.56, -0.19, 1.03, -0.58, 1.42,
ARC_TO, 1.94, 1.94, 0, 0, 1, 17, 12,
CLOSE,
MOVE_TO, 11.54, 8.52,
CLOSE,
R_MOVE_TO, -2.15, 2.15,
CLOSE,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 12,
R_ARC_TO, 2.12, 2.12, 0, 0, 0, 1.42, -0.61,
ARC_TO, 1.88, 1.88, 0, 0, 0, 5, 10,
R_ARC_TO, 1.88, 1.88, 0, 0, 0, -0.58, -1.39,
ARC_TO, 2.12, 2.12, 0, 0, 0, 3, 8,
V_LINE_TO, 4.52,
R_CUBIC_TO, 0, -0.2, 0.05, -0.38, 0.14, -0.56,
R_CUBIC_TO, 0.09, -0.17, 0.21, -0.32, 0.36, -0.46,
R_LINE_TO, 1, 1,
R_V_LINE_TO, 2.33,
R_ARC_TO, 3.23, 3.23, 0, 0, 1, 1.47, 1.28,
CUBIC_TO, 6.32, 8.69, 6.5, 9.32, 6.5, 10,
R_CUBIC_TO, 0, 0.7, -0.18, 1.33, -0.53, 1.91,
ARC_TO, 3.12, 3.12, 0, 0, 1, 4.5, 13.17,
V_LINE_TO, 15.5,
R_H_LINE_TO, 11,
R_LINE_TO, 1, 1,
R_CUBIC_TO, -0.15, 0.14, -0.32, 0.25, -0.49, 0.33,
R_CUBIC_TO, -0.18, 0.09, -0.36, 0.14, -0.56, 0.17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionOffRepList, kExtensionOffIcon, {kExtensionOffPath})
VECTOR_ICON_REP_TEMPLATE(kExtensionOnPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 5.5, 7,
H_LINE_TO, 4.96,
R_LINE_TO, 1.5, -1.5,
H_LINE_TO, 15.5,
R_V_LINE_TO, -11,
R_H_LINE_TO, -11,
R_V_LINE_TO, 2.33,
R_CUBIC_TO, 0.48, 0.24, 0.9, 0.56, 1.24, 0.97,
R_CUBIC_TO, 0.34, 0.41, 0.57, 0.87, 0.68, 1.39,
LINE_TO, 4.86, 10.75,
R_CUBIC_TO, 0.06, -0.11, 0.09, -0.23, 0.11, -0.35,
R_CUBIC_TO, 0.02, -0.12, 0.03, -0.25, 0.03, -0.4,
R_ARC_TO, 1.88, 1.88, 0, 0, 0, -0.58, -1.39,
ARC_TO, 2.12, 2.12, 0, 0, 0, 3, 8,
V_LINE_TO, 4.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
H_LINE_TO, 8,
R_CUBIC_TO, 0, -0.56, 0.19, -1.03, 0.58, -1.42,
ARC_TO, 1.93, 1.93, 0, 0, 1, 10, 1,
R_CUBIC_TO, 0.56, 0, 1.03, 0.19, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_H_LINE_TO, 3.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 8,
R_ARC_TO, 1.94, 1.94, 0, 0, 1, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
R_CUBIC_TO, 0, 0.56, -0.19, 1.03, -0.58, 1.42,
ARC_TO, 1.94, 1.94, 0, 0, 1, 17, 12,
R_V_LINE_TO, 3.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 15.5, 17,
CLOSE,
MOVE_TO, 3.83, 16,
LINE_TO, 1, 13.19,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 1.77, 1.77,
LINE_TO, 7.73, 10,
R_LINE_TO, 1.04, 1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionOnRepList, kExtensionOnIcon, {kExtensionOnPath})
VECTOR_ICON_REP_TEMPLATE(kFamilyLinkPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 4.63, 8,
R_LINE_TO, 5.69, -6,
LINE_TO, 16, 8,
R_LINE_TO, -5.81, 8.87,
R_CUBIC_TO, -0.08, 0.12, -0.18, 0.24, -0.28, 0.35,
R_ARC_TO, 2.44, 2.44, 0, 0, 1, -1.78, 0.78,
R_ARC_TO, 2.44, 2.44, 0, 0, 1, -1.78, -0.78,
R_ARC_TO, 2.72, 2.72, 0, 0, 1, -0.74, -1.88,
R_CUBIC_TO, 0, -0.36, -0.13, -0.69, -0.37, -0.94,
R_ARC_TO, 1.21, 1.21, 0, 0, 0, -0.89, -0.39,
H_LINE_TO, 4,
R_V_LINE_TO, -1.33,
R_H_LINE_TO, 0.33,
R_CUBIC_TO, 0.68, 0, 1.31, 0.28, 1.78, 0.78,
R_CUBIC_TO, 0.48, 0.5, 0.74, 1.17, 0.74, 1.88,
R_CUBIC_TO, 0, 0.36, 0.13, 0.69, 0.37, 0.95,
R_CUBIC_TO, 0.24, 0.26, 0.55, 0.39, 0.9, 0.39,
R_CUBIC_TO, 0.34, 0, 0.65, -0.14, 0.9, -0.39,
R_LINE_TO, 0.04, -0.04,
R_CUBIC_TO, 0.04, -0.04, 0.07, -0.09, 0.11, -0.14,
R_LINE_TO, 0.4, -0.6,
LINE_TO, 4.63, 8,
CLOSE,
R_MOVE_TO, 5.69, 5.94,
LINE_TO, 6.54, 8.17,
R_LINE_TO, 3.78, -3.99,
R_LINE_TO, 3.78, 3.99,
R_LINE_TO, -3.78, 5.77,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFamilyLinkRepList, kFamilyLinkIcon, {kFamilyLinkPath})
VECTOR_ICON_REP_TEMPLATE(kFeedbackPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 480, 600,
R_QUADRATIC_TO, 17, 0, 28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 520, 560,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 480, 520,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 440, 560,
R_QUADRATIC_TO, 0, 17, 11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 480, 600,
CLOSE,
R_MOVE_TO, -40, -160,
R_H_LINE_TO, 80,
R_V_LINE_TO, -240,
R_H_LINE_TO, -80,
R_V_LINE_TO, 240,
CLOSE,
MOVE_TO, 80, 880,
R_V_LINE_TO, -720,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 80,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 160,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 720,
H_LINE_TO, 240,
LINE_TO, 80, 880,
CLOSE,
R_MOVE_TO, 126, -240,
R_H_LINE_TO, 594,
R_V_LINE_TO, -480,
H_LINE_TO, 160,
R_V_LINE_TO, 525,
R_LINE_TO, 46, -45,
CLOSE,
R_MOVE_TO, -46, 0,
R_V_LINE_TO, -480,
R_V_LINE_TO, 480,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFeedbackRepList, kFeedbackIcon, {kFeedbackPath})
VECTOR_ICON_REP_TEMPLATE(kFileDownloadPath, MOVE_TO, 38, 18,
R_H_LINE_TO, -8,
V_LINE_TO, 6,
H_LINE_TO, 18,
R_V_LINE_TO, 12,
R_H_LINE_TO, -8,
R_LINE_TO, 14, 14,
R_LINE_TO, 14, -14,
CLOSE,
MOVE_TO, 10, 36,
R_V_LINE_TO, 4,
R_H_LINE_TO, 28,
R_V_LINE_TO, -4,
H_LINE_TO, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileDownloadRepList, kFileDownloadIcon, {kFileDownloadPath})
VECTOR_ICON_REP_TEMPLATE(kFileDownloadChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 13,
LINE_TO, 6, 9,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 2.19, 2.19,
V_LINE_TO, 3,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 7.13,
R_LINE_TO, 2.19, -2.19,
LINE_TO, 14, 9,
CLOSE,
R_MOVE_TO, -4.51, 3,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -1.05, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4, 14.5,
V_LINE_TO, 13,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 9,
V_LINE_TO, 13,
H_LINE_TO, 16,
R_V_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 14.5, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileDownloadChromeRefreshRepList, kFileDownloadChromeRefreshIcon, {kFileDownloadChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kFileDownloadOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 13.88, 16,
H_LINE_TO, 5.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4, 14.5,
V_LINE_TO, 13,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 6.88,
R_LINE_TO, -1.94, -1.94,
LINE_TO, 10, 13,
LINE_TO, 6, 9,
R_LINE_TO, 0.44, -0.44,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -3.44, -7.69,
LINE_TO, 11.5, 9.38,
R_LINE_TO, 1.44, -1.44,
LINE_TO, 14, 9,
CLOSE,
MOVE_TO, 10.75, 8.63,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 3,
R_H_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 5.25, 5.25,
LINE_TO, 15.13, 13,
H_LINE_TO, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileDownloadOffChromeRefreshRepList, kFileDownloadOffChromeRefreshIcon, {kFileDownloadOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kFilterPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9.5, 17,
V_LINE_TO, 12,
H_LINE_TO, 11,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 6,
R_V_LINE_TO, 1.5,
H_LINE_TO, 11,
V_LINE_TO, 17,
H_LINE_TO, 9.5,
CLOSE,
MOVE_TO, 3, 15.25,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 5,
R_V_LINE_TO, 1.5,
H_LINE_TO, 3,
CLOSE,
MOVE_TO, 6, 12.5,
V_LINE_TO, 10.75,
H_LINE_TO, 3,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 3,
V_LINE_TO, 7.5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 5,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 3, -1.75,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 8,
R_V_LINE_TO, 1.5,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 12, 8,
V_LINE_TO, 3,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.75,
H_LINE_TO, 17,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -3.5,
V_LINE_TO, 8,
H_LINE_TO, 12,
CLOSE,
MOVE_TO, 3, 6.25,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 8,
R_V_LINE_TO, 1.5,
H_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFilterRepList, kFilterIcon, {kFilterPath})
VECTOR_ICON_REP_TEMPLATE(kFingerprintPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 4,
R_CUBIC_TO, 1.6, 0, 3.07, 0.34, 4.42, 1.02,
R_CUBIC_TO, 1.35, 0.68, 2.35, 1.59, 3.02, 2.73,
R_CUBIC_TO, 0.07, 0.11, 0.08, 0.23, 0.04, 0.38,
R_ARC_TO, 0.55, 0.55, 0, 0, 1, -0.23, 0.31,
R_ARC_TO, 0.46, 0.46, 0, 0, 1, -0.37, 0.04,
R_ARC_TO, 0.56, 0.56, 0, 0, 1, -0.29, -0.23,
R_CUBIC_TO, -0.58, -1, -1.47, -1.79, -2.66, -2.37,
CUBIC_TO, 12.74, 5.29, 11.43, 5, 10, 5,
R_CUBIC_TO, -1.43, 0, -2.74, 0.29, -3.93, 0.88,
CUBIC_TO, 4.89, 6.46, 4, 7.25, 3.42, 8.25,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.67, 0.19,
R_ARC_TO, 0.55, 0.55, 0, 0, 1, -0.23, -0.31,
R_ARC_TO, 0.44, 0.44, 0, 0, 1, 0.04, -0.37,
R_CUBIC_TO, 0.67, -1.14, 1.67, -2.05, 3.02, -2.73,
CUBIC_TO, 6.93, 4.34, 8.4, 4, 10, 4,
CLOSE,
R_MOVE_TO, 0, 2,
R_CUBIC_TO, 1.79, 0, 3.32, 0.63, 4.58, 1.9,
R_CUBIC_TO, 1.27, 1.26, 1.9, 2.8, 1.9, 4.61,
R_CUBIC_TO, 0, 0.7, -0.24, 1.29, -0.72, 1.77,
R_CUBIC_TO, -0.48, 0.49, -1.07, 0.73, -1.76, 0.73,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, -0.73,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -0.73, -1.77,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.42, 1.42, 0, 0, 0, 10.02, 11,
R_CUBIC_TO, -0.4, 0, -0.75, 0.14, -1.05, 0.44,
R_CUBIC_TO, -0.3, 0.29, -0.45, 0.64, -0.45, 1.06,
R_CUBIC_TO, 0, 1.48, 0.42, 2.61, 1.24, 3.36,
CUBIC_TO, 10.59, 16.62, 11.5, 17, 12.5, 17,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.36, 0.14,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.14, 0.36,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.14, 0.36,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.35, 0.14,
R_CUBIC_TO, -1.22, 0, -2.36, -0.47, -3.41, -1.41,
R_CUBIC_TO, -1.05, -0.94, -1.57, -2.3, -1.57, -4.09,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.72, -1.77,
ARC_TO, 2.37, 2.37, 0, 0, 1, 10, 10,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.49, 0.49, 0.73, 1.08, 0.73, 1.77,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.29, 0.29, 0.64, 0.44, 1.04, 0.44,
R_CUBIC_TO, 0.4, 0, 0.75, -0.14, 1.05, -0.44,
R_CUBIC_TO, 0.3, -0.29, 0.45, -0.64, 0.45, -1.06,
R_CUBIC_TO, 0, -1.52, -0.54, -2.81, -1.61, -3.89,
CUBIC_TO, 12.81, 7.54, 11.52, 7, 10, 7,
R_CUBIC_TO, -1.52, 0, -2.8, 0.54, -3.87, 1.61,
CUBIC_TO, 5.06, 9.67, 4.52, 10.97, 4.52, 12.5,
R_CUBIC_TO, 0, 0.4, 0.04, 0.8, 0.13, 1.18,
R_CUBIC_TO, 0.09, 0.38, 0.21, 0.75, 0.38, 1.12,
R_CUBIC_TO, 0.07, 0.13, 0.08, 0.25, 0.03, 0.38,
R_ARC_TO, 0.53, 0.53, 0, 0, 1, -0.26, 0.29,
R_ARC_TO, 0.49, 0.49, 0, 0, 1, -0.39, 0.01,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.28, -0.26,
R_ARC_TO, 6.54, 6.54, 0, 0, 1, -0.44, -1.32,
R_ARC_TO, 6.55, 6.55, 0, 0, 1, -0.14, -1.39,
R_CUBIC_TO, 0, -1.8, 0.63, -3.34, 1.88, -4.61,
CUBIC_TO, 6.68, 6.63, 8.21, 6, 10, 6,
CLOSE,
R_MOVE_TO, 0, -4,
R_CUBIC_TO, 0.96, 0, 1.88, 0.12, 2.77, 0.36,
R_CUBIC_TO, 0.89, 0.24, 1.71, 0.57, 2.46, 1.02,
R_CUBIC_TO, 0.13, 0.07, 0.2, 0.17, 0.23, 0.3,
R_ARC_TO, 0.54, 0.54, 0, 0, 1, -0.06, 0.39,
R_ARC_TO, 0.53, 0.53, 0, 0, 1, -0.3, 0.23,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.39, -0.04,
R_ARC_TO, 8, 8, 0, 0, 0, -2.22, -0.91,
ARC_TO, 10.21, 10.21, 0, 0, 0, 10, 3.04,
R_CUBIC_TO, -0.85, 0, -1.68, 0.1, -2.49, 0.3,
R_ARC_TO, 8, 8, 0, 0, 0, -2.22, 0.91,
R_ARC_TO, 0.5, 0.5, 0, 0, 1, -0.69, -0.19,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.06, -0.36,
R_ARC_TO, 0.44, 0.44, 0, 0, 1, 0.23, -0.3,
R_ARC_TO, 9.2, 9.2, 0, 0, 1, 2.46, -1.04,
ARC_TO, 10.64, 10.64, 0, 0, 1, 10, 2,
CLOSE,
R_MOVE_TO, 0, 6,
R_CUBIC_TO, 1.06, 0, 1.99, 0.36, 2.8, 1.08,
R_CUBIC_TO, 0.81, 0.72, 1.34, 1.66, 1.58, 2.81,
R_CUBIC_TO, 0.03, 0.14, 0, 0.27, -0.07, 0.39,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.32, 0.22,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.38, -0.07,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.21, -0.32,
R_CUBIC_TO, -0.19, -0.92, -0.6, -1.66, -1.23, -2.24,
CUBIC_TO, 11.54, 9.29, 10.82, 9, 10, 9,
R_CUBIC_TO, -0.96, 0, -1.78, 0.39, -2.46, 1.17,
R_CUBIC_TO, -0.68, 0.78, -1.02, 1.72, -1.02, 2.83,
R_CUBIC_TO, 0, 0.75, 0.16, 1.48, 0.49, 2.19,
R_CUBIC_TO, 0.32, 0.71, 0.76, 1.27, 1.3, 1.69,
R_ARC_TO, 0.51, 0.51, 0, 0, 1, 0.2, 0.33,
R_ARC_TO, 0.49, 0.49, 0, 0, 1, -0.09, 0.38,
R_ARC_TO, 0.45, 0.45, 0, 0, 1, -0.34, 0.19,
R_ARC_TO, 0.52, 0.52, 0, 0, 1, -0.37, -0.1,
R_CUBIC_TO, -0.66, -0.53, -1.19, -1.22, -1.59, -2.06,
ARC_TO, 6.08, 6.08, 0, 0, 1, 5.52, 13,
R_CUBIC_TO, 0, -1.39, 0.43, -2.57, 1.3, -3.54,
CUBIC_TO, 7.69, 8.48, 8.75, 8, 10, 8,
CLOSE,
R_MOVE_TO, 0, 4,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.36, 0.14,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.14, 0.36,
R_CUBIC_TO, 0, 1.04, 0.36, 1.83, 1.08, 2.38,
R_ARC_TO, 3.9, 3.9, 0, 0, 0, 2.4, 0.81,
R_CUBIC_TO, 0.15, 0, 0.3, -0.02, 0.45, -0.04,
R_LINE_TO, 0.43, -0.08,
R_ARC_TO, 0.52, 0.52, 0, 0, 1, 0.37, 0.06,
R_CUBIC_TO, 0.13, 0.07, 0.2, 0.17, 0.23, 0.31,
R_ARC_TO, 0.53, 0.53, 0, 0, 1, -0.06, 0.39,
R_ARC_TO, 0.44, 0.44, 0, 0, 1, -0.31, 0.22,
R_CUBIC_TO, -0.19, 0.04, -0.38, 0.07, -0.55, 0.1,
R_CUBIC_TO, -0.17, 0.03, -0.36, 0.04, -0.55, 0.04,
R_CUBIC_TO, -1.32, 0, -2.4, -0.4, -3.23, -1.21,
R_CUBIC_TO, -0.83, -0.81, -1.25, -1.8, -1.25, -2.98,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.14, -0.35,
ARC_TO, 0.48, 0.48, 0, 0, 1, 10, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFingerprintRepList, kFingerprintIcon, {kFingerprintPath})
VECTOR_ICON_REP_TEMPLATE(kFingerprintOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 17.06, 18.48,
R_LINE_TO, -7.42, -7.44,
R_ARC_TO, 1.55, 1.55, 0, 0, 0, -0.81, 0.52,
R_ARC_TO, 1.41, 1.41, 0, 0, 0, -0.33, 0.94,
R_CUBIC_TO, 0, 1.48, 0.41, 2.61, 1.24, 3.36,
R_CUBIC_TO, 0.83, 0.76, 1.74, 1.14, 2.74, 1.14,
R_CUBIC_TO, 0.14, 0, 0.25, 0.05, 0.35, 0.14,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.15, 0.36,
R_CUBIC_TO, 0, 0.14, -0.05, 0.26, -0.15, 0.36,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.35, 0.14,
R_CUBIC_TO, -1.22, 0, -2.36, -0.47, -3.41, -1.41,
CUBIC_TO, 8.02, 15.66, 7.5, 14.29, 7.5, 12.5,
R_CUBIC_TO, 0, -0.48, 0.13, -0.93, 0.39, -1.32,
R_CUBIC_TO, 0.25, -0.39, 0.59, -0.7, 0.99, -0.91,
R_LINE_TO, -0.69, -0.66,
R_CUBIC_TO, -0.5, 0.36, -0.9, 0.84, -1.21, 1.43,
R_CUBIC_TO, -0.31, 0.59, -0.46, 1.25, -0.46, 1.97,
R_CUBIC_TO, 0, 0.75, 0.16, 1.48, 0.49, 2.19,
R_CUBIC_TO, 0.32, 0.71, 0.76, 1.27, 1.3, 1.69,
R_ARC_TO, 0.51, 0.51, 0, 0, 1, 0.2, 0.33,
R_ARC_TO, 0.49, 0.49, 0, 0, 1, -0.09, 0.38,
R_ARC_TO, 0.45, 0.45, 0, 0, 1, -0.34, 0.19,
R_ARC_TO, 0.52, 0.52, 0, 0, 1, -0.37, -0.1,
R_CUBIC_TO, -0.66, -0.53, -1.19, -1.22, -1.59, -2.06,
ARC_TO, 6.08, 6.08, 0, 0, 1, 5.52, 13,
R_CUBIC_TO, 0, -0.86, 0.18, -1.65, 0.53, -2.36,
R_CUBIC_TO, 0.36, -0.71, 0.83, -1.3, 1.41, -1.74,
R_LINE_TO, -0.75, -0.77,
R_ARC_TO, 5.58, 5.58, 0, 0, 0, -1.59, 1.89,
ARC_TO, 5.29, 5.29, 0, 0, 0, 4.52, 12.5,
R_CUBIC_TO, 0, 0.4, 0.04, 0.8, 0.13, 1.18,
R_CUBIC_TO, 0.09, 0.38, 0.21, 0.75, 0.38, 1.12,
R_CUBIC_TO, 0.07, 0.13, 0.08, 0.25, 0.03, 0.38,
R_ARC_TO, 0.53, 0.53, 0, 0, 1, -0.26, 0.29,
R_ARC_TO, 0.49, 0.49, 0, 0, 1, -0.39, 0.01,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.28, -0.26,
R_ARC_TO, 6.54, 6.54, 0, 0, 1, -0.44, -1.32,
R_ARC_TO, 6.55, 6.55, 0, 0, 1, -0.14, -1.39,
R_CUBIC_TO, 0, -1.04, 0.22, -2, 0.66, -2.87,
ARC_TO, 6.63, 6.63, 0, 0, 1, 6, 7.42,
LINE_TO, 5.08, 6.5,
R_CUBIC_TO, -0.35, 0.25, -0.66, 0.52, -0.94, 0.81,
R_ARC_TO, 4.76, 4.76, 0, 0, 0, -0.72, 0.94,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.67, 0.19,
R_ARC_TO, 0.56, 0.56, 0, 0, 1, -0.23, -0.3,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, 0.04, -0.39,
R_ARC_TO, 7.06, 7.06, 0, 0, 1, 1.81, -1.96,
LINE_TO, 1.5, 2.94,
R_LINE_TO, 0.73, -0.71,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 13.98, 12.5,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.37, -0.07,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.21, -0.32,
R_CUBIC_TO, -0.16, -0.84, -0.52, -1.53, -1.05, -2.08,
R_CUBIC_TO, -0.53, -0.55, -1.16, -0.88, -1.89, -0.99,
R_LINE_TO, -0.98, -0.98,
R_CUBIC_TO, 0.1, -0.03, 0.18, -0.05, 0.26, -0.05,
ARC_TO, 2.63, 2.63, 0, 0, 1, 10, 8,
R_CUBIC_TO, 1.06, 0, 1.99, 0.36, 2.8, 1.08,
R_CUBIC_TO, 0.81, 0.72, 1.34, 1.66, 1.58, 2.81,
R_CUBIC_TO, 0.03, 0.14, 0, 0.27, -0.07, 0.39,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.32, 0.22,
CLOSE,
MOVE_TO, 10, 2,
R_CUBIC_TO, 0.96, 0, 1.88, 0.12, 2.77, 0.36,
R_CUBIC_TO, 0.89, 0.24, 1.71, 0.57, 2.46, 1.02,
R_CUBIC_TO, 0.13, 0.07, 0.2, 0.17, 0.23, 0.3,
R_ARC_TO, 0.54, 0.54, 0, 0, 1, -0.06, 0.39,
R_ARC_TO, 0.53, 0.53, 0, 0, 1, -0.3, 0.23,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.39, -0.04,
R_ARC_TO, 8.03, 8.03, 0, 0, 0, -2.21, -0.91,
R_ARC_TO, 10.1, 10.1, 0, 0, 0, -2.48, -0.3,
R_CUBIC_TO, -0.8, 0, -1.59, 0.09, -2.36, 0.27,
R_CUBIC_TO, -0.77, 0.18, -1.48, 0.45, -2.14, 0.81,
R_LINE_TO, -0.73, -0.75,
R_ARC_TO, 9.62, 9.62, 0, 0, 1, 2.44, -1.02,
ARC_TO, 10.56, 10.56, 0, 0, 1, 10, 2,
CLOSE,
R_MOVE_TO, 0, 2,
R_CUBIC_TO, 1.6, 0, 3.07, 0.34, 4.42, 1.02,
R_CUBIC_TO, 1.35, 0.68, 2.35, 1.59, 3.02, 2.73,
R_ARC_TO, 0.5, 0.5, 0, 0, 1, -0.19, 0.69,
R_ARC_TO, 0.46, 0.46, 0, 0, 1, -0.37, 0.04,
R_ARC_TO, 0.56, 0.56, 0, 0, 1, -0.29, -0.23,
R_CUBIC_TO, -0.58, -1, -1.47, -1.79, -2.66, -2.37,
CUBIC_TO, 12.74, 5.29, 11.43, 5, 10, 5,
R_ARC_TO, 9.45, 9.45, 0, 0, 0, -3.06, 0.52,
R_LINE_TO, -0.75, -0.75,
ARC_TO, 9.73, 9.73, 0, 0, 1, 10, 4,
CLOSE,
R_MOVE_TO, 0, 2,
R_CUBIC_TO, 1.79, 0, 3.32, 0.63, 4.57, 1.9,
R_CUBIC_TO, 1.25, 1.26, 1.88, 2.8, 1.88, 4.61,
R_CUBIC_TO, 0, 0.36, -0.07, 0.69, -0.19, 0.99,
R_CUBIC_TO, -0.13, 0.3, -0.32, 0.57, -0.56, 0.81,
LINE_TO, 15, 13.58,
R_CUBIC_TO, 0.15, -0.14, 0.27, -0.3, 0.36, -0.48,
R_ARC_TO, 1.46, 1.46, 0, 0, 0, 0.13, -0.6,
R_CUBIC_TO, 0, -1.52, -0.53, -2.81, -1.6, -3.89,
CUBIC_TO, 12.81, 7.54, 11.52, 7, 10, 7,
R_CUBIC_TO, -0.23, 0, -0.47, 0.02, -0.71, 0.04,
R_ARC_TO, 3.64, 3.64, 0, 0, 0, -0.69, 0.14,
R_LINE_TO, -0.79, -0.79,
R_ARC_TO, 6.79, 6.79, 0, 0, 1, 1.06, -0.29,
CUBIC_TO, 9.24, 6.04, 9.61, 6, 10, 6,
CLOSE,
R_MOVE_TO, 3.98, 10.67,
R_CUBIC_TO, -1.22, 0, -2.28, -0.37, -3.16, -1.12,
R_CUBIC_TO, -0.88, -0.75, -1.32, -1.78, -1.32, -3.09,
R_CUBIC_TO, 0, -0.12, 0.05, -0.23, 0.14, -0.32,
ARC_TO, 0.47, 0.47, 0, 0, 1, 9.98, 12,
R_CUBIC_TO, 0.14, 0, 0.26, 0.04, 0.36, 0.11,
R_ARC_TO, 0.36, 0.36, 0, 0, 1, 0.16, 0.31,
R_CUBIC_TO, 0, 1.03, 0.34, 1.82, 1.03, 2.4,
R_CUBIC_TO, 0.69, 0.57, 1.5, 0.86, 2.45, 0.86,
R_CUBIC_TO, 0.14, 0, 0.28, -0.01, 0.41, -0.02,
R_CUBIC_TO, 0.14, -0.01, 0.28, -0.04, 0.42, -0.06,
R_ARC_TO, 0.35, 0.35, 0, 0, 1, 0.33, 0.09,
R_CUBIC_TO, 0.1, 0.09, 0.16, 0.2, 0.19, 0.32,
R_ARC_TO, 0.43, 0.43, 0, 0, 1, -0.06, 0.34,
R_ARC_TO, 0.44, 0.44, 0, 0, 1, -0.29, 0.2,
R_CUBIC_TO, -0.17, 0.04, -0.33, 0.07, -0.5, 0.09,
R_ARC_TO, 4.35, 4.35, 0, 0, 1, -0.5, 0.03,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFingerprintOffRepList, kFingerprintOffIcon, {kFingerprintOffPath})
VECTOR_ICON_REP_TEMPLATE(kFlightPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7, 18,
R_V_LINE_TO, -1,
R_LINE_TO, 1.75, -1.31,
R_V_LINE_TO, -4.62,
LINE_TO, 2, 13,
R_V_LINE_TO, -1.5,
R_LINE_TO, 6.75, -3.85,
V_LINE_TO, 3.25,
R_CUBIC_TO, 0, -0.35, 0.12, -0.64, 0.36, -0.89,
CUBIC_TO, 9.36, 2.12, 9.65, 2, 10, 2,
R_CUBIC_TO, 0.35, 0, 0.64, 0.12, 0.89, 0.36,
R_CUBIC_TO, 0.24, 0.25, 0.36, 0.54, 0.36, 0.89,
R_V_LINE_TO, 4.39,
LINE_TO, 18, 11.5,
V_LINE_TO, 13,
R_LINE_TO, -6.75, -1.94,
R_V_LINE_TO, 4.63,
LINE_TO, 13, 17,
R_V_LINE_TO, 1,
R_LINE_TO, -3, -1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFlightRepList, kFlightIcon, {kFlightPath})
VECTOR_ICON_REP_TEMPLATE(kFolderPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 4.8, 5,
CUBIC_TO, 3.26, 5, 2.01, 6.29, 2.01, 7.88,
LINE_TO, 2, 25.13,
CUBIC_TO, 2, 26.71, 3.26, 28, 4.8, 28,
LINE_TO, 27.2, 28,
CUBIC_TO, 28.74, 28, 30, 26.71, 30, 25.13,
LINE_TO, 30, 10.75,
CUBIC_TO, 30, 9.17, 28.54, 8, 27, 8,
LINE_TO, 16, 8,
LINE_TO, 13.2, 5,
LINE_TO, 4.8, 5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kFolder16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.5, 2,
CUBIC_TO, 1.73, 2, 1.01, 3.15, 1.01, 3.94,
LINE_TO, 1, 12.56,
CUBIC_TO, 1, 13.35, 1.63, 14, 2.4, 14,
LINE_TO, 13.6, 14,
CUBIC_TO, 14.37, 14, 15, 13.35, 15, 12.56,
LINE_TO, 15, 5.38,
CUBIC_TO, 15, 4.58, 14.27, 4, 13.5, 4,
LINE_TO, 9, 4,
LINE_TO, 7, 2,
LINE_TO, 2.5, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFolderRepList, kFolderIcon, {kFolderPath}, {kFolder16Path})
VECTOR_ICON_REP_TEMPLATE(kFolderChromeRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 4, 20,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 6,
R_LINE_TO, 2, 2,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
R_CUBIC_TO, -0.39, 0.39, -0.86, 0.59, -1.41, 0.59,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 16,
V_LINE_TO, 8,
R_H_LINE_TO, -8.82,
R_LINE_TO, -2, -2,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kFolderChromeRefresh20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 16,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3.5, 4,
H_LINE_TO, 8,
R_LINE_TO, 2, 2,
R_H_LINE_TO, 6.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 13,
R_V_LINE_TO, -7,
H_LINE_TO, 9.38,
R_LINE_TO, -2, -2,
H_LINE_TO, 3.5,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFolderChromeRefreshRepList, kFolderChromeRefreshIcon, {kFolderChromeRefreshPath}, {kFolderChromeRefresh20Path})
VECTOR_ICON_REP_TEMPLATE(kFolderManagedRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
R_MOVE_TO, 17, 22,
R_LINE_TO, -0.3, -1.5,
R_ARC_TO, 7.56, 7.56, 0, 0, 1, -0.56, -0.26,
R_ARC_TO, 4.18, 4.18, 0, 0, 1, -0.53, -0.34,
R_LINE_TO, -1.45, 0.45,
R_LINE_TO, -1, -1.7,
R_LINE_TO, 1.15, -1,
R_CUBIC_TO, -0.04, -0.2, -0.05, -0.41, -0.05, -0.65,
R_CUBIC_TO, 0, -0.23, 0.02, -0.45, 0.05, -0.65,
R_LINE_TO, -1.15, -1,
R_LINE_TO, 1, -1.7,
R_LINE_TO, 1.45, 0.45,
R_CUBIC_TO, 0.18, -0.14, 0.36, -0.25, 0.54, -0.34,
R_CUBIC_TO, 0.18, -0.09, 0.36, -0.18, 0.56, -0.26,
LINE_TO, 17, 12,
R_H_LINE_TO, 2,
R_LINE_TO, 0.3, 1.5,
R_CUBIC_TO, 0.2, 0.08, 0.39, 0.17, 0.56, 0.26,
R_CUBIC_TO, 0.18, 0.09, 0.35, 0.2, 0.54, 0.34,
R_LINE_TO, 1.45, -0.45,
R_LINE_TO, 1, 1.7,
R_LINE_TO, -1.15, 1,
R_CUBIC_TO, 0.04, 0.2, 0.05, 0.41, 0.05, 0.65,
R_CUBIC_TO, 0, 0.23, -0.02, 0.45, -0.05, 0.65,
R_LINE_TO, 1.15, 1,
R_LINE_TO, -1, 1.7,
R_LINE_TO, -1.45, -0.45,
R_CUBIC_TO, -0.18, 0.14, -0.36, 0.25, -0.53, 0.34,
R_ARC_TO, 7.56, 7.56, 0, 0, 1, -0.56, 0.26,
LINE_TO, 19, 22,
CLOSE,
R_MOVE_TO, 1, -3,
R_CUBIC_TO, 0.55, 0, 1.02, -0.19, 1.41, -0.59,
R_CUBIC_TO, 0.39, -0.39, 0.59, -0.86, 0.59, -1.41,
R_CUBIC_TO, 0, -0.55, -0.19, -1.02, -0.59, -1.41,
ARC_TO, 1.94, 1.94, 0, 0, 0, 18, 15,
R_CUBIC_TO, -0.55, 0, -1.02, 0.2, -1.41, 0.59,
R_CUBIC_TO, -0.39, 0.39, -0.59, 0.86, -0.59, 1.41,
R_CUBIC_TO, 0, 0.55, 0.2, 1.02, 0.59, 1.41,
R_CUBIC_TO, 0.39, 0.39, 0.86, 0.59, 1.41, 0.59,
CLOSE,
MOVE_TO, 4, 18,
V_LINE_TO, 6,
R_V_LINE_TO, 4.3,
R_V_LINE_TO, -0.3,
CLOSE,
R_MOVE_TO, 0, 2,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 6,
R_LINE_TO, 2, 2,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 3.27,
R_ARC_TO, 6.46, 6.46, 0, 0, 0, -0.95, -0.56,
ARC_TO, 8.89, 8.89, 0, 0, 0, 20, 10.3,
V_LINE_TO, 8,
R_H_LINE_TO, -8.82,
R_LINE_TO, -2, -2,
H_LINE_TO, 4,
R_V_LINE_TO, 12,
R_H_LINE_TO, 7.07,
R_CUBIC_TO, 0.05, 0.35, 0.13, 0.69, 0.24, 1.02,
R_CUBIC_TO, 0.11, 0.34, 0.24, 0.66, 0.39, 0.98,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kFolderManagedRefresh20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 14.83, 18,
R_LINE_TO, -0.27, -1.17,
R_ARC_TO, 3.9, 3.9, 0, 0, 1, -0.55, -0.24,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, -0.49, -0.34,
R_LINE_TO, -1.14, 0.36,
R_LINE_TO, -0.67, -1.15,
R_LINE_TO, 0.86, -0.83,
R_ARC_TO, 2.73, 2.73, 0, 0, 1, -0.06, -0.61,
R_CUBIC_TO, 0, -0.22, 0.02, -0.42, 0.06, -0.62,
R_LINE_TO, -0.86, -0.81,
R_LINE_TO, 0.67, -1.14,
R_LINE_TO, 1.13, 0.33,
R_CUBIC_TO, 0.15, -0.15, 0.32, -0.28, 0.5, -0.37,
R_CUBIC_TO, 0.18, -0.1, 0.37, -0.17, 0.56, -0.23,
LINE_TO, 14.83, 10,
R_H_LINE_TO, 1.34,
R_LINE_TO, 0.27, 1.17,
R_CUBIC_TO, 0.2, 0.07, 0.39, 0.15, 0.57, 0.24,
R_CUBIC_TO, 0.19, 0.09, 0.35, 0.21, 0.49, 0.36,
R_LINE_TO, 1.13, -0.31,
R_LINE_TO, 0.67, 1.15,
R_LINE_TO, -0.84, 0.79,
R_CUBIC_TO, 0.04, 0.19, 0.06, 0.39, 0.06, 0.61,
R_CUBIC_TO, 0, 0.22, -0.02, 0.43, -0.06, 0.62,
R_LINE_TO, 0.86, 0.81,
R_LINE_TO, -0.67, 1.14,
R_LINE_TO, -1.14, -0.33,
R_CUBIC_TO, -0.15, 0.14, -0.32, 0.25, -0.5, 0.34,
R_ARC_TO, 4.5, 4.5, 0, 0, 1, -0.56, 0.24,
LINE_TO, 16.17, 18,
CLOSE,
R_MOVE_TO, 0.67, -2.5,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
R_ARC_TO, 1.45, 1.45, 0, 0, 0, -1.06, -0.44,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 14, 14,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 3.5, 14.5,
R_V_LINE_TO, -9,
R_V_LINE_TO, 3.11,
V_LINE_TO, 8.5,
CLOSE,
R_MOVE_TO, 0, 1.5,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3.5, 4,
H_LINE_TO, 8,
R_LINE_TO, 2, 2,
R_H_LINE_TO, 6.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 1.65,
R_ARC_TO, 5.86, 5.86, 0, 0, 0, -0.72, -0.32,
R_ARC_TO, 5.07, 5.07, 0, 0, 0, -0.78, -0.22,
V_LINE_TO, 7.5,
H_LINE_TO, 9.38,
R_LINE_TO, -2, -2,
H_LINE_TO, 3.5,
R_V_LINE_TO, 9,
R_H_LINE_TO, 6.52,
R_CUBIC_TO, 0.03, 0.26, 0.07, 0.52, 0.14, 0.77,
R_CUBIC_TO, 0.06, 0.25, 0.14, 0.5, 0.24, 0.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFolderManagedRefreshRepList, kFolderManagedRefreshIcon, {kFolderManagedRefreshPath}, {kFolderManagedRefresh20Path})
VECTOR_ICON_REP_TEMPLATE(kFolderOpenPath, MOVE_TO, 40, 12,
H_LINE_TO, 24,
R_LINE_TO, -4, -4,
H_LINE_TO, 8,
R_CUBIC_TO, -2.21, 0, -3.98, 1.79, -3.98, 4,
LINE_TO, 4, 36,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 32,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 16,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
R_MOVE_TO, 0, 24,
H_LINE_TO, 8,
V_LINE_TO, 16,
R_H_LINE_TO, 32,
R_V_LINE_TO, 20,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFolderOpenRepList, kFolderOpenIcon, {kFolderOpenPath})
VECTOR_ICON_REP_TEMPLATE(kFontDownloadPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 2,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 16,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 16,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, 0, 18,
H_LINE_TO, 4,
V_LINE_TO, 4,
R_H_LINE_TO, 16,
R_V_LINE_TO, 16,
CLOSE,
MOVE_TO, 10.69, 6,
R_H_LINE_TO, 2.6,
R_LINE_TO, 4.51, 12,
R_H_LINE_TO, -2.5,
R_LINE_TO, -1.01, -2.87,
H_LINE_TO, 9.7,
LINE_TO, 8.7, 18,
H_LINE_TO, 6.2,
R_LINE_TO, 4.49, -12,
CLOSE,
R_MOVE_TO, 2.87, 7.06,
R_LINE_TO, -1.06, -3.02,
R_LINE_TO, -0.43, -1.44,
R_H_LINE_TO, -0.13,
R_LINE_TO, -0.44, 1.44,
R_LINE_TO, -1.07, 3.02,
R_H_LINE_TO, 3.13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFontDownloadRepList, kFontDownloadIcon, {kFontDownloadPath})
VECTOR_ICON_REP_TEMPLATE(kFontDownloadChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 5.36, 15,
H_LINE_TO, 7.09,
LINE_TO, 8, 12.44,
R_H_LINE_TO, 4.02,
LINE_TO, 12.92, 15,
R_H_LINE_TO, 1.72,
R_LINE_TO, -3.75, -10,
R_H_LINE_TO, -1.79,
CLOSE,
MOVE_TO, 8.5, 11,
R_LINE_TO, 1.46, -4.14,
R_H_LINE_TO, 0.06,
LINE_TO, 11.48, 11,
CLOSE,
R_MOVE_TO, -5, 7,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
R_V_LINE_TO, -13,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 2,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 13,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 18,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 13,
R_V_LINE_TO, -13,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 0, -13,
R_V_LINE_TO, 13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFontDownloadChromeRefreshRepList, kFontDownloadChromeRefreshIcon, {kFontDownloadChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kFontDownloadOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.73, 18.83,
LINE_TO, 15.88, 18,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 4.13,
R_LINE_TO, -0.83, -0.85,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 3.5, 16.5,
R_H_LINE_TO, 10.88,
LINE_TO, 3.5, 5.63,
CLOSE,
R_MOVE_TO, 14.5, -0.62,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 3.5,
H_LINE_TO, 5.63,
LINE_TO, 4.13, 2,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE,
R_MOVE_TO, -4.83, -4.83,
LINE_TO, 10.61, 8.48,
R_LINE_TO, -0.56, -1.62,
R_H_LINE_TO, -0.09,
R_LINE_TO, -0.25, 0.73,
R_LINE_TO, -1.14, -1.14,
LINE_TO, 9.11, 5,
R_H_LINE_TO, 1.79,
CLOSE,
R_MOVE_TO, -4.27, 0.04,
CLOSE,
R_MOVE_TO, 1.71, -2.58,
CLOSE,
R_MOVE_TO, 2.19, 6.27,
R_LINE_TO, -1.06, -3.04,
R_LINE_TO, 2.71, 2.71,
R_LINE_TO, 0.13, 0.33,
CLOSE,
MOVE_TO, 5.33, 15,
LINE_TO, 7.98, 7.98,
R_LINE_TO, 1.19, 1.19,
LINE_TO, 8.52, 11,
R_H_LINE_TO, 2.48,
R_LINE_TO, 1.43, 1.44,
H_LINE_TO, 8.06,
LINE_TO, 7.17, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFontDownloadOffChromeRefreshRepList, kFontDownloadOffChromeRefreshIcon, {kFontDownloadOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kForward10Path, CANVAS_DIMENSIONS, 960,
MOVE_TO, 360, 640,
R_V_LINE_TO, -180,
R_H_LINE_TO, -60,
R_V_LINE_TO, -60,
R_H_LINE_TO, 120,
R_V_LINE_TO, 240,
R_H_LINE_TO, -60,
CLOSE,
R_MOVE_TO, 140, 0,
R_QUADRATIC_TO, -17, 0, -28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 460, 600,
R_V_LINE_TO, -160,
R_QUADRATIC_TO, 0, -17, 11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 500, 400,
R_H_LINE_TO, 80,
R_QUADRATIC_TO, 17, 0, 28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 620, 440,
R_V_LINE_TO, 160,
R_QUADRATIC_TO, 0, 17, -11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 580, 640,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 20, -60,
R_H_LINE_TO, 40,
R_V_LINE_TO, -120,
R_H_LINE_TO, -40,
R_V_LINE_TO, 120,
CLOSE,
MOVE_TO, 480, 880,
R_QUADRATIC_TO, -75, 0, -140.5, -28.5,
R_QUADRATIC_TO, -65.5, -28.5, -114, -77,
R_QUADRATIC_TO, -48.5, -48.5, -77, -114,
QUADRATIC_TO_SHORTHAND, 120, 520,
R_QUADRATIC_TO, 0, -75, 28.5, -140.5,
R_QUADRATIC_TO, 28.5, -65.5, 77, -114,
R_QUADRATIC_TO, 48.5, -48.5, 114, -77,
QUADRATIC_TO_SHORTHAND, 480, 160,
R_H_LINE_TO, 6,
R_LINE_TO, -62, -62,
R_LINE_TO, 56, -58,
R_LINE_TO, 160, 160,
R_LINE_TO, -160, 160,
R_LINE_TO, -56, -58,
R_LINE_TO, 62, -62,
R_H_LINE_TO, -6,
R_QUADRATIC_TO, -117, 0, -198.5, 81.5,
QUADRATIC_TO_SHORTHAND, 200, 520,
R_QUADRATIC_TO, 0, 117, 81.5, 198.5,
QUADRATIC_TO_SHORTHAND, 480, 800,
R_QUADRATIC_TO, 117, 0, 198.5, -81.5,
QUADRATIC_TO_SHORTHAND, 760, 520,
R_H_LINE_TO, 80,
R_QUADRATIC_TO, 0, 75, -28.5, 140.5,
R_QUADRATIC_TO, -28.5, 65.5, -77, 114,
R_QUADRATIC_TO, -48.5, 48.5, -114, 77,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kForward10RepList, kForward10Icon, {kForward10Path})
VECTOR_ICON_REP_TEMPLATE(kForwardArrowPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 27.78, 14.03,
CUBIC_TO, 28.47, 14.15, 29, 14.77, 29, 15.5,
CUBIC_TO, 29, 16.25, 28.47, 16.86, 27.76, 16.98,
LINE_TO, 27.98, 17.19,
LINE_TO, 17.64, 27.51,
CUBIC_TO, 17.35, 27.81, 16.95, 28, 16.5, 28,
CUBIC_TO, 15.67, 28, 15, 27.33, 15, 26.5,
CUBIC_TO, 15, 26.05, 15.2, 25.65, 15.51, 25.38,
LINE_TO, 15.45, 25.32,
LINE_TO, 23.78, 17,
LINE_TO, 4.49, 17,
CUBIC_TO, 3.67, 17, 3, 16.33, 3, 15.5,
CUBIC_TO, 3, 14.67, 3.67, 14, 4.49, 14,
LINE_TO, 23.8, 14,
LINE_TO, 15.45, 5.66,
CUBIC_TO, 15.19, 5.34, 15, 4.94, 15, 4.5,
CUBIC_TO, 15, 3.68, 15.67, 3, 16.5, 3,
CUBIC_TO, 16.94, 3, 17.34, 3.2, 17.61, 3.5,
LINE_TO, 17.64, 3.47,
LINE_TO, 28, 13.81,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kForwardArrow16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7, 13.51,
LINE_TO, 11.51, 9,
LINE_TO, 2, 9,
CUBIC_TO, 1.45, 9, 1, 8.55, 1, 8,
CUBIC_TO, 1, 7.45, 1.45, 7, 2, 7,
LINE_TO, 11.51, 7,
LINE_TO, 7, 2.49,
CUBIC_TO, 7.03, 2.28, 7, 2.14, 7, 2,
CUBIC_TO, 7, 1.45, 7.45, 1, 8, 1,
CUBIC_TO, 8.14, 1, 8.28, 1.03, 8.41, 1.09,
LINE_TO, 8.49, 1,
LINE_TO, 15, 7.51,
LINE_TO, 14.91, 7.59,
CUBIC_TO, 14.97, 7.72, 15, 7.85, 15, 8,
CUBIC_TO, 15, 8.15, 14.97, 8.28, 14.91, 8.41,
LINE_TO, 15, 8.49,
LINE_TO, 8.49, 15,
CUBIC_TO, 8.28, 14.97, 8.14, 15, 8, 15,
CUBIC_TO, 7.45, 15, 7, 14.55, 7, 14,
CUBIC_TO, 7, 13.86, 7.03, 13.72, 7.09, 13.59,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kForwardArrowRepList, kForwardArrowIcon, {kForwardArrowPath}, {kForwardArrow16Path})
VECTOR_ICON_REP_TEMPLATE(kForwardArrowChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 13.13, 10.75,
H_LINE_TO, 4,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 9.13,
LINE_TO, 8.94, 5.06,
LINE_TO, 10, 4,
R_LINE_TO, 6, 6,
R_LINE_TO, -6, 6,
R_LINE_TO, -1.06, -1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kForwardArrowChromeRefreshRepList, kForwardArrowChromeRefreshIcon, {kForwardArrowChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kGlobePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 14.54,
R_CUBIC_TO, -0.9, 0, -1.75, -0.17, -2.54, -0.51,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -2.08, -1.4,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, -2.08,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, -0.51, -2.55,
R_CUBIC_TO, 0, -0.91, 0.17, -1.75, 0.51, -2.54,
ARC_TO, 6.53, 6.53, 0, 0, 1, 3.38, 3.38,
ARC_TO, 6.52, 6.52, 0, 0, 1, 5.46, 1.98,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, 2.55, -0.51,
R_CUBIC_TO, 0.91, 0, 1.75, 0.17, 2.54, 0.51,
R_CUBIC_TO, 0.79, 0.34, 1.48, 0.8, 2.07, 1.4,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, 1.4, 2.08,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, 0.51, 2.54,
R_CUBIC_TO, 0, 0.9, -0.17, 1.75, -0.51, 2.54,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, 2.08,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, -2.08, 1.4,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, -2.54, 0.51,
CLOSE,
MOVE_TO, 8, 13.15,
R_CUBIC_TO, 1.3, 0, 2.42, -0.41, 3.37, -1.25,
R_ARC_TO, 5.06, 5.06, 0, 0, 0, 1.72, -3.1,
R_CUBIC_TO, 0, 0.02, 0, 0.04, 0, 0.06,
R_V_LINE_TO, 0.05,
R_ARC_TO, 1.72, 1.72, 0, 0, 1, -0.34, 0.09,
R_CUBIC_TO, -0.11, 0.02, -0.23, 0.03, -0.36, 0.03,
R_H_LINE_TO, -2.37,
R_ARC_TO, 1.2, 1.2, 0, 0, 1, -0.88, -0.37,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -0.36, -0.88,
R_V_LINE_TO, -0.82,
H_LINE_TO, 5.87,
V_LINE_TO, 5.34,
R_CUBIC_TO, 0, -0.34, 0.13, -0.64, 0.37, -0.88,
R_CUBIC_TO, 0.25, -0.25, 0.54, -0.37, 0.88, -0.37,
R_H_LINE_TO, 0.82,
R_V_LINE_TO, -0.4,
R_CUBIC_TO, 0, -0.17, 0.03, -0.33, 0.09, -0.48,
R_ARC_TO, 0.89, 0.89, 0, 0, 1, 0.24, -0.35,
R_ARC_TO, 0.76, 0.76, 0, 0, 0, -0.16, -0.01,
H_LINE_TO, 8,
R_CUBIC_TO, -1.43, 0, -2.65, 0.5, -3.65, 1.5,
CUBIC_TO_SHORTHAND, 2.85, 6.57, 2.85, 8,
R_CUBIC_TO, 0, 0.01, 0, 0.03, 0, 0.04,
R_V_LINE_TO, 0.04,
R_H_LINE_TO, 3.36,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.48, 0.48, 0.73, 1.07, 0.73, 1.77,
R_V_LINE_TO, 0.82,
H_LINE_TO, 6.23,
R_V_LINE_TO, 1.45,
R_CUBIC_TO, 0.27, 0.11, 0.56, 0.18, 0.85, 0.23,
R_CUBIC_TO, 0.29, 0.05, 0.6, 0.07, 0.91, 0.07,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGlobeRepList, kGlobeIcon, {kGlobePath})
VECTOR_ICON_REP_TEMPLATE(kGoogleColorPath, PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
MOVE_TO, 43.5f, 20,
H_LINE_TO, 24,
R_V_LINE_TO, 8,
R_H_LINE_TO, 11.6f,
R_CUBIC_TO, -0.5f, 2.5f, -2.2f, 4.7f, -4.3f, 6.1f,
R_LINE_TO, 6.6f, 5,
R_CUBIC_TO, 3.9f, -3.5f, 6.1f, -8.6f, 6.1f, -14.7f,
CUBIC_TO, 44, 23, 43.7f, 21.3f, 43.5f, 20,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0F, 0x9D, 0x58,
MOVE_TO, 24.4f, 36.1f,
R_CUBIC_TO, -5.3f, 0, -9.8f, -3.5f, -11.4f, -8.2f,
R_H_LINE_TO, 0,
R_LINE_TO, -1.5f, 1.1f,
R_LINE_TO, -5.3f, 4,
R_V_LINE_TO, 0,
R_CUBIC_TO, 3.4f, 6.5f, 10.2f, 11, 18.2f, 11,
R_CUBIC_TO, 5.5f, 0, 10.1f, -1.8f, 13.5f, -4.8f,
R_LINE_TO, -6.6f, -5,
CUBIC_TO, 29.5f, 35.3f, 27.2f, 36.1f, 24.4f, 36.1f,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xCD, 0x40,
MOVE_TO, 13, 27.8f,
LINE_TO, 13, 27.8f,
R_CUBIC_TO, -0.4f, -1.2f, -0.6f, -2.5f, -0.6f, -3.8f,
R_CUBIC_TO, 0, -1.3f, 0.2f, -2.6f, 0.6f, -3.8f,
LINE_TO, 6.2f, 15,
CUBIC_TO, 4.8f, 17.7f, 4, 20.8f, 4, 24,
R_CUBIC_TO, 0, 3.2f, 0.8f, 6.3f, 2.2f, 9,
R_LINE_TO, 5.3f, -4,
LINE_TO, 13, 27.8f,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDB, 0x44, 0x37,
MOVE_TO, 24.4f, 4,
R_CUBIC_TO, -8, 0, -14.9f, 4.5f, -18.2f, 11,
R_LINE_TO, 6.8f, 5.2f,
R_CUBIC_TO, 1.6f, -4.7f, 6.1f, -8.2f, 11.4f, -8.2f,
R_CUBIC_TO, 3, 0, 5.7f, 1, 7.8f, 3,
R_LINE_TO, 5.8f, -5.7f,
CUBIC_TO, 34.5f, 6, 29.9f, 4, 24.4f, 4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kGoogleColor24Path, CANVAS_DIMENSIONS, 24,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
MOVE_TO, 21.73f, 10,
LINE_TO, 12, 10,
LINE_TO, 12, 14,
LINE_TO, 17.82f, 14,
CUBIC_TO, 17.58f, 15.25f, 16.73f, 16.35f, 15.65f, 17.06f,
LINE_TO, 15.65f, 19.58f,
LINE_TO, 18.96f, 19.58f,
CUBIC_TO, 20.89f, 17.84f, 22, 15.27f, 22, 12.23f,
CUBIC_TO, 22, 11.52f, 21.85f, 10.65f, 21.73f, 10,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0F, 0x9D, 0x58,
MOVE_TO, 12.2f, 22,
CUBIC_TO, 14.96f, 22, 17.27f, 21.11f, 18.96f, 19.58f,
LINE_TO, 15.65f, 17.06f,
CUBIC_TO, 14.74f, 17.66f, 13.58f, 18.03f, 12.2f, 18.03f,
CUBIC_TO, 9.55f, 18.03f, 7.3f, 16.27f, 6.49f, 13.91f,
LINE_TO, 3.09f, 13.91f,
LINE_TO, 3.09f, 16.49f,
CUBIC_TO, 4.77f, 19.75f, 8.22f, 22, 12.2f, 22,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xCD, 0x40,
MOVE_TO, 6.49f, 13.9f,
CUBIC_TO, 6.29f, 13.3f, 6.17f, 12.66f, 6.17f, 12,
CUBIC_TO, 6.17f, 11.34f, 6.29f, 10.7f, 6.49f, 10.1f,
LINE_TO, 6.49f, 7.52f,
LINE_TO, 3.09f, 7.52f,
CUBIC_TO, 2.4f, 8.86f, 2, 10.38f, 2, 12,
CUBIC_TO, 2, 13.62f, 2.4f, 15.14f, 3.09f, 16.48f,
LINE_TO, 5.74f, 14.46f,
LINE_TO, 6.49f, 13.9f,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDB, 0x44, 0x37,
MOVE_TO, 12.2f, 5.98f,
CUBIC_TO, 13.71f, 5.98f, 15.04f, 6.49f, 16.11f, 7.47f,
LINE_TO, 19.03f, 4.61f,
CUBIC_TO, 17.26f, 2.99f, 14.96f, 2, 12.2f, 2,
CUBIC_TO, 8.22f, 2, 4.77f, 4.25f, 3.09f, 7.52f,
LINE_TO, 6.49f, 10.1f,
CUBIC_TO, 7.3f, 7.74f, 9.55f, 5.98f, 12.2f, 5.98f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGoogleColorRepList, kGoogleColorIcon, {kGoogleColorPath}, {kGoogleColor24Path})
VECTOR_ICON_REP_TEMPLATE(kGppMaybePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 4.24,
R_LINE_TO, 6, 3,
R_V_LINE_TO, 4.1,
R_CUBIC_TO, 0, 3.9, -2.55, 7.5, -6, 8.59,
R_CUBIC_TO, -3.45, -1.09, -6, -4.7, -6, -8.59,
R_V_LINE_TO, -4.1,
R_LINE_TO, 6, -3,
MOVE_TO, 12, 2,
LINE_TO, 4, 6,
R_V_LINE_TO, 5.33,
R_CUBIC_TO, 0, 4.93, 3.41, 9.55, 8, 10.67,
R_CUBIC_TO, 4.59, -1.12, 8, -5.73, 8, -10.67,
V_LINE_TO, 6,
R_LINE_TO, -8, -4,
CLOSE,
R_MOVE_TO, -1, 13,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 2, -7,
R_H_LINE_TO, -2,
R_V_LINE_TO, 5,
R_H_LINE_TO, 2,
V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGppMaybeRepList, kGppMaybeIcon, {kGppMaybePath})
VECTOR_ICON_REP_TEMPLATE(kHandGesturePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 22, 5.02,
R_CUBIC_TO, 0, -0.85, -0.29, -1.57, -0.87, -2.15,
R_CUBIC_TO, -0.58, -0.58, -1.3, -0.87, -2.15, -0.87,
V_LINE_TO, 0.5,
R_CUBIC_TO, 1.25, 0, 2.32, 0.44, 3.2, 1.32,
R_CUBIC_TO, 0.88, 0.88, 1.32, 1.95, 1.32, 3.2,
CLOSE,
MOVE_TO, 6, 23,
R_CUBIC_TO, -1.38, 0, -2.56, -0.49, -3.54, -1.46,
CUBIC_TO, 1.49, 20.56, 1, 19.38, 1, 18,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.97, 0.34, 1.79, 1.02, 2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 6, 21.5,
CLOSE,
R_MOVE_TO, 4.05, 0,
R_CUBIC_TO, -0.5, 0, -0.97, -0.11, -1.4, -0.34,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, -1.07, -0.96,
LINE_TO, 1.2, 12.38,
R_LINE_TO, 0.6, -0.57,
R_CUBIC_TO, 0.32, -0.32, 0.69, -0.5, 1.13, -0.55,
R_CUBIC_TO, 0.43, -0.05, 0.82, 0.05, 1.18, 0.3,
LINE_TO, 7, 13.58,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 8, 3,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 13.43,
R_LINE_TO, -3.7, -2.6,
R_LINE_TO, 3.93, 5.73,
R_ARC_TO, 0.99, 0.99, 0, 0, 0, 0.82, 0.45,
LINE_TO, 17, 21,
R_CUBIC_TO, 0.55, 0, 1.02, -0.19, 1.41, -0.59,
R_CUBIC_TO, 0.39, -0.39, 0.59, -0.86, 0.59, -1.41,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 20, 4,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, -0.39, 2.04, -1.18, 2.82,
CUBIC_TO, 19.04, 22.61, 18.1, 23, 17, 23,
CLOSE,
MOVE_TO, 11, 12,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 12, 1,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 10,
CLOSE,
R_MOVE_TO, 4, 0,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 9,
CLOSE,
R_MOVE_TO, -2.85, 4.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHandGestureRepList, kHandGestureIcon, {kHandGesturePath})
VECTOR_ICON_REP_TEMPLATE(kHandGestureOffPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
R_MOVE_TO, 21, 18.15,
R_LINE_TO, -2, -2,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 20, 4,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
CLOSE,
R_MOVE_TO, -12, -12,
R_LINE_TO, -2, -2,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 8, 3,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
CLOSE,
R_MOVE_TO, 4, 4,
R_LINE_TO, -2, -2,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 12, 1,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
CLOSE,
R_MOVE_TO, 4, 1.88,
R_H_LINE_TO, -2,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
CLOSE,
R_MOVE_TO, 0.93, 8.73,
LINE_TO, 9, 11.82,
R_V_LINE_TO, 6.3,
R_LINE_TO, -3.95, -1.98,
R_LINE_TO, 4.43, 4.4,
R_CUBIC_TO, 0.13, 0.12, 0.27, 0.22, 0.4, 0.31,
R_CUBIC_TO, 0.13, 0.09, 0.28, 0.14, 0.45, 0.14,
H_LINE_TO, 17,
R_CUBIC_TO, 0.17, 0, 0.33, -0.02, 0.49, -0.06,
R_CUBIC_TO, 0.16, -0.04, 0.31, -0.1, 0.44, -0.19,
CLOSE,
MOVE_TO, 10.32, 23,
R_CUBIC_TO, -0.4, 0, -0.78, -0.07, -1.15, -0.23,
R_ARC_TO, 2.91, 2.91, 0, 0, 1, -0.98, -0.65,
LINE_TO, 0.98, 14.9,
R_LINE_TO, 1.35, -1.07,
R_CUBIC_TO, 0.3, -0.23, 0.64, -0.37, 1.03, -0.41,
R_ARC_TO, 1.86, 1.86, 0, 0, 1, 1.1, 0.21,
LINE_TO, 7, 14.88,
R_V_LINE_TO, -5.05,
LINE_TO, 0.68, 3.5,
R_LINE_TO, 1.43, -1.43,
R_LINE_TO, 19.8, 19.8,
R_LINE_TO, -1.42, 1.43,
R_LINE_TO, -1.1, -1.1,
R_CUBIC_TO, -0.33, 0.25, -0.7, 0.45, -1.1, 0.59,
R_CUBIC_TO, -0.4, 0.14, -0.82, 0.21, -1.27, 0.21,
CLOSE,
MOVE_TO, 15, 12.02,
CLOSE,
R_MOVE_TO, 7, -7,
R_CUBIC_TO, 0, -0.85, -0.29, -1.57, -0.87, -2.15,
R_CUBIC_TO, -0.58, -0.58, -1.3, -0.87, -2.15, -0.87,
V_LINE_TO, 0.5,
R_CUBIC_TO, 1.25, 0, 2.32, 0.44, 3.2, 1.32,
R_CUBIC_TO, 0.88, 0.88, 1.32, 1.95, 1.32, 3.2,
CLOSE,
MOVE_TO, 6, 23,
R_CUBIC_TO, -1.38, 0, -2.56, -0.49, -3.54, -1.46,
CUBIC_TO, 1.49, 20.56, 1, 19.38, 1, 18,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.97, 0.34, 1.79, 1.02, 2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 6, 21.5,
CLOSE,
R_MOVE_TO, 7.6, -6.6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHandGestureOffRepList, kHandGestureOffIcon, {kHandGestureOffPath})
VECTOR_ICON_REP_TEMPLATE(kHeadsetPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 16, 15,
R_CUBIC_TO, 0, 0.55, -0.45, 1, -1, 1,
R_H_LINE_TO, -1,
R_V_LINE_TO, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 6, 16,
H_LINE_TO, 5,
R_CUBIC_TO, -0.55, 0, -1, -0.45, -1, -1,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
CLOSE,
MOVE_TO, 2, 9,
R_V_LINE_TO, 6,
R_CUBIC_TO, 0, 1.66, 1.34, 3, 3, 3,
R_H_LINE_TO, 3,
R_V_LINE_TO, -7,
H_LINE_TO, 4,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -3.87, 2.13, -5, 6, -5,
R_CUBIC_TO, 3.87, 0, 6, 1.13, 6, 5,
R_V_LINE_TO, 2,
R_H_LINE_TO, -4,
R_V_LINE_TO, 7,
R_H_LINE_TO, 3,
R_CUBIC_TO, 1.66, 0, 3, -1.34, 3, -3,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -4.97, -3.03, -7, -8, -7,
R_CUBIC_TO, -4.97, 0, -8, 2.03, -8, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHeadsetRepList, kHeadsetIcon, {kHeadsetPath})
VECTOR_ICON_REP_TEMPLATE(kHelpPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 2,
CUBIC_TO, 6.48, 2, 2, 6.48, 2, 12,
R_CUBIC_TO, 0, 5.52, 4.48, 10, 10, 10,
R_CUBIC_TO, 5.52, 0, 10, -4.48, 10, -10,
CUBIC_TO_SHORTHAND, 17.52, 2, 12, 2,
CLOSE,
R_MOVE_TO, 1, 17,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 2.07, -7.75,
R_LINE_TO, -0.9, 0.92,
CUBIC_TO, 13.45, 12.9, 13, 13.5, 13, 15,
R_H_LINE_TO, -2,
R_V_LINE_TO, -0.5,
R_CUBIC_TO, 0, -1.1, 0.45, -2.1, 1.17, -2.83,
R_LINE_TO, 1.24, -1.26,
R_CUBIC_TO, 0.37, -0.36, 0.59, -0.86, 0.59, -1.41,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
H_LINE_TO, 8,
R_CUBIC_TO, 0, -2.21, 1.79, -4, 4, -4,
R_CUBIC_TO, 2.21, 0, 4, 1.79, 4, 4,
R_CUBIC_TO, 0, 0.88, -0.36, 1.68, -0.93, 2.25,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHelpRepList, kHelpIcon, {kHelpPath})
VECTOR_ICON_REP_TEMPLATE(kHelpOutlinePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11, 18,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 1, -16,
CUBIC_TO, 6.48, 2, 2, 6.48, 2, 12,
R_CUBIC_TO, 0, 5.52, 4.48, 10, 10, 10,
R_CUBIC_TO, 5.52, 0, 10, -4.48, 10, -10,
CUBIC_TO_SHORTHAND, 17.52, 2, 12, 2,
CLOSE,
R_MOVE_TO, 0, 18,
R_CUBIC_TO, -4.41, 0, -8, -3.59, -8, -8,
R_CUBIC_TO, 0, -4.41, 3.59, -8, 8, -8,
R_CUBIC_TO, 4.41, 0, 8, 3.59, 8, 8,
R_CUBIC_TO, 0, 4.41, -3.59, 8, -8, 8,
CLOSE,
R_MOVE_TO, 0, -14,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_H_LINE_TO, 2,
R_CUBIC_TO, 0, -1.1, 0.9, -2, 2, -2,
R_CUBIC_TO, 1.1, 0, 2, 0.9, 2, 2,
R_CUBIC_TO, 0, 2, -3, 1.75, -3, 5,
R_H_LINE_TO, 2,
R_CUBIC_TO, 0, -2.25, 3, -2.5, 3, -5,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kHelpOutline20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 2,
R_CUBIC_TO, 4.42, 0, 8, 3.58, 8, 8,
R_CUBIC_TO, 0, 4.42, -3.58, 8, -8, 8,
R_CUBIC_TO, -4.42, 0, -8, -3.58, -8, -8,
R_CUBIC_TO, 0, -4.42, 3.58, -8, 8, -8,
CLOSE,
R_MOVE_TO, 0, 14,
R_CUBIC_TO, 3.31, 0, 6, -2.69, 6, -6,
R_CUBIC_TO, 0, -3.31, -2.69, -6, -6, -6,
R_CUBIC_TO, -3.31, 0, -6, 2.69, -6, 6,
R_CUBIC_TO, 0, 3.31, 2.69, 6, 6, 6,
CLOSE,
R_MOVE_TO, -0.74, -1.4,
R_V_LINE_TO, -1.39,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.39,
H_LINE_TO, 9.26,
CLOSE,
MOVE_TO, 10, 5.6,
R_CUBIC_TO, 1.66, 0, 3, 1.25, 3, 2.8,
R_CUBIC_TO, 0, 1.75, -2.24, 1.88, -2.24, 3.46,
H_LINE_TO, 9.26,
CUBIC_TO, 9.26, 9.58, 11.5, 9.8, 11.5, 8.4,
R_CUBIC_TO, 0, -0.77, -0.67, -1.4, -1.5, -1.4,
R_CUBIC_TO, -0.83, 0, -1.5, 0.63, -1.5, 1.4,
H_LINE_TO, 7,
R_CUBIC_TO, 0, -1.55, 1.34, -2.8, 3, -2.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHelpOutlineRepList, kHelpOutlineIcon, {kHelpOutlinePath}, {kHelpOutline20Path})
VECTOR_ICON_REP_TEMPLATE(kHistoryPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.81, 17.5,
R_QUADRATIC_TO, -1.44, 0, -2.76, -0.53,
R_QUADRATIC_TO, -1.32, -0.53, -2.41, -1.64,
R_LINE_TO, 1.23, -1.23,
R_QUADRATIC_TO, 0.81, 0.79, 1.87, 1.22,
R_QUADRATIC_TO, 1.05, 0.43, 2.11, 0.43,
R_QUADRATIC_TO, 2.4, 0, 4.06, -1.68,
R_QUADRATIC_TO, 1.67, -1.68, 1.67, -4.07,
R_QUADRATIC_TO, 0, -2.4, -1.67, -4.07,
QUADRATIC_TO, 13.25, 4.25, 10.85, 4.25,
R_QUADRATIC_TO, -2.37, 0, -4.04, 1.66,
R_QUADRATIC_TO, -1.67, 1.66, -1.67, 4.28,
R_LINE_TO, 1.54, -1.54,
R_LINE_TO, 1.21, 1.21,
LINE_TO, 4.25, 13.5,
LINE_TO, 0.63, 9.88,
R_LINE_TO, 1.23, -1.23,
R_LINE_TO, 1.54, 1.54,
R_QUADRATIC_TO, 0, -1.63, 0.58, -3.03,
R_QUADRATIC_TO, 0.58, -1.41, 1.6, -2.44,
R_QUADRATIC_TO, 1.02, -1.03, 2.38, -1.62,
QUADRATIC_TO, 9.31, 2.5, 10.85, 2.5,
R_QUADRATIC_TO, 1.54, 0, 2.9, 0.59,
R_QUADRATIC_TO, 1.35, 0.59, 2.38, 1.63,
R_QUADRATIC_TO, 1.02, 1.03, 1.61, 2.38,
R_QUADRATIC_TO, 0.59, 1.35, 0.59, 2.9,
R_QUADRATIC_TO, 0, 1.52, -0.6, 2.89,
R_QUADRATIC_TO, -0.6, 1.36, -1.62, 2.4,
R_QUADRATIC_TO, -1.02, 1.04, -2.39, 1.63,
R_QUADRATIC_TO, -1.36, 0.59, -2.91, 0.59,
CLOSE,
R_MOVE_TO, 2.31, -3.98,
R_LINE_TO, -3.15, -3.19,
R_V_LINE_TO, -4.5,
R_H_LINE_TO, 1.75,
R_V_LINE_TO, 3.81,
R_LINE_TO, 2.63, 2.65,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHistoryRepList, kHistoryIcon, {kHistoryPath})
VECTOR_ICON_REP_TEMPLATE(kHistoryChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 17,
R_CUBIC_TO, -1.94, 0, -3.6, -0.68, -4.96, -2.04,
CUBIC_TO, 3.68, 13.6, 3, 11.95, 3, 10,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0, 1.52, 0.54, 2.81, 1.61, 3.89,
CUBIC_TO, 7.19, 14.96, 8.48, 15.5, 10, 15.5,
R_CUBIC_TO, 1.52, 0, 2.81, -0.54, 3.89, -1.61,
CUBIC_TO, 14.96, 12.81, 15.5, 11.52, 15.5, 10,
R_CUBIC_TO, 0, -1.52, -0.54, -2.81, -1.61, -3.89,
CUBIC_TO, 12.81, 5.04, 11.52, 4.5, 10, 4.5,
R_CUBIC_TO, -0.86, 0, -1.66, 0.18, -2.39, 0.54,
ARC_TO, 5.33, 5.33, 0, 0, 0, 5.77, 6.5,
H_LINE_TO, 8,
V_LINE_TO, 8,
H_LINE_TO, 3,
V_LINE_TO, 3,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 2.71,
ARC_TO, 6.94, 6.94, 0, 0, 1, 6.89, 3.73,
CUBIC_TO, 7.84, 3.24, 8.88, 3, 10, 3,
R_CUBIC_TO, 0.97, 0, 1.88, 0.18, 2.73, 0.56,
R_CUBIC_TO, 0.85, 0.37, 1.59, 0.87, 2.22, 1.5,
R_ARC_TO, 7.05, 7.05, 0, 0, 1, 1.5, 2.22,
R_CUBIC_TO, 0.37, 0.85, 0.56, 1.76, 0.56, 2.73,
R_CUBIC_TO, 0, 0.97, -0.18, 1.88, -0.56, 2.73,
R_ARC_TO, 7.05, 7.05, 0, 0, 1, -1.5, 2.22,
R_ARC_TO, 7.05, 7.05, 0, 0, 1, -2.22, 1.5,
ARC_TO, 6.73, 6.73, 0, 0, 1, 10, 17,
CLOSE,
R_MOVE_TO, 2.08, -4.17,
LINE_TO, 9.25, 10,
V_LINE_TO, 6,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 3.38,
R_LINE_TO, 2.4, 2.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHistoryChromeRefreshRepList, kHistoryChromeRefreshIcon, {kHistoryChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kHomePath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 5, 15.83f,
LINE_TO, 7.5f, 15.83f,
LINE_TO, 7.5f, 10.83f,
LINE_TO, 12.5f, 10.83f,
LINE_TO, 12.5f, 15.83f,
LINE_TO, 15, 15.83f,
LINE_TO, 15, 8.33f,
LINE_TO, 10, 4.58f,
LINE_TO, 5, 8.33f,
CLOSE,
MOVE_TO, 3.33f, 17.5f,
LINE_TO, 3.33f, 7.5f,
LINE_TO, 10, 2.5f,
LINE_TO, 16.67f, 7.5f,
LINE_TO, 16.67f, 17.5f,
LINE_TO, 10.83f, 17.5f,
LINE_TO, 10.83f, 12.5f,
LINE_TO, 9.17f, 12.5f,
LINE_TO, 9.17f, 17.5f,
CLOSE,
MOVE_TO, 10, 10.21f,
CLOSE,
MOVE_TO, 10, 10.21f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHomeRepList, kHomeIcon, {kHomePath})
VECTOR_ICON_REP_TEMPLATE(kHttpsValidPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 6.07, 22.18,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, -1.6, -0.67,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, -0.67, -1.61,
R_V_LINE_TO, -9.85,
R_CUBIC_TO, 0, -0.62, 0.22, -1.16, 0.67, -1.61,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, 1.61, -0.67,
R_H_LINE_TO, 0.84,
V_LINE_TO, 5.95,
R_CUBIC_TO, 0, -1.42, 0.5, -2.62, 1.49, -3.62,
CUBIC_TO, 9.39, 1.34, 10.59, 0.84, 12, 0.84,
R_CUBIC_TO, 1.41, 0, 2.61, 0.5, 3.6, 1.49,
R_CUBIC_TO, 0.99, 1, 1.49, 2.2, 1.49, 3.62,
R_V_LINE_TO, 1.82,
R_H_LINE_TO, 0.84,
R_CUBIC_TO, 0.63, 0, 1.16, 0.22, 1.61, 0.67,
R_CUBIC_TO, 0.45, 0.45, 0.67, 0.99, 0.67, 1.61,
R_V_LINE_TO, 9.86,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, -0.67, 1.61,
R_ARC_TO, 2.19, 2.19, 0, 0, 1, -1.6, 0.67,
CLOSE,
R_MOVE_TO, 0, -2.27,
R_H_LINE_TO, 11.86,
R_V_LINE_TO, -9.85,
H_LINE_TO, 6.07,
CLOSE,
MOVE_TO, 12, 16.98,
R_CUBIC_TO, 0.55, 0, 1.02, -0.19, 1.41, -0.58,
R_CUBIC_TO, 0.39, -0.39, 0.59, -0.86, 0.59, -1.41,
R_CUBIC_TO, 0, -0.55, -0.19, -1.02, -0.59, -1.41,
ARC_TO, 1.94, 1.94, 0, 0, 0, 12, 12.98,
R_CUBIC_TO, -0.55, 0, -1.02, 0.2, -1.41, 0.59,
R_CUBIC_TO, -0.39, 0.39, -0.59, 0.86, -0.59, 1.41,
R_CUBIC_TO, 0, 0.55, 0.2, 1.02, 0.59, 1.42,
R_CUBIC_TO, 0.39, 0.39, 0.86, 0.59, 1.41, 0.59,
CLOSE,
MOVE_TO, 9.18, 7.78,
R_H_LINE_TO, 5.63,
V_LINE_TO, 5.95,
R_CUBIC_TO, 0, -0.79, -0.27, -1.46, -0.82, -2.01,
ARC_TO, 2.7, 2.7, 0, 0, 0, 12, 3.12,
R_CUBIC_TO, -0.78, 0, -1.45, 0.27, -2, 0.82,
R_ARC_TO, 2.74, 2.74, 0, 0, 0, -0.82, 2.01,
CLOSE,
MOVE_TO, 6.07, 19.91,
R_V_LINE_TO, -9.85,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kHttpsValid20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5.56, 18.16,
R_CUBIC_TO, -0.48, 0, -0.88, -0.17, -1.22, -0.51,
R_ARC_TO, 1.68, 1.68, 0, 0, 1, -0.5, -1.22,
V_LINE_TO, 8.54,
R_CUBIC_TO, 0, -0.47, 0.17, -0.88, 0.51, -1.22,
R_CUBIC_TO, 0.34, -0.34, 0.75, -0.51, 1.22, -0.51,
R_H_LINE_TO, 0.37,
V_LINE_TO, 4.96,
R_CUBIC_TO, 0, -1.13, 0.4, -2.1, 1.19, -2.89,
CUBIC_TO, 7.91, 1.27, 8.88, 0.87, 10, 0.87,
R_CUBIC_TO, 1.13, 0, 2.09, 0.4, 2.88, 1.2,
R_CUBIC_TO, 0.79, 0.8, 1.19, 1.76, 1.19, 2.9,
R_V_LINE_TO, 1.86,
R_H_LINE_TO, 0.37,
R_CUBIC_TO, 0.47, 0, 0.88, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.51, 0.75, 0.51, 1.22,
R_V_LINE_TO, 7.88,
R_CUBIC_TO, 0, 0.48, -0.17, 0.88, -0.51, 1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -1.22, 0.51,
CLOSE,
R_MOVE_TO, 0, -1.73,
R_H_LINE_TO, 8.88,
V_LINE_TO, 8.54,
H_LINE_TO, 5.56,
CLOSE,
R_MOVE_TO, 4.45, -2.44,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.76, -0.44, -1.06,
R_ARC_TO, 1.47, 1.47, 0, 0, 0, -1.06, -0.44,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
R_ARC_TO, 1.45, 1.45, 0, 0, 0, -0.44, 1.06,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 7.66, 6.82,
R_H_LINE_TO, 4.69,
V_LINE_TO, 4.96,
R_CUBIC_TO, 0, -0.66, -0.23, -1.22, -0.68, -1.67,
R_CUBIC_TO, -0.45, -0.46, -1.01, -0.69, -1.66, -0.69,
R_CUBIC_TO, -0.66, 0, -1.21, 0.23, -1.66, 0.69,
R_ARC_TO, 2.29, 2.29, 0, 0, 0, -0.68, 1.67,
CLOSE,
R_MOVE_TO, -2.1, 9.61,
V_LINE_TO, 8.54,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kHttpsValid16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4.51, 14.69,
R_CUBIC_TO, -0.45, 0, -0.83, -0.16, -1.15, -0.48,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, -0.48, -1.15,
V_LINE_TO, 6.89,
R_CUBIC_TO, 0, -0.45, 0.16, -0.84, 0.48, -1.16,
R_CUBIC_TO, 0.32, -0.32, 0.7, -0.48, 1.15, -0.48,
R_H_LINE_TO, 0.15,
V_LINE_TO, 3.93,
R_CUBIC_TO, 0, -0.94, 0.32, -1.73, 0.97, -2.39,
R_ARC_TO, 3.22, 3.22, 0, 0, 1, 2.37, -0.98,
R_CUBIC_TO, 0.93, 0, 1.72, 0.33, 2.37, 0.98,
R_CUBIC_TO, 0.65, 0.66, 0.97, 1.45, 0.97, 2.39,
V_LINE_TO, 5.25,
R_H_LINE_TO, 0.15,
R_CUBIC_TO, 0.45, 0, 0.83, 0.16, 1.15, 0.48,
R_CUBIC_TO, 0.32, 0.32, 0.48, 0.71, 0.48, 1.16,
R_V_LINE_TO, 6.17,
R_CUBIC_TO, 0, 0.45, -0.16, 0.83, -0.48, 1.15,
R_CUBIC_TO, -0.32, 0.32, -0.7, 0.48, -1.16, 0.48,
CLOSE,
R_MOVE_TO, 0, -1.63,
R_H_LINE_TO, 6.98,
V_LINE_TO, 6.89,
H_LINE_TO, 4.51,
CLOSE,
R_MOVE_TO, 3.49, -1.89,
R_CUBIC_TO, 0.33, 0, 0.61, -0.12, 0.85, -0.36,
R_CUBIC_TO, 0.23, -0.23, 0.35, -0.51, 0.35, -0.85,
R_CUBIC_TO, 0, -0.33, -0.12, -0.61, -0.35, -0.85,
R_ARC_TO, 1.17, 1.17, 0, 0, 0, -0.85, -0.35,
R_CUBIC_TO, -0.33, 0, -0.61, 0.12, -0.85, 0.35,
R_CUBIC_TO, -0.23, 0.23, -0.35, 0.52, -0.35, 0.85,
R_CUBIC_TO, 0, 0.33, 0.12, 0.61, 0.35, 0.84,
R_CUBIC_TO, 0.24, 0.24, 0.52, 0.35, 0.85, 0.35,
CLOSE,
MOVE_TO, 6.29, 5.25,
R_H_LINE_TO, 3.41,
V_LINE_TO, 3.93,
R_CUBIC_TO, 0, -0.48, -0.16, -0.89, -0.49, -1.23,
ARC_TO, 1.62, 1.62, 0, 0, 0, 8, 2.19,
R_CUBIC_TO, -0.48, 0, -0.89, 0.17, -1.22, 0.51,
R_ARC_TO, 1.7, 1.7, 0, 0, 0, -0.49, 1.23,
CLOSE,
R_MOVE_TO, -1.78, 7.81,
V_LINE_TO, 6.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHttpsValidRepList, kHttpsValidIcon, {kHttpsValidPath}, {kHttpsValid20Path}, {kHttpsValid16Path})
VECTOR_ICON_REP_TEMPLATE(kIdCardPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 14, 13,
R_H_LINE_TO, 5,
R_V_LINE_TO, -2,
R_H_LINE_TO, -5,
CLOSE,
R_MOVE_TO, 0, -3,
R_H_LINE_TO, 5,
V_LINE_TO, 8,
R_H_LINE_TO, -5,
CLOSE,
R_MOVE_TO, -9, 6,
R_H_LINE_TO, 8,
R_V_LINE_TO, -0.55,
R_CUBIC_TO, 0, -0.75, -0.37, -1.34, -1.1, -1.79,
CUBIC_TO, 11.17, 13.22, 10.2, 13, 9, 13,
R_CUBIC_TO, -1.2, 0, -2.17, 0.22, -2.9, 0.66,
CUBIC_TO, 5.37, 14.11, 5, 14.7, 5, 15.45,
CLOSE,
R_MOVE_TO, 4, -4,
R_CUBIC_TO, 0.55, 0, 1.02, -0.19, 1.41, -0.59,
R_CUBIC_TO, 0.39, -0.39, 0.59, -0.86, 0.59, -1.41,
R_CUBIC_TO, 0, -0.55, -0.19, -1.02, -0.59, -1.41,
ARC_TO, 1.94, 1.94, 0, 0, 0, 9, 8,
R_CUBIC_TO, -0.55, 0, -1.02, 0.2, -1.41, 0.59,
CUBIC_TO, 7.2, 8.98, 7, 9.45, 7, 10,
R_CUBIC_TO, 0, 0.55, 0.2, 1.02, 0.59, 1.41,
R_CUBIC_TO, 0.39, 0.39, 0.86, 0.59, 1.41, 0.59,
CLOSE,
R_MOVE_TO, -5, 8,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 16,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
R_CUBIC_TO, -0.39, 0.39, -0.86, 0.59, -1.41, 0.59,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 16,
V_LINE_TO, 6,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIdCardRepList, kIdCardIcon, {kIdCardPath})
VECTOR_ICON_REP_TEMPLATE(kIframePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.09, 10.91,
R_H_LINE_TO, 3.82,
V_LINE_TO, 9.59,
R_H_LINE_TO, -3.82,
CLOSE,
R_MOVE_TO, -1.18, 1.18,
V_LINE_TO, 8.41,
R_H_LINE_TO, 6.18,
R_V_LINE_TO, 3.68,
CLOSE,
MOVE_TO, 3.56, 16.17,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.23,
V_LINE_TO, 5.56,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_CUBIC_TO, 0.34, -0.34, 0.75, -0.5, 1.22, -0.5,
H_LINE_TO, 16.44,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.5,
R_CUBIC_TO, 0.34, 0.34, 0.5, 0.75, 0.5, 1.23,
R_V_LINE_TO, 8.88,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.5, 1.22,
R_CUBIC_TO, -0.34, 0.34, -0.75, 0.5, -1.22, 0.5,
CLOSE,
R_MOVE_TO, 0, -1.73,
H_LINE_TO, 16.44,
V_LINE_TO, 7.17,
H_LINE_TO, 3.56,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIframeRepList, kIframeIcon, {kIframePath})
VECTOR_ICON_REP_TEMPLATE(kIframeOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16.81, 18.94,
R_LINE_TO, -2.79, -2.77,
H_LINE_TO, 3.56,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.23,
V_LINE_TO, 5.56,
R_CUBIC_TO, 0, -0.45, 0.16, -0.84, 0.48, -1.17,
R_CUBIC_TO, 0.32, -0.33, 0.71, -0.51, 1.18, -0.54,
R_H_LINE_TO, 0.23,
V_LINE_TO, 5.84,
LINE_TO, 1.14, 3.27,
R_LINE_TO, 1.11, -1.09,
R_LINE_TO, 15.65, 15.64,
CLOSE,
MOVE_TO, 3.56, 14.44,
R_H_LINE_TO, 8.73,
LINE_TO, 5.02, 7.17,
H_LINE_TO, 3.56,
CLOSE,
R_MOVE_TO, 14.23, 1.05,
R_LINE_TO, -1.35, -1.35,
V_LINE_TO, 7.17,
H_LINE_TO, 9.47,
LINE_TO, 6.14, 3.83,
H_LINE_TO, 16.44,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.5,
R_CUBIC_TO, 0.34, 0.34, 0.5, 0.75, 0.5, 1.22,
R_V_LINE_TO, 8.88,
R_CUBIC_TO, 0, 0.2, -0.04, 0.4, -0.1, 0.59,
R_CUBIC_TO, -0.07, 0.19, -0.16, 0.34, -0.27, 0.46,
CLOSE,
R_MOVE_TO, -2.7, -2.7,
R_LINE_TO, -1.18, -1.18,
V_LINE_TO, 9.59,
R_H_LINE_TO, -2.01,
R_LINE_TO, -1.18, -1.18,
R_H_LINE_TO, 4.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIframeOffRepList, kIframeOffIcon, {kIframeOffPath})
VECTOR_ICON_REP_TEMPLATE(kImageSearchPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.6, 14.4,
CUBIC_TO, 3.27, 14.4, 2.98, 14.28, 2.75, 14.05,
CUBIC_TO, 2.52, 13.82, 2.4, 13.54, 2.4, 13.2,
LINE_TO, 2.4, 4.4,
CUBIC_TO, 2.4, 4.07, 2.52, 3.79, 2.75, 3.55,
CUBIC_TO, 2.98, 3.32, 3.27, 3.2, 3.6, 3.2,
LINE_TO, 6.8, 3.2,
LINE_TO, 6.8, 4.4,
LINE_TO, 3.6, 4.4,
LINE_TO, 3.6, 13.2,
LINE_TO, 12.4, 13.2,
LINE_TO, 12.4, 9.35,
LINE_TO, 13.6, 10.55,
LINE_TO, 13.6, 13.2,
CUBIC_TO, 13.6, 13.54, 13.48, 13.82, 13.25, 14.05,
CUBIC_TO, 13.02, 14.28, 12.73, 14.4, 12.4, 14.4,
CLOSE,
MOVE_TO, 4.4, 12,
LINE_TO, 6.2, 9.6,
LINE_TO, 7.4, 11.2,
LINE_TO, 9.2, 8.8,
LINE_TO, 11.6, 12,
CLOSE,
MOVE_TO, 14.35, 9.6,
LINE_TO, 12.3, 7.55,
CUBIC_TO, 12.08, 7.7, 11.84, 7.8, 11.59, 7.88,
CUBIC_TO, 11.34, 7.96, 11.08, 8, 10.8, 8,
CUBIC_TO, 10.02, 8, 9.36, 7.73, 8.82, 7.18,
CUBIC_TO, 8.27, 6.64, 8, 5.98, 8, 5.2,
CUBIC_TO, 8, 4.42, 8.27, 3.76, 8.82, 3.22,
CUBIC_TO, 9.36, 2.67, 10.02, 2.4, 10.8, 2.4,
CUBIC_TO, 11.58, 2.4, 12.24, 2.67, 12.78, 3.22,
CUBIC_TO, 13.33, 3.76, 13.6, 4.42, 13.6, 5.2,
CUBIC_TO, 13.6, 5.48, 13.56, 5.74, 13.48, 5.99,
CUBIC_TO, 13.41, 6.24, 13.29, 6.48, 13.15, 6.7,
LINE_TO, 15.2, 8.75,
CLOSE,
MOVE_TO, 10.8, 6.8,
CUBIC_TO, 11.25, 6.8, 11.62, 6.64, 11.93, 6.33,
CUBIC_TO, 12.25, 6.02, 12.4, 5.64, 12.4, 5.2,
CUBIC_TO, 12.4, 4.75, 12.25, 4.38, 11.93, 4.07,
CUBIC_TO, 11.62, 3.75, 11.25, 3.6, 10.8, 3.6,
CUBIC_TO, 10.36, 3.6, 9.98, 3.75, 9.67, 4.07,
CUBIC_TO, 9.36, 4.38, 9.2, 4.75, 9.2, 5.2,
CUBIC_TO, 9.2, 5.64, 9.36, 6.02, 9.67, 6.33,
CUBIC_TO, 9.98, 6.64, 10.36, 6.8, 10.8, 6.8,
CLOSE,
MOVE_TO, 10.8, 6.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kImageSearchRepList, kImageSearchIcon, {kImageSearchPath})
VECTOR_ICON_REP_TEMPLATE(kInfoOutlinePath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 16, 2,
CUBIC_TO, 8.27, 2, 2, 8.27, 2, 16,
CUBIC_TO, 2, 23.73, 8.27, 30, 16, 30,
CUBIC_TO, 23.73, 30, 30, 23.73, 30, 16,
CUBIC_TO, 30, 8.27, 23.73, 2, 16, 2,
CLOSE,
MOVE_TO, 16, 27.2,
CUBIC_TO, 9.83, 27.2, 4.8, 22.17, 4.8, 16,
CUBIC_TO, 4.8, 9.83, 9.83, 4.8, 16, 4.8,
CUBIC_TO, 22.17, 4.8, 27.2, 9.83, 27.2, 16,
CUBIC_TO, 27.2, 22.17, 22.17, 27.2, 16, 27.2,
CLOSE,
MOVE_TO, 14.6, 23,
LINE_TO, 17.4, 23,
LINE_TO, 17.4, 14.6,
LINE_TO, 14.6, 14.6,
LINE_TO, 14.6, 23,
CLOSE,
MOVE_TO, 14.6, 11.8,
LINE_TO, 17.4, 11.8,
LINE_TO, 17.4, 9,
LINE_TO, 14.6, 9,
LINE_TO, 14.6, 11.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInfoOutlineRepList, kInfoOutlineIcon, {kInfoOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kInfoRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.34, 11.26,
R_H_LINE_TO, 1.32,
V_LINE_TO, 7.2,
H_LINE_TO, 7.34,
CLOSE,
R_MOVE_TO, 0.66, -5.18,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, 0.48, -0.19,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, 0.2, -0.48,
R_ARC_TO, 0.67, 0.67, 0, 0, 0, -0.2, -0.48,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.48, -0.2,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, -0.48, 0.2,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.2, 0.48,
R_CUBIC_TO, 0, 0.2, 0.07, 0.36, 0.2, 0.49,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, 0.48, 0.2,
CLOSE,
R_MOVE_TO, 0.01, 8.46,
R_CUBIC_TO, -0.9, 0, -1.75, -0.17, -2.54, -0.51,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -2.08, -1.4,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, -2.08,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, -0.51, -2.55,
R_CUBIC_TO, 0, -0.91, 0.17, -1.75, 0.51, -2.54,
ARC_TO, 6.53, 6.53, 0, 0, 1, 3.38, 3.38,
ARC_TO, 6.52, 6.52, 0, 0, 1, 5.46, 1.98,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, 2.55, -0.51,
R_CUBIC_TO, 0.91, 0, 1.75, 0.17, 2.54, 0.51,
R_CUBIC_TO, 0.79, 0.34, 1.48, 0.8, 2.07, 1.4,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, 1.4, 2.08,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, 0.51, 2.54,
R_CUBIC_TO, 0, 0.9, -0.17, 1.75, -0.51, 2.54,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, 2.08,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, -2.08, 1.4,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, -2.54, 0.51,
CLOSE,
MOVE_TO, 8, 13.15,
R_CUBIC_TO, 1.43, 0, 2.65, -0.5, 3.65, -1.5,
R_CUBIC_TO, 1, -1, 1.5, -2.22, 1.5, -3.65,
R_CUBIC_TO, 0, -1.43, -0.5, -2.65, -1.5, -3.65,
CUBIC_TO_SHORTHAND, 9.43, 2.85, 8, 2.85,
R_CUBIC_TO, -1.43, 0, -2.65, 0.5, -3.65, 1.5,
CUBIC_TO_SHORTHAND, 2.85, 6.57, 2.85, 8,
R_CUBIC_TO, 0, 1.43, 0.5, 2.65, 1.5, 3.65,
R_CUBIC_TO, 1, 1, 2.22, 1.5, 3.65, 1.5,
CLOSE,
MOVE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInfoRefreshRepList, kInfoRefreshIcon, {kInfoRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kInsertDriveFileOutlinePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 14, 2,
H_LINE_TO, 6,
R_CUBIC_TO, -1.1, 0, -1.99, 0.9, -1.99, 2,
LINE_TO, 4, 20,
R_CUBIC_TO, 0, 1.1, 0.89, 2, 1.99, 2,
H_LINE_TO, 18,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 8,
R_LINE_TO, -6, -6,
CLOSE,
MOVE_TO, 6, 20,
V_LINE_TO, 4,
R_H_LINE_TO, 7,
R_V_LINE_TO, 5,
R_H_LINE_TO, 5,
R_V_LINE_TO, 11,
H_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInsertDriveFileOutlineRepList, kInsertDriveFileOutlineIcon, {kInsertDriveFileOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kInstallDesktopPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.66f, 17.53f,
R_V_LINE_TO, -1.67f,
H_LINE_TO, 3.32f,
R_CUBIC_TO, -0.46f, 0, -0.85f, -0.17f, -1.18f, -0.49f,
R_CUBIC_TO, -0.33f, -0.32f, -0.49f, -0.72f, -0.49f, -1.18f,
V_LINE_TO, 4.17f,
R_CUBIC_TO, 0, -0.46f, 0.17f, -0.85f, 0.49f, -1.18f,
R_CUBIC_TO, 0.32f, -0.33f, 0.72f, -0.49f, 1.18f, -0.49f,
H_LINE_TO, 10,
R_V_LINE_TO, 1.67f,
H_LINE_TO, 3.32f,
R_V_LINE_TO, 10.02f,
R_H_LINE_TO, 13.36f,
R_V_LINE_TO, -2.51f,
R_H_LINE_TO, 1.67f,
R_V_LINE_TO, 2.51f,
R_CUBIC_TO, 0, 0.46f, -0.17f, 0.85f, -0.49f, 1.18f,
R_CUBIC_TO, -0.32f, 0.33f, -0.72f, 0.49f, -1.18f, 0.49f,
R_H_LINE_TO, -3.34f,
R_V_LINE_TO, 1.67f,
H_LINE_TO, 6.66f,
CLOSE,
R_MOVE_TO, 7.51f, -5.84f,
LINE_TO, 9.99f, 7.51f,
R_LINE_TO, 1.17f, -1.17f,
R_LINE_TO, 2.17f, 2.15f,
V_LINE_TO, 2.5f,
H_LINE_TO, 15,
R_V_LINE_TO, 6,
R_LINE_TO, 2.17f, -2.15f,
R_LINE_TO, 1.17f, 1.17f,
R_LINE_TO, -4.18f, 4.18f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInstallDesktopRepList, kInstallDesktopIcon, {kInstallDesktopPath})
VECTOR_ICON_REP_TEMPLATE(kInstallDesktopOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 14.45f, 11.9f,
R_LINE_TO, 4.05f, -4.05f,
R_LINE_TO, -1.17f, -1.17f,
R_LINE_TO, -2.16f, 2.15f,
V_LINE_TO, 2.85f,
H_LINE_TO, 13.5f,
R_V_LINE_TO, 5.98f,
R_LINE_TO, -2.17f, -2.15f,
R_LINE_TO, -1.05f, 1.05f,
R_LINE_TO, 4.17f, 4.17f,
CLOSE,
MOVE_TO, 16.83f, 14.28f,
R_LINE_TO, 1.28f, 1.28f,
R_CUBIC_TO, 0.25f, -0.3f, 0.38f, -0.65f, 0.38f, -1.05f,
R_V_LINE_TO, -2.5f,
R_H_LINE_TO, -1.67f,
R_V_LINE_TO, 2.27f,
CLOSE,
MOVE_TO, 7.07f, 4.51f,
R_H_LINE_TO, 3.1f,
V_LINE_TO, 2.85f,
H_LINE_TO, 5.4f,
R_LINE_TO, 1.67f, 1.66f,
CLOSE,
MOVE_TO, 2.18f, 2.09f,
LINE_TO, 1, 3.27f,
R_LINE_TO, 0.81f, 0.81f,
R_CUBIC_TO, -0.03f, 0.13f, -0.06f, 0.27f, -0.06f, 0.43f,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.46f, 0.17f, 0.85f, 0.49f, 1.17f,
R_CUBIC_TO, 0.32f, 0.32f, 0.72f, 0.49f, 1.17f, 0.49f,
R_H_LINE_TO, 3.33f,
R_V_LINE_TO, 1.67f,
R_H_LINE_TO, 6.67f,
R_V_LINE_TO, -1.67f,
R_H_LINE_TO, 0.49f,
R_LINE_TO, 0.24f, 0.24f,
R_LINE_TO, 2.18f, 2.18f,
R_LINE_TO, 1.19f, -1.18f,
LINE_TO, 2.18f, 2.09f,
CLOSE,
R_MOVE_TO, 1.24f, 12.42f,
V_LINE_TO, 5.69f,
R_LINE_TO, 2.75f, 2.75f,
R_LINE_TO, 4.17f, 4.17f,
R_LINE_TO, 1.91f, 1.91f,
H_LINE_TO, 3.42f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInstallDesktopOffRepList, kInstallDesktopOffIcon, {kInstallDesktopOffPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 7,
R_V_LINE_TO, 10,
H_LINE_TO, 4,
V_LINE_TO, 7,
R_H_LINE_TO, 16,
R_MOVE_TO, 0, -2,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -1.99, 0.9, -1.99, 2,
LINE_TO, 2, 17,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 16,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, -9, 3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, 3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
MOVE_TO, 8, 8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 0, 3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 8,
CLOSE,
R_MOVE_TO, -3, 0,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 0, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 3, 6,
R_H_LINE_TO, 8,
R_V_LINE_TO, 2,
H_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 6, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 3, 3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardRepList, kKeyboardIcon, {kKeyboardPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardLockPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 160, 680,
R_V_LINE_TO, -400,
R_V_LINE_TO, 400,
CLOSE,
R_MOVE_TO, 40, -160,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
MOVE_TO, 200, 400,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 0, 97,
R_QUADRATIC_TO, 18, -8, 38.5, -12.5,
QUADRATIC_TO_SHORTHAND, 760, 480,
R_V_LINE_TO, -40,
R_H_LINE_TO, -80,
R_V_LINE_TO, 57,
CLOSE,
MOVE_TO, 320, 640,
R_H_LINE_TO, 244,
R_QUADRATIC_TO, 5, -23, 14, -43,
R_QUADRATIC_TO, 9, -20, 22, -37,
H_LINE_TO, 320,
R_V_LINE_TO, 80,
CLOSE,
MOVE_TO, 160, 760,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 680,
R_V_LINE_TO, -400,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 200,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 280,
R_V_LINE_TO, 240,
R_QUADRATIC_TO, -17, -13, -37, -22,
R_QUADRATIC_TO, -20, -9, -43, -14,
R_V_LINE_TO, -204,
H_LINE_TO, 160,
R_V_LINE_TO, 400,
R_H_LINE_TO, 400,
R_V_LINE_TO, 80,
H_LINE_TO, 160,
CLOSE,
MOVE_TO, 674, 880,
R_QUADRATIC_TO, -14, 0, -24, -10,
R_QUADRATIC_TO, -10, -10, -10, -24,
R_V_LINE_TO, -132,
R_QUADRATIC_TO, 0, -14, 10, -24,
R_QUADRATIC_TO, 10, -10, 24, -10,
R_H_LINE_TO, 6,
R_V_LINE_TO, -40,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 760, 560,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 840, 640,
R_V_LINE_TO, 40,
R_H_LINE_TO, 6,
R_QUADRATIC_TO, 14, 0, 24, 10,
R_QUADRATIC_TO, 10, 10, 10, 24,
R_V_LINE_TO, 132,
R_QUADRATIC_TO, 0, 14, -10, 24,
R_QUADRATIC_TO, -10, 10, -24, 10,
H_LINE_TO, 674,
CLOSE,
R_MOVE_TO, 46, -200,
R_H_LINE_TO, 80,
R_V_LINE_TO, -40,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 760, 600,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 720, 640,
R_V_LINE_TO, 40,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardLockRepList, kKeyboardLockIcon, {kKeyboardLockPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardLockOffPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 360, 480,
CLOSE,
R_MOVE_TO, 167, 160,
H_LINE_TO, 320,
R_V_LINE_TO, -80,
R_H_LINE_TO, 207,
R_V_LINE_TO, 80,
CLOSE,
MOVE_TO, 200, 520,
R_V_LINE_TO, -80,
R_H_LINE_TO, 80,
R_V_LINE_TO, 80,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 120, 0,
R_V_LINE_TO, -80,
R_H_LINE_TO, 80,
R_V_LINE_TO, 80,
R_H_LINE_TO, -80,
CLOSE,
MOVE_TO, 200, 400,
R_V_LINE_TO, -80,
R_H_LINE_TO, 80,
R_V_LINE_TO, 80,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 360, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 120, 0,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 0, 97,
R_QUADRATIC_TO, 18, -8, 38.5, -12.5,
QUADRATIC_TO_SHORTHAND, 760, 480,
R_V_LINE_TO, -40,
R_H_LINE_TO, -80,
R_V_LINE_TO, 57,
CLOSE,
R_MOVE_TO, -40, 23,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 6,
R_LINE_TO, 74, 74,
R_H_LINE_TO, 6,
CLOSE,
MOVE_TO, 520, 400,
R_V_LINE_TO, -80,
R_H_LINE_TO, -80,
R_V_LINE_TO, 6,
R_LINE_TO, 74, 74,
R_H_LINE_TO, 6,
CLOSE,
MOVE_TO, 819, 932,
LINE_TO, 28, 140,
R_LINE_TO, 56, -56,
LINE_TO, 876, 876,
R_LINE_TO, -57, 56,
CLOSE,
MOVE_TO, 516, 401,
CLOSE,
R_MOVE_TO, 364, 119,
R_QUADRATIC_TO, -17, -13, -37, -22,
R_QUADRATIC_TO, -20, -9, -43, -14,
R_V_LINE_TO, -204,
H_LINE_TO, 394,
R_LINE_TO, -80, -80,
R_H_LINE_TO, 486,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 280,
R_V_LINE_TO, 240,
CLOSE,
MOVE_TO, 160, 760,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 680,
R_V_LINE_TO, -400,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 200,
R_H_LINE_TO, 40,
R_LINE_TO, 80, 80,
H_LINE_TO, 160,
R_V_LINE_TO, 400,
R_H_LINE_TO, 400,
R_V_LINE_TO, 80,
H_LINE_TO, 160,
CLOSE,
MOVE_TO, 674, 880,
R_QUADRATIC_TO, -14, 0, -24, -10,
R_QUADRATIC_TO, -10, -10, -10, -24,
R_V_LINE_TO, -132,
R_QUADRATIC_TO, 0, -14, 10, -24,
R_QUADRATIC_TO, 10, -10, 24, -10,
R_H_LINE_TO, 6,
R_LINE_TO, 160, 160,
R_V_LINE_TO, 40,
H_LINE_TO, 674,
CLOSE,
R_MOVE_TO, 206, -114,
R_LINE_TO, -80, -80,
R_V_LINE_TO, -46,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 760, 600,
R_QUADRATIC_TO, -9, 0, -17.5, 4,
QUADRATIC_TO_SHORTHAND, 729, 615,
R_LINE_TO, -28, -29,
R_QUADRATIC_TO, 11, -12, 26.5, -19,
R_QUADRATIC_TO, 15.5, -7, 32.5, -7,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 840, 640,
R_V_LINE_TO, 40,
R_H_LINE_TO, 6,
R_QUADRATIC_TO, 14, 0, 24, 10,
R_QUADRATIC_TO, 10, 10, 10, 24,
R_V_LINE_TO, 52,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardLockOffRepList, kKeyboardLockOffIcon, {kKeyboardLockOffPath})
VECTOR_ICON_REP_TEMPLATE(kLaunchPath, CANVAS_DIMENSIONS, 18,
FLIPS_IN_RTL,
MOVE_TO, 13.5, 13.5,
R_H_LINE_TO, -9,
R_V_LINE_TO, -9,
H_LINE_TO, 8,
V_LINE_TO, 3,
H_LINE_TO, 4.33,
CUBIC_TO, 3.59, 3, 3, 3.6, 3, 4.33,
R_V_LINE_TO, 9.33,
CUBIC_TO, 3, 14.4, 3.59, 15, 4.33, 15,
R_H_LINE_TO, 9.33,
CUBIC_TO, 14.4, 15, 15, 14.4, 15, 13.67,
V_LINE_TO, 10,
R_H_LINE_TO, -1.5,
CLOSE,
MOVE_TO, 10, 3,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 2.5,
R_LINE_TO, -6, 6,
R_LINE_TO, 1, 1,
R_LINE_TO, 6, -6,
V_LINE_TO, 8,
H_LINE_TO, 15,
V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLaunchRepList, kLaunchIcon, {kLaunchPath})
VECTOR_ICON_REP_TEMPLATE(kLaunchChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
FLIPS_IN_RTL,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
H_LINE_TO, 10,
R_V_LINE_TO, 1.5,
H_LINE_TO, 4.5,
R_V_LINE_TO, 11,
R_H_LINE_TO, 11,
V_LINE_TO, 10,
H_LINE_TO, 17,
R_V_LINE_TO, 5.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 15.5, 17,
CLOSE,
R_MOVE_TO, 3.56, -4,
LINE_TO, 7, 11.94,
LINE_TO, 14.44, 4.5,
H_LINE_TO, 12,
V_LINE_TO, 3,
R_H_LINE_TO, 5,
R_V_LINE_TO, 5,
R_H_LINE_TO, -1.5,
V_LINE_TO, 5.56,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLaunchChromeRefreshRepList, kLaunchChromeRefreshIcon, {kLaunchChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLaunchOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 14.88, 17,
H_LINE_TO, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 5.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
MOVE_TO, 4.5, 15.5,
R_H_LINE_TO, 8.88,
LINE_TO, 9.48, 11.58,
LINE_TO, 8.06, 13,
LINE_TO, 7, 11.94,
R_LINE_TO, 1.42, -1.42,
LINE_TO, 4.5, 6.63,
CLOSE,
R_MOVE_TO, 2.13, -11,
LINE_TO, 5.13, 3,
H_LINE_TO, 10,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 4.96, 4.98,
LINE_TO, 10.52, 8.42,
LINE_TO, 14.44, 4.5,
H_LINE_TO, 12,
V_LINE_TO, 3,
R_H_LINE_TO, 5,
R_V_LINE_TO, 5,
R_H_LINE_TO, -1.5,
V_LINE_TO, 5.56,
CLOSE,
MOVE_TO, 17, 14.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 10,
H_LINE_TO, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLaunchOffChromeRefreshRepList, kLaunchOffChromeRefreshIcon, {kLaunchOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLightbulbOutlinePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9, 21,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
R_H_LINE_TO, 4,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
R_V_LINE_TO, -1,
H_LINE_TO, 9,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 3, -19,
CUBIC_TO, 8.14, 2, 5, 5.14, 5, 9,
R_CUBIC_TO, 0, 2.38, 1.19, 4.47, 3, 5.74,
V_LINE_TO, 17,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
R_H_LINE_TO, 6,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
R_V_LINE_TO, -2.26,
R_CUBIC_TO, 1.81, -1.27, 3, -3.36, 3, -5.74,
R_CUBIC_TO, 0, -3.86, -3.14, -7, -7, -7,
CLOSE,
R_MOVE_TO, 2.85, 11.1,
R_LINE_TO, -0.85, 0.6,
V_LINE_TO, 16,
R_H_LINE_TO, -4,
R_V_LINE_TO, -2.3,
R_LINE_TO, -0.85, -0.6,
ARC_TO, 5, 5, 0, 0, 1, 7, 9,
R_CUBIC_TO, 0, -2.76, 2.24, -5, 5, -5,
R_CUBIC_TO, 2.76, 0, 5, 2.24, 5, 5,
R_CUBIC_TO, 0, 1.63, -0.8, 3.16, -2.15, 4.1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLightbulbOutlineRepList, kLightbulbOutlineIcon, {kLightbulbOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kLightbulbOutlineChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE,
MOVE_TO, 7, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 6,
R_V_LINE_TO, 1.5,
CLOSE,
MOVE_TO, 6.69, 13,
ARC_TO, 5.34, 5.34, 0, 0, 1, 4.7, 10.86,
ARC_TO, 6.12, 6.12, 0, 0, 1, 4, 8,
R_CUBIC_TO, 0, -1.67, 0.58, -3.08, 1.75, -4.25,
CUBIC_TO, 6.92, 2.58, 8.33, 2, 10, 2,
R_CUBIC_TO, 1.67, 0, 3.08, 0.58, 4.25, 1.75,
CUBIC_TO, 15.42, 4.92, 16, 6.33, 16, 8,
R_ARC_TO, 6.12, 6.12, 0, 0, 1, -0.7, 2.86,
ARC_TO, 5.34, 5.34, 0, 0, 1, 13.31, 13,
CLOSE,
R_MOVE_TO, 0.48, -1.5,
R_H_LINE_TO, 5.66,
R_ARC_TO, 4.52, 4.52, 0, 0, 0, 1.23, -1.56,
R_CUBIC_TO, 0.29, -0.61, 0.44, -1.26, 0.44, -1.94,
R_CUBIC_TO, 0, -1.25, -0.44, -2.32, -1.31, -3.19,
R_CUBIC_TO, -0.87, -0.87, -1.93, -1.31, -3.19, -1.31,
R_CUBIC_TO, -1.25, 0, -2.32, 0.44, -3.19, 1.31,
CUBIC_TO, 5.94, 5.68, 5.5, 6.75, 5.5, 8,
R_CUBIC_TO, 0, 0.68, 0.14, 1.33, 0.44, 1.94,
R_ARC_TO, 4.52, 4.52, 0, 0, 0, 1.23, 1.56,
CLOSE,
R_MOVE_TO, 2.83, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLightbulbOutlineChromeRefreshRepList, kLightbulbOutlineChromeRefreshIcon, {kLightbulbOutlineChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLinkPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 8,
H_LINE_TO, 12,
V_LINE_TO, 6,
H_LINE_TO, 14,
CUBIC_TO, 16.21, 6, 18, 7.79, 18, 10,
CUBIC_TO, 18, 12.21, 16.21, 14, 14, 14,
H_LINE_TO, 12,
V_LINE_TO, 12,
H_LINE_TO, 14,
CUBIC_TO, 15.1, 12, 16, 11.1, 16, 10,
CUBIC_TO, 16, 8.9, 15.1, 8, 14, 8,
CLOSE,
MOVE_TO, 8, 6,
V_LINE_TO, 8,
H_LINE_TO, 6,
CUBIC_TO, 4.9, 8, 4, 8.9, 4, 10,
CUBIC_TO, 4, 11.1, 4.9, 12, 6, 12,
H_LINE_TO, 8,
V_LINE_TO, 14,
H_LINE_TO, 6,
CUBIC_TO, 3.79, 14, 2, 12.21, 2, 10,
CUBIC_TO, 2, 7.79, 3.79, 6, 6, 6,
H_LINE_TO, 8,
CLOSE,
MOVE_TO, 13, 9,
H_LINE_TO, 7,
V_LINE_TO, 11,
H_LINE_TO, 13,
V_LINE_TO, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLinkRepList, kLinkIcon, {kLinkPath})
VECTOR_ICON_REP_TEMPLATE(kLiveCaptionOnPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 2, 5.5,
ARC_TO, 1.5, 1.5, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 13,
ARC_TO, 1.5, 1.5, 0, 0, 1, 18, 5.5,
R_V_LINE_TO, 9,
R_ARC_TO, 1.5, 1.5, 0, 0, 1, -1.5, 1.5,
R_H_LINE_TO, -13,
ARC_TO, 1.5, 1.5, 0, 0, 1, 2, 14.5,
R_V_LINE_TO, -9,
CLOSE,
MOVE_TO, 4, 6,
R_H_LINE_TO, 12,
R_V_LINE_TO, 8,
H_LINE_TO, 4,
V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 1, 2,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
H_LINE_TO, 5,
V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 0, 3,
R_H_LINE_TO, 7,
R_V_LINE_TO, 2,
H_LINE_TO, 5,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 10, 0,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, -5, -3,
R_H_LINE_TO, 5,
R_V_LINE_TO, 2,
R_H_LINE_TO, -5,
V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLiveCaptionOnRepList, kLiveCaptionOnIcon, {kLiveCaptionOnPath})
VECTOR_ICON_REP_TEMPLATE(kLocationOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 14.06, 11.92,
R_LINE_TO, -1.08, -1.09,
R_ARC_TO, 7.11, 7.11, 0, 0, 0, 0.74, -1.59,
ARC_TO, 5.59, 5.59, 0, 0, 0, 14, 7.5,
R_CUBIC_TO, 0, -1.1, -0.39, -2.05, -1.17, -2.83,
CUBIC_TO, 12.05, 3.89, 11.11, 3.5, 10, 3.5,
R_CUBIC_TO, -0.58, 0, -1.13, 0.12, -1.64, 0.36,
ARC_TO, 4.34, 4.34, 0, 0, 0, 7, 4.88,
LINE_TO, 5.94, 3.81,
ARC_TO, 5.46, 5.46, 0, 0, 1, 7.78, 2.47,
ARC_TO, 5.4, 5.4, 0, 0, 1, 10, 2,
R_CUBIC_TO, 1.53, 0, 2.83, 0.54, 3.9, 1.6,
CUBIC_TO, 14.97, 4.67, 15.5, 5.97, 15.5, 7.5,
R_CUBIC_TO, 0, 0.8, -0.13, 1.56, -0.39, 2.31,
R_ARC_TO, 9.12, 9.12, 0, 0, 1, -1.05, 2.11,
CLOSE,
R_MOVE_TO, -2.68, -2.67,
R_CUBIC_TO, 0.19, -0.19, 0.34, -0.42, 0.45, -0.67,
R_CUBIC_TO, 0.11, -0.25, 0.17, -0.51, 0.17, -0.79,
R_ARC_TO, 1.93, 1.93, 0, 0, 0, -0.58, -1.42,
ARC_TO, 1.94, 1.94, 0, 0, 0, 10, 5.79,
R_ARC_TO, 2.22, 2.22, 0, 0, 0, -0.8, 0.14,
R_ARC_TO, 1.53, 1.53, 0, 0, 0, -0.66, 0.48,
CLOSE,
MOVE_TO, 16, 18.13,
R_LINE_TO, -3.69, -3.71,
R_CUBIC_TO, -0.23, 0.38, -0.47, 0.76, -0.7, 1.16,
R_CUBIC_TO, -0.23, 0.4, -0.44, 0.81, -0.63, 1.24,
R_ARC_TO, 9.4, 9.4, 0, 0, 1, -0.37, 0.8,
ARC_TO, 0.65, 0.65, 0, 0, 1, 10, 18,
R_ARC_TO, 0.65, 0.65, 0, 0, 1, -0.61, -0.39,
R_ARC_TO, 9.4, 9.4, 0, 0, 1, -0.37, -0.8,
R_ARC_TO, 11.49, 11.49, 0, 0, 0, -1.13, -2.08,
R_ARC_TO, 44.89, 44.89, 0, 0, 0, -1.39, -1.89,
R_ARC_TO, 15.05, 15.05, 0, 0, 1, -1.41, -2.54,
R_ARC_TO, 6.97, 6.97, 0, 0, 1, -0.57, -3.22,
R_CUBIC_TO, 0, -0.13, 0.02, -0.27, 0.05, -0.4,
LINE_TO, 1.88, 3.98,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.15,
CLOSE,
R_MOVE_TO, -6, -2.73,
R_CUBIC_TO, 0.17, -0.36, 0.36, -0.71, 0.58, -1.04,
R_LINE_TO, 0.67, -1,
R_LINE_TO, -5.21, -5.21,
R_CUBIC_TO, 0.08, 0.78, 0.32, 1.5, 0.71, 2.17,
R_CUBIC_TO, 0.39, 0.67, 0.81, 1.32, 1.25, 1.96,
R_CUBIC_TO, 0.38, 0.5, 0.73, 1, 1.07, 1.51,
R_CUBIC_TO, 0.34, 0.51, 0.65, 1.05, 0.93, 1.61,
CLOSE,
MOVE_TO, 8.67, 11,
CLOSE,
R_MOVE_TO, 1.38, -3.08,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLocationOffChromeRefreshRepList, kLocationOffChromeRefreshIcon, {kLocationOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLocationOnPath, MOVE_TO, 24, 4,
R_CUBIC_TO, -7.73, 0, -14, 6.27, -14, 14,
R_CUBIC_TO, 0, 10.5, 14, 26, 14, 26,
R_CUBIC_TO, 0, 0, 14, -15.5, 14, -26,
R_CUBIC_TO, 0, -7.73, -6.27, -14, -14, -14,
CLOSE,
CIRCLE, 24, 18, 5)
VECTOR_ICON_REP_TEMPLATE(kLocationOn16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 1,
CUBIC_TO, 5.24, 1, 3, 3.19, 3, 5.9,
CUBIC_TO, 3, 9.57, 8, 15, 8, 15,
CUBIC_TO, 8, 15, 13, 9.57, 13, 5.9,
CUBIC_TO, 13, 3.19, 10.76, 1, 8, 1,
CLOSE,
MOVE_TO, 8, 8,
CUBIC_TO, 6.9, 8, 6, 7.1, 6, 6,
CUBIC_TO, 6, 4.9, 6.9, 4, 8, 4,
CUBIC_TO, 9.1, 4, 10, 4.9, 10, 6,
CUBIC_TO, 10, 7.1, 9.1, 8, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLocationOnRepList, kLocationOnIcon, {kLocationOnPath}, {kLocationOn16Path})
VECTOR_ICON_REP_TEMPLATE(kLocationOnChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 18,
R_ARC_TO, 0.78, 0.78, 0, 0, 1, -0.49, -0.16,
R_ARC_TO, 0.82, 0.82, 0, 0, 1, -0.29, -0.41,
R_ARC_TO, 14.33, 14.33, 0, 0, 0, -0.95, -2.09,
R_CUBIC_TO, -0.37, -0.66, -0.9, -1.43, -1.59, -2.32,
R_CUBIC_TO, -0.68, -0.87, -1.23, -1.71, -1.66, -2.52,
R_CUBIC_TO, -0.42, -0.8, -0.64, -1.77, -0.64, -2.9,
R_CUBIC_TO, 0, -1.55, 0.55, -2.87, 1.63, -3.96,
CUBIC_TO, 7.11, 2.55, 8.44, 2, 10, 2,
R_CUBIC_TO, 1.56, 0, 2.89, 0.54, 3.97, 1.63,
R_CUBIC_TO, 1.09, 1.09, 1.63, 2.42, 1.63, 3.98,
R_CUBIC_TO, 0, 1.22, -0.23, 2.22, -0.7, 3.02,
R_ARC_TO, 23.89, 23.89, 0, 0, 1, -1.59, 2.38,
R_CUBIC_TO, -0.72, 0.95, -1.26, 1.74, -1.64, 2.39,
R_ARC_TO, 11.54, 11.54, 0, 0, 0, -0.91, 2.03,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.3, 0.41,
R_ARC_TO, 0.72, 0.72, 0, 0, 1, -0.46, 0.16,
CLOSE,
MOVE_TO, 10, 15.36,
R_CUBIC_TO, 0.23, -0.47, 0.5, -0.94, 0.8, -1.4,
R_CUBIC_TO, 0.3, -0.46, 0.74, -1.08, 1.33, -1.85,
R_CUBIC_TO, 0.58, -0.75, 1.06, -1.45, 1.43, -2.09,
R_CUBIC_TO, 0.37, -0.64, 0.55, -1.45, 0.55, -2.41,
R_CUBIC_TO, 0, -1.12, -0.4, -2.09, -1.21, -2.9,
CUBIC_TO, 12.09, 3.9, 11.12, 3.5, 9.99, 3.5,
R_ARC_TO, 3.93, 3.93, 0, 0, 0, -2.89, 1.21,
R_CUBIC_TO, -0.8, 0.81, -1.2, 1.77, -1.2, 2.9,
R_CUBIC_TO, 0, 0.96, 0.19, 1.77, 0.56, 2.41,
R_CUBIC_TO, 0.38, 0.64, 0.85, 1.34, 1.42, 2.09,
R_CUBIC_TO, 0.58, 0.77, 1.02, 1.39, 1.32, 1.85,
R_CUBIC_TO, 0.3, 0.46, 0.57, 0.93, 0.8, 1.4,
CLOSE,
R_MOVE_TO, 0, -5.75,
R_CUBIC_TO, 0.56, 0, 1.03, -0.19, 1.42, -0.58,
ARC_TO, 1.93, 1.93, 0, 0, 0, 12, 7.61,
R_CUBIC_TO, 0, -0.56, -0.19, -1.03, -0.58, -1.42,
R_ARC_TO, 1.92, 1.92, 0, 0, 0, -1.42, -0.58,
R_CUBIC_TO, -0.56, 0, -1.03, 0.19, -1.42, 0.58,
ARC_TO, 1.92, 1.92, 0, 0, 0, 8, 7.6,
R_CUBIC_TO, 0, 0.56, 0.19, 1.03, 0.58, 1.42,
R_CUBIC_TO, 0.39, 0.39, 0.86, 0.59, 1.42, 0.59,
CLOSE,
MOVE_TO, 10, 7.58,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kLocationOnChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 14.52,
R_ARC_TO, 0.74, 0.74, 0, 0, 1, -0.46, -0.15,
R_ARC_TO, 0.86, 0.86, 0, 0, 1, -0.29, -0.39,
R_CUBIC_TO, -0.25, -0.64, -0.52, -1.21, -0.8, -1.72,
R_CUBIC_TO, -0.28, -0.51, -0.69, -1.09, -1.2, -1.76,
R_CUBIC_TO, -0.55, -0.71, -1, -1.39, -1.35, -2.05,
R_CUBIC_TO, -0.34, -0.66, -0.51, -1.44, -0.51, -2.37,
R_CUBIC_TO, 0, -1.28, 0.45, -2.37, 1.34, -3.27,
CUBIC_TO, 5.62, 1.91, 6.72, 1.47, 8, 1.47,
R_CUBIC_TO, 1.29, 0, 2.38, 0.45, 3.27, 1.35,
R_CUBIC_TO, 0.9, 0.9, 1.34, 1.99, 1.34, 3.28,
R_CUBIC_TO, 0, 1, -0.19, 1.82, -0.57, 2.47,
R_ARC_TO, 19.3, 19.3, 0, 0, 1, -1.3, 1.94,
R_CUBIC_TO, -0.53, 0.69, -0.94, 1.29, -1.23, 1.79,
R_ARC_TO, 11.26, 11.26, 0, 0, 0, -0.78, 1.69,
R_ARC_TO, 1.02, 1.02, 0, 0, 1, -0.3, 0.4,
R_ARC_TO, 0.7, 0.7, 0, 0, 1, -0.44, 0.15,
CLOSE,
MOVE_TO, 8, 12.21,
R_CUBIC_TO, 0.19, -0.38, 0.4, -0.75, 0.63, -1.12,
R_CUBIC_TO, 0.24, -0.37, 0.58, -0.85, 1.03, -1.44,
R_CUBIC_TO, 0.47, -0.59, 0.84, -1.15, 1.14, -1.66,
R_CUBIC_TO, 0.29, -0.51, 0.44, -1.14, 0.44, -1.91,
R_CUBIC_TO, 0, -0.89, -0.32, -1.64, -0.95, -2.28,
R_ARC_TO, 3.11, 3.11, 0, 0, 0, -2.29, -0.95,
R_CUBIC_TO, -0.89, 0, -1.65, 0.32, -2.28, 0.95,
R_ARC_TO, 3.13, 3.13, 0, 0, 0, -0.94, 2.28,
R_CUBIC_TO, 0, 0.77, 0.15, 1.4, 0.45, 1.91,
R_CUBIC_TO, 0.3, 0.51, 0.68, 1.07, 1.13, 1.66,
R_CUBIC_TO, 0.45, 0.59, 0.79, 1.07, 1.03, 1.44,
R_CUBIC_TO, 0.24, 0.37, 0.45, 0.74, 0.63, 1.12,
CLOSE,
R_MOVE_TO, 0, -4.51,
R_CUBIC_TO, 0.45, 0, 0.83, -0.16, 1.15, -0.46,
R_CUBIC_TO, 0.31, -0.31, 0.47, -0.69, 0.47, -1.14,
R_CUBIC_TO, 0, -0.45, -0.16, -0.83, -0.47, -1.14,
R_ARC_TO, 1.54, 1.54, 0, 0, 0, -1.14, -0.47,
R_CUBIC_TO, -0.45, 0, -0.83, 0.15, -1.14, 0.47,
R_ARC_TO, 1.55, 1.55, 0, 0, 0, -0.47, 1.14,
R_CUBIC_TO, 0, 0.45, 0.16, 0.83, 0.47, 1.15,
R_CUBIC_TO, 0.31, 0.31, 0.69, 0.47, 1.14, 0.47,
CLOSE,
MOVE_TO, 8, 6.07,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLocationOnChromeRefreshRepList, kLocationOnChromeRefreshIcon, {kLocationOnChromeRefreshPath}, {kLocationOnChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kLockPath, MOVE_TO, 36, 16,
R_H_LINE_TO, -2,
R_V_LINE_TO, -4,
R_CUBIC_TO, 0, -5.52, -4.48, -10, -10, -10,
CUBIC_TO, 18.48, 2, 14, 6.48, 14, 12,
R_V_LINE_TO, 4,
R_H_LINE_TO, -2,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_V_LINE_TO, 20,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 24,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 20,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
MOVE_TO, 24, 34,
R_CUBIC_TO, -2.21, 0, -4, -1.79, -4, -4,
R_CUBIC_TO, 0, -2.21, 1.79, -4, 4, -4,
R_CUBIC_TO, 2.21, 0, 4, 1.79, 4, 4,
R_CUBIC_TO, 0, 2.21, -1.79, 4, -4, 4,
CLOSE,
R_MOVE_TO, 6.2, -18,
H_LINE_TO, 17.8,
R_V_LINE_TO, -4,
R_CUBIC_TO, 0, -3.42, 2.78, -6.2, 6.2, -6.2,
R_CUBIC_TO, 3.42, 0, 6.2, 2.78, 6.2, 6.2,
R_V_LINE_TO, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLockRepList, kLockIcon, {kLockPath})
VECTOR_ICON_REP_TEMPLATE(kLoyaltyPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
R_MOVE_TO, 13, 17.5,
R_LINE_TO, 3.5, -3.5,
R_CUBIC_TO, 0.18, -0.18, 0.33, -0.4, 0.44, -0.65,
R_CUBIC_TO, 0.11, -0.25, 0.16, -0.52, 0.16, -0.8,
R_ARC_TO, 1.98, 1.98, 0, 0, 0, -0.6, -1.45,
R_ARC_TO, 1.96, 1.96, 0, 0, 0, -1.45, -0.6,
R_CUBIC_TO, -0.32, 0, -0.63, 0.09, -0.94, 0.27,
R_CUBIC_TO, -0.31, 0.18, -0.68, 0.49, -1.11, 0.93,
R_CUBIC_TO, -0.5, -0.46, -0.89, -0.78, -1.18, -0.95,
R_ARC_TO, 1.69, 1.69, 0, 0, 0, -0.87, -0.25,
R_CUBIC_TO, -0.57, 0, -1.05, 0.2, -1.45, 0.6,
R_ARC_TO, 1.98, 1.98, 0, 0, 0, -0.6, 1.45,
R_CUBIC_TO, 0, 0.28, 0.06, 0.55, 0.17, 0.8,
R_CUBIC_TO, 0.11, 0.25, 0.25, 0.47, 0.44, 0.65,
CLOSE,
R_MOVE_TO, 8.4, -3.25,
R_LINE_TO, -7.15, 7.15,
R_ARC_TO, 1.98, 1.98, 0, 0, 1, -0.68, 0.45,
R_CUBIC_TO, -0.25, 0.1, -0.5, 0.15, -0.75, 0.15,
R_CUBIC_TO, -0.25, 0, -0.5, -0.05, -0.75, -0.15,
R_ARC_TO, 2.02, 2.02, 0, 0, 1, -0.68, -0.45,
R_LINE_TO, -8.82, -8.82,
ARC_TO, 1.96, 1.96, 0, 0, 1, 2, 11.18,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 2.2, 3.45, 2, 4, 2,
R_H_LINE_TO, 7.18,
R_CUBIC_TO, 0.27, 0, 0.52, 0.06, 0.77, 0.16,
R_CUBIC_TO, 0.25, 0.11, 0.47, 0.25, 0.65, 0.44,
R_LINE_TO, 8.8, 8.82,
R_CUBIC_TO, 0.2, 0.2, 0.35, 0.43, 0.44, 0.68,
R_CUBIC_TO, 0.09, 0.25, 0.14, 0.5, 0.14, 0.75,
R_CUBIC_TO, 0, 0.25, -0.05, 0.5, -0.14, 0.73,
R_CUBIC_TO, -0.09, 0.24, -0.23, 0.47, -0.44, 0.66,
CLOSE,
MOVE_TO, 12.82, 20,
R_LINE_TO, 7.15, -7.15,
LINE_TO, 11.15, 4,
H_LINE_TO, 4,
R_V_LINE_TO, 7.15,
CLOSE,
MOVE_TO, 6.5, 8,
R_CUBIC_TO, 0.42, 0, 0.77, -0.14, 1.06, -0.44,
CUBIC_TO, 7.85, 7.27, 8, 6.92, 8, 6.5,
R_CUBIC_TO, 0, -0.42, -0.14, -0.77, -0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 0, 6.5, 5,
R_CUBIC_TO, -0.42, 0, -0.77, 0.14, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 5, 6.5,
R_CUBIC_TO, 0, 0.42, 0.14, 0.77, 0.44, 1.06,
CUBIC_TO, 5.73, 7.85, 6.08, 8, 6.5, 8,
CLOSE,
R_MOVE_TO, 5.5, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLoyaltyRepList, kLoyaltyIcon, {kLoyaltyPath})
VECTOR_ICON_REP_TEMPLATE(kMagicButtonPath, MOVE_TO, 32, 44.35,
LINE_TO, 26.41, 38.76,
LINE_TO, 32, 33.18,
LINE_TO, 37.59, 38.76,
CLOSE,
MOVE_TO, 15.29, 37.6,
LINE_TO, 3.7, 26,
LINE_TO, 15.29, 14.4,
LINE_TO, 26.88, 26,
CLOSE,
MOVE_TO, 35, 23.48,
CUBIC_TO, 35, 20.56, 33.98, 18.09, 31.95, 16.05,
CUBIC_TO, 29.91, 14.02, 27.44, 13, 24.52, 13,
CUBIC_TO, 27.44, 13, 29.91, 11.98, 31.95, 9.95,
CUBIC_TO, 33.98, 7.91, 35, 5.43, 35, 2.51,
CUBIC_TO, 35, 5.43, 36.02, 7.91, 38.05, 9.95,
CUBIC_TO, 40.09, 11.98, 42.57, 13, 45.49, 13,
CUBIC_TO, 42.57, 13, 40.09, 14.02, 38.05, 16.05,
CUBIC_TO, 36.02, 18.09, 35, 20.56, 35, 23.48,
CLOSE,
MOVE_TO, 35, 23.48,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMagicButtonRepList, kMagicButtonIcon, {kMagicButtonPath})
VECTOR_ICON_REP_TEMPLATE(kMediaNextTrackPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 6, 18,
R_LINE_TO, 8.5, -6,
LINE_TO, 6, 6,
R_V_LINE_TO, 12,
CLOSE,
MOVE_TO, 16, 6,
R_V_LINE_TO, 12,
R_H_LINE_TO, 2,
V_LINE_TO, 6,
R_H_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaNextTrackRepList, kMediaNextTrackIcon, {kMediaNextTrackPath})
VECTOR_ICON_REP_TEMPLATE(kMediaPreviousTrackPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 6, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 12,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 3.5, 6,
R_LINE_TO, 8.5, 6,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaPreviousTrackRepList, kMediaPreviousTrackIcon, {kMediaPreviousTrackPath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterActiveChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 15, 13,
R_H_LINE_TO, -3.98,
R_ARC_TO, 6.57, 6.57, 0, 0, 0, -0.3, -0.78,
R_CUBIC_TO, -0.12, -0.26, -0.23, -0.5, -0.34, -0.72,
H_LINE_TO, 13.5,
R_V_LINE_TO, -3,
H_LINE_TO, 7.83,
R_ARC_TO, 9.7, 9.7, 0, 0, 0, -1.31, -0.85,
ARC_TO, 9.63, 9.63, 0, 0, 0, 5.06, 7,
H_LINE_TO, 15,
CLOSE,
R_MOVE_TO, -5, -3,
CLOSE,
R_MOVE_TO, -8, 6,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0.56, 0, 1.03, 0.2, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
CLOSE,
R_MOVE_TO, 3.5, 0,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 2, 12.5,
V_LINE_TO, 11,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 6.52, 13.43, 7, 14.61, 7, 16,
CLOSE,
R_MOVE_TO, 3, 0,
R_ARC_TO, 6.3, 6.3, 0, 0, 0, -0.51, -2.53,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -1.39, -2.07,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -2.07, -1.39,
ARC_TO, 6.3, 6.3, 0, 0, 0, 2, 9.5,
V_LINE_TO, 8,
R_CUBIC_TO, 1.11, 0, 2.15, 0.21, 3.12, 0.63,
ARC_TO, 8.09, 8.09, 0, 0, 1, 7.66, 10.34,
R_ARC_TO, 8.09, 8.09, 0, 0, 1, 1.72, 2.54,
CUBIC_TO, 9.79, 13.85, 10, 14.89, 10, 16,
CLOSE,
R_MOVE_TO, 8, 0,
R_H_LINE_TO, -5,
R_CUBIC_TO, 0, -0.25, -0.01, -0.5, -0.03, -0.75,
R_CUBIC_TO, -0.02, -0.25, -0.05, -0.5, -0.09, -0.75,
H_LINE_TO, 16.5,
R_V_LINE_TO, -9,
R_H_LINE_TO, -13,
R_V_LINE_TO, 1.13,
R_CUBIC_TO, -0.25, -0.04, -0.5, -0.07, -0.75, -0.09,
R_CUBIC_TO, -0.25, -0.02, -0.5, -0.03, -0.75, -0.03,
R_V_LINE_TO, -1,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9.01,
R_CUBIC_TO, 0, 0.41, -0.15, 0.76, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterActiveChromeRefreshRepList, kMediaRouterActiveChromeRefreshIcon, {kMediaRouterActiveChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterErrorPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 14.55, 1.5,
H_LINE_TO, 1.45,
CUBIC_TO, 0.65, 1.5, 0, 2.15, 0, 2.94,
R_V_LINE_TO, 2.18,
R_LINE_TO, 1.5, 0,
V_LINE_TO, 3,
R_H_LINE_TO, 13,
R_V_LINE_TO, 10,
R_H_LINE_TO, -5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 5.05,
R_CUBIC_TO, 0.8, 0, 1.45, -0.65, 1.45, -1.44,
V_LINE_TO, 2.94,
CUBIC_TO, 16, 2.15, 15.35, 1.5, 14.55, 1.5,
CLOSE,
MOVE_TO, 0, 12.37,
R_V_LINE_TO, 2.13,
R_H_LINE_TO, 2.12,
CUBIC_TO, 2.12, 13.3, 1.21, 12.37, 0, 12.37,
CLOSE,
MOVE_TO, 0, 9.37,
R_LINE_TO, 0, 1.5,
R_CUBIC_TO, 2.01, 0, 3.62, 1.63, 3.62, 3.63,
R_H_LINE_TO, 1.5,
CUBIC_TO, 5.12, 11.71, 2.81, 9.37, 0, 9.37,
CLOSE,
MOVE_TO, 0, 6.56,
V_LINE_TO, 8,
R_CUBIC_TO, 3.61, 0, 6.5, 2.91, 6.5, 6.5,
H_LINE_TO, 8,
CUBIC_TO, 8, 10.11, 4.41, 6.56, 0, 6.56,
CLOSE,
MOVE_TO, 12.94, 6,
R_LINE_TO, -1.69, 1.69,
LINE_TO, 9.56, 6,
LINE_TO, 8.5, 7.06,
R_LINE_TO, 1.69, 1.69,
R_LINE_TO, -1.69, 1.69,
R_LINE_TO, 1.06, 1.06,
R_LINE_TO, 1.69, -1.69,
R_LINE_TO, 1.69, 1.69,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, -1.69, -1.69,
R_LINE_TO, 1.69, -1.69,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterErrorRepList, kMediaRouterErrorIcon, {kMediaRouterErrorPath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterIdlePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 14.55, 1.5,
H_LINE_TO, 1.45,
CUBIC_TO, 0.65, 1.5, 0, 2.15, 0, 2.94,
R_V_LINE_TO, 2.18,
R_H_LINE_TO, 1.5,
V_LINE_TO, 3,
R_H_LINE_TO, 13,
R_V_LINE_TO, 10,
R_H_LINE_TO, -5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 5.05,
R_CUBIC_TO, 0.8, 0, 1.45, -0.65, 1.45, -1.44,
V_LINE_TO, 2.94,
R_CUBIC_TO, 0, -0.79, -0.65, -1.44, -1.45, -1.44,
CLOSE,
MOVE_TO, 0, 12.37,
R_V_LINE_TO, 2.13,
R_H_LINE_TO, 2.12,
R_CUBIC_TO, 0, -1.2, -0.91, -2.13, -2.12, -2.13,
CLOSE,
R_MOVE_TO, 0, -3,
R_V_LINE_TO, 1.5,
R_CUBIC_TO, 2.01, 0, 3.62, 1.63, 3.62, 3.63,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0, -2.79, -2.31, -5.13, -5.12, -5.13,
CLOSE,
R_MOVE_TO, 0, -2.81,
V_LINE_TO, 8,
R_CUBIC_TO, 3.61, 0, 6.5, 2.91, 6.5, 6.5,
H_LINE_TO, 8,
R_CUBIC_TO, 0, -4.39, -3.59, -7.94, -8, -7.94,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterIdleRepList, kMediaRouterIdleIcon, {kMediaRouterIdlePath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterIdleChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 6.5, 6,
R_H_LINE_TO, -5,
R_CUBIC_TO, 0, -0.25, -0.01, -0.5, -0.03, -0.75,
R_CUBIC_TO, -0.02, -0.25, -0.05, -0.5, -0.09, -0.75,
H_LINE_TO, 16.5,
R_V_LINE_TO, -9,
R_H_LINE_TO, -13,
R_V_LINE_TO, 1.13,
R_CUBIC_TO, -0.25, -0.04, -0.5, -0.07, -0.75, -0.09,
R_CUBIC_TO, -0.25, -0.02, -0.5, -0.03, -0.75, -0.03,
R_V_LINE_TO, -1,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9.01,
R_CUBIC_TO, 0, 0.41, -0.15, 0.76, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 16,
CLOSE,
MOVE_TO, 2, 16,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0.56, 0, 1.03, 0.2, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
CLOSE,
R_MOVE_TO, 3.5, 0,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 2, 12.5,
V_LINE_TO, 11,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 6.52, 13.43, 7, 14.61, 7, 16,
CLOSE,
R_MOVE_TO, 3, 0,
R_ARC_TO, 6.3, 6.3, 0, 0, 0, -0.51, -2.53,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -1.39, -2.07,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -2.07, -1.39,
ARC_TO, 6.3, 6.3, 0, 0, 0, 2, 9.5,
V_LINE_TO, 8,
R_CUBIC_TO, 1.11, 0, 2.15, 0.21, 3.12, 0.63,
ARC_TO, 8.09, 8.09, 0, 0, 1, 7.66, 10.34,
R_ARC_TO, 8.09, 8.09, 0, 0, 1, 1.72, 2.54,
CUBIC_TO, 9.79, 13.85, 10, 14.89, 10, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterIdleChromeRefreshRepList, kMediaRouterIdleChromeRefreshIcon, {kMediaRouterIdleChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterPausedPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 15.13, 7.19,
R_H_LINE_TO, 1.08,
V_LINE_TO, 3.61,
R_H_LINE_TO, -1.08,
CLOSE,
R_MOVE_TO, -2, 0,
R_H_LINE_TO, 1.08,
V_LINE_TO, 3.61,
R_H_LINE_TO, -1.08,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, -8.17, 4.09,
R_CUBIC_TO, 0.58, 0, 1.07, 0.2, 1.47, 0.61,
R_CUBIC_TO, 0.4, 0.41, 0.61, 0.9, 0.61, 1.47,
H_LINE_TO, 1.83,
CLOSE,
R_MOVE_TO, 0, -3.07,
R_CUBIC_TO, 1.43, 0, 2.65, 0.5, 3.65, 1.5,
R_CUBIC_TO, 1, 1, 1.5, 2.22, 1.5, 3.65,
H_LINE_TO, 5.41,
R_CUBIC_TO, 0, -0.99, -0.35, -1.84, -1.05, -2.53,
R_ARC_TO, 3.46, 3.46, 0, 0, 0, -2.53, -1.04,
CLOSE,
R_MOVE_TO, 0, -3.07,
R_CUBIC_TO, 1.15, 0, 2.21, 0.22, 3.21, 0.64,
R_ARC_TO, 8.32, 8.32, 0, 0, 1, 2.61, 1.77,
R_ARC_TO, 8.23, 8.23, 0, 0, 1, 1.77, 2.61,
R_CUBIC_TO, 0.43, 1, 0.64, 2.07, 0.64, 3.21,
H_LINE_TO, 8.49,
R_CUBIC_TO, 0, -0.92, -0.17, -1.78, -0.52, -2.59,
R_ARC_TO, 6.8, 6.8, 0, 0, 0, -1.43, -2.12,
R_ARC_TO, 6.8, 6.8, 0, 0, 0, -2.12, -1.43,
R_ARC_TO, 6.45, 6.45, 0, 0, 0, -2.59, -0.52,
CLOSE,
R_MOVE_TO, 14.61, 8.23,
R_H_LINE_TO, -4.88,
R_ARC_TO, 9.06, 9.06, 0, 0, 0, -0.16, -1.73,
R_H_LINE_TO, 5.05,
R_V_LINE_TO, -3.87,
R_CUBIC_TO, 0.32, -0.1, 0.62, -0.22, 0.91, -0.37,
R_CUBIC_TO, 0.29, -0.15, 0.56, -0.34, 0.82, -0.56,
R_V_LINE_TO, 4.79,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.5, 1.23,
R_CUBIC_TO, -0.34, 0.34, -0.75, 0.5, -1.22, 0.5,
CLOSE,
MOVE_TO, 1.83, 6.44,
V_LINE_TO, 5.56,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, 1.22, -0.5,
R_H_LINE_TO, 5.84,
R_ARC_TO, 4.7, 4.7, 0, 0, 0, -0.18, 0.84,
R_CUBIC_TO, -0.04, 0.29, -0.05, 0.59, -0.04, 0.88,
H_LINE_TO, 3.56,
R_V_LINE_TO, 1.05,
R_ARC_TO, 9.19, 9.19, 0, 0, 0, -0.86, -0.12,
R_ARC_TO, 9.18, 9.18, 0, 0, 0, -0.86, -0.04,
CLOSE,
R_MOVE_TO, 12.83, 2.96,
R_CUBIC_TO, -1.1, 0, -2.05, -0.39, -2.83, -1.17,
R_CUBIC_TO, -0.78, -0.78, -1.17, -1.73, -1.17, -2.83,
R_CUBIC_TO, 0, -1.11, 0.39, -2.05, 1.17, -2.83,
R_CUBIC_TO, 0.78, -0.78, 1.73, -1.17, 2.84, -1.17,
R_CUBIC_TO, 1.11, 0, 2.05, 0.39, 2.83, 1.17,
R_CUBIC_TO, 0.78, 0.78, 1.16, 1.73, 1.16, 2.84,
R_CUBIC_TO, 0, 1.11, -0.39, 2.05, -1.17, 2.83,
R_CUBIC_TO, -0.78, 0.78, -1.72, 1.16, -2.83, 1.16,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterPausedRepList, kMediaRouterPausedIcon, {kMediaRouterPausedPath})
VECTOR_ICON_REP_TEMPLATE(kMediaRouterWarningChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, -8, 4,
R_CUBIC_TO, 0.56, 0, 1.03, 0.2, 1.42, 0.58,
R_CUBIC_TO, 0.39, 0.39, 0.58, 0.86, 0.58, 1.42,
H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -3,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 6.52, 13.43, 7, 14.61, 7, 16,
H_LINE_TO, 5.5,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 2, 12.5,
CLOSE,
R_MOVE_TO, 0, -3,
R_CUBIC_TO, 1.11, 0, 2.15, 0.21, 3.12, 0.63,
ARC_TO, 8.09, 8.09, 0, 0, 1, 7.66, 10.34,
R_ARC_TO, 8.09, 8.09, 0, 0, 1, 1.72, 2.54,
CUBIC_TO, 9.79, 13.85, 10, 14.89, 10, 16,
H_LINE_TO, 8.5,
R_ARC_TO, 6.3, 6.3, 0, 0, 0, -0.51, -2.53,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -1.39, -2.07,
R_ARC_TO, 6.56, 6.56, 0, 0, 0, -2.07, -1.39,
ARC_TO, 6.3, 6.3, 0, 0, 0, 2, 9.5,
CLOSE,
R_MOVE_TO, 14.5, 8,
R_H_LINE_TO, -5,
R_CUBIC_TO, 0, -0.25, -0.01, -0.5, -0.03, -0.75,
R_CUBIC_TO, -0.02, -0.25, -0.05, -0.5, -0.09, -0.75,
H_LINE_TO, 16.5,
R_V_LINE_TO, -3.87,
R_CUBIC_TO, 0.28, -0.1, 0.54, -0.23, 0.79, -0.37,
ARC_TO, 4.05, 4.05, 0, 0, 0, 18, 9.75,
R_V_LINE_TO, 4.75,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 16,
CLOSE,
MOVE_TO, 2, 6.5,
R_V_LINE_TO, -1,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
R_H_LINE_TO, 5.71,
R_ARC_TO, 5.64, 5.64, 0, 0, 0, -0.16, 0.73,
CUBIC_TO, 9.02, 4.98, 9, 5.24, 9, 5.5,
H_LINE_TO, 3.5,
R_V_LINE_TO, 1.13,
R_CUBIC_TO, -0.25, -0.04, -0.5, -0.07, -0.75, -0.09,
R_CUBIC_TO, -0.25, -0.02, -0.5, -0.03, -0.75, -0.03,
CLOSE,
R_MOVE_TO, 12.5, 3,
R_CUBIC_TO, -1.11, 0, -2.05, -0.39, -2.83, -1.17,
ARC_TO, 3.87, 3.87, 0, 0, 1, 10.5, 5.5,
R_CUBIC_TO, 0, -1.11, 0.39, -2.05, 1.17, -2.83,
ARC_TO, 3.87, 3.87, 0, 0, 1, 14.5, 1.5,
R_CUBIC_TO, 1.11, 0, 2.05, 0.39, 2.83, 1.17,
ARC_TO, 3.87, 3.87, 0, 0, 1, 18.5, 5.5,
R_CUBIC_TO, 0, 1.11, -0.39, 2.05, -1.17, 2.83,
ARC_TO, 3.87, 3.87, 0, 0, 1, 14.5, 9.5,
CLOSE,
R_MOVE_TO, 0, -2,
R_CUBIC_TO, 0.13, 0, 0.25, -0.05, 0.35, -0.15,
ARC_TO, 0.49, 0.49, 0, 0, 0, 15, 7,
R_CUBIC_TO, 0, -0.13, -0.05, -0.25, -0.15, -0.35,
ARC_TO, 0.49, 0.49, 0, 0, 0, 14.5, 6.5,
R_CUBIC_TO, -0.13, 0, -0.25, 0.05, -0.35, 0.15,
ARC_TO, 0.49, 0.49, 0, 0, 0, 14, 7,
R_CUBIC_TO, 0, 0.13, 0.05, 0.25, 0.15, 0.35,
R_ARC_TO, 0.49, 0.49, 0, 0, 0, 0.35, 0.15,
CLOSE,
R_MOVE_TO, -0.5, -2,
R_H_LINE_TO, 1,
R_V_LINE_TO, -2,
R_H_LINE_TO, -1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaRouterWarningChromeRefreshRepList, kMediaRouterWarningChromeRefreshIcon, {kMediaRouterWarningChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMediaSeekBackwardPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11, 18,
V_LINE_TO, 6,
R_LINE_TO, -8.5, 6,
R_LINE_TO, 8.5, 6,
CLOSE,
R_MOVE_TO, 0.5, -6,
R_LINE_TO, 8.5, 6,
V_LINE_TO, 6,
R_LINE_TO, -8.5, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaSeekBackwardRepList, kMediaSeekBackwardIcon, {kMediaSeekBackwardPath})
VECTOR_ICON_REP_TEMPLATE(kMediaSeekForwardPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 4, 18,
R_LINE_TO, 8.5, -6,
LINE_TO, 4, 6,
R_V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, 9, -12,
R_V_LINE_TO, 12,
R_LINE_TO, 8.5, -6,
LINE_TO, 13, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaSeekForwardRepList, kMediaSeekForwardIcon, {kMediaSeekForwardPath})
VECTOR_ICON_REP_TEMPLATE(kMicPath, MOVE_TO, 24, 30,
R_CUBIC_TO, 3.31, 0, 5.98, -2.69, 5.98, -6,
LINE_TO, 30, 12,
R_CUBIC_TO, 0, -3.32, -2.68, -6, -6, -6,
R_CUBIC_TO, -3.31, 0, -6, 2.68, -6, 6,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 3.31, 2.69, 6, 6, 6,
CLOSE,
R_MOVE_TO, 10.6, -6,
R_CUBIC_TO, 0, 6, -5.07, 10.2, -10.6, 10.2,
R_CUBIC_TO, -5.52, 0, -10.6, -4.2, -10.6, -10.2,
H_LINE_TO, 10,
R_CUBIC_TO, 0, 6.83, 5.44, 12.47, 12, 13.44,
V_LINE_TO, 44,
R_H_LINE_TO, 4,
R_V_LINE_TO, -6.56,
R_CUBIC_TO, 6.56, -0.97, 12, -6.61, 12, -13.44,
R_H_LINE_TO, -3.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMicRepList, kMicIcon, {kMicPath})
VECTOR_ICON_REP_TEMPLATE(kMicChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 12,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, -0.73,
ARC_TO, 2.4, 2.4, 0, 0, 1, 7.5, 9.5,
R_V_LINE_TO, -5,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.49, 0.49, 0.73, 1.08, 0.73, 1.77,
R_V_LINE_TO, 5,
R_CUBIC_TO, 0, 0.7, -0.24, 1.29, -0.73, 1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 10, 12,
CLOSE,
R_MOVE_TO, 0, -5,
CLOSE,
R_MOVE_TO, -0.75, 10,
R_V_LINE_TO, -2.06,
R_CUBIC_TO, -1.37, -0.18, -2.51, -0.78, -3.4, -1.81,
CUBIC_TO, 4.95, 12.1, 4.5, 10.89, 4.5, 9.5,
H_LINE_TO, 6,
R_CUBIC_TO, 0, 1.11, 0.39, 2.05, 1.17, 2.83,
R_CUBIC_TO, 0.78, 0.78, 1.73, 1.17, 2.83, 1.17,
R_CUBIC_TO, 1.11, 0, 2.05, -0.39, 2.83, -1.17,
CUBIC_TO, 13.61, 11.55, 14, 10.61, 14, 9.5,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0, 1.39, -0.45, 2.6, -1.35, 3.63,
R_CUBIC_TO, -0.89, 1.03, -2.03, 1.63, -3.4, 1.81,
V_LINE_TO, 17,
CLOSE,
R_MOVE_TO, 0.75, -6.5,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 11, 9.5,
R_V_LINE_TO, -5,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_V_LINE_TO, 5,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMicChromeRefreshRepList, kMicChromeRefreshIcon, {kMicChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMicOffPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 11,
R_H_LINE_TO, -2,
R_CUBIC_TO, 0, 0.91, -0.25, 1.76, -0.68, 2.49,
R_LINE_TO, 1.45, 1.45,
CUBIC_TO, 18.54, 13.82, 19, 12.47, 19, 11,
CLOSE,
MOVE_TO, 2.81, 2.81,
LINE_TO, 1.39, 4.22,
R_LINE_TO, 11.66, 11.66,
CUBIC_TO, 12.71, 15.96, 12.36, 16, 12, 16,
R_CUBIC_TO, -2.76, 0, -5, -2.24, -5, -5,
H_LINE_TO, 5,
R_CUBIC_TO, 0, 3.53, 2.61, 6.43, 6, 6.92,
V_LINE_TO, 21,
R_H_LINE_TO, 2,
R_V_LINE_TO, -3.08,
R_CUBIC_TO, 0.57, -0.08, 1.12, -0.24, 1.64, -0.45,
R_LINE_TO, 5.14, 5.14,
R_LINE_TO, 1.41, -1.41,
LINE_TO, 2.81, 2.81,
CLOSE,
MOVE_TO, 15, 11,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
CUBIC_TO_SHORTHAND, 9, 3.34, 9, 5,
R_V_LINE_TO, 1.17,
R_LINE_TO, 5.81, 5.81,
CUBIC_TO, 14.92, 11.67, 15, 11.35, 15, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMicOffRepList, kMicOffIcon, {kMicOffPath})
VECTOR_ICON_REP_TEMPLATE(kMicOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14.61, 12.48,
LINE_TO, 13.5, 11.38,
R_CUBIC_TO, 0.15, -0.29, 0.27, -0.59, 0.36, -0.9,
R_CUBIC_TO, 0.09, -0.31, 0.13, -0.64, 0.13, -0.97,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0, 0.53, -0.08, 1.04, -0.23, 1.55,
R_CUBIC_TO, -0.15, 0.51, -0.37, 0.98, -0.66, 1.43,
CLOSE,
MOVE_TO, 9.94, 7.86,
CLOSE,
R_MOVE_TO, 2.44, 2.4,
LINE_TO, 11, 8.88,
V_LINE_TO, 4.5,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_V_LINE_TO, 2.38,
LINE_TO, 7.5, 5.37,
V_LINE_TO, 4.5,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.49, 0.49, 0.73, 1.08, 0.73, 1.77,
R_V_LINE_TO, 5,
R_ARC_TO, 2.43, 2.43, 0, 0, 1, -0.12, 0.75,
CLOSE,
MOVE_TO, 9.25, 17,
R_V_LINE_TO, -2.06,
R_CUBIC_TO, -1.37, -0.17, -2.51, -0.76, -3.41, -1.8,
CUBIC_TO, 4.95, 12.1, 4.5, 10.89, 4.5, 9.5,
H_LINE_TO, 6,
R_CUBIC_TO, 0, 1.11, 0.39, 2.05, 1.17, 2.83,
CUBIC_TO, 7.95, 13.11, 8.89, 13.5, 10, 13.5,
R_CUBIC_TO, 0.47, 0, 0.92, -0.09, 1.34, -0.27,
R_ARC_TO, 4.73, 4.73, 0, 0, 0, 1.18, -0.73,
R_LINE_TO, 1.09, 1.08,
R_ARC_TO, 6.51, 6.51, 0, 0, 1, -1.33, 0.89,
R_ARC_TO, 4.8, 4.8, 0, 0, 1, -1.52, 0.47,
V_LINE_TO, 17,
CLOSE,
MOVE_TO, 16, 18.13,
LINE_TO, 1.88, 3.98,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMicOffChromeRefreshRepList, kMicOffChromeRefreshIcon, {kMicOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMidiPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 3,
H_LINE_TO, 5,
CUBIC_TO, 3.9, 3, 3, 3.9, 3, 5,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 14,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 5,
CUBIC_TO, 21, 3.9, 20.1, 3, 19, 3,
CLOSE,
MOVE_TO, 14, 14.5,
R_H_LINE_TO, 0.25,
V_LINE_TO, 19,
R_H_LINE_TO, -4.5,
R_V_LINE_TO, -4.5,
H_LINE_TO, 10,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
V_LINE_TO, 5,
R_H_LINE_TO, 2,
R_V_LINE_TO, 8.5,
CUBIC_TO, 13, 14.05, 13.45, 14.5, 14, 14.5,
CLOSE,
MOVE_TO, 5, 5,
R_H_LINE_TO, 2,
R_V_LINE_TO, 8.5,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
R_H_LINE_TO, 0.25,
V_LINE_TO, 19,
H_LINE_TO, 5,
V_LINE_TO, 5,
CLOSE,
MOVE_TO, 19, 19,
R_H_LINE_TO, -3.25,
R_V_LINE_TO, -4.5,
H_LINE_TO, 16,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
V_LINE_TO, 5,
R_H_LINE_TO, 2,
V_LINE_TO, 19,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMidiRepList, kMidiIcon, {kMidiPath})
VECTOR_ICON_REP_TEMPLATE(kMidiChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 4.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
H_LINE_TO, 7,
V_LINE_TO, 12,
R_H_LINE_TO, -0.5,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.35, -0.14,
ARC_TO, 0.47, 0.47, 0, 0, 1, 6, 11.5,
R_V_LINE_TO, -7,
H_LINE_TO, 4.5,
CLOSE,
R_MOVE_TO, 8.5, 0,
R_H_LINE_TO, 2.5,
R_V_LINE_TO, -11,
H_LINE_TO, 14,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.14, -0.05, 0.26, -0.14, 0.36,
ARC_TO, 0.47, 0.47, 0, 0, 1, 13.5, 12,
H_LINE_TO, 13,
CLOSE,
R_MOVE_TO, -5, 0,
R_H_LINE_TO, 4,
V_LINE_TO, 12,
R_H_LINE_TO, -0.5,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.35, -0.14,
ARC_TO, 0.47, 0.47, 0, 0, 1, 11, 11.5,
R_V_LINE_TO, -7,
H_LINE_TO, 9,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.14, -0.05, 0.26, -0.14, 0.36,
ARC_TO, 0.47, 0.47, 0, 0, 1, 8.5, 12,
H_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMidiChromeRefreshRepList, kMidiChromeRefreshIcon, {kMidiChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMidiOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 14.88, 17,
H_LINE_TO, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
V_LINE_TO, 5.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, 1, -3.25,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 4.5,
H_LINE_TO, 14,
R_V_LINE_TO, 7,
R_ARC_TO, 0.43, 0.43, 0, 0, 1, -0.1, 0.27,
LINE_TO, 11, 8.88,
V_LINE_TO, 4.5,
H_LINE_TO, 9,
R_V_LINE_TO, 2.38,
LINE_TO, 5.13, 3,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE,
MOVE_TO, 4.5, 15.5,
H_LINE_TO, 7,
V_LINE_TO, 12,
R_H_LINE_TO, -0.5,
R_ARC_TO, 0.47, 0.47, 0, 0, 1, -0.35, -0.14,
ARC_TO, 0.47, 0.47, 0, 0, 1, 6, 11.5,
V_LINE_TO, 8.13,
R_LINE_TO, -1.5, -1.5,
CLOSE,
R_MOVE_TO, 3.5, 0,
R_H_LINE_TO, 4,
R_V_LINE_TO, -1.37,
R_LINE_TO, -3, -3,
R_V_LINE_TO, 0.38,
R_ARC_TO, 0.48, 0.48, 0, 0, 1, -0.14, 0.36,
ARC_TO, 0.48, 0.48, 0, 0, 1, 8.5, 12,
H_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 5, -0.04,
R_H_LINE_TO, 0.19,
LINE_TO, 13, 15.27,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMidiOffChromeRefreshRepList, kMidiOffChromeRefreshIcon, {kMidiOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNoEncryptionPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 12.93, 11.06,
LINE_TO, 11.55, 9.67,
V_LINE_TO, 6.84,
H_LINE_TO, 8.72,
LINE_TO, 7.34, 5.45,
R_H_LINE_TO, 2.54,
V_LINE_TO, 3.97,
R_CUBIC_TO, 0, -0.52, -0.18, -0.97, -0.54, -1.34,
R_ARC_TO, 1.81, 1.81, 0, 0, 0, -1.34, -0.55,
R_ARC_TO, 1.82, 1.82, 0, 0, 0, -1.34, 0.55,
R_ARC_TO, 1.81, 1.81, 0, 0, 0, -0.55, 1.33,
R_V_LINE_TO, 0.27,
LINE_TO, 4.92, 3.04,
ARC_TO, 3.15, 3.15, 0, 0, 1, 8, 0.7,
R_CUBIC_TO, 0.91, 0, 1.68, 0.32, 2.31, 0.95,
R_CUBIC_TO, 0.63, 0.63, 0.95, 1.4, 0.95, 2.31,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 0.29,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.59, 0.4, 0.98,
CLOSE,
R_MOVE_TO, 0.53, 4.09,
R_LINE_TO, -0.98, -0.99,
R_ARC_TO, 1.49, 1.49, 0, 0, 1, -0.4, 0.25,
R_ARC_TO, 1.23, 1.23, 0, 0, 1, -0.53, 0.11,
H_LINE_TO, 4.44,
R_ARC_TO, 1.35, 1.35, 0, 0, 1, -0.98, -0.4,
R_ARC_TO, 1.26, 1.26, 0, 0, 1, -0.39, -0.98,
V_LINE_TO, 6.84,
R_CUBIC_TO, 0, -0.3, 0.08, -0.56, 0.24, -0.79,
R_CUBIC_TO, 0.16, -0.23, 0.36, -0.39, 0.59, -0.48,
LINE_TO, 0.93, 2.61,
R_LINE_TO, 0.89, -0.89,
R_LINE_TO, 12.53, 12.55,
CLOSE,
R_MOVE_TO, -2.01, -2.01,
R_LINE_TO, -2.49, -2.48,
R_ARC_TO, 1.05, 1.05, 0, 0, 1, -0.41, 0.39,
R_ARC_TO, 1.18, 1.18, 0, 0, 1, -1.4, -0.21,
R_ARC_TO, 1.16, 1.16, 0, 0, 1, -0.35, -0.85,
R_CUBIC_TO, 0, -0.19, 0.04, -0.37, 0.13, -0.54,
R_CUBIC_TO, 0.08, -0.17, 0.22, -0.32, 0.39, -0.44,
LINE_TO, 5.16, 6.84,
H_LINE_TO, 4.45,
R_V_LINE_TO, 6.31,
CLOSE,
MOVE_TO, 8.14, 9.82,
CLOSE,
R_MOVE_TO, 1.94, -1.62,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNoEncryptionRepList, kNoEncryptionIcon, {kNoEncryptionPath})
VECTOR_ICON_REP_TEMPLATE(kNotSecureWarningPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 4, 27,
R_H_LINE_TO, 25,
LINE_TO, 16.5, 5,
LINE_TO, 4, 27,
CLOSE,
R_MOVE_TO, 14, -3,
R_H_LINE_TO, -3,
R_V_LINE_TO, -3,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
CLOSE,
R_MOVE_TO, 0, -5,
R_H_LINE_TO, -3,
R_V_LINE_TO, -6,
R_H_LINE_TO, 3,
R_V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNotSecureWarning16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 0.5, 14,
R_H_LINE_TO, 15,
LINE_TO, 8, 1,
LINE_TO, 0.5, 14,
CLOSE,
MOVE_TO, 9, 12,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -3,
H_LINE_TO, 7,
V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotSecureWarningRepList, kNotSecureWarningIcon, {kNotSecureWarningPath}, {kNotSecureWarning16Path})
VECTOR_ICON_REP_TEMPLATE(kNotSecureWarningChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 1, 17,
R_LINE_TO, 9, -15,
R_LINE_TO, 9, 15,
CLOSE,
R_MOVE_TO, 2.65, -1.5,
R_H_LINE_TO, 12.71,
LINE_TO, 10, 4.92,
CLOSE,
R_MOVE_TO, 6.35, -1,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.53, -0.22,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
MOVE_TO, 9.25, 12,
R_H_LINE_TO, 1.5,
V_LINE_TO, 8,
R_H_LINE_TO, -1.5,
CLOSE,
R_MOVE_TO, 0.75, -1.79,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNotSecureWarningChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 0.68, 13.67,
LINE_TO, 8, 1.47,
R_LINE_TO, 7.32, 12.2,
CLOSE,
R_MOVE_TO, 2.33, -1.32,
R_H_LINE_TO, 9.97,
LINE_TO, 8, 4.05,
CLOSE,
R_MOVE_TO, 4.98, -0.75,
R_CUBIC_TO, 0.17, 0, 0.32, -0.06, 0.44, -0.18,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, 0.18, -0.44,
R_ARC_TO, 0.62, 0.62, 0, 0, 0, -0.62, -0.62,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.44, 0.18,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.18, 0.43,
R_ARC_TO, 0.62, 0.62, 0, 0, 0, 0.62, 0.63,
CLOSE,
R_MOVE_TO, -0.6, -1.99,
R_H_LINE_TO, 1.2,
V_LINE_TO, 6.45,
H_LINE_TO, 7.4,
CLOSE,
MOVE_TO, 8, 8.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotSecureWarningChromeRefreshRepList, kNotSecureWarningChromeRefreshIcon, {kNotSecureWarningChromeRefreshPath}, {kNotSecureWarningChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kNotSecureWarningOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 14.48,
R_ARC_TO, 0.76, 0.76, 0, 0, 1, -0.55, -0.22,
R_ARC_TO, 0.74, 0.74, 0, 0, 1, -0.23, -0.55,
R_CUBIC_TO, 0, -0.21, 0.07, -0.4, 0.22, -0.55,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.55, -0.23,
R_CUBIC_TO, 0.22, 0, 0.4, 0.08, 0.55, 0.22,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.23, 0.55,
R_ARC_TO, 0.76, 0.76, 0, 0, 1, -0.22, 0.55,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.55, 0.23,
CLOSE,
MOVE_TO, 9.25, 12,
V_LINE_TO, 9.25,
R_LINE_TO, 1.5, 1.5,
V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, 9.78, 4.91,
R_LINE_TO, -4.8, -4.8,
LINE_TO, 10, 5.06,
LINE_TO, 8.95, 6.82,
LINE_TO, 7.73, 5.6,
LINE_TO, 10, 1.83,
CLOSE,
MOVE_TO, 3.77, 15.43,
R_H_LINE_TO, 9.43,
LINE_TO, 7.3, 9.54,
CLOSE,
R_MOVE_TO, 13.31, 3.88,
R_LINE_TO, -2.22, -2.22,
R_H_LINE_TO, -14,
LINE_TO, 6.11, 8.34,
LINE_TO, 0.7, 2.93,
R_LINE_TO, 1.11, -1.11,
R_LINE_TO, 16.38, 16.38,
CLOSE,
R_MOVE_TO, -6.82, -6.82,
CLOSE,
R_MOVE_TO, 1.34, -3.03,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotSecureWarningOffChromeRefreshRepList, kNotSecureWarningOffChromeRefreshIcon, {kNotSecureWarningOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNotUploadedPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16.5, 18.83,
LINE_TO, 14.29, 16.67,
H_LINE_TO, 5.42,
R_CUBIC_TO, -1.28, 0, -2.36, -0.44, -3.25, -1.33,
CUBIC_TO, 1.28, 14.44, 0.83, 13.36, 0.83, 12.08,
R_CUBIC_TO, 0, -1.07, 0.33, -2.02, 0.98, -2.85,
R_CUBIC_TO, 0.67, -0.83, 1.52, -1.37, 2.56, -1.6,
R_CUBIC_TO, 0.04, -0.11, 0.08, -0.21, 0.13, -0.31,
R_CUBIC_TO, 0.04, -0.11, 0.08, -0.23, 0.13, -0.35,
LINE_TO, 1.17, 3.5,
R_LINE_TO, 1.17, -1.17,
R_LINE_TO, 15.33, 15.33,
R_LINE_TO, -1.17, 1.17,
CLOSE,
MOVE_TO, 5.42, 15,
R_H_LINE_TO, 7.21,
LINE_TO, 5.92, 8.29,
R_ARC_TO, 5.52, 5.52, 0, 0, 0, -0.06, 0.44,
ARC_TO, 4.4, 4.4, 0, 0, 0, 5.83, 9.17,
R_H_LINE_TO, -0.42,
R_CUBIC_TO, -0.81, 0, -1.49, 0.28, -2.06, 0.85,
ARC_TO, 2.81, 2.81, 0, 0, 0, 2.5, 12.08,
R_CUBIC_TO, 0, 0.81, 0.28, 1.49, 0.85, 2.06,
ARC_TO, 2.81, 2.81, 0, 0, 0, 5.42, 15,
CLOSE,
R_MOVE_TO, 12.58, 0.63,
R_LINE_TO, -1.21, -1.17,
R_CUBIC_TO, 0.24, -0.19, 0.41, -0.42, 0.52, -0.67,
R_CUBIC_TO, 0.13, -0.26, 0.19, -0.56, 0.19, -0.87,
R_CUBIC_TO, 0, -0.58, -0.2, -1.08, -0.6, -1.48,
CUBIC_TO, 16.49, 11.04, 16, 10.83, 15.42, 10.83,
H_LINE_TO, 14.17,
R_V_LINE_TO, -1.67,
R_CUBIC_TO, 0, -1.15, -0.41, -2.13, -1.23, -2.94,
CUBIC_TO, 12.13, 5.41, 11.15, 5, 10, 5,
R_CUBIC_TO, -0.37, 0, -0.74, 0.05, -1.08, 0.15,
R_ARC_TO, 3.48, 3.48, 0, 0, 0, -1, 0.42,
R_LINE_TO, -1.21, -1.21,
R_CUBIC_TO, 0.49, -0.33, 1, -0.58, 1.54, -0.75,
ARC_TO, 5.63, 5.63, 0, 0, 1, 10, 3.33,
R_CUBIC_TO, 1.63, 0, 3, 0.57, 4.13, 1.71,
CUBIC_TO, 15.26, 6.17, 15.83, 7.54, 15.83, 9.17,
R_CUBIC_TO, 0.96, 0.11, 1.75, 0.53, 2.38, 1.25,
R_CUBIC_TO, 0.64, 0.71, 0.96, 1.54, 0.96, 2.5,
R_ARC_TO, 3.73, 3.73, 0, 0, 1, -0.31, 1.52,
ARC_TO, 3.66, 3.66, 0, 0, 1, 18, 15.63,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotUploadedRepList, kNotUploadedIcon, {kNotUploadedPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationWarningPath, CANVAS_DIMENSIONS, 96,
MOVE_TO, 48, 8,
R_CUBIC_TO, 22.08, 0, 40, 17.92, 40, 40,
CUBIC_TO_SHORTHAND, 70.08, 88, 48, 88,
CUBIC_TO_SHORTHAND, 8, 70.08, 8, 48,
CUBIC_TO_SHORTHAND, 25.92, 8, 48, 8,
CLOSE,
R_MOVE_TO, -4, 20,
R_V_LINE_TO, 24,
R_H_LINE_TO, 8,
V_LINE_TO, 28,
R_H_LINE_TO, -8,
CLOSE,
R_MOVE_TO, 0, 32,
R_V_LINE_TO, 8,
R_H_LINE_TO, 8,
R_V_LINE_TO, -8,
R_H_LINE_TO, -8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationWarningRepList, kNotificationWarningIcon, {kNotificationWarningPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationsPath, MOVE_TO, 24, 44,
R_CUBIC_TO, 2.21, 0, 4, -1.49, 4, -4,
R_H_LINE_TO, -8,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
CLOSE,
R_MOVE_TO, 12, -12,
V_LINE_TO, 22,
R_CUBIC_TO, 0, -6.15, -3.27, -11.28, -9, -12.64,
V_LINE_TO, 8,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
R_CUBIC_TO, -1.66, 0, -3, 1.34, -3, 3,
R_V_LINE_TO, 1.36,
R_CUBIC_TO, -5.73, 1.36, -9, 6.49, -9, 12.64,
R_V_LINE_TO, 10,
R_LINE_TO, -4, 4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 32,
R_V_LINE_TO, -2,
R_LINE_TO, -4, -4)
VECTOR_ICON_TEMPLATE_CC(kNotificationsRepList, kNotificationsIcon, {kNotificationsPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationsChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -1.21, 0.37, -2.27, 1.11, -3.19,
CUBIC_TO, 6.86, 4.9, 7.82, 4.33, 9, 4.11,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.2, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 1.11,
R_CUBIC_TO, 1.18, 0.22, 2.14, 0.79, 2.89, 1.71,
CUBIC_TO, 14.63, 6.73, 15, 7.79, 15, 9,
R_V_LINE_TO, 5,
R_H_LINE_TO, 1,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 6, -5.75,
CLOSE,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE,
MOVE_TO, 6.5, 14,
R_H_LINE_TO, 7,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
R_CUBIC_TO, -0.68, -0.68, -1.51, -1.02, -2.48, -1.02,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 6.84, 7.2, 6.5, 8.03, 6.5, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationsChromeRefreshRepList, kNotificationsChromeRefreshIcon, {kNotificationsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationsOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -0.57, 0.09, -1.11, 0.28, -1.64,
R_CUBIC_TO, 0.19, -0.52, 0.44, -1.01, 0.76, -1.47,
LINE_TO, 7.15, 7,
R_ARC_TO, 3.46, 3.46, 0, 0, 0, -0.48, 0.95,
ARC_TO, 3.32, 3.32, 0, 0, 0, 6.5, 9,
R_V_LINE_TO, 5,
H_LINE_TO, 12,
LINE_TO, 1.88, 3.88,
R_LINE_TO, 1.06, -1.08,
R_LINE_TO, 14.12, 14.15,
LINE_TO, 16, 18,
R_LINE_TO, -2.5, -2.5,
CLOSE,
R_MOVE_TO, 11, -2.75,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
R_CUBIC_TO, -0.68, -0.68, -1.51, -1.02, -2.48, -1.02,
R_CUBIC_TO, -0.32, 0, -0.62, 0.04, -0.91, 0.13,
R_ARC_TO, 4.05, 4.05, 0, 0, 0, -0.86, 0.36,
LINE_TO, 7.15, 4.89,
R_CUBIC_TO, 0.28, -0.2, 0.57, -0.37, 0.89, -0.49,
ARC_TO, 5.53, 5.53, 0, 0, 1, 9, 4.11,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.2, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 1.11,
R_CUBIC_TO, 1.18, 0.22, 2.14, 0.79, 2.89, 1.71,
CUBIC_TO, 14.63, 6.73, 15, 7.79, 15, 9,
CLOSE,
R_MOVE_TO, -5.75, -1.5,
CLOSE,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE,
R_MOVE_TO, 0.88, -9.39,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationsOffChromeRefreshRepList, kNotificationsOffChromeRefreshIcon, {kNotificationsOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPageInfoContentPastePath, CANVAS_DIMENSIONS, 18,
MOVE_TO, 6.71, 3.25,
R_ARC_TO, 2.5, 2.5, 0, 0, 1, 4.58, 0,
H_LINE_TO, 14,
R_ARC_TO, 1, 1, 0, 0, 1, 1, 1,
R_V_LINE_TO, 11,
R_ARC_TO, 1, 1, 0, 0, 1, -1, 1,
H_LINE_TO, 4,
R_ARC_TO, 1, 1, 0, 0, 1, -1, -1,
R_V_LINE_TO, -11,
R_ARC_TO, 1, 1, 0, 0, 1, 1, -1,
CLOSE,
MOVE_TO, 9, 5.25,
R_ARC_TO, 1, 1, 0, 1, 0, 0, -2,
R_ARC_TO, 1, 1, 0, 0, 0, 0, 2,
CLOSE,
R_MOVE_TO, -5, -0.5,
R_V_LINE_TO, 10,
R_H_LINE_TO, 10,
R_V_LINE_TO, -10,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.5,
R_ARC_TO, 1, 1, 0, 0, 1, -1, 1,
H_LINE_TO, 7,
R_ARC_TO, 1, 1, 0, 0, 1, -1, -1,
R_V_LINE_TO, -1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPageInfoContentPasteRepList, kPageInfoContentPasteIcon, {kPageInfoContentPastePath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11, 12,
R_QUADRATIC_TO, -1.65, 0, -2.81, -1.17,
QUADRATIC_TO, 7.03, 9.65, 7.03, 8,
R_QUADRATIC_TO, 0, -1.65, 1.16, -2.82,
QUADRATIC_TO, 9.35, 4, 11, 4,
R_QUADRATIC_TO, 1.65, 0, 2.83, 1.18,
QUADRATIC_TO, 15, 6.35, 15, 8,
R_QUADRATIC_TO, 0, 1.65, -1.17, 2.83,
QUADRATIC_TO, 12.65, 12, 11, 12,
CLOSE,
R_MOVE_TO, 7.25, 9,
LINE_TO, 17, 19.5,
R_V_LINE_TO, -3.67,
R_QUADRATIC_TO, -0.87, -0.32, -1.44, -1.09,
QUADRATIC_TO, 15, 13.98, 15, 13,
R_QUADRATIC_TO, 0, -1.25, 0.88, -2.12,
QUADRATIC_TO_SHORTHAND, 18, 10,
R_QUADRATIC_TO, 1.25, 0, 2.13, 0.88,
QUADRATIC_TO_SHORTHAND, 21, 13,
R_QUADRATIC_TO, 0, 0.98, -0.56, 1.74,
R_QUADRATIC_TO, -0.56, 0.76, -1.44, 1.09,
V_LINE_TO, 16,
R_LINE_TO, 1, 1,
R_LINE_TO, -1, 1,
R_LINE_TO, 1, 1,
CLOSE,
MOVE_TO, 3, 20,
R_V_LINE_TO, -2.77,
R_QUADRATIC_TO, 0, -0.85, 0.43, -1.57,
R_QUADRATIC_TO, 0.43, -0.72, 1.18, -1.1,
R_QUADRATIC_TO, 1.27, -0.65, 2.89, -1.1,
QUADRATIC_TO, 9.1, 13, 11, 13,
R_QUADRATIC_TO, 0.53, 0, 1.02, 0.04,
R_QUADRATIC_TO, 0.5, 0.04, 1, 0.11,
R_QUADRATIC_TO, 0.05, 1.13, 0.54, 2.15,
R_QUADRATIC_TO, 0.49, 1.02, 1.44, 1.68,
V_LINE_TO, 20,
CLOSE,
R_MOVE_TO, 15, -5.5,
R_QUADRATIC_TO, 0.63, 0, 1.06, -0.44,
R_QUADRATIC_TO, 0.44, -0.44, 0.44, -1.06,
R_QUADRATIC_TO, 0, -0.62, -0.44, -1.06,
QUADRATIC_TO, 18.63, 11.5, 18, 11.5,
R_QUADRATIC_TO, -0.63, 0, -1.06, 0.44,
QUADRATIC_TO, 16.5, 12.38, 16.5, 13,
R_QUADRATIC_TO, 0, 0.62, 0.44, 1.06,
R_QUADRATIC_TO, 0.44, 0.44, 1.06, 0.44,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasskeyRepList, kPasskeyIcon, {kPasskeyPath})
VECTOR_ICON_REP_TEMPLATE(kPasswordManagerPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6, 12,
R_CUBIC_TO, 0.55, 0, 1.02, -0.19, 1.41, -0.59,
CUBIC_TO, 7.8, 11.02, 8, 10.55, 8, 10,
R_CUBIC_TO, 0, -0.55, -0.19, -1.02, -0.59, -1.41,
ARC_TO, 1.94, 1.94, 0, 0, 0, 6, 8,
R_CUBIC_TO, -0.55, 0, -1.02, 0.2, -1.41, 0.59,
CUBIC_TO, 4.2, 8.98, 4, 9.45, 4, 10,
R_CUBIC_TO, 0, 0.55, 0.2, 1.02, 0.59, 1.41,
R_CUBIC_TO, 0.39, 0.39, 0.86, 0.59, 1.41, 0.59,
CLOSE,
R_MOVE_TO, 0, 3,
R_CUBIC_TO, -1.39, 0, -2.57, -0.48, -3.54, -1.46,
CUBIC_TO, 1.48, 12.57, 1, 11.39, 1, 10,
R_CUBIC_TO, 0, -1.39, 0.48, -2.57, 1.46, -3.54,
CUBIC_TO, 3.43, 5.48, 4.61, 5, 6, 5,
R_CUBIC_TO, 1, 0, 1.91, 0.27, 2.73, 0.81,
ARC_TO, 5.09, 5.09, 0, 0, 1, 10.58, 8,
H_LINE_TO, 17.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 4,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 17.5, 15,
R_H_LINE_TO, -3,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 13, 13.5,
V_LINE_TO, 12,
R_H_LINE_TO, -2.42,
R_ARC_TO, 5.09, 5.09, 0, 0, 1, -1.85, 2.19,
ARC_TO, 4.84, 4.84, 0, 0, 1, 6, 15,
CLOSE,
R_MOVE_TO, 3.46, -4.5,
H_LINE_TO, 14.5,
R_V_LINE_TO, 3,
R_H_LINE_TO, 1,
V_LINE_TO, 12,
R_CUBIC_TO, 0, -0.14, 0.05, -0.27, 0.14, -0.36,
R_ARC_TO, 0.49, 0.49, 0, 0, 1, 0.36, -0.14,
R_CUBIC_TO, 0.14, 0, 0.27, 0.05, 0.36, 0.14,
R_CUBIC_TO, 0.09, 0.09, 0.14, 0.22, 0.14, 0.36,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 1,
R_V_LINE_TO, -4,
H_LINE_TO, 9.46,
R_ARC_TO, 3.27, 3.27, 0, 0, 0, -1.16, -2.16,
ARC_TO, 3.45, 3.45, 0, 0, 0, 6, 6.5,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 2.84, 8.2, 2.5, 9.03, 2.5, 10,
R_CUBIC_TO, 0, 0.97, 0.34, 1.8, 1.02, 2.48,
R_CUBIC_TO, 0.68, 0.68, 1.51, 1.02, 2.48, 1.02,
R_CUBIC_TO, 0.87, 0, 1.64, -0.28, 2.3, -0.84,
ARC_TO, 3.27, 3.27, 0, 0, 0, 9.46, 10.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasswordManagerRepList, kPasswordManagerIcon, {kPasswordManagerPath})
VECTOR_ICON_REP_TEMPLATE(kPasswordManagerOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16, 18.13,
R_LINE_TO, -5.64, -5.64,
R_ARC_TO, 4.96, 4.96, 0, 0, 1, -1.83, 1.84,
ARC_TO, 4.96, 4.96, 0, 0, 1, 6, 15,
R_CUBIC_TO, -1.39, 0, -2.57, -0.48, -3.54, -1.46,
CUBIC_TO, 1.48, 12.57, 1, 11.39, 1, 10,
R_CUBIC_TO, 0, -0.9, 0.22, -1.74, 0.67, -2.52,
ARC_TO, 4.81, 4.81, 0, 0, 1, 3.52, 5.65,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
MOVE_TO, 6, 13.5,
R_CUBIC_TO, 0.71, 0, 1.36, -0.19, 1.94, -0.57,
R_ARC_TO, 3.53, 3.53, 0, 0, 0, 1.31, -1.57,
LINE_TO, 4.64, 6.77,
R_ARC_TO, 3.39, 3.39, 0, 0, 0, -1.57, 1.29,
R_ARC_TO, 3.46, 3.46, 0, 0, 0, -0.57, 1.95,
R_CUBIC_TO, 0, 0.96, 0.34, 1.78, 1.02, 2.47,
ARC_TO, 3.38, 3.38, 0, 0, 0, 6, 13.5,
CLOSE,
R_MOVE_TO, 5.63, -4,
CLOSE,
MOVE_TO, 19, 15,
R_H_LINE_TO, -1.87,
LINE_TO, 15, 12.88,
R_V_LINE_TO, -0.62,
R_CUBIC_TO, 0, -0.21, 0.07, -0.39, 0.22, -0.53,
R_ARC_TO, 0.71, 0.71, 0, 0, 1, 0.53, -0.21,
R_CUBIC_TO, 0.21, 0, 0.39, 0.07, 0.54, 0.22,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.22, 0.54,
R_V_LINE_TO, 1.25,
R_H_LINE_TO, 1,
R_V_LINE_TO, -4,
R_H_LINE_TO, -5.87,
R_LINE_TO, -1.5, -1.5,
H_LINE_TO, 19,
CLOSE,
MOVE_TO, 6, 12,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 4, 10,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 4.98, 8.2, 5.45, 8, 6, 8,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
CUBIC_TO, 7.8, 8.98, 8, 9.45, 8, 10,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
CUBIC_TO, 7.02, 11.8, 6.55, 12, 6, 12,
CLOSE,
R_MOVE_TO, 0, -1.87,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasswordManagerOffRepList, kPasswordManagerOffIcon, {kPasswordManagerOffPath})
VECTOR_ICON_REP_TEMPLATE(kPausePath, MOVE_TO, 12, 38,
R_H_LINE_TO, 8,
V_LINE_TO, 10,
R_H_LINE_TO, -8,
R_V_LINE_TO, 28,
CLOSE,
R_MOVE_TO, 16, -28,
R_V_LINE_TO, 28,
R_H_LINE_TO, 8,
V_LINE_TO, 10,
R_H_LINE_TO, -8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPauseRepList, kPauseIcon, {kPausePath})
VECTOR_ICON_REP_TEMPLATE(kPauseChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 11, 16,
V_LINE_TO, 4,
R_H_LINE_TO, 5,
R_V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, -7, 0,
V_LINE_TO, 4,
R_H_LINE_TO, 5,
R_V_LINE_TO, 12,
CLOSE,
R_MOVE_TO, 8.5, -1.5,
R_H_LINE_TO, 2,
R_V_LINE_TO, -9,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, -7, 0,
R_H_LINE_TO, 2,
R_V_LINE_TO, -9,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 0, -9,
R_V_LINE_TO, 9,
CLOSE,
R_MOVE_TO, 7, 0,
R_V_LINE_TO, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPauseChromeRefreshRepList, kPauseChromeRefreshIcon, {kPauseChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPersonCheckPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14.48f, 10.5f,
LINE_TO, 12, 8.02f,
LINE_TO, 13.06f, 6.96f,
LINE_TO, 14.48f, 8.38f,
LINE_TO, 17.67f, 5.21f,
LINE_TO, 18.73f, 6.25f,
LINE_TO, 14.48f, 10.5f,
CLOSE,
MOVE_TO, 8, 10,
CUBIC_TO, 7.17f, 10, 6.46f, 9.71f, 5.88f, 9.13f,
CUBIC_TO, 5.29f, 8.54f, 5, 7.83f, 5, 7,
CUBIC_TO, 5, 6.17f, 5.29f, 5.46f, 5.88f, 4.88f,
CUBIC_TO, 6.46f, 4.29f, 7.17f, 4, 8, 4,
CUBIC_TO, 8.83f, 4, 9.54f, 4.29f, 10.13f, 4.88f,
CUBIC_TO, 10.71f, 5.46f, 11, 6.17f, 11, 7,
CUBIC_TO, 11, 7.83f, 10.71f, 8.54f, 10.13f, 9.13f,
CUBIC_TO, 9.54f, 9.71f, 8.83f, 10, 8, 10,
CLOSE,
MOVE_TO, 2, 16,
V_LINE_TO, 14.08f,
CUBIC_TO, 2, 13.72f, 2.08f, 13.4f, 2.25f, 13.1f,
CUBIC_TO, 2.43f, 12.8f, 2.67f, 12.56f, 2.98f, 12.38f,
CUBIC_TO, 3.74f, 11.93f, 4.55f, 11.59f, 5.4f, 11.35f,
CUBIC_TO, 6.24f, 11.12f, 7.11f, 11, 8, 11,
CUBIC_TO, 8.89f, 11, 9.76f, 11.12f, 10.6f, 11.35f,
CUBIC_TO, 11.45f, 11.59f, 12.26f, 11.93f, 13.02f, 12.38f,
CUBIC_TO, 13.33f, 12.56f, 13.56f, 12.8f, 13.73f, 13.1f,
CUBIC_TO, 13.91f, 13.4f, 14, 13.72f, 14, 14.08f,
V_LINE_TO, 16,
H_LINE_TO, 2,
CLOSE,
MOVE_TO, 3.5f, 14.5f,
H_LINE_TO, 12.5f,
V_LINE_TO, 14.08f,
CUBIC_TO, 12.5f, 14, 12.48f, 13.92f, 12.44f, 13.85f,
CUBIC_TO, 12.4f, 13.77f, 12.34f, 13.71f, 12.27f, 13.67f,
CUBIC_TO, 11.62f, 13.29f, 10.93f, 13.01f, 10.21f, 12.81f,
CUBIC_TO, 9.49f, 12.6f, 8.75f, 12.5f, 8, 12.5f,
CUBIC_TO, 7.25f, 12.5f, 6.51f, 12.6f, 5.79f, 12.81f,
CUBIC_TO, 5.07f, 13.01f, 4.38f, 13.29f, 3.73f, 13.67f,
CUBIC_TO, 3.66f, 13.71f, 3.6f, 13.77f, 3.56f, 13.85f,
CUBIC_TO, 3.52f, 13.92f, 3.5f, 14, 3.5f, 14.08f,
V_LINE_TO, 14.5f,
CLOSE,
MOVE_TO, 8, 8.5f,
CUBIC_TO, 8.42f, 8.5f, 8.77f, 8.35f, 9.06f, 8.06f,
CUBIC_TO, 9.35f, 7.77f, 9.5f, 7.42f, 9.5f, 7,
CUBIC_TO, 9.5f, 6.58f, 9.35f, 6.23f, 9.06f, 5.94f,
CUBIC_TO, 8.77f, 5.65f, 8.42f, 5.5f, 8, 5.5f,
CUBIC_TO, 7.58f, 5.5f, 7.23f, 5.65f, 6.94f, 5.94f,
CUBIC_TO, 6.65f, 6.23f, 6.5f, 6.58f, 6.5f, 7,
CUBIC_TO, 6.5f, 7.42f, 6.65f, 7.77f, 6.94f, 8.06f,
CUBIC_TO, 7.23f, 8.35f, 7.58f, 8.5f, 8, 8.5f,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kPersonCheckRepList, kPersonCheckIcon, {kPersonCheckPath})
VECTOR_ICON_REP_TEMPLATE(kPersonTextPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7, 13,
CUBIC_TO, 7.93f, 13, 8.82f, 13.12f, 9.65f, 13.35f,
CUBIC_TO, 10.5f, 13.57f, 11.3f, 13.9f, 12.05f, 14.35f,
CUBIC_TO, 12.35f, 14.53f, 12.58f, 14.78f, 12.75f, 15.1f,
CUBIC_TO, 12.92f, 15.42f, 13, 15.75f, 13, 16.1f,
V_LINE_TO, 18,
H_LINE_TO, 1,
V_LINE_TO, 16.1f,
CUBIC_TO, 1, 15.75f, 1.08f, 15.42f, 1.25f, 15.1f,
CUBIC_TO, 1.42f, 14.78f, 1.65f, 14.53f, 1.95f, 14.35f,
CUBIC_TO, 2.7f, 13.9f, 3.49f, 13.57f, 4.33f, 13.35f,
CUBIC_TO, 5.18f, 13.12f, 6.07f, 13, 7, 13,
CLOSE,
MOVE_TO, 7, 15,
CUBIC_TO, 6.32f, 15, 5.65f, 15.08f, 5, 15.25f,
CUBIC_TO, 4.35f, 15.42f, 3.73f, 15.67f, 3.15f, 16,
H_LINE_TO, 10.85f,
CUBIC_TO, 10.27f, 15.67f, 9.65f, 15.42f, 9, 15.25f,
CUBIC_TO, 8.35f, 15.08f, 7.68f, 15, 7, 15,
CLOSE,
MOVE_TO, 23, 18,
H_LINE_TO, 16,
V_LINE_TO, 16,
H_LINE_TO, 23,
V_LINE_TO, 18,
CLOSE,
MOVE_TO, 23, 13,
H_LINE_TO, 14,
V_LINE_TO, 11,
H_LINE_TO, 23,
V_LINE_TO, 13,
CLOSE,
MOVE_TO, 7, 6,
CUBIC_TO, 7.83f, 6, 8.54f, 6.29f, 9.13f, 6.88f,
CUBIC_TO, 9.71f, 7.46f, 10, 8.17f, 10, 9,
CUBIC_TO, 10, 9.83f, 9.71f, 10.54f, 9.13f, 11.13f,
CUBIC_TO, 8.54f, 11.71f, 7.83f, 12, 7, 12,
CUBIC_TO, 6.17f, 12, 5.46f, 11.71f, 4.88f, 11.13f,
CUBIC_TO, 4.29f, 10.54f, 4, 9.83f, 4, 9,
CUBIC_TO, 4, 8.17f, 4.29f, 7.46f, 4.88f, 6.88f,
CUBIC_TO, 5.46f, 6.29f, 6.17f, 6, 7, 6,
CLOSE,
MOVE_TO, 7, 8,
CUBIC_TO, 6.72f, 8, 6.48f, 8.1f, 6.28f, 8.3f,
CUBIC_TO, 6.09f, 8.48f, 6, 8.72f, 6, 9,
CUBIC_TO, 6, 9.28f, 6.09f, 9.52f, 6.28f, 9.72f,
CUBIC_TO, 6.48f, 9.91f, 6.72f, 10, 7, 10,
CUBIC_TO, 7.28f, 10, 7.52f, 9.91f, 7.7f, 9.72f,
CUBIC_TO, 7.9f, 9.52f, 8, 9.28f, 8, 9,
CUBIC_TO, 8, 8.72f, 7.9f, 8.48f, 7.7f, 8.3f,
CUBIC_TO, 7.52f, 8.1f, 7.28f, 8, 7, 8,
CLOSE,
MOVE_TO, 23, 8,
H_LINE_TO, 12,
V_LINE_TO, 6,
H_LINE_TO, 23,
V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPersonTextRepList, kPersonTextIcon, {kPersonTextPath})
VECTOR_ICON_REP_TEMPLATE(kPhotoPath, CANVAS_DIMENSIONS, 18,
MOVE_TO, 15, 13.67,
V_LINE_TO, 4.33,
CUBIC_TO, 15, 3.6, 14.4, 3, 13.67, 3,
H_LINE_TO, 4.33,
CUBIC_TO, 3.6, 3, 3, 3.6, 3, 4.33,
R_V_LINE_TO, 9.33,
CUBIC_TO, 3, 14.4, 3.6, 15, 4.33, 15,
R_H_LINE_TO, 9.33,
CUBIC_TO, 14.4, 15, 15, 14.4, 15, 13.67,
CLOSE,
MOVE_TO, 6.67, 10,
R_LINE_TO, 1.67, 2.01,
LINE_TO, 10.67, 9,
R_LINE_TO, 3, 4,
H_LINE_TO, 4.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPhotoRepList, kPhotoIcon, {kPhotoPath})
VECTOR_ICON_REP_TEMPLATE(kPhotoChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_ARC_TO, 1.42, 1.42, 0, 0, 1, -1.06, -0.45,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.44, -1.05,
CUBIC_TO, 3.73, 3.15, 4.09, 3, 4.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.45,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.05,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
R_V_LINE_TO, -11,
R_H_LINE_TO, -11,
CLOSE,
R_MOVE_TO, 1, -1.5,
R_H_LINE_TO, 9,
R_LINE_TO, -3, -4,
R_LINE_TO, -2.25, 3,
R_LINE_TO, -1.5, -2,
CLOSE,
R_MOVE_TO, -1, 1.5,
R_V_LINE_TO, -11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPhotoChromeRefreshRepList, kPhotoChromeRefreshIcon, {kPhotoChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPhotoOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 17, 14.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 4.5,
H_LINE_TO, 6.63,
LINE_TO, 5.13, 3,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.4, 0, 0.75, 0.15, 1.05, 0.45,
R_CUBIC_TO, 0.3, 0.3, 0.45, 0.65, 0.45, 1.05,
CLOSE,
R_MOVE_TO, -1, 3.25,
LINE_TO, 14.88, 17,
H_LINE_TO, 4.5,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
V_LINE_TO, 5.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
MOVE_TO, 5.5, 14,
R_LINE_TO, 2.25, -3,
R_LINE_TO, 1.5, 2,
R_LINE_TO, 0.71, -0.94,
LINE_TO, 4.5, 6.63,
V_LINE_TO, 15.5,
R_H_LINE_TO, 8.88,
R_LINE_TO, -1.5, -1.5,
CLOSE,
MOVE_TO, 11, 9,
CLOSE,
R_MOVE_TO, -2.12, 2.13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPhotoOffChromeRefreshRepList, kPhotoOffChromeRefreshIcon, {kPhotoOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPictureInPicturePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 4, 20,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 16,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
R_CUBIC_TO, -0.39, 0.39, -0.86, 0.59, -1.41, 0.59,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 16,
V_LINE_TO, 6,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 7, -5,
R_H_LINE_TO, 8,
V_LINE_TO, 7,
R_H_LINE_TO, -8,
CLOSE,
R_MOVE_TO, 2, -2,
V_LINE_TO, 9,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPictureInPictureRepList, kPictureInPictureIcon, {kPictureInPicturePath})
VECTOR_ICON_REP_TEMPLATE(kPictureInPictureAltPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 160, 800,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 720,
R_V_LINE_TO, -480,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 160,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 240,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 800,
H_LINE_TO, 160,
CLOSE,
R_MOVE_TO, 0, -80,
R_H_LINE_TO, 640,
R_V_LINE_TO, -480,
H_LINE_TO, 160,
R_V_LINE_TO, 480,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -480,
R_V_LINE_TO, 480,
CLOSE,
R_MOVE_TO, 280, -40,
R_H_LINE_TO, 320,
R_V_LINE_TO, -240,
H_LINE_TO, 440,
R_V_LINE_TO, 240,
CLOSE,
R_MOVE_TO, 80, -80,
R_V_LINE_TO, -80,
R_H_LINE_TO, 160,
R_V_LINE_TO, 80,
H_LINE_TO, 520,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPictureInPictureAltRepList, kPictureInPictureAltIcon, {kPictureInPictureAltPath})
VECTOR_ICON_REP_TEMPLATE(kPipExitPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 160, 800,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 720,
R_V_LINE_TO, -280,
R_H_LINE_TO, 80,
R_V_LINE_TO, 280,
R_H_LINE_TO, 640,
R_V_LINE_TO, -480,
H_LINE_TO, 440,
R_V_LINE_TO, -80,
R_H_LINE_TO, 360,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 240,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 800,
H_LINE_TO, 160,
CLOSE,
R_MOVE_TO, 523, -140,
R_LINE_TO, 57, -57,
R_LINE_TO, -124, -123,
R_H_LINE_TO, 104,
R_V_LINE_TO, -80,
H_LINE_TO, 480,
R_V_LINE_TO, 240,
R_H_LINE_TO, 80,
R_V_LINE_TO, -103,
R_LINE_TO, 123, 123,
CLOSE,
MOVE_TO, 80, 360,
R_V_LINE_TO, -200,
R_H_LINE_TO, 280,
R_V_LINE_TO, 200,
H_LINE_TO, 80,
CLOSE,
R_MOVE_TO, 400, 120,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPipExitRepList, kPipExitIcon, {kPipExitPath})
VECTOR_ICON_REP_TEMPLATE(kPlayArrowPath, FLIPS_IN_RTL,
MOVE_TO, 16, 10,
R_V_LINE_TO, 28,
R_LINE_TO, 22, -14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPlayArrowRepList, kPlayArrowIcon, {kPlayArrowPath})
VECTOR_ICON_REP_TEMPLATE(kPlayArrowChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7, 15.5,
R_V_LINE_TO, -11,
R_LINE_TO, 8.5, 5.5,
CLOSE,
R_MOVE_TO, 1.52, -5.52,
CLOSE,
R_MOVE_TO, -0.02, 2.77,
LINE_TO, 12.75, 10,
LINE_TO, 8.5, 7.25,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPlayArrowChromeRefreshRepList, kPlayArrowChromeRefreshIcon, {kPlayArrowChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPointerLockPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 480, 440,
CLOSE,
R_MOVE_TO, 0, 440,
R_QUADRATIC_TO, -116, 0, -198, -82,
R_QUADRATIC_TO, -82, -82, -82, -198,
R_V_LINE_TO, -240,
R_QUADRATIC_TO, 0, -116, 82, -198,
R_QUADRATIC_TO, 82, -82, 198, -82,
R_QUADRATIC_TO, 116, 0, 198, 82,
R_QUADRATIC_TO, 82, 82, 82, 198,
R_V_LINE_TO, 124,
R_QUADRATIC_TO, -20, -4, -40, -4,
R_QUADRATIC_TO, -20, 0, -40, 4,
R_V_LINE_TO, -44,
H_LINE_TO, 280,
R_V_LINE_TO, 160,
R_QUADRATIC_TO, 0, 83, 58.5, 141.5,
QUADRATIC_TO_SHORTHAND, 480, 800,
R_QUADRATIC_TO, 11, 0, 20.5, -1,
R_QUADRATIC_TO, 9.5, -1, 19.5, -3,
R_V_LINE_TO, 81,
R_QUADRATIC_TO, -10, 2, -19.5, 2.5,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE,
MOVE_TO, 280, 360,
R_H_LINE_TO, 160,
R_V_LINE_TO, -196,
R_QUADRATIC_TO, -69, 14, -114.5, 69,
QUADRATIC_TO_SHORTHAND, 280, 360,
CLOSE,
R_MOVE_TO, 240, 0,
R_H_LINE_TO, 160,
R_QUADRATIC_TO, 0, -72, -45.5, -127,
QUADRATIC_TO_SHORTHAND, 520, 164,
R_V_LINE_TO, 196,
CLOSE,
MOVE_TO, 634, 880,
R_QUADRATIC_TO, -14, 0, -24, -10,
R_QUADRATIC_TO, -10, -10, -10, -24,
R_V_LINE_TO, -132,
R_QUADRATIC_TO, 0, -14, 10, -24,
R_QUADRATIC_TO, 10, -10, 24, -10,
R_H_LINE_TO, 6,
R_V_LINE_TO, -40,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 720, 560,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 800, 640,
R_V_LINE_TO, 40,
R_H_LINE_TO, 6,
R_QUADRATIC_TO, 14, 0, 24, 10,
R_QUADRATIC_TO, 10, 10, 10, 24,
R_V_LINE_TO, 132,
R_QUADRATIC_TO, 0, 14, -10, 24,
R_QUADRATIC_TO, -10, 10, -24, 10,
H_LINE_TO, 634,
CLOSE,
R_MOVE_TO, 46, -200,
R_H_LINE_TO, 80,
R_V_LINE_TO, -40,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 720, 600,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 680, 640,
R_V_LINE_TO, 40,
CLOSE,
MOVE_TO, 480, 440,
CLOSE,
R_MOVE_TO, 40, -80,
CLOSE,
R_MOVE_TO, -80, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPointerLockRepList, kPointerLockIcon, {kPointerLockPath})
VECTOR_ICON_REP_TEMPLATE(kPointerLockOffPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 440, 328,
CLOSE,
R_MOVE_TO, 111, 112,
CLOSE,
R_MOVE_TO, -131, 93,
CLOSE,
R_MOVE_TO, 20, -93,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE,
R_MOVE_TO, 80, -80,
CLOSE,
R_MOVE_TO, -40, -280,
R_QUADRATIC_TO, 116, 0, 198, 82,
R_QUADRATIC_TO, 82, 82, 82, 198,
R_V_LINE_TO, 124,
R_QUADRATIC_TO, -20, -4, -40, -4,
R_QUADRATIC_TO, -20, 0, -40, 4,
R_V_LINE_TO, -44,
H_LINE_TO, 551,
LINE_TO, 440, 328,
R_V_LINE_TO, -164,
R_QUADRATIC_TO, -31, 6, -57.5, 21,
QUADRATIC_TO_SHORTHAND, 335, 222,
R_LINE_TO, -56, -57,
R_QUADRATIC_TO, 38, -39, 90, -62,
R_QUADRATIC_TO, 52, -23, 111, -23,
CLOSE,
MOVE_TO, 231, 232,
R_LINE_TO, 209, 208,
H_LINE_TO, 280,
R_V_LINE_TO, 160,
R_QUADRATIC_TO, 0, 83, 58.5, 141.5,
QUADRATIC_TO_SHORTHAND, 480, 800,
R_QUADRATIC_TO, 11, 0, 20.5, -1,
R_QUADRATIC_TO, 9.5, -1, 19.5, -3,
R_V_LINE_TO, 81,
R_QUADRATIC_TO, -10, 2, -19.5, 2.5,
QUADRATIC_TO_SHORTHAND, 480, 880,
R_QUADRATIC_TO, -116, 0, -198, -82,
R_QUADRATIC_TO, -82, -82, -82, -198,
R_V_LINE_TO, -240,
R_QUADRATIC_TO, 0, -35, 8, -67,
R_QUADRATIC_TO, 8, -32, 23, -61,
CLOSE,
R_MOVE_TO, 289, 128,
R_H_LINE_TO, 160,
R_QUADRATIC_TO, 0, -72, -45.5, -127,
QUADRATIC_TO_SHORTHAND, 520, 164,
R_V_LINE_TO, 196,
CLOSE,
MOVE_TO, 819, 932,
LINE_TO, 28, 140,
R_LINE_TO, 56, -56,
LINE_TO, 876, 876,
R_LINE_TO, -57, 56,
CLOSE,
MOVE_TO, 634, 880,
R_QUADRATIC_TO, -14, 0, -24, -10,
R_QUADRATIC_TO, -10, -10, -10, -24,
R_V_LINE_TO, -126,
R_QUADRATIC_TO, 0, -17, 11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 640, 680,
R_H_LINE_TO, 40,
R_LINE_TO, 160, 160,
R_V_LINE_TO, 6,
R_QUADRATIC_TO, 0, 14, -10, 24,
R_QUADRATIC_TO, -10, 10, -24, 10,
H_LINE_TO, 634,
CLOSE,
R_MOVE_TO, 166, -188,
R_LINE_TO, -40, -40,
R_V_LINE_TO, -12,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 720, 600,
R_H_LINE_TO, -5,
R_QUADRATIC_TO, -3, 0, -5, 1,
R_LINE_TO, -30, -30,
R_QUADRATIC_TO, 9, -5, 19, -8,
R_QUADRATIC_TO, 10, -3, 21, -3,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 800, 640,
R_V_LINE_TO, 52,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPointerLockOffRepList, kPointerLockOffIcon, {kPointerLockOffPath})
VECTOR_ICON_REP_TEMPLATE(kPrinterPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 640, 320,
R_V_LINE_TO, -120,
H_LINE_TO, 320,
R_V_LINE_TO, 120,
R_H_LINE_TO, -80,
R_V_LINE_TO, -200,
R_H_LINE_TO, 480,
R_V_LINE_TO, 200,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, -480, 80,
R_H_LINE_TO, 640,
R_H_LINE_TO, -640,
CLOSE,
R_MOVE_TO, 560, 100,
R_QUADRATIC_TO, 17, 0, 28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 760, 460,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 720, 420,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 680, 460,
R_QUADRATIC_TO, 0, 17, 11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 720, 500,
CLOSE,
R_MOVE_TO, -80, 260,
R_V_LINE_TO, -160,
H_LINE_TO, 320,
R_V_LINE_TO, 160,
R_H_LINE_TO, 320,
CLOSE,
R_MOVE_TO, 80, 80,
H_LINE_TO, 240,
R_V_LINE_TO, -160,
H_LINE_TO, 80,
R_V_LINE_TO, -240,
R_QUADRATIC_TO, 0, -51, 35, -85.5,
R_QUADRATIC_TO, 35, -34.5, 85, -34.5,
R_H_LINE_TO, 560,
R_QUADRATIC_TO, 51, 0, 85.5, 34.5,
QUADRATIC_TO_SHORTHAND, 880, 440,
R_V_LINE_TO, 240,
H_LINE_TO, 720,
R_V_LINE_TO, 160,
CLOSE,
R_MOVE_TO, 80, -240,
R_V_LINE_TO, -160,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 760, 400,
H_LINE_TO, 200,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 160, 440,
R_V_LINE_TO, 160,
R_H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, 480,
R_V_LINE_TO, 80,
R_H_LINE_TO, 80,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPrinterRepList, kPrinterIcon, {kPrinterPath})
VECTOR_ICON_REP_TEMPLATE(kProtectedContentPath, CANVAS_DIMENSIONS, 18,
MOVE_TO, 7.54, 11.99,
R_LINE_TO, -0.81, -0.81,
R_V_LINE_TO, 0,
LINE_TO, 5.11, 9.56,
R_LINE_TO, 0.71, -0.71,
R_LINE_TO, 1.62, 1.62,
R_LINE_TO, 4.24, -4.24,
R_LINE_TO, 0.81, 0.81,
R_LINE_TO, -4.95, 4.95,
CLOSE,
MOVE_TO, 15.86, 3,
H_LINE_TO, 2.14,
CUBIC_TO, 1.34, 3, 1, 3.32, 1, 4,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.67, 0.34, 1, 1.14, 1,
H_LINE_TO, 5.57,
R_V_LINE_TO, 1,
R_H_LINE_TO, 6.86,
R_V_LINE_TO, -1,
R_H_LINE_TO, 3.43,
R_CUBIC_TO, 0.8, 0, 1.14, -0.33, 1.14, -1,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -0.68, -0.34, -1, -1.14, -1,
CLOSE,
MOVE_TO, 15, 13,
H_LINE_TO, 3,
V_LINE_TO, 5,
R_H_LINE_TO, 12,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProtectedContentRepList, kProtectedContentIcon, {kProtectedContentPath})
VECTOR_ICON_REP_TEMPLATE(kProtocolHandlerPath, MOVE_TO, 43.44, 22.66,
LINE_TO, 30.15, 8.59,
CUBIC_TO, 29.42, 7.82, 28.14, 7.81, 27.39, 8.57,
LINE_TO, 24.05, 12.01,
LINE_TO, 20.82, 8.59,
CUBIC_TO, 20.08, 7.81, 18.79, 7.81, 18.06, 8.57,
LINE_TO, 4.58, 22.44,
CUBIC_TO, 4.21, 22.82, 4, 23.33, 4, 23.87,
CUBIC_TO, 4, 24.42, 4.2, 24.93, 4.56, 25.32,
LINE_TO, 17.85, 39.39,
CUBIC_TO, 18.22, 39.78, 18.71, 40, 19.24, 40,
CUBIC_TO, 19.75, 40, 20.24, 39.79, 20.61, 39.41,
LINE_TO, 23.95, 35.97,
LINE_TO, 27.18, 39.39,
CUBIC_TO, 27.55, 39.78, 28.04, 40, 28.57, 40,
CUBIC_TO, 29.09, 40, 29.58, 39.79, 29.94, 39.41,
LINE_TO, 43.42, 25.54,
CUBIC_TO, 44.18, 24.76, 44.19, 23.46, 43.44, 22.66,
LINE_TO, 43.44, 22.66,
LINE_TO, 43.44, 22.66,
CLOSE,
MOVE_TO, 13.89, 24.93,
LINE_TO, 21.21, 32.5,
LINE_TO, 19.26, 34.46,
LINE_TO, 8.71, 23.54,
LINE_TO, 19.41, 12.79,
LINE_TO, 21.27, 14.71,
LINE_TO, 13.92, 22.11,
CUBIC_TO, 13.54, 22.49, 13.34, 22.98, 13.33, 23.52,
CUBIC_TO, 13.33, 24.05, 13.53, 24.55, 13.89, 24.93,
LINE_TO, 13.89, 24.93,
LINE_TO, 13.89, 24.93,
CLOSE,
MOVE_TO, 28.59, 34.46,
LINE_TO, 26.73, 32.54,
LINE_TO, 34.09, 25.14,
CUBIC_TO, 34.85, 24.37, 34.86, 23.1, 34.11, 22.32,
LINE_TO, 26.79, 14.75,
LINE_TO, 28.74, 12.79,
LINE_TO, 39.29, 23.71,
LINE_TO, 28.59, 34.46,
LINE_TO, 28.59, 34.46,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProtocolHandlerRepList, kProtocolHandlerIcon, {kProtocolHandlerPath})
VECTOR_ICON_REP_TEMPLATE(kProtocolHandlerChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.88, 16.4,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.39, -0.08,
R_ARC_TO, 1.18, 1.18, 0, 0, 1, -0.35, -0.25,
LINE_TO, 2.25, 10.67,
R_ARC_TO, 1.08, 1.08, 0, 0, 1, -0.19, -0.32,
R_ARC_TO, 1, 1, 0, 0, 1, 0.19, -1.01,
R_LINE_TO, 4.88, -5.39,
R_CUBIC_TO, 0.11, -0.11, 0.23, -0.19, 0.36, -0.25,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, 0.78, 0,
R_CUBIC_TO, 0.12, 0.06, 0.23, 0.14, 0.34, 0.25,
LINE_TO, 10, 5.48,
R_LINE_TO, 1.4, -1.54,
R_ARC_TO, 1.3, 1.3, 0, 0, 1, 0.34, -0.25,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, 0.78, 0,
R_CUBIC_TO, 0.13, 0.06, 0.25, 0.14, 0.36, 0.25,
R_LINE_TO, 4.88, 5.4,
R_CUBIC_TO, 0.08, 0.1, 0.14, 0.21, 0.19, 0.32,
R_CUBIC_TO, 0.04, 0.12, 0.06, 0.24, 0.06, 0.34,
R_ARC_TO, 1.08, 1.08, 0, 0, 1, -0.25, 0.67,
R_LINE_TO, -4.87, 5.4,
R_CUBIC_TO, -0.11, 0.11, -0.23, 0.2, -0.35, 0.25,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.78, 0,
R_ARC_TO, 1.3, 1.3, 0, 0, 1, -0.34, -0.25,
LINE_TO, 10, 14.52,
R_LINE_TO, -1.39, 1.54,
R_ARC_TO, 1.3, 1.3, 0, 0, 1, -0.34, 0.25,
R_ARC_TO, 0.92, 0.92, 0, 0, 1, -0.39, 0.08,
CLOSE,
R_MOVE_TO, 0, -1.75,
LINE_TO, 9, 13.42,
R_LINE_TO, -2.5, -2.75,
ARC_TO, 0.99, 0.99, 0, 0, 1, 6.25, 10,
R_CUBIC_TO, 0, -0.25, 0.08, -0.47, 0.25, -0.67,
LINE_TO, 9, 6.58,
LINE_TO, 7.88, 5.36,
LINE_TO, 3.67, 10,
CLOSE,
R_MOVE_TO, 4.25, 0,
LINE_TO, 16.33, 10,
R_LINE_TO, -4.21, -4.64,
LINE_TO, 11, 6.58,
R_LINE_TO, 2.5, 2.75,
R_CUBIC_TO, 0.17, 0.2, 0.25, 0.42, 0.25, 0.67,
R_CUBIC_TO, 0, 0.25, -0.08, 0.47, -0.25, 0.67,
R_LINE_TO, -2.5, 2.75,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProtocolHandlerChromeRefreshRepList, kProtocolHandlerChromeRefreshIcon, {kProtocolHandlerChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kProtocolHandlerOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 13.38, 15.5,
R_LINE_TO, -0.5, 0.56,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.33, 0.25,
R_ARC_TO, 1.04, 1.04, 0, 0, 1, -0.42, 0.08,
R_CUBIC_TO, -0.15, 0, -0.29, -0.03, -0.42, -0.08,
R_ARC_TO, 0.81, 0.81, 0, 0, 1, -0.31, -0.25,
LINE_TO, 10, 14.52,
R_LINE_TO, -1.39, 1.54,
R_ARC_TO, 0.98, 0.98, 0, 0, 1, -0.33, 0.25,
R_ARC_TO, 1.04, 1.04, 0, 0, 1, -0.81, 0,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.33, -0.25,
LINE_TO, 2.25, 10.67,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, -0.19, -0.3,
ARC_TO, 1.05, 1.05, 0, 0, 1, 2, 10,
R_ARC_TO, 0.99, 0.99, 0, 0, 1, 0.25, -0.67,
LINE_TO, 4.61, 6.73,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -3.69, -3.69,
R_LINE_TO, -1.17, -1.19,
CLOSE,
R_MOVE_TO, -4.44, 0.21,
LINE_TO, 9, 13.42,
R_LINE_TO, -2.5, -2.75,
ARC_TO, 0.99, 0.99, 0, 0, 1, 6.25, 10,
R_CUBIC_TO, 0, -0.25, 0.08, -0.47, 0.25, -0.67,
R_LINE_TO, 0.33, -0.37,
R_LINE_TO, -1.16, -1.16,
R_LINE_TO, -2, 2.21,
CLOSE,
R_MOVE_TO, 7.52, -1.37,
R_LINE_TO, -1.06, -1.06,
R_LINE_TO, 2, -2.21,
R_LINE_TO, -4.35, -4.5,
LINE_TO, 11, 6.58,
R_LINE_TO, 2.5, 2.75,
R_CUBIC_TO, 0.17, 0.2, 0.25, 0.42, 0.25, 0.67,
R_CUBIC_TO, 0, 0.25, -0.08, 0.47, -0.25, 0.67,
R_LINE_TO, -0.33, 0.38,
LINE_TO, 6.63, 4.5,
R_LINE_TO, 0.5, -0.56,
R_CUBIC_TO, 0.11, -0.11, 0.23, -0.19, 0.34, -0.25,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, 0.41, -0.08,
R_CUBIC_TO, 0.14, 0, 0.27, 0.03, 0.4, 0.08,
R_CUBIC_TO, 0.13, 0.05, 0.24, 0.14, 0.34, 0.25,
LINE_TO, 10, 5.48,
R_LINE_TO, 1.4, -1.54,
R_ARC_TO, 0.98, 0.98, 0, 0, 1, 0.34, -0.25,
R_ARC_TO, 1.04, 1.04, 0, 0, 1, 0.81, 0,
R_CUBIC_TO, 0.13, 0.06, 0.23, 0.14, 0.33, 0.25,
R_LINE_TO, 4.88, 5.4,
ARC_TO, 0.99, 0.99, 0, 0, 1, 18, 10,
R_ARC_TO, 0.99, 0.99, 0, 0, 1, -0.25, 0.67,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProtocolHandlerOffChromeRefreshRepList, kProtocolHandlerOffChromeRefreshIcon, {kProtocolHandlerOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kQwacStatusPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 9.97f, 0,
R_ARC_TO, 4.87f, 4.87f, 0, 0, 0, -4.86f, 4.87f,
V_LINE_TO, 7.56f,
ARC_TO, 2.07f, 2.07f, 0, 0, 0, 3.2f, 9.63f,
R_V_LINE_TO, 8.3f,
CUBIC_TO, 3.2f, 19.07f, 4.13f, 20, 5.27f, 20,
R_H_LINE_TO, 9.46f,
R_CUBIC_TO, 1.15f, 0, 2.07f, -0.93f, 2.07f, -2.08f,
V_LINE_TO, 9.63f,
R_CUBIC_TO, 0, -1.11f, -0.86f, -2.01f, -1.95f, -2.07f,
R_CUBIC_TO, -0.01f, -0.8f, -0.02f, -1.73f, -0.02f, -2.68f,
ARC_TO, 4.87f, 4.87f, 0, 0, 0, 9.97f, 0,
CLOSE,
R_MOVE_TO, 0, 2.08f,
R_ARC_TO, 2.8f, 2.8f, 0, 0, 1, 2.79f, 2.8f,
R_CUBIC_TO, 0, 0.95f, 0.01f, 1.87f, 0.02f, 2.68f,
H_LINE_TO, 7.18f,
R_V_LINE_TO, -2.68f,
R_ARC_TO, 2.8f, 2.8f, 0, 0, 1, 2.79f, -2.8f,
CLOSE,
R_MOVE_TO, 0.03f, 6.45f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.34f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, 5.37f, 0.32f,
R_CUBIC_TO, 0.2f, 0.07f, 0.37f, 0.18f, 0.56f, 0.56f,
R_ARC_TO, 17.78f, 17.78f, 0, 0, 0, -1.68f, 1.75f,
R_LINE_TO, 0.09f, 0.26f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.1f, -0.08f,
R_CUBIC_TO, -0.26f, 0.32f, -0.52f, 0.65f, -0.78f, 1,
R_ARC_TO, 50.19f, 50.19f, 0, 0, 0, -2.76f, 4.07f,
R_CUBIC_TO, -0.72f, -0.92f, -1.94f, -2.23f, -3.64f, -3.93f,
R_LINE_TO, 0.85f, -0.83f,
LINE_TO, 9.77f, 13.87f,
R_ARC_TO, 85.52f, 85.52f, 0, 0, 1, 3.44f, -3.27f,
R_CUBIC_TO, 1.07f, -0.95f, 1.79f, -1.53f, 2.17f, -1.76f,
CLOSE,
R_MOVE_TO, -2.88f, 0.35f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, -4.98f, 0,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
MOVE_TO, 5.77f, 10.97f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, 8.29f, 0.4f,
R_LINE_TO, -0.03f, 0.04f,
R_H_LINE_TO, 0.02f,
R_LINE_TO, 0.01f, -0.04f,
CLOSE,
MOVE_TO, 5.4f, 13.13f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, 9.21f, 0,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, -8.71f, 2.37f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, 8.3f, 0,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, -1.7f, 1.58f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, -4.98f, 0.17f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.35f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE,
R_MOVE_TO, 2.49f, 0.58f,
R_LINE_TO, 0.14f, 0.44f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, -0.35f, 0.28f,
R_LINE_TO, 0.13f, 0.44f,
R_LINE_TO, -0.36f, -0.26f,
R_LINE_TO, -0.36f, 0.26f,
R_LINE_TO, 0.13f, -0.44f,
R_LINE_TO, -0.34f, -0.28f,
R_H_LINE_TO, 0.43f,
R_LINE_TO, 0.14f, -0.44f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kQwacStatusRepList, kQwacStatusIcon, {kQwacStatusPath})
VECTOR_ICON_REP_TEMPLATE(kRadioButtonCheckedPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 14,
R_CUBIC_TO, 1.11, 0, 2.05, -0.39, 2.83, -1.17,
ARC_TO, 3.87, 3.87, 0, 0, 0, 14, 10,
R_CUBIC_TO, 0, -1.11, -0.39, -2.05, -1.17, -2.83,
ARC_TO, 3.87, 3.87, 0, 0, 0, 10, 6,
R_CUBIC_TO, -1.11, 0, -2.05, 0.39, -2.83, 1.17,
ARC_TO, 3.87, 3.87, 0, 0, 0, 6, 10,
R_CUBIC_TO, 0, 1.11, 0.39, 2.05, 1.17, 2.83,
ARC_TO, 3.87, 3.87, 0, 0, 0, 10, 14,
CLOSE,
R_MOVE_TO, 0, 4.17,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -3.18, -0.64,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, -4.36, -4.36,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -0.64, -3.18,
R_CUBIC_TO, 0, -1.13, 0.21, -2.19, 0.64, -3.18,
ARC_TO, 8.22, 8.22, 0, 0, 1, 6.82, 2.47,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, 3.18, -0.64,
R_CUBIC_TO, 1.13, 0, 2.19, 0.21, 3.18, 0.64,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, 2.59, 1.75,
R_ARC_TO, 8.2, 8.2, 0, 0, 1, 1.75, 2.6,
R_CUBIC_TO, 0.43, 0.99, 0.64, 2.05, 0.64, 3.18,
R_CUBIC_TO, 0, 1.13, -0.21, 2.19, -0.64, 3.18,
R_ARC_TO, 8.22, 8.22, 0, 0, 1, -4.35, 4.36,
R_ARC_TO, 7.94, 7.94, 0, 0, 1, -3.18, 0.64,
CLOSE,
MOVE_TO, 10, 16.44,
R_CUBIC_TO, 1.79, 0, 3.31, -0.62, 4.56, -1.88,
R_CUBIC_TO, 1.25, -1.25, 1.88, -2.77, 1.88, -4.56,
R_CUBIC_TO, 0, -1.79, -0.62, -3.31, -1.88, -4.56,
CUBIC_TO, 13.31, 4.18, 11.79, 3.56, 10, 3.56,
R_CUBIC_TO, -1.79, 0, -3.31, 0.63, -4.56, 1.88,
CUBIC_TO, 4.18, 6.69, 3.56, 8.21, 3.56, 10,
R_CUBIC_TO, 0, 1.79, 0.63, 3.31, 1.88, 4.56,
R_CUBIC_TO, 1.25, 1.25, 2.77, 1.88, 4.56, 1.88,
CLOSE,
MOVE_TO, 10, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRadioButtonCheckedRepList, kRadioButtonCheckedIcon, {kRadioButtonCheckedPath})
VECTOR_ICON_REP_TEMPLATE(kReceiptLongPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 6, 22,
R_ARC_TO, 2.9, 2.9, 0, 0, 1, -2.12, -0.87,
ARC_TO, 2.9, 2.9, 0, 0, 1, 3, 19,
R_V_LINE_TO, -3,
R_H_LINE_TO, 3,
V_LINE_TO, 2,
R_LINE_TO, 1.5, 1.5,
LINE_TO, 9, 2,
R_LINE_TO, 1.5, 1.5,
LINE_TO, 12, 2,
R_LINE_TO, 1.5, 1.5,
LINE_TO, 15, 2,
R_LINE_TO, 1.5, 1.5,
LINE_TO, 18, 2,
R_LINE_TO, 1.5, 1.5,
LINE_TO, 21, 2,
R_V_LINE_TO, 17,
R_CUBIC_TO, 0, 0.83, -0.29, 1.54, -0.87, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 1, 18, 22,
CLOSE,
R_MOVE_TO, 12, -2,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 19, 19,
V_LINE_TO, 5,
H_LINE_TO, 8,
R_V_LINE_TO, 11,
R_H_LINE_TO, 9,
R_V_LINE_TO, 3,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
MOVE_TO, 9, 9,
V_LINE_TO, 7,
R_H_LINE_TO, 6,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 3,
R_V_LINE_TO, -2,
R_H_LINE_TO, 6,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 8, -3,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 8,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 17, 7,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 17, 9,
CLOSE,
R_MOVE_TO, 0, 3,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 11,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 17, 10,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 17, 12,
CLOSE,
MOVE_TO, 6, 20,
R_H_LINE_TO, 9,
R_V_LINE_TO, -2,
H_LINE_TO, 5,
R_V_LINE_TO, 1,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, -1, 0,
R_V_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReceiptLongRepList, kReceiptLongIcon, {kReceiptLongPath})
VECTOR_ICON_REP_TEMPLATE(kReloadPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 25.1, 20.15,
LINE_TO, 25.08, 20.14,
CUBIC_TO, 23.51, 23.59, 20.04, 26, 16, 26,
CUBIC_TO, 10.48, 26, 6, 21.52, 6, 16,
CUBIC_TO, 6, 10.48, 10.48, 6, 16, 6,
CUBIC_TO, 19.02, 6, 21.72, 7.34, 23.55, 9.45,
LINE_TO, 23.55, 9.45,
LINE_TO, 19, 14,
LINE_TO, 25.8, 14,
LINE_TO, 28.83, 14,
LINE_TO, 30, 14,
LINE_TO, 30, 3,
LINE_TO, 25.67, 7.33,
CUBIC_TO, 23.3, 4.67, 19.85, 3, 16, 3,
CUBIC_TO, 8.82, 3, 3, 8.82, 3, 16,
CUBIC_TO, 3, 23.18, 8.82, 29, 16, 29,
CUBIC_TO, 21.27, 29, 25.8, 25.86, 27.84, 21.34,
CUBIC_TO, 27.96, 21.13, 28.03, 20.88, 28.03, 20.61,
CUBIC_TO, 28.03, 19.78, 27.36, 19.11, 26.53, 19.11,
CUBIC_TO, 25.87, 19.11, 25.3, 19.55, 25.1, 20.15,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kReload16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 15, 1,
LINE_TO, 15, 7,
LINE_TO, 9, 7,
LINE_TO, 11.62, 4.37,
CUBIC_TO, 10.67, 3.43, 9.44, 3, 8, 3,
CUBIC_TO, 5.09, 3, 3, 5.1, 3, 8,
CUBIC_TO, 3, 10.9, 5.09, 13, 8, 13,
CUBIC_TO, 10.3, 13, 12.08, 11.81, 12.75, 9.83,
LINE_TO, 12.77, 9.79,
CUBIC_TO, 12.93, 9.44, 13.47, 9.18, 13.76, 9.18,
CUBIC_TO, 14.15, 9.18, 14.79, 9.41, 14.79, 10.01,
CUBIC_TO, 14.79, 10.14, 14.71, 10.46, 14.66, 10.57,
CUBIC_TO, 13.66, 13.13, 10.98, 15, 8.03, 15,
CUBIC_TO, 4.15, 15, 1, 11.87, 1, 8,
CUBIC_TO, 1, 4.13, 4.15, 1, 8.03, 1,
CUBIC_TO, 9.96, 1, 11.7, 1.77, 12.97, 3.03,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReloadRepList, kReloadIcon, {kReloadPath}, {kReload16Path})
VECTOR_ICON_REP_TEMPLATE(kReloadChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 16,
R_CUBIC_TO, -1.67, 0, -3.08, -0.58, -4.25, -1.75,
CUBIC_TO, 4.58, 13.08, 4, 11.67, 4, 10,
R_CUBIC_TO, 0, -1.67, 0.58, -3.08, 1.75, -4.25,
CUBIC_TO, 6.92, 4.58, 8.33, 4, 10, 4,
R_CUBIC_TO, 0.9, 0, 1.74, 0.19, 2.51, 0.56,
R_CUBIC_TO, 0.77, 0.38, 1.43, 0.88, 1.99, 1.5,
V_LINE_TO, 4,
H_LINE_TO, 16,
R_V_LINE_TO, 5,
R_H_LINE_TO, -5,
V_LINE_TO, 7.5,
R_H_LINE_TO, 2.73,
R_ARC_TO, 4.44, 4.44, 0, 0, 0, -1.58, -1.46,
ARC_TO, 4.33, 4.33, 0, 0, 0, 10, 5.5,
R_CUBIC_TO, -1.25, 0, -2.31, 0.44, -3.19, 1.31,
CUBIC_TO_SHORTHAND, 5.5, 8.75, 5.5, 10,
R_CUBIC_TO, 0, 1.25, 0.44, 2.31, 1.31, 3.19,
CUBIC_TO, 7.69, 14.06, 8.75, 14.5, 10, 14.5,
R_CUBIC_TO, 1.17, 0, 2.17, -0.39, 3, -1.16,
R_ARC_TO, 4.43, 4.43, 0, 0, 0, 1.44, -2.84,
R_H_LINE_TO, 1.54,
R_CUBIC_TO, -0.12, 1.56, -0.76, 2.86, -1.9, 3.92,
CUBIC_TO, 12.95, 15.47, 11.58, 16, 10, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReloadChromeRefreshRepList, kReloadChromeRefreshIcon, {kReloadChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kReplayPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 5,
V_LINE_TO, 1,
LINE_TO, 7, 6,
R_LINE_TO, 5, 5,
V_LINE_TO, 7,
R_CUBIC_TO, 3.31, 0, 6, 2.69, 6, 6,
R_CUBIC_TO, 0, 3.31, -2.69, 6, -6, 6,
R_CUBIC_TO, -3.31, 0, -6, -2.69, -6, -6,
H_LINE_TO, 4,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 4.42, 0, 8, -3.58, 8, -8,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReplayRepList, kReplayIcon, {kReplayPath})
VECTOR_ICON_REP_TEMPLATE(kReplay10Path, CANVAS_DIMENSIONS, 960,
MOVE_TO, 480, 880,
R_QUADRATIC_TO, -75, 0, -140.5, -28.5,
R_QUADRATIC_TO, -65.5, -28.5, -114, -77,
R_QUADRATIC_TO, -48.5, -48.5, -77, -114,
QUADRATIC_TO_SHORTHAND, 120, 520,
R_H_LINE_TO, 80,
R_QUADRATIC_TO, 0, 117, 81.5, 198.5,
QUADRATIC_TO_SHORTHAND, 480, 800,
R_QUADRATIC_TO, 117, 0, 198.5, -81.5,
QUADRATIC_TO_SHORTHAND, 760, 520,
R_QUADRATIC_TO, 0, -117, -81.5, -198.5,
QUADRATIC_TO_SHORTHAND, 480, 240,
R_H_LINE_TO, -6,
R_LINE_TO, 62, 62,
R_LINE_TO, -56, 58,
R_LINE_TO, -160, -160,
R_LINE_TO, 160, -160,
R_LINE_TO, 56, 58,
R_LINE_TO, -62, 62,
R_H_LINE_TO, 6,
R_QUADRATIC_TO, 75, 0, 140.5, 28.5,
R_QUADRATIC_TO, 65.5, 28.5, 114, 77,
R_QUADRATIC_TO, 48.5, 48.5, 77, 114,
QUADRATIC_TO_SHORTHAND, 840, 520,
R_QUADRATIC_TO, 0, 75, -28.5, 140.5,
R_QUADRATIC_TO, -28.5, 65.5, -77, 114,
R_QUADRATIC_TO, -48.5, 48.5, -114, 77,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE,
MOVE_TO, 360, 640,
R_V_LINE_TO, -180,
R_H_LINE_TO, -60,
R_V_LINE_TO, -60,
R_H_LINE_TO, 120,
R_V_LINE_TO, 240,
R_H_LINE_TO, -60,
CLOSE,
R_MOVE_TO, 140, 0,
R_QUADRATIC_TO, -17, 0, -28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 460, 600,
R_V_LINE_TO, -160,
R_QUADRATIC_TO, 0, -17, 11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 500, 400,
R_H_LINE_TO, 80,
R_QUADRATIC_TO, 17, 0, 28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 620, 440,
R_V_LINE_TO, 160,
R_QUADRATIC_TO, 0, 17, -11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 580, 640,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 20, -60,
R_H_LINE_TO, 40,
R_V_LINE_TO, -120,
R_H_LINE_TO, -40,
R_V_LINE_TO, 120,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReplay10RepList, kReplay10Icon, {kReplay10Path})
VECTOR_ICON_REP_TEMPLATE(kRouterPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5f, 17,
R_CUBIC_TO, -0.41f, 0, -0.77f, -0.15f, -1.06f, -0.44f,
ARC_TO, 1.45f, 1.45f, 0, 0, 1, 3, 15.5f,
R_V_LINE_TO, -3,
R_CUBIC_TO, 0, -0.41f, 0.15f, -0.77f, 0.44f, -1.06f,
ARC_TO, 1.44f, 1.44f, 0, 0, 1, 4.5f, 11,
R_H_LINE_TO, 8,
V_LINE_TO, 8,
H_LINE_TO, 14,
R_V_LINE_TO, 3,
R_H_LINE_TO, 1.5f,
R_CUBIC_TO, 0.43f, 0, 0.79f, 0.14f, 1.09f, 0.44f,
R_CUBIC_TO, 0.3f, 0.29f, 0.44f, 0.64f, 0.41f, 1.06f,
R_V_LINE_TO, 3,
R_ARC_TO, 1.64f, 1.64f, 0, 0, 1, -0.47f, 1.05f,
R_CUBIC_TO, -0.28f, 0.3f, -0.63f, 0.45f, -1.03f, 0.45f,
CLOSE,
R_MOVE_TO, 0, -1.5f,
R_H_LINE_TO, 11,
R_V_LINE_TO, -3,
R_H_LINE_TO, -11,
CLOSE,
R_MOVE_TO, 1.75f, -0.75f,
R_CUBIC_TO, 0.21f, 0, 0.39f, -0.07f, 0.54f, -0.21f,
ARC_TO, 0.72f, 0.72f, 0, 0, 0, 7, 14,
R_CUBIC_TO, 0, -0.21f, -0.07f, -0.39f, -0.21f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.53f, -0.22f,
R_CUBIC_TO, -0.21f, 0, -0.39f, 0.07f, -0.53f, 0.22f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, 0.07f, 0.39f, 0.22f, 0.54f,
R_CUBIC_TO, 0.14f, 0.14f, 0.32f, 0.22f, 0.53f, 0.22f,
CLOSE,
R_MOVE_TO, 2.75f, 0,
R_CUBIC_TO, 0.21f, 0, 0.39f, -0.07f, 0.54f, -0.21f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, 0.22f, -0.53f,
R_CUBIC_TO, 0, -0.21f, -0.07f, -0.39f, -0.21f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.53f, -0.22f,
R_CUBIC_TO, -0.21f, 0, -0.39f, 0.07f, -0.53f, 0.22f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, 0.07f, 0.39f, 0.22f, 0.54f,
R_CUBIC_TO, 0.14f, 0.14f, 0.32f, 0.22f, 0.53f, 0.22f,
CLOSE,
R_MOVE_TO, 2.75f, 0,
R_CUBIC_TO, 0.21f, 0, 0.39f, -0.07f, 0.54f, -0.21f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, 0.22f, -0.53f,
R_CUBIC_TO, 0, -0.21f, -0.07f, -0.39f, -0.21f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.53f, -0.22f,
R_CUBIC_TO, -0.21f, 0, -0.39f, 0.07f, -0.53f, 0.22f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 0, -0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, 0.07f, 0.39f, 0.22f, 0.54f,
R_CUBIC_TO, 0.14f, 0.14f, 0.32f, 0.22f, 0.53f, 0.22f,
CLOSE,
R_MOVE_TO, 0.36f, -7.89f,
R_LINE_TO, -1.06f, -1.06f,
R_CUBIC_TO, 0.29f, -0.28f, 0.63f, -0.48f, 1.02f, -0.61f,
R_ARC_TO, 3.87f, 3.87f, 0, 0, 1, 2.37f, 0,
R_CUBIC_TO, 0.39f, 0.13f, 0.73f, 0.33f, 1.02f, 0.61f,
R_LINE_TO, -1.06f, 1.06f,
R_ARC_TO, 1.04f, 1.04f, 0, 0, 0, -0.53f, -0.29f,
R_ARC_TO, 2.92f, 2.92f, 0, 0, 0, -0.61f, -0.06f,
R_CUBIC_TO, -0.21f, 0, -0.41f, 0.02f, -0.61f, 0.06f,
R_CUBIC_TO, -0.2f, 0.04f, -0.38f, 0.14f, -0.53f, 0.29f,
CLOSE,
MOVE_TO, 10, 4.75f,
LINE_TO, 8.92f, 3.67f,
R_ARC_TO, 5.05f, 5.05f, 0, 0, 1, 1.99f, -1.27f,
ARC_TO, 7.13f, 7.13f, 0, 0, 1, 13.25f, 2,
R_CUBIC_TO, 0.81f, 0, 1.59f, 0.13f, 2.34f, 0.4f,
R_ARC_TO, 5.05f, 5.05f, 0, 0, 1, 1.99f, 1.27f,
LINE_TO, 16.5f, 4.75f,
R_ARC_TO, 4.01f, 4.01f, 0, 0, 0, -1.49f, -0.95f,
R_ARC_TO, 5.25f, 5.25f, 0, 0, 0, -1.76f, -0.3f,
R_CUBIC_TO, -0.61f, 0, -1.2f, 0.1f, -1.76f, 0.3f,
ARC_TO, 4.01f, 4.01f, 0, 0, 0, 10, 4.75f,
CLOSE,
MOVE_TO, 4.5f, 15.5f,
R_V_LINE_TO, -3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRouterRepList, kRouterIcon, {kRouterPath})
VECTOR_ICON_REP_TEMPLATE(kRouterOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 12.11f, 6.86f,
R_LINE_TO, -1.06f, -1.06f,
R_CUBIC_TO, 0.29f, -0.28f, 0.63f, -0.48f, 1.02f, -0.61f,
R_ARC_TO, 3.87f, 3.87f, 0, 0, 1, 2.37f, 0,
R_CUBIC_TO, 0.39f, 0.13f, 0.73f, 0.33f, 1.02f, 0.61f,
R_LINE_TO, -1.06f, 1.06f,
R_ARC_TO, 1.04f, 1.04f, 0, 0, 0, -0.53f, -0.29f,
R_ARC_TO, 2.92f, 2.92f, 0, 0, 0, -0.61f, -0.06f,
R_CUBIC_TO, -0.21f, 0, -0.41f, 0.02f, -0.61f, 0.06f,
R_CUBIC_TO, -0.2f, 0.04f, -0.38f, 0.14f, -0.53f, 0.29f,
CLOSE,
MOVE_TO, 10, 4.75f,
LINE_TO, 8.92f, 3.67f,
R_ARC_TO, 5.05f, 5.05f, 0, 0, 1, 1.99f, -1.27f,
ARC_TO, 7.13f, 7.13f, 0, 0, 1, 13.25f, 2,
R_CUBIC_TO, 0.81f, 0, 1.59f, 0.13f, 2.34f, 0.4f,
R_ARC_TO, 5.05f, 5.05f, 0, 0, 1, 1.99f, 1.27f,
LINE_TO, 16.5f, 4.75f,
R_ARC_TO, 4.01f, 4.01f, 0, 0, 0, -1.49f, -0.95f,
R_ARC_TO, 5.25f, 5.25f, 0, 0, 0, -1.76f, -0.3f,
R_CUBIC_TO, -0.61f, 0, -1.2f, 0.1f, -1.76f, 0.3f,
ARC_TO, 4.01f, 4.01f, 0, 0, 0, 10, 4.75f,
CLOSE,
R_MOVE_TO, 7, 10.13f,
R_LINE_TO, -4.5f, -4.51f,
V_LINE_TO, 8,
H_LINE_TO, 14,
R_V_LINE_TO, 3,
R_H_LINE_TO, 1.5f,
R_CUBIC_TO, 0.43f, 0, 0.79f, 0.14f, 1.09f, 0.44f,
R_CUBIC_TO, 0.3f, 0.29f, 0.44f, 0.64f, 0.41f, 1.06f,
CLOSE,
MOVE_TO, 4.5f, 15.5f,
R_H_LINE_TO, 8.88f,
R_LINE_TO, -3, -3,
H_LINE_TO, 4.5f,
CLOSE,
MOVE_TO, 16, 18.13f,
LINE_TO, 14.88f, 17,
H_LINE_TO, 4.5f,
R_CUBIC_TO, -0.41f, 0, -0.77f, -0.15f, -1.06f, -0.44f,
ARC_TO, 1.45f, 1.45f, 0, 0, 1, 3, 15.5f,
R_V_LINE_TO, -3,
R_CUBIC_TO, 0, -0.41f, 0.15f, -0.77f, 0.44f, -1.06f,
ARC_TO, 1.44f, 1.44f, 0, 0, 1, 4.5f, 11,
R_H_LINE_TO, 4.38f,
R_LINE_TO, -7, -7,
R_LINE_TO, 1.06f, -1.06f,
R_LINE_TO, 14.12f, 14.13f,
CLOSE,
MOVE_TO, 6.25f, 14.75f,
R_CUBIC_TO, -0.21f, 0, -0.39f, -0.07f, -0.53f, -0.21f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.22f, -0.53f,
R_CUBIC_TO, 0, -0.21f, 0.07f, -0.39f, 0.22f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, 0.53f, -0.22f,
R_CUBIC_TO, 0.21f, 0, 0.39f, 0.07f, 0.54f, 0.22f,
R_CUBIC_TO, 0.14f, 0.14f, 0.22f, 0.32f, 0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, -0.07f, 0.39f, -0.21f, 0.54f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.53f, 0.22f,
CLOSE,
R_MOVE_TO, 2.75f, 0,
R_CUBIC_TO, -0.21f, 0, -0.39f, -0.07f, -0.53f, -0.21f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.22f, -0.53f,
R_CUBIC_TO, 0, -0.21f, 0.07f, -0.39f, 0.22f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, 0.53f, -0.22f,
R_CUBIC_TO, 0.21f, 0, 0.39f, 0.07f, 0.54f, 0.22f,
R_CUBIC_TO, 0.14f, 0.14f, 0.22f, 0.32f, 0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, -0.07f, 0.39f, -0.21f, 0.54f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.53f, 0.22f,
CLOSE,
R_MOVE_TO, 2.75f, 0,
R_CUBIC_TO, -0.21f, 0, -0.39f, -0.07f, -0.53f, -0.21f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.22f, -0.53f,
R_CUBIC_TO, 0, -0.21f, 0.07f, -0.39f, 0.22f, -0.53f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, 0.53f, -0.22f,
R_CUBIC_TO, 0.21f, 0, 0.39f, 0.07f, 0.54f, 0.22f,
R_CUBIC_TO, 0.14f, 0.14f, 0.22f, 0.32f, 0.22f, 0.53f,
R_CUBIC_TO, 0, 0.21f, -0.07f, 0.39f, -0.21f, 0.54f,
R_ARC_TO, 0.72f, 0.72f, 0, 0, 1, -0.53f, 0.22f,
CLOSE,
MOVE_TO, 4.5f, 15.5f,
R_V_LINE_TO, -3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRouterOffRepList, kRouterOffIcon, {kRouterOffPath})
VECTOR_ICON_REP_TEMPLATE(kSaveCloudPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5.02, 16.17,
CUBIC_TO, 3.85, 16.17, 2.87, 15.76, 2.06, 14.96,
CUBIC_TO, 1.26, 14.14, 0.85, 13.15, 0.85, 12,
CUBIC_TO, 0.85, 10.9, 1.21, 9.96, 1.92, 9.17,
CUBIC_TO, 2.64, 8.36, 3.54, 7.92, 4.63, 7.85,
CUBIC_TO, 4.97, 6.66, 5.64, 5.69, 6.63, 4.96,
CUBIC_TO, 7.63, 4.21, 8.75, 3.83, 10, 3.83,
CUBIC_TO, 11.5, 3.83, 12.81, 4.31, 13.92, 5.27,
CUBIC_TO, 15.03, 6.22, 15.6, 7.41, 15.65, 8.85,
CUBIC_TO, 16.63, 8.9, 17.46, 9.27, 18.13, 9.98,
CUBIC_TO, 18.81, 10.67, 19.15, 11.51, 19.15, 12.5,
CUBIC_TO, 19.15, 13.51, 18.78, 14.38, 18.06, 15.1,
CUBIC_TO, 17.35, 15.81, 16.49, 16.17, 15.48, 16.17,
H_LINE_TO, 10.94,
CUBIC_TO, 10.47, 16.17, 10.06, 16, 9.71, 15.67,
CUBIC_TO, 9.38, 15.32, 9.21, 14.91, 9.21, 14.44,
V_LINE_TO, 11.13,
LINE_TO, 7.98, 12.35,
LINE_TO, 6.88, 11.23,
LINE_TO, 10, 8.1,
LINE_TO, 13.13, 11.23,
LINE_TO, 12.02, 12.35,
LINE_TO, 10.79, 11.13,
V_LINE_TO, 14.44,
H_LINE_TO, 15.48,
CUBIC_TO, 16.02, 14.44, 16.48, 14.25, 16.85, 13.88,
CUBIC_TO, 17.23, 13.5, 17.42, 13.04, 17.42, 12.5,
CUBIC_TO, 17.42, 11.96, 17.23, 11.5, 16.85, 11.13,
CUBIC_TO, 16.48, 10.75, 16.02, 10.56, 15.48, 10.56,
H_LINE_TO, 13.92,
V_LINE_TO, 8.98,
CUBIC_TO, 13.92, 7.99, 13.53, 7.18, 12.75, 6.54,
CUBIC_TO, 11.97, 5.89, 11.05, 5.56, 9.98, 5.56,
CUBIC_TO, 8.92, 5.56, 8.03, 5.96, 7.29, 6.75,
CUBIC_TO, 6.57, 7.53, 6.13, 8.47, 5.98, 9.56,
H_LINE_TO, 5.02,
CUBIC_TO, 4.34, 9.56, 3.76, 9.81, 3.29, 10.29,
CUBIC_TO, 2.82, 10.76, 2.58, 11.33, 2.58, 12,
CUBIC_TO, 2.58, 12.68, 2.82, 13.26, 3.29, 13.73,
CUBIC_TO, 3.76, 14.2, 4.34, 14.44, 5.02, 14.44,
H_LINE_TO, 7.71,
V_LINE_TO, 16.17,
H_LINE_TO, 5.02,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kSaveCloudRepList, kSaveCloudIcon, {kSaveCloudPath})
VECTOR_ICON_REP_TEMPLATE(kSciencePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 21,
R_CUBIC_TO, -0.85, 0, -1.45, -0.38, -1.81, -1.14,
R_CUBIC_TO, -0.36, -0.76, -0.27, -1.46, 0.26, -2.11,
LINE_TO, 9, 11,
V_LINE_TO, 5,
H_LINE_TO, 8,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 7, 4,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 8, 3,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 5,
R_H_LINE_TO, -1,
R_V_LINE_TO, 6,
R_LINE_TO, 5.55, 6.75,
R_CUBIC_TO, 0.53, 0.65, 0.62, 1.36, 0.26, 2.11,
CUBIC_TO, 20.45, 20.62, 19.85, 21, 19, 21,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 14,
R_LINE_TO, -6, -7.3,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 6.7,
CLOSE,
R_MOVE_TO, 7, -7,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kScience20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.64, 0, -1.1, -0.28, -1.37, -0.84,
R_CUBIC_TO, -0.28, -0.56, -0.21, -1.09, 0.19, -1.58,
LINE_TO, 7.5, 9.5,
R_V_LINE_TO, -5,
R_H_LINE_TO, -0.75,
R_CUBIC_TO, -0.21, 0, -0.39, -0.07, -0.53, -0.21,
ARC_TO, 0.72, 0.72, 0, 0, 1, 6, 3.75,
R_CUBIC_TO, 0, -0.21, 0.07, -0.39, 0.22, -0.53,
ARC_TO, 0.73, 0.73, 0, 0, 1, 6.75, 3,
R_H_LINE_TO, 6.5,
R_CUBIC_TO, 0.21, 0, 0.39, 0.07, 0.54, 0.22,
R_CUBIC_TO, 0.14, 0.14, 0.22, 0.32, 0.22, 0.53,
R_CUBIC_TO, 0, 0.21, -0.07, 0.39, -0.21, 0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.53, 0.22,
R_H_LINE_TO, -0.75,
R_V_LINE_TO, 5,
R_LINE_TO, 4.19, 5.08,
R_CUBIC_TO, 0.39, 0.49, 0.45, 1.01, 0.17, 1.57,
R_CUBIC_TO, -0.28, 0.56, -0.73, 0.84, -1.35, 0.84,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
LINE_TO, 11, 10,
V_LINE_TO, 4.5,
H_LINE_TO, 9,
V_LINE_TO, 10,
CLOSE,
R_MOVE_TO, 5.52, -5.5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kScience16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.6, 13.73,
R_CUBIC_TO, -0.57, 0, -0.98, -0.25, -1.22, -0.75,
R_CUBIC_TO, -0.25, -0.5, -0.19, -0.97, 0.17, -1.41,
R_LINE_TO, 3.32, -4.03,
V_LINE_TO, 3.69,
R_H_LINE_TO, -0.47,
R_ARC_TO, 0.68, 0.68, 0, 0, 1, -0.49, -0.2,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, -0.2, -0.49,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, 0.2, -0.49,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.49, -0.2,
R_H_LINE_TO, 5.23,
R_CUBIC_TO, 0.19, 0, 0.36, 0.07, 0.49, 0.2,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.2, 0.49,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, -0.2, 0.49,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, -0.49, 0.2,
R_H_LINE_TO, -0.48,
R_V_LINE_TO, 3.86,
R_LINE_TO, 3.32, 4.03,
R_CUBIC_TO, 0.35, 0.43, 0.4, 0.9, 0.15, 1.4,
R_CUBIC_TO, -0.25, 0.5, -0.65, 0.75, -1.21, 0.75,
CLOSE,
R_MOVE_TO, 0.1, -1.38,
R_H_LINE_TO, 8.59,
LINE_TO, 8.75, 8.02,
V_LINE_TO, 3.69,
H_LINE_TO, 7.25,
V_LINE_TO, 8.02,
CLOSE,
MOVE_TO, 8.02, 8.02,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScienceRepList, kScienceIcon, {kSciencePath}, {kScience20Path}, {kScience16Path})
VECTOR_ICON_REP_TEMPLATE(kScreenRecordPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 3.95f, 17.95f,
CUBIC_TO, 3.33f, 17.12f, 2.86f, 16.2f, 2.51f, 15.19f,
CUBIC_TO, 2.17f, 14.18f, 2, 13.12f, 2, 12,
CUBIC_TO, 2, 10.88f, 2.17f, 9.82f, 2.5f, 8.82f,
CUBIC_TO, 2.83f, 7.82f, 3.31f, 6.91f, 3.93f, 6.07f,
LINE_TO, 5.38f, 7.5f,
CUBIC_TO, 4.94f, 8.13f, 4.61f, 8.83f, 4.36f, 9.59f,
CUBIC_TO, 4.12f, 10.35f, 4, 11.15f, 4, 12,
CUBIC_TO, 4, 12.85f, 4.12f, 13.66f, 4.36f, 14.43f,
CUBIC_TO, 4.61f, 15.19f, 4.94f, 15.89f, 5.38f, 16.52f,
CLOSE,
MOVE_TO, 12, 22,
CUBIC_TO, 10.88f, 22, 9.82f, 21.83f, 8.82f, 21.5f,
CUBIC_TO, 7.82f, 21.17f, 6.91f, 20.69f, 6.07f, 20.07f,
LINE_TO, 7.5f, 18.63f,
CUBIC_TO, 8.13f, 19.06f, 8.83f, 19.39f, 9.59f, 19.64f,
CUBIC_TO, 10.35f, 19.88f, 11.15f, 20, 12, 20,
CUBIC_TO, 12.85f, 20, 13.65f, 19.88f, 14.41f, 19.64f,
CUBIC_TO, 15.17f, 19.39f, 15.87f, 19.06f, 16.5f, 18.63f,
LINE_TO, 17.93f, 20.07f,
CUBIC_TO, 17.09f, 20.69f, 16.18f, 21.17f, 15.18f, 21.5f,
CUBIC_TO, 14.18f, 21.83f, 13.12f, 22, 12, 22,
CLOSE,
MOVE_TO, 20.05f, 17.95f,
LINE_TO, 18.63f, 16.52f,
CUBIC_TO, 19.06f, 15.89f, 19.39f, 15.19f, 19.64f, 14.43f,
CUBIC_TO, 19.88f, 13.66f, 20, 12.85f, 20, 12,
CUBIC_TO, 20, 11.15f, 19.88f, 10.35f, 19.64f, 9.59f,
CUBIC_TO, 19.39f, 8.83f, 19.06f, 8.13f, 18.63f, 7.5f,
LINE_TO, 20.07f, 6.07f,
CUBIC_TO, 20.69f, 6.91f, 21.17f, 7.82f, 21.5f, 8.82f,
CUBIC_TO, 21.83f, 9.82f, 22, 10.88f, 22, 12,
CUBIC_TO, 22, 13.12f, 21.83f, 14.18f, 21.49f, 15.19f,
CUBIC_TO, 21.14f, 16.2f, 20.67f, 17.12f, 20.05f, 17.95f,
CLOSE,
MOVE_TO, 7.48f, 5.38f,
LINE_TO, 6.05f, 3.95f,
CUBIC_TO, 6.88f, 3.33f, 7.8f, 2.86f, 8.81f, 2.51f,
CUBIC_TO, 9.82f, 2.17f, 10.88f, 2, 12, 2,
CUBIC_TO, 13.13f, 2, 14.2f, 2.17f, 15.2f, 2.51f,
CUBIC_TO, 16.2f, 2.86f, 17.12f, 3.33f, 17.95f, 3.95f,
LINE_TO, 16.52f, 5.38f,
CUBIC_TO, 15.89f, 4.94f, 15.19f, 4.61f, 14.43f, 4.36f,
CUBIC_TO, 13.66f, 4.12f, 12.85f, 4, 12, 4,
CUBIC_TO, 11.15f, 4, 10.34f, 4.12f, 9.57f, 4.36f,
CUBIC_TO, 8.81f, 4.61f, 8.11f, 4.94f, 7.48f, 5.38f,
CLOSE,
MOVE_TO, 12, 17,
CUBIC_TO, 10.62f, 17, 9.44f, 16.51f, 8.46f, 15.54f,
CUBIC_TO, 7.49f, 14.56f, 7, 13.38f, 7, 12,
CUBIC_TO, 7, 10.62f, 7.49f, 9.44f, 8.46f, 8.46f,
CUBIC_TO, 9.44f, 7.49f, 10.62f, 7, 12, 7,
CUBIC_TO, 13.38f, 7, 14.56f, 7.49f, 15.54f, 8.46f,
CUBIC_TO, 16.51f, 9.44f, 17, 10.62f, 17, 12,
CUBIC_TO, 17, 13.38f, 16.51f, 14.56f, 15.54f, 15.54f,
CUBIC_TO, 14.56f, 16.51f, 13.38f, 17, 12, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScreenRecordRepList, kScreenRecordIcon, {kScreenRecordPath})
VECTOR_ICON_REP_TEMPLATE(kScreenSharePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.57, 9.23,
R_H_LINE_TO, 1.27,
V_LINE_TO, 8.2,
R_ARC_TO, 0.75, 0.75, 0, 0, 1, 0.77, -0.77,
H_LINE_TO, 8.77,
V_LINE_TO, 8.87,
R_LINE_TO, 2.07, -2.07,
LINE_TO, 8.77, 4.73,
R_V_LINE_TO, 1.44,
H_LINE_TO, 7.2,
R_CUBIC_TO, -0.45, 0, -0.84, 0.16, -1.16, 0.48,
R_CUBIC_TO, -0.32, 0.32, -0.48, 0.7, -0.48, 1.16,
CLOSE,
R_MOVE_TO, -2.72, 2.5,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 6.7,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 10.3,
V_LINE_TO, 3.65,
H_LINE_TO, 2.85,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 3.65,
CLOSE,
MOVE_TO, 0.68, 13.8,
R_V_LINE_TO, -1.26,
R_H_LINE_TO, 14.65,
R_V_LINE_TO, 1.26,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScreenShareRepList, kScreenShareIcon, {kScreenSharePath})
VECTOR_ICON_REP_TEMPLATE(kScreenShareOldPath, MOVE_TO, 40, 36,
R_CUBIC_TO, 2.2, 0, 3.98, -1.8, 3.98, -4,
LINE_TO, 44, 12,
R_CUBIC_TO, 0, -2.22, -1.8, -4, -4, -4,
H_LINE_TO, 8,
R_CUBIC_TO, -2.22, 0, -4, 1.78, -4, 4,
R_V_LINE_TO, 20,
R_CUBIC_TO, 0, 2.2, 1.78, 4, 4, 4,
H_LINE_TO, 0,
R_V_LINE_TO, 4,
R_H_LINE_TO, 48,
R_V_LINE_TO, -4,
R_H_LINE_TO, -8,
CLOSE,
R_MOVE_TO, -14, -7.06,
R_V_LINE_TO, -4.38,
R_CUBIC_TO, -5.56, 0, -9.22, 1.7, -12, 5.44,
R_CUBIC_TO, 1.12, -5.34, 4.22, -10.66, 12, -11.74,
V_LINE_TO, 14,
R_LINE_TO, 8, 7.46,
R_LINE_TO, -8, 7.48,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScreenShareOldRepList, kScreenShareOldIcon, {kScreenShareOldPath})
VECTOR_ICON_REP_TEMPLATE(kSearchPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 20.29, 19.45,
LINE_TO, 19.93, 19.09,
CUBIC_TO, 21.23, 17.59, 22.13, 15.52, 22.13, 12.96,
CUBIC_TO, 22.13, 8.23, 17.85, 4, 13.07, 4,
CUBIC_TO, 8.28, 4, 4, 8.23, 4, 12.96,
CUBIC_TO, 4, 17.69, 9.18, 21.92, 13.26, 21.92,
CUBIC_TO, 15.66, 21.92, 17.51, 21.26, 18.98, 20.02,
LINE_TO, 19.35, 20.38,
LINE_TO, 19.35, 21.42,
LINE_TO, 26.01, 28,
LINE_TO, 28, 26.04,
LINE_TO, 21.35, 19.45,
LINE_TO, 20.29, 19.45,
CLOSE,
MOVE_TO, 13.07, 19.36,
CUBIC_TO, 9.49, 19.36, 6.59, 16.5, 6.59, 12.96,
CUBIC_TO, 6.59, 9.43, 9.49, 6.56, 13.07, 6.56,
CUBIC_TO, 16.64, 6.56, 19.54, 9.43, 19.54, 12.96,
CUBIC_TO, 19.54, 16.5, 16.64, 19.36, 13.07, 19.36,
LINE_TO, 13.07, 19.36,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSearchRepList, kSearchIcon, {kSearchPath})
VECTOR_ICON_REP_TEMPLATE(kSearchChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 15.94, 17,
R_LINE_TO, -4.98, -4.98,
R_ARC_TO, 4.99, 4.99, 0, 0, 1, -1.37, 0.72,
ARC_TO, 4.71, 4.71, 0, 0, 1, 8, 13,
R_CUBIC_TO, -1.39, 0, -2.57, -0.48, -3.54, -1.46,
CUBIC_TO, 3.48, 10.57, 3, 9.39, 3, 8,
R_CUBIC_TO, 0, -1.39, 0.48, -2.57, 1.46, -3.54,
CUBIC_TO, 5.43, 3.48, 6.61, 3, 8, 3,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 12.52, 5.43, 13, 6.61, 13, 8,
R_CUBIC_TO, 0, 0.56, -0.09, 1.09, -0.26, 1.59,
R_CUBIC_TO, -0.17, 0.5, -0.41, 0.96, -0.72, 1.37,
R_LINE_TO, 4.98, 4.98,
CLOSE,
MOVE_TO, 8, 11.5,
R_CUBIC_TO, 0.97, 0, 1.8, -0.34, 2.48, -1.02,
R_CUBIC_TO, 0.68, -0.68, 1.02, -1.51, 1.02, -2.48,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
CUBIC_TO, 9.8, 4.84, 8.97, 4.5, 8, 4.5,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 4.84, 6.2, 4.5, 7.03, 4.5, 8,
R_CUBIC_TO, 0, 0.97, 0.34, 1.8, 1.02, 2.48,
R_CUBIC_TO, 0.68, 0.68, 1.51, 1.02, 2.48, 1.02,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSearchChromeRefreshRepList, kSearchChromeRefreshIcon, {kSearchChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSelectWindowPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 21, 1,
H_LINE_TO, 8,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 6,
H_LINE_TO, 3,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 13,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
R_V_LINE_TO, -6,
R_H_LINE_TO, 3,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, -5, 20,
H_LINE_TO, 3,
R_V_LINE_TO, -8,
R_H_LINE_TO, 13,
R_V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 5, -8,
R_H_LINE_TO, -3,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
H_LINE_TO, 8,
V_LINE_TO, 5,
R_H_LINE_TO, 13,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSelectWindowRepList, kSelectWindowIcon, {kSelectWindowPath})
VECTOR_ICON_REP_TEMPLATE(kSelectWindowChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 8,
H_LINE_TO, 5,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 6.5, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 12,
H_LINE_TO, 15,
R_V_LINE_TO, 4.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 13.5, 18,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 10,
V_LINE_TO, 11,
R_H_LINE_TO, -10,
CLOSE,
R_MOVE_TO, 11.5, -6,
R_H_LINE_TO, 1.5,
V_LINE_TO, 5,
R_H_LINE_TO, -10,
R_V_LINE_TO, 3,
R_H_LINE_TO, 7,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSelectWindowChromeRefreshRepList, kSelectWindowChromeRefreshIcon, {kSelectWindowChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSelectWindowOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.73, 18.83,
LINE_TO, 8.9, 11,
H_LINE_TO, 3.5,
R_V_LINE_TO, 5.5,
R_H_LINE_TO, 10,
R_V_LINE_TO, -3,
R_LINE_TO, 1.5, 1.5,
R_V_LINE_TO, 1.51,
R_CUBIC_TO, 0, 0.41, -0.15, 0.76, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 13.5, 18,
R_H_LINE_TO, -10,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 9.5,
R_CUBIC_TO, 0, -0.43, 0.14, -0.79, 0.44, -1.09,
ARC_TO, 1.31, 1.31, 0, 0, 1, 3.5, 8,
H_LINE_TO, 5,
R_V_LINE_TO, -0.87,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 15, 12.88,
LINE_TO, 10.13, 8,
H_LINE_TO, 13.5,
R_CUBIC_TO, 0.43, 0, 0.79, 0.14, 1.07, 0.43,
R_CUBIC_TO, 0.28, 0.28, 0.43, 0.64, 0.43, 1.07,
R_V_LINE_TO, 1,
R_H_LINE_TO, 1.5,
V_LINE_TO, 5,
H_LINE_TO, 7.13,
R_LINE_TO, -2.02, -2.02,
R_CUBIC_TO, 0.1, -0.31, 0.27, -0.55, 0.53, -0.72,
CUBIC_TO, 5.9, 2.09, 6.18, 2, 6.5, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 12,
H_LINE_TO, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSelectWindowOffChromeRefreshRepList, kSelectWindowOffChromeRefreshIcon, {kSelectWindowOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSendPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 3, 3,
LINE_TO, 18, 10,
LINE_TO, 3, 17,
V_LINE_TO, 3,
CLOSE,
MOVE_TO, 4.5, 5.36,
LINE_TO, 14.45, 10,
LINE_TO, 4.5, 14.64,
V_LINE_TO, 12,
LINE_TO, 9, 10,
LINE_TO, 4.5, 8,
V_LINE_TO, 5.36,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSendRepList, kSendIcon, {kSendPath})
VECTOR_ICON_REP_TEMPLATE(kSensorsPath, CANVAS_DIMENSIONS, 18,
MOVE_TO, 9, 7.6,
CUBIC_TO, 8.2, 7.6, 7.6, 8.2, 7.6, 9,
R_CUBIC_TO, 0, 0.8, 0.6, 1.4, 1.4, 1.4,
R_CUBIC_TO, 0.8, 0, 1.4, -0.6, 1.4, -1.4,
CUBIC_TO_SHORTHAND, 9.8, 7.6, 9, 7.6,
CLOSE,
MOVE_TO, 6.7, 5.1,
CUBIC_TO, 5.4, 5.9, 4.5, 7.3, 4.5, 9,
R_CUBIC_TO, 0, 1.7, 0.9, 3.2, 2.2, 4,
R_LINE_TO, 0.7, -1.3,
CUBIC_TO, 6.6, 11.1, 6, 10.1, 6, 9,
R_CUBIC_TO, 0, -1.1, 0.6, -2.1, 1.5, -2.6,
LINE_TO, 6.7, 5.1,
CLOSE,
MOVE_TO, 13.5, 9,
R_CUBIC_TO, 0, -1.7, -0.9, -3.1, -2.2, -3.9,
R_LINE_TO, -0.8, 1.3,
CUBIC_TO, 11.4, 6.9, 12, 7.9, 12, 9,
R_CUBIC_TO, 0, 1.1, -0.6, 2.1, -1.5, 2.6,
R_LINE_TO, 0.8, 1.3,
CUBIC_TO, 12.6, 12.2, 13.5, 10.7, 13.5, 9,
CLOSE,
MOVE_TO, 5.2, 2.4,
CUBIC_TO, 3, 3.8, 1.5, 6.2, 1.5, 9,
R_CUBIC_TO, 0, 2.8, 1.5, 5.3, 3.7, 6.6,
LINE_TO, 6, 14.2,
R_CUBIC_TO, -1.8, -1.1, -3, -3, -3, -5.3,
R_CUBIC_TO, 0, -2.2, 1.2, -4.2, 3, -5.2,
LINE_TO, 5.2, 2.4,
CLOSE,
MOVE_TO, 12, 3.7,
R_CUBIC_TO, 1.8, 1.1, 3, 3, 3, 5.2,
R_CUBIC_TO, 0, 2.2, -1.2, 4.2, -3, 5.3,
R_LINE_TO, 0.8, 1.3,
R_CUBIC_TO, 2.2, -1.3, 3.8, -3.8, 3.8, -6.6,
R_CUBIC_TO, 0, -2.8, -1.5, -5.2, -3.7, -6.6,
LINE_TO, 12, 3.7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSensorsRepList, kSensorsIcon, {kSensorsPath})
VECTOR_ICON_REP_TEMPLATE(kSensorsChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.36, 15.65,
R_ARC_TO, 7.89, 7.89, 0, 0, 1, -1.73, -2.53,
ARC_TO, 7.72, 7.72, 0, 0, 1, 2, 10.01,
R_CUBIC_TO, 0, -1.12, 0.21, -2.16, 0.63, -3.12,
R_ARC_TO, 8.37, 8.37, 0, 0, 1, 1.71, -2.56,
R_LINE_TO, 1.06, 1.06,
R_ARC_TO, 6.81, 6.81, 0, 0, 0, -1.38, 2.08,
R_ARC_TO, 6.28, 6.28, 0, 0, 0, -0.51, 2.52,
R_ARC_TO, 6.33, 6.33, 0, 0, 0, 1.92, 4.59,
CLOSE,
R_MOVE_TO, 2.1, -2.1,
R_ARC_TO, 5.5, 5.5, 0, 0, 1, -1.06, -1.59,
ARC_TO, 4.85, 4.85, 0, 0, 1, 5, 10,
R_CUBIC_TO, 0, -0.7, 0.13, -1.36, 0.4, -1.96,
R_ARC_TO, 5.48, 5.48, 0, 0, 1, 1.06, -1.59,
LINE_TO, 7.52, 7.52,
R_ARC_TO, 3.59, 3.59, 0, 0, 0, -0.75, 1.12,
R_ARC_TO, 3.4, 3.4, 0, 0, 0, -0.27, 1.36,
R_CUBIC_TO, 0, 0.48, 0.09, 0.94, 0.27, 1.36,
R_CUBIC_TO, 0.18, 0.42, 0.43, 0.8, 0.75, 1.12,
CLOSE,
R_MOVE_TO, 3.54, -1.79,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -1.24, -0.52,
R_ARC_TO, 1.7, 1.7, 0, 0, 1, -0.51, -1.24,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.52, -1.23,
R_CUBIC_TO, 0.34, -0.34, 0.76, -0.51, 1.24, -0.51,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.23, 0.52,
R_CUBIC_TO, 0.34, 0.34, 0.51, 0.76, 0.51, 1.24,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.52, 1.23,
R_CUBIC_TO, -0.34, 0.34, -0.76, 0.51, -1.24, 0.51,
CLOSE,
R_MOVE_TO, 3.52, 1.77,
R_LINE_TO, -1.04, -1.04,
R_CUBIC_TO, 0.32, -0.32, 0.57, -0.69, 0.75, -1.12,
R_ARC_TO, 3.4, 3.4, 0, 0, 0, 0.27, -1.36,
R_CUBIC_TO, 0, -0.48, -0.09, -0.94, -0.27, -1.36,
R_ARC_TO, 3.57, 3.57, 0, 0, 0, -0.75, -1.12,
R_LINE_TO, 1.06, -1.06,
R_CUBIC_TO, 0.44, 0.46, 0.8, 0.99, 1.06, 1.59,
ARC_TO, 4.89, 4.89, 0, 0, 1, 15, 10.01,
R_ARC_TO, 4.83, 4.83, 0, 0, 1, -1.48, 3.51,
CLOSE,
R_MOVE_TO, 2.13, 2.13,
R_LINE_TO, -1.06, -1.06,
R_ARC_TO, 6.33, 6.33, 0, 0, 0, 1.41, -2.06,
R_CUBIC_TO, 0.34, -0.78, 0.51, -1.62, 0.51, -2.52,
R_CUBIC_TO, 0, -0.9, -0.17, -1.75, -0.51, -2.54,
R_ARC_TO, 6.84, 6.84, 0, 0, 0, -1.38, -2.07,
R_LINE_TO, 1.06, -1.06,
R_ARC_TO, 8.37, 8.37, 0, 0, 1, 1.71, 2.56,
R_ARC_TO, 7.76, 7.76, 0, 0, 1, 0.63, 3.12,
R_CUBIC_TO, 0, 1.11, -0.21, 2.14, -0.62, 3.11,
R_ARC_TO, 7.89, 7.89, 0, 0, 1, -1.73, 2.53,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSensorsChromeRefreshRepList, kSensorsChromeRefreshIcon, {kSensorsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSensorsOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 6.71, 8.83,
R_ARC_TO, 3.53, 3.53, 0, 0, 0, -0.16, 0.56,
R_CUBIC_TO, -0.04, 0.2, -0.05, 0.4, -0.05, 0.61,
R_CUBIC_TO, 0, 0.48, 0.09, 0.94, 0.27, 1.36,
R_CUBIC_TO, 0.18, 0.43, 0.43, 0.8, 0.75, 1.12,
R_LINE_TO, -1.04, 1.04,
ARC_TO, 4.86, 4.86, 0, 0, 1, 5, 10,
R_CUBIC_TO, 0, -0.42, 0.05, -0.82, 0.16, -1.2,
R_ARC_TO, 5.72, 5.72, 0, 0, 1, 0.43, -1.09,
LINE_TO, 4.48, 6.58,
R_CUBIC_TO, -0.31, 0.5, -0.55, 1.04, -0.72, 1.62,
ARC_TO, 6.12, 6.12, 0, 0, 0, 3.5, 10,
R_ARC_TO, 6.36, 6.36, 0, 0, 0, 1.92, 4.58,
R_LINE_TO, -1.06, 1.06,
R_ARC_TO, 7.89, 7.89, 0, 0, 1, -1.73, -2.53,
ARC_TO, 7.75, 7.75, 0, 0, 1, 2, 10,
R_ARC_TO, 7.92, 7.92, 0, 0, 1, 1.38, -4.5,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, 0.63, -3.62,
R_LINE_TO, -1.1, -1.08,
R_CUBIC_TO, 0.31, -0.5, 0.55, -1.04, 0.72, -1.62,
ARC_TO, 6.12, 6.12, 0, 0, 0, 16.5, 10,
R_ARC_TO, 6.36, 6.36, 0, 0, 0, -1.92, -4.58,
R_LINE_TO, 1.06, -1.06,
R_ARC_TO, 7.89, 7.89, 0, 0, 1, 1.73, 2.53,
ARC_TO, 7.75, 7.75, 0, 0, 1, 18, 10,
R_CUBIC_TO, 0, 0.83, -0.12, 1.63, -0.35, 2.4,
R_ARC_TO, 7.51, 7.51, 0, 0, 1, -1.02, 2.11,
CLOSE,
R_MOVE_TO, -2.19, -2.19,
R_LINE_TO, -1.14, -1.14,
R_CUBIC_TO, 0.07, -0.19, 0.12, -0.39, 0.16, -0.57,
R_CUBIC_TO, 0.04, -0.19, 0.05, -0.39, 0.05, -0.59,
R_CUBIC_TO, 0, -0.48, -0.09, -0.94, -0.27, -1.36,
R_ARC_TO, 3.6, 3.6, 0, 0, 0, -0.75, -1.12,
R_LINE_TO, 1.04, -1.04,
ARC_TO, 4.86, 4.86, 0, 0, 1, 15, 10,
R_CUBIC_TO, 0, 0.42, -0.05, 0.82, -0.14, 1.21,
R_CUBIC_TO, -0.09, 0.39, -0.23, 0.76, -0.42, 1.11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSensorsOffChromeRefreshRepList, kSensorsOffChromeRefreshIcon, {kSensorsOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSerialPortPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 22, 9,
V_LINE_TO, 7,
R_H_LINE_TO, -2,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 14,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
V_LINE_TO, 9,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, -4, 10,
H_LINE_TO, 4,
V_LINE_TO, 5,
R_H_LINE_TO, 14,
R_V_LINE_TO, 14,
CLOSE,
MOVE_TO, 6, 13,
R_H_LINE_TO, 5,
R_V_LINE_TO, 4,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 6, -6,
R_H_LINE_TO, 4,
R_V_LINE_TO, 3,
R_H_LINE_TO, -4,
CLOSE,
MOVE_TO, 6, 7,
R_H_LINE_TO, 5,
R_V_LINE_TO, 5,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 6, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 6,
R_H_LINE_TO, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSerialPortRepList, kSerialPortIcon, {kSerialPortPath})
VECTOR_ICON_REP_TEMPLATE(kSerialPortChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 17,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.4, 0, 0.75, 0.15, 1.05, 0.44,
R_CUBIC_TO, 0.3, 0.29, 0.45, 0.65, 0.45, 1.06,
V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 2,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 2,
V_LINE_TO, 14,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.49,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.45, 1.06,
R_CUBIC_TO, -0.3, 0.3, -0.65, 0.45, -1.05, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
R_V_LINE_TO, -11,
R_H_LINE_TO, -11,
CLOSE,
MOVE_TO, 5, 14,
R_H_LINE_TO, 4,
R_V_LINE_TO, -3,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 5, -6,
R_H_LINE_TO, 3,
V_LINE_TO, 6,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, -5, 2,
R_H_LINE_TO, 4,
V_LINE_TO, 6,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 5, 4,
R_H_LINE_TO, 3,
V_LINE_TO, 9,
R_H_LINE_TO, -3,
CLOSE,
MOVE_TO, 3.5, 4.5,
R_V_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSerialPortChromeRefreshRepList, kSerialPortChromeRefreshIcon, {kSerialPortChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSerialPortOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.73, 18.83,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 5.13, 3,
R_H_LINE_TO, 9.37,
R_CUBIC_TO, 0.42, 0, 0.78, 0.15, 1.07, 0.45,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 2,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 2,
V_LINE_TO, 14,
R_H_LINE_TO, -1.87,
LINE_TO, 14.5, 12.38,
V_LINE_TO, 4.5,
H_LINE_TO, 6.63,
CLOSE,
MOVE_TO, 9, 6.88,
LINE_TO, 8.13, 6,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 10.13, 8,
LINE_TO, 10, 7.88,
V_LINE_TO, 6,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 13, 10.88,
LINE_TO, 11.13, 9,
H_LINE_TO, 13,
CLOSE,
R_MOVE_TO, -4, 0.25,
CLOSE,
R_MOVE_TO, 1.69, -2.54,
CLOSE,
MOVE_TO, 5, 14,
R_V_LINE_TO, -3,
R_H_LINE_TO, 4,
R_V_LINE_TO, 3,
CLOSE,
MOVE_TO, 3.13, 3.13,
LINE_TO, 4.5, 4.5,
R_H_LINE_TO, -1,
R_V_LINE_TO, 11,
R_H_LINE_TO, 11.02,
R_V_LINE_TO, -0.98,
LINE_TO, 16, 16,
R_ARC_TO, 1.81, 1.81, 0, 0, 1, -0.61, 0.7,
R_CUBIC_TO, -0.28, 0.2, -0.58, 0.3, -0.89, 0.3,
R_H_LINE_TO, -11,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.32, 0.11, -0.59, 0.34, -0.84,
R_CUBIC_TO, 0.23, -0.25, 0.49, -0.43, 0.78, -0.53,
CLOSE,
MOVE_TO, 10, 10,
R_LINE_TO, 3.33, 3.33,
V_LINE_TO, 14,
H_LINE_TO, 10,
CLOSE,
MOVE_TO, 6, 6,
R_LINE_TO, 3.29, 3.29,
V_LINE_TO, 10,
H_LINE_TO, 5,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSerialPortOffChromeRefreshRepList, kSerialPortOffChromeRefreshIcon, {kSerialPortOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSettingsPath, MOVE_TO, 38.86, 25.95,
R_CUBIC_TO, 0.08, -0.64, 0.14, -1.29, 0.14, -1.95,
R_CUBIC_TO, 0, -0.66, -0.06, -1.31, -0.14, -1.95,
R_LINE_TO, 4.23, -3.31,
R_CUBIC_TO, 0.38, -0.3, 0.49, -0.84, 0.24, -1.28,
R_LINE_TO, -4, -6.93,
R_CUBIC_TO, -0.25, -0.43, -0.77, -0.61, -1.22, -0.43,
R_LINE_TO, -4.98, 2.01,
R_CUBIC_TO, -1.03, -0.79, -2.16, -1.46, -3.38, -1.97,
LINE_TO, 29, 4.84,
R_CUBIC_TO, -0.09, -0.47, -0.5, -0.84, -1, -0.84,
R_H_LINE_TO, -8,
R_CUBIC_TO, -0.5, 0, -0.91, 0.37, -0.99, 0.84,
R_LINE_TO, -0.75, 5.3,
R_CUBIC_TO, -1.22, 0.51, -2.35, 1.17, -3.38, 1.97,
LINE_TO, 9.9, 10.1,
R_CUBIC_TO, -0.45, -0.17, -0.97, 0, -1.22, 0.43,
R_LINE_TO, -4, 6.93,
R_CUBIC_TO, -0.25, 0.43, -0.14, 0.97, 0.24, 1.28,
R_LINE_TO, 4.22, 3.31,
CUBIC_TO, 9.06, 22.69, 9, 23.34, 9, 24,
R_CUBIC_TO, 0, 0.66, 0.06, 1.31, 0.14, 1.95,
R_LINE_TO, -4.22, 3.31,
R_CUBIC_TO, -0.38, 0.3, -0.49, 0.84, -0.24, 1.28,
R_LINE_TO, 4, 6.93,
R_CUBIC_TO, 0.25, 0.43, 0.77, 0.61, 1.22, 0.43,
R_LINE_TO, 4.98, -2.01,
R_CUBIC_TO, 1.03, 0.79, 2.16, 1.46, 3.38, 1.97,
R_LINE_TO, 0.75, 5.3,
R_CUBIC_TO, 0.08, 0.47, 0.49, 0.84, 0.99, 0.84,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.5, 0, 0.91, -0.37, 0.99, -0.84,
R_LINE_TO, 0.75, -5.3,
R_CUBIC_TO, 1.22, -0.51, 2.35, -1.17, 3.38, -1.97,
R_LINE_TO, 4.98, 2.01,
R_CUBIC_TO, 0.45, 0.17, 0.97, 0, 1.22, -0.43,
R_LINE_TO, 4, -6.93,
R_CUBIC_TO, 0.25, -0.43, 0.14, -0.97, -0.24, -1.28,
R_LINE_TO, -4.22, -3.31,
CLOSE,
MOVE_TO, 24, 31,
R_CUBIC_TO, -3.87, 0, -7, -3.13, -7, -7,
R_CUBIC_TO, 0, -3.87, 3.13, -7, 7, -7,
R_CUBIC_TO, 3.87, 0, 7, 3.13, 7, 7,
R_CUBIC_TO, 0, 3.87, -3.13, 7, -7, 7,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSettings16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12.58, 8.59,
CUBIC_TO, 12.61, 8.4, 12.63, 8.2, 12.63, 8,
CUBIC_TO, 12.63, 7.8, 12.61, 7.6, 12.58, 7.41,
LINE_TO, 13.89, 6.42,
CUBIC_TO, 14, 6.33, 14.03, 6.17, 13.96, 6.04,
LINE_TO, 12.73, 3.96,
CUBIC_TO, 12.65, 3.83, 12.49, 3.78, 12.35, 3.83,
LINE_TO, 10.81, 4.43,
CUBIC_TO, 10.49, 4.19, 10.15, 3.99, 9.77, 3.84,
LINE_TO, 9.54, 2.25,
CUBIC_TO, 9.52, 2.11, 9.39, 2, 9.24, 2,
LINE_TO, 6.77, 2,
CUBIC_TO, 6.61, 2, 6.48, 2.11, 6.47, 2.25,
LINE_TO, 6.23, 3.84,
CUBIC_TO, 5.85, 3.99, 5.51, 4.2, 5.19, 4.43,
LINE_TO, 3.65, 3.83,
CUBIC_TO, 3.51, 3.78, 3.35, 3.83, 3.28, 3.96,
LINE_TO, 2.04, 6.04,
CUBIC_TO, 1.96, 6.17, 2, 6.33, 2.12, 6.42,
LINE_TO, 3.42, 7.41,
CUBIC_TO, 3.39, 7.6, 3.38, 7.8, 3.38, 8,
CUBIC_TO, 3.38, 8.2, 3.39, 8.4, 3.42, 8.59,
LINE_TO, 2.12, 9.58,
CUBIC_TO, 2, 9.67, 1.97, 9.83, 2.04, 9.96,
LINE_TO, 3.28, 12.04,
CUBIC_TO, 3.35, 12.17, 3.52, 12.22, 3.65, 12.17,
LINE_TO, 5.19, 11.57,
CUBIC_TO, 5.51, 11.81, 5.85, 12.01, 6.23, 12.16,
LINE_TO, 6.47, 13.75,
CUBIC_TO, 6.48, 13.89, 6.61, 14, 6.77, 14,
LINE_TO, 9.24, 14,
CUBIC_TO, 9.39, 14, 9.52, 13.89, 9.54, 13.75,
LINE_TO, 9.77, 12.16,
CUBIC_TO, 10.15, 12.01, 10.49, 11.8, 10.81, 11.57,
LINE_TO, 12.35, 12.17,
CUBIC_TO, 12.49, 12.22, 12.65, 12.17, 12.73, 12.04,
LINE_TO, 13.96, 9.96,
CUBIC_TO, 14.03, 9.83, 14, 9.67, 13.89, 9.58,
LINE_TO, 12.58, 8.59,
CLOSE,
MOVE_TO, 8, 10,
CUBIC_TO, 6.9, 10, 6, 9.1, 6, 8,
CUBIC_TO, 6, 6.9, 6.9, 6, 8, 6,
CUBIC_TO, 9.1, 6, 10, 6.9, 10, 8,
CUBIC_TO, 10, 9.1, 9.1, 10, 8, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSettingsRepList, kSettingsIcon, {kSettingsPath}, {kSettings16Path})
VECTOR_ICON_REP_TEMPLATE(kSettingsChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 8.4, 18,
R_LINE_TO, -0.46, -2.37,
R_ARC_TO, 7.16, 7.16, 0, 0, 1, -0.93, -0.44,
R_CUBIC_TO, -0.3, -0.17, -0.58, -0.36, -0.84, -0.58,
R_LINE_TO, -2.29, 0.77,
R_LINE_TO, -1.6, -2.77,
R_LINE_TO, 1.81, -1.58,
R_ARC_TO, 6.99, 6.99, 0, 0, 1, -0.06, -0.5,
R_ARC_TO, 7.33, 7.33, 0, 0, 1, 0, -1.04,
R_ARC_TO, 6.99, 6.99, 0, 0, 1, 0.06, -0.5,
LINE_TO, 2.27, 7.4,
R_LINE_TO, 1.61, -2.77,
R_LINE_TO, 2.29, 0.77,
R_CUBIC_TO, 0.26, -0.22, 0.54, -0.41, 0.84, -0.58,
R_CUBIC_TO, 0.3, -0.17, 0.61, -0.31, 0.93, -0.44,
LINE_TO, 8.4, 2,
R_H_LINE_TO, 3.21,
R_LINE_TO, 0.46, 2.38,
R_CUBIC_TO, 0.32, 0.13, 0.63, 0.27, 0.93, 0.44,
R_CUBIC_TO, 0.3, 0.17, 0.58, 0.36, 0.84, 0.58,
R_LINE_TO, 2.29, -0.77,
R_LINE_TO, 1.61, 2.77,
R_LINE_TO, -1.81, 1.59,
R_CUBIC_TO, 0.03, 0.17, 0.05, 0.33, 0.06, 0.5,
R_ARC_TO, 7.33, 7.33, 0, 0, 1, 0, 1.04,
R_ARC_TO, 6.99, 6.99, 0, 0, 1, -0.06, 0.5,
R_LINE_TO, 1.81, 1.59,
R_LINE_TO, -1.6, 2.77,
R_LINE_TO, -2.29, -0.77,
R_ARC_TO, 5.23, 5.23, 0, 0, 1, -0.84, 0.58,
R_ARC_TO, 7.16, 7.16, 0, 0, 1, -0.92, 0.44,
LINE_TO, 11.6, 18,
CLOSE,
R_MOVE_TO, 1.23, -1.5,
R_H_LINE_TO, 0.75,
R_LINE_TO, 0.4, -2.06,
R_ARC_TO, 4.59, 4.59, 0, 0, 0, 1.48, -0.54,
R_ARC_TO, 4.31, 4.31, 0, 0, 0, 1.19, -1,
R_LINE_TO, 2, 0.67,
R_LINE_TO, 0.37, -0.63,
R_LINE_TO, -1.58, -1.39,
R_CUBIC_TO, 0.08, -0.24, 0.15, -0.48, 0.2, -0.74,
R_CUBIC_TO, 0.05, -0.25, 0.07, -0.52, 0.07, -0.8,
R_CUBIC_TO, 0, -0.28, -0.02, -0.55, -0.07, -0.8,
R_ARC_TO, 5.05, 5.05, 0, 0, 0, -0.2, -0.74,
R_LINE_TO, 1.58, -1.39,
R_LINE_TO, -0.37, -0.62,
R_LINE_TO, -2, 0.67,
R_ARC_TO, 4.31, 4.31, 0, 0, 0, -1.19, -1,
R_ARC_TO, 4.59, 4.59, 0, 0, 0, -1.48, -0.54,
LINE_TO, 10.38, 3.5,
R_H_LINE_TO, -0.75,
LINE_TO, 9.23, 5.56,
R_ARC_TO, 4.59, 4.59, 0, 0, 0, -1.48, 0.54,
R_ARC_TO, 4.31, 4.31, 0, 0, 0, -1.19, 1,
R_LINE_TO, -2, -0.67,
R_LINE_TO, -0.37, 0.63,
LINE_TO, 5.77, 8.46,
R_ARC_TO, 5.05, 5.05, 0, 0, 0, -0.2, 0.74,
R_CUBIC_TO, -0.05, 0.25, -0.07, 0.52, -0.07, 0.8,
R_CUBIC_TO, 0, 0.28, 0.02, 0.55, 0.07, 0.8,
R_CUBIC_TO, 0.05, 0.26, 0.11, 0.51, 0.2, 0.74,
R_LINE_TO, -1.58, 1.4,
R_LINE_TO, 0.38, 0.62,
R_LINE_TO, 2, -0.67,
R_CUBIC_TO, 0.33, 0.4, 0.73, 0.74, 1.19, 1,
R_ARC_TO, 4.59, 4.59, 0, 0, 0, 1.48, 0.54,
CLOSE,
MOVE_TO, 10, 13,
R_CUBIC_TO, 0.83, 0, 1.54, -0.29, 2.13, -0.87,
ARC_TO, 2.9, 2.9, 0, 0, 0, 13, 10,
R_CUBIC_TO, 0, -0.83, -0.29, -1.54, -0.87, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 0, 10, 7,
R_CUBIC_TO, -0.83, 0, -1.54, 0.29, -2.12, 0.88,
ARC_TO, 2.9, 2.9, 0, 0, 0, 7, 10,
R_CUBIC_TO, 0, 0.83, 0.29, 1.54, 0.88, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 0, 10, 13,
CLOSE,
R_MOVE_TO, 0, -3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSettingsChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 6.6, 14.54,
R_LINE_TO, -0.37, -1.94,
R_CUBIC_TO, -0.23, -0.09, -0.46, -0.2, -0.68, -0.32,
R_ARC_TO, 3.78, 3.78, 0, 0, 1, -0.62, -0.43,
R_LINE_TO, -1.87, 0.64,
R_LINE_TO, -1.4, -2.43,
R_LINE_TO, 1.48, -1.29,
R_ARC_TO, 6.3, 6.3, 0, 0, 1, -0.05, -0.37,
ARC_TO, 4.13, 4.13, 0, 0, 1, 3.06, 8,
R_CUBIC_TO, 0, -0.13, 0.01, -0.26, 0.02, -0.39,
R_CUBIC_TO, 0.01, -0.12, 0.03, -0.24, 0.05, -0.37,
LINE_TO, 1.64, 5.96,
R_LINE_TO, 1.4, -2.43,
R_LINE_TO, 1.88, 0.63,
R_CUBIC_TO, 0.2, -0.16, 0.4, -0.3, 0.62, -0.43,
R_CUBIC_TO, 0.22, -0.12, 0.45, -0.23, 0.68, -0.32,
R_LINE_TO, 0.38, -1.95,
R_H_LINE_TO, 2.8,
R_LINE_TO, 0.38, 1.95,
R_CUBIC_TO, 0.24, 0.09, 0.46, 0.2, 0.68, 0.32,
R_CUBIC_TO, 0.22, 0.12, 0.43, 0.26, 0.63, 0.43,
R_LINE_TO, 1.88, -0.63,
R_LINE_TO, 1.4, 2.43,
R_LINE_TO, -1.49, 1.29,
R_ARC_TO, 4.15, 4.15, 0, 0, 1, 0.06, 0.75,
R_ARC_TO, 4.15, 4.15, 0, 0, 1, -0.06, 0.75,
R_LINE_TO, 1.49, 1.29,
R_LINE_TO, -1.41, 2.43,
R_LINE_TO, -1.88, -0.64,
R_ARC_TO, 4.07, 4.07, 0, 0, 1, -0.62, 0.43,
R_ARC_TO, 5.2, 5.2, 0, 0, 1, -0.68, 0.32,
R_LINE_TO, -0.37, 1.95,
CLOSE,
R_MOVE_TO, 1.14, -1.38,
R_H_LINE_TO, 0.51,
R_LINE_TO, 0.32, -1.64,
R_ARC_TO, 3.73, 3.73, 0, 0, 0, 1.2, -0.44,
R_ARC_TO, 3.28, 3.28, 0, 0, 0, 0.96, -0.82,
R_LINE_TO, 1.59, 0.53,
R_LINE_TO, 0.25, -0.43,
R_LINE_TO, -1.25, -1.11,
R_CUBIC_TO, 0.07, -0.19, 0.12, -0.39, 0.16, -0.6,
R_CUBIC_TO, 0.04, -0.21, 0.06, -0.42, 0.06, -0.65,
R_CUBIC_TO, 0, -0.23, -0.02, -0.44, -0.06, -0.65,
R_CUBIC_TO, -0.04, -0.21, -0.09, -0.41, -0.16, -0.61,
R_LINE_TO, 1.26, -1.11,
R_LINE_TO, -0.26, -0.42,
R_LINE_TO, -1.59, 0.53,
R_ARC_TO, 3.4, 3.4, 0, 0, 0, -0.96, -0.82,
R_ARC_TO, 3.72, 3.72, 0, 0, 0, -1.2, -0.44,
R_LINE_TO, -0.32, -1.64,
R_H_LINE_TO, -0.52,
LINE_TO, 7.43, 4.48,
R_ARC_TO, 3.76, 3.76, 0, 0, 0, -1.21, 0.44,
R_ARC_TO, 3.42, 3.42, 0, 0, 0, -0.96, 0.82,
R_LINE_TO, -1.59, -0.53,
R_LINE_TO, -0.26, 0.43,
R_LINE_TO, 1.25, 1.11,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, -0.16, 0.61,
R_CUBIC_TO, -0.04, 0.21, -0.06, 0.43, -0.06, 0.65,
R_CUBIC_TO, 0, 0.23, 0.02, 0.44, 0.06, 0.65,
R_CUBIC_TO, 0.04, 0.21, 0.09, 0.41, 0.16, 0.61,
R_LINE_TO, -1.25, 1.1,
R_LINE_TO, 0.26, 0.43,
R_LINE_TO, 1.59, -0.53,
R_CUBIC_TO, 0.27, 0.33, 0.59, 0.6, 0.97, 0.81,
R_CUBIC_TO, 0.38, 0.22, 0.78, 0.36, 1.2, 0.44,
CLOSE,
R_MOVE_TO, 0.25, -2.75,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, 1.7, -0.7,
ARC_TO, 2.3, 2.3, 0, 0, 0, 10.39, 8,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, -0.7, -1.7,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, -1.7, -0.7,
R_CUBIC_TO, -0.66, 0, -1.23, 0.23, -1.7, 0.7,
ARC_TO, 2.3, 2.3, 0, 0, 0, 5.59, 8,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, 0.7, 1.7,
R_CUBIC_TO, 0.47, 0.47, 1.03, 0.7, 1.7, 0.7,
CLOSE,
MOVE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSettingsChromeRefreshRepList, kSettingsChromeRefreshIcon, {kSettingsChromeRefreshPath}, {kSettingsChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kSettingsOutlinePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 11.48, 18,
H_LINE_TO, 8.52,
R_CUBIC_TO, -0.59, 0, -1.09, -0.42, -1.16, -0.99,
R_LINE_TO, -0.22, -1.48,
R_CUBIC_TO, -0.22, -0.11, -0.42, -0.23, -0.63, -0.36,
R_LINE_TO, -1.44, 0.56,
R_CUBIC_TO, -0.56, 0.2, -1.18, -0.02, -1.45, -0.51,
R_LINE_TO, -1.46, -2.48,
R_CUBIC_TO, -0.28, -0.52, -0.16, -1.12, 0.29, -1.47,
R_LINE_TO, 1.22, -0.93,
R_CUBIC_TO, -0.01, -0.12, -0.02, -0.23, -0.02, -0.36,
R_CUBIC_TO, 0, -0.12, 0.01, -0.24, 0.02, -0.36,
R_LINE_TO, -1.22, -0.93,
R_CUBIC_TO, -0.47, -0.35, -0.59, -0.98, -0.3, -1.47,
R_LINE_TO, 1.48, -2.49,
R_CUBIC_TO, 0.27, -0.48, 0.89, -0.7, 1.43, -0.49,
R_LINE_TO, 1.45, 0.57,
R_CUBIC_TO, 0.21, -0.13, 0.42, -0.25, 0.62, -0.36,
R_LINE_TO, 0.22, -1.49,
CUBIC_TO, 7.43, 2.43, 7.93, 2, 8.51, 2,
R_H_LINE_TO, 2.96,
R_CUBIC_TO, 0.59, 0, 1.09, 0.42, 1.16, 0.99,
R_LINE_TO, 0.22, 1.48,
R_CUBIC_TO, 0.22, 0.11, 0.42, 0.23, 0.63, 0.36,
R_LINE_TO, 1.44, -0.56,
R_CUBIC_TO, 0.57, -0.2, 1.18, 0.02, 1.46, 0.51,
R_LINE_TO, 1.47, 2.48,
R_CUBIC_TO, 0.29, 0.52, 0.16, 1.12, -0.29, 1.47,
R_LINE_TO, -1.22, 0.93,
R_CUBIC_TO, 0.01, 0.12, 0.02, 0.23, 0.02, 0.36,
R_CUBIC_TO, 0, 0.12, -0.01, 0.24, -0.02, 0.36,
R_LINE_TO, 1.22, 0.93,
R_CUBIC_TO, 0.45, 0.35, 0.58, 0.96, 0.3, 1.45,
R_LINE_TO, -1.49, 2.51,
R_CUBIC_TO, -0.27, 0.48, -0.89, 0.7, -1.44, 0.49,
R_LINE_TO, -1.44, -0.56,
R_CUBIC_TO, -0.21, 0.13, -0.42, 0.25, -0.62, 0.36,
R_LINE_TO, -0.22, 1.49,
CUBIC_TO, 12.57, 17.58, 12.07, 18, 11.48, 18,
CLOSE,
R_MOVE_TO, -2.53, -2,
R_H_LINE_TO, 2.11,
R_LINE_TO, 0.28, -1.85,
R_LINE_TO, 0.41, -0.16,
R_CUBIC_TO, 0.34, -0.13, 0.67, -0.32, 1.03, -0.57,
R_LINE_TO, 0.34, -0.25,
R_LINE_TO, 1.82, 0.7,
LINE_TO, 16, 12.12,
R_LINE_TO, -1.55, -1.15,
R_LINE_TO, 0.05, -0.41,
R_CUBIC_TO, 0.02, -0.19, 0.05, -0.37, 0.05, -0.57,
R_CUBIC_TO, 0, -0.2, -0.02, -0.39, -0.05, -0.57,
R_LINE_TO, -0.05, -0.41,
LINE_TO, 16, 7.88,
R_LINE_TO, -1.06, -1.75,
R_LINE_TO, -1.83, 0.7,
R_LINE_TO, -0.34, -0.25,
R_CUBIC_TO, -0.32, -0.23, -0.67, -0.42, -1.02, -0.56,
R_LINE_TO, -0.4, -0.16,
LINE_TO, 11.06, 4,
H_LINE_TO, 8.95,
R_LINE_TO, -0.28, 1.85,
R_LINE_TO, -0.41, 0.15,
R_CUBIC_TO, -0.34, 0.14, -0.67, 0.32, -1.03, 0.57,
R_LINE_TO, -0.34, 0.24,
R_LINE_TO, -1.82, -0.69,
LINE_TO, 4, 7.87,
R_LINE_TO, 1.55, 1.15,
R_LINE_TO, -0.05, 0.41,
R_CUBIC_TO, -0.02, 0.19, -0.05, 0.39, -0.05, 0.57,
R_CUBIC_TO, 0, 0.19, 0.02, 0.39, 0.05, 0.57,
R_LINE_TO, 0.05, 0.41,
LINE_TO, 4, 12.12,
R_LINE_TO, 1.06, 1.75,
R_LINE_TO, 1.83, -0.7,
R_LINE_TO, 0.34, 0.25,
R_CUBIC_TO, 0.33, 0.24, 0.66, 0.42, 1.02, 0.56,
R_LINE_TO, 0.41, 0.16,
LINE_TO, 8.95, 16,
CLOSE,
MOVE_TO, 10, 12.5,
R_CUBIC_TO, 1.38, 0, 2.5, -1.12, 2.5, -2.5,
R_CUBIC_TO, 0, -1.38, -1.12, -2.5, -2.5, -2.5,
R_CUBIC_TO, -1.38, 0, -2.5, 1.12, -2.5, 2.5,
R_CUBIC_TO, 0, 1.38, 1.12, 2.5, 2.5, 2.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSettingsOutlineRepList, kSettingsOutlineIcon, {kSettingsOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kShoppingBagPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 18, 6,
R_H_LINE_TO, -2,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CUBIC_TO_SHORTHAND, 8, 3.79, 8, 6,
H_LINE_TO, 6,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 12,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 8,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, -6, -2,
R_CUBIC_TO, 1.1, 0, 2, 0.9, 2, 2,
R_H_LINE_TO, -4,
R_CUBIC_TO, 0, -1.1, 0.9, -2, 2, -2,
CLOSE,
R_MOVE_TO, 6, 16,
H_LINE_TO, 6,
V_LINE_TO, 8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
V_LINE_TO, 8,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
R_CUBIC_TO, 0, 0.55, 0.45, 1, 1, 1,
R_CUBIC_TO, 0.55, 0, 1, -0.45, 1, -1,
V_LINE_TO, 8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kShoppingBagRepList, kShoppingBagIcon, {kShoppingBagPath})
VECTOR_ICON_REP_TEMPLATE(kShoppingBagRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 5.49, 18,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -1.05, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4, 16.5,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5.5, 5.5,
H_LINE_TO, 7,
R_V_LINE_TO, -0.33,
R_CUBIC_TO, 0, -0.84, 0.28, -1.57, 0.84, -2.21,
CUBIC_TO, 8.41, 2.32, 9.13, 2, 10, 2,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
CUBIC_TO, 12.71, 3.46, 13, 4.17, 13, 5,
R_V_LINE_TO, 0.5,
R_H_LINE_TO, 1.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 14.5, 18,
CLOSE,
R_MOVE_TO, 0.01, -1.5,
R_H_LINE_TO, 9,
V_LINE_TO, 7,
H_LINE_TO, 13,
R_V_LINE_TO, 1.25,
R_CUBIC_TO, 0, 0.21, -0.07, 0.39, -0.21, 0.54,
R_ARC_TO, 0.71, 0.71, 0, 0, 1, -0.53, 0.22,
R_CUBIC_TO, -0.21, 0, -0.39, -0.07, -0.53, -0.21,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.22, -0.53,
V_LINE_TO, 7,
R_H_LINE_TO, -3,
R_V_LINE_TO, 1.25,
R_CUBIC_TO, 0, 0.21, -0.07, 0.39, -0.21, 0.54,
ARC_TO, 0.71, 0.71, 0, 0, 1, 7.75, 9,
R_CUBIC_TO, -0.21, 0, -0.39, -0.07, -0.53, -0.21,
ARC_TO, 0.73, 0.73, 0, 0, 1, 7, 8.25,
V_LINE_TO, 7,
H_LINE_TO, 5.5,
CLOSE,
R_MOVE_TO, 3, -11,
R_H_LINE_TO, 3,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
ARC_TO, 1.46, 1.46, 0, 0, 0, 10, 3.5,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.44, 1.44, 0, 0, 0, 8.5, 5,
CLOSE,
R_MOVE_TO, -3, 11,
V_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kShoppingBagRefreshRepList, kShoppingBagRefreshIcon, {kShoppingBagRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kShoppingmodePath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10.42, 17.56,
ARC_TO, 1.45, 1.45, 0, 0, 1, 9.36, 18,
R_CUBIC_TO, -0.42, 0, -0.77, -0.14, -1.06, -0.44,
R_LINE_TO, -5.85, -5.85,
ARC_TO, 1.42, 1.42, 0, 0, 1, 2, 10.65,
R_CUBIC_TO, 0, -0.42, 0.14, -0.77, 0.44, -1.07,
LINE_TO, 9.59, 2.43,
R_CUBIC_TO, 0.15, -0.15, 0.31, -0.26, 0.49, -0.32,
ARC_TO, 1.52, 1.52, 0, 0, 1, 10.65, 2,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 5.88,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -0.44, 1.04,
CLOSE,
MOVE_TO, 14.5, 6.75,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
R_ARC_TO, 1.22, 1.22, 0, 0, 0, -0.89, -0.36,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
MOVE_TO, 9.36, 16.5,
LINE_TO, 16.5, 9.38,
V_LINE_TO, 3.5,
R_H_LINE_TO, -5.85,
LINE_TO, 3.5, 10.65,
CLOSE,
MOVE_TO, 16.48, 3.58,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kShoppingmodeRepList, kShoppingmodeIcon, {kShoppingmodePath})
VECTOR_ICON_REP_TEMPLATE(kSkipNextPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 660, 720,
R_V_LINE_TO, -480,
R_H_LINE_TO, 80,
R_V_LINE_TO, 480,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, -440, 0,
R_V_LINE_TO, -480,
R_LINE_TO, 360, 240,
R_LINE_TO, -360, 240,
CLOSE,
R_MOVE_TO, 80, -240,
CLOSE,
R_MOVE_TO, 0, 90,
R_LINE_TO, 136, -90,
R_LINE_TO, -136, -90,
R_V_LINE_TO, 180,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSkipNextRepList, kSkipNextIcon, {kSkipNextPath})
VECTOR_ICON_REP_TEMPLATE(kSkipPreviousPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 220, 720,
R_V_LINE_TO, -480,
R_H_LINE_TO, 80,
R_V_LINE_TO, 480,
R_H_LINE_TO, -80,
CLOSE,
R_MOVE_TO, 520, 0,
LINE_TO, 380, 480,
R_LINE_TO, 360, -240,
R_V_LINE_TO, 480,
CLOSE,
R_MOVE_TO, -80, -240,
CLOSE,
R_MOVE_TO, 0, 90,
R_V_LINE_TO, -180,
R_LINE_TO, -136, 90,
R_LINE_TO, 136, 90,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSkipPreviousRepList, kSkipPreviousIcon, {kSkipPreviousPath})
VECTOR_ICON_REP_TEMPLATE(kSmartCardReaderPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2, 18,
R_V_LINE_TO, -2.5,
R_CUBIC_TO, 0, -0.42, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 14,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 18,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 13,
R_V_LINE_TO, -1,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 1, -3.5,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.46, 0.14, -0.82, 0.41, -1.09,
CUBIC_TO, 5.18, 2.14, 5.54, 2, 6, 2,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.46, 0, 0.82, 0.14, 1.09, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.63, 0.41, 1.09,
V_LINE_TO, 13,
H_LINE_TO, 14,
V_LINE_TO, 3.5,
H_LINE_TO, 6,
V_LINE_TO, 13,
CLOSE,
MOVE_TO, 7, 11.5,
R_H_LINE_TO, 0.43,
R_CUBIC_TO, 0.55, 0, 0.99, -0.27, 1.32, -0.82,
R_CUBIC_TO, 0.33, -0.55, 0.5, -1.28, 0.5, -2.18,
R_CUBIC_TO, 0, -0.9, -0.16, -1.62, -0.5, -2.17,
R_CUBIC_TO, -0.33, -0.55, -0.77, -0.82, -1.32, -0.82,
H_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 4.5, -1.5,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 0, 11.5, 7,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 10, 8.5,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 10, 16.5,
CLOSE,
R_MOVE_TO, 0, -8.25,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSmartCardReaderRepList, kSmartCardReaderIcon, {kSmartCardReaderPath})
VECTOR_ICON_REP_TEMPLATE(kSmartCardReaderOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14, 1.17,
R_CUBIC_TO, 0.46, 0, 0.82, 0.13, 1.09, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.63, 0.41, 1.09,
R_V_LINE_TO, 9.51,
R_H_LINE_TO, -0.39,
LINE_TO, 14, 11.06,
V_LINE_TO, 2.67,
H_LINE_TO, 5.65,
LINE_TO, 4.75, 1.77,
R_CUBIC_TO, 0.13, -0.19, 0.3, -0.34, 0.51, -0.45,
R_CUBIC_TO, 0.22, -0.1, 0.46, -0.16, 0.74, -0.16,
CLOSE,
R_MOVE_TO, -1.98, 7.91,
R_LINE_TO, -1.91, -1.94,
R_ARC_TO, 1.56, 1.56, 0, 0, 1, 0.54, -0.7,
R_ARC_TO, 1.38, 1.38, 0, 0, 1, 0.86, -0.28,
R_CUBIC_TO, 0.41, 0, 0.76, 0.14, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_CUBIC_TO, 0, 0.32, -0.09, 0.61, -0.28, 0.87,
R_ARC_TO, 1.57, 1.57, 0, 0, 1, -0.7, 0.55,
CLOSE,
MOVE_TO, 7, 10.67,
R_V_LINE_TO, -4.5,
R_LINE_TO, 2.21, 2.21,
R_CUBIC_TO, -0.08, 0.71, -0.28, 1.27, -0.59, 1.68,
R_CUBIC_TO, -0.31, 0.41, -0.71, 0.62, -1.18, 0.62,
CLOSE,
R_MOVE_TO, -3.5, 5,
R_H_LINE_TO, 10.88,
R_LINE_TO, -1, -1,
H_LINE_TO, 3.5,
CLOSE,
R_MOVE_TO, 13.23, 2.35,
R_LINE_TO, -0.85, -0.85,
H_LINE_TO, 2,
R_V_LINE_TO, -2.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, 1.06, -0.44,
R_H_LINE_TO, 8.38,
LINE_TO, 6, 7.29,
R_V_LINE_TO, 4.88,
H_LINE_TO, 4.5,
V_LINE_TO, 5.79,
LINE_TO, 1.15, 2.44,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 15.59, 15.58,
CLOSE,
R_MOVE_TO, -7.79, -2.35,
CLOSE,
R_MOVE_TO, 0.9, -8.81,
CLOSE,
MOVE_TO, 8.44, 9.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSmartCardReaderOffRepList, kSmartCardReaderOffIcon, {kSmartCardReaderOffPath})
VECTOR_ICON_REP_TEMPLATE(kSmsPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 2,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 18,
R_LINE_TO, 4, -4,
R_H_LINE_TO, 14,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, 0, 14,
H_LINE_TO, 6,
R_LINE_TO, -2, 2,
V_LINE_TO, 4,
R_H_LINE_TO, 16,
R_V_LINE_TO, 12,
CLOSE,
MOVE_TO, 7, 9,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 4, 0,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 4, 0,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSmsRepList, kSmsIcon, {kSmsPath})
VECTOR_ICON_REP_TEMPLATE(kStarPath, CANVAS_DIMENSIONS, 13,
FILL_RULE_NONZERO,
R_MOVE_TO, 3.39, 10.41,
R_LINE_TO, 0.83, -3.49,
R_LINE_TO, -2.76, -2.35,
R_LINE_TO, 3.62, -0.31,
R_LINE_TO, 1.42, -3.3,
R_LINE_TO, 1.42, 3.31,
R_LINE_TO, 3.62, 0.3,
R_LINE_TO, -2.76, 2.35,
R_LINE_TO, 0.83, 3.5,
LINE_TO, 6.5, 8.55,
R_LINE_TO, -3.11, 1.86,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStarRepList, kStarIcon, {kStarPath})
VECTOR_ICON_REP_TEMPLATE(kStarHalfPath, CANVAS_DIMENSIONS, 13,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
FILL_RULE_NONZERO,
R_MOVE_TO, 3.39, 10.41,
R_LINE_TO, 0.83, -3.49,
R_LINE_TO, -2.76, -2.35,
R_LINE_TO, 3.62, -0.31,
R_LINE_TO, 1.42, -3.3,
R_LINE_TO, 1.42, 3.31,
R_LINE_TO, 3.62, 0.3,
R_LINE_TO, -2.76, 2.35,
R_LINE_TO, 0.83, 3.5,
LINE_TO, 6.5, 8.55,
R_LINE_TO, -3.11, 1.86,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
R_MOVE_TO, 3.39, 10.41,
R_LINE_TO, 0.83, -3.5,
R_LINE_TO, -2.76, -2.35,
R_LINE_TO, 3.62, -0.31,
LINE_TO, 6.5, 0.95,
R_V_LINE_TO, 7.61,
R_LINE_TO, -3.11, 1.86,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStarHalfRepList, kStarHalfIcon, {kStarHalfPath})
VECTOR_ICON_REP_TEMPLATE(kStickyNote2Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 15.5,
R_H_LINE_TO, 7,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -7,
R_H_LINE_TO, -11,
CLOSE,
R_MOVE_TO, 0, 1.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 12,
R_LINE_TO, -5, 5,
CLOSE,
MOVE_TO, 6, 11.5,
V_LINE_TO, 10,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 0, -3,
V_LINE_TO, 7,
R_H_LINE_TO, 8,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, -1.5, 7,
R_V_LINE_TO, -11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStickyNote2RepList, kStickyNote2Icon, {kStickyNote2Path})
VECTOR_ICON_REP_TEMPLATE(kStopCirclePath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 320, 640,
R_H_LINE_TO, 320,
R_V_LINE_TO, -320,
H_LINE_TO, 320,
R_V_LINE_TO, 320,
CLOSE,
MOVE_TO, 480, 880,
R_QUADRATIC_TO, -83, 0, -156, -31.5,
QUADRATIC_TO_SHORTHAND, 197, 763,
R_QUADRATIC_TO, -54, -54, -85.5, -127,
QUADRATIC_TO_SHORTHAND, 80, 480,
R_QUADRATIC_TO, 0, -83, 31.5, -156,
QUADRATIC_TO_SHORTHAND, 197, 197,
R_QUADRATIC_TO, 54, -54, 127, -85.5,
QUADRATIC_TO_SHORTHAND, 480, 80,
R_QUADRATIC_TO, 83, 0, 156, 31.5,
QUADRATIC_TO_SHORTHAND, 763, 197,
R_QUADRATIC_TO, 54, 54, 85.5, 127,
QUADRATIC_TO_SHORTHAND, 880, 480,
R_QUADRATIC_TO, 0, 83, -31.5, 156,
QUADRATIC_TO_SHORTHAND, 763, 763,
R_QUADRATIC_TO, -54, 54, -127, 85.5,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE,
R_MOVE_TO, 0, -80,
R_QUADRATIC_TO, 134, 0, 227, -93,
R_QUADRATIC_TO, 93, -93, 93, -227,
R_QUADRATIC_TO, 0, -134, -93, -227,
R_QUADRATIC_TO, -93, -93, -227, -93,
R_QUADRATIC_TO, -134, 0, -227, 93,
R_QUADRATIC_TO, -93, 93, -93, 227,
R_QUADRATIC_TO, 0, 134, 93, 227,
R_QUADRATIC_TO, 93, 93, 227, 93,
CLOSE,
R_MOVE_TO, 0, -320,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStopCircleRepList, kStopCircleIcon, {kStopCirclePath})
VECTOR_ICON_REP_TEMPLATE(kStorageAccessPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.5, 14.69,
R_ARC_TO, 6.46, 6.46, 0, 0, 1, -3.26, -2.36,
ARC_TO, 6.34, 6.34, 0, 0, 1, 2, 8.5,
R_CUBIC_TO, 0, -1.8, 0.63, -3.34, 1.9, -4.61,
CUBIC_TO, 5.16, 2.63, 6.7, 2, 8.5, 2,
R_ARC_TO, 6.34, 6.34, 0, 0, 1, 3.82, 1.24,
ARC_TO, 6.46, 6.46, 0, 0, 1, 14.69, 6.5,
R_H_LINE_TO, -1.61,
R_ARC_TO, 4.92, 4.92, 0, 0, 0, -1.84, -2.19,
ARC_TO, 4.87, 4.87, 0, 0, 0, 8.5, 3.5,
R_CUBIC_TO, -1.39, 0, -2.57, 0.48, -3.54, 1.46,
CUBIC_TO, 3.98, 5.93, 3.5, 7.11, 3.5, 8.5,
R_CUBIC_TO, 0, 1, 0.27, 1.91, 0.81, 2.73,
ARC_TO, 4.97, 4.97, 0, 0, 0, 6.5, 13.06,
CLOSE,
MOVE_TO, 9.5, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8, 16.5,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 9.5, 8,
R_H_LINE_TO, 7,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 18,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 7,
R_V_LINE_TO, -7,
R_H_LINE_TO, -7,
CLOSE,
R_MOVE_TO, 0.5, -1,
R_H_LINE_TO, 6,
LINE_TO, 14.11, 13,
R_LINE_TO, -1.5, 1.98,
LINE_TO, 11.5, 13.5,
CLOSE,
R_MOVE_TO, 3, -2.5,
CLOSE,
MOVE_TO, 8.29, 8.27,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStorageAccessRepList, kStorageAccessIcon, {kStorageAccessPath})
VECTOR_ICON_REP_TEMPLATE(kStorageAccessOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 18, 15.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 9.5,
R_H_LINE_TO, -4.87,
R_LINE_TO, -1.5, -1.5,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
CLOSE,
MOVE_TO, 13.08, 6.5,
R_ARC_TO, 4.92, 4.92, 0, 0, 0, -1.84, -2.19,
ARC_TO, 4.87, 4.87, 0, 0, 0, 8.5, 3.5,
R_CUBIC_TO, -0.4, 0, -0.79, 0.05, -1.18, 0.14,
R_ARC_TO, 5.1, 5.1, 0, 0, 0, -1.12, 0.44,
LINE_TO, 5.08, 2.98,
R_ARC_TO, 6.9, 6.9, 0, 0, 1, 1.65, -0.73,
ARC_TO, 6.26, 6.26, 0, 0, 1, 8.5, 2,
R_ARC_TO, 6.34, 6.34, 0, 0, 1, 3.82, 1.24,
ARC_TO, 6.46, 6.46, 0, 0, 1, 14.69, 6.5,
CLOSE,
R_MOVE_TO, -1.14, 7.56,
CLOSE,
R_MOVE_TO, 4.79, 4.79,
LINE_TO, 15.88, 18,
H_LINE_TO, 9.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8, 16.5,
R_V_LINE_TO, -6.37,
LINE_TO, 4.06, 6.19,
ARC_TO, 4.97, 4.97, 0, 0, 0, 3.5, 8.5,
R_CUBIC_TO, 0, 1, 0.27, 1.91, 0.81, 2.73,
ARC_TO, 4.97, 4.97, 0, 0, 0, 6.5, 13.06,
R_V_LINE_TO, 1.63,
R_ARC_TO, 6.46, 6.46, 0, 0, 1, -3.26, -2.36,
ARC_TO, 6.34, 6.34, 0, 0, 1, 2, 8.5,
R_CUBIC_TO, 0, -0.63, 0.08, -1.23, 0.25, -1.8,
R_ARC_TO, 6.7, 6.7, 0, 0, 1, 0.71, -1.61,
LINE_TO, 1.17, 3.29,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.56, 15.56,
CLOSE,
MOVE_TO, 9.04, 6.54,
CLOSE,
R_MOVE_TO, -1.6, 0.89,
CLOSE,
MOVE_TO, 10, 15.5,
R_LINE_TO, 1.48, -2,
R_LINE_TO, 1.27, 1.29,
R_LINE_TO, 0.88, -1.17,
LINE_TO, 15.5, 15.5,
CLOSE,
R_MOVE_TO, -0.5, 1,
R_H_LINE_TO, 4.88,
LINE_TO, 9.5, 11.63,
CLOSE,
R_MOVE_TO, 4.56, -4.56,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStorageAccessOffRepList, kStorageAccessOffIcon, {kStorageAccessOffPath})
VECTOR_ICON_REP_TEMPLATE(kStorefrontPath, CANVAS_DIMENSIONS, 14,
FILL_RULE_NONZERO,
MOVE_TO, 12.6, 5.6,
R_V_LINE_TO, 4.8,
R_CUBIC_TO, 0, 0.32, -0.12, 0.61, -0.35, 0.85,
R_CUBIC_TO, -0.23, 0.23, -0.52, 0.35, -0.85, 0.35,
H_LINE_TO, 2.6,
R_CUBIC_TO, -0.33, 0, -0.62, -0.12, -0.85, -0.35,
R_ARC_TO, 1.19, 1.19, 0, 0, 1, -0.35, -0.85,
V_LINE_TO, 5.58,
CUBIC_TO, 1.03, 5.33, 0.8, 5, 0.7, 4.6,
R_CUBIC_TO, -0.09, -0.4, -0.08, -0.82, 0.02, -1.27,
LINE_TO, 1.48, 1.2,
R_ARC_TO, 0.91, 0.91, 0, 0, 1, 0.38, -0.6,
R_CUBIC_TO, 0.2, -0.13, 0.44, -0.2, 0.73, -0.2,
R_H_LINE_TO, 8.8,
R_CUBIC_TO, 0.29, 0, 0.53, 0.06, 0.72, 0.18,
R_CUBIC_TO, 0.2, 0.12, 0.33, 0.33, 0.4, 0.62,
R_LINE_TO, 0.77, 2.13,
R_CUBIC_TO, 0.1, 0.45, 0.1, 0.87, 0, 1.27,
R_CUBIC_TO, -0.1, 0.4, -0.33, 0.73, -0.68, 1,
CLOSE,
R_MOVE_TO, -4.13, -0.8,
R_ARC_TO, 0.79, 0.79, 0, 0, 0, 0.58, -0.23,
ARC_TO, 0.65, 0.65, 0, 0, 0, 9.27, 4,
R_LINE_TO, -0.4, -2.4,
R_H_LINE_TO, -1.2,
V_LINE_TO, 4,
R_CUBIC_TO, 0, 0.22, 0.08, 0.41, 0.23, 0.57,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, 0.57, 0.23,
CLOSE,
R_MOVE_TO, -2.93, 0,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, 0.57, -0.23,
ARC_TO, 0.77, 0.77, 0, 0, 0, 6.33, 4,
V_LINE_TO, 1.6,
R_H_LINE_TO, -1.2,
R_LINE_TO, -0.4, 2.4,
R_ARC_TO, 0.67, 0.67, 0, 0, 0, 0.2, 0.57,
R_ARC_TO, 0.85, 0.85, 0, 0, 0, 0.6, 0.23,
CLOSE,
MOVE_TO, 2.6, 4.8,
R_CUBIC_TO, 0.2, 0, 0.37, -0.06, 0.52, -0.18,
R_ARC_TO, 0.68, 0.68, 0, 0, 0, 0.27, -0.47,
LINE_TO, 3.8, 1.6,
H_LINE_TO, 2.6,
R_LINE_TO, -0.75, 2.13,
R_ARC_TO, 0.79, 0.79, 0, 0, 0, 0.1, 0.73,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, 0.65, 0.33,
CLOSE,
R_MOVE_TO, 8.8, 0,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, 0.65, -0.33,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, 0.12, -0.73,
LINE_TO, 11.4, 1.6,
R_H_LINE_TO, -1.2,
R_LINE_TO, 0.42, 2.55,
R_ARC_TO, 0.68, 0.68, 0, 0, 0, 0.27, 0.47,
R_ARC_TO, 0.82, 0.82, 0, 0, 0, 0.52, 0.18,
CLOSE,
R_MOVE_TO, -8.8, 5.6,
R_H_LINE_TO, 8.8,
V_LINE_TO, 6,
R_CUBIC_TO, -0.28, 0, -0.54, -0.05, -0.8, -0.15,
R_ARC_TO, 2.02, 2.02, 0, 0, 1, -0.67, -0.5,
R_CUBIC_TO, -0.2, 0.22, -0.43, 0.39, -0.68, 0.5,
R_CUBIC_TO, -0.24, 0.1, -0.51, 0.15, -0.78, 0.15,
R_ARC_TO, 1.87, 1.87, 0, 0, 1, -0.78, -0.17,
ARC_TO, 2.33, 2.33, 0, 0, 1, 7, 5.35,
R_ARC_TO, 1.9, 1.9, 0, 0, 1, -0.67, 0.48,
R_ARC_TO, 1.99, 1.99, 0, 0, 1, -0.8, 0.17,
R_CUBIC_TO, -0.28, 0, -0.54, -0.04, -0.78, -0.13,
R_ARC_TO, 1.83, 1.83, 0, 0, 1, -0.68, -0.52,
R_ARC_TO, 2.28, 2.28, 0, 0, 1, -0.73, 0.52,
ARC_TO, 2.04, 2.04, 0, 0, 1, 2.6, 6,
R_V_LINE_TO, 4.4,
CLOSE,
R_MOVE_TO, 8.8, 0,
H_LINE_TO, 2.6,
R_CUBIC_TO, 0.03, 0, 0.03, 0, 0, 0,
R_CUBIC_TO, -0.02, 0, -0.02, 0, 0, 0,
H_LINE_TO, 11.4,
R_H_LINE_TO, -0.02,
R_H_LINE_TO, 0.02,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStorefrontRepList, kStorefrontIcon, {kStorefrontPath})
VECTOR_ICON_REP_TEMPLATE(kSubmenuArrowPath, CANVAS_DIMENSIONS, 16,
FLIPS_IN_RTL,
MOVE_TO, 3, 16,
R_LINE_TO, 11, -8,
LINE_TO, 3, 0,
R_V_LINE_TO, 16,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSubmenuArrow8Path, CANVAS_DIMENSIONS, 8,
FLIPS_IN_RTL,
MOVE_TO, 2, 8,
R_LINE_TO, 5, -4,
R_LINE_TO, -5, -4,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSubmenuArrowRepList, kSubmenuArrowIcon, {kSubmenuArrowPath}, {kSubmenuArrow8Path})
VECTOR_ICON_REP_TEMPLATE(kSubmenuArrowChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FLIPS_IN_RTL,
R_MOVE_TO, 6.4, 12.13,
R_LINE_TO, -0.98, -0.98,
LINE_TO, 8.57, 8,
LINE_TO, 5.42, 4.85,
R_LINE_TO, 0.98, -0.98,
LINE_TO, 10.53, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSubmenuArrowChromeRefreshRepList, kSubmenuArrowChromeRefreshIcon, {kSubmenuArrowChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSyncPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 3.27,
V_LINE_TO, 1.5,
LINE_TO, 5.5, 3.86,
LINE_TO, 8, 6.23,
V_LINE_TO, 4.46,
R_CUBIC_TO, 2.07, 0, 3.75, 1.59, 3.75, 3.55,
R_CUBIC_TO, 0, 0.6, -0.16, 1.16, -0.44, 1.66,
R_LINE_TO, 0.91, 0.86,
CUBIC_TO, 12.71, 9.79, 13, 8.93, 13, 8,
R_CUBIC_TO, 0, -2.61, -2.24, -4.73, -5, -4.73,
CLOSE,
R_MOVE_TO, 0, 8.27,
R_CUBIC_TO, -2.07, 0, -3.75, -1.59, -3.75, -3.54,
R_CUBIC_TO, 0, -0.6, 0.16, -1.16, 0.44, -1.65,
R_LINE_TO, -0.91, -0.86,
CUBIC_TO, 3.29, 6.21, 3, 7.07, 3, 8,
R_CUBIC_TO, 0, 2.61, 2.24, 4.73, 5, 4.73,
V_LINE_TO, 14.5,
R_LINE_TO, 2.5, -2.36,
LINE_TO, 8, 9.77,
R_V_LINE_TO, 1.77,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncRepList, kSyncIcon, {kSyncPath})
VECTOR_ICON_REP_TEMPLATE(kSyncChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 16,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 1.54,
R_ARC_TO, 6.27, 6.27, 0, 0, 1, -1.49, -1.99,
ARC_TO, 5.78, 5.78, 0, 0, 1, 4, 10,
R_CUBIC_TO, 0, -1.4, 0.42, -2.64, 1.27, -3.7,
ARC_TO, 5.92, 5.92, 0, 0, 1, 8.5, 4.21,
V_LINE_TO, 5.77,
R_CUBIC_TO, -0.87, 0.32, -1.59, 0.86, -2.16, 1.62,
CUBIC_TO, 5.78, 8.14, 5.5, 9.02, 5.5, 10,
R_CUBIC_TO, 0, 0.67, 0.14, 1.29, 0.41, 1.86,
ARC_TO, 4.5, 4.5, 0, 0, 0, 7, 13.31,
V_LINE_TO, 12,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 7, -0.21,
V_LINE_TO, 14.23,
R_ARC_TO, 4.61, 4.61, 0, 0, 0, 2.16, -1.62,
R_CUBIC_TO, 0.56, -0.75, 0.84, -1.63, 0.84, -2.61,
R_CUBIC_TO, 0, -0.67, -0.14, -1.28, -0.41, -1.85,
ARC_TO, 4.5, 4.5, 0, 0, 0, 13, 6.69,
V_LINE_TO, 8,
R_H_LINE_TO, -1.5,
V_LINE_TO, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -1.54,
R_ARC_TO, 6.27, 6.27, 0, 0, 1, 1.49, 1.99,
R_CUBIC_TO, 0.37, 0.77, 0.55, 1.61, 0.55, 2.51,
R_CUBIC_TO, 0, 1.4, -0.42, 2.64, -1.27, 3.7,
R_ARC_TO, 5.92, 5.92, 0, 0, 1, -3.23, 2.09,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSyncChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.62, 12.99,
R_V_LINE_TO, -1.34,
R_H_LINE_TO, 0.93,
R_LINE_TO, 0.12, 0.09,
R_ARC_TO, 5.92, 5.92, 0, 0, 1, -1.23, -1.68,
ARC_TO, 4.62, 4.62, 0, 0, 1, 2.96, 8,
R_CUBIC_TO, 0, -1.22, 0.39, -2.29, 1.17, -3.2,
R_ARC_TO, 5.07, 5.07, 0, 0, 1, 2.91, -1.73,
R_V_LINE_TO, 1.68,
R_CUBIC_TO, -0.71, 0.2, -1.29, 0.59, -1.75, 1.19,
ARC_TO, 3.28, 3.28, 0, 0, 0, 4.6, 8,
R_CUBIC_TO, 0, 0.5, 0.11, 0.96, 0.31, 1.38,
R_CUBIC_TO, 0.21, 0.43, 0.48, 0.8, 0.82, 1.11,
R_LINE_TO, -0.07, -0.07,
R_V_LINE_TO, -0.81,
R_H_LINE_TO, 1.34,
R_V_LINE_TO, 3.39,
CLOSE,
R_MOVE_TO, 5.35, -0.06,
R_V_LINE_TO, -1.68,
R_CUBIC_TO, 0.71, -0.2, 1.29, -0.59, 1.75, -1.19,
ARC_TO, 3.28, 3.28, 0, 0, 0, 11.4, 8,
R_CUBIC_TO, 0, -0.5, -0.1, -0.96, -0.31, -1.38,
R_ARC_TO, 3.57, 3.57, 0, 0, 0, -0.82, -1.1,
R_LINE_TO, 0.07, 0.07,
R_V_LINE_TO, 0.81,
R_H_LINE_TO, -1.34,
V_LINE_TO, 3.01,
R_H_LINE_TO, 3.38,
R_V_LINE_TO, 1.34,
R_H_LINE_TO, -0.93,
R_LINE_TO, -0.12, -0.09,
R_CUBIC_TO, 0.52, 0.47, 0.93, 1.03, 1.24, 1.67,
R_CUBIC_TO, 0.31, 0.64, 0.46, 1.33, 0.46, 2.07,
R_CUBIC_TO, 0, 1.22, -0.39, 2.29, -1.16, 3.2,
R_ARC_TO, 5.07, 5.07, 0, 0, 1, -2.91, 1.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncChromeRefreshRepList, kSyncChromeRefreshIcon, {kSyncChromeRefreshPath}, {kSyncChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kSyncOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16, 17.06,
R_LINE_TO, -2.98, -2.98,
R_CUBIC_TO, -0.23, 0.14, -0.48, 0.27, -0.73, 0.39,
R_CUBIC_TO, -0.25, 0.12, -0.52, 0.21, -0.79, 0.28,
R_V_LINE_TO, -1.58,
R_CUBIC_TO, 0.07, -0.03, 0.14, -0.06, 0.21, -0.09,
R_CUBIC_TO, 0.07, -0.04, 0.14, -0.07, 0.21, -0.09,
LINE_TO, 5.96, 7,
R_ARC_TO, 5.21, 5.21, 0, 0, 0, -0.33, 0.93,
ARC_TO, 4.15, 4.15, 0, 0, 0, 5.5, 8.94,
R_CUBIC_TO, 0, 0.67, 0.14, 1.29, 0.41, 1.86,
ARC_TO, 4.5, 4.5, 0, 0, 0, 7, 12.25,
R_V_LINE_TO, -1.31,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 4,
R_H_LINE_TO, -4,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 1.54,
R_ARC_TO, 6.27, 6.27, 0, 0, 1, -1.49, -1.99,
ARC_TO, 5.78, 5.78, 0, 0, 1, 4, 8.94,
R_CUBIC_TO, 0, -0.56, 0.07, -1.09, 0.22, -1.61,
R_CUBIC_TO, 0.14, -0.51, 0.35, -0.99, 0.61, -1.44,
LINE_TO, 1.88, 2.92,
R_LINE_TO, 1.06, -1.06,
LINE_TO, 17.06, 16,
CLOSE,
R_MOVE_TO, -0.83, -5.08,
R_LINE_TO, -1.12, -1.12,
R_CUBIC_TO, 0.14, -0.29, 0.25, -0.6, 0.33, -0.92,
R_ARC_TO, 4.33, 4.33, 0, 0, 0, -0.28, -2.86,
ARC_TO, 4.43, 4.43, 0, 0, 0, 13, 5.61,
R_V_LINE_TO, 1.33,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -1.54,
R_ARC_TO, 6.27, 6.27, 0, 0, 1, 1.49, 1.99,
R_CUBIC_TO, 0.37, 0.77, 0.55, 1.61, 0.55, 2.51,
R_CUBIC_TO, 0, 0.56, -0.07, 1.09, -0.22, 1.61,
R_ARC_TO, 6.11, 6.11, 0, 0, 1, -0.61, 1.44,
CLOSE,
MOVE_TO, 8.08, 4.89,
LINE_TO, 6.98, 3.77,
R_CUBIC_TO, 0.24, -0.14, 0.48, -0.26, 0.73, -0.37,
R_CUBIC_TO, 0.25, -0.11, 0.52, -0.2, 0.79, -0.27,
R_V_LINE_TO, 1.58,
R_CUBIC_TO, -0.07, 0.03, -0.14, 0.06, -0.21, 0.09,
R_CUBIC_TO, -0.07, 0.04, -0.14, 0.07, -0.21, 0.09,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSyncOffChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 12.77, 13.69,
R_LINE_TO, -2.34, -2.34,
R_CUBIC_TO, -0.21, 0.13, -0.43, 0.24, -0.65, 0.34,
R_CUBIC_TO, -0.23, 0.1, -0.46, 0.18, -0.71, 0.24,
R_V_LINE_TO, -1.45,
R_CUBIC_TO, 0.06, -0.02, 0.11, -0.05, 0.17, -0.07,
R_CUBIC_TO, 0.06, -0.03, 0.11, -0.05, 0.17, -0.07,
LINE_TO, 4.79, 5.69,
R_ARC_TO, 3.69, 3.69, 0, 0, 0, -0.24, 0.7,
R_CUBIC_TO, -0.06, 0.24, -0.09, 0.5, -0.09, 0.76,
R_CUBIC_TO, 0, 0.52, 0.11, 1, 0.32, 1.44,
R_CUBIC_TO, 0.21, 0.45, 0.5, 0.82, 0.85, 1.14,
R_LINE_TO, -0.03, -0.03,
R_V_LINE_TO, -0.95,
R_H_LINE_TO, 1.26,
R_V_LINE_TO, 3.28,
R_H_LINE_TO, -3.28,
V_LINE_TO, 10.77,
R_H_LINE_TO, 1.11,
R_LINE_TO, 0.05, 0.04,
R_ARC_TO, 5.13, 5.13, 0, 0, 1, -1.21, -1.62,
R_ARC_TO, 4.72, 4.72, 0, 0, 1, -0.45, -2.04,
R_CUBIC_TO, 0, -0.45, 0.06, -0.89, 0.18, -1.31,
R_CUBIC_TO, 0.12, -0.42, 0.29, -0.81, 0.5, -1.17,
LINE_TO, 1.47, 2.38,
R_LINE_TO, 0.89, -0.89,
R_LINE_TO, 11.3, 11.32,
CLOSE,
R_MOVE_TO, -0.58, -4.07,
R_LINE_TO, -1.04, -1.04,
R_ARC_TO, 3.39, 3.39, 0, 0, 0, 0.25, -0.68,
R_ARC_TO, 3.37, 3.37, 0, 0, 0, -0.23, -2.2,
R_ARC_TO, 3.53, 3.53, 0, 0, 0, -0.85, -1.15,
R_LINE_TO, 0.03, 0.03,
R_V_LINE_TO, 0.97,
H_LINE_TO, 9.09,
V_LINE_TO, 2.27,
R_H_LINE_TO, 3.28,
V_LINE_TO, 3.53,
R_H_LINE_TO, -1.1,
R_LINE_TO, -0.05, -0.04,
R_CUBIC_TO, 0.51, 0.46, 0.91, 1, 1.21, 1.63,
R_CUBIC_TO, 0.3, 0.63, 0.45, 1.31, 0.45, 2.04,
R_CUBIC_TO, 0, 0.45, -0.06, 0.89, -0.18, 1.31,
R_ARC_TO, 4.65, 4.65, 0, 0, 1, -0.5, 1.17,
CLOSE,
MOVE_TO, 6.54, 3.97,
R_LINE_TO, -1.02, -1.03,
R_CUBIC_TO, 0.21, -0.12, 0.42, -0.23, 0.65, -0.33,
R_CUBIC_TO, 0.22, -0.1, 0.46, -0.17, 0.7, -0.23,
R_V_LINE_TO, 1.45,
R_CUBIC_TO, -0.05, 0.02, -0.11, 0.04, -0.17, 0.07,
R_ARC_TO, 1.48, 1.48, 0, 0, 1, -0.16, 0.07,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncOffChromeRefreshRepList, kSyncOffChromeRefreshIcon, {kSyncOffChromeRefreshPath}, {kSyncOffChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kSyncProblemChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.75, 12.88,
V_LINE_TO, 11.62,
R_H_LINE_TO, 1.11,
R_LINE_TO, 0.05, 0.04,
R_ARC_TO, 5.3, 5.3, 0, 0, 1, -1.21, -1.63,
R_CUBIC_TO, -0.3, -0.62, -0.45, -1.3, -0.45, -2.03,
R_CUBIC_TO, 0, -1.16, 0.36, -2.18, 1.07, -3.06,
R_ARC_TO, 4.88, 4.88, 0, 0, 1, 2.72, -1.7,
R_V_LINE_TO, 1.43,
R_ARC_TO, 3.46, 3.46, 0, 0, 0, -1.73, 1.25,
ARC_TO, 3.36, 3.36, 0, 0, 0, 3.63, 8,
R_CUBIC_TO, 0, 0.52, 0.11, 1, 0.32, 1.44,
R_CUBIC_TO, 0.21, 0.45, 0.5, 0.83, 0.85, 1.14,
R_LINE_TO, -0.03, -0.03,
V_LINE_TO, 9.6,
R_H_LINE_TO, 1.26,
R_V_LINE_TO, 3.28,
CLOSE,
MOVE_TO, 8, 11.25,
R_ARC_TO, 0.62, 0.62, 0, 0, 1, -0.46, -0.19,
R_ARC_TO, 0.61, 0.61, 0, 0, 1, -0.19, -0.46,
ARC_TO, 0.64, 0.64, 0, 0, 1, 8, 9.95,
R_CUBIC_TO, 0.18, 0, 0.33, 0.06, 0.46, 0.19,
R_ARC_TO, 0.61, 0.61, 0, 0, 1, 0.19, 0.46,
R_ARC_TO, 0.64, 0.64, 0, 0, 1, -0.65, 0.65,
CLOSE,
R_MOVE_TO, -0.63, -2.41,
V_LINE_TO, 4.74,
R_H_LINE_TO, 1.27,
R_V_LINE_TO, 4.09,
CLOSE,
R_MOVE_TO, 2.59, 3.93,
R_V_LINE_TO, -1.43,
R_ARC_TO, 3.46, 3.46, 0, 0, 0, 1.73, -1.25,
R_CUBIC_TO, 0.45, -0.6, 0.68, -1.29, 0.68, -2.07,
R_CUBIC_TO, 0, -0.52, -0.1, -1, -0.32, -1.44,
R_ARC_TO, 3.54, 3.54, 0, 0, 0, -0.85, -1.14,
R_LINE_TO, 0.03, 0.03,
R_V_LINE_TO, 0.95,
H_LINE_TO, 9.97,
V_LINE_TO, 3.12,
R_H_LINE_TO, 3.28,
V_LINE_TO, 4.38,
R_H_LINE_TO, -1.1,
R_LINE_TO, -0.05, -0.04,
R_CUBIC_TO, 0.51, 0.45, 0.91, 1, 1.21, 1.63,
R_CUBIC_TO, 0.3, 0.63, 0.45, 1.31, 0.45, 2.04,
R_CUBIC_TO, 0, 1.16, -0.35, 2.18, -1.07, 3.06,
R_ARC_TO, 4.88, 4.88, 0, 0, 1, -2.72, 1.7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncProblemChromeRefreshRepList, kSyncProblemChromeRefreshIcon, {kSyncProblemChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSyncSavedLocallyPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 9.11, 11.63,
R_LINE_TO, 4.6, -4.61,
R_LINE_TO, -1.14, -1.12,
R_LINE_TO, -3.46, 3.46,
R_LINE_TO, -1.69, -1.69,
LINE_TO, 6.27, 8.79,
CLOSE,
MOVE_TO, 1, 17,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 18,
V_LINE_TO, 17,
CLOSE,
R_MOVE_TO, 2.5, -2.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 13,
V_LINE_TO, 4.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 3,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 13,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -1.06, 0.44,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 13,
V_LINE_TO, 4.5,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 4.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncSavedLocallyRepList, kSyncSavedLocallyIcon, {kSyncSavedLocallyPath})
VECTOR_ICON_REP_TEMPLATE(kSyncSavedLocallyOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.61f, 14.5f,
LINE_TO, 15.13f, 13,
LINE_TO, 16.5f, 13,
LINE_TO, 16.5f, 4.5f,
LINE_TO, 6.63f, 4.5f,
LINE_TO, 5.13f, 3,
LINE_TO, 16.5f, 3,
CUBIC_TO, 16.91f, 3, 17.27f, 3.15f, 17.56f, 3.44f,
CUBIC_TO, 17.85f, 3.73f, 18, 4.09f, 18, 4.5f,
LINE_TO, 18, 13,
CUBIC_TO, 18, 13.38f, 17.87f, 13.72f, 17.61f, 14.01f,
CUBIC_TO, 17.34f, 14.29f, 17.01f, 14.46f, 16.61f, 14.5f,
CLOSE,
MOVE_TO, 16.73f, 18.83f,
LINE_TO, 14.88f, 17,
LINE_TO, 1, 17,
LINE_TO, 1, 15.5f,
LINE_TO, 13.38f, 15.5f,
LINE_TO, 12.38f, 14.5f,
LINE_TO, 3.5f, 14.5f,
CUBIC_TO, 3.09f, 14.5f, 2.73f, 14.35f, 2.44f, 14.06f,
CUBIC_TO, 2.15f, 13.77f, 2, 13.41f, 2, 13,
LINE_TO, 2, 4.5f,
CUBIC_TO, 2, 4.45f, 2, 4.39f, 2.01f, 4.33f,
CUBIC_TO, 2.02f, 4.28f, 2.03f, 4.22f, 2.04f, 4.17f,
LINE_TO, 1.17f, 3.29f,
LINE_TO, 2.23f, 2.23f,
LINE_TO, 17.77f, 17.79f,
CLOSE,
MOVE_TO, 10.88f, 13,
LINE_TO, 3.5f, 5.63f,
LINE_TO, 3.5f, 13,
CLOSE,
MOVE_TO, 10.88f, 8.75f,
CLOSE,
MOVE_TO, 7.19f, 9.31f,
CLOSE,
MOVE_TO, 10.29f, 8.17f,
LINE_TO, 12.56f, 5.89f,
LINE_TO, 13.71f, 7.02f,
LINE_TO, 11.44f, 9.29f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncSavedLocallyOffRepList, kSyncSavedLocallyOffIcon, {kSyncSavedLocallyOffPath})
VECTOR_ICON_REP_TEMPLATE(kTabSearchPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 4, 20,
CUBIC_TO, 3.45f, 20, 2.98f, 19.8f, 2.59f, 19.41f,
CUBIC_TO, 2.2f, 19.02f, 2, 18.55f, 2, 18,
LINE_TO, 2, 6,
CUBIC_TO, 2, 5.45f, 2.2f, 4.98f, 2.59f, 4.59f,
CUBIC_TO, 2.98f, 4.2f, 3.45f, 4, 4, 4,
LINE_TO, 20, 4,
CUBIC_TO, 20.55f, 4, 21.02f, 4.2f, 21.41f, 4.59f,
CUBIC_TO, 21.8f, 4.98f, 22, 5.45f, 22, 6,
LINE_TO, 22, 10,
LINE_TO, 13, 10,
LINE_TO, 13, 6,
LINE_TO, 4, 6,
LINE_TO, 4, 18,
LINE_TO, 10, 18,
LINE_TO, 10, 20,
CLOSE,
MOVE_TO, 4, 18,
LINE_TO, 4, 9,
LINE_TO, 4, 10,
LINE_TO, 4, 6,
CLOSE,
MOVE_TO, 21.6f, 22,
LINE_TO, 18.9f, 19.3f,
CUBIC_TO, 18.54f, 19.52f, 18.15f, 19.69f, 17.75f, 19.81f,
CUBIC_TO, 17.35f, 19.94f, 16.93f, 20, 16.5f, 20,
CUBIC_TO, 15.25f, 20, 14.19f, 19.56f, 13.31f, 18.69f,
CUBIC_TO, 12.44f, 17.81f, 12, 16.75f, 12, 15.5f,
CUBIC_TO, 12, 14.25f, 12.44f, 13.19f, 13.31f, 12.31f,
CUBIC_TO, 14.19f, 11.44f, 15.25f, 11, 16.5f, 11,
CUBIC_TO, 17.75f, 11, 18.81f, 11.44f, 19.69f, 12.31f,
CUBIC_TO, 20.56f, 13.19f, 21, 14.25f, 21, 15.5f,
CUBIC_TO, 21, 15.93f, 20.94f, 16.35f, 20.81f, 16.75f,
CUBIC_TO, 20.69f, 17.15f, 20.52f, 17.54f, 20.3f, 17.9f,
LINE_TO, 23, 20.6f,
CLOSE,
MOVE_TO, 16.5f, 18,
CUBIC_TO, 17.2f, 18, 17.79f, 17.76f, 18.27f, 17.27f,
CUBIC_TO, 18.76f, 16.79f, 19, 16.2f, 19, 15.5f,
CUBIC_TO, 19, 14.8f, 18.76f, 14.21f, 18.27f, 13.73f,
CUBIC_TO, 17.79f, 13.24f, 17.2f, 13, 16.5f, 13,
CUBIC_TO, 15.8f, 13, 15.21f, 13.24f, 14.73f, 13.73f,
CUBIC_TO, 14.24f, 14.21f, 14, 14.8f, 14, 15.5f,
CUBIC_TO, 14, 16.2f, 14.24f, 16.79f, 14.73f, 17.27f,
CUBIC_TO, 15.21f, 17.76f, 15.8f, 18, 16.5f, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabSearchRepList, kTabSearchIcon, {kTabSearchPath})
VECTOR_ICON_REP_TEMPLATE(kTenancyPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 3.5, 17,
R_QUADRATIC_TO, -1.04, 0, -1.77, -0.73,
QUADRATIC_TO, 1, 15.54, 1, 14.5,
R_QUADRATIC_TO, 0, -1.04, 0.73, -1.77,
QUADRATIC_TO, 2.46, 12, 3.5, 12,
R_QUADRATIC_TO, 0.29, 0, 0.57, 0.06,
R_QUADRATIC_TO, 0.28, 0.06, 0.53, 0.19,
R_LINE_TO, 3.13, -4.29,
R_QUADRATIC_TO, -0.35, -0.4, -0.54, -0.9,
QUADRATIC_TO, 7, 6.56, 7, 6,
R_QUADRATIC_TO, 0, -1.25, 0.88, -2.12,
QUADRATIC_TO_SHORTHAND, 10, 3,
R_QUADRATIC_TO, 1.25, 0, 2.13, 0.88,
QUADRATIC_TO_SHORTHAND, 13, 6,
R_QUADRATIC_TO, 0, 0.56, -0.19, 1.06,
R_QUADRATIC_TO, -0.19, 0.5, -0.54, 0.9,
R_LINE_TO, 3.13, 4.29,
R_QUADRATIC_TO, 0.25, -0.12, 0.53, -0.19,
R_QUADRATIC_TO, 0.28, -0.06, 0.57, -0.06,
R_QUADRATIC_TO, 1.04, 0, 1.77, 0.73,
R_QUADRATIC_TO, 0.73, 0.73, 0.73, 1.77,
R_QUADRATIC_TO, 0, 1.04, -0.73, 1.77,
QUADRATIC_TO, 17.54, 17, 16.5, 17,
R_QUADRATIC_TO, -1.04, 0, -1.77, -0.73,
QUADRATIC_TO, 14, 15.54, 14, 14.5,
R_QUADRATIC_TO, 0, -0.33, 0.08, -0.62,
R_QUADRATIC_TO, 0.08, -0.29, 0.23, -0.56,
R_LINE_TO, -3.27, -4.5,
R_QUADRATIC_TO, -0.08, 0.04, -0.15, 0.05,
R_QUADRATIC_TO, -0.06, 0.01, -0.15, 0.03,
R_V_LINE_TO, 3.23,
R_QUADRATIC_TO, 0.77, 0.23, 1.26, 0.88,
R_QUADRATIC_TO, 0.49, 0.65, 0.49, 1.5,
R_QUADRATIC_TO, 0, 1.04, -0.73, 1.77,
QUADRATIC_TO, 11.04, 17, 10, 17,
R_QUADRATIC_TO, -1.04, 0, -1.77, -0.73,
QUADRATIC_TO, 7.5, 15.54, 7.5, 14.5,
R_QUADRATIC_TO, 0, -0.85, 0.49, -1.5,
R_QUADRATIC_TO, 0.49, -0.65, 1.26, -0.87,
V_LINE_TO, 8.9,
R_QUADRATIC_TO, -0.08, -0.02, -0.16, -0.03,
R_QUADRATIC_TO, -0.07, -0.01, -0.14, -0.05,
R_LINE_TO, -3.25, 4.5,
R_QUADRATIC_TO, 0.15, 0.27, 0.22, 0.56,
R_QUADRATIC_TO, 0.07, 0.29, 0.07, 0.63,
R_QUADRATIC_TO, 0, 1.04, -0.73, 1.77,
QUADRATIC_TO, 4.54, 17, 3.5, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTenancyRepList, kTenancyIcon, {kTenancyPath})
VECTOR_ICON_REP_TEMPLATE(kThumbDownPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 6, 3,
R_H_LINE_TO, 11,
R_V_LINE_TO, 13,
R_LINE_TO, -7, 7,
R_LINE_TO, -1.25, -1.25,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -0.3, -0.47,
R_CUBIC_TO, -0.07, -0.2, -0.1, -0.39, -0.1, -0.57,
R_V_LINE_TO, -0.35,
LINE_TO, 9.45, 16,
H_LINE_TO, 3,
R_CUBIC_TO, -0.53, 0, -1, -0.2, -1.4, -0.6,
R_CUBIC_TO, -0.4, -0.4, -0.6, -0.87, -0.6, -1.4,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0, -0.12, 0.02, -0.24, 0.05, -0.37,
R_CUBIC_TO, 0.03, -0.13, 0.07, -0.26, 0.1, -0.37,
R_LINE_TO, 3, -7.05,
R_CUBIC_TO, 0.15, -0.33, 0.4, -0.62, 0.75, -0.85,
CUBIC_TO, 5.25, 3.12, 5.62, 3, 6, 3,
CLOSE,
R_MOVE_TO, 9, 2,
H_LINE_TO, 6,
R_LINE_TO, -3, 7,
R_V_LINE_TO, 2,
R_H_LINE_TO, 9,
R_LINE_TO, -1.35, 5.5,
LINE_TO, 15, 15.15,
V_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 0, 10.15,
V_LINE_TO, 5,
R_V_LINE_TO, 10.15,
CLOSE,
R_MOVE_TO, 2, 0.85,
R_V_LINE_TO, -2,
R_H_LINE_TO, 3,
V_LINE_TO, 5,
R_H_LINE_TO, -3,
V_LINE_TO, 3,
R_H_LINE_TO, 5,
R_V_LINE_TO, 13,
R_H_LINE_TO, -5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kThumbDownRepList, kThumbDownIcon, {kThumbDownPath})
VECTOR_ICON_REP_TEMPLATE(kThumbDownFilledPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 6, 3,
R_H_LINE_TO, 10,
R_V_LINE_TO, 13,
R_LINE_TO, -7, 7,
R_LINE_TO, -1.25, -1.25,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.29, -0.48,
R_ARC_TO, 1.66, 1.66, 0, 0, 1, -0.11, -0.57,
R_V_LINE_TO, -0.35,
LINE_TO, 8.45, 16,
H_LINE_TO, 3,
R_CUBIC_TO, -0.53, 0, -1, -0.2, -1.4, -0.6,
CUBIC_TO, 1.2, 15, 1, 14.54, 1, 14,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0, -0.12, 0.01, -0.24, 0.04, -0.37,
R_CUBIC_TO, 0.02, -0.13, 0.06, -0.26, 0.11, -0.37,
R_LINE_TO, 3, -7.05,
R_CUBIC_TO, 0.15, -0.33, 0.4, -0.62, 0.75, -0.85,
ARC_TO, 1.96, 1.96, 0, 0, 1, 6, 3,
CLOSE,
R_MOVE_TO, 12, 13,
V_LINE_TO, 3,
R_H_LINE_TO, 4,
R_V_LINE_TO, 13,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kThumbDownFilledRepList, kThumbDownFilledIcon, {kThumbDownFilledPath})
VECTOR_ICON_REP_TEMPLATE(kThumbUpPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 18, 21,
H_LINE_TO, 7,
V_LINE_TO, 8,
R_LINE_TO, 7, -7,
R_LINE_TO, 1.25, 1.25,
R_CUBIC_TO, 0.12, 0.12, 0.21, 0.28, 0.28, 0.48,
R_CUBIC_TO, 0.08, 0.2, 0.13, 0.39, 0.13, 0.57,
R_V_LINE_TO, 0.35,
LINE_TO, 14.55, 8,
H_LINE_TO, 21,
R_CUBIC_TO, 0.53, 0, 1, 0.2, 1.4, 0.6,
R_CUBIC_TO, 0.4, 0.4, 0.6, 0.87, 0.6, 1.4,
R_V_LINE_TO, 2,
R_CUBIC_TO, 0, 0.12, -0.02, 0.24, -0.05, 0.38,
R_CUBIC_TO, -0.03, 0.14, -0.07, 0.26, -0.1, 0.38,
R_LINE_TO, -3, 7.05,
R_CUBIC_TO, -0.15, 0.33, -0.4, 0.62, -0.75, 0.85,
R_CUBIC_TO, -0.35, 0.23, -0.72, 0.35, -1.1, 0.35,
CLOSE,
R_MOVE_TO, -9, -2,
R_H_LINE_TO, 9,
R_LINE_TO, 3, -7,
R_V_LINE_TO, -2,
R_H_LINE_TO, -9,
R_LINE_TO, 1.35, -5.5,
LINE_TO, 9, 8.85,
V_LINE_TO, 19,
CLOSE,
MOVE_TO, 9, 8.85,
V_LINE_TO, 19,
V_LINE_TO, 8.85,
CLOSE,
MOVE_TO, 7, 8,
R_V_LINE_TO, 2,
H_LINE_TO, 4,
R_V_LINE_TO, 9,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
H_LINE_TO, 2,
V_LINE_TO, 8,
R_H_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kThumbUpRepList, kThumbUpIcon, {kThumbUpPath})
VECTOR_ICON_REP_TEMPLATE(kThumbUpFilledPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 18, 21,
H_LINE_TO, 8,
V_LINE_TO, 8,
R_LINE_TO, 7, -7,
R_LINE_TO, 1.25, 1.25,
R_CUBIC_TO, 0.12, 0.12, 0.21, 0.27, 0.29, 0.48,
R_CUBIC_TO, 0.07, 0.2, 0.11, 0.39, 0.11, 0.57,
R_V_LINE_TO, 0.35,
LINE_TO, 15.55, 8,
H_LINE_TO, 21,
R_CUBIC_TO, 0.54, 0, 1, 0.2, 1.4, 0.6,
CUBIC_TO, 22.8, 9, 23, 9.47, 23, 10,
R_V_LINE_TO, 2,
R_CUBIC_TO, 0, 0.12, -0.01, 0.24, -0.04, 0.38,
R_ARC_TO, 1.9, 1.9, 0, 0, 1, -0.11, 0.38,
R_LINE_TO, -3, 7.05,
R_ARC_TO, 2.04, 2.04, 0, 0, 1, -0.75, 0.85,
ARC_TO, 1.96, 1.96, 0, 0, 1, 18, 21,
CLOSE,
MOVE_TO, 6, 8,
R_V_LINE_TO, 13,
H_LINE_TO, 2,
V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kThumbUpFilledRepList, kThumbUpFilledIcon, {kThumbUpFilledPath})
VECTOR_ICON_REP_TEMPLATE(kTouchpadMousePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16.5, 20,
CUBIC_TO, 17.46, 20, 18.29, 19.66, 18.98, 18.98,
CUBIC_TO, 19.66, 18.29, 20, 17.46, 20, 16.5,
LINE_TO, 20, 15,
LINE_TO, 13, 15,
LINE_TO, 13, 16.5,
CUBIC_TO, 13, 17.46, 13.34, 18.29, 14.02, 18.98,
CUBIC_TO, 14.71, 19.66, 15.54, 20, 16.5, 20,
CLOSE,
MOVE_TO, 13.02, 13,
LINE_TO, 15.5, 13,
LINE_TO, 15.5, 10.15,
CUBIC_TO, 14.87, 10.33, 14.32, 10.68, 13.86, 11.2,
CUBIC_TO, 13.4, 11.71, 13.13, 12.32, 13.02, 13,
CLOSE,
MOVE_TO, 17.5, 13,
LINE_TO, 19.98, 13,
CUBIC_TO, 19.88, 12.32, 19.6, 11.71, 19.14, 11.2,
CUBIC_TO, 18.68, 10.68, 18.13, 10.33, 17.5, 10.15,
CLOSE,
MOVE_TO, 16.5, 22,
CUBIC_TO, 14.96, 22, 13.67, 21.46, 12.6, 20.4,
CUBIC_TO, 11.54, 19.33, 11, 18.04, 11, 16.5,
LINE_TO, 11, 13.5,
CUBIC_TO, 11, 11.96, 11.54, 10.67, 12.6, 9.6,
CUBIC_TO, 13.67, 8.54, 14.96, 8, 16.5, 8,
CUBIC_TO, 18.04, 8, 19.33, 8.54, 20.4, 9.6,
CUBIC_TO, 21.46, 10.67, 22, 11.96, 22, 13.5,
LINE_TO, 22, 16.5,
CUBIC_TO, 22, 18.04, 21.46, 19.33, 20.4, 20.4,
CUBIC_TO, 19.33, 21.46, 18.04, 22, 16.5, 22,
CLOSE,
MOVE_TO, 4, 18,
LINE_TO, 4, 6,
CLOSE,
MOVE_TO, 4, 20,
CUBIC_TO, 3.45, 20, 2.98, 19.8, 2.59, 19.41,
CUBIC_TO, 2.2, 19.02, 2, 18.55, 2, 18,
LINE_TO, 2, 6,
CUBIC_TO, 2, 5.45, 2.2, 4.98, 2.59, 4.59,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
LINE_TO, 20, 4,
CUBIC_TO, 20.55, 4, 21.02, 4.2, 21.41, 4.59,
CUBIC_TO, 21.8, 4.98, 22, 5.45, 22, 6,
LINE_TO, 22, 8.4,
CUBIC_TO, 21.71, 8.08, 21.41, 7.8, 21.07, 7.54,
CUBIC_TO, 20.74, 7.28, 20.38, 7.05, 20, 6.85,
LINE_TO, 20, 6,
LINE_TO, 4, 6,
LINE_TO, 4, 18,
LINE_TO, 9.15, 18,
CUBIC_TO, 9.23, 18.35, 9.33, 18.69, 9.44, 19.02,
CUBIC_TO, 9.55, 19.36, 9.68, 19.68, 9.85, 20,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTouchpadMouseRepList, kTouchpadMouseIcon, {kTouchpadMousePath})
VECTOR_ICON_REP_TEMPLATE(kTouchpadMouseOffPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 16.5, 15.02,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE,
R_MOVE_TO, 3.98, 8.28,
LINE_TO, 0.68, 3.5,
R_LINE_TO, 1.43, -1.43,
R_LINE_TO, 19.8, 19.8,
CLOSE,
MOVE_TO, 16.5, 15.02,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE,
R_MOVE_TO, 0, 6.98,
R_CUBIC_TO, -1.53, 0, -2.83, -0.53, -3.9, -1.6,
CUBIC_TO, 11.54, 19.33, 11, 18.04, 11, 16.5,
R_V_LINE_TO, -3,
R_CUBIC_TO, 0, -0.38, 0.04, -0.75, 0.11, -1.09,
R_CUBIC_TO, 0.08, -0.34, 0.18, -0.68, 0.31, -1.02,
LINE_TO, 15.02, 15,
H_LINE_TO, 13,
R_V_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.97, 0.34, 1.79, 1.02, 2.48,
ARC_TO, 3.38, 3.38, 0, 0, 0, 16.5, 20,
R_ARC_TO, 3.4, 3.4, 0, 0, 0, 1.36, -0.27,
R_ARC_TO, 3.31, 3.31, 0, 0, 0, 1.11, -0.78,
R_LINE_TO, 1.42, 1.43,
R_CUBIC_TO, -0.5, 0.5, -1.08, 0.9, -1.75, 1.19,
ARC_TO, 5.27, 5.27, 0, 0, 1, 16.5, 22,
CLOSE,
R_MOVE_TO, 5.05, -3.32,
R_LINE_TO, -1.6, -1.6,
R_CUBIC_TO, 0.02, -0.1, 0.03, -0.19, 0.04, -0.28,
R_CUBIC_TO, 0.01, -0.09, 0.01, -0.19, 0.01, -0.29,
V_LINE_TO, 15,
R_H_LINE_TO, -2.12,
LINE_TO, 15.5, 12.63,
R_V_LINE_TO, -2.48,
R_ARC_TO, 3.52, 3.52, 0, 0, 0, -0.81, 0.36,
R_ARC_TO, 3.38, 3.38, 0, 0, 0, -0.71, 0.59,
LINE_TO, 12.55, 9.68,
R_ARC_TO, 5.6, 5.6, 0, 0, 1, 1.76, -1.23,
CUBIC_TO, 14.99, 8.15, 15.72, 8, 16.5, 8,
R_CUBIC_TO, 1.54, 0, 2.83, 0.54, 3.9, 1.6,
CUBIC_TO, 21.47, 10.67, 22, 11.97, 22, 13.5,
R_V_LINE_TO, 3,
R_CUBIC_TO, 0, 0.38, -0.04, 0.76, -0.12, 1.13,
R_ARC_TO, 6.99, 6.99, 0, 0, 1, -0.32, 1.05,
CLOSE,
MOVE_TO, 17.5, 13,
R_H_LINE_TO, 2.48,
R_ARC_TO, 3.39, 3.39, 0, 0, 0, -0.84, -1.8,
R_ARC_TO, 3.44, 3.44, 0, 0, 0, -1.64, -1.05,
CLOSE,
MOVE_TO, 9.93, 9.9,
CLOSE,
R_MOVE_TO, 1.22, -1.62,
CLOSE,
MOVE_TO, 4, 20,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 0.02,
R_LINE_TO, 2, 2,
H_LINE_TO, 4,
R_V_LINE_TO, 12,
R_H_LINE_TO, 5.15,
R_CUBIC_TO, 0.09, 0.35, 0.18, 0.69, 0.29, 1.02,
R_CUBIC_TO, 0.11, 0.34, 0.25, 0.66, 0.41, 0.98,
CLOSE,
MOVE_TO, 22, 8.4,
R_ARC_TO, 6.88, 6.88, 0, 0, 0, -0.93, -0.86,
ARC_TO, 6.79, 6.79, 0, 0, 0, 20, 6.85,
V_LINE_TO, 6,
H_LINE_TO, 8.88,
R_LINE_TO, -2, -2,
H_LINE_TO, 20,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTouchpadMouseOffRepList, kTouchpadMouseOffIcon, {kTouchpadMouseOffPath})
VECTOR_ICON_REP_TEMPLATE(kTranslatePath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 10, 18.16,
R_LINE_TO, -1.02, -3.05,
H_LINE_TO, 3.38,
R_ARC_TO, 1.59, 1.59, 0, 0, 1, -1.08, -0.46,
R_ARC_TO, 1.46, 1.46, 0, 0, 1, -0.45, -1.07,
V_LINE_TO, 3.38,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.07,
R_CUBIC_TO, 0.3, -0.3, 0.66, -0.46, 1.08, -0.46,
R_H_LINE_TO, 4.59,
R_LINE_TO, 1.01, 3.05,
R_H_LINE_TO, 7.64,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.07, 0.46,
R_CUBIC_TO, 0.31, 0.3, 0.46, 0.66, 0.46, 1.07,
R_V_LINE_TO, 10.2,
R_CUBIC_TO, 0, 0.43, -0.15, 0.79, -0.46, 1.08,
R_CUBIC_TO, -0.3, 0.3, -0.66, 0.45, -1.07, 0.45,
CLOSE,
MOVE_TO, 5.99, 12.04,
R_CUBIC_TO, 0.81, 0, 1.5, -0.26, 2.07, -0.79,
R_CUBIC_TO, 0.57, -0.53, 0.86, -1.27, 0.86, -2.21,
R_CUBIC_TO, 0, -0.1, 0, -0.2, -0.01, -0.29,
R_ARC_TO, 2.07, 2.07, 0, 0, 0, -0.05, -0.32,
H_LINE_TO, 5.99,
R_V_LINE_TO, 1.04,
R_H_LINE_TO, 1.78,
R_CUBIC_TO, -0.05, 0.47, -0.24, 0.83, -0.58, 1.09,
R_CUBIC_TO, -0.34, 0.26, -0.74, 0.39, -1.21, 0.39,
R_CUBIC_TO, -0.54, 0, -1, -0.19, -1.37, -0.57,
R_ARC_TO, 1.94, 1.94, 0, 0, 1, -0.56, -1.4,
R_CUBIC_TO, 0, -0.54, 0.19, -1, 0.56, -1.39,
R_CUBIC_TO, 0.38, -0.39, 0.83, -0.59, 1.37, -0.59,
R_CUBIC_TO, 0.23, 0, 0.45, 0.04, 0.66, 0.13,
R_ARC_TO, 2, 2, 0, 0, 1, 0.57, 0.36,
R_LINE_TO, 0.81, -0.79,
R_ARC_TO, 2.75, 2.75, 0, 0, 0, -0.96, -0.59,
R_ARC_TO, 3.26, 3.26, 0, 0, 0, -1.09, -0.19,
R_CUBIC_TO, -0.85, 0, -1.58, 0.3, -2.17, 0.89,
R_ARC_TO, 2.95, 2.95, 0, 0, 0, -0.89, 2.17,
R_CUBIC_TO, 0, 0.84, 0.3, 1.57, 0.89, 2.16,
R_CUBIC_TO, 0.59, 0.6, 1.32, 0.9, 2.17, 0.9,
CLOSE,
R_MOVE_TO, 5.39, 0.72,
R_LINE_TO, 0.41, -0.4,
R_ARC_TO, 5.65, 5.65, 0, 0, 1, -0.53, -0.66,
R_ARC_TO, 7.64, 7.64, 0, 0, 1, -0.44, -0.73,
CLOSE,
R_MOVE_TO, 1, -1.04,
R_CUBIC_TO, 0.29, -0.34, 0.55, -0.69, 0.79, -1.07,
R_CUBIC_TO, 0.24, -0.37, 0.42, -0.79, 0.53, -1.24,
R_H_LINE_TO, -3.37,
R_LINE_TO, 0.29, 0.89,
R_LINE_TO, 0.83, -0.02,
R_CUBIC_TO, 0.13, 0.27, 0.26, 0.53, 0.41, 0.77,
R_CUBIC_TO, 0.15, 0.24, 0.32, 0.46, 0.52, 0.68,
CLOSE,
R_MOVE_TO, -1.36, 5.43,
R_H_LINE_TO, 5.61,
R_ARC_TO, 0.52, 0.52, 0, 0, 0, 0.37, -0.14,
R_ARC_TO, 0.5, 0.5, 0, 0, 0, 0.15, -0.37,
R_V_LINE_TO, -10.2,
R_ARC_TO, 0.5, 0.5, 0, 0, 0, -0.52, -0.51,
H_LINE_TO, 9.24,
R_LINE_TO, 0.81, 2.62,
R_H_LINE_TO, 1.7,
R_V_LINE_TO, -0.87,
R_H_LINE_TO, 0.85,
R_V_LINE_TO, 0.87,
R_H_LINE_TO, 3.07,
R_V_LINE_TO, 0.87,
H_LINE_TO, 14.59,
R_ARC_TO, 6.11, 6.11, 0, 0, 1, -0.64, 1.58,
R_CUBIC_TO, -0.29, 0.49, -0.61, 0.95, -0.98, 1.37,
R_LINE_TO, 2.29, 2.25,
R_LINE_TO, -0.61, 0.61,
R_LINE_TO, -2.25, -2.25,
R_LINE_TO, -0.74, 0.73,
R_LINE_TO, 0.76, 2.41,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTranslateRepList, kTranslateIcon, {kTranslatePath})
VECTOR_ICON_REP_TEMPLATE(kUndoPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 229.85, 812.57,
R_V_LINE_TO, -71.25,
R_H_LINE_TO, 348.33,
R_CUBIC_TO, 56.25, 0, 104.66, -18.41, 145.24, -55.23,
R_CUBIC_TO, 40.58, -36.82, 60.87, -82.54, 60.87, -137.17,
R_CUBIC_TO, 0, -54.63, -20.29, -100.35, -60.87, -137.17,
R_CUBIC_TO, -40.58, -36.82, -88.99, -55.22, -145.24, -55.22,
H_LINE_TO, 222.62,
R_LINE_TO, 137.4, 135.39,
R_LINE_TO, -50.62, 49.88,
LINE_TO, 85.21, 320.9,
LINE_TO, 309.4, 100,
R_LINE_TO, 50.62, 49.88,
R_LINE_TO, -137.4, 135.39,
R_H_LINE_TO, 354.36,
R_CUBIC_TO, 76.33, 0, 142.03, 25.33, 197.07, 76.01,
R_CUBIC_TO, 55.04, 50.67, 82.56, 113.22, 82.56, 187.64,
R_CUBIC_TO, 0, 74.43, -27.52, 136.97, -82.56, 187.64,
R_CUBIC_TO, -55.04, 50.67, -120.73, 76.01, -197.06, 76.01,
H_LINE_TO, 229.85,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUndoRepList, kUndoIcon, {kUndoPath})
VECTOR_ICON_REP_TEMPLATE(kUsbPath, MOVE_TO, 30, 14,
R_V_LINE_TO, 8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 4,
R_H_LINE_TO, -6,
V_LINE_TO, 10,
R_H_LINE_TO, 4,
R_LINE_TO, -6, -8,
R_LINE_TO, -6, 8,
R_H_LINE_TO, 4,
R_V_LINE_TO, 16,
R_H_LINE_TO, -6,
R_V_LINE_TO, -4.14,
R_CUBIC_TO, 1.41, -0.73, 2.4, -2.16, 2.4, -3.86,
R_CUBIC_TO, 0, -2.43, -1.97, -4.4, -4.4, -4.4,
R_CUBIC_TO, -2.43, 0, -4.4, 1.97, -4.4, 4.4,
R_CUBIC_TO, 0, 1.7, 0.99, 3.13, 2.4, 3.86,
V_LINE_TO, 26,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6.1,
R_CUBIC_TO, -1.42, 0.73, -2.4, 2.19, -2.4, 3.9,
R_CUBIC_TO, 0, 2.43, 1.97, 4.4, 4.4, 4.4,
R_CUBIC_TO, 2.43, 0, 4.4, -1.97, 4.4, -4.4,
R_CUBIC_TO, 0, -1.71, -0.98, -3.17, -2.4, -3.9,
V_LINE_TO, 30,
R_H_LINE_TO, 6,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -8,
R_H_LINE_TO, -8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUsbRepList, kUsbIcon, {kUsbPath})
VECTOR_ICON_REP_TEMPLATE(kUsbChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_CUBIC_TO, 0, -0.27, 0.07, -0.52, 0.2, -0.75,
R_CUBIC_TO, 0.13, -0.23, 0.32, -0.41, 0.55, -0.54,
V_LINE_TO, 13,
R_H_LINE_TO, -2.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.14, -1.06, -0.44,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -0.44, -1.05,
V_LINE_TO, 9.79,
R_ARC_TO, 1.36, 1.36, 0, 0, 1, -0.55, -0.53,
R_CUBIC_TO, -0.13, -0.23, -0.2, -0.48, -0.2, -0.76,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.46, 1.46, 0, 0, 1, 6, 7,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_CUBIC_TO, 0, 0.28, -0.07, 0.53, -0.2, 0.76,
R_ARC_TO, 1.36, 1.36, 0, 0, 1, -0.55, 0.53,
V_LINE_TO, 11.5,
R_H_LINE_TO, 2.5,
V_LINE_TO, 5,
H_LINE_TO, 7.5,
LINE_TO, 10, 2,
R_LINE_TO, 2.5, 3,
R_H_LINE_TO, -1.75,
R_V_LINE_TO, 6.5,
R_H_LINE_TO, 2.5,
V_LINE_TO, 10,
R_H_LINE_TO, -0.75,
V_LINE_TO, 7,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_H_LINE_TO, -0.75,
R_V_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 13.25, 13,
R_H_LINE_TO, -2.5,
R_V_LINE_TO, 2.21,
R_CUBIC_TO, 0.24, 0.13, 0.42, 0.31, 0.56, 0.53,
R_CUBIC_TO, 0.13, 0.23, 0.2, 0.48, 0.2, 0.76,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUsbChromeRefreshRepList, kUsbChromeRefreshIcon, {kUsbChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kUsbOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 10.87, 13,
R_H_LINE_TO, -0.12,
R_V_LINE_TO, 2.21,
R_CUBIC_TO, 0.24, 0.13, 0.42, 0.3, 0.56, 0.53,
R_CUBIC_TO, 0.13, 0.23, 0.2, 0.49, 0.2, 0.76,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.46, 1.46, 0, 0, 1, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_CUBIC_TO, 0, -0.28, 0.07, -0.53, 0.2, -0.75,
R_ARC_TO, 1.53, 1.53, 0, 0, 1, 0.55, -0.54,
V_LINE_TO, 13,
R_H_LINE_TO, -2.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.14, -1.06, -0.44,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -0.44, -1.05,
V_LINE_TO, 9.79,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, -0.55, -0.53,
R_ARC_TO, 1.54, 1.54, 0, 0, 1, -0.2, -0.77,
R_CUBIC_TO, 0, -0.23, 0.06, -0.46, 0.18, -0.68,
R_CUBIC_TO, 0.12, -0.21, 0.28, -0.4, 0.47, -0.55,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -1.52, -5.77,
R_LINE_TO, -1.23, -1.23,
V_LINE_TO, 10,
R_H_LINE_TO, -0.75,
V_LINE_TO, 7,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_H_LINE_TO, -0.75,
R_V_LINE_TO, 1.5,
R_CUBIC_TO, 0, 0.15, -0.02, 0.31, -0.06, 0.45,
R_ARC_TO, 1.19, 1.19, 0, 0, 1, -0.21, 0.41,
CLOSE,
MOVE_TO, 6.75, 11.5,
R_H_LINE_TO, 2.5,
R_V_LINE_TO, -0.12,
R_LINE_TO, -2.02, -2.02,
R_ARC_TO, 1.31, 1.31, 0, 0, 1, -0.22, 0.24,
R_ARC_TO, 6.41, 6.41, 0, 0, 1, -0.26, 0.2,
CLOSE,
R_MOVE_TO, 4, -2.87,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 5,
H_LINE_TO, 7.5,
LINE_TO, 10, 2,
R_LINE_TO, 2.5, 3,
R_H_LINE_TO, -1.75,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUsbOffChromeRefreshRepList, kUsbOffChromeRefreshIcon, {kUsbOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVideoLibraryPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 9.65, 11.75,
LINE_TO, 14.55, 8.6,
LINE_TO, 9.65, 5.45,
V_LINE_TO, 11.75,
CLOSE,
MOVE_TO, 7.2, 14.2,
CUBIC_TO, 6.82, 14.2, 6.49, 14.06, 6.21, 13.79,
CUBIC_TO, 5.94, 13.51, 5.8, 13.19, 5.8, 12.8,
V_LINE_TO, 4.4,
CUBIC_TO, 5.8, 4.01, 5.94, 3.69, 6.21, 3.41,
CUBIC_TO, 6.49, 3.14, 6.82, 3, 7.2, 3,
H_LINE_TO, 15.6,
CUBIC_TO, 15.99, 3, 16.31, 3.14, 16.59, 3.41,
CUBIC_TO, 16.86, 3.69, 17, 4.01, 17, 4.4,
V_LINE_TO, 12.8,
CUBIC_TO, 17, 13.19, 16.86, 13.51, 16.59, 13.79,
CUBIC_TO, 16.31, 14.06, 15.99, 14.2, 15.6, 14.2,
H_LINE_TO, 7.2,
CLOSE,
MOVE_TO, 7.2, 12.8,
H_LINE_TO, 15.6,
V_LINE_TO, 4.4,
H_LINE_TO, 7.2,
V_LINE_TO, 12.8,
CLOSE,
MOVE_TO, 4.4, 17,
CUBIC_TO, 4.01, 17, 3.69, 16.86, 3.41, 16.59,
CUBIC_TO, 3.14, 16.31, 3, 15.99, 3, 15.6,
V_LINE_TO, 5.8,
H_LINE_TO, 4.4,
V_LINE_TO, 15.6,
H_LINE_TO, 14.2,
V_LINE_TO, 17,
H_LINE_TO, 4.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideoLibraryRepList, kVideoLibraryIcon, {kVideoLibraryPath})
VECTOR_ICON_REP_TEMPLATE(kVideocamPath, MOVE_TO, 34, 21,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
H_LINE_TO, 8,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 20,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 24,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
R_V_LINE_TO, -7,
R_LINE_TO, 8, 8,
V_LINE_TO, 13,
R_LINE_TO, -8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideocamRepList, kVideocamIcon, {kVideocamPath})
VECTOR_ICON_REP_TEMPLATE(kVideocamChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 16,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.45, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 4.5, 4,
R_H_LINE_TO, 9,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 9,
R_LINE_TO, 3, -3,
R_V_LINE_TO, 8,
R_LINE_TO, -3, -3,
R_V_LINE_TO, 3.5,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 9,
R_V_LINE_TO, -9,
R_H_LINE_TO, -9,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideocamChromeRefreshRepList, kVideocamChromeRefreshIcon, {kVideocamChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVideocamOffPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 21, 18,
LINE_TO, 9, 6,
H_LINE_TO, 16,
CUBIC_TO, 16.55, 6, 17, 6.45, 17, 7,
V_LINE_TO, 10.5,
LINE_TO, 21, 6.5,
V_LINE_TO, 18,
CLOSE,
MOVE_TO, 21.8, 21.6,
LINE_TO, 17, 16.8,
LINE_TO, 6.2, 6,
LINE_TO, 2.6, 2.4,
LINE_TO, 1.2, 3.8,
LINE_TO, 3.53, 6.13,
CUBIC_TO, 3.22, 6.3, 3, 6.62, 3, 7,
V_LINE_TO, 17,
CUBIC_TO, 3, 17.55, 3.45, 18, 4, 18,
H_LINE_TO, 15.4,
LINE_TO, 20.4, 23,
LINE_TO, 21.8, 21.6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideocamOffRepList, kVideocamOffIcon, {kVideocamOffPath})
VECTOR_ICON_REP_TEMPLATE(kVideocamOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 18, 13.98,
R_LINE_TO, -3, -3,
R_V_LINE_TO, 1.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 5.5,
H_LINE_TO, 7.63,
LINE_TO, 6.13, 4,
H_LINE_TO, 13.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 3.48,
R_LINE_TO, 3, -3,
CLOSE,
R_MOVE_TO, -1.27, 4.83,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.21,
LINE_TO, 17.79, 17.75,
CLOSE,
MOVE_TO, 10.56, 8.42,
CLOSE,
MOVE_TO, 8.46, 10.52,
CLOSE,
MOVE_TO, 4.04, 4.04,
LINE_TO, 5.5, 5.48,
R_H_LINE_TO, -1,
R_V_LINE_TO, 9.02,
R_H_LINE_TO, 9,
R_V_LINE_TO, -1.04,
R_LINE_TO, 1.5, 1.5,
R_CUBIC_TO, -0.11, 0.28, -0.28, 0.52, -0.52, 0.73,
R_CUBIC_TO, -0.24, 0.21, -0.56, 0.31, -0.98, 0.31,
H_LINE_TO, 4.5,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -1.05, -0.44,
R_CUBIC_TO, -0.3, -0.29, -0.45, -0.65, -0.45, -1.06,
V_LINE_TO, 5.48,
R_CUBIC_TO, 0, -0.35, 0.1, -0.66, 0.3, -0.91,
R_CUBIC_TO, 0.2, -0.25, 0.45, -0.42, 0.74, -0.52,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideocamOffChromeRefreshRepList, kVideocamOffChromeRefreshIcon, {kVideocamOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVideogameAssetPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 21, 6,
H_LINE_TO, 3,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 8,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 18,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 8,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, -10, 7,
H_LINE_TO, 8,
R_V_LINE_TO, 3,
H_LINE_TO, 6,
R_V_LINE_TO, -3,
H_LINE_TO, 3,
R_V_LINE_TO, -2,
R_H_LINE_TO, 3,
V_LINE_TO, 8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4.5, 2,
R_CUBIC_TO, -0.83, 0, -1.5, -0.67, -1.5, -1.5,
R_CUBIC_TO, 0, -0.83, 0.67, -1.5, 1.5, -1.5,
R_CUBIC_TO, 0.83, 0, 1.5, 0.67, 1.5, 1.5,
R_CUBIC_TO, 0, 0.83, -0.67, 1.5, -1.5, 1.5,
CLOSE,
R_MOVE_TO, 4, -3,
R_CUBIC_TO, -0.83, 0, -1.5, -0.67, -1.5, -1.5,
CUBIC_TO_SHORTHAND, 18.67, 9, 19.5, 9,
R_CUBIC_TO, 0.83, 0, 1.5, 0.67, 1.5, 1.5,
R_CUBIC_TO, 0, 0.83, -0.67, 1.5, -1.5, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideogameAssetRepList, kVideogameAssetIcon, {kVideogameAssetPath})
VECTOR_ICON_REP_TEMPLATE(kVideogameAssetChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 15,
R_ARC_TO, 1.42, 1.42, 0, 0, 1, -1.06, -0.45,
ARC_TO, 1.45, 1.45, 0, 0, 1, 2, 13.5,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.44, -1.05,
CUBIC_TO, 2.73, 5.15, 3.09, 5, 3.5, 5,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.45,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.05,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 13,
R_V_LINE_TO, -7,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 2.54, -1,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, -1.75,
R_H_LINE_TO, 1.75,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, -1.75,
V_LINE_TO, 7.5,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, -1.75,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 1.75,
CLOSE,
MOVE_TO, 12, 12.25,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
ARC_TO, 1.22, 1.22, 0, 0, 0, 12, 9.75,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
R_MOVE_TO, 2.5, -2,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
R_ARC_TO, 1.22, 1.22, 0, 0, 0, -0.89, -0.36,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
R_MOVE_TO, -11, 3.25,
R_V_LINE_TO, -7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideogameAssetChromeRefreshRepList, kVideogameAssetChromeRefreshIcon, {kVideogameAssetChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVideogameAssetOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14.5, 10.25,
R_CUBIC_TO, -0.35, 0, -0.64, -0.12, -0.89, -0.36,
ARC_TO, 1.22, 1.22, 0, 0, 1, 13.25, 9,
R_CUBIC_TO, 0, -0.35, 0.12, -0.64, 0.36, -0.89,
R_CUBIC_TO, 0.25, -0.24, 0.54, -0.36, 0.89, -0.36,
R_CUBIC_TO, 0.35, 0, 0.64, 0.12, 0.89, 0.36,
R_CUBIC_TO, 0.24, 0.25, 0.36, 0.54, 0.36, 0.89,
R_CUBIC_TO, 0, 0.35, -0.12, 0.64, -0.36, 0.89,
R_CUBIC_TO, -0.25, 0.24, -0.54, 0.36, -0.89, 0.36,
CLOSE,
R_MOVE_TO, -6.64, -0.17,
CLOSE,
MOVE_TO, 6, 12.5,
R_V_LINE_TO, -1.75,
H_LINE_TO, 4.25,
R_V_LINE_TO, -1.5,
H_LINE_TO, 6,
V_LINE_TO, 7.5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.75,
R_H_LINE_TO, 1.75,
R_V_LINE_TO, 1.5,
H_LINE_TO, 7.5,
R_V_LINE_TO, 1.75,
CLOSE,
MOVE_TO, 3.5, 15,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -0.4, 0.14, -0.75, 0.42, -1.05,
R_CUBIC_TO, 0.28, -0.3, 0.62, -0.45, 1.01, -0.45,
H_LINE_TO, 5,
R_LINE_TO, 1.5, 1.5,
R_H_LINE_TO, -3,
R_V_LINE_TO, 7,
R_H_LINE_TO, 7.88,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
LINE_TO, 16, 18.13,
LINE_TO, 12.88, 15,
CLOSE,
MOVE_TO, 18, 13.5,
R_CUBIC_TO, 0, 0.32, -0.08, 0.61, -0.25, 0.86,
R_CUBIC_TO, -0.17, 0.25, -0.41, 0.43, -0.73, 0.54,
R_LINE_TO, -0.52, -0.52,
V_LINE_TO, 6.5,
H_LINE_TO, 8.63,
LINE_TO, 7.13, 5,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.4, 0, 0.75, 0.15, 1.05, 0.45,
R_CUBIC_TO, 0.3, 0.3, 0.45, 0.65, 0.45, 1.05,
CLOSE,
R_MOVE_TO, -5.44, -3.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVideogameAssetOffChromeRefreshRepList, kVideogameAssetOffChromeRefreshIcon, {kVideogameAssetOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kViewInArChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 9.25, 16.42,
R_LINE_TO, -4.5, -2.56,
R_ARC_TO, 1.69, 1.69, 0, 0, 1, -0.55, -0.57,
R_ARC_TO, 1.43, 1.43, 0, 0, 1, -0.2, -0.75,
V_LINE_TO, 7.44,
R_CUBIC_TO, 0, -0.27, 0.07, -0.52, 0.2, -0.75,
R_ARC_TO, 1.51, 1.51, 0, 0, 1, 0.56, -0.54,
R_LINE_TO, 4.5, -2.58,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, 0.75, -0.21,
R_CUBIC_TO, 0.27, 0, 0.52, 0.07, 0.75, 0.21,
R_LINE_TO, 4.5, 2.58,
R_CUBIC_TO, 0.24, 0.14, 0.42, 0.32, 0.56, 0.54,
R_CUBIC_TO, 0.13, 0.23, 0.2, 0.48, 0.2, 0.75,
R_V_LINE_TO, 5.13,
R_ARC_TO, 1.4, 1.4, 0, 0, 1, -0.2, 0.73,
R_ARC_TO, 1.71, 1.71, 0, 0, 1, -0.55, 0.56,
R_LINE_TO, -4.5, 2.56,
R_ARC_TO, 1.47, 1.47, 0, 0, 1, -1.5, 0,
CLOSE,
R_MOVE_TO, 0, -1.71,
R_V_LINE_TO, -4.29,
LINE_TO, 5.5, 8.17,
R_V_LINE_TO, 4.39,
CLOSE,
R_MOVE_TO, 1.5, 0,
R_LINE_TO, 3.75, -2.14,
V_LINE_TO, 8.19,
R_LINE_TO, -3.75, 2.25,
CLOSE,
MOVE_TO, 2, 6,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.42, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 2,
H_LINE_TO, 6,
R_V_LINE_TO, 1.5,
H_LINE_TO, 3.5,
V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 4, 12,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.42, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 2.5,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 8, 0,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 2.5,
V_LINE_TO, 14,
H_LINE_TO, 18,
R_V_LINE_TO, 2.5,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 18,
CLOSE,
R_MOVE_TO, 2.5, -12,
V_LINE_TO, 3.5,
H_LINE_TO, 14,
V_LINE_TO, 2,
R_H_LINE_TO, 2.5,
R_CUBIC_TO, 0.42, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 6,
CLOSE,
MOVE_TO, 10, 9.13,
R_LINE_TO, 3.63, -2.17,
LINE_TO, 10, 4.88,
LINE_TO, 6.38, 6.96,
CLOSE,
R_MOVE_TO, 0, 0.83,
CLOSE,
R_MOVE_TO, 0, -0.83,
CLOSE,
R_MOVE_TO, 0.75, 1.31,
CLOSE,
R_MOVE_TO, -1.5, -0.02,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kViewInArChromeRefreshRepList, kViewInArChromeRefreshIcon, {kViewInArChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kViewInArOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 11.33, 9.21,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 5.65, 3.52,
LINE_TO, 6.98, 4.86,
R_LINE_TO, 2.27, -1.29,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, 0.75, -0.21,
R_CUBIC_TO, 0.27, 0, 0.52, 0.07, 0.75, 0.21,
R_LINE_TO, 4.5, 2.58,
ARC_TO, 1.48, 1.48, 0, 0, 1, 16, 7.44,
R_V_LINE_TO, 5.13,
R_CUBIC_TO, 0, 0.18, -0.03, 0.34, -0.1, 0.5,
R_CUBIC_TO, -0.06, 0.16, -0.15, 0.31, -0.26, 0.45,
CLOSE,
MOVE_TO, 9.25, 16.42,
R_LINE_TO, -4.5, -2.56,
R_ARC_TO, 1.68, 1.68, 0, 0, 1, -0.55, -0.56,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -0.2, -0.75,
V_LINE_TO, 7.44,
R_ARC_TO, 1.49, 1.49, 0, 0, 1, 0.75, -1.29,
R_LINE_TO, 0.9, -0.5,
R_LINE_TO, 8.71, 8.71,
R_LINE_TO, -3.6, 2.06,
R_ARC_TO, 1.47, 1.47, 0, 0, 1, -1.5, 0,
CLOSE,
R_MOVE_TO, 1.54, -7.75,
CLOSE,
R_MOVE_TO, -1.54, 1.75,
CLOSE,
R_MOVE_TO, 2.63, -0.67,
CLOSE,
R_MOVE_TO, -1.12, 1,
CLOSE,
MOVE_TO, 8.11, 5.98,
R_LINE_TO, 2.69, 2.69,
R_LINE_TO, 2.83, -1.71,
LINE_TO, 10, 4.88,
CLOSE,
R_MOVE_TO, 1.15, 8.73,
R_V_LINE_TO, -4.29,
LINE_TO, 5.5, 8.17,
R_V_LINE_TO, 4.39,
CLOSE,
R_MOVE_TO, 5.25, -2.33,
V_LINE_TO, 8.19,
LINE_TO, 11.88, 9.75,
CLOSE,
R_MOVE_TO, -3.75, 2.33,
R_LINE_TO, 2.52, -1.44,
R_LINE_TO, -2.52, -2.52,
CLOSE,
R_MOVE_TO, 5.98, 4.13,
LINE_TO, 15.9, 18,
H_LINE_TO, 14,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 0.56,
R_V_LINE_TO, 0.17,
LINE_TO, 3.21, 5.31,
H_LINE_TO, 3.5,
V_LINE_TO, 6,
H_LINE_TO, 2,
V_LINE_TO, 4.11,
R_LINE_TO, -0.83, -0.83,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 18, 14,
R_V_LINE_TO, 1.88,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 14,
CLOSE,
MOVE_TO, 6, 2,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -0.37,
LINE_TO, 4.13, 2,
CLOSE,
R_MOVE_TO, 0, 16,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.42, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 2.5,
H_LINE_TO, 6,
CLOSE,
MOVE_TO, 16.5, 6,
V_LINE_TO, 3.5,
H_LINE_TO, 14,
V_LINE_TO, 2,
R_H_LINE_TO, 2.5,
R_CUBIC_TO, 0.42, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kViewInArOffChromeRefreshRepList, kViewInArOffChromeRefreshIcon, {kViewInArOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVisibilityPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 7,
R_CUBIC_TO, -2.48, 0, -4.5, 2.02, -4.5, 4.5,
CUBIC_TO_SHORTHAND, 9.52, 16, 12, 16,
R_CUBIC_TO, 2.48, 0, 4.5, -2.02, 4.5, -4.5,
CUBIC_TO_SHORTHAND, 14.48, 7, 12, 7,
CLOSE,
R_MOVE_TO, 0, 7.2,
R_CUBIC_TO, -1.49, 0, -2.7, -1.21, -2.7, -2.7,
R_CUBIC_TO, 0, -1.49, 1.21, -2.7, 2.7, -2.7,
R_CUBIC_TO, 1.49, 0, 2.7, 1.21, 2.7, 2.7,
R_CUBIC_TO, 0, 1.49, -1.21, 2.7, -2.7, 2.7,
CLOSE,
MOVE_TO, 12, 4,
CUBIC_TO, 7, 4, 2.73, 7.11, 1, 11.5,
CUBIC_TO, 2.73, 15.89, 7, 19, 12, 19,
R_CUBIC_TO, 5, 0, 9.27, -3.11, 11, -7.5,
CUBIC_TO, 21.27, 7.11, 17, 4, 12, 4,
CLOSE,
R_MOVE_TO, 0, 13,
R_CUBIC_TO, -3.79, 0, -7.17, -2.13, -8.82, -5.5,
CUBIC_TO, 4.83, 8.13, 8.21, 6, 12, 6,
R_CUBIC_TO, 3.79, 0, 7.17, 2.13, 8.82, 5.5,
CUBIC_TO, 19.17, 14.87, 15.79, 17, 12, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVisibilityRepList, kVisibilityIcon, {kVisibilityPath})
VECTOR_ICON_REP_TEMPLATE(kVisibilityOffPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 10.58, 7.25,
R_LINE_TO, 1.56, 1.56,
R_CUBIC_TO, 1.38, 0.07, 2.47, 1.17, 2.54, 2.54,
R_LINE_TO, 1.56, 1.56,
R_CUBIC_TO, 0.16, -0.44, 0.26, -0.91, 0.26, -1.41,
CUBIC_TO, 16.5, 9.02, 14.48, 7, 12, 7,
R_CUBIC_TO, -0.5, 0, -0.97, 0.1, -1.42, 0.25,
CLOSE,
MOVE_TO, 12, 6,
R_CUBIC_TO, 3.79, 0, 7.17, 2.13, 8.82, 5.5,
R_CUBIC_TO, -0.64, 1.32, -1.56, 2.44, -2.66, 3.33,
R_LINE_TO, 1.42, 1.42,
R_CUBIC_TO, 1.51, -1.26, 2.7, -2.89, 3.43, -4.74,
CUBIC_TO, 21.27, 7.11, 17, 4, 12, 4,
R_CUBIC_TO, -1.4, 0, -2.73, 0.25, -3.98, 0.7,
R_LINE_TO, 1.61, 1.6,
CUBIC_TO, 10.4, 6.12, 11.19, 6, 12, 6,
CLOSE,
R_MOVE_TO, 4.43, 9.93,
R_LINE_TO, -1.25, -1.25,
R_LINE_TO, -1.27, -1.27,
R_LINE_TO, -3.82, -3.82,
R_LINE_TO, -1.27, -1.27,
R_LINE_TO, -1.25, -1.25,
R_LINE_TO, -1.48, -1.48,
R_LINE_TO, -2.78, -2.78,
R_LINE_TO, -1.42, 1.41,
R_LINE_TO, 2.53, 2.53,
CUBIC_TO, 2.92, 8.02, 1.73, 9.64, 1, 11.5,
CUBIC_TO, 2.73, 15.89, 7, 19, 12, 19,
R_CUBIC_TO, 1.4, 0, 2.73, -0.25, 3.98, -0.7,
R_LINE_TO, 4.3, 4.3,
R_LINE_TO, 1.41, -1.41,
R_LINE_TO, -3.78, -3.78,
R_LINE_TO, -1.48, -1.48,
CLOSE,
R_MOVE_TO, -4.57, -1.74,
R_CUBIC_TO, -1.38, -0.07, -2.47, -1.17, -2.54, -2.54,
R_LINE_TO, 2.54, 2.54,
CLOSE,
MOVE_TO, 12, 17,
R_CUBIC_TO, -3.79, 0, -7.17, -2.13, -8.82, -5.5,
R_CUBIC_TO, 0.64, -1.32, 1.56, -2.44, 2.66, -3.33,
R_LINE_TO, 1.91, 1.91,
R_CUBIC_TO, -0.15, 0.45, -0.25, 0.92, -0.25, 1.42,
R_CUBIC_TO, 0, 2.48, 2.02, 4.5, 4.5, 4.5,
R_CUBIC_TO, 0.5, 0, 0.97, -0.1, 1.42, -0.25,
R_LINE_TO, 0.95, 0.95,
R_CUBIC_TO, -0.77, 0.18, -1.56, 0.3, -2.37, 0.3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVisibilityOffRepList, kVisibilityOffIcon, {kVisibilityOffPath})
VECTOR_ICON_REP_TEMPLATE(kVolumeOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 16, 18.13,
R_LINE_TO, -2.23, -2.23,
R_ARC_TO, 6.93, 6.93, 0, 0, 1, -1.09, 0.55,
R_CUBIC_TO, -0.42, 0.17, -0.82, 0.3, -1.18, 0.38,
R_V_LINE_TO, -1.54,
R_CUBIC_TO, 0.17, -0.07, 0.36, -0.15, 0.59, -0.24,
R_CUBIC_TO, 0.23, -0.09, 0.42, -0.18, 0.57, -0.26,
LINE_TO, 10, 12.13,
R_V_LINE_TO, 3.9,
R_LINE_TO, -4, -4,
H_LINE_TO, 3,
R_V_LINE_TO, -4,
R_H_LINE_TO, 2.88,
R_LINE_TO, -4, -4.02,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
R_MOVE_TO, -0.12, -4.36,
R_LINE_TO, -1.08, -1.08,
R_CUBIC_TO, 0.22, -0.4, 0.4, -0.83, 0.52, -1.28,
R_CUBIC_TO, 0.12, -0.45, 0.19, -0.91, 0.19, -1.39,
R_ARC_TO, 5.27, 5.27, 0, 0, 0, -1.11, -3.3,
ARC_TO, 5.64, 5.64, 0, 0, 0, 11.5, 4.73,
V_LINE_TO, 3.19,
R_CUBIC_TO, 1.63, 0.32, 2.95, 1.13, 3.97, 2.42,
CUBIC_TO, 16.49, 6.9, 17, 8.37, 17, 10.02,
R_CUBIC_TO, 0, 0.67, -0.1, 1.32, -0.29, 1.95,
R_ARC_TO, 7.31, 7.31, 0, 0, 1, -0.83, 1.8,
CLOSE,
R_MOVE_TO, -2.58, -2.58,
LINE_TO, 11.5, 9.4,
R_V_LINE_TO, -2.54,
R_ARC_TO, 3.21, 3.21, 0, 0, 1, 1.47, 1.28,
R_ARC_TO, 3.51, 3.51, 0, 0, 1, 0.53, 1.88,
R_CUBIC_TO, 0, 0.2, -0.02, 0.39, -0.04, 0.59,
R_ARC_TO, 2.37, 2.37, 0, 0, 1, -0.16, 0.58,
CLOSE,
MOVE_TO, 10, 7.89,
LINE_TO, 8.06, 5.96,
LINE_TO, 10, 4.02,
CLOSE,
R_MOVE_TO, -1.5, 4.5,
R_V_LINE_TO, -1.77,
LINE_TO, 7, 9.13,
R_LINE_TO, -0.37, 0.4,
H_LINE_TO, 4.5,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2.13,
CLOSE,
R_MOVE_TO, -0.75, -2.52,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kVolumeOffChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 12.84, 14.63,
R_LINE_TO, -1.79, -1.8,
R_ARC_TO, 5.1, 5.1, 0, 0, 1, -0.84, 0.41,
R_CUBIC_TO, -0.33, 0.13, -0.63, 0.23, -0.91, 0.29,
R_V_LINE_TO, -1.3,
R_CUBIC_TO, 0.11, -0.05, 0.25, -0.11, 0.41, -0.17,
R_CUBIC_TO, 0.16, -0.07, 0.3, -0.12, 0.41, -0.18,
LINE_TO, 8.1, 9.86,
R_V_LINE_TO, 3.28,
LINE_TO, 4.71, 9.75,
H_LINE_TO, 2.23,
V_LINE_TO, 6.28,
H_LINE_TO, 4.54,
LINE_TO, 1.36, 3.07,
R_LINE_TO, 0.89, -0.89,
R_LINE_TO, 11.48, 11.56,
CLOSE,
R_MOVE_TO, 0, -3.57,
R_LINE_TO, -0.91, -0.92,
R_CUBIC_TO, 0.18, -0.32, 0.32, -0.66, 0.42, -1.02,
R_CUBIC_TO, 0.1, -0.36, 0.15, -0.73, 0.15, -1.1,
R_ARC_TO, 4.2, 4.2, 0, 0, 0, -0.89, -2.63,
R_ARC_TO, 4.57, 4.57, 0, 0, 0, -2.3, -1.6,
V_LINE_TO, 2.48,
R_ARC_TO, 5.31, 5.31, 0, 0, 1, 3.22, 1.96,
R_ARC_TO, 5.6, 5.6, 0, 0, 1, 1.24, 3.58,
R_CUBIC_TO, 0, 0.55, -0.08, 1.07, -0.24, 1.58,
R_CUBIC_TO, -0.16, 0.51, -0.39, 1, -0.68, 1.46,
CLOSE,
MOVE_TO, 10.78, 8.98,
R_LINE_TO, -1.48, -1.49,
V_LINE_TO, 5.43,
R_ARC_TO, 2.82, 2.82, 0, 0, 1, 1.66, 2.58,
R_CUBIC_TO, 0, 0.16, -0.02, 0.33, -0.04, 0.49,
R_ARC_TO, 1.79, 1.79, 0, 0, 1, -0.14, 0.48,
CLOSE,
R_MOVE_TO, -2.68, -2.7,
LINE_TO, 6.42, 4.58,
R_LINE_TO, 1.69, -1.68,
CLOSE,
MOVE_TO, 6.72, 9.8,
V_LINE_TO, 8.46,
LINE_TO, 5.61, 7.35,
R_LINE_TO, -0.3, 0.32,
H_LINE_TO, 3.62,
R_V_LINE_TO, 0.7,
R_H_LINE_TO, 1.67,
CLOSE,
R_MOVE_TO, -0.55, -1.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVolumeOffChromeRefreshRepList, kVolumeOffChromeRefreshIcon, {kVolumeOffChromeRefreshPath}, {kVolumeOffChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kVolumeUpPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2, 5.95,
R_V_LINE_TO, 4.1,
R_H_LINE_TO, 2.67,
LINE_TO, 8, 13.47,
V_LINE_TO, 2.53,
R_LINE_TO, -3.33, 3.42,
H_LINE_TO, 2,
CLOSE,
MOVE_TO, 11, 8,
R_CUBIC_TO, 0, -1.21, -0.68, -2.25, -1.67, -2.76,
R_V_LINE_TO, 5.51,
CUBIC_TO, 10.32, 10.25, 11, 9.21, 11, 8,
CLOSE,
MOVE_TO, 9.33, 2,
R_V_LINE_TO, 1.41,
R_CUBIC_TO, 1.93, 0.59, 3.33, 2.42, 3.33, 4.59,
R_CUBIC_TO, 0, 2.17, -1.41, 4, -3.33, 4.59,
V_LINE_TO, 14,
CUBIC_TO, 12.01, 13.38, 14, 10.93, 14, 8,
R_CUBIC_TO, 0, -2.93, -1.99, -5.38, -4.67, -6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVolumeUpRepList, kVolumeUpIcon, {kVolumeUpPath})
VECTOR_ICON_REP_TEMPLATE(kVolumeUpChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 11.5, 16.83,
V_LINE_TO, 15.27,
R_ARC_TO, 5.18, 5.18, 0, 0, 0, 2.9, -1.94,
R_CUBIC_TO, 0.74, -0.98, 1.11, -2.08, 1.11, -3.32,
R_CUBIC_TO, 0, -1.24, -0.37, -2.34, -1.11, -3.3,
ARC_TO, 5.67, 5.67, 0, 0, 0, 11.5, 4.71,
V_LINE_TO, 3.15,
R_CUBIC_TO, 1.61, 0.35, 2.93, 1.16, 3.96, 2.44,
CUBIC_TO, 16.48, 6.86, 17, 8.33, 17, 9.98,
R_CUBIC_TO, 0, 1.65, -0.51, 3.12, -1.53, 4.41,
R_CUBIC_TO, -1.02, 1.29, -2.34, 2.1, -3.97, 2.44,
CLOSE,
MOVE_TO, 3, 11.98,
R_V_LINE_TO, -4,
R_H_LINE_TO, 3,
R_LINE_TO, 4, -4,
R_V_LINE_TO, 12,
R_LINE_TO, -4, -4,
CLOSE,
R_MOVE_TO, 8.5, 1.15,
V_LINE_TO, 6.83,
R_CUBIC_TO, 0.63, 0.28, 1.12, 0.71, 1.47, 1.28,
R_CUBIC_TO, 0.36, 0.57, 0.53, 1.19, 0.53, 1.88,
R_CUBIC_TO, 0, 0.68, -0.18, 1.29, -0.53, 1.86,
R_ARC_TO, 3.3, 3.3, 0, 0, 1, -1.47, 1.28,
CLOSE,
R_MOVE_TO, -3, -5.52,
LINE_TO, 6.63, 9.48,
H_LINE_TO, 4.5,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2.13,
LINE_TO, 8.5, 12.36,
CLOSE,
MOVE_TO, 6.61, 9.96,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kVolumeUpChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 9.31, 13.54,
R_V_LINE_TO, -1.32,
R_ARC_TO, 4.19, 4.19, 0, 0, 0, 2.31, -1.56,
R_ARC_TO, 4.28, 4.28, 0, 0, 0, 0.89, -2.65,
R_ARC_TO, 4.2, 4.2, 0, 0, 0, -0.89, -2.64,
R_ARC_TO, 4.58, 4.58, 0, 0, 0, -2.3, -1.6,
V_LINE_TO, 2.45,
R_CUBIC_TO, 1.3, 0.28, 2.38, 0.94, 3.21, 1.97,
R_CUBIC_TO, 0.84, 1.03, 1.25, 2.22, 1.25, 3.56,
R_ARC_TO, 5.57, 5.57, 0, 0, 1, -1.24, 3.57,
R_CUBIC_TO, -0.83, 1.04, -1.9, 1.7, -3.21, 1.98,
CLOSE,
MOVE_TO, 2.24, 9.72,
V_LINE_TO, 6.25,
R_H_LINE_TO, 2.48,
R_LINE_TO, 3.39, -3.39,
R_V_LINE_TO, 10.25,
LINE_TO, 4.72, 9.72,
CLOSE,
R_MOVE_TO, 7.07, 0.83,
V_LINE_TO, 5.42,
R_CUBIC_TO, 0.51, 0.23, 0.91, 0.58, 1.21, 1.04,
R_CUBIC_TO, 0.3, 0.46, 0.45, 0.97, 0.45, 1.54,
R_CUBIC_TO, 0, 0.55, -0.15, 1.06, -0.45, 1.52,
R_CUBIC_TO, -0.3, 0.46, -0.7, 0.81, -1.21, 1.04,
CLOSE,
MOVE_TO, 6.72, 6.2,
R_LINE_TO, -1.43, 1.43,
H_LINE_TO, 3.62,
R_V_LINE_TO, 0.7,
H_LINE_TO, 5.29,
LINE_TO, 6.72, 9.77,
CLOSE,
MOVE_TO, 5.25, 7.97,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVolumeUpChromeRefreshRepList, kVolumeUpChromeRefreshIcon, {kVolumeUpChromeRefreshPath}, {kVolumeUpChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kVrHeadsetPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20.91, 6.68,
ARC_TO, 2.54, 2.54, 0, 0, 0, 19.16, 6,
H_LINE_TO, 4.9,
R_CUBIC_TO, -0.66, 0, -1.28, 0.24, -1.75, 0.68,
R_ARC_TO, 2.23, 2.23, 0, 0, 0, -0.72, 1.64,
R_V_LINE_TO, 7.37,
R_CUBIC_TO, 0, 0.62, 0.26, 1.2, 0.72, 1.64,
ARC_TO, 2.54, 2.54, 0, 0, 0, 4.9, 18,
R_H_LINE_TO, 3.42,
R_CUBIC_TO, 0.45, 0, 0.88, -0.11, 1.27, -0.33,
R_CUBIC_TO, 0.38, -0.22, 0.7, -0.52, 0.91, -0.89,
R_LINE_TO, 0.97, -1.68,
R_ARC_TO, 0.57, 0.57, 0, 0, 1, 0.16, -0.74,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, 0.81, 0,
R_CUBIC_TO, 0.24, 0.18, 0.3, 0.49, 0.16, 0.74,
R_LINE_TO, 0.97, 1.68,
R_CUBIC_TO, 0.21, 0.37, 0.52, 0.68, 0.91, 0.89,
R_CUBIC_TO, 0.38, 0.22, 0.82, 0.33, 1.27, 0.33,
R_H_LINE_TO, 3.42,
R_CUBIC_TO, 0.66, 0, 1.28, -0.24, 1.75, -0.68,
R_CUBIC_TO, 0.47, -0.44, 0.72, -1.02, 0.72, -1.64,
R_V_LINE_TO, -7.37,
R_CUBIC_TO, 0, -0.62, -0.26, -1.2, -0.72, -1.64,
CLOSE,
MOVE_TO, 7.83, 13.8,
R_CUBIC_TO, -1.33, 0, -2.4, -1.08, -2.4, -2.4,
R_CUBIC_TO, 0, -1.32, 1.08, -2.4, 2.4, -2.4,
R_CUBIC_TO, 1.32, 0, 2.4, 1.08, 2.4, 2.4,
R_CUBIC_TO, 0, 1.32, -1.07, 2.4, -2.4, 2.4,
CLOSE,
R_MOVE_TO, 8.4, 0,
R_CUBIC_TO, -1.33, 0, -2.4, -1.08, -2.4, -2.4,
R_CUBIC_TO, 0, -1.32, 1.08, -2.4, 2.4, -2.4,
R_CUBIC_TO, 1.32, 0, 2.4, 1.08, 2.4, 2.4,
R_CUBIC_TO, 0, 1.32, -1.07, 2.4, -2.4, 2.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVrHeadsetRepList, kVrHeadsetIcon, {kVrHeadsetPath})
VECTOR_ICON_REP_TEMPLATE(kVrHeadsetChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 13,
R_H_LINE_TO, 3.19,
R_LINE_TO, 0.62, -1.22,
R_ARC_TO, 1.95, 1.95, 0, 0, 1, 0.7, -0.75,
ARC_TO, 1.82, 1.82, 0, 0, 1, 10, 10.75,
R_ARC_TO, 1.88, 1.88, 0, 0, 1, 1.69, 1.02,
R_LINE_TO, 0.62, 1.23,
H_LINE_TO, 15.5,
V_LINE_TO, 7,
R_H_LINE_TO, -11,
CLOSE,
R_MOVE_TO, 2, -1.5,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 0, 6.5, 8.5,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 5, 10,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 3, 13,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 5.5,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 6,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -1.06, 0.44,
R_H_LINE_TO, -3.19,
R_CUBIC_TO, -0.28, 0, -0.54, -0.07, -0.78, -0.22,
R_ARC_TO, 1.42, 1.42, 0, 0, 1, -0.55, -0.59,
R_LINE_TO, -0.62, -1.21,
R_ARC_TO, 0.4, 0.4, 0, 0, 0, -0.15, -0.17,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.41, 0,
R_ARC_TO, 0.34, 0.34, 0, 0, 0, -0.15, 0.17,
R_LINE_TO, -0.62, 1.21,
R_CUBIC_TO, -0.12, 0.25, -0.31, 0.45, -0.55, 0.59,
R_ARC_TO, 1.5, 1.5, 0, 0, 1, -0.78, 0.22,
H_LINE_TO, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3, 13,
CLOSE,
R_MOVE_TO, 10.5, -1.5,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
R_ARC_TO, 1.45, 1.45, 0, 0, 0, -1.06, -0.44,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 12, 10,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 10, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVrHeadsetChromeRefreshRepList, kVrHeadsetChromeRefreshIcon, {kVrHeadsetChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kVrHeadsetOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16, 18.13,
LINE_TO, 1.88, 4,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 14.12, 14.13,
CLOSE,
MOVE_TO, 7.88, 10,
CLOSE,
R_MOVE_TO, 8.69, 4.06,
LINE_TO, 15.5, 13,
V_LINE_TO, 7,
H_LINE_TO, 9.11,
R_LINE_TO, -1.48, -1.5,
H_LINE_TO, 15.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 5.99,
R_CUBIC_TO, 0, 0.22, -0.04, 0.41, -0.11, 0.59,
R_CUBIC_TO, -0.08, 0.18, -0.18, 0.34, -0.32, 0.48,
CLOSE,
MOVE_TO, 6.5, 11.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 5, 10,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 6.5, 8.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.06,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -1.06, 0.44,
CLOSE,
R_MOVE_TO, 7.05, 0,
LINE_TO, 12, 9.94,
R_CUBIC_TO, 0.03, -0.4, 0.18, -0.74, 0.47, -1.02,
ARC_TO, 1.43, 1.43, 0, 0, 1, 13.5, 8.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_CUBIC_TO, 0, 0.4, -0.14, 0.75, -0.43, 1.04,
R_CUBIC_TO, -0.28, 0.29, -0.63, 0.44, -1.03, 0.46,
CLOSE,
R_MOVE_TO, -1.48, -1.5,
CLOSE,
MOVE_TO, 4.5, 14.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 3, 13,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 5.5,
R_H_LINE_TO, 1,
LINE_TO, 7, 7,
H_LINE_TO, 4.5,
R_V_LINE_TO, 6,
R_H_LINE_TO, 3.19,
R_LINE_TO, 0.62, -1.22,
R_ARC_TO, 1.95, 1.95, 0, 0, 1, 0.7, -0.75,
ARC_TO, 1.82, 1.82, 0, 0, 1, 10, 10.75,
R_H_LINE_TO, 0.75,
R_LINE_TO, 3.75, 3.75,
R_H_LINE_TO, -2.19,
R_CUBIC_TO, -0.28, 0, -0.54, -0.07, -0.78, -0.22,
R_ARC_TO, 1.42, 1.42, 0, 0, 1, -0.55, -0.59,
R_LINE_TO, -0.62, -1.21,
R_ARC_TO, 0.4, 0.4, 0, 0, 0, -0.15, -0.17,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.41, 0,
R_ARC_TO, 0.34, 0.34, 0, 0, 0, -0.15, 0.17,
R_LINE_TO, -0.62, 1.21,
R_CUBIC_TO, -0.12, 0.25, -0.31, 0.45, -0.55, 0.59,
R_ARC_TO, 1.5, 1.5, 0, 0, 1, -0.78, 0.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kVrHeadsetOffChromeRefreshRepList, kVrHeadsetOffChromeRefreshIcon, {kVrHeadsetOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kWarningPath, MOVE_TO, 2, 42,
R_H_LINE_TO, 44,
LINE_TO, 24, 4,
LINE_TO, 2, 42,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 26, 36,
R_H_LINE_TO, -4,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, -8,
R_H_LINE_TO, -4,
R_V_LINE_TO, -8,
R_H_LINE_TO, 4,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWarningRepList, kWarningIcon, {kWarningPath})
VECTOR_ICON_REP_TEMPLATE(kWarningOutlinePath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9.13, 2.5,
CUBIC_TO, 9.52, 1.83, 10.48, 1.83, 10.87, 2.5,
LINE_TO, 18.87, 16.5,
CUBIC_TO, 19.25, 17.17, 18.77, 18, 18, 18,
H_LINE_TO, 2,
CUBIC_TO, 1.23, 18, 0.75, 17.17, 1.13, 16.5,
LINE_TO, 9.13, 2.5,
CLOSE,
MOVE_TO, 10, 5.02,
LINE_TO, 3.72, 16,
H_LINE_TO, 16.28,
LINE_TO, 10, 5.02,
CLOSE,
MOVE_TO, 11, 12,
V_LINE_TO, 8,
H_LINE_TO, 9,
V_LINE_TO, 12,
H_LINE_TO, 11,
CLOSE,
MOVE_TO, 11, 13,
V_LINE_TO, 15,
H_LINE_TO, 9,
V_LINE_TO, 13,
H_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWarningOutlineRepList, kWarningOutlineIcon, {kWarningOutlinePath})
VECTOR_ICON_REP_TEMPLATE(kWebAssetOffPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 16.73, 18.83,
LINE_TO, 13.88, 16,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 2, 14.5,
V_LINE_TO, 5.49,
R_CUBIC_TO, 0, -0.41, 0.15, -0.76, 0.46, -1.05,
ARC_TO, 1.55, 1.55, 0, 0, 1, 3.56, 4,
R_H_LINE_TO, 0.23,
R_V_LINE_TO, 1.9,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.23,
R_LINE_TO, 15.54, 15.54,
CLOSE,
MOVE_TO, 3.5, 14.5,
R_H_LINE_TO, 8.88,
LINE_TO, 4.88, 7,
H_LINE_TO, 3.5,
CLOSE,
R_MOVE_TO, 14.13, 1,
LINE_TO, 16.5, 14.38,
V_LINE_TO, 7,
H_LINE_TO, 9.13,
R_LINE_TO, -3, -3,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.19, -0.04, 0.38, -0.1, 0.56,
R_CUBIC_TO, -0.07, 0.18, -0.16, 0.33, -0.27, 0.44,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebAssetOffRepList, kWebAssetOffIcon, {kWebAssetOffPath})
VECTOR_ICON_REP_TEMPLATE(kWorkPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.33f, 17.5f,
CUBIC_TO, 2.88f, 17.5f, 2.48f, 17.34f, 2.16f, 17.01f,
CUBIC_TO, 1.83f, 16.68f, 1.67f, 16.29f, 1.67f, 15.83f,
LINE_TO, 1.67f, 6.67f,
CUBIC_TO, 1.67f, 6.21f, 1.83f, 5.82f, 2.16f, 5.49f,
CUBIC_TO, 2.48f, 5.16f, 2.88f, 5, 3.33f, 5,
LINE_TO, 6.67f, 5,
LINE_TO, 6.67f, 3.33f,
CUBIC_TO, 6.67f, 2.88f, 6.83f, 2.48f, 7.16f, 2.16f,
CUBIC_TO, 7.48f, 1.83f, 7.88f, 1.67f, 8.33f, 1.67f,
LINE_TO, 11.67f, 1.67f,
CUBIC_TO, 12.13f, 1.67f, 12.52f, 1.83f, 12.84f, 2.16f,
CUBIC_TO, 13.17f, 2.48f, 13.33f, 2.88f, 13.33f, 3.33f,
LINE_TO, 13.33f, 5,
LINE_TO, 16.67f, 5,
CUBIC_TO, 17.13f, 5, 17.52f, 5.16f, 17.84f, 5.49f,
CUBIC_TO, 18.17f, 5.82f, 18.33f, 6.21f, 18.33f, 6.67f,
LINE_TO, 18.33f, 15.83f,
CUBIC_TO, 18.33f, 16.29f, 18.17f, 16.68f, 17.84f, 17.01f,
CUBIC_TO, 17.52f, 17.34f, 17.13f, 17.5f, 16.67f, 17.5f,
CLOSE,
MOVE_TO, 3.33f, 15.83f,
LINE_TO, 16.67f, 15.83f,
LINE_TO, 16.67f, 6.67f,
LINE_TO, 3.33f, 6.67f,
CLOSE,
MOVE_TO, 8.33f, 5,
LINE_TO, 11.67f, 5,
LINE_TO, 11.67f, 3.33f,
LINE_TO, 8.33f, 3.33f,
CLOSE,
MOVE_TO, 3.33f, 15.83f,
LINE_TO, 3.33f, 6.67f,
CLOSE,
MOVE_TO, 3.33f, 15.83f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWorkRepList, kWorkIcon, {kWorkPath})

}  // namespace vector_icons
