// components/user_data_importer/mojom/bookmark_html_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_H_
#define COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-features.h"  // IWYU pragma: export
#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-shared.h"  // IWYU pragma: export
#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/user_data_importer/mojom/bookmark_html_parser_traits.h"




namespace user_data_importer::mojom {

class BookmarkHtmlParserProxy;

template <typename ImplRefTraits>
class BookmarkHtmlParserStub;

class BookmarkHtmlParserRequestValidator;
class BookmarkHtmlParserResponseValidator;


class BookmarkHtmlParser
    : public BookmarkHtmlParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "user_data_importer.mojom.BookmarkHtmlParser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarkHtmlParserInterfaceBase;
  using Proxy_ = BookmarkHtmlParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarkHtmlParserStub<ImplRefTraits>;

  using RequestValidator_ = BookmarkHtmlParserRequestValidator;
  using ResponseValidator_ = BookmarkHtmlParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Parse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarkHtmlParser() = default;

  using ParseCallback = base::OnceCallback<void(::user_data_importer::BookmarkParser::ParsedBookmarks)>;
  using ParseMojoCallback = base::OnceCallback<void(::user_data_importer::BookmarkParser::ParsedBookmarks)>;

  virtual void Parse(const std::string& raw_html, ParseCallback callback) = 0;
};



class  BookmarkHtmlParserProxy
    : public BookmarkHtmlParser {
 public:
  using InterfaceType = BookmarkHtmlParser;

  explicit BookmarkHtmlParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Parse(const std::string& raw_html, ParseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BookmarkHtmlParserStubDispatch {
 public:
  static bool Accept(BookmarkHtmlParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarkHtmlParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarkHtmlParser>>
class BookmarkHtmlParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarkHtmlParserStub() = default;
  ~BookmarkHtmlParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkHtmlParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarkHtmlParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarkHtmlParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarkHtmlParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class  ImportedBookmarkEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImportedBookmarkEntry, T>::value>;
  using DataView = ImportedBookmarkEntryDataView;
  using Data_ = internal::ImportedBookmarkEntry_Data;

  template <typename... Args>
  static ImportedBookmarkEntryPtr New(Args&&... args) {
    return ImportedBookmarkEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImportedBookmarkEntryPtr From(const U& u) {
    return mojo::TypeConverter<ImportedBookmarkEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImportedBookmarkEntry>::Convert(*this);
  }


  ImportedBookmarkEntry();

  ImportedBookmarkEntry(
      bool is_folder,
      const ::GURL& url,
      std::vector<::std::u16string> path,
      const ::std::u16string& title,
      ::base::Time creation_time,
      std::optional<::base::Time> last_visit_time,
      bool in_toolbar);


  ~ImportedBookmarkEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImportedBookmarkEntryPtr>
  ImportedBookmarkEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImportedBookmarkEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImportedBookmarkEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImportedBookmarkEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImportedBookmarkEntry_UnserializedMessageContext<
            UserType, ImportedBookmarkEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImportedBookmarkEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImportedBookmarkEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImportedBookmarkEntry_UnserializedMessageContext<
            UserType, ImportedBookmarkEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImportedBookmarkEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_folder;
  
  ::GURL url;
  
  std::vector<::std::u16string> path;
  
  ::std::u16string title;
  
  ::base::Time creation_time;
  
  std::optional<::base::Time> last_visit_time;
  
  bool in_toolbar;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImportedBookmarkEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SearchEngineInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchEngineInfo, T>::value>;
  using DataView = SearchEngineInfoDataView;
  using Data_ = internal::SearchEngineInfo_Data;

  template <typename... Args>
  static SearchEngineInfoPtr New(Args&&... args) {
    return SearchEngineInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchEngineInfoPtr From(const U& u) {
    return mojo::TypeConverter<SearchEngineInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchEngineInfo>::Convert(*this);
  }


  SearchEngineInfo();

  SearchEngineInfo(
      const ::std::u16string& display_name,
      const ::std::u16string& keyword,
      const ::std::u16string& url);


  ~SearchEngineInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchEngineInfoPtr>
  SearchEngineInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchEngineInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchEngineInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchEngineInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchEngineInfo_UnserializedMessageContext<
            UserType, SearchEngineInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchEngineInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchEngineInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchEngineInfo_UnserializedMessageContext<
            UserType, SearchEngineInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchEngineInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string display_name;
  
  ::std::u16string keyword;
  
  ::std::u16string url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchEngineInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FaviconUsageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FaviconUsageData, T>::value>;
  using DataView = FaviconUsageDataDataView;
  using Data_ = internal::FaviconUsageData_Data;

  template <typename... Args>
  static FaviconUsageDataPtr New(Args&&... args) {
    return FaviconUsageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FaviconUsageDataPtr From(const U& u) {
    return mojo::TypeConverter<FaviconUsageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FaviconUsageData>::Convert(*this);
  }


  FaviconUsageData();

  FaviconUsageData(
      const ::GURL& favicon_url,
      std::vector<uint8_t> png_data,
      std::vector<::GURL> urls);


  ~FaviconUsageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FaviconUsageDataPtr>
  FaviconUsageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FaviconUsageData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FaviconUsageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FaviconUsageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FaviconUsageData_UnserializedMessageContext<
            UserType, FaviconUsageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FaviconUsageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FaviconUsageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FaviconUsageData_UnserializedMessageContext<
            UserType, FaviconUsageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FaviconUsageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL favicon_url;
  
  std::vector<uint8_t> png_data;
  
  std::vector<::GURL> urls;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FaviconUsageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ParsedBookmarks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsedBookmarks, T>::value>;
  using DataView = ParsedBookmarksDataView;
  using Data_ = internal::ParsedBookmarks_Data;

  template <typename... Args>
  static ParsedBookmarksPtr New(Args&&... args) {
    return ParsedBookmarksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsedBookmarksPtr From(const U& u) {
    return mojo::TypeConverter<ParsedBookmarksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsedBookmarks>::Convert(*this);
  }


  ParsedBookmarks();

  ParsedBookmarks(
      std::vector<::user_data_importer::ImportedBookmarkEntry> bookmarks,
      std::vector<::user_data_importer::ImportedBookmarkEntry> reading_list,
      std::vector<::user_data_importer::SearchEngineInfo> search_engines,
      std::vector<::favicon_base::FaviconUsageData> favicons);

ParsedBookmarks(const ParsedBookmarks&) = delete;
ParsedBookmarks& operator=(const ParsedBookmarks&) = delete;

  ~ParsedBookmarks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsedBookmarksPtr>
  ParsedBookmarksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedBookmarks::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedBookmarks::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsedBookmarks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsedBookmarks_UnserializedMessageContext<
            UserType, ParsedBookmarks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParsedBookmarks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParsedBookmarks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsedBookmarks_UnserializedMessageContext<
            UserType, ParsedBookmarks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsedBookmarks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::user_data_importer::ImportedBookmarkEntry> bookmarks;
  
  std::vector<::user_data_importer::ImportedBookmarkEntry> reading_list;
  
  std::vector<::user_data_importer::SearchEngineInfo> search_engines;
  
  std::vector<::favicon_base::FaviconUsageData> favicons;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsedBookmarks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImportedBookmarkEntryPtr ImportedBookmarkEntry::Clone() const {
  return New(
      mojo::Clone(is_folder),
      mojo::Clone(url),
      mojo::Clone(path),
      mojo::Clone(title),
      mojo::Clone(creation_time),
      mojo::Clone(last_visit_time),
      mojo::Clone(in_toolbar)
  );
}

template <typename T, ImportedBookmarkEntry::EnableIfSame<T>*>
bool ImportedBookmarkEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_folder, other_struct.is_folder))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->last_visit_time, other_struct.last_visit_time))
    return false;
  if (!mojo::Equals(this->in_toolbar, other_struct.in_toolbar))
    return false;
  return true;
}

template <typename T, ImportedBookmarkEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_folder < rhs.is_folder)
    return true;
  if (rhs.is_folder < lhs.is_folder)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.last_visit_time < rhs.last_visit_time)
    return true;
  if (rhs.last_visit_time < lhs.last_visit_time)
    return false;
  if (lhs.in_toolbar < rhs.in_toolbar)
    return true;
  if (rhs.in_toolbar < lhs.in_toolbar)
    return false;
  return false;
}
template <typename StructPtrType>
SearchEngineInfoPtr SearchEngineInfo::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(keyword),
      mojo::Clone(url)
  );
}

template <typename T, SearchEngineInfo::EnableIfSame<T>*>
bool SearchEngineInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->keyword, other_struct.keyword))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, SearchEngineInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.keyword < rhs.keyword)
    return true;
  if (rhs.keyword < lhs.keyword)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
FaviconUsageDataPtr FaviconUsageData::Clone() const {
  return New(
      mojo::Clone(favicon_url),
      mojo::Clone(png_data),
      mojo::Clone(urls)
  );
}

template <typename T, FaviconUsageData::EnableIfSame<T>*>
bool FaviconUsageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->png_data, other_struct.png_data))
    return false;
  if (!mojo::Equals(this->urls, other_struct.urls))
    return false;
  return true;
}

template <typename T, FaviconUsageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.png_data < rhs.png_data)
    return true;
  if (rhs.png_data < lhs.png_data)
    return false;
  if (lhs.urls < rhs.urls)
    return true;
  if (rhs.urls < lhs.urls)
    return false;
  return false;
}
template <typename StructPtrType>
ParsedBookmarksPtr ParsedBookmarks::Clone() const {
  return New(
      mojo::Clone(bookmarks),
      mojo::Clone(reading_list),
      mojo::Clone(search_engines),
      mojo::Clone(favicons)
  );
}

template <typename T, ParsedBookmarks::EnableIfSame<T>*>
bool ParsedBookmarks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bookmarks, other_struct.bookmarks))
    return false;
  if (!mojo::Equals(this->reading_list, other_struct.reading_list))
    return false;
  if (!mojo::Equals(this->search_engines, other_struct.search_engines))
    return false;
  if (!mojo::Equals(this->favicons, other_struct.favicons))
    return false;
  return true;
}

template <typename T, ParsedBookmarks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bookmarks < rhs.bookmarks)
    return true;
  if (rhs.bookmarks < lhs.bookmarks)
    return false;
  if (lhs.reading_list < rhs.reading_list)
    return true;
  if (rhs.reading_list < lhs.reading_list)
    return false;
  if (lhs.search_engines < rhs.search_engines)
    return true;
  if (rhs.search_engines < lhs.search_engines)
    return false;
  if (lhs.favicons < rhs.favicons)
    return true;
  if (rhs.favicons < lhs.favicons)
    return false;
  return false;
}


}  // user_data_importer::mojom

namespace mojo {


template <>
struct  StructTraits<::user_data_importer::mojom::ImportedBookmarkEntry::DataView,
                                         ::user_data_importer::mojom::ImportedBookmarkEntryPtr> {
  static bool IsNull(const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) { return !input; }
  static void SetToNull(::user_data_importer::mojom::ImportedBookmarkEntryPtr* output) { output->reset(); }

  static decltype(::user_data_importer::mojom::ImportedBookmarkEntry::is_folder) is_folder(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->is_folder;
  }

  static const decltype(::user_data_importer::mojom::ImportedBookmarkEntry::url)& url(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->url;
  }

  static const decltype(::user_data_importer::mojom::ImportedBookmarkEntry::path)& path(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->path;
  }

  static const decltype(::user_data_importer::mojom::ImportedBookmarkEntry::title)& title(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->title;
  }

  static const decltype(::user_data_importer::mojom::ImportedBookmarkEntry::creation_time)& creation_time(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->creation_time;
  }

  static const decltype(::user_data_importer::mojom::ImportedBookmarkEntry::last_visit_time)& last_visit_time(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->last_visit_time;
  }

  static decltype(::user_data_importer::mojom::ImportedBookmarkEntry::in_toolbar) in_toolbar(
      const ::user_data_importer::mojom::ImportedBookmarkEntryPtr& input) {
    return input->in_toolbar;
  }

  static bool Read(::user_data_importer::mojom::ImportedBookmarkEntry::DataView input, ::user_data_importer::mojom::ImportedBookmarkEntryPtr* output);
};


template <>
struct  StructTraits<::user_data_importer::mojom::SearchEngineInfo::DataView,
                                         ::user_data_importer::mojom::SearchEngineInfoPtr> {
  static bool IsNull(const ::user_data_importer::mojom::SearchEngineInfoPtr& input) { return !input; }
  static void SetToNull(::user_data_importer::mojom::SearchEngineInfoPtr* output) { output->reset(); }

  static const decltype(::user_data_importer::mojom::SearchEngineInfo::display_name)& display_name(
      const ::user_data_importer::mojom::SearchEngineInfoPtr& input) {
    return input->display_name;
  }

  static const decltype(::user_data_importer::mojom::SearchEngineInfo::keyword)& keyword(
      const ::user_data_importer::mojom::SearchEngineInfoPtr& input) {
    return input->keyword;
  }

  static const decltype(::user_data_importer::mojom::SearchEngineInfo::url)& url(
      const ::user_data_importer::mojom::SearchEngineInfoPtr& input) {
    return input->url;
  }

  static bool Read(::user_data_importer::mojom::SearchEngineInfo::DataView input, ::user_data_importer::mojom::SearchEngineInfoPtr* output);
};


template <>
struct  StructTraits<::user_data_importer::mojom::FaviconUsageData::DataView,
                                         ::user_data_importer::mojom::FaviconUsageDataPtr> {
  static bool IsNull(const ::user_data_importer::mojom::FaviconUsageDataPtr& input) { return !input; }
  static void SetToNull(::user_data_importer::mojom::FaviconUsageDataPtr* output) { output->reset(); }

  static const decltype(::user_data_importer::mojom::FaviconUsageData::favicon_url)& favicon_url(
      const ::user_data_importer::mojom::FaviconUsageDataPtr& input) {
    return input->favicon_url;
  }

  static const decltype(::user_data_importer::mojom::FaviconUsageData::png_data)& png_data(
      const ::user_data_importer::mojom::FaviconUsageDataPtr& input) {
    return input->png_data;
  }

  static const decltype(::user_data_importer::mojom::FaviconUsageData::urls)& urls(
      const ::user_data_importer::mojom::FaviconUsageDataPtr& input) {
    return input->urls;
  }

  static bool Read(::user_data_importer::mojom::FaviconUsageData::DataView input, ::user_data_importer::mojom::FaviconUsageDataPtr* output);
};


template <>
struct  StructTraits<::user_data_importer::mojom::ParsedBookmarks::DataView,
                                         ::user_data_importer::mojom::ParsedBookmarksPtr> {
  static bool IsNull(const ::user_data_importer::mojom::ParsedBookmarksPtr& input) { return !input; }
  static void SetToNull(::user_data_importer::mojom::ParsedBookmarksPtr* output) { output->reset(); }

  static const decltype(::user_data_importer::mojom::ParsedBookmarks::bookmarks)& bookmarks(
      const ::user_data_importer::mojom::ParsedBookmarksPtr& input) {
    return input->bookmarks;
  }

  static const decltype(::user_data_importer::mojom::ParsedBookmarks::reading_list)& reading_list(
      const ::user_data_importer::mojom::ParsedBookmarksPtr& input) {
    return input->reading_list;
  }

  static const decltype(::user_data_importer::mojom::ParsedBookmarks::search_engines)& search_engines(
      const ::user_data_importer::mojom::ParsedBookmarksPtr& input) {
    return input->search_engines;
  }

  static const decltype(::user_data_importer::mojom::ParsedBookmarks::favicons)& favicons(
      const ::user_data_importer::mojom::ParsedBookmarksPtr& input) {
    return input->favicons;
  }

  static bool Read(::user_data_importer::mojom::ParsedBookmarks::DataView input, ::user_data_importer::mojom::ParsedBookmarksPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_H_