// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/ui_devtools/overlay.h"

#include "components/ui_devtools/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace ui_devtools {
namespace protocol {
namespace Overlay {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Overlay";
const char Metainfo::commandPrefix[] = "Overlay.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(HighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("borderColor", m_borderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("contentColor", m_contentColor),
    CRDTP_DESERIALIZE_FIELD_OPT("displayAsMaterial", m_displayAsMaterial),
    CRDTP_DESERIALIZE_FIELD_OPT("eventTargetColor", m_eventTargetColor),
    CRDTP_DESERIALIZE_FIELD_OPT("marginColor", m_marginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("paddingColor", m_paddingColor),
    CRDTP_DESERIALIZE_FIELD_OPT("selectorList", m_selectorList),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeColor", m_shapeColor),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeMarginColor", m_shapeMarginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("showExtensionLines", m_showExtensionLines),
    CRDTP_DESERIALIZE_FIELD_OPT("showInfo", m_showInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("showRulers", m_showRulers),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HighlightConfig)
    CRDTP_SERIALIZE_FIELD("showInfo", m_showInfo);
    CRDTP_SERIALIZE_FIELD("showRulers", m_showRulers);
    CRDTP_SERIALIZE_FIELD("showExtensionLines", m_showExtensionLines);
    CRDTP_SERIALIZE_FIELD("displayAsMaterial", m_displayAsMaterial);
    CRDTP_SERIALIZE_FIELD("contentColor", m_contentColor);
    CRDTP_SERIALIZE_FIELD("paddingColor", m_paddingColor);
    CRDTP_SERIALIZE_FIELD("borderColor", m_borderColor);
    CRDTP_SERIALIZE_FIELD("marginColor", m_marginColor);
    CRDTP_SERIALIZE_FIELD("eventTargetColor", m_eventTargetColor);
    CRDTP_SERIALIZE_FIELD("shapeColor", m_shapeColor);
    CRDTP_SERIALIZE_FIELD("shapeMarginColor", m_shapeMarginColor);
    CRDTP_SERIALIZE_FIELD("selectorList", m_selectorList);
CRDTP_END_SERIALIZER();


namespace InspectModeEnum {
const char SearchForNode[] = "searchForNode";
const char SearchForUAShadowDOM[] = "searchForUAShadowDOM";
const char None[] = "none";
} // namespace InspectModeEnum


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::inspectNodeRequested(int backendNodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("backendNodeId"), backendNodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.inspectNodeRequested", serializer.Finish()));
}

void Frontend::nodeHighlightRequested(int nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.nodeHighlightRequested", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void hideHighlight(const crdtp::Dispatchable& dispatchable);
    void highlightNode(const crdtp::Dispatchable& dispatchable);
    void setInspectMode(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("hideHighlight"),
          &DomainDispatcherImpl::hideHighlight
    },
    {
          crdtp::SpanFrom("highlightNode"),
          &DomainDispatcherImpl::highlightNode
    },
    {
          crdtp::SpanFrom("setInspectMode"),
          &DomainDispatcherImpl::setInspectMode
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::hideHighlight(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->hideHighlight();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.hideHighlight"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightNodeParams : public crdtp::DeserializableProtocolObject<highlightNodeParams> {
    std::unique_ptr<protocol::Overlay::HighlightConfig> highlightConfig;
    std::optional<int> nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightNodeParams)
    CRDTP_DESERIALIZE_FIELD("highlightConfig", highlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightNodeParams params;
    if (!highlightNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightNode(std::move(params.highlightConfig), std::move(params.nodeId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setInspectModeParams : public crdtp::DeserializableProtocolObject<setInspectModeParams> {
    String mode;
    std::unique_ptr<protocol::Overlay::HighlightConfig> highlightConfig;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInspectModeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("highlightConfig", highlightConfig),
    CRDTP_DESERIALIZE_FIELD("mode", mode),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInspectMode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInspectModeParams params;
    if (!setInspectModeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInspectMode(params.mode, std::move(params.highlightConfig));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setInspectMode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Overlay"), SortedRedirects(), std::move(dispatcher));
}

} // Overlay
} // namespace ui_devtools
} // namespace protocol
