// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ui_devtools_protocol_DOM_h
#define ui_devtools_protocol_DOM_h

#include "components/ui_devtools/devtools_export.h"
#include "components/ui_devtools/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace ui_devtools {
namespace protocol {
namespace DOM {
using NodeId = int;
using BackendNodeId = int;
class Node;
class RGBA;
class MouseEvent;
class KeyEvent;
class Rect;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class UI_DEVTOOLS_EXPORT Node : public ::crdtp::ProtocolObject<Node> {
public:
    ~Node() override;  // Defined below

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value);  // Defined below

    int getBackendNodeId() { return m_backendNodeId; }
    void setBackendNodeId(int value);  // Defined below

    int getNodeType() { return m_nodeType; }
    void setNodeType(int value);  // Defined below

    String getNodeName() { return m_nodeName; }
    void setNodeName(const String& value);  // Defined below

    bool hasChildNodeCount() { return !!m_childNodeCount; }
    int getChildNodeCount(int defaultValue) const {
       return m_childNodeCount.value_or(defaultValue);
    }
    const std::optional<int>& getChildNodeCount() const {
       return m_childNodeCount;
    }
    void setChildNodeCount(int value);  // Defined below

    bool hasChildren() { return !!m_children; }
    protocol::Array<protocol::DOM::Node>* getChildren(protocol::Array<protocol::DOM::Node>* defaultValue) {
       return m_children ? m_children.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOM::Node>>& getChildren() const {
       return m_children;
    }
    void setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value);  // Defined below

    bool hasAttributes() { return !!m_attributes; }
    protocol::Array<String>* getAttributes(protocol::Array<String>* defaultValue) {
       return m_attributes ? m_attributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getAttributes() const {
       return m_attributes;
    }
    void setAttributes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    String getValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& getValue() const {
       return m_value;
    }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class NodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            BackendNodeIdSet = 1 << 2,
            NodeTypeSet = 1 << 3,
            NodeNameSet = 1 << 4,
            AllFieldsSet = (NodeIdSet | BackendNodeIdSet | NodeTypeSet | NodeNameSet | 0)};


        NodeBuilder<STATE | NodeIdSet>& setNodeId(int value);  // Defined below

        NodeBuilder<STATE | BackendNodeIdSet>& setBackendNodeId(int value);  // Defined below

        NodeBuilder<STATE | NodeTypeSet>& setNodeType(int value);  // Defined below

        NodeBuilder<STATE | NodeNameSet>& setNodeName(const String& value);  // Defined below

        NodeBuilder<STATE>& setChildNodeCount(int value);  // Defined below

        NodeBuilder<STATE>& setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value);  // Defined below

        NodeBuilder<STATE>& setAttributes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        NodeBuilder<STATE>& setName(const String& value);  // Defined below

        NodeBuilder<STATE>& setValue(const String& value);  // Defined below

        std::unique_ptr<Node> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Node;
        NodeBuilder() : m_result(new Node()) { }

        template<int STEP> NodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::Node> m_result;
    };

    static NodeBuilder<0> create()
    {
        return NodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Node();  // Defined below

    int m_nodeId;
    int m_backendNodeId;
    int m_nodeType;
    String m_nodeName;
    std::optional<int> m_childNodeCount;
    std::unique_ptr<protocol::Array<protocol::DOM::Node>> m_children;
    std::unique_ptr<protocol::Array<String>> m_attributes;
    std::optional<String> m_name;
    std::optional<String> m_value;
};


class UI_DEVTOOLS_EXPORT RGBA : public ::crdtp::ProtocolObject<RGBA> {
public:
    ~RGBA() override;  // Defined below

    int getR() { return m_r; }
    void setR(int value);  // Defined below

    int getG() { return m_g; }
    void setG(int value);  // Defined below

    int getB() { return m_b; }
    void setB(int value);  // Defined below

    bool hasA() { return !!m_a; }
    double getA(double defaultValue) const {
       return m_a.value_or(defaultValue);
    }
    const std::optional<double>& getA() const {
       return m_a;
    }
    void setA(double value);  // Defined below

    template<int STATE>
    class RGBABuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RSet = 1 << 1,
            GSet = 1 << 2,
            BSet = 1 << 3,
            AllFieldsSet = (RSet | GSet | BSet | 0)};


        RGBABuilder<STATE | RSet>& setR(int value);  // Defined below

        RGBABuilder<STATE | GSet>& setG(int value);  // Defined below

        RGBABuilder<STATE | BSet>& setB(int value);  // Defined below

        RGBABuilder<STATE>& setA(double value);  // Defined below

        std::unique_ptr<RGBA> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RGBA;
        RGBABuilder() : m_result(new RGBA()) { }

        template<int STEP> RGBABuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RGBABuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::RGBA> m_result;
    };

    static RGBABuilder<0> create()
    {
        return RGBABuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RGBA();  // Defined below

    int m_r;
    int m_g;
    int m_b;
    std::optional<double> m_a;
};


class UI_DEVTOOLS_EXPORT MouseEvent : public ::crdtp::ProtocolObject<MouseEvent> {
public:
    ~MouseEvent() override;  // Defined below

    struct UI_DEVTOOLS_EXPORT TypeEnum {
        static const char* MousePressed;
        static const char* MouseDragged;
        static const char* MouseReleased;
        static const char* MouseMoved;
        static const char* MouseEntered;
        static const char* MouseExited;
        static const char* MouseWheel;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    int getX() { return m_x; }
    void setX(int value);  // Defined below

    int getY() { return m_y; }
    void setY(int value);  // Defined below

    struct UI_DEVTOOLS_EXPORT ButtonEnum {
        static const char* None;
        static const char* Left;
        static const char* Right;
        static const char* Middle;
        static const char* Back;
        static const char* Forward;
    }; // ButtonEnum

    String getButton() { return m_button; }
    void setButton(const String& value);  // Defined below

    struct UI_DEVTOOLS_EXPORT WheelDirectionEnum {
        static const char* None;
        static const char* Up;
        static const char* Down;
        static const char* Left;
        static const char* Right;
    }; // WheelDirectionEnum

    String getWheelDirection() { return m_wheelDirection; }
    void setWheelDirection(const String& value);  // Defined below

    template<int STATE>
    class MouseEventBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            XSet = 1 << 2,
            YSet = 1 << 3,
            ButtonSet = 1 << 4,
            WheelDirectionSet = 1 << 5,
            AllFieldsSet = (TypeSet | XSet | YSet | ButtonSet | WheelDirectionSet | 0)};


        MouseEventBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        MouseEventBuilder<STATE | XSet>& setX(int value);  // Defined below

        MouseEventBuilder<STATE | YSet>& setY(int value);  // Defined below

        MouseEventBuilder<STATE | ButtonSet>& setButton(const String& value);  // Defined below

        MouseEventBuilder<STATE | WheelDirectionSet>& setWheelDirection(const String& value);  // Defined below

        std::unique_ptr<MouseEvent> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MouseEvent;
        MouseEventBuilder() : m_result(new MouseEvent()) { }

        template<int STEP> MouseEventBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MouseEventBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::MouseEvent> m_result;
    };

    static MouseEventBuilder<0> create()
    {
        return MouseEventBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MouseEvent();  // Defined below

    String m_type;
    int m_x;
    int m_y;
    String m_button;
    String m_wheelDirection;
};


class UI_DEVTOOLS_EXPORT KeyEvent : public ::crdtp::ProtocolObject<KeyEvent> {
public:
    ~KeyEvent() override;  // Defined below

    struct UI_DEVTOOLS_EXPORT TypeEnum {
        static const char* KeyPressed;
        static const char* KeyReleased;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    int getKeyCode() { return m_keyCode; }
    void setKeyCode(int value);  // Defined below

    int getCode() { return m_code; }
    void setCode(int value);  // Defined below

    int getFlags() { return m_flags; }
    void setFlags(int value);  // Defined below

    int getKey() { return m_key; }
    void setKey(int value);  // Defined below

    bool getIsChar() { return m_isChar; }
    void setIsChar(bool value);  // Defined below

    template<int STATE>
    class KeyEventBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            KeyCodeSet = 1 << 2,
            CodeSet = 1 << 3,
            FlagsSet = 1 << 4,
            KeySet = 1 << 5,
            IsCharSet = 1 << 6,
            AllFieldsSet = (TypeSet | KeyCodeSet | CodeSet | FlagsSet | KeySet | IsCharSet | 0)};


        KeyEventBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        KeyEventBuilder<STATE | KeyCodeSet>& setKeyCode(int value);  // Defined below

        KeyEventBuilder<STATE | CodeSet>& setCode(int value);  // Defined below

        KeyEventBuilder<STATE | FlagsSet>& setFlags(int value);  // Defined below

        KeyEventBuilder<STATE | KeySet>& setKey(int value);  // Defined below

        KeyEventBuilder<STATE | IsCharSet>& setIsChar(bool value);  // Defined below

        std::unique_ptr<KeyEvent> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class KeyEvent;
        KeyEventBuilder() : m_result(new KeyEvent()) { }

        template<int STEP> KeyEventBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyEventBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::KeyEvent> m_result;
    };

    static KeyEventBuilder<0> create()
    {
        return KeyEventBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    KeyEvent();  // Defined below

    String m_type;
    int m_keyCode;
    int m_code;
    int m_flags;
    int m_key;
    bool m_isChar;
};


class UI_DEVTOOLS_EXPORT Rect : public ::crdtp::ProtocolObject<Rect> {
public:
    ~Rect() override;  // Defined below

    double getX() { return m_x; }
    void setX(double value);  // Defined below

    double getY() { return m_y; }
    void setY(double value);  // Defined below

    double getWidth() { return m_width; }
    void setWidth(double value);  // Defined below

    double getHeight() { return m_height; }
    void setHeight(double value);  // Defined below

    template<int STATE>
    class RectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            AllFieldsSet = (XSet | YSet | WidthSet | HeightSet | 0)};


        RectBuilder<STATE | XSet>& setX(double value);  // Defined below

        RectBuilder<STATE | YSet>& setY(double value);  // Defined below

        RectBuilder<STATE | WidthSet>& setWidth(double value);  // Defined below

        RectBuilder<STATE | HeightSet>& setHeight(double value);  // Defined below

        std::unique_ptr<Rect> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Rect;
        RectBuilder() : m_result(new Rect()) { }

        template<int STEP> RectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::Rect> m_result;
    };

    static RectBuilder<0> create()
    {
        return RectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Rect();  // Defined below

    double m_x;
    double m_y;
    double m_width;
    double m_height;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Node::~Node() = default;
inline void Node::setNodeId(int value) { m_nodeId = value; }
inline void Node::setBackendNodeId(int value) { m_backendNodeId = value; }
inline void Node::setNodeType(int value) { m_nodeType = value; }
inline void Node::setNodeName(const String& value) { m_nodeName = value; }
inline void Node::setChildNodeCount(int value) { m_childNodeCount = value; }
inline void Node::setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value) { m_children = std::move(value); }
inline void Node::setAttributes(std::unique_ptr<protocol::Array<String>> value) { m_attributes = std::move(value); }
inline void Node::setName(const String& value) { m_name = value; }
inline void Node::setValue(const String& value) { m_value = value; }

template<int STATE>
inline Node::NodeBuilder<STATE | Node::NodeBuilder<STATE>::NodeIdSet>&
Node::NodeBuilder<STATE>::setNodeId(int value) {
  static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
  m_result->setNodeId(value);
  return castState<NodeIdSet>();
}
template<int STATE>
inline Node::NodeBuilder<STATE | Node::NodeBuilder<STATE>::BackendNodeIdSet>&
Node::NodeBuilder<STATE>::setBackendNodeId(int value) {
  static_assert(!(STATE & BackendNodeIdSet), "property backendNodeId should not be set yet");
  m_result->setBackendNodeId(value);
  return castState<BackendNodeIdSet>();
}
template<int STATE>
inline Node::NodeBuilder<STATE | Node::NodeBuilder<STATE>::NodeTypeSet>&
Node::NodeBuilder<STATE>::setNodeType(int value) {
  static_assert(!(STATE & NodeTypeSet), "property nodeType should not be set yet");
  m_result->setNodeType(value);
  return castState<NodeTypeSet>();
}
template<int STATE>
inline Node::NodeBuilder<STATE | Node::NodeBuilder<STATE>::NodeNameSet>&
Node::NodeBuilder<STATE>::setNodeName(const String& value) {
  static_assert(!(STATE & NodeNameSet), "property nodeName should not be set yet");
  m_result->setNodeName(value);
  return castState<NodeNameSet>();
}
template<int STATE>
inline Node::NodeBuilder<STATE>& Node::NodeBuilder<STATE>::setChildNodeCount(int value) {
  m_result->setChildNodeCount(value);
  return *this;
}
template<int STATE>
inline Node::NodeBuilder<STATE>& Node::NodeBuilder<STATE>::setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value) {
  m_result->setChildren(std::move(value));
  return *this;
}
template<int STATE>
inline Node::NodeBuilder<STATE>& Node::NodeBuilder<STATE>::setAttributes(std::unique_ptr<protocol::Array<String>> value) {
  m_result->setAttributes(std::move(value));
  return *this;
}
template<int STATE>
inline Node::NodeBuilder<STATE>& Node::NodeBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}
template<int STATE>
inline Node::NodeBuilder<STATE>& Node::NodeBuilder<STATE>::setValue(const String& value) {
  m_result->setValue(value);
  return *this;
}

inline Node::Node() {
  m_nodeId = 0;
  m_backendNodeId = 0;
  m_nodeType = 0;
}
inline RGBA::~RGBA() = default;
inline void RGBA::setR(int value) { m_r = value; }
inline void RGBA::setG(int value) { m_g = value; }
inline void RGBA::setB(int value) { m_b = value; }
inline void RGBA::setA(double value) { m_a = value; }

template<int STATE>
inline RGBA::RGBABuilder<STATE | RGBA::RGBABuilder<STATE>::RSet>&
RGBA::RGBABuilder<STATE>::setR(int value) {
  static_assert(!(STATE & RSet), "property r should not be set yet");
  m_result->setR(value);
  return castState<RSet>();
}
template<int STATE>
inline RGBA::RGBABuilder<STATE | RGBA::RGBABuilder<STATE>::GSet>&
RGBA::RGBABuilder<STATE>::setG(int value) {
  static_assert(!(STATE & GSet), "property g should not be set yet");
  m_result->setG(value);
  return castState<GSet>();
}
template<int STATE>
inline RGBA::RGBABuilder<STATE | RGBA::RGBABuilder<STATE>::BSet>&
RGBA::RGBABuilder<STATE>::setB(int value) {
  static_assert(!(STATE & BSet), "property b should not be set yet");
  m_result->setB(value);
  return castState<BSet>();
}
template<int STATE>
inline RGBA::RGBABuilder<STATE>& RGBA::RGBABuilder<STATE>::setA(double value) {
  m_result->setA(value);
  return *this;
}

inline RGBA::RGBA() {
  m_r = 0;
  m_g = 0;
  m_b = 0;
}
inline MouseEvent::~MouseEvent() = default;
inline void MouseEvent::setType(const String& value) { m_type = value; }
inline void MouseEvent::setX(int value) { m_x = value; }
inline void MouseEvent::setY(int value) { m_y = value; }
inline void MouseEvent::setButton(const String& value) { m_button = value; }
inline void MouseEvent::setWheelDirection(const String& value) { m_wheelDirection = value; }

template<int STATE>
inline MouseEvent::MouseEventBuilder<STATE | MouseEvent::MouseEventBuilder<STATE>::TypeSet>&
MouseEvent::MouseEventBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline MouseEvent::MouseEventBuilder<STATE | MouseEvent::MouseEventBuilder<STATE>::XSet>&
MouseEvent::MouseEventBuilder<STATE>::setX(int value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->setX(value);
  return castState<XSet>();
}
template<int STATE>
inline MouseEvent::MouseEventBuilder<STATE | MouseEvent::MouseEventBuilder<STATE>::YSet>&
MouseEvent::MouseEventBuilder<STATE>::setY(int value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->setY(value);
  return castState<YSet>();
}
template<int STATE>
inline MouseEvent::MouseEventBuilder<STATE | MouseEvent::MouseEventBuilder<STATE>::ButtonSet>&
MouseEvent::MouseEventBuilder<STATE>::setButton(const String& value) {
  static_assert(!(STATE & ButtonSet), "property button should not be set yet");
  m_result->setButton(value);
  return castState<ButtonSet>();
}
template<int STATE>
inline MouseEvent::MouseEventBuilder<STATE | MouseEvent::MouseEventBuilder<STATE>::WheelDirectionSet>&
MouseEvent::MouseEventBuilder<STATE>::setWheelDirection(const String& value) {
  static_assert(!(STATE & WheelDirectionSet), "property wheelDirection should not be set yet");
  m_result->setWheelDirection(value);
  return castState<WheelDirectionSet>();
}

inline MouseEvent::MouseEvent() {
  m_x = 0;
  m_y = 0;
}
inline KeyEvent::~KeyEvent() = default;
inline void KeyEvent::setType(const String& value) { m_type = value; }
inline void KeyEvent::setKeyCode(int value) { m_keyCode = value; }
inline void KeyEvent::setCode(int value) { m_code = value; }
inline void KeyEvent::setFlags(int value) { m_flags = value; }
inline void KeyEvent::setKey(int value) { m_key = value; }
inline void KeyEvent::setIsChar(bool value) { m_isChar = value; }

template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::TypeSet>&
KeyEvent::KeyEventBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::KeyCodeSet>&
KeyEvent::KeyEventBuilder<STATE>::setKeyCode(int value) {
  static_assert(!(STATE & KeyCodeSet), "property keyCode should not be set yet");
  m_result->setKeyCode(value);
  return castState<KeyCodeSet>();
}
template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::CodeSet>&
KeyEvent::KeyEventBuilder<STATE>::setCode(int value) {
  static_assert(!(STATE & CodeSet), "property code should not be set yet");
  m_result->setCode(value);
  return castState<CodeSet>();
}
template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::FlagsSet>&
KeyEvent::KeyEventBuilder<STATE>::setFlags(int value) {
  static_assert(!(STATE & FlagsSet), "property flags should not be set yet");
  m_result->setFlags(value);
  return castState<FlagsSet>();
}
template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::KeySet>&
KeyEvent::KeyEventBuilder<STATE>::setKey(int value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline KeyEvent::KeyEventBuilder<STATE | KeyEvent::KeyEventBuilder<STATE>::IsCharSet>&
KeyEvent::KeyEventBuilder<STATE>::setIsChar(bool value) {
  static_assert(!(STATE & IsCharSet), "property isChar should not be set yet");
  m_result->setIsChar(value);
  return castState<IsCharSet>();
}

inline KeyEvent::KeyEvent() {
  m_keyCode = 0;
  m_code = 0;
  m_flags = 0;
  m_key = 0;
  m_isChar = false;
}
inline Rect::~Rect() = default;
inline void Rect::setX(double value) { m_x = value; }
inline void Rect::setY(double value) { m_y = value; }
inline void Rect::setWidth(double value) { m_width = value; }
inline void Rect::setHeight(double value) { m_height = value; }

template<int STATE>
inline Rect::RectBuilder<STATE | Rect::RectBuilder<STATE>::XSet>&
Rect::RectBuilder<STATE>::setX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->setX(value);
  return castState<XSet>();
}
template<int STATE>
inline Rect::RectBuilder<STATE | Rect::RectBuilder<STATE>::YSet>&
Rect::RectBuilder<STATE>::setY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->setY(value);
  return castState<YSet>();
}
template<int STATE>
inline Rect::RectBuilder<STATE | Rect::RectBuilder<STATE>::WidthSet>&
Rect::RectBuilder<STATE>::setWidth(double value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->setWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline Rect::RectBuilder<STATE | Rect::RectBuilder<STATE>::HeightSet>&
Rect::RectBuilder<STATE>::setHeight(double value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->setHeight(value);
  return castState<HeightSet>();
}

inline Rect::Rect() {
  m_x = 0;
  m_y = 0;
  m_width = 0;
  m_height = 0;
}

// ------------- Backend interface.

class UI_DEVTOOLS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getDocument(std::unique_ptr<protocol::DOM::Node>* out_root) = 0;
    virtual DispatchResponse pushNodesByBackendIdsToFrontend(std::unique_ptr<protocol::Array<int>> in_backendNodeIds, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse performSearch(const String& in_query, std::optional<bool> in_includeUserAgentShadowDOM, String* out_searchId, int* out_resultCount) = 0;
    virtual DispatchResponse getSearchResults(const String& in_searchId, int in_fromIndex, int in_toIndex, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse discardSearchResults(const String& in_searchId) = 0;
    virtual DispatchResponse dispatchMouseEvent(int in_nodeId, std::unique_ptr<protocol::DOM::MouseEvent> in_event) = 0;
    virtual DispatchResponse dispatchKeyEvent(int in_nodeId, std::unique_ptr<protocol::DOM::KeyEvent> in_event) = 0;
    virtual DispatchResponse getNodeBoundsInScreen(int in_nodeId, std::unique_ptr<protocol::DOM::Rect>* out_boundsInScreen) = 0;
    virtual DispatchResponse getDeviceScaleFactor(int in_nodeId, double* out_deviceScaleFactor) = 0;
    virtual DispatchResponse getOuterHTML(int in_nodeId, String* out_outerHTML) = 0;

};

// ------------- Frontend interface.

class UI_DEVTOOLS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void childNodeInserted(int parentNodeId, int previousNodeId, std::unique_ptr<protocol::DOM::Node> node);
    void childNodeRemoved(int parentNodeId, int nodeId);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class UI_DEVTOOLS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class UI_DEVTOOLS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DOM
} // namespace ui_devtools
} // namespace protocol

#endif // !defined(ui_devtools_protocol_DOM_h)
