// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ui_devtools_protocol_CSS_h
#define ui_devtools_protocol_CSS_h

#include "components/ui_devtools/devtools_export.h"
#include "components/ui_devtools/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "components/ui_devtools/dom.h"

namespace ui_devtools {
namespace protocol {
namespace CSS {
using StyleSheetId = String;
class SourceRange;
class ShorthandEntry;
class CSSStyle;
class CSSProperty;
class RuleMatch;
class Value;
class SelectorList;
class CSSStyleSheetHeader;
class CSSRule;
class StyleDeclarationEdit;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class UI_DEVTOOLS_EXPORT SourceRange : public ::crdtp::ProtocolObject<SourceRange> {
public:
    ~SourceRange() override;  // Defined below

    int getStartLine() { return m_startLine; }
    void setStartLine(int value);  // Defined below

    int getStartColumn() { return m_startColumn; }
    void setStartColumn(int value);  // Defined below

    int getEndLine() { return m_endLine; }
    void setEndLine(int value);  // Defined below

    int getEndColumn() { return m_endColumn; }
    void setEndColumn(int value);  // Defined below

    template<int STATE>
    class SourceRangeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartLineSet = 1 << 1,
            StartColumnSet = 1 << 2,
            EndLineSet = 1 << 3,
            EndColumnSet = 1 << 4,
            AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet | 0)};


        SourceRangeBuilder<STATE | StartLineSet>& setStartLine(int value);  // Defined below

        SourceRangeBuilder<STATE | StartColumnSet>& setStartColumn(int value);  // Defined below

        SourceRangeBuilder<STATE | EndLineSet>& setEndLine(int value);  // Defined below

        SourceRangeBuilder<STATE | EndColumnSet>& setEndColumn(int value);  // Defined below

        std::unique_ptr<SourceRange> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceRange;
        SourceRangeBuilder() : m_result(new SourceRange()) { }

        template<int STEP> SourceRangeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceRangeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::SourceRange> m_result;
    };

    static SourceRangeBuilder<0> create()
    {
        return SourceRangeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceRange();  // Defined below

    int m_startLine;
    int m_startColumn;
    int m_endLine;
    int m_endColumn;
};


class UI_DEVTOOLS_EXPORT ShorthandEntry : public ::crdtp::ProtocolObject<ShorthandEntry> {
public:
    ~ShorthandEntry() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    bool hasImportant() { return !!m_important; }
    bool getImportant(bool defaultValue) const {
       return m_important.value_or(defaultValue);
    }
    const std::optional<bool>& getImportant() const {
       return m_important;
    }
    void setImportant(bool value);  // Defined below

    template<int STATE>
    class ShorthandEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        ShorthandEntryBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        ShorthandEntryBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        ShorthandEntryBuilder<STATE>& setImportant(bool value);  // Defined below

        std::unique_ptr<ShorthandEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ShorthandEntry;
        ShorthandEntryBuilder() : m_result(new ShorthandEntry()) { }

        template<int STEP> ShorthandEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ShorthandEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::ShorthandEntry> m_result;
    };

    static ShorthandEntryBuilder<0> create()
    {
        return ShorthandEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ShorthandEntry();  // Defined below

    String m_name;
    String m_value;
    std::optional<bool> m_important;
};


class UI_DEVTOOLS_EXPORT CSSStyle : public ::crdtp::ProtocolObject<CSSStyle> {
public:
    ~CSSStyle() override;  // Defined below

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value);  // Defined below

    protocol::Array<protocol::CSS::CSSProperty>* getCssProperties() { return m_cssProperties.get(); }
    void setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value);  // Defined below

    protocol::Array<protocol::CSS::ShorthandEntry>* getShorthandEntries() { return m_shorthandEntries.get(); }
    void setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value);  // Defined below

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

    template<int STATE>
    class CSSStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CssPropertiesSet = 1 << 1,
            ShorthandEntriesSet = 1 << 2,
            AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet | 0)};


        CSSStyleBuilder<STATE>& setStyleSheetId(const String& value);  // Defined below

        CSSStyleBuilder<STATE | CssPropertiesSet>& setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value);  // Defined below

        CSSStyleBuilder<STATE | ShorthandEntriesSet>& setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value);  // Defined below

        CSSStyleBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

        std::unique_ptr<CSSStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSStyle;
        CSSStyleBuilder() : m_result(new CSSStyle()) { }

        template<int STEP> CSSStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSStyle> m_result;
    };

    static CSSStyleBuilder<0> create()
    {
        return CSSStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSStyle();  // Defined below

    std::optional<String> m_styleSheetId;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> m_cssProperties;
    std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> m_shorthandEntries;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
};


class UI_DEVTOOLS_EXPORT CSSProperty : public ::crdtp::ProtocolObject<CSSProperty> {
public:
    ~CSSProperty() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

    template<int STATE>
    class CSSPropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CSSPropertyBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        CSSPropertyBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        CSSPropertyBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

        std::unique_ptr<CSSProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSProperty;
        CSSPropertyBuilder() : m_result(new CSSProperty()) { }

        template<int STEP> CSSPropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSPropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSProperty> m_result;
    };

    static CSSPropertyBuilder<0> create()
    {
        return CSSPropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSProperty();  // Defined below

    String m_name;
    String m_value;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
};


class UI_DEVTOOLS_EXPORT RuleMatch : public ::crdtp::ProtocolObject<RuleMatch> {
public:
    ~RuleMatch() override;  // Defined below

    protocol::CSS::CSSRule* getRule() { return m_rule.get(); }
    void setRule(std::unique_ptr<protocol::CSS::CSSRule> value);  // Defined below

    protocol::Array<int>* getMatchingSelectors() { return m_matchingSelectors.get(); }
    void setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class RuleMatchBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RuleSet = 1 << 1,
            MatchingSelectorsSet = 1 << 2,
            AllFieldsSet = (RuleSet | MatchingSelectorsSet | 0)};


        RuleMatchBuilder<STATE | RuleSet>& setRule(std::unique_ptr<protocol::CSS::CSSRule> value);  // Defined below

        RuleMatchBuilder<STATE | MatchingSelectorsSet>& setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<RuleMatch> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RuleMatch;
        RuleMatchBuilder() : m_result(new RuleMatch()) { }

        template<int STEP> RuleMatchBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RuleMatchBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::RuleMatch> m_result;
    };

    static RuleMatchBuilder<0> create()
    {
        return RuleMatchBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RuleMatch();  // Defined below

    std::unique_ptr<protocol::CSS::CSSRule> m_rule;
    std::unique_ptr<protocol::Array<int>> m_matchingSelectors;
};


class UI_DEVTOOLS_EXPORT Value : public ::crdtp::ProtocolObject<Value> {
public:
    ~Value() override;  // Defined below

    String getText() { return m_text; }
    void setText(const String& value);  // Defined below

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

    template<int STATE>
    class ValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            AllFieldsSet = (TextSet | 0)};


        ValueBuilder<STATE | TextSet>& setText(const String& value);  // Defined below

        ValueBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

        std::unique_ptr<Value> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Value;
        ValueBuilder() : m_result(new Value()) { }

        template<int STEP> ValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::Value> m_result;
    };

    static ValueBuilder<0> create()
    {
        return ValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Value();  // Defined below

    String m_text;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
};


class UI_DEVTOOLS_EXPORT SelectorList : public ::crdtp::ProtocolObject<SelectorList> {
public:
    ~SelectorList() override;  // Defined below

    protocol::Array<protocol::CSS::Value>* getSelectors() { return m_selectors.get(); }
    void setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value);  // Defined below

    template<int STATE>
    class SelectorListBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SelectorsSet = 1 << 1,
            AllFieldsSet = (SelectorsSet | 0)};


        SelectorListBuilder<STATE | SelectorsSet>& setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value);  // Defined below

        std::unique_ptr<SelectorList> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SelectorList;
        SelectorListBuilder() : m_result(new SelectorList()) { }

        template<int STEP> SelectorListBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SelectorListBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::SelectorList> m_result;
    };

    static SelectorListBuilder<0> create()
    {
        return SelectorListBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SelectorList();  // Defined below

    std::unique_ptr<protocol::Array<protocol::CSS::Value>> m_selectors;
};


class UI_DEVTOOLS_EXPORT CSSStyleSheetHeader : public ::crdtp::ProtocolObject<CSSStyleSheetHeader> {
public:
    ~CSSStyleSheetHeader() override;  // Defined below

    String getStyleSheetId() { return m_styleSheetId; }
    void setStyleSheetId(const String& value);  // Defined below

    String getSourceURL() { return m_sourceURL; }
    void setSourceURL(const String& value);  // Defined below

    double getStartLine() { return m_startLine; }
    void setStartLine(double value);  // Defined below

    double getStartColumn() { return m_startColumn; }
    void setStartColumn(double value);  // Defined below

    template<int STATE>
    class CSSStyleSheetHeaderBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSheetIdSet = 1 << 1,
            SourceURLSet = 1 << 2,
            StartLineSet = 1 << 3,
            StartColumnSet = 1 << 4,
            AllFieldsSet = (StyleSheetIdSet | SourceURLSet | StartLineSet | StartColumnSet | 0)};


        CSSStyleSheetHeaderBuilder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value);  // Defined below

        CSSStyleSheetHeaderBuilder<STATE | SourceURLSet>& setSourceURL(const String& value);  // Defined below

        CSSStyleSheetHeaderBuilder<STATE | StartLineSet>& setStartLine(double value);  // Defined below

        CSSStyleSheetHeaderBuilder<STATE | StartColumnSet>& setStartColumn(double value);  // Defined below

        std::unique_ptr<CSSStyleSheetHeader> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSStyleSheetHeader;
        CSSStyleSheetHeaderBuilder() : m_result(new CSSStyleSheetHeader()) { }

        template<int STEP> CSSStyleSheetHeaderBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSStyleSheetHeaderBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSStyleSheetHeader> m_result;
    };

    static CSSStyleSheetHeaderBuilder<0> create()
    {
        return CSSStyleSheetHeaderBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSStyleSheetHeader();  // Defined below

    String m_styleSheetId;
    String m_sourceURL;
    double m_startLine;
    double m_startColumn;
};


class UI_DEVTOOLS_EXPORT CSSRule : public ::crdtp::ProtocolObject<CSSRule> {
public:
    ~CSSRule() override;  // Defined below

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value);  // Defined below

    protocol::CSS::SelectorList* getSelectorList() { return m_selectorList.get(); }
    void setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value);  // Defined below

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value);  // Defined below

    template<int STATE>
    class CSSRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SelectorListSet = 1 << 1,
            StyleSet = 1 << 2,
            AllFieldsSet = (SelectorListSet | StyleSet | 0)};


        CSSRuleBuilder<STATE>& setStyleSheetId(const String& value);  // Defined below

        CSSRuleBuilder<STATE | SelectorListSet>& setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value);  // Defined below

        CSSRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value);  // Defined below

        std::unique_ptr<CSSRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSRule;
        CSSRuleBuilder() : m_result(new CSSRule()) { }

        template<int STEP> CSSRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSRule> m_result;
    };

    static CSSRuleBuilder<0> create()
    {
        return CSSRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSRule();  // Defined below

    std::optional<String> m_styleSheetId;
    std::unique_ptr<protocol::CSS::SelectorList> m_selectorList;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class UI_DEVTOOLS_EXPORT StyleDeclarationEdit : public ::crdtp::ProtocolObject<StyleDeclarationEdit> {
public:
    ~StyleDeclarationEdit() override;  // Defined below

    String getStyleSheetId() { return m_styleSheetId; }
    void setStyleSheetId(const String& value);  // Defined below

    protocol::CSS::SourceRange* getRange() { return m_range.get(); }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

    String getText() { return m_text; }
    void setText(const String& value);  // Defined below

    template<int STATE>
    class StyleDeclarationEditBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSheetIdSet = 1 << 1,
            RangeSet = 1 << 2,
            TextSet = 1 << 3,
            AllFieldsSet = (StyleSheetIdSet | RangeSet | TextSet | 0)};


        StyleDeclarationEditBuilder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value);  // Defined below

        StyleDeclarationEditBuilder<STATE | RangeSet>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value);  // Defined below

        StyleDeclarationEditBuilder<STATE | TextSet>& setText(const String& value);  // Defined below

        std::unique_ptr<StyleDeclarationEdit> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StyleDeclarationEdit;
        StyleDeclarationEditBuilder() : m_result(new StyleDeclarationEdit()) { }

        template<int STEP> StyleDeclarationEditBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StyleDeclarationEditBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::StyleDeclarationEdit> m_result;
    };

    static StyleDeclarationEditBuilder<0> create()
    {
        return StyleDeclarationEditBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StyleDeclarationEdit();  // Defined below

    String m_styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    String m_text;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline SourceRange::~SourceRange() = default;
inline void SourceRange::setStartLine(int value) { m_startLine = value; }
inline void SourceRange::setStartColumn(int value) { m_startColumn = value; }
inline void SourceRange::setEndLine(int value) { m_endLine = value; }
inline void SourceRange::setEndColumn(int value) { m_endColumn = value; }

template<int STATE>
inline SourceRange::SourceRangeBuilder<STATE | SourceRange::SourceRangeBuilder<STATE>::StartLineSet>&
SourceRange::SourceRangeBuilder<STATE>::setStartLine(int value) {
  static_assert(!(STATE & StartLineSet), "property startLine should not be set yet");
  m_result->setStartLine(value);
  return castState<StartLineSet>();
}
template<int STATE>
inline SourceRange::SourceRangeBuilder<STATE | SourceRange::SourceRangeBuilder<STATE>::StartColumnSet>&
SourceRange::SourceRangeBuilder<STATE>::setStartColumn(int value) {
  static_assert(!(STATE & StartColumnSet), "property startColumn should not be set yet");
  m_result->setStartColumn(value);
  return castState<StartColumnSet>();
}
template<int STATE>
inline SourceRange::SourceRangeBuilder<STATE | SourceRange::SourceRangeBuilder<STATE>::EndLineSet>&
SourceRange::SourceRangeBuilder<STATE>::setEndLine(int value) {
  static_assert(!(STATE & EndLineSet), "property endLine should not be set yet");
  m_result->setEndLine(value);
  return castState<EndLineSet>();
}
template<int STATE>
inline SourceRange::SourceRangeBuilder<STATE | SourceRange::SourceRangeBuilder<STATE>::EndColumnSet>&
SourceRange::SourceRangeBuilder<STATE>::setEndColumn(int value) {
  static_assert(!(STATE & EndColumnSet), "property endColumn should not be set yet");
  m_result->setEndColumn(value);
  return castState<EndColumnSet>();
}

inline SourceRange::SourceRange() {
  m_startLine = 0;
  m_startColumn = 0;
  m_endLine = 0;
  m_endColumn = 0;
}
inline ShorthandEntry::~ShorthandEntry() = default;
inline void ShorthandEntry::setName(const String& value) { m_name = value; }
inline void ShorthandEntry::setValue(const String& value) { m_value = value; }
inline void ShorthandEntry::setImportant(bool value) { m_important = value; }

template<int STATE>
inline ShorthandEntry::ShorthandEntryBuilder<STATE | ShorthandEntry::ShorthandEntryBuilder<STATE>::NameSet>&
ShorthandEntry::ShorthandEntryBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline ShorthandEntry::ShorthandEntryBuilder<STATE | ShorthandEntry::ShorthandEntryBuilder<STATE>::ValueSet>&
ShorthandEntry::ShorthandEntryBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}
template<int STATE>
inline ShorthandEntry::ShorthandEntryBuilder<STATE>& ShorthandEntry::ShorthandEntryBuilder<STATE>::setImportant(bool value) {
  m_result->setImportant(value);
  return *this;
}

inline ShorthandEntry::ShorthandEntry() {
}
inline CSSStyle::~CSSStyle() = default;
inline void CSSStyle::setStyleSheetId(const String& value) { m_styleSheetId = value; }
inline void CSSStyle::setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value) { m_cssProperties = std::move(value); }
inline void CSSStyle::setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value) { m_shorthandEntries = std::move(value); }
inline void CSSStyle::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

template<int STATE>
inline CSSStyle::CSSStyleBuilder<STATE>& CSSStyle::CSSStyleBuilder<STATE>::setStyleSheetId(const String& value) {
  m_result->setStyleSheetId(value);
  return *this;
}
template<int STATE>
inline CSSStyle::CSSStyleBuilder<STATE | CSSStyle::CSSStyleBuilder<STATE>::CssPropertiesSet>&
CSSStyle::CSSStyleBuilder<STATE>::setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value) {
  static_assert(!(STATE & CssPropertiesSet), "property cssProperties should not be set yet");
  m_result->setCssProperties(std::move(value));
  return castState<CssPropertiesSet>();
}
template<int STATE>
inline CSSStyle::CSSStyleBuilder<STATE | CSSStyle::CSSStyleBuilder<STATE>::ShorthandEntriesSet>&
CSSStyle::CSSStyleBuilder<STATE>::setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value) {
  static_assert(!(STATE & ShorthandEntriesSet), "property shorthandEntries should not be set yet");
  m_result->setShorthandEntries(std::move(value));
  return castState<ShorthandEntriesSet>();
}
template<int STATE>
inline CSSStyle::CSSStyleBuilder<STATE>& CSSStyle::CSSStyleBuilder<STATE>::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) {
  m_result->setRange(std::move(value));
  return *this;
}

inline CSSStyle::CSSStyle() {
}
inline CSSProperty::~CSSProperty() = default;
inline void CSSProperty::setName(const String& value) { m_name = value; }
inline void CSSProperty::setValue(const String& value) { m_value = value; }
inline void CSSProperty::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

template<int STATE>
inline CSSProperty::CSSPropertyBuilder<STATE | CSSProperty::CSSPropertyBuilder<STATE>::NameSet>&
CSSProperty::CSSPropertyBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline CSSProperty::CSSPropertyBuilder<STATE | CSSProperty::CSSPropertyBuilder<STATE>::ValueSet>&
CSSProperty::CSSPropertyBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}
template<int STATE>
inline CSSProperty::CSSPropertyBuilder<STATE>& CSSProperty::CSSPropertyBuilder<STATE>::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) {
  m_result->setRange(std::move(value));
  return *this;
}

inline CSSProperty::CSSProperty() {
}
inline RuleMatch::~RuleMatch() = default;
inline void RuleMatch::setRule(std::unique_ptr<protocol::CSS::CSSRule> value) { m_rule = std::move(value); }
inline void RuleMatch::setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value) { m_matchingSelectors = std::move(value); }

template<int STATE>
inline RuleMatch::RuleMatchBuilder<STATE | RuleMatch::RuleMatchBuilder<STATE>::RuleSet>&
RuleMatch::RuleMatchBuilder<STATE>::setRule(std::unique_ptr<protocol::CSS::CSSRule> value) {
  static_assert(!(STATE & RuleSet), "property rule should not be set yet");
  m_result->setRule(std::move(value));
  return castState<RuleSet>();
}
template<int STATE>
inline RuleMatch::RuleMatchBuilder<STATE | RuleMatch::RuleMatchBuilder<STATE>::MatchingSelectorsSet>&
RuleMatch::RuleMatchBuilder<STATE>::setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & MatchingSelectorsSet), "property matchingSelectors should not be set yet");
  m_result->setMatchingSelectors(std::move(value));
  return castState<MatchingSelectorsSet>();
}

inline RuleMatch::RuleMatch() {
}
inline Value::~Value() = default;
inline void Value::setText(const String& value) { m_text = value; }
inline void Value::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

template<int STATE>
inline Value::ValueBuilder<STATE | Value::ValueBuilder<STATE>::TextSet>&
Value::ValueBuilder<STATE>::setText(const String& value) {
  static_assert(!(STATE & TextSet), "property text should not be set yet");
  m_result->setText(value);
  return castState<TextSet>();
}
template<int STATE>
inline Value::ValueBuilder<STATE>& Value::ValueBuilder<STATE>::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) {
  m_result->setRange(std::move(value));
  return *this;
}

inline Value::Value() {
}
inline SelectorList::~SelectorList() = default;
inline void SelectorList::setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value) { m_selectors = std::move(value); }

template<int STATE>
inline SelectorList::SelectorListBuilder<STATE | SelectorList::SelectorListBuilder<STATE>::SelectorsSet>&
SelectorList::SelectorListBuilder<STATE>::setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value) {
  static_assert(!(STATE & SelectorsSet), "property selectors should not be set yet");
  m_result->setSelectors(std::move(value));
  return castState<SelectorsSet>();
}

inline SelectorList::SelectorList() {
}
inline CSSStyleSheetHeader::~CSSStyleSheetHeader() = default;
inline void CSSStyleSheetHeader::setStyleSheetId(const String& value) { m_styleSheetId = value; }
inline void CSSStyleSheetHeader::setSourceURL(const String& value) { m_sourceURL = value; }
inline void CSSStyleSheetHeader::setStartLine(double value) { m_startLine = value; }
inline void CSSStyleSheetHeader::setStartColumn(double value) { m_startColumn = value; }

template<int STATE>
inline CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE | CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::StyleSheetIdSet>&
CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::setStyleSheetId(const String& value) {
  static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId should not be set yet");
  m_result->setStyleSheetId(value);
  return castState<StyleSheetIdSet>();
}
template<int STATE>
inline CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE | CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::SourceURLSet>&
CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::setSourceURL(const String& value) {
  static_assert(!(STATE & SourceURLSet), "property sourceURL should not be set yet");
  m_result->setSourceURL(value);
  return castState<SourceURLSet>();
}
template<int STATE>
inline CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE | CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::StartLineSet>&
CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::setStartLine(double value) {
  static_assert(!(STATE & StartLineSet), "property startLine should not be set yet");
  m_result->setStartLine(value);
  return castState<StartLineSet>();
}
template<int STATE>
inline CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE | CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::StartColumnSet>&
CSSStyleSheetHeader::CSSStyleSheetHeaderBuilder<STATE>::setStartColumn(double value) {
  static_assert(!(STATE & StartColumnSet), "property startColumn should not be set yet");
  m_result->setStartColumn(value);
  return castState<StartColumnSet>();
}

inline CSSStyleSheetHeader::CSSStyleSheetHeader() {
  m_startLine = 0;
  m_startColumn = 0;
}
inline CSSRule::~CSSRule() = default;
inline void CSSRule::setStyleSheetId(const String& value) { m_styleSheetId = value; }
inline void CSSRule::setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value) { m_selectorList = std::move(value); }
inline void CSSRule::setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

template<int STATE>
inline CSSRule::CSSRuleBuilder<STATE>& CSSRule::CSSRuleBuilder<STATE>::setStyleSheetId(const String& value) {
  m_result->setStyleSheetId(value);
  return *this;
}
template<int STATE>
inline CSSRule::CSSRuleBuilder<STATE | CSSRule::CSSRuleBuilder<STATE>::SelectorListSet>&
CSSRule::CSSRuleBuilder<STATE>::setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value) {
  static_assert(!(STATE & SelectorListSet), "property selectorList should not be set yet");
  m_result->setSelectorList(std::move(value));
  return castState<SelectorListSet>();
}
template<int STATE>
inline CSSRule::CSSRuleBuilder<STATE | CSSRule::CSSRuleBuilder<STATE>::StyleSet>&
CSSRule::CSSRuleBuilder<STATE>::setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) {
  static_assert(!(STATE & StyleSet), "property style should not be set yet");
  m_result->setStyle(std::move(value));
  return castState<StyleSet>();
}

inline CSSRule::CSSRule() {
}
inline StyleDeclarationEdit::~StyleDeclarationEdit() = default;
inline void StyleDeclarationEdit::setStyleSheetId(const String& value) { m_styleSheetId = value; }
inline void StyleDeclarationEdit::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }
inline void StyleDeclarationEdit::setText(const String& value) { m_text = value; }

template<int STATE>
inline StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE | StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::StyleSheetIdSet>&
StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::setStyleSheetId(const String& value) {
  static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId should not be set yet");
  m_result->setStyleSheetId(value);
  return castState<StyleSheetIdSet>();
}
template<int STATE>
inline StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE | StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::RangeSet>&
StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::setRange(std::unique_ptr<protocol::CSS::SourceRange> value) {
  static_assert(!(STATE & RangeSet), "property range should not be set yet");
  m_result->setRange(std::move(value));
  return castState<RangeSet>();
}
template<int STATE>
inline StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE | StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::TextSet>&
StyleDeclarationEdit::StyleDeclarationEditBuilder<STATE>::setText(const String& value) {
  static_assert(!(STATE & TextSet), "property text should not be set yet");
  m_result->setText(value);
  return castState<TextSet>();
}

inline StyleDeclarationEdit::StyleDeclarationEdit() {
}

// ------------- Backend interface.

class UI_DEVTOOLS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getMatchedStylesForNode(int in_nodeId, std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>>* out_matchedCSSRules) = 0;
    virtual DispatchResponse getStyleSheetText(const String& in_styleSheetId, String* out_text) = 0;
    virtual DispatchResponse setStyleTexts(std::unique_ptr<protocol::Array<protocol::CSS::StyleDeclarationEdit>> in_edits, std::unique_ptr<protocol::Array<protocol::CSS::CSSStyle>>* out_styles) = 0;

};

// ------------- Frontend interface.

class UI_DEVTOOLS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void styleSheetChanged(const String& styleSheetId);
    void styleSheetAdded(std::unique_ptr<protocol::CSS::CSSStyleSheetHeader> header);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class UI_DEVTOOLS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class UI_DEVTOOLS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace CSS
} // namespace ui_devtools
} // namespace protocol

#endif // !defined(ui_devtools_protocol_CSS_h)
