// components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SYSTEM_MEDIA_CONTROLS_MAC_REMOTE_COCOA_SYSTEM_MEDIA_CONTROLS_MOJOM_H_
#define COMPONENTS_SYSTEM_MEDIA_CONTROLS_MAC_REMOTE_COCOA_SYSTEM_MEDIA_CONTROLS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-features.h"  // IWYU pragma: export
#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-shared.h"  // IWYU pragma: export
#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace system_media_controls::mojom {

class SystemMediaControlsProxy;

template <typename ImplRefTraits>
class SystemMediaControlsStub;

class SystemMediaControlsRequestValidator;


class SystemMediaControls
    : public SystemMediaControlsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "system_media_controls.mojom.SystemMediaControls";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SystemMediaControlsInterfaceBase;
  using Proxy_ = SystemMediaControlsProxy;

  template <typename ImplRefTraits>
  using Stub_ = SystemMediaControlsStub<ImplRefTraits>;

  using RequestValidator_ = SystemMediaControlsRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetIsNextEnabledMinVersion = 0,
    kSetIsPreviousEnabledMinVersion = 0,
    kSetIsPlayPauseEnabledMinVersion = 0,
    kSetIsStopEnabledMinVersion = 0,
    kSetIsSeekToEnabledMinVersion = 0,
    kSetPlaybackStatusMinVersion = 0,
    kSetTitleMinVersion = 0,
    kSetArtistMinVersion = 0,
    kSetAlbumMinVersion = 0,
    kSetThumbnailMinVersion = 0,
    kSetPositionMinVersion = 0,
    kClearMetadataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetIsNextEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsPreviousEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsPlayPauseEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsStopEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsSeekToEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPlaybackStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetArtist_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAlbum_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetThumbnail_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPosition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SystemMediaControls() = default;

  virtual void SetIsNextEnabled(bool enabled) = 0;

  virtual void SetIsPreviousEnabled(bool enabled) = 0;

  virtual void SetIsPlayPauseEnabled(bool enabled) = 0;

  virtual void SetIsStopEnabled(bool enabled) = 0;

  virtual void SetIsSeekToEnabled(bool enabled) = 0;

  virtual void SetPlaybackStatus(PlaybackStatus status) = 0;

  virtual void SetTitle(const ::std::u16string& title) = 0;

  virtual void SetArtist(const ::std::u16string& artist) = 0;

  virtual void SetAlbum(const ::std::u16string& album) = 0;

  virtual void SetThumbnail(const ::SkBitmap& thumbnail) = 0;

  virtual void SetPosition(const ::media_session::MediaPosition& position) = 0;

  virtual void ClearMetadata() = 0;
};

class SystemMediaControlsObserverProxy;

template <typename ImplRefTraits>
class SystemMediaControlsObserverStub;

class SystemMediaControlsObserverRequestValidator;


class SystemMediaControlsObserver
    : public SystemMediaControlsObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "system_media_controls.mojom.SystemMediaControlsObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SystemMediaControlsObserverInterfaceBase;
  using Proxy_ = SystemMediaControlsObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SystemMediaControlsObserverStub<ImplRefTraits>;

  using RequestValidator_ = SystemMediaControlsObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNextMinVersion = 0,
    kOnPreviousMinVersion = 0,
    kOnPauseMinVersion = 0,
    kOnPlayPauseMinVersion = 0,
    kOnStopMinVersion = 0,
    kOnPlayMinVersion = 0,
    kOnSeekToMinVersion = 0,
    kOnBridgeCreatedForTestingMinVersion = 0,
    kOnMetadataClearedForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPrevious_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPlayPause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSeekTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBridgeCreatedForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMetadataClearedForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SystemMediaControlsObserver() = default;

  virtual void OnNext() = 0;

  virtual void OnPrevious() = 0;

  virtual void OnPause() = 0;

  virtual void OnPlayPause() = 0;

  virtual void OnStop() = 0;

  virtual void OnPlay() = 0;

  virtual void OnSeekTo(::base::TimeDelta seek_time) = 0;

  virtual void OnBridgeCreatedForTesting() = 0;

  virtual void OnMetadataClearedForTesting() = 0;
};



class  SystemMediaControlsProxy
    : public SystemMediaControls {
 public:
  using InterfaceType = SystemMediaControls;

  explicit SystemMediaControlsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetIsNextEnabled(bool enabled) final;
  
  void SetIsPreviousEnabled(bool enabled) final;
  
  void SetIsPlayPauseEnabled(bool enabled) final;
  
  void SetIsStopEnabled(bool enabled) final;
  
  void SetIsSeekToEnabled(bool enabled) final;
  
  void SetPlaybackStatus(PlaybackStatus status) final;
  
  void SetTitle(const ::std::u16string& title) final;
  
  void SetArtist(const ::std::u16string& artist) final;
  
  void SetAlbum(const ::std::u16string& album) final;
  
  void SetThumbnail(const ::SkBitmap& thumbnail) final;
  
  void SetPosition(const ::media_session::MediaPosition& position) final;
  
  void ClearMetadata() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SystemMediaControlsObserverProxy
    : public SystemMediaControlsObserver {
 public:
  using InterfaceType = SystemMediaControlsObserver;

  explicit SystemMediaControlsObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNext() final;
  
  void OnPrevious() final;
  
  void OnPause() final;
  
  void OnPlayPause() final;
  
  void OnStop() final;
  
  void OnPlay() final;
  
  void OnSeekTo(::base::TimeDelta seek_time) final;
  
  void OnBridgeCreatedForTesting() final;
  
  void OnMetadataClearedForTesting() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SystemMediaControlsStubDispatch {
 public:
  static bool Accept(SystemMediaControls* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SystemMediaControls* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SystemMediaControls>>
class SystemMediaControlsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SystemMediaControlsStub() = default;
  ~SystemMediaControlsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemMediaControlsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemMediaControlsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SystemMediaControlsObserverStubDispatch {
 public:
  static bool Accept(SystemMediaControlsObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SystemMediaControlsObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SystemMediaControlsObserver>>
class SystemMediaControlsObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SystemMediaControlsObserverStub() = default;
  ~SystemMediaControlsObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemMediaControlsObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemMediaControlsObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SystemMediaControlsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SystemMediaControlsObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // system_media_controls::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SYSTEM_MEDIA_CONTROLS_MAC_REMOTE_COCOA_SYSTEM_MEDIA_CONTROLS_MOJOM_H_