// components/subresource_filter/content/mojom/subresource_filter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CONTENT_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CONTENT_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/subresource_filter/content/mojom/subresource_filter.mojom-features.h"  // IWYU pragma: export
#include "components/subresource_filter/content/mojom/subresource_filter.mojom-shared.h"  // IWYU pragma: export
#include "components/subresource_filter/content/mojom/subresource_filter.mojom-forward.h"  // IWYU pragma: export
#include "components/subresource_filter/core/mojom/subresource_filter.mojom-forward.h"
#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace subresource_filter::mojom {

class SubresourceFilterAgentProxy;

template <typename ImplRefTraits>
class SubresourceFilterAgentStub;

class SubresourceFilterAgentRequestValidator;


class SubresourceFilterAgent
    : public SubresourceFilterAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "subresource_filter.mojom.SubresourceFilterAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SubresourceFilterAgentInterfaceBase;
  using Proxy_ = SubresourceFilterAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = SubresourceFilterAgentStub<ImplRefTraits>;

  using RequestValidator_ = SubresourceFilterAgentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kActivateForNextCommittedLoadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ActivateForNextCommittedLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SubresourceFilterAgent() = default;

  virtual void ActivateForNextCommittedLoad(::subresource_filter::mojom::ActivationStatePtr activation_state, const std::optional<::blink::FrameAdEvidence>& ad_evidence) = 0;
};

class SubresourceFilterHostProxy;

template <typename ImplRefTraits>
class SubresourceFilterHostStub;

class SubresourceFilterHostRequestValidator;


class SubresourceFilterHost
    : public SubresourceFilterHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "subresource_filter.mojom.SubresourceFilterHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SubresourceFilterHostInterfaceBase;
  using Proxy_ = SubresourceFilterHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SubresourceFilterHostStub<ImplRefTraits>;

  using RequestValidator_ = SubresourceFilterHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidDisallowFirstSubresourceMinVersion = 0,
    kFrameIsAdMinVersion = 0,
    kFrameWasCreatedByAdScriptMinVersion = 0,
    kAdScriptDidCreateFencedFrameMinVersion = 0,
    kSetDocumentLoadStatisticsMinVersion = 0,
    kOnAdsViolationTriggeredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidDisallowFirstSubresource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameIsAd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameWasCreatedByAdScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdScriptDidCreateFencedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDocumentLoadStatistics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAdsViolationTriggered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SubresourceFilterHost() = default;

  virtual void DidDisallowFirstSubresource() = 0;

  virtual void FrameIsAd() = 0;

  virtual void FrameWasCreatedByAdScript() = 0;

  virtual void AdScriptDidCreateFencedFrame(const ::blink::RemoteFrameToken& fenced_frame_root_placeholder_token) = 0;

  virtual void SetDocumentLoadStatistics(::subresource_filter::mojom::DocumentLoadStatisticsPtr statistics) = 0;

  virtual void OnAdsViolationTriggered(::subresource_filter::mojom::AdsViolation violation) = 0;
};



class  SubresourceFilterAgentProxy
    : public SubresourceFilterAgent {
 public:
  using InterfaceType = SubresourceFilterAgent;

  explicit SubresourceFilterAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ActivateForNextCommittedLoad(::subresource_filter::mojom::ActivationStatePtr activation_state, const std::optional<::blink::FrameAdEvidence>& ad_evidence) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SubresourceFilterHostProxy
    : public SubresourceFilterHost {
 public:
  using InterfaceType = SubresourceFilterHost;

  explicit SubresourceFilterHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidDisallowFirstSubresource() final;
  
  void FrameIsAd() final;
  
  void FrameWasCreatedByAdScript() final;
  
  void AdScriptDidCreateFencedFrame(const ::blink::RemoteFrameToken& fenced_frame_root_placeholder_token) final;
  
  void SetDocumentLoadStatistics(::subresource_filter::mojom::DocumentLoadStatisticsPtr statistics) final;
  
  void OnAdsViolationTriggered(::subresource_filter::mojom::AdsViolation violation) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SubresourceFilterAgentStubDispatch {
 public:
  static bool Accept(SubresourceFilterAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SubresourceFilterAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SubresourceFilterAgent>>
class SubresourceFilterAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SubresourceFilterAgentStub() = default;
  ~SubresourceFilterAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SubresourceFilterHostStubDispatch {
 public:
  static bool Accept(SubresourceFilterHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SubresourceFilterHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SubresourceFilterHost>>
class SubresourceFilterHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SubresourceFilterHostStub() = default;
  ~SubresourceFilterHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubresourceFilterHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SubresourceFilterAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SubresourceFilterHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // subresource_filter::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CONTENT_MOJOM_SUBRESOURCE_FILTER_MOJOM_H_