// components/subresource_filter/content/mojom/subresource_filter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/subresource_filter/content/mojom/subresource_filter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/subresource_filter/content/mojom/subresource_filter.mojom-params-data.h"
#include "components/subresource_filter/content/mojom/subresource_filter.mojom-shared-message-ids.h"

#include "components/subresource_filter/content/mojom/subresource_filter.mojom-import-headers.h"
#include "components/subresource_filter/content/mojom/subresource_filter.mojom-test-utils.h"


namespace subresource_filter::mojom {
// The declaration includes the definition on other builds.

SubresourceFilterAgent::IPCStableHashFunction SubresourceFilterAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SubresourceFilterAgent>(message.name())) {
    case messages::SubresourceFilterAgent::kActivateForNextCommittedLoad: {
      return &SubresourceFilterAgent::ActivateForNextCommittedLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SubresourceFilterAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SubresourceFilterAgent>(message.name())) {
      case messages::SubresourceFilterAgent::kActivateForNextCommittedLoad:
            return "Receive subresource_filter::mojom::SubresourceFilterAgent::ActivateForNextCommittedLoad";
    }
  } else {
    switch (static_cast<messages::SubresourceFilterAgent>(message.name())) {
      case messages::SubresourceFilterAgent::kActivateForNextCommittedLoad:
            return "Receive reply subresource_filter::mojom::SubresourceFilterAgent::ActivateForNextCommittedLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SubresourceFilterAgent::ActivateForNextCommittedLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80ffe9f3;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterAgent::ActivateForNextCommittedLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SubresourceFilterAgentProxy::SubresourceFilterAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubresourceFilterAgentProxy::ActivateForNextCommittedLoad(
    ::subresource_filter::mojom::ActivationStatePtr in_activation_state, const std::optional<::blink::FrameAdEvidence>& in_ad_evidence) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send subresource_filter::mojom::SubresourceFilterAgent::ActivateForNextCommittedLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_state"), in_activation_state,
                        "<value of type ::subresource_filter::mojom::ActivationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_evidence"), in_ad_evidence,
                        "<value of type const std::optional<::blink::FrameAdEvidence>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterAgent::kActivateForNextCommittedLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterAgent_ActivateForNextCommittedLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->activation_state)::BaseType> activation_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::subresource_filter::mojom::ActivationStateDataView>(
    in_activation_state,
    activation_state_fragment);

  params->activation_state.Set(
      activation_state_fragment.is_null() ? nullptr : activation_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->activation_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null activation_state in SubresourceFilterAgent.ActivateForNextCommittedLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->ad_evidence)::BaseType> ad_evidence_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameAdEvidenceDataView>(
    in_ad_evidence,
    ad_evidence_fragment);

  params->ad_evidence.Set(
      ad_evidence_fragment.is_null() ? nullptr : ad_evidence_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterAgent::Name_);
  message.set_method_name("ActivateForNextCommittedLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SubresourceFilterAgentStubDispatch::Accept(
    SubresourceFilterAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SubresourceFilterAgent>(message->header()->name)) {
    case messages::SubresourceFilterAgent::kActivateForNextCommittedLoad: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterAgent_ActivateForNextCommittedLoad_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterAgent_ActivateForNextCommittedLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterAgent.0
      bool success = true;
      ::subresource_filter::mojom::ActivationStatePtr p_activation_state{};
      std::optional<::blink::FrameAdEvidence> p_ad_evidence{};
      SubresourceFilterAgent_ActivateForNextCommittedLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActivationState(&p_activation_state))
        success = false;
      if (success && !input_data_view.ReadAdEvidence(&p_ad_evidence))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateForNextCommittedLoad(        
        std::move(p_activation_state), 
        std::move(p_ad_evidence));
      return true;
    }
  }
  return false;
}

// static
bool SubresourceFilterAgentStubDispatch::AcceptWithResponder(
    SubresourceFilterAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SubresourceFilterAgent>(message->header()->name)) {
    case messages::SubresourceFilterAgent::kActivateForNextCommittedLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSubresourceFilterAgentValidationInfo[] = {
    { &internal::SubresourceFilterAgent_ActivateForNextCommittedLoad_Params_Data::Validate,
     nullptr /* no response */},
};

bool SubresourceFilterAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::subresource_filter::mojom::SubresourceFilterAgent::Name_,
    kSubresourceFilterAgentValidationInfo);
}

// The declaration includes the definition on other builds.

SubresourceFilterHost::IPCStableHashFunction SubresourceFilterHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SubresourceFilterHost>(message.name())) {
    case messages::SubresourceFilterHost::kDidDisallowFirstSubresource: {
      return &SubresourceFilterHost::DidDisallowFirstSubresource_Sym::IPCStableHash;
    }
    case messages::SubresourceFilterHost::kFrameIsAd: {
      return &SubresourceFilterHost::FrameIsAd_Sym::IPCStableHash;
    }
    case messages::SubresourceFilterHost::kFrameWasCreatedByAdScript: {
      return &SubresourceFilterHost::FrameWasCreatedByAdScript_Sym::IPCStableHash;
    }
    case messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame: {
      return &SubresourceFilterHost::AdScriptDidCreateFencedFrame_Sym::IPCStableHash;
    }
    case messages::SubresourceFilterHost::kSetDocumentLoadStatistics: {
      return &SubresourceFilterHost::SetDocumentLoadStatistics_Sym::IPCStableHash;
    }
    case messages::SubresourceFilterHost::kOnAdsViolationTriggered: {
      return &SubresourceFilterHost::OnAdsViolationTriggered_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SubresourceFilterHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SubresourceFilterHost>(message.name())) {
      case messages::SubresourceFilterHost::kDidDisallowFirstSubresource:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::DidDisallowFirstSubresource";
      case messages::SubresourceFilterHost::kFrameIsAd:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::FrameIsAd";
      case messages::SubresourceFilterHost::kFrameWasCreatedByAdScript:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::FrameWasCreatedByAdScript";
      case messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::AdScriptDidCreateFencedFrame";
      case messages::SubresourceFilterHost::kSetDocumentLoadStatistics:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::SetDocumentLoadStatistics";
      case messages::SubresourceFilterHost::kOnAdsViolationTriggered:
            return "Receive subresource_filter::mojom::SubresourceFilterHost::OnAdsViolationTriggered";
    }
  } else {
    switch (static_cast<messages::SubresourceFilterHost>(message.name())) {
      case messages::SubresourceFilterHost::kDidDisallowFirstSubresource:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::DidDisallowFirstSubresource";
      case messages::SubresourceFilterHost::kFrameIsAd:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::FrameIsAd";
      case messages::SubresourceFilterHost::kFrameWasCreatedByAdScript:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::FrameWasCreatedByAdScript";
      case messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::AdScriptDidCreateFencedFrame";
      case messages::SubresourceFilterHost::kSetDocumentLoadStatistics:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::SetDocumentLoadStatistics";
      case messages::SubresourceFilterHost::kOnAdsViolationTriggered:
            return "Receive reply subresource_filter::mojom::SubresourceFilterHost::OnAdsViolationTriggered";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SubresourceFilterHost::DidDisallowFirstSubresource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc853df4c;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::DidDisallowFirstSubresource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubresourceFilterHost::FrameIsAd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc53a2cd3;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::FrameIsAd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubresourceFilterHost::FrameWasCreatedByAdScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x072ecd84;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::FrameWasCreatedByAdScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubresourceFilterHost::AdScriptDidCreateFencedFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e79abe6;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::AdScriptDidCreateFencedFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubresourceFilterHost::SetDocumentLoadStatistics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf794418;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::SetDocumentLoadStatistics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubresourceFilterHost::OnAdsViolationTriggered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde082d46;  // IPCStableHash for subresource_filter::mojom::SubresourceFilterHost::OnAdsViolationTriggered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SubresourceFilterHostProxy::SubresourceFilterHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubresourceFilterHostProxy::DidDisallowFirstSubresource(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send subresource_filter::mojom::SubresourceFilterHost::DidDisallowFirstSubresource");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kDidDisallowFirstSubresource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_DidDisallowFirstSubresource_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("DidDisallowFirstSubresource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SubresourceFilterHostProxy::FrameIsAd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send subresource_filter::mojom::SubresourceFilterHost::FrameIsAd");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kFrameIsAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_FrameIsAd_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("FrameIsAd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SubresourceFilterHostProxy::FrameWasCreatedByAdScript(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send subresource_filter::mojom::SubresourceFilterHost::FrameWasCreatedByAdScript");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kFrameWasCreatedByAdScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_FrameWasCreatedByAdScript_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("FrameWasCreatedByAdScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SubresourceFilterHostProxy::AdScriptDidCreateFencedFrame(
    const ::blink::RemoteFrameToken& in_fenced_frame_root_placeholder_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send subresource_filter::mojom::SubresourceFilterHost::AdScriptDidCreateFencedFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fenced_frame_root_placeholder_token"), in_fenced_frame_root_placeholder_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_AdScriptDidCreateFencedFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->fenced_frame_root_placeholder_token)::BaseType> fenced_frame_root_placeholder_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_fenced_frame_root_placeholder_token,
    fenced_frame_root_placeholder_token_fragment);

  params->fenced_frame_root_placeholder_token.Set(
      fenced_frame_root_placeholder_token_fragment.is_null() ? nullptr : fenced_frame_root_placeholder_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fenced_frame_root_placeholder_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fenced_frame_root_placeholder_token in SubresourceFilterHost.AdScriptDidCreateFencedFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("AdScriptDidCreateFencedFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SubresourceFilterHostProxy::SetDocumentLoadStatistics(
    ::subresource_filter::mojom::DocumentLoadStatisticsPtr in_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send subresource_filter::mojom::SubresourceFilterHost::SetDocumentLoadStatistics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statistics"), in_statistics,
                        "<value of type ::subresource_filter::mojom::DocumentLoadStatisticsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kSetDocumentLoadStatistics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_SetDocumentLoadStatistics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->statistics)::BaseType> statistics_fragment(
          params.message());
  
  mojo::internal::Serialize<::subresource_filter::mojom::DocumentLoadStatisticsDataView>(
    in_statistics,
    statistics_fragment);

  params->statistics.Set(
      statistics_fragment.is_null() ? nullptr : statistics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->statistics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null statistics in SubresourceFilterHost.SetDocumentLoadStatistics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("SetDocumentLoadStatistics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SubresourceFilterHostProxy::OnAdsViolationTriggered(
    ::subresource_filter::mojom::AdsViolation in_violation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send subresource_filter::mojom::SubresourceFilterHost::OnAdsViolationTriggered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("violation"), in_violation,
                        "<value of type ::subresource_filter::mojom::AdsViolation>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceFilterHost::kOnAdsViolationTriggered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::subresource_filter::mojom::internal::SubresourceFilterHost_OnAdsViolationTriggered_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::subresource_filter::mojom::AdsViolation>(
    in_violation,
    &params->violation);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceFilterHost::Name_);
  message.set_method_name("OnAdsViolationTriggered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SubresourceFilterHostStubDispatch::Accept(
    SubresourceFilterHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SubresourceFilterHost>(message->header()->name)) {
    case messages::SubresourceFilterHost::kDidDisallowFirstSubresource: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_DidDisallowFirstSubresource_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_DidDisallowFirstSubresource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.0
      bool success = true;
      SubresourceFilterHost_DidDisallowFirstSubresource_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDisallowFirstSubresource(        );
      return true;
    }
    case messages::SubresourceFilterHost::kFrameIsAd: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_FrameIsAd_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_FrameIsAd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.1
      bool success = true;
      SubresourceFilterHost_FrameIsAd_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameIsAd(        );
      return true;
    }
    case messages::SubresourceFilterHost::kFrameWasCreatedByAdScript: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_FrameWasCreatedByAdScript_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_FrameWasCreatedByAdScript_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.2
      bool success = true;
      SubresourceFilterHost_FrameWasCreatedByAdScript_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameWasCreatedByAdScript(        );
      return true;
    }
    case messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_AdScriptDidCreateFencedFrame_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_AdScriptDidCreateFencedFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.3
      bool success = true;
      ::blink::RemoteFrameToken p_fenced_frame_root_placeholder_token{};
      SubresourceFilterHost_AdScriptDidCreateFencedFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFencedFrameRootPlaceholderToken(&p_fenced_frame_root_placeholder_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdScriptDidCreateFencedFrame(        
        std::move(p_fenced_frame_root_placeholder_token));
      return true;
    }
    case messages::SubresourceFilterHost::kSetDocumentLoadStatistics: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_SetDocumentLoadStatistics_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_SetDocumentLoadStatistics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.4
      bool success = true;
      ::subresource_filter::mojom::DocumentLoadStatisticsPtr p_statistics{};
      SubresourceFilterHost_SetDocumentLoadStatistics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatistics(&p_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDocumentLoadStatistics(        
        std::move(p_statistics));
      return true;
    }
    case messages::SubresourceFilterHost::kOnAdsViolationTriggered: {
      DCHECK(message->is_serialized());
      internal::SubresourceFilterHost_OnAdsViolationTriggered_Params_Data* params =
          reinterpret_cast<internal::SubresourceFilterHost_OnAdsViolationTriggered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceFilterHost.5
      bool success = true;
      ::subresource_filter::mojom::AdsViolation p_violation{};
      SubresourceFilterHost_OnAdsViolationTriggered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViolation(&p_violation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceFilterHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAdsViolationTriggered(        
        std::move(p_violation));
      return true;
    }
  }
  return false;
}

// static
bool SubresourceFilterHostStubDispatch::AcceptWithResponder(
    SubresourceFilterHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SubresourceFilterHost>(message->header()->name)) {
    case messages::SubresourceFilterHost::kDidDisallowFirstSubresource: {
      break;
    }
    case messages::SubresourceFilterHost::kFrameIsAd: {
      break;
    }
    case messages::SubresourceFilterHost::kFrameWasCreatedByAdScript: {
      break;
    }
    case messages::SubresourceFilterHost::kAdScriptDidCreateFencedFrame: {
      break;
    }
    case messages::SubresourceFilterHost::kSetDocumentLoadStatistics: {
      break;
    }
    case messages::SubresourceFilterHost::kOnAdsViolationTriggered: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSubresourceFilterHostValidationInfo[] = {
    { &internal::SubresourceFilterHost_DidDisallowFirstSubresource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SubresourceFilterHost_FrameIsAd_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SubresourceFilterHost_FrameWasCreatedByAdScript_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SubresourceFilterHost_AdScriptDidCreateFencedFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SubresourceFilterHost_SetDocumentLoadStatistics_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SubresourceFilterHost_OnAdsViolationTriggered_Params_Data::Validate,
     nullptr /* no response */},
};

bool SubresourceFilterHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::subresource_filter::mojom::SubresourceFilterHost::Name_,
    kSubresourceFilterHostValidationInfo);
}



}  // subresource_filter::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace subresource_filter::mojom {


void SubresourceFilterAgentInterceptorForTesting::ActivateForNextCommittedLoad(::subresource_filter::mojom::ActivationStatePtr activation_state, const std::optional<::blink::FrameAdEvidence>& ad_evidence) {
  GetForwardingInterface()->ActivateForNextCommittedLoad(
    std::move(activation_state)
    , 
    std::move(ad_evidence)
    );
}
SubresourceFilterAgentAsyncWaiter::SubresourceFilterAgentAsyncWaiter(
    SubresourceFilterAgent* proxy) : proxy_(proxy) {}

SubresourceFilterAgentAsyncWaiter::~SubresourceFilterAgentAsyncWaiter() = default;





void SubresourceFilterHostInterceptorForTesting::DidDisallowFirstSubresource() {
  GetForwardingInterface()->DidDisallowFirstSubresource();
}
void SubresourceFilterHostInterceptorForTesting::FrameIsAd() {
  GetForwardingInterface()->FrameIsAd();
}
void SubresourceFilterHostInterceptorForTesting::FrameWasCreatedByAdScript() {
  GetForwardingInterface()->FrameWasCreatedByAdScript();
}
void SubresourceFilterHostInterceptorForTesting::AdScriptDidCreateFencedFrame(const ::blink::RemoteFrameToken& fenced_frame_root_placeholder_token) {
  GetForwardingInterface()->AdScriptDidCreateFencedFrame(
    std::move(fenced_frame_root_placeholder_token)
    );
}
void SubresourceFilterHostInterceptorForTesting::SetDocumentLoadStatistics(::subresource_filter::mojom::DocumentLoadStatisticsPtr statistics) {
  GetForwardingInterface()->SetDocumentLoadStatistics(
    std::move(statistics)
    );
}
void SubresourceFilterHostInterceptorForTesting::OnAdsViolationTriggered(::subresource_filter::mojom::AdsViolation violation) {
  GetForwardingInterface()->OnAdsViolationTriggered(
    std::move(violation)
    );
}
SubresourceFilterHostAsyncWaiter::SubresourceFilterHostAsyncWaiter(
    SubresourceFilterHost* proxy) : proxy_(proxy) {}

SubresourceFilterHostAsyncWaiter::~SubresourceFilterHostAsyncWaiter() = default;







}  // subresource_filter::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif