// components/spellcheck/common/spellcheck_panel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_PANEL_MOJOM_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_PANEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/spellcheck/common/spellcheck_panel.mojom-features.h"  // IWYU pragma: export
#include "components/spellcheck/common/spellcheck_panel.mojom-shared.h"  // IWYU pragma: export
#include "components/spellcheck/common/spellcheck_panel.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace spellcheck::mojom {

class SpellCheckPanelProxy;

template <typename ImplRefTraits>
class SpellCheckPanelStub;

class SpellCheckPanelRequestValidator;


class SpellCheckPanel
    : public SpellCheckPanelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "spellcheck.mojom.SpellCheckPanel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpellCheckPanelInterfaceBase;
  using Proxy_ = SpellCheckPanelProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckPanelStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckPanelRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kToggleSpellPanelMinVersion = 0,
    kAdvanceToNextMisspellingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ToggleSpellPanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceToNextMisspelling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpellCheckPanel() = default;

  virtual void ToggleSpellPanel(bool visible) = 0;

  virtual void AdvanceToNextMisspelling() = 0;
};

class SpellCheckPanelHostProxy;

template <typename ImplRefTraits>
class SpellCheckPanelHostStub;

class SpellCheckPanelHostRequestValidator;


class SpellCheckPanelHost
    : public SpellCheckPanelHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "spellcheck.mojom.SpellCheckPanelHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpellCheckPanelHostInterfaceBase;
  using Proxy_ = SpellCheckPanelHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckPanelHostStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckPanelHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowSpellingPanelMinVersion = 0,
    kUpdateSpellingPanelWithMisspelledWordMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowSpellingPanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSpellingPanelWithMisspelledWord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpellCheckPanelHost() = default;

  virtual void ShowSpellingPanel(bool show) = 0;

  virtual void UpdateSpellingPanelWithMisspelledWord(const ::std::u16string& word) = 0;
};



class  SpellCheckPanelProxy
    : public SpellCheckPanel {
 public:
  using InterfaceType = SpellCheckPanel;

  explicit SpellCheckPanelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ToggleSpellPanel(bool visible) final;
  
  void AdvanceToNextMisspelling() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpellCheckPanelHostProxy
    : public SpellCheckPanelHost {
 public:
  using InterfaceType = SpellCheckPanelHost;

  explicit SpellCheckPanelHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowSpellingPanel(bool show) final;
  
  void UpdateSpellingPanelWithMisspelledWord(const ::std::u16string& word) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpellCheckPanelStubDispatch {
 public:
  static bool Accept(SpellCheckPanel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellCheckPanel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellCheckPanel>>
class SpellCheckPanelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckPanelStub() = default;
  ~SpellCheckPanelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckPanelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckPanelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckPanelHostStubDispatch {
 public:
  static bool Accept(SpellCheckPanelHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellCheckPanelHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellCheckPanelHost>>
class SpellCheckPanelHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckPanelHostStub() = default;
  ~SpellCheckPanelHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckPanelHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckPanelHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckPanelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckPanelHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // spellcheck::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_PANEL_MOJOM_H_