// components/spellcheck/common/spellcheck.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/spellcheck/common/spellcheck.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/spellcheck/common/spellcheck.mojom-data-view.h"




namespace std {

template <>
struct hash<::spellcheck::mojom::Decoration>
    : public mojo::internal::EnumHashImpl<::spellcheck::mojom::Decoration> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::Decoration, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::spellcheck::mojom::Decoration, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::spellcheck::mojom::Decoration>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::SpellCheckBDictLanguageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckBDictLanguageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::file(input)) in_file = Traits::file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file)::BaseType> file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_file,
      file_fragment);

    fragment->file.Set(
        file_fragment.is_null() ? nullptr : file_fragment.data());

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in SpellCheckBDictLanguage struct");
  }

  static bool Deserialize(::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::spellcheck::mojom::SpellCheckBDictLanguageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::SpellCheckResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::spellcheck::mojom::Decoration>(
      Traits::decoration(input),
      &fragment->decoration);

    fragment->location = Traits::location(input);

    fragment->length = Traits::length(input);

    decltype(Traits::replacements(input)) in_replacements = Traits::replacements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacements)::BaseType>
        replacements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& replacements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_replacements,
      replacements_fragment,
      &replacements_validate_params);

    fragment->replacements.Set(
        replacements_fragment.is_null() ? nullptr : replacements_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->replacements.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replacements in SpellCheckResult struct");

    fragment->should_hide_suggestion_menu = Traits::should_hide_suggestion_menu(input);
  }

  static bool Deserialize(::spellcheck::mojom::internal::SpellCheckResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::spellcheck::mojom::SpellCheckResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace spellcheck::mojom {

inline void SpellCheckBDictLanguageDataView::GetFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void SpellCheckBDictLanguageDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SpellCheckResultDataView::GetReplacementsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->replacements.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}



}  // spellcheck::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::spellcheck::mojom::Decoration> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::spellcheck::mojom::Decoration value);
};

} // namespace perfetto

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_