// components/services/storage/public/mojom/local_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/local_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/local_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/local_storage_control.mojom-import-headers.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-test-utils.h"


namespace storage::mojom {
// The declaration includes the definition on other builds.

LocalStorageControl::IPCStableHashFunction LocalStorageControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalStorageControl>(message.name())) {
    case messages::LocalStorageControl::kBindStorageArea: {
      return &LocalStorageControl::BindStorageArea_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kGetUsage: {
      return &LocalStorageControl::GetUsage_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kDeleteStorage: {
      return &LocalStorageControl::DeleteStorage_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kCleanUpStorage: {
      return &LocalStorageControl::CleanUpStorage_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kFlush: {
      return &LocalStorageControl::Flush_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kPurgeMemory: {
      return &LocalStorageControl::PurgeMemory_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kApplyPolicyUpdates: {
      return &LocalStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash;
    }
    case messages::LocalStorageControl::kForceKeepSessionState: {
      return &LocalStorageControl::ForceKeepSessionState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalStorageControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalStorageControl>(message.name())) {
      case messages::LocalStorageControl::kBindStorageArea:
            return "Receive storage::mojom::LocalStorageControl::BindStorageArea";
      case messages::LocalStorageControl::kGetUsage:
            return "Receive storage::mojom::LocalStorageControl::GetUsage";
      case messages::LocalStorageControl::kDeleteStorage:
            return "Receive storage::mojom::LocalStorageControl::DeleteStorage";
      case messages::LocalStorageControl::kCleanUpStorage:
            return "Receive storage::mojom::LocalStorageControl::CleanUpStorage";
      case messages::LocalStorageControl::kFlush:
            return "Receive storage::mojom::LocalStorageControl::Flush";
      case messages::LocalStorageControl::kPurgeMemory:
            return "Receive storage::mojom::LocalStorageControl::PurgeMemory";
      case messages::LocalStorageControl::kApplyPolicyUpdates:
            return "Receive storage::mojom::LocalStorageControl::ApplyPolicyUpdates";
      case messages::LocalStorageControl::kForceKeepSessionState:
            return "Receive storage::mojom::LocalStorageControl::ForceKeepSessionState";
    }
  } else {
    switch (static_cast<messages::LocalStorageControl>(message.name())) {
      case messages::LocalStorageControl::kBindStorageArea:
            return "Receive reply storage::mojom::LocalStorageControl::BindStorageArea";
      case messages::LocalStorageControl::kGetUsage:
            return "Receive reply storage::mojom::LocalStorageControl::GetUsage";
      case messages::LocalStorageControl::kDeleteStorage:
            return "Receive reply storage::mojom::LocalStorageControl::DeleteStorage";
      case messages::LocalStorageControl::kCleanUpStorage:
            return "Receive reply storage::mojom::LocalStorageControl::CleanUpStorage";
      case messages::LocalStorageControl::kFlush:
            return "Receive reply storage::mojom::LocalStorageControl::Flush";
      case messages::LocalStorageControl::kPurgeMemory:
            return "Receive reply storage::mojom::LocalStorageControl::PurgeMemory";
      case messages::LocalStorageControl::kApplyPolicyUpdates:
            return "Receive reply storage::mojom::LocalStorageControl::ApplyPolicyUpdates";
      case messages::LocalStorageControl::kForceKeepSessionState:
            return "Receive reply storage::mojom::LocalStorageControl::ForceKeepSessionState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalStorageControl::BindStorageArea_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc06ab80;  // IPCStableHash for storage::mojom::LocalStorageControl::BindStorageArea
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::GetUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbcd7a3d2;  // IPCStableHash for storage::mojom::LocalStorageControl::GetUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::DeleteStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2a86690;  // IPCStableHash for storage::mojom::LocalStorageControl::DeleteStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::CleanUpStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56394bfd;  // IPCStableHash for storage::mojom::LocalStorageControl::CleanUpStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e87eff9;  // IPCStableHash for storage::mojom::LocalStorageControl::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::PurgeMemory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf258d4b0;  // IPCStableHash for storage::mojom::LocalStorageControl::PurgeMemory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc86a5821;  // IPCStableHash for storage::mojom::LocalStorageControl::ApplyPolicyUpdates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalStorageControl::ForceKeepSessionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x893c42a4;  // IPCStableHash for storage::mojom::LocalStorageControl::ForceKeepSessionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LocalStorageControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_GetUsage_ForwardToCallback(
      LocalStorageControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalStorageControl_GetUsage_ForwardToCallback(const LocalStorageControl_GetUsage_ForwardToCallback&) = delete;
  LocalStorageControl_GetUsage_ForwardToCallback& operator=(const LocalStorageControl_GetUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::GetUsageCallback callback_;
};

class LocalStorageControl_DeleteStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_DeleteStorage_ForwardToCallback(
      LocalStorageControl::DeleteStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalStorageControl_DeleteStorage_ForwardToCallback(const LocalStorageControl_DeleteStorage_ForwardToCallback&) = delete;
  LocalStorageControl_DeleteStorage_ForwardToCallback& operator=(const LocalStorageControl_DeleteStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::DeleteStorageCallback callback_;
};

class LocalStorageControl_CleanUpStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_CleanUpStorage_ForwardToCallback(
      LocalStorageControl::CleanUpStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalStorageControl_CleanUpStorage_ForwardToCallback(const LocalStorageControl_CleanUpStorage_ForwardToCallback&) = delete;
  LocalStorageControl_CleanUpStorage_ForwardToCallback& operator=(const LocalStorageControl_CleanUpStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::CleanUpStorageCallback callback_;
};

LocalStorageControlProxy::LocalStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalStorageControlProxy::BindStorageArea(
    const ::blink::StorageKey& in_storage_key, ::mojo::PendingReceiver<::blink::mojom::StorageArea> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::LocalStorageControl::BindStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::StorageArea>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kBindStorageArea), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_BindStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in LocalStorageControl.BindStorageArea request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in LocalStorageControl.BindStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalStorageControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::LocalStorageControl::GetUsage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kGetUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_GetUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalStorageControlProxy::DeleteStorage(
    const ::blink::StorageKey& in_storage_key, DeleteStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::LocalStorageControl::DeleteStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kDeleteStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_DeleteStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in LocalStorageControl.DeleteStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_DeleteStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalStorageControlProxy::CleanUpStorage(
    CleanUpStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::LocalStorageControl::CleanUpStorage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kCleanUpStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_CleanUpStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_CleanUpStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalStorageControlProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::LocalStorageControl::Flush");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("Flush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalStorageControlProxy::PurgeMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::LocalStorageControl::PurgeMemory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kPurgeMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_PurgeMemory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("PurgeMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::LocalStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kApplyPolicyUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& policy_updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
    in_policy_updates,
    policy_updates_fragment,
    &policy_updates_validate_params);

  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_updates in LocalStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalStorageControlProxy::ForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::LocalStorageControl::ForceKeepSessionState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kForceKeepSessionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_ForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("ForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class LocalStorageControl_GetUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalStorageControl::GetUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalStorageControl_GetUsage_ProxyToResponder> proxy(
        new LocalStorageControl_GetUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalStorageControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalStorageControl_GetUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalStorageControl::GetUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::storage::mojom::StorageUsageInfoPtr> in_info);
};

bool LocalStorageControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalStorageControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalStorageControl.1
  bool success = true;
  std::vector<::storage::mojom::StorageUsageInfoPtr> p_info{};
  LocalStorageControl_GetUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void LocalStorageControl_GetUsage_ProxyToResponder::Run(
    std::vector<::storage::mojom::StorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::LocalStorageControl::GetUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type std::vector<::storage::mojom::StorageUsageInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kGetUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_GetUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StorageUsageInfoDataView>>(
    in_info,
    info_fragment,
    &info_validate_params);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalStorageControl_DeleteStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalStorageControl::DeleteStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalStorageControl_DeleteStorage_ProxyToResponder> proxy(
        new LocalStorageControl_DeleteStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalStorageControl_DeleteStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_DeleteStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalStorageControl_DeleteStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalStorageControl::DeleteStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalStorageControl_DeleteStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalStorageControl_DeleteStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_DeleteStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalStorageControl.2
  bool success = true;
  LocalStorageControl_DeleteStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalStorageControl_DeleteStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::LocalStorageControl::DeleteStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kDeleteStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_DeleteStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalStorageControl_CleanUpStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalStorageControl::CleanUpStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalStorageControl_CleanUpStorage_ProxyToResponder> proxy(
        new LocalStorageControl_CleanUpStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalStorageControl_CleanUpStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_CleanUpStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalStorageControl_CleanUpStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalStorageControl::CleanUpStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LocalStorageControl_CleanUpStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalStorageControl.3
  bool success = true;
  LocalStorageControl_CleanUpStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LocalStorageControl_CleanUpStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::LocalStorageControl::CleanUpStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalStorageControl::kCleanUpStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalStorageControlStubDispatch::Accept(
    LocalStorageControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalStorageControl>(message->header()->name)) {
    case messages::LocalStorageControl::kBindStorageArea: {
      DCHECK(message->is_serialized());
      internal::LocalStorageControl_BindStorageArea_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_BindStorageArea_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalStorageControl.0
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ::mojo::PendingReceiver<::blink::mojom::StorageArea> p_receiver{};
      LocalStorageControl_BindStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStorageArea(        
        std::move(p_storage_key), 
        std::move(p_receiver));
      return true;
    }
    case messages::LocalStorageControl::kGetUsage: {
      break;
    }
    case messages::LocalStorageControl::kDeleteStorage: {
      break;
    }
    case messages::LocalStorageControl::kCleanUpStorage: {
      break;
    }
    case messages::LocalStorageControl::kFlush: {
      DCHECK(message->is_serialized());
      internal::LocalStorageControl_Flush_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_Flush_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalStorageControl.4
      bool success = true;
      LocalStorageControl_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(        );
      return true;
    }
    case messages::LocalStorageControl::kPurgeMemory: {
      DCHECK(message->is_serialized());
      internal::LocalStorageControl_PurgeMemory_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_PurgeMemory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalStorageControl.5
      bool success = true;
      LocalStorageControl_PurgeMemory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgeMemory(        );
      return true;
    }
    case messages::LocalStorageControl::kApplyPolicyUpdates: {
      DCHECK(message->is_serialized());
      internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalStorageControl.6
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      LocalStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(        
        std::move(p_policy_updates));
      return true;
    }
    case messages::LocalStorageControl::kForceKeepSessionState: {
      DCHECK(message->is_serialized());
      internal::LocalStorageControl_ForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_ForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalStorageControl.7
      bool success = true;
      LocalStorageControl_ForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceKeepSessionState(        );
      return true;
    }
  }
  return false;
}

// static
bool LocalStorageControlStubDispatch::AcceptWithResponder(
    LocalStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalStorageControl>(message->header()->name)) {
    case messages::LocalStorageControl::kBindStorageArea: {
      break;
    }
    case messages::LocalStorageControl::kGetUsage: {
      internal::LocalStorageControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalStorageControl.1
      bool success = true;
      LocalStorageControl_GetUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 1, false);
        return false;
      }
      auto callback =
          LocalStorageControl_GetUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case messages::LocalStorageControl::kDeleteStorage: {
      internal::LocalStorageControl_DeleteStorage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_DeleteStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalStorageControl.2
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      LocalStorageControl_DeleteStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 2, false);
        return false;
      }
      auto callback =
          LocalStorageControl_DeleteStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStorage(        
        std::move(p_storage_key), std::move(callback));
      return true;
    }
    case messages::LocalStorageControl::kCleanUpStorage: {
      internal::LocalStorageControl_CleanUpStorage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_CleanUpStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalStorageControl.3
      bool success = true;
      LocalStorageControl_CleanUpStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 3, false);
        return false;
      }
      auto callback =
          LocalStorageControl_CleanUpStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CleanUpStorage(std::move(callback));
      return true;
    }
    case messages::LocalStorageControl::kFlush: {
      break;
    }
    case messages::LocalStorageControl::kPurgeMemory: {
      break;
    }
    case messages::LocalStorageControl::kApplyPolicyUpdates: {
      break;
    }
    case messages::LocalStorageControl::kForceKeepSessionState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalStorageControlValidationInfo[] = {
    { &internal::LocalStorageControl_BindStorageArea_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalStorageControl_GetUsage_Params_Data::Validate,
     &internal::LocalStorageControl_GetUsage_ResponseParams_Data::Validate},
    { &internal::LocalStorageControl_DeleteStorage_Params_Data::Validate,
     &internal::LocalStorageControl_DeleteStorage_ResponseParams_Data::Validate},
    { &internal::LocalStorageControl_CleanUpStorage_Params_Data::Validate,
     &internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data::Validate},
    { &internal::LocalStorageControl_Flush_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalStorageControl_PurgeMemory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalStorageControl_ForceKeepSessionState_Params_Data::Validate,
     nullptr /* no response */},
};

bool LocalStorageControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::LocalStorageControl::Name_,
    kLocalStorageControlValidationInfo);
}

bool LocalStorageControlResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::LocalStorageControl::Name_,
    kLocalStorageControlValidationInfo);
}


}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void LocalStorageControlInterceptorForTesting::BindStorageArea(const ::blink::StorageKey& storage_key, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) {
  GetForwardingInterface()->BindStorageArea(
    std::move(storage_key)
    , 
    std::move(receiver)
    );
}
void LocalStorageControlInterceptorForTesting::GetUsage(GetUsageCallback callback) {
  GetForwardingInterface()->GetUsage(std::move(callback));
}
void LocalStorageControlInterceptorForTesting::DeleteStorage(const ::blink::StorageKey& storage_key, DeleteStorageCallback callback) {
  GetForwardingInterface()->DeleteStorage(
    std::move(storage_key)
    , std::move(callback));
}
void LocalStorageControlInterceptorForTesting::CleanUpStorage(CleanUpStorageCallback callback) {
  GetForwardingInterface()->CleanUpStorage(std::move(callback));
}
void LocalStorageControlInterceptorForTesting::Flush() {
  GetForwardingInterface()->Flush();
}
void LocalStorageControlInterceptorForTesting::PurgeMemory() {
  GetForwardingInterface()->PurgeMemory();
}
void LocalStorageControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  GetForwardingInterface()->ApplyPolicyUpdates(
    std::move(policy_updates)
    );
}
void LocalStorageControlInterceptorForTesting::ForceKeepSessionState() {
  GetForwardingInterface()->ForceKeepSessionState();
}
LocalStorageControlAsyncWaiter::LocalStorageControlAsyncWaiter(
    LocalStorageControl* proxy) : proxy_(proxy) {}

LocalStorageControlAsyncWaiter::~LocalStorageControlAsyncWaiter() = default;


void LocalStorageControlAsyncWaiter::GetUsage(
    std::vector<::storage::mojom::StorageUsageInfoPtr>* out_info) {
  base::RunLoop loop;
  proxy_->GetUsage(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::storage::mojom::StorageUsageInfoPtr>* out_info
,
             std::vector<::storage::mojom::StorageUsageInfoPtr> info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

std::vector<::storage::mojom::StorageUsageInfoPtr> LocalStorageControlAsyncWaiter::GetUsage(
    ) {
  std::vector<::storage::mojom::StorageUsageInfoPtr> async_wait_result;
  GetUsage(&async_wait_result);
  return async_wait_result;
}

void LocalStorageControlAsyncWaiter::DeleteStorage(
    const ::blink::StorageKey& storage_key) {
  base::RunLoop loop;
  proxy_->DeleteStorage(
      std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void LocalStorageControlAsyncWaiter::CleanUpStorage(
    ) {
  base::RunLoop loop;
  proxy_->CleanUpStorage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif