// components/services/storage/public/mojom/blob_storage_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/blob_storage_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-params-data.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-import-headers.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-test-utils.h"


namespace storage::mojom {
BlobDataItem::BlobDataItem()
    : type(),
      size(),
      side_data_size(),
      content_type(),
      reader() {}

BlobDataItem::BlobDataItem(
    BlobDataItemType type_in,
    uint64_t size_in,
    uint64_t side_data_size_in,
    const std::string& content_type_in,
    ::mojo::PendingRemote<BlobDataItemReader> reader_in)
    : type(std::move(type_in)),
      size(std::move(size_in)),
      side_data_size(std::move(side_data_size_in)),
      content_type(std::move(content_type_in)),
      reader(std::move(reader_in)) {}

BlobDataItem::~BlobDataItem() = default;

void BlobDataItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BlobDataItemType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_data_size"), this->side_data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_type"), this->content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reader"), this->reader,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<BlobDataItemReader>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BlobDataItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BlobDataItemReader::IPCStableHashFunction BlobDataItemReader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobDataItemReader>(message.name())) {
    case messages::BlobDataItemReader::kRead: {
      return &BlobDataItemReader::Read_Sym::IPCStableHash;
    }
    case messages::BlobDataItemReader::kReadSideData: {
      return &BlobDataItemReader::ReadSideData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobDataItemReader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobDataItemReader>(message.name())) {
      case messages::BlobDataItemReader::kRead:
            return "Receive storage::mojom::BlobDataItemReader::Read";
      case messages::BlobDataItemReader::kReadSideData:
            return "Receive storage::mojom::BlobDataItemReader::ReadSideData";
    }
  } else {
    switch (static_cast<messages::BlobDataItemReader>(message.name())) {
      case messages::BlobDataItemReader::kRead:
            return "Receive reply storage::mojom::BlobDataItemReader::Read";
      case messages::BlobDataItemReader::kReadSideData:
            return "Receive reply storage::mojom::BlobDataItemReader::ReadSideData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobDataItemReader::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07e616d2;  // IPCStableHash for storage::mojom::BlobDataItemReader::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobDataItemReader::ReadSideData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b610b7f;  // IPCStableHash for storage::mojom::BlobDataItemReader::ReadSideData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BlobDataItemReader_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobDataItemReader_Read_ForwardToCallback(
      BlobDataItemReader::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobDataItemReader_Read_ForwardToCallback(const BlobDataItemReader_Read_ForwardToCallback&) = delete;
  BlobDataItemReader_Read_ForwardToCallback& operator=(const BlobDataItemReader_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobDataItemReader::ReadCallback callback_;
};

class BlobDataItemReader_ReadSideData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobDataItemReader_ReadSideData_ForwardToCallback(
      BlobDataItemReader::ReadSideDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobDataItemReader_ReadSideData_ForwardToCallback(const BlobDataItemReader_ReadSideData_ForwardToCallback&) = delete;
  BlobDataItemReader_ReadSideData_ForwardToCallback& operator=(const BlobDataItemReader_ReadSideData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobDataItemReader::ReadSideDataCallback callback_;
};

BlobDataItemReaderProxy::BlobDataItemReaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobDataItemReaderProxy::Read(
    uint64_t in_offset, uint64_t in_length, ::mojo::ScopedDataPipeProducerHandle in_pipe, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::BlobDataItemReader::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobDataItemReader::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobDataItemReader_Read_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->length = in_length;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in BlobDataItemReader.Read request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobDataItemReader_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobDataItemReaderProxy::ReadSideData(
    ReadSideDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::BlobDataItemReader::ReadSideData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobDataItemReader::kReadSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobDataItemReader_ReadSideData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("ReadSideData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobDataItemReader_ReadSideData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BlobDataItemReader_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobDataItemReader::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobDataItemReader_Read_ProxyToResponder> proxy(
        new BlobDataItemReader_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobDataItemReader_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobDataItemReader_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobDataItemReader_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BlobDataItemReader::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_success);
};

bool BlobDataItemReader_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobDataItemReader_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobDataItemReader_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BlobDataItemReader.0
  bool success = true;
  int32_t p_success{};
  BlobDataItemReader_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobDataItemReader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void BlobDataItemReader_Read_ProxyToResponder::Run(
    int32_t in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::BlobDataItemReader::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobDataItemReader::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobDataItemReader_Read_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BlobDataItemReader_ReadSideData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobDataItemReader::ReadSideDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobDataItemReader_ReadSideData_ProxyToResponder> proxy(
        new BlobDataItemReader_ReadSideData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobDataItemReader_ReadSideData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobDataItemReader_ReadSideData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobDataItemReader_ReadSideData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BlobDataItemReader::ReadSideDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_success, ::mojo_base::BigBuffer in_data);
};

bool BlobDataItemReader_ReadSideData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobDataItemReader_ReadSideData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BlobDataItemReader.1
  bool success = true;
  int32_t p_success{};
  ::mojo_base::BigBuffer p_data{};
  BlobDataItemReader_ReadSideData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobDataItemReader::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_data));
  }
  return true;
}

void BlobDataItemReader_ReadSideData_ProxyToResponder::Run(
    int32_t in_success, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::BlobDataItemReader::ReadSideData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobDataItemReader::kReadSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobDataItemReader_ReadSideData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("ReadSideData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobDataItemReaderStubDispatch::Accept(
    BlobDataItemReader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobDataItemReader>(message->header()->name)) {
    case messages::BlobDataItemReader::kRead: {
      break;
    }
    case messages::BlobDataItemReader::kReadSideData: {
      break;
    }
  }
  return false;
}

// static
bool BlobDataItemReaderStubDispatch::AcceptWithResponder(
    BlobDataItemReader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobDataItemReader>(message->header()->name)) {
    case messages::BlobDataItemReader::kRead: {
      internal::BlobDataItemReader_Read_Params_Data* params =
          reinterpret_cast<
              internal::BlobDataItemReader_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BlobDataItemReader.0
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      BlobDataItemReader_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobDataItemReader::Name_, 0, false);
        return false;
      }
      auto callback =
          BlobDataItemReader_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(        
        std::move(p_offset), 
        std::move(p_length), 
        std::move(p_pipe), std::move(callback));
      return true;
    }
    case messages::BlobDataItemReader::kReadSideData: {
      internal::BlobDataItemReader_ReadSideData_Params_Data* params =
          reinterpret_cast<
              internal::BlobDataItemReader_ReadSideData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BlobDataItemReader.1
      bool success = true;
      BlobDataItemReader_ReadSideData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobDataItemReader::Name_, 1, false);
        return false;
      }
      auto callback =
          BlobDataItemReader_ReadSideData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSideData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobDataItemReaderValidationInfo[] = {
    { &internal::BlobDataItemReader_Read_Params_Data::Validate,
     &internal::BlobDataItemReader_Read_ResponseParams_Data::Validate},
    { &internal::BlobDataItemReader_ReadSideData_Params_Data::Validate,
     &internal::BlobDataItemReader_ReadSideData_ResponseParams_Data::Validate},
};

bool BlobDataItemReaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::BlobDataItemReader::Name_,
    kBlobDataItemReaderValidationInfo);
}

bool BlobDataItemReaderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::BlobDataItemReader::Name_,
    kBlobDataItemReaderValidationInfo);
}
// The declaration includes the definition on other builds.

BlobStorageContext::IPCStableHashFunction BlobStorageContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobStorageContext>(message.name())) {
    case messages::BlobStorageContext::kRegisterFromDataItem: {
      return &BlobStorageContext::RegisterFromDataItem_Sym::IPCStableHash;
    }
    case messages::BlobStorageContext::kRegisterFromMemory: {
      return &BlobStorageContext::RegisterFromMemory_Sym::IPCStableHash;
    }
    case messages::BlobStorageContext::kWriteBlobToFile: {
      return &BlobStorageContext::WriteBlobToFile_Sym::IPCStableHash;
    }
    case messages::BlobStorageContext::kClone: {
      return &BlobStorageContext::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobStorageContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobStorageContext>(message.name())) {
      case messages::BlobStorageContext::kRegisterFromDataItem:
            return "Receive storage::mojom::BlobStorageContext::RegisterFromDataItem";
      case messages::BlobStorageContext::kRegisterFromMemory:
            return "Receive storage::mojom::BlobStorageContext::RegisterFromMemory";
      case messages::BlobStorageContext::kWriteBlobToFile:
            return "Receive storage::mojom::BlobStorageContext::WriteBlobToFile";
      case messages::BlobStorageContext::kClone:
            return "Receive storage::mojom::BlobStorageContext::Clone";
    }
  } else {
    switch (static_cast<messages::BlobStorageContext>(message.name())) {
      case messages::BlobStorageContext::kRegisterFromDataItem:
            return "Receive reply storage::mojom::BlobStorageContext::RegisterFromDataItem";
      case messages::BlobStorageContext::kRegisterFromMemory:
            return "Receive reply storage::mojom::BlobStorageContext::RegisterFromMemory";
      case messages::BlobStorageContext::kWriteBlobToFile:
            return "Receive reply storage::mojom::BlobStorageContext::WriteBlobToFile";
      case messages::BlobStorageContext::kClone:
            return "Receive reply storage::mojom::BlobStorageContext::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobStorageContext::RegisterFromDataItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd575dde7;  // IPCStableHash for storage::mojom::BlobStorageContext::RegisterFromDataItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobStorageContext::RegisterFromMemory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49bb676d;  // IPCStableHash for storage::mojom::BlobStorageContext::RegisterFromMemory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobStorageContext::WriteBlobToFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabaf91dc;  // IPCStableHash for storage::mojom::BlobStorageContext::WriteBlobToFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobStorageContext::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d15a08e;  // IPCStableHash for storage::mojom::BlobStorageContext::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BlobStorageContext_WriteBlobToFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobStorageContext_WriteBlobToFile_ForwardToCallback(
      BlobStorageContext::WriteBlobToFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobStorageContext_WriteBlobToFile_ForwardToCallback(const BlobStorageContext_WriteBlobToFile_ForwardToCallback&) = delete;
  BlobStorageContext_WriteBlobToFile_ForwardToCallback& operator=(const BlobStorageContext_WriteBlobToFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobStorageContext::WriteBlobToFileCallback callback_;
};

BlobStorageContextProxy::BlobStorageContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobStorageContextProxy::RegisterFromDataItem(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, BlobDataItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::BlobStorageContext::RegisterFromDataItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type BlobDataItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobStorageContext::kRegisterFromDataItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobStorageContext_RegisterFromDataItem_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in BlobStorageContext.RegisterFromDataItem request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BlobStorageContext.RegisterFromDataItem request");
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BlobDataItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in BlobStorageContext.RegisterFromDataItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("RegisterFromDataItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobStorageContextProxy::RegisterFromMemory(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::BlobStorageContext::RegisterFromMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobStorageContext::kRegisterFromMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobStorageContext_RegisterFromMemory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in BlobStorageContext.RegisterFromMemory request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in BlobStorageContext.RegisterFromMemory request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in BlobStorageContext.RegisterFromMemory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("RegisterFromMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobStorageContextProxy::WriteBlobToFile(
    ::mojo::PendingRemote<::blink::mojom::Blob> in_blob, const ::base::FilePath& in_path, bool in_flush_on_write, std::optional<::base::Time> in_last_modified, WriteBlobToFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::BlobStorageContext::WriteBlobToFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flush_on_write"), in_flush_on_write,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_modified"), in_last_modified,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobStorageContext::kWriteBlobToFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobStorageContext_WriteBlobToFile_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in BlobStorageContext.WriteBlobToFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in BlobStorageContext.WriteBlobToFile request");

  params->flush_on_write = in_flush_on_write;
  mojo::internal::MessageFragment<
      typename decltype(params->last_modified)::BaseType> last_modified_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_last_modified,
    last_modified_fragment);

  params->last_modified.Set(
      last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("WriteBlobToFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobStorageContext_WriteBlobToFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobStorageContextProxy::Clone(
    ::mojo::PendingReceiver<BlobStorageContext> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::BlobStorageContext::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<BlobStorageContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobStorageContext::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobStorageContext_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::BlobStorageContextInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in BlobStorageContext.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class BlobStorageContext_WriteBlobToFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobStorageContext::WriteBlobToFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobStorageContext_WriteBlobToFile_ProxyToResponder> proxy(
        new BlobStorageContext_WriteBlobToFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobStorageContext_WriteBlobToFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobStorageContext_WriteBlobToFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobStorageContext_WriteBlobToFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BlobStorageContext::WriteBlobToFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WriteBlobToFileResult in_result);
};

bool BlobStorageContext_WriteBlobToFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BlobStorageContext.2
  bool success = true;
  WriteBlobToFileResult p_result{};
  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobStorageContext::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void BlobStorageContext_WriteBlobToFile_ProxyToResponder::Run(
    WriteBlobToFileResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::BlobStorageContext::WriteBlobToFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WriteBlobToFileResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobStorageContext::kWriteBlobToFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::WriteBlobToFileResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("WriteBlobToFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobStorageContextStubDispatch::Accept(
    BlobStorageContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobStorageContext>(message->header()->name)) {
    case messages::BlobStorageContext::kRegisterFromDataItem: {
      DCHECK(message->is_serialized());
      internal::BlobStorageContext_RegisterFromDataItem_Params_Data* params =
          reinterpret_cast<internal::BlobStorageContext_RegisterFromDataItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BlobStorageContext.0
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      BlobDataItemPtr p_item{};
      BlobStorageContext_RegisterFromDataItem_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromDataItem(        
        std::move(p_blob), 
        std::move(p_uuid), 
        std::move(p_item));
      return true;
    }
    case messages::BlobStorageContext::kRegisterFromMemory: {
      DCHECK(message->is_serialized());
      internal::BlobStorageContext_RegisterFromMemory_Params_Data* params =
          reinterpret_cast<internal::BlobStorageContext_RegisterFromMemory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BlobStorageContext.1
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      ::mojo_base::BigBuffer p_data{};
      BlobStorageContext_RegisterFromMemory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromMemory(        
        std::move(p_blob), 
        std::move(p_uuid), 
        std::move(p_data));
      return true;
    }
    case messages::BlobStorageContext::kWriteBlobToFile: {
      break;
    }
    case messages::BlobStorageContext::kClone: {
      DCHECK(message->is_serialized());
      internal::BlobStorageContext_Clone_Params_Data* params =
          reinterpret_cast<internal::BlobStorageContext_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BlobStorageContext.3
      bool success = true;
      ::mojo::PendingReceiver<BlobStorageContext> p_receiver{};
      BlobStorageContext_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool BlobStorageContextStubDispatch::AcceptWithResponder(
    BlobStorageContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobStorageContext>(message->header()->name)) {
    case messages::BlobStorageContext::kRegisterFromDataItem: {
      break;
    }
    case messages::BlobStorageContext::kRegisterFromMemory: {
      break;
    }
    case messages::BlobStorageContext::kWriteBlobToFile: {
      internal::BlobStorageContext_WriteBlobToFile_Params_Data* params =
          reinterpret_cast<
              internal::BlobStorageContext_WriteBlobToFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BlobStorageContext.2
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::Blob> p_blob{};
      ::base::FilePath p_path{};
      bool p_flush_on_write{};
      std::optional<::base::Time> p_last_modified{};
      BlobStorageContext_WriteBlobToFile_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_flush_on_write = input_data_view.flush_on_write();
      if (success && !input_data_view.ReadLastModified(&p_last_modified))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 2, false);
        return false;
      }
      auto callback =
          BlobStorageContext_WriteBlobToFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteBlobToFile(        
        std::move(p_blob), 
        std::move(p_path), 
        std::move(p_flush_on_write), 
        std::move(p_last_modified), std::move(callback));
      return true;
    }
    case messages::BlobStorageContext::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobStorageContextValidationInfo[] = {
    { &internal::BlobStorageContext_RegisterFromDataItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BlobStorageContext_RegisterFromMemory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BlobStorageContext_WriteBlobToFile_Params_Data::Validate,
     &internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data::Validate},
    { &internal::BlobStorageContext_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool BlobStorageContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::BlobStorageContext::Name_,
    kBlobStorageContextValidationInfo);
}

bool BlobStorageContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::BlobStorageContext::Name_,
    kBlobStorageContextValidationInfo);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::BlobDataItem::DataView, ::storage::mojom::BlobDataItemPtr>::Read(
    ::storage::mojom::BlobDataItem::DataView input,
    ::storage::mojom::BlobDataItemPtr* output) {
  bool success = true;
  ::storage::mojom::BlobDataItemPtr result(::storage::mojom::BlobDataItem::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->side_data_size = input.side_data_size();
      if (success && !input.ReadContentType(&result->content_type))
        success = false;
      if (success) {
        result->reader =
            input.TakeReader<decltype(result->reader)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void BlobDataItemReaderInterceptorForTesting::Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) {
  GetForwardingInterface()->Read(
    std::move(offset)
    , 
    std::move(length)
    , 
    std::move(pipe)
    , std::move(callback));
}
void BlobDataItemReaderInterceptorForTesting::ReadSideData(ReadSideDataCallback callback) {
  GetForwardingInterface()->ReadSideData(std::move(callback));
}
BlobDataItemReaderAsyncWaiter::BlobDataItemReaderAsyncWaiter(
    BlobDataItemReader* proxy) : proxy_(proxy) {}

BlobDataItemReaderAsyncWaiter::~BlobDataItemReaderAsyncWaiter() = default;


void BlobDataItemReaderAsyncWaiter::Read(
    uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, int32_t* out_success) {
  base::RunLoop loop;
  proxy_->Read(
      std::move(offset),
      std::move(length),
      std::move(pipe),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_success
,
             int32_t success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

int32_t BlobDataItemReaderAsyncWaiter::Read(
    uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe) {
  int32_t async_wait_result;
  Read(std::move(offset),std::move(length),std::move(pipe),&async_wait_result);
  return async_wait_result;
}

void BlobDataItemReaderAsyncWaiter::ReadSideData(
    int32_t* out_success, ::mojo_base::BigBuffer* out_data) {
  base::RunLoop loop;
  proxy_->ReadSideData(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_success
,
             ::mojo_base::BigBuffer* out_data
,
             int32_t success,
             ::mojo_base::BigBuffer data) {*out_success = std::move(success);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_data));
  loop.Run();
}






void BlobStorageContextInterceptorForTesting::RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) {
  GetForwardingInterface()->RegisterFromDataItem(
    std::move(blob)
    , 
    std::move(uuid)
    , 
    std::move(item)
    );
}
void BlobStorageContextInterceptorForTesting::RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) {
  GetForwardingInterface()->RegisterFromMemory(
    std::move(blob)
    , 
    std::move(uuid)
    , 
    std::move(data)
    );
}
void BlobStorageContextInterceptorForTesting::WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, std::optional<::base::Time> last_modified, WriteBlobToFileCallback callback) {
  GetForwardingInterface()->WriteBlobToFile(
    std::move(blob)
    , 
    std::move(path)
    , 
    std::move(flush_on_write)
    , 
    std::move(last_modified)
    , std::move(callback));
}
void BlobStorageContextInterceptorForTesting::Clone(::mojo::PendingReceiver<BlobStorageContext> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
BlobStorageContextAsyncWaiter::BlobStorageContextAsyncWaiter(
    BlobStorageContext* proxy) : proxy_(proxy) {}

BlobStorageContextAsyncWaiter::~BlobStorageContextAsyncWaiter() = default;


void BlobStorageContextAsyncWaiter::WriteBlobToFile(
    ::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, std::optional<::base::Time> last_modified, WriteBlobToFileResult* out_result) {
  base::RunLoop loop;
  proxy_->WriteBlobToFile(
      std::move(blob),
      std::move(path),
      std::move(flush_on_write),
      std::move(last_modified),
      base::BindOnce(
          [](base::RunLoop* loop,
             WriteBlobToFileResult* out_result
,
             WriteBlobToFileResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WriteBlobToFileResult BlobStorageContextAsyncWaiter::WriteBlobToFile(
    ::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, std::optional<::base::Time> last_modified) {
  WriteBlobToFileResult async_wait_result;
  WriteBlobToFile(std::move(blob),std::move(path),std::move(flush_on_write),std::move(last_modified),&async_wait_result);
  return async_wait_result;
}






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif