// components/services/storage/public/mojom/blob_storage_context.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SEND_VALIDATION_H_

#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::BlobDataItemType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::WriteBlobToFileResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::BlobDataItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BlobDataItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BlobDataItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::storage::mojom::BlobDataItemType>(
        Traits::type(input),
        &fragment->type);

      fragment->size = Traits::size(input);

      fragment->side_data_size = Traits::side_data_size(input);

      decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_type)::BaseType> content_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_type,
        content_type_fragment);

      fragment->content_type.Set(
          content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in BlobDataItem struct");

      decltype(Traits::reader(input)) in_reader = Traits::reader(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
        in_reader,
        &fragment->reader,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->reader)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid reader in BlobDataItem struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SEND_VALIDATION_H_