// components/services/patch/public/mojom/file_patcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/patch/public/mojom/file_patcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/patch/public/mojom/file_patcher.mojom-params-data.h"
#include "components/services/patch/public/mojom/file_patcher.mojom-shared-message-ids.h"

#include "components/services/patch/public/mojom/file_patcher.mojom-import-headers.h"
#include "components/services/patch/public/mojom/file_patcher.mojom-test-utils.h"


namespace patch::mojom {
// The declaration includes the definition on other builds.

FilePatcher::IPCStableHashFunction FilePatcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FilePatcher>(message.name())) {
    case messages::FilePatcher::kPatchFilePuffPatch: {
      return &FilePatcher::PatchFilePuffPatch_Sym::IPCStableHash;
    }
    case messages::FilePatcher::kPatchFileZucchini: {
      return &FilePatcher::PatchFileZucchini_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FilePatcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FilePatcher>(message.name())) {
      case messages::FilePatcher::kPatchFilePuffPatch:
            return "Receive patch::mojom::FilePatcher::PatchFilePuffPatch";
      case messages::FilePatcher::kPatchFileZucchini:
            return "Receive patch::mojom::FilePatcher::PatchFileZucchini";
    }
  } else {
    switch (static_cast<messages::FilePatcher>(message.name())) {
      case messages::FilePatcher::kPatchFilePuffPatch:
            return "Receive reply patch::mojom::FilePatcher::PatchFilePuffPatch";
      case messages::FilePatcher::kPatchFileZucchini:
            return "Receive reply patch::mojom::FilePatcher::PatchFileZucchini";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FilePatcher::PatchFilePuffPatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31791af8;  // IPCStableHash for patch::mojom::FilePatcher::PatchFilePuffPatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FilePatcher::PatchFileZucchini_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe430c44c;  // IPCStableHash for patch::mojom::FilePatcher::PatchFileZucchini
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FilePatcher_PatchFilePuffPatch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FilePatcher_PatchFilePuffPatch_ForwardToCallback(
      FilePatcher::PatchFilePuffPatchCallback callback
      ) : callback_(std::move(callback)) {
  }

  FilePatcher_PatchFilePuffPatch_ForwardToCallback(const FilePatcher_PatchFilePuffPatch_ForwardToCallback&) = delete;
  FilePatcher_PatchFilePuffPatch_ForwardToCallback& operator=(const FilePatcher_PatchFilePuffPatch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FilePatcher::PatchFilePuffPatchCallback callback_;
};

class FilePatcher_PatchFileZucchini_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FilePatcher_PatchFileZucchini_ForwardToCallback(
      FilePatcher::PatchFileZucchiniCallback callback
      ) : callback_(std::move(callback)) {
  }

  FilePatcher_PatchFileZucchini_ForwardToCallback(const FilePatcher_PatchFileZucchini_ForwardToCallback&) = delete;
  FilePatcher_PatchFileZucchini_ForwardToCallback& operator=(const FilePatcher_PatchFileZucchini_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FilePatcher::PatchFileZucchiniCallback callback_;
};

FilePatcherProxy::FilePatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FilePatcherProxy::PatchFilePuffPatch(
    ::base::File in_input_file, ::base::File in_patch_file, ::base::File in_output_file, PatchFilePuffPatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send patch::mojom::FilePatcher::PatchFilePuffPatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_file"), in_input_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("patch_file"), in_patch_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_file"), in_output_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FilePatcher::kPatchFilePuffPatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::patch::mojom::internal::FilePatcher_PatchFilePuffPatch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_file)::BaseType> input_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_input_file,
    input_file_fragment);

  params->input_file.Set(
      input_file_fragment.is_null() ? nullptr : input_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_file in FilePatcher.PatchFilePuffPatch request");
  mojo::internal::MessageFragment<
      typename decltype(params->patch_file)::BaseType> patch_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_patch_file,
    patch_file_fragment);

  params->patch_file.Set(
      patch_file_fragment.is_null() ? nullptr : patch_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->patch_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null patch_file in FilePatcher.PatchFilePuffPatch request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_file)::BaseType> output_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_output_file,
    output_file_fragment);

  params->output_file.Set(
      output_file_fragment.is_null() ? nullptr : output_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output_file in FilePatcher.PatchFilePuffPatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FilePatcher::Name_);
  message.set_method_name("PatchFilePuffPatch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FilePatcher_PatchFilePuffPatch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FilePatcherProxy::PatchFileZucchini(
    ::base::File in_input_file, ::base::File in_patch_file, ::base::File in_output_file, PatchFileZucchiniCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send patch::mojom::FilePatcher::PatchFileZucchini", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_file"), in_input_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("patch_file"), in_patch_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_file"), in_output_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FilePatcher::kPatchFileZucchini), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::patch::mojom::internal::FilePatcher_PatchFileZucchini_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_file)::BaseType> input_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_input_file,
    input_file_fragment);

  params->input_file.Set(
      input_file_fragment.is_null() ? nullptr : input_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_file in FilePatcher.PatchFileZucchini request");
  mojo::internal::MessageFragment<
      typename decltype(params->patch_file)::BaseType> patch_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_patch_file,
    patch_file_fragment);

  params->patch_file.Set(
      patch_file_fragment.is_null() ? nullptr : patch_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->patch_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null patch_file in FilePatcher.PatchFileZucchini request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_file)::BaseType> output_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_output_file,
    output_file_fragment);

  params->output_file.Set(
      output_file_fragment.is_null() ? nullptr : output_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output_file in FilePatcher.PatchFileZucchini request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FilePatcher::Name_);
  message.set_method_name("PatchFileZucchini");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FilePatcher_PatchFileZucchini_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FilePatcher_PatchFilePuffPatch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FilePatcher::PatchFilePuffPatchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FilePatcher_PatchFilePuffPatch_ProxyToResponder> proxy(
        new FilePatcher_PatchFilePuffPatch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FilePatcher_PatchFilePuffPatch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FilePatcher_PatchFilePuffPatch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FilePatcher_PatchFilePuffPatch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FilePatcher::PatchFilePuffPatchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool FilePatcher_PatchFilePuffPatch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FilePatcher_PatchFilePuffPatch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FilePatcher_PatchFilePuffPatch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FilePatcher.0
  bool success = true;
  int32_t p_result{};
  FilePatcher_PatchFilePuffPatch_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FilePatcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FilePatcher_PatchFilePuffPatch_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply patch::mojom::FilePatcher::PatchFilePuffPatch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FilePatcher::kPatchFilePuffPatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::patch::mojom::internal::FilePatcher_PatchFilePuffPatch_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FilePatcher::Name_);
  message.set_method_name("PatchFilePuffPatch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FilePatcher_PatchFileZucchini_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FilePatcher::PatchFileZucchiniCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FilePatcher_PatchFileZucchini_ProxyToResponder> proxy(
        new FilePatcher_PatchFileZucchini_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FilePatcher_PatchFileZucchini_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FilePatcher_PatchFileZucchini_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FilePatcher_PatchFileZucchini_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FilePatcher::PatchFileZucchiniCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      zucchini::status::Code in_result);
};

bool FilePatcher_PatchFileZucchini_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FilePatcher_PatchFileZucchini_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FilePatcher_PatchFileZucchini_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FilePatcher.1
  bool success = true;
  zucchini::status::Code p_result{};
  FilePatcher_PatchFileZucchini_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FilePatcher::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FilePatcher_PatchFileZucchini_ProxyToResponder::Run(
    zucchini::status::Code in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply patch::mojom::FilePatcher::PatchFileZucchini", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type zucchini::status::Code>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FilePatcher::kPatchFileZucchini), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::patch::mojom::internal::FilePatcher_PatchFileZucchini_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::patch::mojom::ZucchiniStatus>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FilePatcher::Name_);
  message.set_method_name("PatchFileZucchini");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FilePatcherStubDispatch::Accept(
    FilePatcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FilePatcher>(message->header()->name)) {
    case messages::FilePatcher::kPatchFilePuffPatch: {
      break;
    }
    case messages::FilePatcher::kPatchFileZucchini: {
      break;
    }
  }
  return false;
}

// static
bool FilePatcherStubDispatch::AcceptWithResponder(
    FilePatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FilePatcher>(message->header()->name)) {
    case messages::FilePatcher::kPatchFilePuffPatch: {
      internal::FilePatcher_PatchFilePuffPatch_Params_Data* params =
          reinterpret_cast<
              internal::FilePatcher_PatchFilePuffPatch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FilePatcher.0
      bool success = true;
      ::base::File p_input_file{};
      ::base::File p_patch_file{};
      ::base::File p_output_file{};
      FilePatcher_PatchFilePuffPatch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputFile(&p_input_file))
        success = false;
      if (success && !input_data_view.ReadPatchFile(&p_patch_file))
        success = false;
      if (success && !input_data_view.ReadOutputFile(&p_output_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FilePatcher::Name_, 0, false);
        return false;
      }
      auto callback =
          FilePatcher_PatchFilePuffPatch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PatchFilePuffPatch(        
        std::move(p_input_file), 
        std::move(p_patch_file), 
        std::move(p_output_file), std::move(callback));
      return true;
    }
    case messages::FilePatcher::kPatchFileZucchini: {
      internal::FilePatcher_PatchFileZucchini_Params_Data* params =
          reinterpret_cast<
              internal::FilePatcher_PatchFileZucchini_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FilePatcher.1
      bool success = true;
      ::base::File p_input_file{};
      ::base::File p_patch_file{};
      ::base::File p_output_file{};
      FilePatcher_PatchFileZucchini_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputFile(&p_input_file))
        success = false;
      if (success && !input_data_view.ReadPatchFile(&p_patch_file))
        success = false;
      if (success && !input_data_view.ReadOutputFile(&p_output_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FilePatcher::Name_, 1, false);
        return false;
      }
      auto callback =
          FilePatcher_PatchFileZucchini_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PatchFileZucchini(        
        std::move(p_input_file), 
        std::move(p_patch_file), 
        std::move(p_output_file), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFilePatcherValidationInfo[] = {
    { &internal::FilePatcher_PatchFilePuffPatch_Params_Data::Validate,
     &internal::FilePatcher_PatchFilePuffPatch_ResponseParams_Data::Validate},
    { &internal::FilePatcher_PatchFileZucchini_Params_Data::Validate,
     &internal::FilePatcher_PatchFileZucchini_ResponseParams_Data::Validate},
};

bool FilePatcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::patch::mojom::FilePatcher::Name_,
    kFilePatcherValidationInfo);
}

bool FilePatcherResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::patch::mojom::FilePatcher::Name_,
    kFilePatcherValidationInfo);
}


}  // patch::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace patch::mojom {


void FilePatcherInterceptorForTesting::PatchFilePuffPatch(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFilePuffPatchCallback callback) {
  GetForwardingInterface()->PatchFilePuffPatch(
    std::move(input_file)
    , 
    std::move(patch_file)
    , 
    std::move(output_file)
    , std::move(callback));
}
void FilePatcherInterceptorForTesting::PatchFileZucchini(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFileZucchiniCallback callback) {
  GetForwardingInterface()->PatchFileZucchini(
    std::move(input_file)
    , 
    std::move(patch_file)
    , 
    std::move(output_file)
    , std::move(callback));
}
FilePatcherAsyncWaiter::FilePatcherAsyncWaiter(
    FilePatcher* proxy) : proxy_(proxy) {}

FilePatcherAsyncWaiter::~FilePatcherAsyncWaiter() = default;


void FilePatcherAsyncWaiter::PatchFilePuffPatch(
    ::base::File input_file, ::base::File patch_file, ::base::File output_file, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->PatchFilePuffPatch(
      std::move(input_file),
      std::move(patch_file),
      std::move(output_file),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t FilePatcherAsyncWaiter::PatchFilePuffPatch(
    ::base::File input_file, ::base::File patch_file, ::base::File output_file) {
  int32_t async_wait_result;
  PatchFilePuffPatch(std::move(input_file),std::move(patch_file),std::move(output_file),&async_wait_result);
  return async_wait_result;
}

void FilePatcherAsyncWaiter::PatchFileZucchini(
    ::base::File input_file, ::base::File patch_file, ::base::File output_file, zucchini::status::Code* out_result) {
  base::RunLoop loop;
  proxy_->PatchFileZucchini(
      std::move(input_file),
      std::move(patch_file),
      std::move(output_file),
      base::BindOnce(
          [](base::RunLoop* loop,
             zucchini::status::Code* out_result
,
             zucchini::status::Code result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

zucchini::status::Code FilePatcherAsyncWaiter::PatchFileZucchini(
    ::base::File input_file, ::base::File patch_file, ::base::File output_file) {
  zucchini::status::Code async_wait_result;
  PatchFileZucchini(std::move(input_file),std::move(patch_file),std::move(output_file),&async_wait_result);
  return async_wait_result;
}






}  // patch::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif