// components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_H_
#define COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-features.h"  // IWYU pragma: export
#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-shared.h"  // IWYU pragma: export
#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-forward.h"  // IWYU pragma: export
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-forward.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace paint_preview::mojom {

class PaintPreviewCompositorProxy;

template <typename ImplRefTraits>
class PaintPreviewCompositorStub;

class PaintPreviewCompositorRequestValidator;
class PaintPreviewCompositorResponseValidator;


class PaintPreviewCompositor
    : public PaintPreviewCompositorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "paint_preview.mojom.PaintPreviewCompositor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaintPreviewCompositorInterfaceBase;
  using Proxy_ = PaintPreviewCompositorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaintPreviewCompositorStub<ImplRefTraits>;

  using RequestValidator_ = PaintPreviewCompositorRequestValidator;
  using ResponseValidator_ = PaintPreviewCompositorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBeginSeparatedFrameCompositeMinVersion = 0,
    kBitmapForSeparatedFrameMinVersion = 0,
    kBeginMainFrameCompositeMinVersion = 0,
    kBitmapForMainFrameMinVersion = 0,
    kSetRootFrameUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BeginSeparatedFrameComposite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BitmapForSeparatedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginMainFrameComposite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BitmapForMainFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRootFrameUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using BeginCompositeStatus = PaintPreviewCompositor_BeginCompositeStatus;
  
  using BitmapStatus = PaintPreviewCompositor_BitmapStatus;
  virtual ~PaintPreviewCompositor() = default;

  using BeginSeparatedFrameCompositeCallback = base::OnceCallback<void(PaintPreviewCompositor::BeginCompositeStatus, PaintPreviewBeginCompositeResponsePtr)>;
  using BeginSeparatedFrameCompositeMojoCallback = base::OnceCallback<void(PaintPreviewCompositor::BeginCompositeStatus, PaintPreviewBeginCompositeResponsePtr)>;

  virtual void BeginSeparatedFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginSeparatedFrameCompositeCallback callback) = 0;

  using BitmapForSeparatedFrameCallback = base::OnceCallback<void(PaintPreviewCompositor::BitmapStatus, const ::SkBitmap&)>;
  using BitmapForSeparatedFrameMojoCallback = base::OnceCallback<void(PaintPreviewCompositor::BitmapStatus, const ::SkBitmap&)>;

  virtual void BitmapForSeparatedFrame(const ::base::UnguessableToken& frame_guid, const ::gfx::Rect& clip_rect, float scale_factor, BitmapForSeparatedFrameCallback callback) = 0;

  using BeginMainFrameCompositeCallback = base::OnceCallback<void(PaintPreviewCompositor::BeginCompositeStatus, PaintPreviewBeginCompositeResponsePtr)>;
  using BeginMainFrameCompositeMojoCallback = base::OnceCallback<void(PaintPreviewCompositor::BeginCompositeStatus, PaintPreviewBeginCompositeResponsePtr)>;

  virtual void BeginMainFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginMainFrameCompositeCallback callback) = 0;

  using BitmapForMainFrameCallback = base::OnceCallback<void(PaintPreviewCompositor::BitmapStatus, const ::SkBitmap&)>;
  using BitmapForMainFrameMojoCallback = base::OnceCallback<void(PaintPreviewCompositor::BitmapStatus, const ::SkBitmap&)>;

  virtual void BitmapForMainFrame(const ::gfx::Rect& clip_rect, float scale_factor, BitmapForMainFrameCallback callback) = 0;

  virtual void SetRootFrameUrl(const ::GURL& url) = 0;
};

class PaintPreviewCompositorCollectionProxy;

template <typename ImplRefTraits>
class PaintPreviewCompositorCollectionStub;

class PaintPreviewCompositorCollectionRequestValidator;
class PaintPreviewCompositorCollectionResponseValidator;


class PaintPreviewCompositorCollection
    : public PaintPreviewCompositorCollectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "paint_preview.mojom.PaintPreviewCompositorCollection";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kPrintCompositor;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaintPreviewCompositorCollectionInterfaceBase;
  using Proxy_ = PaintPreviewCompositorCollectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaintPreviewCompositorCollectionStub<ImplRefTraits>;

  using RequestValidator_ = PaintPreviewCompositorCollectionRequestValidator;
  using ResponseValidator_ = PaintPreviewCompositorCollectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetDiscardableSharedMemoryManagerMinVersion = 0,
    kCreateCompositorMinVersion = 0,
    kOnMemoryPressureMinVersion = 0,
    kListCompositorsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetDiscardableSharedMemoryManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCompositor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMemoryPressure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ListCompositors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaintPreviewCompositorCollection() = default;

  virtual void SetDiscardableSharedMemoryManager(::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> manager) = 0;

  using CreateCompositorCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  using CreateCompositorMojoCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;

  virtual void CreateCompositor(::mojo::PendingReceiver<PaintPreviewCompositor> compositor, CreateCompositorCallback callback) = 0;

  virtual void OnMemoryPressure(::base::MemoryPressureLevel memory_pressure_level) = 0;

  using ListCompositorsCallback = base::OnceCallback<void(const std::vector<::base::UnguessableToken>&)>;
  using ListCompositorsMojoCallback = base::OnceCallback<void(const std::vector<::base::UnguessableToken>&)>;

  virtual void ListCompositors(ListCompositorsCallback callback) = 0;
};



class  PaintPreviewCompositorProxy
    : public PaintPreviewCompositor {
 public:
  using InterfaceType = PaintPreviewCompositor;

  explicit PaintPreviewCompositorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BeginSeparatedFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginSeparatedFrameCompositeCallback callback) final;
  
  void BitmapForSeparatedFrame(const ::base::UnguessableToken& frame_guid, const ::gfx::Rect& clip_rect, float scale_factor, BitmapForSeparatedFrameCallback callback) final;
  
  void BeginMainFrameComposite(PaintPreviewBeginCompositeRequestPtr request, BeginMainFrameCompositeCallback callback) final;
  
  void BitmapForMainFrame(const ::gfx::Rect& clip_rect, float scale_factor, BitmapForMainFrameCallback callback) final;
  
  void SetRootFrameUrl(const ::GURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PaintPreviewCompositorCollectionProxy
    : public PaintPreviewCompositorCollection {
 public:
  using InterfaceType = PaintPreviewCompositorCollection;

  explicit PaintPreviewCompositorCollectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetDiscardableSharedMemoryManager(::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> manager) final;
  
  void CreateCompositor(::mojo::PendingReceiver<PaintPreviewCompositor> compositor, CreateCompositorCallback callback) final;
  
  void OnMemoryPressure(::base::MemoryPressureLevel memory_pressure_level) final;
  
  void ListCompositors(ListCompositorsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PaintPreviewCompositorStubDispatch {
 public:
  static bool Accept(PaintPreviewCompositor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaintPreviewCompositor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaintPreviewCompositor>>
class PaintPreviewCompositorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaintPreviewCompositorStub() = default;
  ~PaintPreviewCompositorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewCompositorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewCompositorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PaintPreviewCompositorCollectionStubDispatch {
 public:
  static bool Accept(PaintPreviewCompositorCollection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaintPreviewCompositorCollection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaintPreviewCompositorCollection>>
class PaintPreviewCompositorCollectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaintPreviewCompositorCollectionStub() = default;
  ~PaintPreviewCompositorCollectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewCompositorCollectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewCompositorCollectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PaintPreviewCompositorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PaintPreviewCompositorCollectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PaintPreviewCompositorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PaintPreviewCompositorCollectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class  PaintPreviewBeginCompositeRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewBeginCompositeRequest, T>::value>;
  using DataView = PaintPreviewBeginCompositeRequestDataView;
  using Data_ = internal::PaintPreviewBeginCompositeRequest_Data;

  template <typename... Args>
  static PaintPreviewBeginCompositeRequestPtr New(Args&&... args) {
    return PaintPreviewBeginCompositeRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewBeginCompositeRequestPtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewBeginCompositeRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewBeginCompositeRequest>::Convert(*this);
  }


  PaintPreviewBeginCompositeRequest();

  PaintPreviewBeginCompositeRequest(
      ::mojo_base::ProtoWrapper preview,
      base::flat_map<::base::UnguessableToken, ::paint_preview::SerializedRecording> recording_map);

PaintPreviewBeginCompositeRequest(const PaintPreviewBeginCompositeRequest&) = delete;
PaintPreviewBeginCompositeRequest& operator=(const PaintPreviewBeginCompositeRequest&) = delete;

  ~PaintPreviewBeginCompositeRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewBeginCompositeRequestPtr>
  PaintPreviewBeginCompositeRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewBeginCompositeRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewBeginCompositeRequest_UnserializedMessageContext<
            UserType, PaintPreviewBeginCompositeRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewBeginCompositeRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewBeginCompositeRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewBeginCompositeRequest_UnserializedMessageContext<
            UserType, PaintPreviewBeginCompositeRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewBeginCompositeRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::ProtoWrapper preview;
  
  base::flat_map<::base::UnguessableToken, ::paint_preview::SerializedRecording> recording_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SubframeClipRect {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubframeClipRect, T>::value>;
  using DataView = SubframeClipRectDataView;
  using Data_ = internal::SubframeClipRect_Data;

  template <typename... Args>
  static SubframeClipRectPtr New(Args&&... args) {
    return SubframeClipRectPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubframeClipRectPtr From(const U& u) {
    return mojo::TypeConverter<SubframeClipRectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubframeClipRect>::Convert(*this);
  }


  SubframeClipRect();

  SubframeClipRect(
      const ::base::UnguessableToken& frame_guid,
      const ::gfx::RectF& clip_rect);


  ~SubframeClipRect();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubframeClipRectPtr>
  SubframeClipRectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubframeClipRect::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubframeClipRect::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubframeClipRect::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubframeClipRect_UnserializedMessageContext<
            UserType, SubframeClipRect::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubframeClipRect::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubframeClipRect::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubframeClipRect_UnserializedMessageContext<
            UserType, SubframeClipRect::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubframeClipRect::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken frame_guid;
  
  ::gfx::RectF clip_rect;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubframeClipRect::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameData, T>::value>;
  using DataView = FrameDataDataView;
  using Data_ = internal::FrameData_Data;

  template <typename... Args>
  static FrameDataPtr New(Args&&... args) {
    return FrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameDataPtr From(const U& u) {
    return mojo::TypeConverter<FrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameData>::Convert(*this);
  }


  FrameData();

  FrameData(
      const ::gfx::Size& scroll_extents,
      const ::gfx::Size& scroll_offsets,
      std::vector<SubframeClipRectPtr> subframes);

FrameData(const FrameData&) = delete;
FrameData& operator=(const FrameData&) = delete;

  ~FrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameDataPtr>
  FrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameData_UnserializedMessageContext<
            UserType, FrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameData_UnserializedMessageContext<
            UserType, FrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size scroll_extents;
  
  ::gfx::Size scroll_offsets;
  
  std::vector<SubframeClipRectPtr> subframes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PaintPreviewBeginCompositeResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewBeginCompositeResponse, T>::value>;
  using DataView = PaintPreviewBeginCompositeResponseDataView;
  using Data_ = internal::PaintPreviewBeginCompositeResponse_Data;

  template <typename... Args>
  static PaintPreviewBeginCompositeResponsePtr New(Args&&... args) {
    return PaintPreviewBeginCompositeResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewBeginCompositeResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewBeginCompositeResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewBeginCompositeResponse>::Convert(*this);
  }


  PaintPreviewBeginCompositeResponse();

  PaintPreviewBeginCompositeResponse(
      const ::base::UnguessableToken& root_frame_guid,
      base::flat_map<::base::UnguessableToken, FrameDataPtr> frames);

PaintPreviewBeginCompositeResponse(const PaintPreviewBeginCompositeResponse&) = delete;
PaintPreviewBeginCompositeResponse& operator=(const PaintPreviewBeginCompositeResponse&) = delete;

  ~PaintPreviewBeginCompositeResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewBeginCompositeResponsePtr>
  PaintPreviewBeginCompositeResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintPreviewBeginCompositeResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintPreviewBeginCompositeResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewBeginCompositeResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewBeginCompositeResponse_UnserializedMessageContext<
            UserType, PaintPreviewBeginCompositeResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewBeginCompositeResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewBeginCompositeResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewBeginCompositeResponse_UnserializedMessageContext<
            UserType, PaintPreviewBeginCompositeResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewBeginCompositeResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken root_frame_guid;
  
  base::flat_map<::base::UnguessableToken, FrameDataPtr> frames;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaintPreviewBeginCompositeRequestPtr PaintPreviewBeginCompositeRequest::Clone() const {
  return New(
      mojo::Clone(preview),
      mojo::Clone(recording_map)
  );
}

template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>*>
bool PaintPreviewBeginCompositeRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->preview, other_struct.preview))
    return false;
  if (!mojo::Equals(this->recording_map, other_struct.recording_map))
    return false;
  return true;
}

template <typename T, PaintPreviewBeginCompositeRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.preview < rhs.preview)
    return true;
  if (rhs.preview < lhs.preview)
    return false;
  if (lhs.recording_map < rhs.recording_map)
    return true;
  if (rhs.recording_map < lhs.recording_map)
    return false;
  return false;
}
template <typename StructPtrType>
SubframeClipRectPtr SubframeClipRect::Clone() const {
  return New(
      mojo::Clone(frame_guid),
      mojo::Clone(clip_rect)
  );
}

template <typename T, SubframeClipRect::EnableIfSame<T>*>
bool SubframeClipRect::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_guid, other_struct.frame_guid))
    return false;
  if (!mojo::Equals(this->clip_rect, other_struct.clip_rect))
    return false;
  return true;
}

template <typename T, SubframeClipRect::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_guid < rhs.frame_guid)
    return true;
  if (rhs.frame_guid < lhs.frame_guid)
    return false;
  if (lhs.clip_rect < rhs.clip_rect)
    return true;
  if (rhs.clip_rect < lhs.clip_rect)
    return false;
  return false;
}
template <typename StructPtrType>
FrameDataPtr FrameData::Clone() const {
  return New(
      mojo::Clone(scroll_extents),
      mojo::Clone(scroll_offsets),
      mojo::Clone(subframes)
  );
}

template <typename T, FrameData::EnableIfSame<T>*>
bool FrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_extents, other_struct.scroll_extents))
    return false;
  if (!mojo::Equals(this->scroll_offsets, other_struct.scroll_offsets))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  return true;
}

template <typename T, FrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_extents < rhs.scroll_extents)
    return true;
  if (rhs.scroll_extents < lhs.scroll_extents)
    return false;
  if (lhs.scroll_offsets < rhs.scroll_offsets)
    return true;
  if (rhs.scroll_offsets < lhs.scroll_offsets)
    return false;
  if (lhs.subframes < rhs.subframes)
    return true;
  if (rhs.subframes < lhs.subframes)
    return false;
  return false;
}
template <typename StructPtrType>
PaintPreviewBeginCompositeResponsePtr PaintPreviewBeginCompositeResponse::Clone() const {
  return New(
      mojo::Clone(root_frame_guid),
      mojo::Clone(frames)
  );
}

template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>*>
bool PaintPreviewBeginCompositeResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->root_frame_guid, other_struct.root_frame_guid))
    return false;
  if (!mojo::Equals(this->frames, other_struct.frames))
    return false;
  return true;
}

template <typename T, PaintPreviewBeginCompositeResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.root_frame_guid < rhs.root_frame_guid)
    return true;
  if (rhs.root_frame_guid < lhs.root_frame_guid)
    return false;
  if (lhs.frames < rhs.frames)
    return true;
  if (rhs.frames < lhs.frames)
    return false;
  return false;
}


}  // paint_preview::mojom

namespace mojo {


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewBeginCompositeRequest::DataView,
                                         ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr* output) { output->reset(); }

  static  decltype(::paint_preview::mojom::PaintPreviewBeginCompositeRequest::preview)& preview(
       ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr& input) {
    return input->preview;
  }

  static  decltype(::paint_preview::mojom::PaintPreviewBeginCompositeRequest::recording_map)& recording_map(
       ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr& input) {
    return input->recording_map;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewBeginCompositeRequest::DataView input, ::paint_preview::mojom::PaintPreviewBeginCompositeRequestPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::SubframeClipRect::DataView,
                                         ::paint_preview::mojom::SubframeClipRectPtr> {
  static bool IsNull(const ::paint_preview::mojom::SubframeClipRectPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::SubframeClipRectPtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::SubframeClipRect::frame_guid)& frame_guid(
      const ::paint_preview::mojom::SubframeClipRectPtr& input) {
    return input->frame_guid;
  }

  static const decltype(::paint_preview::mojom::SubframeClipRect::clip_rect)& clip_rect(
      const ::paint_preview::mojom::SubframeClipRectPtr& input) {
    return input->clip_rect;
  }

  static bool Read(::paint_preview::mojom::SubframeClipRect::DataView input, ::paint_preview::mojom::SubframeClipRectPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::FrameData::DataView,
                                         ::paint_preview::mojom::FrameDataPtr> {
  static bool IsNull(const ::paint_preview::mojom::FrameDataPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::FrameDataPtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::FrameData::scroll_extents)& scroll_extents(
      const ::paint_preview::mojom::FrameDataPtr& input) {
    return input->scroll_extents;
  }

  static const decltype(::paint_preview::mojom::FrameData::scroll_offsets)& scroll_offsets(
      const ::paint_preview::mojom::FrameDataPtr& input) {
    return input->scroll_offsets;
  }

  static const decltype(::paint_preview::mojom::FrameData::subframes)& subframes(
      const ::paint_preview::mojom::FrameDataPtr& input) {
    return input->subframes;
  }

  static bool Read(::paint_preview::mojom::FrameData::DataView input, ::paint_preview::mojom::FrameDataPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewBeginCompositeResponse::DataView,
                                         ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::PaintPreviewBeginCompositeResponse::root_frame_guid)& root_frame_guid(
      const ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr& input) {
    return input->root_frame_guid;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewBeginCompositeResponse::frames)& frames(
      const ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr& input) {
    return input->frames;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewBeginCompositeResponse::DataView input, ::paint_preview::mojom::PaintPreviewBeginCompositeResponsePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_H_