// components/services/font_data/public/mojom/font_data_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-features.h"  // IWYU pragma: export
#include "components/services/font_data/public/mojom/font_data_service.mojom-shared.h"  // IWYU pragma: export
#include "components/services/font_data/public/mojom/font_data_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace font_data_service::mojom {

class FontDataServiceProxy;

template <typename ImplRefTraits>
class FontDataServiceStub;

class FontDataServiceRequestValidator;
class FontDataServiceResponseValidator;


class FontDataService
    : public FontDataServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "font_data_service.mojom.FontDataService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FontDataServiceInterfaceBase;
  using Proxy_ = FontDataServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = FontDataServiceStub<ImplRefTraits>;

  using RequestValidator_ = FontDataServiceRequestValidator;
  using ResponseValidator_ = FontDataServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMatchFamilyNameMinVersion = 0,
    kMatchFamilyNameCharacterMinVersion = 0,
    kGetAllFamilyNamesMinVersion = 0,
    kLegacyMakeTypefaceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MatchFamilyName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MatchFamilyNameCharacter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllFamilyNames_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LegacyMakeTypeface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FontDataService() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result);
  using MatchFamilyNameCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;
  using MatchFamilyNameMojoCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;

  virtual void MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameResultPtr* out_result);
  using MatchFamilyNameCharacterCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;
  using MatchFamilyNameCharacterMojoCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;

  virtual void MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameCharacterCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetAllFamilyNames(std::vector<std::string>* out_result);
  using GetAllFamilyNamesCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetAllFamilyNamesMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetAllFamilyNames(GetAllFamilyNamesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result);
  using LegacyMakeTypefaceCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;
  using LegacyMakeTypefaceMojoCallback = base::OnceCallback<void(MatchFamilyNameResultPtr)>;

  virtual void LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, LegacyMakeTypefaceCallback callback) = 0;
};



class  FontDataServiceProxy
    : public FontDataService {
 public:
  using InterfaceType = FontDataService;

  explicit FontDataServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) final;
  
  void MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameCallback callback) final;
  
  bool MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameResultPtr* out_result) final;
  
  void MatchFamilyNameCharacter(const std::string& family_name, TypefaceStylePtr style, const std::vector<std::string>& bcp47s, int32_t character, MatchFamilyNameCharacterCallback callback) final;
  
  bool GetAllFamilyNames(std::vector<std::string>* out_result) final;
  
  void GetAllFamilyNames(GetAllFamilyNamesCallback callback) final;
  
  bool LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, MatchFamilyNameResultPtr* out_result) final;
  
  void LegacyMakeTypeface(const std::optional<std::string>& family_name, TypefaceStylePtr style, LegacyMakeTypefaceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FontDataServiceStubDispatch {
 public:
  static bool Accept(FontDataService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FontDataService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FontDataService>>
class FontDataServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FontDataServiceStub() = default;
  ~FontDataServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FontDataServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FontDataServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FontDataServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FontDataServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  TypefaceStyle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TypefaceStyle, T>::value>;
  using DataView = TypefaceStyleDataView;
  using Data_ = internal::TypefaceStyle_Data;

  template <typename... Args>
  static TypefaceStylePtr New(Args&&... args) {
    return TypefaceStylePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TypefaceStylePtr From(const U& u) {
    return mojo::TypeConverter<TypefaceStylePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypefaceStyle>::Convert(*this);
  }


  TypefaceStyle();

  TypefaceStyle(
      uint16_t weight,
      uint8_t width,
      TypefaceSlant slant);


  ~TypefaceStyle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TypefaceStylePtr>
  TypefaceStylePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypefaceStyle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypefaceStyle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypefaceStyle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TypefaceStyle_UnserializedMessageContext<
            UserType, TypefaceStyle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TypefaceStyle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TypefaceStyle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TypefaceStyle_UnserializedMessageContext<
            UserType, TypefaceStyle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TypefaceStyle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t weight;
  
  uint8_t width;
  
  TypefaceSlant slant;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Coordinate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Coordinate, T>::value>;
  using DataView = CoordinateDataView;
  using Data_ = internal::Coordinate_Data;

  template <typename... Args>
  static CoordinatePtr New(Args&&... args) {
    return CoordinatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CoordinatePtr From(const U& u) {
    return mojo::TypeConverter<CoordinatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Coordinate>::Convert(*this);
  }


  Coordinate();

  Coordinate(
      uint32_t axis,
      float value);


  ~Coordinate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CoordinatePtr>
  CoordinatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Coordinate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Coordinate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Coordinate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Coordinate_UnserializedMessageContext<
            UserType, Coordinate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Coordinate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Coordinate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Coordinate_UnserializedMessageContext<
            UserType, Coordinate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Coordinate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t axis;
  
  float value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Coordinate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  TypefaceData {
 public:
  using DataView = TypefaceDataDataView;
  using Data_ = internal::TypefaceData_Data;
  using Tag = Data_::TypefaceData_Tag;

  template <typename... Args>
  static TypefaceDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |region|.
  static TypefaceDataPtr NewRegion(
      ::base::ReadOnlySharedMemoryRegion value);
  // Construct an instance holding |font_file|.
  static TypefaceDataPtr NewFontFile(
      TypefaceFilePtr value);

  template <typename U>
  static TypefaceDataPtr From(const U& u) {
    return mojo::TypeConverter<TypefaceDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypefaceData>::Convert(*this);
  }
  ~TypefaceData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TypefaceData(const TypefaceData& other) = delete;
  TypefaceData& operator=(const TypefaceData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TypefaceDataPtr>
  TypefaceDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TypefaceData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TypefaceData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_region() const { return tag_ == Tag::kRegion; }
  const ::base::ReadOnlySharedMemoryRegion& get_region() const {
    CHECK(tag_ == Tag::kRegion);
    return data_.region;
  }
  ::base::ReadOnlySharedMemoryRegion& get_region() {
    CHECK(tag_ == Tag::kRegion);
    return data_.region;
  }
  void set_region(::base::ReadOnlySharedMemoryRegion region);

  bool is_font_file() const { return tag_ == Tag::kFontFile; }
  const TypefaceFilePtr& get_font_file() const {
    CHECK(tag_ == Tag::kFontFile);
    return data_.font_file;
  }
  TypefaceFilePtr& get_font_file() {
    CHECK(tag_ == Tag::kFontFile);
    return data_.font_file;
  }
  void set_font_file(TypefaceFilePtr font_file);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypefaceData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TypefaceData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegion)>,
        ::base::ReadOnlySharedMemoryRegion value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFontFile)>,
        TypefaceFilePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::ReadOnlySharedMemoryRegion region;
    TypefaceFilePtr font_file;
  };

  TypefaceData(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegion)>,
      ::base::ReadOnlySharedMemoryRegion value);
  TypefaceData(
      std::in_place_index_t<static_cast<size_t>(Tag::kFontFile)>,
      TypefaceFilePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class  VariationPosition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VariationPosition, T>::value>;
  using DataView = VariationPositionDataView;
  using Data_ = internal::VariationPosition_Data;

  template <typename... Args>
  static VariationPositionPtr New(Args&&... args) {
    return VariationPositionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VariationPositionPtr From(const U& u) {
    return mojo::TypeConverter<VariationPositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VariationPosition>::Convert(*this);
  }


  VariationPosition();

  VariationPosition(
      std::vector<CoordinatePtr> coordinates,
      uint16_t coordinateCount);

VariationPosition(const VariationPosition&) = delete;
VariationPosition& operator=(const VariationPosition&) = delete;

  ~VariationPosition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VariationPositionPtr>
  VariationPositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariationPosition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VariationPosition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VariationPosition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VariationPosition_UnserializedMessageContext<
            UserType, VariationPosition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VariationPosition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VariationPosition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VariationPosition_UnserializedMessageContext<
            UserType, VariationPosition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VariationPosition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<CoordinatePtr> coordinates;
  
  uint16_t coordinateCount;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VariationPosition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TypefaceFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TypefaceFile, T>::value>;
  using DataView = TypefaceFileDataView;
  using Data_ = internal::TypefaceFile_Data;

  template <typename... Args>
  static TypefaceFilePtr New(Args&&... args) {
    return TypefaceFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TypefaceFilePtr From(const U& u) {
    return mojo::TypeConverter<TypefaceFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypefaceFile>::Convert(*this);
  }


  TypefaceFile();

  TypefaceFile(
      ::base::File file_handle,
      uint64_t id);

TypefaceFile(const TypefaceFile&) = delete;
TypefaceFile& operator=(const TypefaceFile&) = delete;

  ~TypefaceFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TypefaceFilePtr>
  TypefaceFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypefaceFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TypefaceFile_UnserializedMessageContext<
            UserType, TypefaceFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TypefaceFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TypefaceFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TypefaceFile_UnserializedMessageContext<
            UserType, TypefaceFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TypefaceFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File file_handle;
  
  uint64_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TypefaceFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MatchFamilyNameResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MatchFamilyNameResult, T>::value>;
  using DataView = MatchFamilyNameResultDataView;
  using Data_ = internal::MatchFamilyNameResult_Data;

  template <typename... Args>
  static MatchFamilyNameResultPtr New(Args&&... args) {
    return MatchFamilyNameResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MatchFamilyNameResultPtr From(const U& u) {
    return mojo::TypeConverter<MatchFamilyNameResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MatchFamilyNameResult>::Convert(*this);
  }


  MatchFamilyNameResult();

  MatchFamilyNameResult(
      TypefaceDataPtr typeface_data,
      int32_t ttc_index,
      VariationPositionPtr variation_position);

MatchFamilyNameResult(const MatchFamilyNameResult&) = delete;
MatchFamilyNameResult& operator=(const MatchFamilyNameResult&) = delete;

  ~MatchFamilyNameResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MatchFamilyNameResultPtr>
  MatchFamilyNameResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MatchFamilyNameResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MatchFamilyNameResult_UnserializedMessageContext<
            UserType, MatchFamilyNameResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MatchFamilyNameResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MatchFamilyNameResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MatchFamilyNameResult_UnserializedMessageContext<
            UserType, MatchFamilyNameResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MatchFamilyNameResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TypefaceDataPtr typeface_data;
  
  int32_t ttc_index;
  
  VariationPositionPtr variation_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MatchFamilyNameResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TypefaceDataPtr TypefaceData::Clone() const {
  switch (tag_) {
    case Tag::kRegion:
      return NewRegion(
          mojo::Clone(data_.region));
    case Tag::kFontFile:
      return NewFontFile(
          mojo::Clone(data_.font_file));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TypefaceData>::value>::type*>
bool TypefaceData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRegion:
      return mojo::Equals(data_.region, other.data_.region);
    case Tag::kFontFile:
      return mojo::Equals(data_.font_file, other.data_.font_file);
  }

  return false;
}
template <typename StructPtrType>
TypefaceStylePtr TypefaceStyle::Clone() const {
  return New(
      mojo::Clone(weight),
      mojo::Clone(width),
      mojo::Clone(slant)
  );
}

template <typename T, TypefaceStyle::EnableIfSame<T>*>
bool TypefaceStyle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->weight, other_struct.weight))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->slant, other_struct.slant))
    return false;
  return true;
}

template <typename T, TypefaceStyle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.weight < rhs.weight)
    return true;
  if (rhs.weight < lhs.weight)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.slant < rhs.slant)
    return true;
  if (rhs.slant < lhs.slant)
    return false;
  return false;
}
template <typename StructPtrType>
CoordinatePtr Coordinate::Clone() const {
  return New(
      mojo::Clone(axis),
      mojo::Clone(value)
  );
}

template <typename T, Coordinate::EnableIfSame<T>*>
bool Coordinate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, Coordinate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
VariationPositionPtr VariationPosition::Clone() const {
  return New(
      mojo::Clone(coordinates),
      mojo::Clone(coordinateCount)
  );
}

template <typename T, VariationPosition::EnableIfSame<T>*>
bool VariationPosition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->coordinates, other_struct.coordinates))
    return false;
  if (!mojo::Equals(this->coordinateCount, other_struct.coordinateCount))
    return false;
  return true;
}

template <typename T, VariationPosition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.coordinates < rhs.coordinates)
    return true;
  if (rhs.coordinates < lhs.coordinates)
    return false;
  if (lhs.coordinateCount < rhs.coordinateCount)
    return true;
  if (rhs.coordinateCount < lhs.coordinateCount)
    return false;
  return false;
}
template <typename StructPtrType>
TypefaceFilePtr TypefaceFile::Clone() const {
  return New(
      mojo::Clone(file_handle),
      mojo::Clone(id)
  );
}

template <typename T, TypefaceFile::EnableIfSame<T>*>
bool TypefaceFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_handle, other_struct.file_handle))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, TypefaceFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_handle < rhs.file_handle)
    return true;
  if (rhs.file_handle < lhs.file_handle)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
MatchFamilyNameResultPtr MatchFamilyNameResult::Clone() const {
  return New(
      mojo::Clone(typeface_data),
      mojo::Clone(ttc_index),
      mojo::Clone(variation_position)
  );
}

template <typename T, MatchFamilyNameResult::EnableIfSame<T>*>
bool MatchFamilyNameResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->typeface_data, other_struct.typeface_data))
    return false;
  if (!mojo::Equals(this->ttc_index, other_struct.ttc_index))
    return false;
  if (!mojo::Equals(this->variation_position, other_struct.variation_position))
    return false;
  return true;
}

template <typename T, MatchFamilyNameResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.typeface_data < rhs.typeface_data)
    return true;
  if (rhs.typeface_data < lhs.typeface_data)
    return false;
  if (lhs.ttc_index < rhs.ttc_index)
    return true;
  if (rhs.ttc_index < lhs.ttc_index)
    return false;
  if (lhs.variation_position < rhs.variation_position)
    return true;
  if (rhs.variation_position < lhs.variation_position)
    return false;
  return false;
}


}  // font_data_service::mojom

namespace mojo {


template <>
struct  StructTraits<::font_data_service::mojom::TypefaceStyle::DataView,
                                         ::font_data_service::mojom::TypefaceStylePtr> {
  static bool IsNull(const ::font_data_service::mojom::TypefaceStylePtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::TypefaceStylePtr* output) { output->reset(); }

  static decltype(::font_data_service::mojom::TypefaceStyle::weight) weight(
      const ::font_data_service::mojom::TypefaceStylePtr& input) {
    return input->weight;
  }

  static decltype(::font_data_service::mojom::TypefaceStyle::width) width(
      const ::font_data_service::mojom::TypefaceStylePtr& input) {
    return input->width;
  }

  static decltype(::font_data_service::mojom::TypefaceStyle::slant) slant(
      const ::font_data_service::mojom::TypefaceStylePtr& input) {
    return input->slant;
  }

  static bool Read(::font_data_service::mojom::TypefaceStyle::DataView input, ::font_data_service::mojom::TypefaceStylePtr* output);
};


template <>
struct  StructTraits<::font_data_service::mojom::Coordinate::DataView,
                                         ::font_data_service::mojom::CoordinatePtr> {
  static bool IsNull(const ::font_data_service::mojom::CoordinatePtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::CoordinatePtr* output) { output->reset(); }

  static decltype(::font_data_service::mojom::Coordinate::axis) axis(
      const ::font_data_service::mojom::CoordinatePtr& input) {
    return input->axis;
  }

  static decltype(::font_data_service::mojom::Coordinate::value) value(
      const ::font_data_service::mojom::CoordinatePtr& input) {
    return input->value;
  }

  static bool Read(::font_data_service::mojom::Coordinate::DataView input, ::font_data_service::mojom::CoordinatePtr* output);
};


template <>
struct  StructTraits<::font_data_service::mojom::VariationPosition::DataView,
                                         ::font_data_service::mojom::VariationPositionPtr> {
  static bool IsNull(const ::font_data_service::mojom::VariationPositionPtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::VariationPositionPtr* output) { output->reset(); }

  static const decltype(::font_data_service::mojom::VariationPosition::coordinates)& coordinates(
      const ::font_data_service::mojom::VariationPositionPtr& input) {
    return input->coordinates;
  }

  static decltype(::font_data_service::mojom::VariationPosition::coordinateCount) coordinateCount(
      const ::font_data_service::mojom::VariationPositionPtr& input) {
    return input->coordinateCount;
  }

  static bool Read(::font_data_service::mojom::VariationPosition::DataView input, ::font_data_service::mojom::VariationPositionPtr* output);
};


template <>
struct  StructTraits<::font_data_service::mojom::TypefaceFile::DataView,
                                         ::font_data_service::mojom::TypefaceFilePtr> {
  static bool IsNull(const ::font_data_service::mojom::TypefaceFilePtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::TypefaceFilePtr* output) { output->reset(); }

  static  decltype(::font_data_service::mojom::TypefaceFile::file_handle)& file_handle(
       ::font_data_service::mojom::TypefaceFilePtr& input) {
    return input->file_handle;
  }

  static decltype(::font_data_service::mojom::TypefaceFile::id) id(
      const ::font_data_service::mojom::TypefaceFilePtr& input) {
    return input->id;
  }

  static bool Read(::font_data_service::mojom::TypefaceFile::DataView input, ::font_data_service::mojom::TypefaceFilePtr* output);
};


template <>
struct  StructTraits<::font_data_service::mojom::MatchFamilyNameResult::DataView,
                                         ::font_data_service::mojom::MatchFamilyNameResultPtr> {
  static bool IsNull(const ::font_data_service::mojom::MatchFamilyNameResultPtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::MatchFamilyNameResultPtr* output) { output->reset(); }

  static  decltype(::font_data_service::mojom::MatchFamilyNameResult::typeface_data)& typeface_data(
       ::font_data_service::mojom::MatchFamilyNameResultPtr& input) {
    return input->typeface_data;
  }

  static decltype(::font_data_service::mojom::MatchFamilyNameResult::ttc_index) ttc_index(
      const ::font_data_service::mojom::MatchFamilyNameResultPtr& input) {
    return input->ttc_index;
  }

  static const decltype(::font_data_service::mojom::MatchFamilyNameResult::variation_position)& variation_position(
      const ::font_data_service::mojom::MatchFamilyNameResultPtr& input) {
    return input->variation_position;
  }

  static bool Read(::font_data_service::mojom::MatchFamilyNameResult::DataView input, ::font_data_service::mojom::MatchFamilyNameResultPtr* output);
};


template <>
struct  UnionTraits<::font_data_service::mojom::TypefaceData::DataView,
                                        ::font_data_service::mojom::TypefaceDataPtr> {
  static bool IsNull(const ::font_data_service::mojom::TypefaceDataPtr& input) { return !input; }
  static void SetToNull(::font_data_service::mojom::TypefaceDataPtr* output) { output->reset(); }

  static ::font_data_service::mojom::TypefaceData::Tag GetTag(const ::font_data_service::mojom::TypefaceDataPtr& input) {
    return input->which();
  }

  static  ::base::ReadOnlySharedMemoryRegion& region( ::font_data_service::mojom::TypefaceDataPtr& input) {
    return input->get_region();
  }

  static  ::font_data_service::mojom::TypefaceFilePtr& font_file( ::font_data_service::mojom::TypefaceDataPtr& input) {
    return input->get_font_file();
  }

  static bool Read(::font_data_service::mojom::TypefaceData::DataView input, ::font_data_service::mojom::TypefaceDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_H_