// components/services/filesystem/public/mojom/directory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FileError as mojoBase_mojom_FileError,
  FileErrorSpec as mojoBase_mojom_FileErrorSpec
} from '../../../../../mojo/public/mojom/base/file_error.mojom.m.js';

import {
  DirectoryEntry as filesystem_mojom_DirectoryEntry,
  DirectoryEntrySpec as filesystem_mojom_DirectoryEntrySpec,
  FileInformation as filesystem_mojom_FileInformation,
  FileInformationSpec as filesystem_mojom_FileInformationSpec
} from './types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DirectoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'filesystem.mojom.Directory', scope);
  }
}

/** @interface */
export class DirectoryInterface {
  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        directoryContents: ?Array<!filesystem_mojom_DirectoryEntry>,
   *  }>}
   */

  read() {}
  
  /**
   * @param { !string } path
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        fileHandle: ?mojoBase_mojom_File,
   *  }>}
   */

  openFileHandle(path, openFlags) {}
  
  /**
   * @param { !Array<!FileOpenDetails> } files
   * @return {!Promise<{
        results: !Array<!FileOpenResult>,
   *  }>}
   */

  openFileHandles(files) {}
  
  /**
   * @param { !string } path
   * @param { ?DirectoryPendingReceiver } directory
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  openDirectory(path, directory, openFlags) {}
  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  rename(path, newPath) {}
  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  replace(path, newPath) {}
  
  /**
   * @param { !string } path
   * @param { !number } deleteFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  delete(path, deleteFlags) {}
  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        exists: !boolean,
   *  }>}
   */

  exists(path) {}
  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        isWritable: !boolean,
   *  }>}
   */

  isWritable(path) {}
  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  flush() {}
  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        fileInformation: ?filesystem_mojom_FileInformation,
   *  }>}
   */

  statFile(path) {}
  
  /**
   * @param { !DirectoryPendingReceiver } directory
   */

  clone(directory) {}
  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        data: !Array<!number>,
   *  }>}
   */

  readEntireFile(path) {}
  
  /**
   * @param { !string } path
   * @param { !Array<!number> } data
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  writeFile(path, data) {}
}

/**
 * @implements { DirectoryInterface }
 */
export class DirectoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DirectoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DirectoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DirectoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        directoryContents: ?Array<!filesystem_mojom_DirectoryEntry>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        Directory_Read_ParamsSpec.$,
        Directory_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        fileHandle: ?mojoBase_mojom_File,
   *  }>}
   */

  openFileHandle(
      path,
      openFlags) {
    return this.proxy.sendMessage(
        1,
        Directory_OpenFileHandle_ParamsSpec.$,
        Directory_OpenFileHandle_ResponseParamsSpec.$,
        [
          path,
          openFlags
        ],
        false);
  }

  
  /**
   * @param { !Array<!FileOpenDetails> } files
   * @return {!Promise<{
        results: !Array<!FileOpenResult>,
   *  }>}
   */

  openFileHandles(
      files) {
    return this.proxy.sendMessage(
        2,
        Directory_OpenFileHandles_ParamsSpec.$,
        Directory_OpenFileHandles_ResponseParamsSpec.$,
        [
          files
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { ?DirectoryPendingReceiver } directory
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  openDirectory(
      path,
      directory,
      openFlags) {
    return this.proxy.sendMessage(
        3,
        Directory_OpenDirectory_ParamsSpec.$,
        Directory_OpenDirectory_ResponseParamsSpec.$,
        [
          path,
          directory,
          openFlags
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  rename(
      path,
      newPath) {
    return this.proxy.sendMessage(
        4,
        Directory_Rename_ParamsSpec.$,
        Directory_Rename_ResponseParamsSpec.$,
        [
          path,
          newPath
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  replace(
      path,
      newPath) {
    return this.proxy.sendMessage(
        5,
        Directory_Replace_ParamsSpec.$,
        Directory_Replace_ResponseParamsSpec.$,
        [
          path,
          newPath
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !number } deleteFlags
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  delete(
      path,
      deleteFlags) {
    return this.proxy.sendMessage(
        6,
        Directory_Delete_ParamsSpec.$,
        Directory_Delete_ResponseParamsSpec.$,
        [
          path,
          deleteFlags
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        exists: !boolean,
   *  }>}
   */

  exists(
      path) {
    return this.proxy.sendMessage(
        7,
        Directory_Exists_ParamsSpec.$,
        Directory_Exists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        isWritable: !boolean,
   *  }>}
   */

  isWritable(
      path) {
    return this.proxy.sendMessage(
        8,
        Directory_IsWritable_ParamsSpec.$,
        Directory_IsWritable_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        9,
        Directory_Flush_ParamsSpec.$,
        Directory_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        fileInformation: ?filesystem_mojom_FileInformation,
   *  }>}
   */

  statFile(
      path) {
    return this.proxy.sendMessage(
        10,
        Directory_StatFile_ParamsSpec.$,
        Directory_StatFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !DirectoryPendingReceiver } directory
   */

  clone(
      directory) {
    this.proxy.sendMessage(
        11,
        Directory_Clone_ParamsSpec.$,
        null,
        [
          directory
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        data: !Array<!number>,
   *  }>}
   */

  readEntireFile(
      path) {
    return this.proxy.sendMessage(
        12,
        Directory_ReadEntireFile_ParamsSpec.$,
        Directory_ReadEntireFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !Array<!number> } data
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  writeFile(
      path,
      data) {
    return this.proxy.sendMessage(
        13,
        Directory_WriteFile_ParamsSpec.$,
        Directory_WriteFile_ResponseParamsSpec.$,
        [
          path,
          data
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Directory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DirectoryReceiver {
  /**
   * @param {!DirectoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DirectoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DirectoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DirectoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Directory_Read_ParamsSpec.$,
        Directory_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Directory_OpenFileHandle_ParamsSpec.$,
        Directory_OpenFileHandle_ResponseParamsSpec.$,
        impl.openFileHandle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Directory_OpenFileHandles_ParamsSpec.$,
        Directory_OpenFileHandles_ResponseParamsSpec.$,
        impl.openFileHandles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Directory_OpenDirectory_ParamsSpec.$,
        Directory_OpenDirectory_ResponseParamsSpec.$,
        impl.openDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Directory_Rename_ParamsSpec.$,
        Directory_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Directory_Replace_ParamsSpec.$,
        Directory_Replace_ResponseParamsSpec.$,
        impl.replace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Directory_Delete_ParamsSpec.$,
        Directory_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Directory_Exists_ParamsSpec.$,
        Directory_Exists_ResponseParamsSpec.$,
        impl.exists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Directory_IsWritable_ParamsSpec.$,
        Directory_IsWritable_ResponseParamsSpec.$,
        impl.isWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Directory_Flush_ParamsSpec.$,
        Directory_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Directory_StatFile_ParamsSpec.$,
        Directory_StatFile_ResponseParamsSpec.$,
        impl.statFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        Directory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        Directory_ReadEntireFile_ParamsSpec.$,
        Directory_ReadEntireFile_ResponseParamsSpec.$,
        impl.readEntireFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        Directory_WriteFile_ParamsSpec.$,
        Directory_WriteFile_ResponseParamsSpec.$,
        impl.writeFile.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Directory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "filesystem.mojom.Directory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DirectoryRemote}
   */
  static getRemote() {
    let remote = new DirectoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Directory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DirectoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DirectoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DirectoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Directory_Read_ParamsSpec.$,
        Directory_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Directory_OpenFileHandle_ParamsSpec.$,
        Directory_OpenFileHandle_ResponseParamsSpec.$,
        this.openFileHandle.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileHandles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Directory_OpenFileHandles_ParamsSpec.$,
        Directory_OpenFileHandles_ResponseParamsSpec.$,
        this.openFileHandles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Directory_OpenDirectory_ParamsSpec.$,
        Directory_OpenDirectory_ResponseParamsSpec.$,
        this.openDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Directory_Rename_ParamsSpec.$,
        Directory_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Directory_Replace_ParamsSpec.$,
        Directory_Replace_ResponseParamsSpec.$,
        this.replace.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Directory_Delete_ParamsSpec.$,
        Directory_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Directory_Exists_ParamsSpec.$,
        Directory_Exists_ResponseParamsSpec.$,
        this.exists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Directory_IsWritable_ParamsSpec.$,
        Directory_IsWritable_ResponseParamsSpec.$,
        this.isWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Directory_Flush_ParamsSpec.$,
        Directory_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.statFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Directory_StatFile_ParamsSpec.$,
        Directory_StatFile_ResponseParamsSpec.$,
        this.statFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        Directory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readEntireFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        Directory_ReadEntireFile_ParamsSpec.$,
        Directory_ReadEntireFile_ResponseParamsSpec.$,
        this.readEntireFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        Directory_WriteFile_ParamsSpec.$,
        Directory_WriteFile_ResponseParamsSpec.$,
        this.writeFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileOpenDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileOpenResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenFileHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenFileHandle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenFileHandles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenFileHandles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_OpenDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Replace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Replace_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Exists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Exists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_IsWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_IsWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_StatFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_StatFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_ReadEntireFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_ReadEntireFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_WriteFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Directory_WriteFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileOpenDetailsSpec.$,
    'FileOpenDetails',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileOpenDetails {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !number } */
    this.openFlags;
  }
}



mojo.internal.Struct(
    FileOpenResultSpec.$,
    'FileOpenResult',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileHandle', 16,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileOpenResult {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.fileHandle;
  }
}



mojo.internal.Struct(
    Directory_Read_ParamsSpec.$,
    'Directory_Read_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Directory_Read_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Directory_Read_ResponseParamsSpec.$,
    'Directory_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directoryContents', 8,
        0,
        mojo.internal.Array(filesystem_mojom_DirectoryEntrySpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_Read_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { (Array<!filesystem_mojom_DirectoryEntry>|undefined) } */
    this.directoryContents;
  }
}



mojo.internal.Struct(
    Directory_OpenFileHandle_ParamsSpec.$,
    'Directory_OpenFileHandle_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_OpenFileHandle_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !number } */
    this.openFlags;
  }
}



mojo.internal.Struct(
    Directory_OpenFileHandle_ResponseParamsSpec.$,
    'Directory_OpenFileHandle_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileHandle', 8,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_OpenFileHandle_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.fileHandle;
  }
}



mojo.internal.Struct(
    Directory_OpenFileHandles_ParamsSpec.$,
    'Directory_OpenFileHandles_Params',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(FileOpenDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_OpenFileHandles_Params {
  constructor() {
    /** @type { !Array<!FileOpenDetails> } */
    this.files;
  }
}



mojo.internal.Struct(
    Directory_OpenFileHandles_ResponseParamsSpec.$,
    'Directory_OpenFileHandles_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(FileOpenResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_OpenFileHandles_ResponseParams {
  constructor() {
    /** @type { !Array<!FileOpenResult> } */
    this.results;
  }
}



mojo.internal.Struct(
    Directory_OpenDirectory_ParamsSpec.$,
    'Directory_OpenDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceRequest(DirectoryPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openFlags', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_OpenDirectory_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { (DirectoryPendingReceiver|undefined) } */
    this.directory;
    /** @type { !number } */
    this.openFlags;
  }
}



mojo.internal.Struct(
    Directory_OpenDirectory_ResponseParamsSpec.$,
    'Directory_OpenDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_OpenDirectory_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    Directory_Rename_ParamsSpec.$,
    'Directory_Rename_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newPath', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_Rename_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !string } */
    this.newPath;
  }
}



mojo.internal.Struct(
    Directory_Rename_ResponseParamsSpec.$,
    'Directory_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Rename_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    Directory_Replace_ParamsSpec.$,
    'Directory_Replace_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newPath', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_Replace_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !string } */
    this.newPath;
  }
}



mojo.internal.Struct(
    Directory_Replace_ResponseParamsSpec.$,
    'Directory_Replace_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Replace_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    Directory_Delete_ParamsSpec.$,
    'Directory_Delete_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deleteFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_Delete_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !number } */
    this.deleteFlags;
  }
}



mojo.internal.Struct(
    Directory_Delete_ResponseParamsSpec.$,
    'Directory_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Delete_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    Directory_Exists_ParamsSpec.$,
    'Directory_Exists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Exists_Params {
  constructor() {
    /** @type { !string } */
    this.path;
  }
}



mojo.internal.Struct(
    Directory_Exists_ResponseParamsSpec.$,
    'Directory_Exists_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exists', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Exists_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !boolean } */
    this.exists;
  }
}



mojo.internal.Struct(
    Directory_IsWritable_ParamsSpec.$,
    'Directory_IsWritable_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_IsWritable_Params {
  constructor() {
    /** @type { !string } */
    this.path;
  }
}



mojo.internal.Struct(
    Directory_IsWritable_ResponseParamsSpec.$,
    'Directory_IsWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWritable', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_IsWritable_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !boolean } */
    this.isWritable;
  }
}



mojo.internal.Struct(
    Directory_Flush_ParamsSpec.$,
    'Directory_Flush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Directory_Flush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Directory_Flush_ResponseParamsSpec.$,
    'Directory_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Flush_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    Directory_StatFile_ParamsSpec.$,
    'Directory_StatFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_StatFile_Params {
  constructor() {
    /** @type { !string } */
    this.path;
  }
}



mojo.internal.Struct(
    Directory_StatFile_ResponseParamsSpec.$,
    'Directory_StatFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileInformation', 8,
        0,
        filesystem_mojom_FileInformationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_StatFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { (filesystem_mojom_FileInformation|undefined) } */
    this.fileInformation;
  }
}



mojo.internal.Struct(
    Directory_Clone_ParamsSpec.$,
    'Directory_Clone_Params',
    [
      mojo.internal.StructField(
        'directory', 0,
        0,
        mojo.internal.InterfaceRequest(DirectoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_Clone_Params {
  constructor() {
    /** @type { !DirectoryPendingReceiver } */
    this.directory;
  }
}



mojo.internal.Struct(
    Directory_ReadEntireFile_ParamsSpec.$,
    'Directory_ReadEntireFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_ReadEntireFile_Params {
  constructor() {
    /** @type { !string } */
    this.path;
  }
}



mojo.internal.Struct(
    Directory_ReadEntireFile_ResponseParamsSpec.$,
    'Directory_ReadEntireFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_ReadEntireFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    Directory_WriteFile_ParamsSpec.$,
    'Directory_WriteFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Directory_WriteFile_Params {
  constructor() {
    /** @type { !string } */
    this.path;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    Directory_WriteFile_ResponseParamsSpec.$,
    'Directory_WriteFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Directory_WriteFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}

