// Generated by the proto_extras plugin. DO NOT EDIT!
// source: components/safe_browsing/core/common/proto/csd.proto

#include "components/safe_browsing/core/common/proto/csd.to_value.h"



#include "base/base64.h"
#include "base/strings/string_number_conversions.h"
#include "base/values.h"
#include "components/proto_extras/proto_extras_lib.h"
#include "components/safe_browsing/core/common/proto/csd.pb.h"


namespace safe_browsing {
base::Value Serialize(const ChromeUserPopulation& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_user_population()) {
    dict.Set("user_population", ::safe_browsing::ChromeUserPopulation_UserPopulation_Name(message.user_population()));
  }
  if (message.has_is_history_sync_enabled()) {
    dict.Set("is_history_sync_enabled", static_cast<bool>(message.is_history_sync_enabled()));
  }
  if (!message.finch_active_groups().empty()) {
    base::ListValue list;
    for (const auto& value : message.finch_active_groups()) {
      list.Append((value));
    }
    dict.Set("finch_active_groups", std::move(list));
  }
  if (message.has_profile_management_status()) {
    dict.Set("profile_management_status", ::safe_browsing::ChromeUserPopulation_ProfileManagementStatus_Name(message.profile_management_status()));
  }
  if (message.has_is_under_advanced_protection()) {
    dict.Set("is_under_advanced_protection", static_cast<bool>(message.is_under_advanced_protection()));
  }
  if (message.has_is_incognito()) {
    dict.Set("is_incognito", static_cast<bool>(message.is_incognito()));
  }
  if (message.has_is_mbb_enabled()) {
    dict.Set("is_mbb_enabled", static_cast<bool>(message.is_mbb_enabled()));
  }
  if (message.has_user_agent()) {
    dict.Set("user_agent", (message.user_agent()));
  }
  if (message.has_number_of_profiles()) {
    dict.Set("number_of_profiles", (message.number_of_profiles()));
  }
  if (message.has_number_of_loaded_profiles()) {
    dict.Set("number_of_loaded_profiles", (message.number_of_loaded_profiles()));
  }
  if (!message.page_load_tokens().empty()) {
    base::ListValue list;
    for (const auto& value : message.page_load_tokens()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("page_load_tokens", std::move(list));
  }
  if (message.has_is_aesb_enabled()) {
    dict.Set("is_aesb_enabled", static_cast<bool>(message.is_aesb_enabled()));
  }
  if (message.has_aesb_last_update_time_windows_epoch_micros()) {
    dict.Set("aesb_last_update_time_windows_epoch_micros", ::proto_extras::ToNumericTypeForValue(message.aesb_last_update_time_windows_epoch_micros()));
  }
  if (message.has_is_signed_in()) {
    dict.Set("is_signed_in", static_cast<bool>(message.is_signed_in()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ChromeUserPopulation>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ChromeUserPopulation_PageLoadToken& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_token_source()) {
    dict.Set("token_source", ::safe_browsing::ChromeUserPopulation_PageLoadToken_TokenSource_Name(message.token_source()));
  }
  if (message.has_token_time_msec()) {
    dict.Set("token_time_msec", ::proto_extras::ToNumericTypeForValue(message.token_time_msec()));
  }
  if (message.has_token_value()) {
    dict.Set("token_value", base::Base64Encode(message.token_value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ChromeUserPopulation_PageLoadToken>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const SafeBrowsingWebAppKey& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_start_url_origin()) {
    dict.Set("start_url_origin", (message.start_url_origin()));
  }
  if (message.has_id_or_start_path()) {
    dict.Set("id_or_start_path", (message.id_or_start_path()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<SafeBrowsingWebAppKey>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ImageFeatureEmbedding& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_embedding_model_version()) {
    dict.Set("embedding_model_version", (message.embedding_model_version()));
  }
  if (!message.embedding_value().empty()) {
    base::ListValue list;
    for (const auto& value : message.embedding_value()) {
      list.Append(static_cast<double>(value));
    }
    dict.Set("embedding_value", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ImageFeatureEmbedding>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LlamaTriggerRuleInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_llama_trigger_rule_id()) {
    dict.Set("llama_trigger_rule_id", (message.llama_trigger_rule_id()));
  }
  if (message.has_intelligent_scan()) {
    dict.Set("intelligent_scan", static_cast<bool>(message.intelligent_scan()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LlamaTriggerRuleInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LlamaForcedTriggerInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.llama_trigger_rule_infos().empty()) {
    base::ListValue list;
    for (const auto& value : message.llama_trigger_rule_infos()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("llama_trigger_rule_infos", std::move(list));
  }
  if (message.has_intelligent_scan()) {
    dict.Set("intelligent_scan", static_cast<bool>(message.intelligent_scan()));
  }
  if (message.has_trigger_url()) {
    dict.Set("trigger_url", (message.trigger_url()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LlamaForcedTriggerInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const IntelligentScanInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_brand()) {
    dict.Set("brand", (message.brand()));
  }
  if (message.has_intent()) {
    dict.Set("intent", (message.intent()));
  }
  if (message.has_no_info_reason()) {
    dict.Set("no_info_reason", ::safe_browsing::IntelligentScanInfo_NoInfoReason_Name(message.no_info_reason()));
  }
  if (message.has_model_version()) {
    dict.Set("model_version", ::proto_extras::ToNumericTypeForValue(message.model_version()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<IntelligentScanInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientPhishingRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_obsolete_hash_prefix()) {
    dict.Set("obsolete_hash_prefix", base::Base64Encode(message.obsolete_hash_prefix()));
  }
  if (message.has_client_score()) {
    dict.Set("client_score", static_cast<double>(message.client_score()));
  }
  if (message.has_is_phishing()) {
    dict.Set("is_phishing", static_cast<bool>(message.is_phishing()));
  }
  if (!message.feature_map().empty()) {
    base::ListValue list;
    for (const auto& value : message.feature_map()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("feature_map", std::move(list));
  }
  if (message.has_dom_model_version()) {
    dict.Set("dom_model_version", (message.dom_model_version()));
  }
  if (message.has_model_version()) {
    dict.Set("model_version", (message.model_version()));
  }
  if (!message.non_model_feature_map().empty()) {
    base::ListValue list;
    for (const auto& value : message.non_model_feature_map()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("non_model_feature_map", std::move(list));
  }
  if (message.has_obsolete_referrer_url()) {
    dict.Set("obsolete_referrer_url", (message.obsolete_referrer_url()));
  }
  if (!message.shingle_hashes().empty()) {
    base::ListValue list;
    for (const auto& value : message.shingle_hashes()) {
      list.Append(::proto_extras::ToNumericTypeForValue(value));
    }
    dict.Set("shingle_hashes", std::move(list));
  }
  if (message.has_deprecated_model_filename()) {
    dict.Set("deprecated_model_filename", (message.deprecated_model_filename()));
  }
  if (message.has_population()) {
    dict.Set("population", ::safe_browsing::Serialize(message.population()));
  }
  if (message.has_is_dom_match()) {
    dict.Set("is_dom_match", static_cast<bool>(message.is_dom_match()));
  }
  if (!message.referrer_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.referrer_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("referrer_chain", std::move(list));
  }
  if (message.has_tflite_model_version()) {
    dict.Set("tflite_model_version", (message.tflite_model_version()));
  }
  if (!message.tflite_model_scores().empty()) {
    base::ListValue list;
    for (const auto& value : message.tflite_model_scores()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("tflite_model_scores", std::move(list));
  }
  if (message.has_is_tflite_match()) {
    dict.Set("is_tflite_match", static_cast<bool>(message.is_tflite_match()));
  }
  if (message.has_visual_features()) {
    dict.Set("visual_features", ::safe_browsing::Serialize(message.visual_features()));
  }
  if (message.has_client_side_detection_type()) {
    dict.Set("client_side_detection_type", ::safe_browsing::ClientSideDetectionType_Name(message.client_side_detection_type()));
  }
  if (message.has_image_feature_embedding()) {
    dict.Set("image_feature_embedding", ::safe_browsing::Serialize(message.image_feature_embedding()));
  }
  if (message.has_report_type()) {
    dict.Set("report_type", ::safe_browsing::ClientPhishingRequest_ReportType_Name(message.report_type()));
  }
  if (message.has_llama_forced_trigger_info()) {
    dict.Set("llama_forced_trigger_info", ::safe_browsing::Serialize(message.llama_forced_trigger_info()));
  }
  if (message.has_intelligent_scan_info()) {
    dict.Set("intelligent_scan_info", ::safe_browsing::Serialize(message.intelligent_scan_info()));
  }
  if (message.has_clipboard_extracted_data()) {
    dict.Set("clipboard_extracted_data", ::safe_browsing::Serialize(message.clipboard_extracted_data()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientPhishingRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientPhishingRequest_Feature& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_value()) {
    dict.Set("value", static_cast<double>(message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientPhishingRequest_Feature>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientPhishingRequest_CategoryScore& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_label()) {
    dict.Set("label", (message.label()));
  }
  if (message.has_value()) {
    dict.Set("value", static_cast<double>(message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientPhishingRequest_CategoryScore>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClipboardExtractedData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.suspicious_tokens().empty()) {
    base::ListValue list;
    for (const auto& value : message.suspicious_tokens()) {
      list.Append((value));
    }
    dict.Set("suspicious_tokens", std::move(list));
  }
  if (message.has_is_first_token_suspicious()) {
    dict.Set("is_first_token_suspicious", static_cast<bool>(message.is_first_token_suspicious()));
  }
  if (message.has_is_last_token_suspicious()) {
    dict.Set("is_last_token_suspicious", static_cast<bool>(message.is_last_token_suspicious()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClipboardExtractedData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientPhishingResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_phishy()) {
    dict.Set("phishy", static_cast<bool>(message.phishy()));
  }
  if (!message.obsolete_allowlist_expression().empty()) {
    base::ListValue list;
    for (const auto& value : message.obsolete_allowlist_expression()) {
      list.Append((value));
    }
    dict.Set("obsolete_allowlist_expression", std::move(list));
  }
  if (message.has_intelligent_scan_verdict()) {
    dict.Set("intelligent_scan_verdict", ::safe_browsing::IntelligentScanVerdict_Name(message.intelligent_scan_verdict()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientPhishingResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ReferringAppInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_referring_app_source()) {
    dict.Set("referring_app_source", ::safe_browsing::ReferringAppInfo_ReferringAppSource_Name(message.referring_app_source()));
  }
  if (message.has_referring_app_name()) {
    dict.Set("referring_app_name", (message.referring_app_name()));
  }
  if (message.has_referring_webapk()) {
    dict.Set("referring_webapk", ::safe_browsing::Serialize(message.referring_webapk()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ReferringAppInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_page_url()) {
    dict.Set("page_url", (message.page_url()));
  }
  if (message.has_trigger_type()) {
    dict.Set("trigger_type", ::safe_browsing::LoginReputationClientRequest_TriggerType_Name(message.trigger_type()));
  }
  if (!message.frames().empty()) {
    base::ListValue list;
    for (const auto& value : message.frames()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("frames", std::move(list));
  }
  if (message.has_password_reuse_event()) {
    dict.Set("password_reuse_event", ::safe_browsing::Serialize(message.password_reuse_event()));
  }
  if (message.has_stored_verdict_cnt()) {
    dict.Set("stored_verdict_cnt", (message.stored_verdict_cnt()));
  }
  if (message.has_population()) {
    dict.Set("population", ::safe_browsing::Serialize(message.population()));
  }
  if (message.has_clicked_through_interstitial()) {
    dict.Set("clicked_through_interstitial", static_cast<bool>(message.clicked_through_interstitial()));
  }
  if (message.has_content_type()) {
    dict.Set("content_type", (message.content_type()));
  }
  if (message.has_content_area_height()) {
    dict.Set("content_area_height", (message.content_area_height()));
  }
  if (message.has_content_area_width()) {
    dict.Set("content_area_width", (message.content_area_width()));
  }
  if (message.has_visual_features()) {
    dict.Set("visual_features", ::safe_browsing::Serialize(message.visual_features()));
  }
  if (message.has_dom_features()) {
    dict.Set("dom_features", ::safe_browsing::Serialize(message.dom_features()));
  }
  if (message.has_report_type()) {
    dict.Set("report_type", ::safe_browsing::LoginReputationClientRequest_ReportType_Name(message.report_type()));
  }
  if (message.has_url_display_experiment()) {
    dict.Set("url_display_experiment", ::safe_browsing::Serialize(message.url_display_experiment()));
  }
  if (message.has_referring_app_info()) {
    dict.Set("referring_app_info", ::safe_browsing::Serialize(message.referring_app_info()));
  }
  if (message.has_csd_debugging_metadata()) {
    dict.Set("csd_debugging_metadata", ::safe_browsing::Serialize(message.csd_debugging_metadata()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_Frame& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_frame_index()) {
    dict.Set("frame_index", (message.frame_index()));
  }
  if (message.has_parent_frame_index()) {
    dict.Set("parent_frame_index", (message.parent_frame_index()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_has_password_field()) {
    dict.Set("has_password_field", static_cast<bool>(message.has_password_field()));
  }
  if (!message.referrer_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.referrer_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("referrer_chain", std::move(list));
  }
  if (message.has_referrer_chain_options()) {
    dict.Set("referrer_chain_options", ::safe_browsing::Serialize(message.referrer_chain_options()));
  }
  if (!message.forms().empty()) {
    base::ListValue list;
    for (const auto& value : message.forms()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("forms", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_Frame>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_Frame_Form& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_action_url()) {
    dict.Set("action_url", (message.action_url()));
  }
  if (message.has_has_password_field()) {
    dict.Set("has_password_field", static_cast<bool>(message.has_password_field()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_Frame_Form>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_PasswordReuseEvent& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.domains_matching_password().empty()) {
    base::ListValue list;
    for (const auto& value : message.domains_matching_password()) {
      list.Append((value));
    }
    dict.Set("domains_matching_password", std::move(list));
  }
  if (message.has_frame_id()) {
    dict.Set("frame_id", (message.frame_id()));
  }
  if (message.has_reused_password_type()) {
    dict.Set("reused_password_type", ::safe_browsing::LoginReputationClientRequest_PasswordReuseEvent_ReusedPasswordType_Name(message.reused_password_type()));
  }
  if (message.has_reused_password_account_type()) {
    dict.Set("reused_password_account_type", ::safe_browsing::Serialize(message.reused_password_account_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_PasswordReuseEvent>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_PasswordReuseEvent_ReusedPasswordAccountType& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_is_account_syncing()) {
    dict.Set("is_account_syncing", static_cast<bool>(message.is_account_syncing()));
  }
  if (message.has_account_type()) {
    dict.Set("account_type", ::safe_browsing::LoginReputationClientRequest_PasswordReuseEvent_ReusedPasswordAccountType_AccountType_Name(message.account_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_PasswordReuseEvent_ReusedPasswordAccountType>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_UrlDisplayExperiment& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_delayed_warnings_enabled()) {
    dict.Set("delayed_warnings_enabled", static_cast<bool>(message.delayed_warnings_enabled()));
  }
  if (message.has_delayed_warnings_mouse_clicks_enabled()) {
    dict.Set("delayed_warnings_mouse_clicks_enabled", static_cast<bool>(message.delayed_warnings_mouse_clicks_enabled()));
  }
  if (message.has_reveal_on_hover()) {
    dict.Set("reveal_on_hover", static_cast<bool>(message.reveal_on_hover()));
  }
  if (message.has_hide_on_interaction()) {
    dict.Set("hide_on_interaction", static_cast<bool>(message.hide_on_interaction()));
  }
  if (message.has_elide_to_registrable_domain()) {
    dict.Set("elide_to_registrable_domain", static_cast<bool>(message.elide_to_registrable_domain()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_UrlDisplayExperiment>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientRequest_DebuggingMetadata& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_csd_model_version()) {
    dict.Set("csd_model_version", (message.csd_model_version()));
  }
  if (message.has_preclassification_check_result()) {
    dict.Set("preclassification_check_result", ::safe_browsing::PreClassificationCheckResult_Name(message.preclassification_check_result()));
  }
  if (message.has_phishing_detector_result()) {
    dict.Set("phishing_detector_result", ::safe_browsing::PhishingDetectorResult_Name(message.phishing_detector_result()));
  }
  if (message.has_local_model_detects_phishing()) {
    dict.Set("local_model_detects_phishing", static_cast<bool>(message.local_model_detects_phishing()));
  }
  if (message.has_forced_request()) {
    dict.Set("forced_request", static_cast<bool>(message.forced_request()));
  }
  if (message.has_network_result()) {
    dict.Set("network_result", (message.network_result()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientRequest_DebuggingMetadata>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const LoginReputationClientResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_verdict_type()) {
    dict.Set("verdict_type", ::safe_browsing::LoginReputationClientResponse_VerdictType_Name(message.verdict_type()));
  }
  if (message.has_cache_duration_sec()) {
    dict.Set("cache_duration_sec", ::proto_extras::ToNumericTypeForValue(message.cache_duration_sec()));
  }
  if (message.has_cache_expression()) {
    dict.Set("cache_expression", (message.cache_expression()));
  }
  if (message.has_deprecated_cache_expression_exact_match()) {
    dict.Set("deprecated_cache_expression_exact_match", static_cast<bool>(message.deprecated_cache_expression_exact_match()));
  }
  if (message.has_verdict_token()) {
    dict.Set("verdict_token", base::Base64Encode(message.verdict_token()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<LoginReputationClientResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const VisualFeatures& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_image()) {
    dict.Set("image", ::safe_browsing::Serialize(message.image()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<VisualFeatures>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const VisualFeatures_BlurredImage& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_width()) {
    dict.Set("width", (message.width()));
  }
  if (message.has_height()) {
    dict.Set("height", (message.height()));
  }
  if (message.has_data()) {
    dict.Set("data", base::Base64Encode(message.data()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<VisualFeatures_BlurredImage>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const DomFeatures& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.feature_map().empty()) {
    base::ListValue list;
    for (const auto& value : message.feature_map()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("feature_map", std::move(list));
  }
  if (!message.shingle_hashes().empty()) {
    base::ListValue list;
    for (const auto& value : message.shingle_hashes()) {
      list.Append(::proto_extras::ToNumericTypeForValue(value));
    }
    dict.Set("shingle_hashes", std::move(list));
  }
  if (message.has_model_version()) {
    dict.Set("model_version", (message.model_version()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<DomFeatures>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const DomFeatures_Feature& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_value()) {
    dict.Set("value", static_cast<double>(message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<DomFeatures_Feature>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_digests()) {
    dict.Set("digests", ::safe_browsing::Serialize(message.digests()));
  }
  if (message.has_length()) {
    dict.Set("length", ::proto_extras::ToNumericTypeForValue(message.length()));
  }
  if (!message.resources().empty()) {
    base::ListValue list;
    for (const auto& value : message.resources()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("resources", std::move(list));
  }
  if (message.has_signature()) {
    dict.Set("signature", ::safe_browsing::Serialize(message.signature()));
  }
  if (message.has_user_initiated()) {
    dict.Set("user_initiated", static_cast<bool>(message.user_initiated()));
  }
  if (message.has_file_basename()) {
    dict.Set("file_basename", (message.file_basename()));
  }
  if (message.has_download_type()) {
    dict.Set("download_type", ::safe_browsing::ClientDownloadRequest_DownloadType_Name(message.download_type()));
  }
  if (message.has_locale()) {
    dict.Set("locale", (message.locale()));
  }
  if (message.has_image_headers()) {
    dict.Set("image_headers", ::safe_browsing::Serialize(message.image_headers()));
  }
  if (!message.archived_binary().empty()) {
    base::ListValue list;
    for (const auto& value : message.archived_binary()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("archived_binary", std::move(list));
  }
  if (message.has_population()) {
    dict.Set("population", ::safe_browsing::Serialize(message.population()));
  }
  if (message.has_deprecated_archive_valid()) {
    dict.Set("deprecated_archive_valid", static_cast<bool>(message.deprecated_archive_valid()));
  }
  if (message.has_skipped_url_allowlist()) {
    dict.Set("skipped_url_allowlist", static_cast<bool>(message.skipped_url_allowlist()));
  }
  if (message.has_skipped_certificate_allowlist()) {
    dict.Set("skipped_certificate_allowlist", static_cast<bool>(message.skipped_certificate_allowlist()));
  }
  if (!message.alternate_extensions().empty()) {
    base::ListValue list;
    for (const auto& value : message.alternate_extensions()) {
      list.Append((value));
    }
    dict.Set("alternate_extensions", std::move(list));
  }
  if (!message.referrer_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.referrer_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("referrer_chain", std::move(list));
  }
  if (message.has_referrer_chain_options()) {
    dict.Set("referrer_chain_options", ::safe_browsing::Serialize(message.referrer_chain_options()));
  }
  if (message.has_deprecated_download_attribution_finch_enabled()) {
    dict.Set("deprecated_download_attribution_finch_enabled", static_cast<bool>(message.deprecated_download_attribution_finch_enabled()));
  }
  if (message.has_udif_code_signature()) {
    dict.Set("udif_code_signature", base::Base64Encode(message.udif_code_signature()));
  }
  if (!message.detached_code_signature().empty()) {
    base::ListValue list;
    for (const auto& value : message.detached_code_signature()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("detached_code_signature", std::move(list));
  }
  if (message.has_request_ap_verdicts()) {
    dict.Set("request_ap_verdicts", static_cast<bool>(message.request_ap_verdicts()));
  }
  if (message.has_deprecated_archive_file_count()) {
    dict.Set("deprecated_archive_file_count", (message.deprecated_archive_file_count()));
  }
  if (message.has_deprecated_archive_directory_count()) {
    dict.Set("deprecated_archive_directory_count", (message.deprecated_archive_directory_count()));
  }
  if (message.has_archive_summary()) {
    dict.Set("archive_summary", ::safe_browsing::Serialize(message.archive_summary()));
  }
  if (message.has_tailored_info()) {
    dict.Set("tailored_info", ::safe_browsing::Serialize(message.tailored_info()));
  }
  if (message.has_previous_token()) {
    dict.Set("previous_token", base::Base64Encode(message.previous_token()));
  }
  if (message.has_referring_app_info()) {
    dict.Set("referring_app_info", ::safe_browsing::Serialize(message.referring_app_info()));
  }
  if (!message.download_visual_features().empty()) {
    base::ListValue list;
    for (const auto& value : message.download_visual_features()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("download_visual_features", std::move(list));
  }
  if (message.has_rate_limiting_key()) {
    dict.Set("rate_limiting_key", (message.rate_limiting_key()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_Digests& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_sha256()) {
    dict.Set("sha256", base::Base64Encode(message.sha256()));
  }
  if (message.has_sha1()) {
    dict.Set("sha1", base::Base64Encode(message.sha1()));
  }
  if (message.has_md5()) {
    dict.Set("md5", base::Base64Encode(message.md5()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_Digests>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_Resource& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ClientDownloadRequest_ResourceType_Name(message.type()));
  }
  if (message.has_remote_ip()) {
    dict.Set("remote_ip", base::Base64Encode(message.remote_ip()));
  }
  if (message.has_referrer()) {
    dict.Set("referrer", (message.referrer()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_Resource>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_CertificateChain& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.element().empty()) {
    base::ListValue list;
    for (const auto& value : message.element()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("element", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_CertificateChain>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_CertificateChain_Element& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_certificate()) {
    dict.Set("certificate", base::Base64Encode(message.certificate()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_CertificateChain_Element>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_ExtendedAttr& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_key()) {
    dict.Set("key", (message.key()));
  }
  if (message.has_value()) {
    dict.Set("value", base::Base64Encode(message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_ExtendedAttr>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_SignatureInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.certificate_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.certificate_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("certificate_chain", std::move(list));
  }
  if (message.has_trusted()) {
    dict.Set("trusted", static_cast<bool>(message.trusted()));
  }
  if (!message.signed_data().empty()) {
    base::ListValue list;
    for (const auto& value : message.signed_data()) {
      list.Append(base::Base64Encode(value));
    }
    dict.Set("signed_data", std::move(list));
  }
  if (!message.xattr().empty()) {
    base::ListValue list;
    for (const auto& value : message.xattr()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("xattr", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_SignatureInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_PEImageHeaders& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_dos_header()) {
    dict.Set("dos_header", base::Base64Encode(message.dos_header()));
  }
  if (message.has_file_header()) {
    dict.Set("file_header", base::Base64Encode(message.file_header()));
  }
  if (message.has_optional_headers32()) {
    dict.Set("optional_headers32", base::Base64Encode(message.optional_headers32()));
  }
  if (message.has_optional_headers64()) {
    dict.Set("optional_headers64", base::Base64Encode(message.optional_headers64()));
  }
  if (!message.section_header().empty()) {
    base::ListValue list;
    for (const auto& value : message.section_header()) {
      list.Append(base::Base64Encode(value));
    }
    dict.Set("section_header", std::move(list));
  }
  if (message.has_export_section_data()) {
    dict.Set("export_section_data", base::Base64Encode(message.export_section_data()));
  }
  if (!message.debug_data().empty()) {
    base::ListValue list;
    for (const auto& value : message.debug_data()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("debug_data", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_PEImageHeaders>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_PEImageHeaders_DebugData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_directory_entry()) {
    dict.Set("directory_entry", base::Base64Encode(message.directory_entry()));
  }
  if (message.has_raw_data()) {
    dict.Set("raw_data", base::Base64Encode(message.raw_data()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_PEImageHeaders_DebugData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_MachOHeaders& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_mach_header()) {
    dict.Set("mach_header", base::Base64Encode(message.mach_header()));
  }
  if (!message.load_commands().empty()) {
    base::ListValue list;
    for (const auto& value : message.load_commands()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("load_commands", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_MachOHeaders>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_MachOHeaders_LoadCommand& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_command_id()) {
    dict.Set("command_id", ::proto_extras::ToNumericTypeForValue(message.command_id()));
  }
  if (message.has_command()) {
    dict.Set("command", base::Base64Encode(message.command()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_MachOHeaders_LoadCommand>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_ImageHeaders& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_pe_headers()) {
    dict.Set("pe_headers", ::safe_browsing::Serialize(message.pe_headers()));
  }
  if (!message.mach_o_headers().empty()) {
    base::ListValue list;
    for (const auto& value : message.mach_o_headers()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("mach_o_headers", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_ImageHeaders>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_ArchivedBinary& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_file_path()) {
    dict.Set("file_path", (message.file_path()));
  }
  if (message.has_download_type()) {
    dict.Set("download_type", ::safe_browsing::ClientDownloadRequest_DownloadType_Name(message.download_type()));
  }
  if (message.has_digests()) {
    dict.Set("digests", ::safe_browsing::Serialize(message.digests()));
  }
  if (message.has_length()) {
    dict.Set("length", ::proto_extras::ToNumericTypeForValue(message.length()));
  }
  if (message.has_signature()) {
    dict.Set("signature", ::safe_browsing::Serialize(message.signature()));
  }
  if (message.has_image_headers()) {
    dict.Set("image_headers", ::safe_browsing::Serialize(message.image_headers()));
  }
  if (message.has_is_encrypted()) {
    dict.Set("is_encrypted", static_cast<bool>(message.is_encrypted()));
  }
  if (message.has_is_executable()) {
    dict.Set("is_executable", static_cast<bool>(message.is_executable()));
  }
  if (message.has_is_archive()) {
    dict.Set("is_archive", static_cast<bool>(message.is_archive()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_ArchivedBinary>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_DetachedCodeSignature& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_file_name()) {
    dict.Set("file_name", (message.file_name()));
  }
  if (message.has_contents()) {
    dict.Set("contents", base::Base64Encode(message.contents()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_DetachedCodeSignature>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_ArchiveSummary& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_parser_status()) {
    dict.Set("parser_status", ::safe_browsing::ClientDownloadRequest_ArchiveSummary_Status_Name(message.parser_status()));
  }
  if (message.has_file_count()) {
    dict.Set("file_count", (message.file_count()));
  }
  if (message.has_directory_count()) {
    dict.Set("directory_count", (message.directory_count()));
  }
  if (message.has_is_encrypted()) {
    dict.Set("is_encrypted", static_cast<bool>(message.is_encrypted()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_ArchiveSummary>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_TailoredInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_version()) {
    dict.Set("version", (message.version()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_TailoredInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadRequest_DownloadVisualFeatures& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_main_frame_url()) {
    dict.Set("main_frame_url", (message.main_frame_url()));
  }
  if (message.has_visual_features()) {
    dict.Set("visual_features", ::safe_browsing::Serialize(message.visual_features()));
  }
  if (message.has_referrer_chain_index()) {
    dict.Set("referrer_chain_index", (message.referrer_chain_index()));
  }
  if (message.has_related_page()) {
    dict.Set("related_page", ::safe_browsing::ClientDownloadRequest_DownloadVisualFeatures_PageType_Name(message.related_page()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadRequest_DownloadVisualFeatures>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ReferrerChainOptions& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_recent_navigations_to_collect()) {
    dict.Set("recent_navigations_to_collect", (message.recent_navigations_to_collect()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ReferrerChainOptions>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ReferrerChainEntry& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_main_frame_url()) {
    dict.Set("main_frame_url", (message.main_frame_url()));
  }
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ReferrerChainEntry_URLType_Name(message.type()));
  }
  if (!message.ip_addresses().empty()) {
    base::ListValue list;
    for (const auto& value : message.ip_addresses()) {
      list.Append((value));
    }
    dict.Set("ip_addresses", std::move(list));
  }
  if (message.has_referrer_url()) {
    dict.Set("referrer_url", (message.referrer_url()));
  }
  if (message.has_referrer_main_frame_url()) {
    dict.Set("referrer_main_frame_url", (message.referrer_main_frame_url()));
  }
  if (message.has_is_retargeting()) {
    dict.Set("is_retargeting", static_cast<bool>(message.is_retargeting()));
  }
  if (message.has_navigation_time_msec()) {
    dict.Set("navigation_time_msec", static_cast<double>(message.navigation_time_msec()));
  }
  if (!message.server_redirect_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.server_redirect_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("server_redirect_chain", std::move(list));
  }
  if (message.has_navigation_initiation()) {
    dict.Set("navigation_initiation", ::safe_browsing::ReferrerChainEntry_NavigationInitiation_Name(message.navigation_initiation()));
  }
  if (message.has_maybe_launched_by_external_application()) {
    dict.Set("maybe_launched_by_external_application", static_cast<bool>(message.maybe_launched_by_external_application()));
  }
  if (message.has_is_subframe_url_removed()) {
    dict.Set("is_subframe_url_removed", static_cast<bool>(message.is_subframe_url_removed()));
  }
  if (message.has_is_subframe_referrer_url_removed()) {
    dict.Set("is_subframe_referrer_url_removed", static_cast<bool>(message.is_subframe_referrer_url_removed()));
  }
  if (message.has_is_url_removed_by_policy()) {
    dict.Set("is_url_removed_by_policy", static_cast<bool>(message.is_url_removed_by_policy()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ReferrerChainEntry>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ReferrerChainEntry_ServerRedirect& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ReferrerChainEntry_ServerRedirect>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_verdict()) {
    dict.Set("verdict", ::safe_browsing::ClientDownloadResponse_Verdict_Name(message.verdict()));
  }
  if (message.has_more_info()) {
    dict.Set("more_info", ::safe_browsing::Serialize(message.more_info()));
  }
  if (message.has_token()) {
    dict.Set("token", base::Base64Encode(message.token()));
  }
  if (message.has_upload()) {
    dict.Set("upload", static_cast<bool>(message.upload()));
  }
  if (message.has_request_deep_scan()) {
    dict.Set("request_deep_scan", static_cast<bool>(message.request_deep_scan()));
  }
  if (message.has_tailored_verdict()) {
    dict.Set("tailored_verdict", ::safe_browsing::Serialize(message.tailored_verdict()));
  }
  if (message.has_is_suspicious_encrypted_archive()) {
    dict.Set("is_suspicious_encrypted_archive", static_cast<bool>(message.is_suspicious_encrypted_archive()));
  }
  if (!message.visual_features_requested().empty()) {
    base::ListValue list;
    for (const auto& value : message.visual_features_requested()) {
      list.Append((value));
    }
    dict.Set("visual_features_requested", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadResponse_MoreInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_description()) {
    dict.Set("description", (message.description()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadResponse_MoreInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadResponse_TailoredVerdict& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_tailored_verdict_type()) {
    dict.Set("tailored_verdict_type", ::safe_browsing::ClientDownloadResponse_TailoredVerdict_TailoredVerdictType_Name(message.tailored_verdict_type()));
  }
  if (!message.adjustments().empty()) {
    base::ListValue list;
    for (const auto& value : message.adjustments()) {
      list.Append(::safe_browsing::ClientDownloadResponse_TailoredVerdict_ExperimentalWarningAdjustment_Name(value));
    }
    dict.Set("adjustments", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadResponse_TailoredVerdict>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadReport& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_reason()) {
    dict.Set("reason", ::safe_browsing::ClientDownloadReport_Reason_Name(message.reason()));
  }
  if (message.has_download_request()) {
    dict.Set("download_request", ::safe_browsing::Serialize(message.download_request()));
  }
  if (message.has_user_information()) {
    dict.Set("user_information", ::safe_browsing::Serialize(message.user_information()));
  }
  if (message.has_comment()) {
    dict.Set("comment", base::Base64Encode(message.comment()));
  }
  if (message.has_download_response()) {
    dict.Set("download_response", ::safe_browsing::Serialize(message.download_response()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadReport>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientDownloadReport_UserInformation& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_email()) {
    dict.Set("email", (message.email()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientDownloadReport_UserInformation>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientUploadResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_status()) {
    dict.Set("status", ::safe_browsing::ClientUploadResponse_UploadStatus_Name(message.status()));
  }
  if (message.has_permalink()) {
    dict.Set("permalink", (message.permalink()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientUploadResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.incident().empty()) {
    base::ListValue list;
    for (const auto& value : message.incident()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("incident", std::move(list));
  }
  if (message.has_download()) {
    dict.Set("download", ::safe_browsing::Serialize(message.download()));
  }
  if (message.has_environment()) {
    dict.Set("environment", ::safe_browsing::Serialize(message.environment()));
  }
  if (message.has_population()) {
    dict.Set("population", ::safe_browsing::Serialize(message.population()));
  }
  if (message.has_extension_data()) {
    dict.Set("extension_data", ::safe_browsing::Serialize(message.extension_data()));
  }
  if (message.has_non_binary_download()) {
    dict.Set("non_binary_download", ::safe_browsing::Serialize(message.non_binary_download()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_incident_time_msec()) {
    dict.Set("incident_time_msec", ::proto_extras::ToNumericTypeForValue(message.incident_time_msec()));
  }
  if (message.has_tracked_preference()) {
    dict.Set("tracked_preference", ::safe_browsing::Serialize(message.tracked_preference()));
  }
  if (message.has_binary_integrity()) {
    dict.Set("binary_integrity", ::safe_browsing::Serialize(message.binary_integrity()));
  }
  if (message.has_resource_request()) {
    dict.Set("resource_request", ::safe_browsing::Serialize(message.resource_request()));
  }
  if (message.has_notification_import_script()) {
    dict.Set("notification_import_script", ::safe_browsing::Serialize(message.notification_import_script()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData_TrackedPreferenceIncident& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_path()) {
    dict.Set("path", (message.path()));
  }
  if (message.has_atomic_value()) {
    dict.Set("atomic_value", (message.atomic_value()));
  }
  if (!message.split_key().empty()) {
    base::ListValue list;
    for (const auto& value : message.split_key()) {
      list.Append((value));
    }
    dict.Set("split_key", std::move(list));
  }
  if (message.has_value_state()) {
    dict.Set("value_state", ::safe_browsing::ClientIncidentReport_IncidentData_TrackedPreferenceIncident_ValueState_Name(message.value_state()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData_TrackedPreferenceIncident>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData_BinaryIntegrityIncident& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_file_basename()) {
    dict.Set("file_basename", (message.file_basename()));
  }
  if (message.has_signature()) {
    dict.Set("signature", ::safe_browsing::Serialize(message.signature()));
  }
  if (message.has_image_headers()) {
    dict.Set("image_headers", ::safe_browsing::Serialize(message.image_headers()));
  }
  if (message.has_sec_error()) {
    dict.Set("sec_error", (message.sec_error()));
  }
  if (!message.contained_file().empty()) {
    base::ListValue list;
    for (const auto& value : message.contained_file()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("contained_file", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData_BinaryIntegrityIncident>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData_BinaryIntegrityIncident_ContainedFile& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_relative_path()) {
    dict.Set("relative_path", (message.relative_path()));
  }
  if (message.has_signature()) {
    dict.Set("signature", ::safe_browsing::Serialize(message.signature()));
  }
  if (message.has_image_headers()) {
    dict.Set("image_headers", ::safe_browsing::Serialize(message.image_headers()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData_BinaryIntegrityIncident_ContainedFile>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData_ResourceRequestIncident& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_digest()) {
    dict.Set("digest", base::Base64Encode(message.digest()));
  }
  if (message.has_origin()) {
    dict.Set("origin", (message.origin()));
  }
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ClientIncidentReport_IncidentData_ResourceRequestIncident_Type_Name(message.type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData_ResourceRequestIncident>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_IncidentData_ServiceWorkerRegistrationIncident& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_scope_url()) {
    dict.Set("scope_url", (message.scope_url()));
  }
  if (!message.import_script_url().empty()) {
    base::ListValue list;
    for (const auto& value : message.import_script_url()) {
      list.Append((value));
    }
    dict.Set("import_script_url", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_IncidentData_ServiceWorkerRegistrationIncident>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_DownloadDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_token()) {
    dict.Set("token", base::Base64Encode(message.token()));
  }
  if (message.has_download()) {
    dict.Set("download", ::safe_browsing::Serialize(message.download()));
  }
  if (message.has_download_time_msec()) {
    dict.Set("download_time_msec", ::proto_extras::ToNumericTypeForValue(message.download_time_msec()));
  }
  if (message.has_open_time_msec()) {
    dict.Set("open_time_msec", ::proto_extras::ToNumericTypeForValue(message.open_time_msec()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_DownloadDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_os()) {
    dict.Set("os", ::safe_browsing::Serialize(message.os()));
  }
  if (message.has_machine()) {
    dict.Set("machine", ::safe_browsing::Serialize(message.machine()));
  }
  if (message.has_process()) {
    dict.Set("process", ::safe_browsing::Serialize(message.process()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_OS& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_os_name()) {
    dict.Set("os_name", (message.os_name()));
  }
  if (message.has_os_version()) {
    dict.Set("os_version", (message.os_version()));
  }
  if (!message.registry_key().empty()) {
    base::ListValue list;
    for (const auto& value : message.registry_key()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("registry_key", std::move(list));
  }
  if (message.has_is_enrolled_to_domain()) {
    dict.Set("is_enrolled_to_domain", static_cast<bool>(message.is_enrolled_to_domain()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_OS>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_OS_RegistryValue& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_type()) {
    dict.Set("type", ::proto_extras::ToNumericTypeForValue(message.type()));
  }
  if (message.has_data()) {
    dict.Set("data", base::Base64Encode(message.data()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_OS_RegistryValue>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_OS_RegistryKey& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (!message.value().empty()) {
    base::ListValue list;
    for (const auto& value : message.value()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("value", std::move(list));
  }
  if (!message.key().empty()) {
    base::ListValue list;
    for (const auto& value : message.key()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("key", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_OS_RegistryKey>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Machine& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_cpu_architecture()) {
    dict.Set("cpu_architecture", (message.cpu_architecture()));
  }
  if (message.has_cpu_vendor()) {
    dict.Set("cpu_vendor", (message.cpu_vendor()));
  }
  if (message.has_cpuid()) {
    dict.Set("cpuid", ::proto_extras::ToNumericTypeForValue(message.cpuid()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Machine>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_version()) {
    dict.Set("version", (message.version()));
  }
  if (!message.obsolete_dlls().empty()) {
    base::ListValue list;
    for (const auto& value : message.obsolete_dlls()) {
      list.Append((value));
    }
    dict.Set("obsolete_dlls", std::move(list));
  }
  if (!message.patches().empty()) {
    base::ListValue list;
    for (const auto& value : message.patches()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("patches", std::move(list));
  }
  if (!message.network_providers().empty()) {
    base::ListValue list;
    for (const auto& value : message.network_providers()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("network_providers", std::move(list));
  }
  if (message.has_chrome_update_channel()) {
    dict.Set("chrome_update_channel", ::safe_browsing::ClientIncidentReport_EnvironmentData_Process_Channel_Name(message.chrome_update_channel()));
  }
  if (message.has_uptime_msec()) {
    dict.Set("uptime_msec", ::proto_extras::ToNumericTypeForValue(message.uptime_msec()));
  }
  if (message.has_metrics_consent()) {
    dict.Set("metrics_consent", static_cast<bool>(message.metrics_consent()));
  }
  if (message.has_obsolete_extended_consent()) {
    dict.Set("obsolete_extended_consent", static_cast<bool>(message.obsolete_extended_consent()));
  }
  if (!message.dll().empty()) {
    base::ListValue list;
    for (const auto& value : message.dll()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("dll", std::move(list));
  }
  if (!message.blocklisted_dll().empty()) {
    base::ListValue list;
    for (const auto& value : message.blocklisted_dll()) {
      list.Append((value));
    }
    dict.Set("blocklisted_dll", std::move(list));
  }
  if (!message.module_state().empty()) {
    base::ListValue list;
    for (const auto& value : message.module_state()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("module_state", std::move(list));
  }
  if (message.has_obsolete_field_trial_participant()) {
    dict.Set("obsolete_field_trial_participant", static_cast<bool>(message.obsolete_field_trial_participant()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process_Patch& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_function()) {
    dict.Set("function", (message.function()));
  }
  if (message.has_target_dll()) {
    dict.Set("target_dll", (message.target_dll()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process_Patch>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process_NetworkProvider& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process_NetworkProvider>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process_Dll& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_path()) {
    dict.Set("path", (message.path()));
  }
  if (message.has_base_address()) {
    dict.Set("base_address", ::proto_extras::ToNumericTypeForValue(message.base_address()));
  }
  if (message.has_length()) {
    dict.Set("length", ::proto_extras::ToNumericTypeForValue(message.length()));
  }
  if (!message.feature().empty()) {
    base::ListValue list;
    for (const auto& value : message.feature()) {
      list.Append(::safe_browsing::ClientIncidentReport_EnvironmentData_Process_Dll_Feature_Name(value));
    }
    dict.Set("feature", std::move(list));
  }
  if (message.has_image_headers()) {
    dict.Set("image_headers", ::safe_browsing::Serialize(message.image_headers()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process_Dll>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process_ModuleState& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_modified_state()) {
    dict.Set("modified_state", ::safe_browsing::ClientIncidentReport_EnvironmentData_Process_ModuleState_ModifiedState_Name(message.modified_state()));
  }
  if (!message.obsolete_modified_export().empty()) {
    base::ListValue list;
    for (const auto& value : message.obsolete_modified_export()) {
      list.Append((value));
    }
    dict.Set("obsolete_modified_export", std::move(list));
  }
  if (!message.modification().empty()) {
    base::ListValue list;
    for (const auto& value : message.modification()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("modification", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process_ModuleState>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_EnvironmentData_Process_ModuleState_Modification& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_file_offset()) {
    dict.Set("file_offset", ::proto_extras::ToNumericTypeForValue(message.file_offset()));
  }
  if (message.has_byte_count()) {
    dict.Set("byte_count", (message.byte_count()));
  }
  if (message.has_modified_bytes()) {
    dict.Set("modified_bytes", base::Base64Encode(message.modified_bytes()));
  }
  if (message.has_export_name()) {
    dict.Set("export_name", (message.export_name()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_EnvironmentData_Process_ModuleState_Modification>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_ExtensionData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_last_installed_extension()) {
    dict.Set("last_installed_extension", ::safe_browsing::Serialize(message.last_installed_extension()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_ExtensionData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_ExtensionData_ExtensionInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_id()) {
    dict.Set("id", (message.id()));
  }
  if (message.has_version()) {
    dict.Set("version", (message.version()));
  }
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_description()) {
    dict.Set("description", (message.description()));
  }
  if (message.has_state()) {
    dict.Set("state", ::safe_browsing::ClientIncidentReport_ExtensionData_ExtensionInfo_ExtensionState_Name(message.state()));
  }
  if (message.has_type()) {
    dict.Set("type", (message.type()));
  }
  if (message.has_update_url()) {
    dict.Set("update_url", (message.update_url()));
  }
  if (message.has_has_signature_validation()) {
    dict.Set("has_signature_validation", static_cast<bool>(message.has_signature_validation()));
  }
  if (message.has_signature_is_valid()) {
    dict.Set("signature_is_valid", static_cast<bool>(message.signature_is_valid()));
  }
  if (message.has_installed_by_custodian()) {
    dict.Set("installed_by_custodian", static_cast<bool>(message.installed_by_custodian()));
  }
  if (message.has_installed_by_default()) {
    dict.Set("installed_by_default", static_cast<bool>(message.installed_by_default()));
  }
  if (message.has_installed_by_oem()) {
    dict.Set("installed_by_oem", static_cast<bool>(message.installed_by_oem()));
  }
  if (message.has_from_bookmark()) {
    dict.Set("from_bookmark", static_cast<bool>(message.from_bookmark()));
  }
  if (message.has_from_webstore()) {
    dict.Set("from_webstore", static_cast<bool>(message.from_webstore()));
  }
  if (message.has_converted_from_user_script()) {
    dict.Set("converted_from_user_script", static_cast<bool>(message.converted_from_user_script()));
  }
  if (message.has_may_be_untrusted()) {
    dict.Set("may_be_untrusted", static_cast<bool>(message.may_be_untrusted()));
  }
  if (message.has_install_time_msec()) {
    dict.Set("install_time_msec", ::proto_extras::ToNumericTypeForValue(message.install_time_msec()));
  }
  if (message.has_manifest_location_type()) {
    dict.Set("manifest_location_type", (message.manifest_location_type()));
  }
  if (message.has_manifest()) {
    dict.Set("manifest", (message.manifest()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_ExtensionData_ExtensionInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentReport_NonBinaryDownloadDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_file_type()) {
    dict.Set("file_type", (message.file_type()));
  }
  if (message.has_url_spec_sha256()) {
    dict.Set("url_spec_sha256", base::Base64Encode(message.url_spec_sha256()));
  }
  if (message.has_host()) {
    dict.Set("host", (message.host()));
  }
  if (message.has_length()) {
    dict.Set("length", ::proto_extras::ToNumericTypeForValue(message.length()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentReport_NonBinaryDownloadDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_token()) {
    dict.Set("token", base::Base64Encode(message.token()));
  }
  if (message.has_download_requested()) {
    dict.Set("download_requested", static_cast<bool>(message.download_requested()));
  }
  if (!message.environment_requests().empty()) {
    base::ListValue list;
    for (const auto& value : message.environment_requests()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("environment_requests", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientIncidentResponse_EnvironmentRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_dll_index()) {
    dict.Set("dll_index", (message.dll_index()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientIncidentResponse_EnvironmentRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const DownloadMetadata& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_download_id()) {
    dict.Set("download_id", ::proto_extras::ToNumericTypeForValue(message.download_id()));
  }
  if (message.has_download()) {
    dict.Set("download", ::safe_browsing::Serialize(message.download()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<DownloadMetadata>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ClientSafeBrowsingReportRequest_ReportType_Name(message.type()));
  }
  if (message.has_download_verdict()) {
    dict.Set("download_verdict", ::safe_browsing::ClientDownloadResponse_Verdict_Name(message.download_verdict()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_page_url()) {
    dict.Set("page_url", (message.page_url()));
  }
  if (message.has_referrer_url()) {
    dict.Set("referrer_url", (message.referrer_url()));
  }
  if (!message.resources().empty()) {
    base::ListValue list;
    for (const auto& value : message.resources()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("resources", std::move(list));
  }
  if (!message.dom().empty()) {
    base::ListValue list;
    for (const auto& value : message.dom()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("dom", std::move(list));
  }
  if (message.has_complete()) {
    dict.Set("complete", static_cast<bool>(message.complete()));
  }
  if (!message.client_asn().empty()) {
    base::ListValue list;
    for (const auto& value : message.client_asn()) {
      list.Append((value));
    }
    dict.Set("client_asn", std::move(list));
  }
  if (message.has_client_country()) {
    dict.Set("client_country", (message.client_country()));
  }
  if (message.has_did_proceed()) {
    dict.Set("did_proceed", static_cast<bool>(message.did_proceed()));
  }
  if (message.has_repeat_visit()) {
    dict.Set("repeat_visit", static_cast<bool>(message.repeat_visit()));
  }
  if (message.has_token()) {
    dict.Set("token", base::Base64Encode(message.token()));
  }
  if (message.has_client_properties()) {
    dict.Set("client_properties", ::safe_browsing::Serialize(message.client_properties()));
  }
  if (message.has_show_download_in_folder()) {
    dict.Set("show_download_in_folder", static_cast<bool>(message.show_download_in_folder()));
  }
  if (!message.referrer_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.referrer_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("referrer_chain", std::move(list));
  }
  if (message.has_download_item_info()) {
    dict.Set("download_item_info", ::safe_browsing::Serialize(message.download_item_info()));
  }
  if (message.has_safety_net_id()) {
    dict.Set("safety_net_id", (message.safety_net_id()));
  }
  if (message.has_population()) {
    dict.Set("population", ::safe_browsing::Serialize(message.population()));
  }
  if (!message.download_warning_actions().empty()) {
    base::ListValue list;
    for (const auto& value : message.download_warning_actions()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("download_warning_actions", std::move(list));
  }
  if (message.has_hash_real_time_experiment_details()) {
    dict.Set("hash_real_time_experiment_details", ::safe_browsing::Serialize(message.hash_real_time_experiment_details()));
  }
  if (message.has_url_request_destination()) {
    dict.Set("url_request_destination", ::safe_browsing::ClientSafeBrowsingReportRequest_UrlRequestDestination_Name(message.url_request_destination()));
  }
  if (!message.interstitial_interactions().empty()) {
    base::ListValue list;
    for (const auto& value : message.interstitial_interactions()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("interstitial_interactions", std::move(list));
  }
  if (!message.phishy_site_interactions().empty()) {
    base::ListValue list;
    for (const auto& value : message.phishy_site_interactions()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("phishy_site_interactions", std::move(list));
  }
  if (message.has_warning_shown_timestamp_msec()) {
    dict.Set("warning_shown_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.warning_shown_timestamp_msec()));
  }
  if (message.has_warning_shown_info()) {
    dict.Set("warning_shown_info", ::safe_browsing::Serialize(message.warning_shown_info()));
  }
  if (message.has_permission_prompt_info()) {
    dict.Set("permission_prompt_info", ::safe_browsing::Serialize(message.permission_prompt_info()));
  }
  if (message.has_locale()) {
    dict.Set("locale", (message.locale()));
  }
  if (message.has_url_real_time_and_hash_real_time_discrepancy_info()) {
    dict.Set("url_real_time_and_hash_real_time_discrepancy_info", ::safe_browsing::Serialize(message.url_real_time_and_hash_real_time_discrepancy_info()));
  }
  if (!message.service_worker_behaviors().empty()) {
    base::ListValue list;
    for (const auto& value : message.service_worker_behaviors()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("service_worker_behaviors", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HTTPHeader& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", base::Base64Encode(message.name()));
  }
  if (message.has_value()) {
    dict.Set("value", base::Base64Encode(message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HTTPHeader>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HTTPRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_firstline()) {
    dict.Set("firstline", ::safe_browsing::Serialize(message.firstline()));
  }
  if (!message.headers().empty()) {
    base::ListValue list;
    for (const auto& value : message.headers()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("headers", std::move(list));
  }
  if (message.has_body()) {
    dict.Set("body", base::Base64Encode(message.body()));
  }
  if (message.has_bodydigest()) {
    dict.Set("bodydigest", base::Base64Encode(message.bodydigest()));
  }
  if (message.has_bodylength()) {
    dict.Set("bodylength", (message.bodylength()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HTTPRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HTTPRequest_FirstLine& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_verb()) {
    dict.Set("verb", base::Base64Encode(message.verb()));
  }
  if (message.has_uri()) {
    dict.Set("uri", base::Base64Encode(message.uri()));
  }
  if (message.has_version()) {
    dict.Set("version", base::Base64Encode(message.version()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HTTPRequest_FirstLine>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HTTPResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_firstline()) {
    dict.Set("firstline", ::safe_browsing::Serialize(message.firstline()));
  }
  if (!message.headers().empty()) {
    base::ListValue list;
    for (const auto& value : message.headers()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("headers", std::move(list));
  }
  if (message.has_body()) {
    dict.Set("body", base::Base64Encode(message.body()));
  }
  if (message.has_bodydigest()) {
    dict.Set("bodydigest", base::Base64Encode(message.bodydigest()));
  }
  if (message.has_bodylength()) {
    dict.Set("bodylength", (message.bodylength()));
  }
  if (message.has_remote_ip()) {
    dict.Set("remote_ip", base::Base64Encode(message.remote_ip()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HTTPResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HTTPResponse_FirstLine& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_code()) {
    dict.Set("code", (message.code()));
  }
  if (message.has_message()) {
    dict.Set("message", base::Base64Encode(message.message()));
  }
  if (message.has_version()) {
    dict.Set("version", base::Base64Encode(message.version()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HTTPResponse_FirstLine>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_Resource& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_id()) {
    dict.Set("id", (message.id()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_request()) {
    dict.Set("request", ::safe_browsing::Serialize(message.request()));
  }
  if (message.has_response()) {
    dict.Set("response", ::safe_browsing::Serialize(message.response()));
  }
  if (message.has_parent_id()) {
    dict.Set("parent_id", (message.parent_id()));
  }
  if (!message.child_ids().empty()) {
    base::ListValue list;
    for (const auto& value : message.child_ids()) {
      list.Append((value));
    }
    dict.Set("child_ids", std::move(list));
  }
  if (message.has_tag_name()) {
    dict.Set("tag_name", (message.tag_name()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_Resource>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_SafeBrowsingClientProperties& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_client_version()) {
    dict.Set("client_version", (message.client_version()));
  }
  if (message.has_google_play_services_version()) {
    dict.Set("google_play_services_version", ::proto_extras::ToNumericTypeForValue(message.google_play_services_version()));
  }
  if (message.has_is_instant_apps()) {
    dict.Set("is_instant_apps", static_cast<bool>(message.is_instant_apps()));
  }
  if (message.has_url_api_type()) {
    dict.Set("url_api_type", ::safe_browsing::ClientSafeBrowsingReportRequest_SafeBrowsingUrlApiType_Name(message.url_api_type()));
  }
  if (message.has_is_async_check()) {
    dict.Set("is_async_check", static_cast<bool>(message.is_async_check()));
  }
  if (message.has_app_verification_enabled()) {
    dict.Set("app_verification_enabled", static_cast<bool>(message.app_verification_enabled()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_SafeBrowsingClientProperties>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_DownloadItemInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_digests()) {
    dict.Set("digests", ::safe_browsing::Serialize(message.digests()));
  }
  if (message.has_length()) {
    dict.Set("length", ::proto_extras::ToNumericTypeForValue(message.length()));
  }
  if (message.has_file_basename()) {
    dict.Set("file_basename", (message.file_basename()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_DownloadItemInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_DownloadItemInfo_Digests& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_sha256()) {
    dict.Set("sha256", base::Base64Encode(message.sha256()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_DownloadItemInfo_Digests>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_DownloadWarningAction& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_surface()) {
    dict.Set("surface", ::safe_browsing::ClientSafeBrowsingReportRequest_DownloadWarningAction_Surface_Name(message.surface()));
  }
  if (message.has_action()) {
    dict.Set("action", ::safe_browsing::ClientSafeBrowsingReportRequest_DownloadWarningAction_Action_Name(message.action()));
  }
  if (message.has_is_terminal_action()) {
    dict.Set("is_terminal_action", static_cast<bool>(message.is_terminal_action()));
  }
  if (message.has_interval_msec()) {
    dict.Set("interval_msec", ::proto_extras::ToNumericTypeForValue(message.interval_msec()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_DownloadWarningAction>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_hash_database_threat_type()) {
    dict.Set("hash_database_threat_type", ::safe_browsing::ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails_ExperimentThreatType_Name(message.hash_database_threat_type()));
  }
  if (message.has_url_realtime_details()) {
    dict.Set("url_realtime_details", ::safe_browsing::Serialize(message.url_realtime_details()));
  }
  if (message.has_hash_realtime_details()) {
    dict.Set("hash_realtime_details", ::safe_browsing::Serialize(message.hash_realtime_details()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails_RealTimeDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_threat_type()) {
    dict.Set("threat_type", ::safe_browsing::ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails_ExperimentThreatType_Name(message.threat_type()));
  }
  if (message.has_matched_global_cache()) {
    dict.Set("matched_global_cache", static_cast<bool>(message.matched_global_cache()));
  }
  if (message.has_locally_cached_results_threat_type()) {
    dict.Set("locally_cached_results_threat_type", ::safe_browsing::ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails_ExperimentThreatType_Name(message.locally_cached_results_threat_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_HashRealTimeExperimentDetails_RealTimeDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_InterstitialInteraction& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_security_interstitial_interaction()) {
    dict.Set("security_interstitial_interaction", ::safe_browsing::ClientSafeBrowsingReportRequest_InterstitialInteraction_SecurityInterstitialInteraction_Name(message.security_interstitial_interaction()));
  }
  if (message.has_occurrence_count()) {
    dict.Set("occurrence_count", (message.occurrence_count()));
  }
  if (message.has_first_interaction_timestamp_msec()) {
    dict.Set("first_interaction_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.first_interaction_timestamp_msec()));
  }
  if (message.has_last_interaction_timestamp_msec()) {
    dict.Set("last_interaction_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.last_interaction_timestamp_msec()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_InterstitialInteraction>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_PhishySiteInteraction& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_phishy_site_interaction_type()) {
    dict.Set("phishy_site_interaction_type", ::safe_browsing::ClientSafeBrowsingReportRequest_PhishySiteInteraction_PhishySiteInteractionType_Name(message.phishy_site_interaction_type()));
  }
  if (message.has_occurrence_count()) {
    dict.Set("occurrence_count", (message.occurrence_count()));
  }
  if (message.has_first_interaction_timestamp_msec()) {
    dict.Set("first_interaction_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.first_interaction_timestamp_msec()));
  }
  if (message.has_last_interaction_timestamp_msec()) {
    dict.Set("last_interaction_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.last_interaction_timestamp_msec()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_PhishySiteInteraction>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_WarningShownInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_warning_type()) {
    dict.Set("warning_type", ::safe_browsing::ClientSafeBrowsingReportRequest_WarningShownInfo_WarningUXType_Name(message.warning_type()));
  }
  if (message.has_post_data()) {
    dict.Set("post_data", (message.post_data()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_WarningShownInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_PermissionPromptInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_origin()) {
    dict.Set("origin", (message.origin()));
  }
  if (message.has_display_duration_sec()) {
    dict.Set("display_duration_sec", ::proto_extras::ToNumericTypeForValue(message.display_duration_sec()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_PermissionPromptInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_UrlRealTimeAndHashRealTimeDiscrepancyInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_hash_realtime_threat_type()) {
    dict.Set("hash_realtime_threat_type", ::safe_browsing::ClientSafeBrowsingReportRequest_UrlRealTimeAndHashRealTimeDiscrepancyInfo_LookupThreatType_Name(message.hash_realtime_threat_type()));
  }
  if (message.has_url_realtime_threat_type()) {
    dict.Set("url_realtime_threat_type", ::safe_browsing::ClientSafeBrowsingReportRequest_UrlRealTimeAndHashRealTimeDiscrepancyInfo_LookupThreatType_Name(message.url_realtime_threat_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_UrlRealTimeAndHashRealTimeDiscrepancyInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ClientSafeBrowsingReportRequest_ServiceWorkerBehavior& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_scope_url()) {
    dict.Set("scope_url", (message.scope_url()));
  }
  if (!message.requested_urls().empty()) {
    base::ListValue list;
    for (const auto& value : message.requested_urls()) {
      list.Append((value));
    }
    dict.Set("requested_urls", std::move(list));
  }
  if (!message.import_script_urls().empty()) {
    base::ListValue list;
    for (const auto& value : message.import_script_urls()) {
      list.Append((value));
    }
    dict.Set("import_script_urls", std::move(list));
  }
  if (message.has_script_url()) {
    dict.Set("script_url", (message.script_url()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ClientSafeBrowsingReportRequest_ServiceWorkerBehavior>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const HTMLElement& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_id()) {
    dict.Set("id", (message.id()));
  }
  if (message.has_tag()) {
    dict.Set("tag", (message.tag()));
  }
  if (!message.child_ids().empty()) {
    base::ListValue list;
    for (const auto& value : message.child_ids()) {
      list.Append((value));
    }
    dict.Set("child_ids", std::move(list));
  }
  if (message.has_resource_id()) {
    dict.Set("resource_id", (message.resource_id()));
  }
  if (!message.attribute().empty()) {
    base::ListValue list;
    for (const auto& value : message.attribute()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("attribute", std::move(list));
  }
  if (message.has_inner_html()) {
    dict.Set("inner_html", base::Base64Encode(message.inner_html()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<HTMLElement>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const HTMLElement_Attribute& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_value()) {
    dict.Set("value", (message.value()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<HTMLElement_Attribute>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionWebStoreInstallRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.referrer_chain().empty()) {
    base::ListValue list;
    for (const auto& value : message.referrer_chain()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("referrer_chain", std::move(list));
  }
  if (message.has_referrer_chain_options()) {
    dict.Set("referrer_chain_options", ::safe_browsing::Serialize(message.referrer_chain_options()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionWebStoreInstallRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_creation_timestamp_msec()) {
    dict.Set("creation_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.creation_timestamp_msec()));
  }
  if (!message.reports().empty()) {
    base::ListValue list;
    for (const auto& value : message.reports()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("reports", std::move(list));
  }
  if (message.has_configuration_version()) {
    dict.Set("configuration_version", ::proto_extras::ToNumericTypeForValue(message.configuration_version()));
  }
  if (message.has_developer_mode_enabled()) {
    dict.Set("developer_mode_enabled", static_cast<bool>(message.developer_mode_enabled()));
  }
  if (message.has_management_authority_trustworthiness()) {
    dict.Set("management_authority_trustworthiness", ::safe_browsing::ExtensionTelemetryReportRequest_ManagementAuthorityTrustworthiness_Name(message.management_authority_trustworthiness()));
  }
  if (message.has_management_authority()) {
    dict.Set("management_authority", ::safe_browsing::ExtensionTelemetryReportRequest_ManagementAuthority_Name(message.management_authority()));
  }
  if (message.has_search_hijacking_signal()) {
    dict.Set("search_hijacking_signal", ::safe_browsing::Serialize(message.search_hijacking_signal()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_ExtensionInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_id()) {
    dict.Set("id", (message.id()));
  }
  if (message.has_version()) {
    dict.Set("version", (message.version()));
  }
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_install_timestamp_msec()) {
    dict.Set("install_timestamp_msec", ::proto_extras::ToNumericTypeForValue(message.install_timestamp_msec()));
  }
  if (message.has_is_default_installed()) {
    dict.Set("is_default_installed", static_cast<bool>(message.is_default_installed()));
  }
  if (message.has_is_oem_installed()) {
    dict.Set("is_oem_installed", static_cast<bool>(message.is_oem_installed()));
  }
  if (message.has_is_from_store()) {
    dict.Set("is_from_store", static_cast<bool>(message.is_from_store()));
  }
  if (message.has_updates_from_store()) {
    dict.Set("updates_from_store", static_cast<bool>(message.updates_from_store()));
  }
  if (message.has_is_converted_from_user_script()) {
    dict.Set("is_converted_from_user_script", static_cast<bool>(message.is_converted_from_user_script()));
  }
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ExtensionTelemetryReportRequest_ExtensionInfo_Type_Name(message.type()));
  }
  if (message.has_install_location()) {
    dict.Set("install_location", ::safe_browsing::ExtensionTelemetryReportRequest_ExtensionInfo_InstallLocation_Name(message.install_location()));
  }
  if (message.has_blocklist_state()) {
    dict.Set("blocklist_state", ::safe_browsing::ExtensionTelemetryReportRequest_ExtensionInfo_BlocklistState_Name(message.blocklist_state()));
  }
  if (message.has_disable_reasons()) {
    dict.Set("disable_reasons", ::proto_extras::ToNumericTypeForValue(message.disable_reasons()));
  }
  if (message.has_manifest_json()) {
    dict.Set("manifest_json", (message.manifest_json()));
  }
  if (!message.file_infos().empty()) {
    base::ListValue list;
    for (const auto& value : message.file_infos()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("file_infos", std::move(list));
  }
  if (message.has_telemetry_blocklist_state()) {
    dict.Set("telemetry_blocklist_state", ::safe_browsing::ExtensionTelemetryReportRequest_ExtensionInfo_BlocklistState_Name(message.telemetry_blocklist_state()));
  }
  if (message.has_installation_policy()) {
    dict.Set("installation_policy", ::safe_browsing::ExtensionTelemetryReportRequest_ExtensionInfo_InstallationPolicy_Name(message.installation_policy()));
  }
  if (!message.disable_reasons_list().empty()) {
    base::ListValue list;
    for (const auto& value : message.disable_reasons_list()) {
      list.Append(::proto_extras::ToNumericTypeForValue(value));
    }
    dict.Set("disable_reasons_list", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_ExtensionInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_ExtensionInfo_FileInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_hash()) {
    dict.Set("hash", base::Base64Encode(message.hash()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_ExtensionInfo_FileInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_tabs_execute_script_info()) {
    dict.Set("tabs_execute_script_info", ::safe_browsing::Serialize(message.tabs_execute_script_info()));
  }
  if (message.has_remote_host_contacted_info()) {
    dict.Set("remote_host_contacted_info", ::safe_browsing::Serialize(message.remote_host_contacted_info()));
  }
  if (message.has_cookies_get_all_info()) {
    dict.Set("cookies_get_all_info", ::safe_browsing::Serialize(message.cookies_get_all_info()));
  }
  if (message.has_cookies_get_info()) {
    dict.Set("cookies_get_info", ::safe_browsing::Serialize(message.cookies_get_info()));
  }
  if (message.has_potential_password_theft_info()) {
    dict.Set("potential_password_theft_info", ::safe_browsing::Serialize(message.potential_password_theft_info()));
  }
  if (message.has_declarative_net_request_info()) {
    dict.Set("declarative_net_request_info", ::safe_browsing::Serialize(message.declarative_net_request_info()));
  }
  if (message.has_tabs_api_info()) {
    dict.Set("tabs_api_info", ::safe_browsing::Serialize(message.tabs_api_info()));
  }
  if (message.has_declarative_net_request_action_info()) {
    dict.Set("declarative_net_request_action_info", ::safe_browsing::Serialize(message.declarative_net_request_action_info()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_JSCallStackFrame& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_function_name()) {
    dict.Set("function_name", (message.function_name()));
  }
  if (message.has_script_name()) {
    dict.Set("script_name", (message.script_name()));
  }
  if (message.has_line()) {
    dict.Set("line", ::proto_extras::ToNumericTypeForValue(message.line()));
  }
  if (message.has_column()) {
    dict.Set("column", ::proto_extras::ToNumericTypeForValue(message.column()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_JSCallStackFrame>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_JSCallStack& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.frames().empty()) {
    base::ListValue list;
    for (const auto& value : message.frames()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("frames", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_JSCallStack>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_TabsExecuteScriptInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.scripts().empty()) {
    base::ListValue list;
    for (const auto& value : message.scripts()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("scripts", std::move(list));
  }
  if (message.has_max_exceeded_script_count()) {
    dict.Set("max_exceeded_script_count", ::proto_extras::ToNumericTypeForValue(message.max_exceeded_script_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_TabsExecuteScriptInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_TabsExecuteScriptInfo_ScriptInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_hash()) {
    dict.Set("hash", base::Base64Encode(message.hash()));
  }
  if (message.has_execution_count()) {
    dict.Set("execution_count", ::proto_extras::ToNumericTypeForValue(message.execution_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_TabsExecuteScriptInfo_ScriptInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.remote_host().empty()) {
    base::ListValue list;
    for (const auto& value : message.remote_host()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("remote_host", std::move(list));
  }
  if (message.has_collected_from_new_interception()) {
    dict.Set("collected_from_new_interception", static_cast<bool>(message.collected_from_new_interception()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo_RemoteHostInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_contact_count()) {
    dict.Set("contact_count", ::proto_extras::ToNumericTypeForValue(message.contact_count()));
  }
  if (message.has_connection_protocol()) {
    dict.Set("connection_protocol", ::safe_browsing::ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo_RemoteHostInfo_ProtocolType_Name(message.connection_protocol()));
  }
  if (message.has_contacted_by()) {
    dict.Set("contacted_by", ::safe_browsing::ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo_RemoteHostInfo_ContactInitiator_Name(message.contacted_by()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_RemoteHostContactedInfo_RemoteHostInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_CookiesGetAllInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.get_all_args_info().empty()) {
    base::ListValue list;
    for (const auto& value : message.get_all_args_info()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("get_all_args_info", std::move(list));
  }
  if (message.has_max_exceeded_args_count()) {
    dict.Set("max_exceeded_args_count", ::proto_extras::ToNumericTypeForValue(message.max_exceeded_args_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_CookiesGetAllInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_CookiesGetAllInfo_GetAllArgsInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_domain()) {
    dict.Set("domain", (message.domain()));
  }
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_path()) {
    dict.Set("path", (message.path()));
  }
  if (message.has_secure()) {
    dict.Set("secure", static_cast<bool>(message.secure()));
  }
  if (message.has_store_id()) {
    dict.Set("store_id", (message.store_id()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  if (message.has_is_session()) {
    dict.Set("is_session", static_cast<bool>(message.is_session()));
  }
  if (!message.js_callstacks().empty()) {
    base::ListValue list;
    for (const auto& value : message.js_callstacks()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("js_callstacks", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_CookiesGetAllInfo_GetAllArgsInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_CookiesGetInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.get_args_info().empty()) {
    base::ListValue list;
    for (const auto& value : message.get_args_info()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("get_args_info", std::move(list));
  }
  if (message.has_max_exceeded_args_count()) {
    dict.Set("max_exceeded_args_count", ::proto_extras::ToNumericTypeForValue(message.max_exceeded_args_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_CookiesGetInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_CookiesGetInfo_GetArgsInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_name()) {
    dict.Set("name", (message.name()));
  }
  if (message.has_url()) {
    dict.Set("url", (message.url()));
  }
  if (message.has_store_id()) {
    dict.Set("store_id", (message.store_id()));
  }
  if (!message.js_callstacks().empty()) {
    base::ListValue list;
    for (const auto& value : message.js_callstacks()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("js_callstacks", std::move(list));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_CookiesGetInfo_GetArgsInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.remote_hosts().empty()) {
    base::ListValue list;
    for (const auto& value : message.remote_hosts()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("remote_hosts", std::move(list));
  }
  if (!message.reused_password_infos().empty()) {
    base::ListValue list;
    for (const auto& value : message.reused_password_infos()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("reused_password_infos", std::move(list));
  }
  if (!message.remote_hosts_data().empty()) {
    base::ListValue list;
    for (const auto& value : message.remote_hosts_data()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("remote_hosts_data", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_RemoteHostInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_remote_host_url()) {
    dict.Set("remote_host_url", (message.remote_host_url()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_RemoteHostInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_PasswordReuseInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.domains_matching_password().empty()) {
    base::ListValue list;
    for (const auto& value : message.domains_matching_password()) {
      list.Append((value));
    }
    dict.Set("domains_matching_password", std::move(list));
  }
  if (message.has_is_chrome_signin_password()) {
    dict.Set("is_chrome_signin_password", static_cast<bool>(message.is_chrome_signin_password()));
  }
  if (message.has_reused_password_account_type()) {
    dict.Set("reused_password_account_type", ::safe_browsing::Serialize(message.reused_password_account_type()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_PasswordReuseInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_PasswordReuseInfo_ReusedPasswordAccountType& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_is_account_syncing()) {
    dict.Set("is_account_syncing", static_cast<bool>(message.is_account_syncing()));
  }
  if (message.has_account_type()) {
    dict.Set("account_type", ::safe_browsing::ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_PasswordReuseInfo_ReusedPasswordAccountType_AccountType_Name(message.account_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_PasswordReuseInfo_ReusedPasswordAccountType>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_RemoteHostData& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_remote_host_url()) {
    dict.Set("remote_host_url", (message.remote_host_url()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_PotentialPasswordTheftInfo_RemoteHostData>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.rules().empty()) {
    base::ListValue list;
    for (const auto& value : message.rules()) {
      list.Append((value));
    }
    dict.Set("rules", std::move(list));
  }
  if (message.has_max_exceeded_rules_count()) {
    dict.Set("max_exceeded_rules_count", ::proto_extras::ToNumericTypeForValue(message.max_exceeded_rules_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_TabsApiInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.call_details().empty()) {
    base::ListValue list;
    for (const auto& value : message.call_details()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("call_details", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_TabsApiInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_TabsApiInfo_CallDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_method()) {
    dict.Set("method", ::safe_browsing::ExtensionTelemetryReportRequest_SignalInfo_TabsApiInfo_ApiMethod_Name(message.method()));
  }
  if (message.has_new_url()) {
    dict.Set("new_url", (message.new_url()));
  }
  if (message.has_current_url()) {
    dict.Set("current_url", (message.current_url()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  if (!message.js_callstacks().empty()) {
    base::ListValue list;
    for (const auto& value : message.js_callstacks()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("js_callstacks", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_TabsApiInfo_CallDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestActionInfo& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (!message.action_details().empty()) {
    base::ListValue list;
    for (const auto& value : message.action_details()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("action_details", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestActionInfo>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestActionInfo_ActionDetails& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_type()) {
    dict.Set("type", ::safe_browsing::ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestActionInfo_ActionType_Name(message.type()));
  }
  if (message.has_request_url()) {
    dict.Set("request_url", (message.request_url()));
  }
  if (message.has_redirect_url()) {
    dict.Set("redirect_url", (message.redirect_url()));
  }
  if (message.has_count()) {
    dict.Set("count", ::proto_extras::ToNumericTypeForValue(message.count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SignalInfo_DeclarativeNetRequestActionInfo_ActionDetails>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_Report& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_extension()) {
    dict.Set("extension", ::safe_browsing::Serialize(message.extension()));
  }
  if (!message.signals().empty()) {
    base::ListValue list;
    for (const auto& value : message.signals()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("signals", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_Report>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportRequest_SearchHijackingSignal& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_detection_timestamp()) {
    dict.Set("detection_timestamp", ::proto_extras::ToNumericTypeForValue(message.detection_timestamp()));
  }
  if (message.has_omnibox_search_count()) {
    dict.Set("omnibox_search_count", ::proto_extras::ToNumericTypeForValue(message.omnibox_search_count()));
  }
  if (message.has_serp_landing_count()) {
    dict.Set("serp_landing_count", ::proto_extras::ToNumericTypeForValue(message.serp_landing_count()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportRequest_SearchHijackingSignal>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportResponse& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_configuration()) {
    dict.Set("configuration", ::safe_browsing::Serialize(message.configuration()));
  }
  if (!message.offstore_extension_verdicts().empty()) {
    base::ListValue list;
    for (const auto& value : message.offstore_extension_verdicts()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("offstore_extension_verdicts", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportResponse>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportResponse_ExtensionParameters& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_extension_id()) {
    dict.Set("extension_id", (message.extension_id()));
  }
  if (message.has_signal_enable_mask()) {
    dict.Set("signal_enable_mask", ::proto_extras::ToNumericTypeForValue(message.signal_enable_mask()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportResponse_ExtensionParameters>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportResponse_Configuration& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_configuration_version()) {
    dict.Set("configuration_version", ::proto_extras::ToNumericTypeForValue(message.configuration_version()));
  }
  if (message.has_reporting_interval_seconds()) {
    dict.Set("reporting_interval_seconds", ::proto_extras::ToNumericTypeForValue(message.reporting_interval_seconds()));
  }
  if (message.has_writes_per_interval()) {
    dict.Set("writes_per_interval", ::proto_extras::ToNumericTypeForValue(message.writes_per_interval()));
  }
  if (!message.extension_parameters().empty()) {
    base::ListValue list;
    for (const auto& value : message.extension_parameters()) {
      list.Append(::safe_browsing::Serialize(value));
    }
    dict.Set("extension_parameters", std::move(list));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportResponse_Configuration>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
base::Value Serialize(const ExtensionTelemetryReportResponse_OffstoreExtensionVerdict& message) {
  base::DictValue dict;
  ::proto_extras::SerializeUnknownFields(message, dict);
  if (message.has_extension_id()) {
    dict.Set("extension_id", (message.extension_id()));
  }
  if (message.has_verdict_type()) {
    dict.Set("verdict_type", ::safe_browsing::ExtensionTelemetryReportResponse_OffstoreExtensionVerdict_OffstoreExtensionVerdictType_Name(message.verdict_type()));
  }
  return base::Value(std::move(dict));
}
void MaybeSerialize(const std::optional<ExtensionTelemetryReportResponse_OffstoreExtensionVerdict>& opt_message,
                    std::string_view name,
                    base::DictValue& output_dictionary) {
  if (!opt_message.has_value()) {
    return;
  }
  output_dictionary.Set(name, Serialize(*opt_message));
}
}  // namespace safe_browsing

