// components/remote_cocoa/common/native_widget_ns_window.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/native_widget_ns_window.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-params-data.h"
#include "components/remote_cocoa/common/native_widget_ns_window.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-import-headers.h"
#include "components/remote_cocoa/common/native_widget_ns_window.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace remote_cocoa::mojom {
CreateWindowParams::CreateWindowParams()
    : window_class(),
      style_mask(),
      titlebar_appears_transparent(),
      window_title_hidden(),
      animation_enabled() {}

CreateWindowParams::CreateWindowParams(
    WindowClass window_class_in,
    uint64_t style_mask_in,
    bool titlebar_appears_transparent_in,
    bool window_title_hidden_in,
    bool animation_enabled_in)
    : window_class(std::move(window_class_in)),
      style_mask(std::move(style_mask_in)),
      titlebar_appears_transparent(std::move(titlebar_appears_transparent_in)),
      window_title_hidden(std::move(window_title_hidden_in)),
      animation_enabled(std::move(animation_enabled_in)) {}

CreateWindowParams::~CreateWindowParams() = default;
size_t CreateWindowParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->window_class);
  seed = mojo::internal::Hash(seed, this->style_mask);
  seed = mojo::internal::Hash(seed, this->titlebar_appears_transparent);
  seed = mojo::internal::Hash(seed, this->window_title_hidden);
  seed = mojo::internal::Hash(seed, this->animation_enabled);
  return seed;
}

void CreateWindowParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_class"), this->window_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WindowClass>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style_mask"), this->style_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "titlebar_appears_transparent"), this->titlebar_appears_transparent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_title_hidden"), this->window_title_hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animation_enabled"), this->animation_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateWindowParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NativeWidgetNSWindowInitParams::NativeWidgetNSWindowInitParams()
    : modal_type(),
      is_translucent(),
      has_window_server_shadow(),
      force_into_collection_cycle(),
      state_restoration_data(),
      is_tooltip() {}

NativeWidgetNSWindowInitParams::NativeWidgetNSWindowInitParams(
    ::ui::mojom::ModalType modal_type_in,
    bool is_translucent_in,
    bool has_window_server_shadow_in,
    bool force_into_collection_cycle_in,
    std::vector<uint8_t> state_restoration_data_in,
    bool is_tooltip_in)
    : modal_type(std::move(modal_type_in)),
      is_translucent(std::move(is_translucent_in)),
      has_window_server_shadow(std::move(has_window_server_shadow_in)),
      force_into_collection_cycle(std::move(force_into_collection_cycle_in)),
      state_restoration_data(std::move(state_restoration_data_in)),
      is_tooltip(std::move(is_tooltip_in)) {}

NativeWidgetNSWindowInitParams::~NativeWidgetNSWindowInitParams() = default;

void NativeWidgetNSWindowInitParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modal_type"), this->modal_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::ModalType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_translucent"), this->is_translucent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_window_server_shadow"), this->has_window_server_shadow,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_into_collection_cycle"), this->force_into_collection_cycle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_restoration_data"), this->state_restoration_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_tooltip"), this->is_tooltip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NativeWidgetNSWindowInitParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NativeWidgetNSWindow::IPCStableHashFunction NativeWidgetNSWindow::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NativeWidgetNSWindow>(message.name())) {
    case messages::NativeWidgetNSWindow::kCreateWindow: {
      return &NativeWidgetNSWindow::CreateWindow_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetParent: {
      return &NativeWidgetNSWindow::SetParent_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kCreateSelectFileDialog: {
      return &NativeWidgetNSWindow::CreateSelectFileDialog_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kShowCertificateViewer: {
      return &NativeWidgetNSWindow::ShowCertificateViewer_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kStackAbove: {
      return &NativeWidgetNSWindow::StackAbove_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kStackAtTop: {
      return &NativeWidgetNSWindow::StackAtTop_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kShowEmojiPanel: {
      return &NativeWidgetNSWindow::ShowEmojiPanel_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kInitWindow: {
      return &NativeWidgetNSWindow::InitWindow_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kInitCompositorView: {
      return &NativeWidgetNSWindow::InitCompositorView_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kCreateContentView: {
      return &NativeWidgetNSWindow::CreateContentView_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kDestroyContentView: {
      return &NativeWidgetNSWindow::DestroyContentView_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kCloseWindow: {
      return &NativeWidgetNSWindow::CloseWindow_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kCloseWindowNow: {
      return &NativeWidgetNSWindow::CloseWindowNow_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetInitialBounds: {
      return &NativeWidgetNSWindow::SetInitialBounds_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetBounds: {
      return &NativeWidgetNSWindow::SetBounds_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetSize: {
      return &NativeWidgetNSWindow::SetSize_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetSizeAndCenter: {
      return &NativeWidgetNSWindow::SetSizeAndCenter_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetVisibilityState: {
      return &NativeWidgetNSWindow::SetVisibilityState_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetAnimationEnabled: {
      return &NativeWidgetNSWindow::SetAnimationEnabled_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetTransitionsToAnimate: {
      return &NativeWidgetNSWindow::SetTransitionsToAnimate_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces: {
      return &NativeWidgetNSWindow::SetVisibleOnAllSpaces_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kEnterFullscreen: {
      return &NativeWidgetNSWindow::EnterFullscreen_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kExitFullscreen: {
      return &NativeWidgetNSWindow::ExitFullscreen_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces: {
      return &NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetMiniaturized: {
      return &NativeWidgetNSWindow::SetMiniaturized_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetZoomed: {
      return &NativeWidgetNSWindow::SetZoomed_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetSizeConstraints: {
      return &NativeWidgetNSWindow::SetSizeConstraints_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetOpacity: {
      return &NativeWidgetNSWindow::SetOpacity_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetWindowLevel: {
      return &NativeWidgetNSWindow::SetWindowLevel_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetActivationIndependence: {
      return &NativeWidgetNSWindow::SetActivationIndependence_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetAspectRatio: {
      return &NativeWidgetNSWindow::SetAspectRatio_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetCALayerParams: {
      return &NativeWidgetNSWindow::SetCALayerParams_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetWindowTitle: {
      return &NativeWidgetNSWindow::SetWindowTitle_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents: {
      return &NativeWidgetNSWindow::SetIgnoresMouseEvents_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kMakeFirstResponder: {
      return &NativeWidgetNSWindow::MakeFirstResponder_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSortSubviews: {
      return &NativeWidgetNSWindow::SortSubviews_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kClearTouchBar: {
      return &NativeWidgetNSWindow::ClearTouchBar_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kUpdateTooltip: {
      return &NativeWidgetNSWindow::UpdateTooltip_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kAcquireCapture: {
      return &NativeWidgetNSWindow::AcquireCapture_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kReleaseCapture: {
      return &NativeWidgetNSWindow::ReleaseCapture_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kRedispatchKeyEvent: {
      return &NativeWidgetNSWindow::RedispatchKeyEvent_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled: {
      return &NativeWidgetNSWindow::SetLocalEventMonitorEnabled_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetCursor: {
      return &NativeWidgetNSWindow::SetCursor_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen: {
      return &NativeWidgetNSWindow::EnableImmersiveFullscreen_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen: {
      return &NativeWidgetNSWindow::DisableImmersiveFullscreen_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kUpdateToolbarVisibility: {
      return &NativeWidgetNSWindow::UpdateToolbarVisibility_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged: {
      return &NativeWidgetNSWindow::OnTopContainerViewBoundsChanged_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock: {
      return &NativeWidgetNSWindow::ImmersiveFullscreenRevealLock_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock: {
      return &NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoBack: {
      return &NativeWidgetNSWindow::SetCanGoBack_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoForward: {
      return &NativeWidgetNSWindow::SetCanGoForward_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kDisplayContextMenu: {
      return &NativeWidgetNSWindow::DisplayContextMenu_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetAllowScreenshots: {
      return &NativeWidgetNSWindow::SetAllowScreenshots_Sym::IPCStableHash;
    }
    case messages::NativeWidgetNSWindow::kSetColorMode: {
      return &NativeWidgetNSWindow::SetColorMode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NativeWidgetNSWindow::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NativeWidgetNSWindow>(message.name())) {
      case messages::NativeWidgetNSWindow::kCreateWindow:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::CreateWindow";
      case messages::NativeWidgetNSWindow::kSetParent:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetParent";
      case messages::NativeWidgetNSWindow::kCreateSelectFileDialog:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::CreateSelectFileDialog";
      case messages::NativeWidgetNSWindow::kShowCertificateViewer:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ShowCertificateViewer";
      case messages::NativeWidgetNSWindow::kStackAbove:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::StackAbove";
      case messages::NativeWidgetNSWindow::kStackAtTop:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::StackAtTop";
      case messages::NativeWidgetNSWindow::kShowEmojiPanel:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ShowEmojiPanel";
      case messages::NativeWidgetNSWindow::kInitWindow:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::InitWindow";
      case messages::NativeWidgetNSWindow::kInitCompositorView:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::InitCompositorView";
      case messages::NativeWidgetNSWindow::kCreateContentView:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::CreateContentView";
      case messages::NativeWidgetNSWindow::kDestroyContentView:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::DestroyContentView";
      case messages::NativeWidgetNSWindow::kCloseWindow:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindow";
      case messages::NativeWidgetNSWindow::kCloseWindowNow:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindowNow";
      case messages::NativeWidgetNSWindow::kSetInitialBounds:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetInitialBounds";
      case messages::NativeWidgetNSWindow::kSetBounds:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetBounds";
      case messages::NativeWidgetNSWindow::kSetSize:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetSize";
      case messages::NativeWidgetNSWindow::kSetSizeAndCenter:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeAndCenter";
      case messages::NativeWidgetNSWindow::kSetVisibilityState:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibilityState";
      case messages::NativeWidgetNSWindow::kSetAnimationEnabled:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetAnimationEnabled";
      case messages::NativeWidgetNSWindow::kSetTransitionsToAnimate:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetTransitionsToAnimate";
      case messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibleOnAllSpaces";
      case messages::NativeWidgetNSWindow::kEnterFullscreen:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::EnterFullscreen";
      case messages::NativeWidgetNSWindow::kExitFullscreen:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ExitFullscreen";
      case messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces";
      case messages::NativeWidgetNSWindow::kSetMiniaturized:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetMiniaturized";
      case messages::NativeWidgetNSWindow::kSetZoomed:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetZoomed";
      case messages::NativeWidgetNSWindow::kSetSizeConstraints:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeConstraints";
      case messages::NativeWidgetNSWindow::kSetOpacity:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetOpacity";
      case messages::NativeWidgetNSWindow::kSetWindowLevel:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowLevel";
      case messages::NativeWidgetNSWindow::kSetActivationIndependence:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetActivationIndependence";
      case messages::NativeWidgetNSWindow::kSetAspectRatio:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetAspectRatio";
      case messages::NativeWidgetNSWindow::kSetCALayerParams:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetCALayerParams";
      case messages::NativeWidgetNSWindow::kSetWindowTitle:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowTitle";
      case messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetIgnoresMouseEvents";
      case messages::NativeWidgetNSWindow::kMakeFirstResponder:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::MakeFirstResponder";
      case messages::NativeWidgetNSWindow::kSortSubviews:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SortSubviews";
      case messages::NativeWidgetNSWindow::kClearTouchBar:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ClearTouchBar";
      case messages::NativeWidgetNSWindow::kUpdateTooltip:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::UpdateTooltip";
      case messages::NativeWidgetNSWindow::kAcquireCapture:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::AcquireCapture";
      case messages::NativeWidgetNSWindow::kReleaseCapture:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ReleaseCapture";
      case messages::NativeWidgetNSWindow::kRedispatchKeyEvent:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::RedispatchKeyEvent";
      case messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetLocalEventMonitorEnabled";
      case messages::NativeWidgetNSWindow::kSetCursor:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetCursor";
      case messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::EnableImmersiveFullscreen";
      case messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::DisableImmersiveFullscreen";
      case messages::NativeWidgetNSWindow::kUpdateToolbarVisibility:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::UpdateToolbarVisibility";
      case messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::OnTopContainerViewBoundsChanged";
      case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealLock";
      case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock";
      case messages::NativeWidgetNSWindow::kSetCanGoBack:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoBack";
      case messages::NativeWidgetNSWindow::kSetCanGoForward:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoForward";
      case messages::NativeWidgetNSWindow::kDisplayContextMenu:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::DisplayContextMenu";
      case messages::NativeWidgetNSWindow::kSetAllowScreenshots:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetAllowScreenshots";
      case messages::NativeWidgetNSWindow::kSetColorMode:
            return "Receive remote_cocoa::mojom::NativeWidgetNSWindow::SetColorMode";
    }
  } else {
    switch (static_cast<messages::NativeWidgetNSWindow>(message.name())) {
      case messages::NativeWidgetNSWindow::kCreateWindow:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::CreateWindow";
      case messages::NativeWidgetNSWindow::kSetParent:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetParent";
      case messages::NativeWidgetNSWindow::kCreateSelectFileDialog:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::CreateSelectFileDialog";
      case messages::NativeWidgetNSWindow::kShowCertificateViewer:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ShowCertificateViewer";
      case messages::NativeWidgetNSWindow::kStackAbove:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::StackAbove";
      case messages::NativeWidgetNSWindow::kStackAtTop:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::StackAtTop";
      case messages::NativeWidgetNSWindow::kShowEmojiPanel:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ShowEmojiPanel";
      case messages::NativeWidgetNSWindow::kInitWindow:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::InitWindow";
      case messages::NativeWidgetNSWindow::kInitCompositorView:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::InitCompositorView";
      case messages::NativeWidgetNSWindow::kCreateContentView:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::CreateContentView";
      case messages::NativeWidgetNSWindow::kDestroyContentView:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::DestroyContentView";
      case messages::NativeWidgetNSWindow::kCloseWindow:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindow";
      case messages::NativeWidgetNSWindow::kCloseWindowNow:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindowNow";
      case messages::NativeWidgetNSWindow::kSetInitialBounds:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetInitialBounds";
      case messages::NativeWidgetNSWindow::kSetBounds:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetBounds";
      case messages::NativeWidgetNSWindow::kSetSize:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetSize";
      case messages::NativeWidgetNSWindow::kSetSizeAndCenter:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeAndCenter";
      case messages::NativeWidgetNSWindow::kSetVisibilityState:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibilityState";
      case messages::NativeWidgetNSWindow::kSetAnimationEnabled:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetAnimationEnabled";
      case messages::NativeWidgetNSWindow::kSetTransitionsToAnimate:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetTransitionsToAnimate";
      case messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibleOnAllSpaces";
      case messages::NativeWidgetNSWindow::kEnterFullscreen:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::EnterFullscreen";
      case messages::NativeWidgetNSWindow::kExitFullscreen:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ExitFullscreen";
      case messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces";
      case messages::NativeWidgetNSWindow::kSetMiniaturized:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetMiniaturized";
      case messages::NativeWidgetNSWindow::kSetZoomed:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetZoomed";
      case messages::NativeWidgetNSWindow::kSetSizeConstraints:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeConstraints";
      case messages::NativeWidgetNSWindow::kSetOpacity:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetOpacity";
      case messages::NativeWidgetNSWindow::kSetWindowLevel:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowLevel";
      case messages::NativeWidgetNSWindow::kSetActivationIndependence:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetActivationIndependence";
      case messages::NativeWidgetNSWindow::kSetAspectRatio:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetAspectRatio";
      case messages::NativeWidgetNSWindow::kSetCALayerParams:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetCALayerParams";
      case messages::NativeWidgetNSWindow::kSetWindowTitle:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowTitle";
      case messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetIgnoresMouseEvents";
      case messages::NativeWidgetNSWindow::kMakeFirstResponder:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::MakeFirstResponder";
      case messages::NativeWidgetNSWindow::kSortSubviews:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SortSubviews";
      case messages::NativeWidgetNSWindow::kClearTouchBar:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ClearTouchBar";
      case messages::NativeWidgetNSWindow::kUpdateTooltip:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::UpdateTooltip";
      case messages::NativeWidgetNSWindow::kAcquireCapture:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::AcquireCapture";
      case messages::NativeWidgetNSWindow::kReleaseCapture:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ReleaseCapture";
      case messages::NativeWidgetNSWindow::kRedispatchKeyEvent:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::RedispatchKeyEvent";
      case messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetLocalEventMonitorEnabled";
      case messages::NativeWidgetNSWindow::kSetCursor:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetCursor";
      case messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::EnableImmersiveFullscreen";
      case messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::DisableImmersiveFullscreen";
      case messages::NativeWidgetNSWindow::kUpdateToolbarVisibility:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::UpdateToolbarVisibility";
      case messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::OnTopContainerViewBoundsChanged";
      case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealLock";
      case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock";
      case messages::NativeWidgetNSWindow::kSetCanGoBack:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoBack";
      case messages::NativeWidgetNSWindow::kSetCanGoForward:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoForward";
      case messages::NativeWidgetNSWindow::kDisplayContextMenu:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::DisplayContextMenu";
      case messages::NativeWidgetNSWindow::kSetAllowScreenshots:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetAllowScreenshots";
      case messages::NativeWidgetNSWindow::kSetColorMode:
            return "Receive reply remote_cocoa::mojom::NativeWidgetNSWindow::SetColorMode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NativeWidgetNSWindow::CreateWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4921bd2;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::CreateWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetParent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3fab86e;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetParent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::CreateSelectFileDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c8b92fb;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::CreateSelectFileDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ShowCertificateViewer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb32b33b5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ShowCertificateViewer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::StackAbove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe63b8d4f;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::StackAbove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::StackAtTop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd70a6780;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::StackAtTop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ShowEmojiPanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ead2c27;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ShowEmojiPanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::InitWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6556a61;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::InitWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::InitCompositorView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce00b361;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::InitCompositorView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::CreateContentView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb17496f8;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::CreateContentView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::DestroyContentView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55f26b04;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::DestroyContentView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::CloseWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0919f293;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::CloseWindowNow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3607c6d;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindowNow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetInitialBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5cf49a5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetInitialBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ccffbf5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdad0b9c9;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetSizeAndCenter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x514cbde4;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeAndCenter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetVisibilityState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe8d452a;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibilityState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetAnimationEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7bff0ad3;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetAnimationEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetTransitionsToAnimate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7dfa58fc;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetTransitionsToAnimate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetVisibleOnAllSpaces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb4a362a5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibleOnAllSpaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::EnterFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d8a2c52;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::EnterFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ExitFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a2e71de;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ExitFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30fa26c6;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetMiniaturized_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16ac5bc6;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetMiniaturized
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetZoomed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91ce5e57;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetZoomed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetSizeConstraints_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecfde471;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeConstraints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetOpacity_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed6f579a;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetOpacity
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetWindowLevel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd0be309;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowLevel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetActivationIndependence_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85bdbb9d;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetActivationIndependence
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetAspectRatio_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x544fa423;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetAspectRatio
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetCALayerParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7a2039f;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetCALayerParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetWindowTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03aa6ee6;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetIgnoresMouseEvents_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e306e13;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetIgnoresMouseEvents
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::MakeFirstResponder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2caec36;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::MakeFirstResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SortSubviews_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeaf3a9dd;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SortSubviews
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ClearTouchBar_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaad0cfd4;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ClearTouchBar
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::UpdateTooltip_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c271ec8;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::UpdateTooltip
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::AcquireCapture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95278712;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::AcquireCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ReleaseCapture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc148f51a;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ReleaseCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::RedispatchKeyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad93ac0d;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::RedispatchKeyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetLocalEventMonitorEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9be6135;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetLocalEventMonitorEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98a8b0a0;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::EnableImmersiveFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54d29df5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::EnableImmersiveFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::DisableImmersiveFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcdfbbaa5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::DisableImmersiveFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::UpdateToolbarVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd81112f0;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::UpdateToolbarVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::OnTopContainerViewBoundsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8d51c6c;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::OnTopContainerViewBoundsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ImmersiveFullscreenRevealLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc62a0a76;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2c7eb41;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetCanGoBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94172684;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetCanGoForward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x517831fe;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoForward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::DisplayContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x361108b5;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::DisplayContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetAllowScreenshots_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77949430;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetAllowScreenshots
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NativeWidgetNSWindow::SetColorMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4880215f;  // IPCStableHash for remote_cocoa::mojom::NativeWidgetNSWindow::SetColorMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NativeWidgetNSWindow_InitCompositorView_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeWidgetNSWindow_InitCompositorView_ForwardToCallback(
      NativeWidgetNSWindow::InitCompositorViewCallback callback
      ) : callback_(std::move(callback)) {
  }

  NativeWidgetNSWindow_InitCompositorView_ForwardToCallback(const NativeWidgetNSWindow_InitCompositorView_ForwardToCallback&) = delete;
  NativeWidgetNSWindow_InitCompositorView_ForwardToCallback& operator=(const NativeWidgetNSWindow_InitCompositorView_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NativeWidgetNSWindow::InitCompositorViewCallback callback_;
};

NativeWidgetNSWindowProxy::NativeWidgetNSWindowProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeWidgetNSWindowProxy::CreateWindow(
    CreateWindowParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::CreateWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateWindowParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kCreateWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_CreateWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::CreateWindowParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in NativeWidgetNSWindow.CreateWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("CreateWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetParent(
    uint64_t in_parent_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetParent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_id"), in_parent_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetParent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetParent_Params_Data> params(
          message);
  params.Allocate();

  params->parent_id = in_parent_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetParent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::CreateSelectFileDialog(
    ::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog> in_dialog) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::CreateSelectFileDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dialog"), in_dialog,
                        "<value of type ::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kCreateSelectFileDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::remote_cocoa::mojom::SelectFileDialogInterfaceBase>>(
    in_dialog,
    &params->dialog,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->dialog)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid dialog in NativeWidgetNSWindow.CreateSelectFileDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("CreateSelectFileDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ShowCertificateViewer(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ShowCertificateViewer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kShowCertificateViewer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ShowCertificateViewer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NativeWidgetNSWindow.ShowCertificateViewer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ShowCertificateViewer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::StackAbove(
    uint64_t in_sibling_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::StackAbove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sibling_id"), in_sibling_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kStackAbove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_StackAbove_Params_Data> params(
          message);
  params.Allocate();

  params->sibling_id = in_sibling_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("StackAbove");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::StackAtTop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::StackAtTop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kStackAtTop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_StackAtTop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("StackAtTop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ShowEmojiPanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ShowEmojiPanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kShowEmojiPanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ShowEmojiPanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ShowEmojiPanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::InitWindow(
    NativeWidgetNSWindowInitParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::InitWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type NativeWidgetNSWindowInitParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kInitWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_InitWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in NativeWidgetNSWindow.InitWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("InitWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::InitCompositorView(
    InitCompositorViewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::InitCompositorView");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kInitCompositorView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_InitCompositorView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("InitCompositorView");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeWidgetNSWindow_InitCompositorView_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NativeWidgetNSWindowProxy::CreateContentView(
    uint64_t in_ns_view_id, const ::gfx::Rect& in_bounds, std::optional<int32_t> in_corner_radius) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::CreateContentView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ns_view_id"), in_ns_view_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("corner_radius"), in_corner_radius,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kCreateContentView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_CreateContentView_Params_Data> params(
          message);
  params.Allocate();

  params->ns_view_id = in_ns_view_id;
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in NativeWidgetNSWindow.CreateContentView request");
  params->corner_radius_$flag = in_corner_radius.has_value();
  if (in_corner_radius.has_value()) {
    params->corner_radius_$value = in_corner_radius.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("CreateContentView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::DestroyContentView(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::DestroyContentView");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kDestroyContentView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_DestroyContentView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("DestroyContentView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::CloseWindow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kCloseWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_CloseWindow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("CloseWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::CloseWindowNow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::CloseWindowNow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kCloseWindowNow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_CloseWindowNow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("CloseWindowNow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetInitialBounds(
    const ::gfx::Rect& in_new_bounds, const ::gfx::Size& in_minimum_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetInitialBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_bounds"), in_new_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_content_size"), in_minimum_content_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetInitialBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetInitialBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_bounds)::BaseType> new_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_new_bounds,
    new_bounds_fragment);

  params->new_bounds.Set(
      new_bounds_fragment.is_null() ? nullptr : new_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_bounds in NativeWidgetNSWindow.SetInitialBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->minimum_content_size)::BaseType> minimum_content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_minimum_content_size,
    minimum_content_size_fragment);

  params->minimum_content_size.Set(
      minimum_content_size_fragment.is_null() ? nullptr : minimum_content_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->minimum_content_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null minimum_content_size in NativeWidgetNSWindow.SetInitialBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetInitialBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetBounds(
    const ::gfx::Rect& in_new_bounds, const ::gfx::Size& in_minimum_content_size, const std::optional<::gfx::Size>& in_maximum_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_bounds"), in_new_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_content_size"), in_minimum_content_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("maximum_content_size"), in_maximum_content_size,
                        "<value of type const std::optional<::gfx::Size>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_bounds)::BaseType> new_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_new_bounds,
    new_bounds_fragment);

  params->new_bounds.Set(
      new_bounds_fragment.is_null() ? nullptr : new_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_bounds in NativeWidgetNSWindow.SetBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->minimum_content_size)::BaseType> minimum_content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_minimum_content_size,
    minimum_content_size_fragment);

  params->minimum_content_size.Set(
      minimum_content_size_fragment.is_null() ? nullptr : minimum_content_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->minimum_content_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null minimum_content_size in NativeWidgetNSWindow.SetBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->maximum_content_size)::BaseType> maximum_content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_maximum_content_size,
    maximum_content_size_fragment);

  params->maximum_content_size.Set(
      maximum_content_size_fragment.is_null() ? nullptr : maximum_content_size_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetSize(
    const ::gfx::Size& in_new_size, const ::gfx::Size& in_minimum_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_size"), in_new_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_content_size"), in_minimum_content_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_size)::BaseType> new_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_new_size,
    new_size_fragment);

  params->new_size.Set(
      new_size_fragment.is_null() ? nullptr : new_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_size in NativeWidgetNSWindow.SetSize request");
  mojo::internal::MessageFragment<
      typename decltype(params->minimum_content_size)::BaseType> minimum_content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_minimum_content_size,
    minimum_content_size_fragment);

  params->minimum_content_size.Set(
      minimum_content_size_fragment.is_null() ? nullptr : minimum_content_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->minimum_content_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null minimum_content_size in NativeWidgetNSWindow.SetSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetSizeAndCenter(
    const ::gfx::Size& in_content_size, const ::gfx::Size& in_minimum_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeAndCenter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_size"), in_content_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_content_size"), in_minimum_content_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetSizeAndCenter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetSizeAndCenter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_size)::BaseType> content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_content_size,
    content_size_fragment);

  params->content_size.Set(
      content_size_fragment.is_null() ? nullptr : content_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_size in NativeWidgetNSWindow.SetSizeAndCenter request");
  mojo::internal::MessageFragment<
      typename decltype(params->minimum_content_size)::BaseType> minimum_content_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_minimum_content_size,
    minimum_content_size_fragment);

  params->minimum_content_size.Set(
      minimum_content_size_fragment.is_null() ? nullptr : minimum_content_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->minimum_content_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null minimum_content_size in NativeWidgetNSWindow.SetSizeAndCenter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetSizeAndCenter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetVisibilityState(
    WindowVisibilityState in_new_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibilityState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_state"), in_new_state,
                        "<value of type WindowVisibilityState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetVisibilityState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetVisibilityState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::WindowVisibilityState>(
    in_new_state,
    &params->new_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetVisibilityState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetAnimationEnabled(
    bool in_animation_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetAnimationEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("animation_enabled"), in_animation_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetAnimationEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetAnimationEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->animation_enabled = in_animation_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetAnimationEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetTransitionsToAnimate(
    VisibilityTransition in_transitions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetTransitionsToAnimate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transitions"), in_transitions,
                        "<value of type VisibilityTransition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetTransitionsToAnimate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::VisibilityTransition>(
    in_transitions,
    &params->transitions);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetTransitionsToAnimate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetVisibleOnAllSpaces(
    bool in_always_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetVisibleOnAllSpaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("always_visible"), in_always_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data> params(
          message);
  params.Allocate();

  params->always_visible = in_always_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetVisibleOnAllSpaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::EnterFullscreen(
    int64_t in_target_display_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::EnterFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_display_id"), in_target_display_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kEnterFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_EnterFullscreen_Params_Data> params(
          message);
  params.Allocate();

  params->target_display_id = in_target_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("EnterFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ExitFullscreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ExitFullscreen");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kExitFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ExitFullscreen_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ExitFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetCanAppearInExistingFullscreenSpaces(
    bool in_can_appear_in_existing_fullscreen_spaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetCanAppearInExistingFullscreenSpaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_appear_in_existing_fullscreen_spaces"), in_can_appear_in_existing_fullscreen_spaces,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data> params(
          message);
  params.Allocate();

  params->can_appear_in_existing_fullscreen_spaces = in_can_appear_in_existing_fullscreen_spaces;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetCanAppearInExistingFullscreenSpaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetMiniaturized(
    bool in_miniaturized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetMiniaturized", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("miniaturized"), in_miniaturized,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetMiniaturized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetMiniaturized_Params_Data> params(
          message);
  params.Allocate();

  params->miniaturized = in_miniaturized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetMiniaturized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetZoomed(
    bool in_zoomed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetZoomed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zoomed"), in_zoomed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetZoomed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetZoomed_Params_Data> params(
          message);
  params.Allocate();

  params->zoomed = in_zoomed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetZoomed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetSizeConstraints(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size, bool in_is_resizable, bool in_is_maximizable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetSizeConstraints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_size"), in_min_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_resizable"), in_is_resizable,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_maximizable"), in_is_maximizable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetSizeConstraints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetSizeConstraints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_size)::BaseType> min_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_min_size,
    min_size_fragment);

  params->min_size.Set(
      min_size_fragment.is_null() ? nullptr : min_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->min_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null min_size in NativeWidgetNSWindow.SetSizeConstraints request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_max_size,
    max_size_fragment);

  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->max_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null max_size in NativeWidgetNSWindow.SetSizeConstraints request");

  params->is_resizable = in_is_resizable;

  params->is_maximizable = in_is_maximizable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetSizeConstraints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetOpacity(
    float in_opacity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetOpacity", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opacity"), in_opacity,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetOpacity), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetOpacity_Params_Data> params(
          message);
  params.Allocate();

  params->opacity = in_opacity;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetOpacity");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetWindowLevel(
    int32_t in_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowLevel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetWindowLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetWindowLevel_Params_Data> params(
          message);
  params.Allocate();

  params->level = in_level;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetWindowLevel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetActivationIndependence(
    bool in_independence) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetActivationIndependence", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("independence"), in_independence,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetActivationIndependence), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetActivationIndependence_Params_Data> params(
          message);
  params.Allocate();

  params->independence = in_independence;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetActivationIndependence");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetAspectRatio(
    const ::gfx::SizeF& in_aspect_ratio, const ::gfx::Size& in_excluded_margin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetAspectRatio", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aspect_ratio"), in_aspect_ratio,
                        "<value of type const ::gfx::SizeF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("excluded_margin"), in_excluded_margin,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetAspectRatio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetAspectRatio_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->aspect_ratio)::BaseType> aspect_ratio_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
    in_aspect_ratio,
    aspect_ratio_fragment);

  params->aspect_ratio.Set(
      aspect_ratio_fragment.is_null() ? nullptr : aspect_ratio_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->aspect_ratio.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null aspect_ratio in NativeWidgetNSWindow.SetAspectRatio request");
  mojo::internal::MessageFragment<
      typename decltype(params->excluded_margin)::BaseType> excluded_margin_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_excluded_margin,
    excluded_margin_fragment);

  params->excluded_margin.Set(
      excluded_margin_fragment.is_null() ? nullptr : excluded_margin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->excluded_margin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null excluded_margin in NativeWidgetNSWindow.SetAspectRatio request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetAspectRatio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetCALayerParams(
    const ::gfx::CALayerParams& in_ca_layer_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetCALayerParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ca_layer_params"), in_ca_layer_params,
                        "<value of type const ::gfx::CALayerParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetCALayerParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetCALayerParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ca_layer_params)::BaseType> ca_layer_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::CALayerParamsDataView>(
    in_ca_layer_params,
    ca_layer_params_fragment);

  params->ca_layer_params.Set(
      ca_layer_params_fragment.is_null() ? nullptr : ca_layer_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ca_layer_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ca_layer_params in NativeWidgetNSWindow.SetCALayerParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetCALayerParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetWindowTitle(
    const ::std::u16string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetWindowTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetWindowTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetWindowTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in NativeWidgetNSWindow.SetWindowTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetWindowTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetIgnoresMouseEvents(
    bool in_ignores_mouse_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetIgnoresMouseEvents", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ignores_mouse_events"), in_ignores_mouse_events,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data> params(
          message);
  params.Allocate();

  params->ignores_mouse_events = in_ignores_mouse_events;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetIgnoresMouseEvents");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::MakeFirstResponder(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::MakeFirstResponder");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kMakeFirstResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_MakeFirstResponder_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("MakeFirstResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SortSubviews(
    const std::vector<uint64_t>& in_attached_subview_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SortSubviews", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attached_subview_ids"), in_attached_subview_ids,
                        "<value of type const std::vector<uint64_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSortSubviews), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SortSubviews_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->attached_subview_ids)::BaseType>
      attached_subview_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& attached_subview_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
    in_attached_subview_ids,
    attached_subview_ids_fragment,
    &attached_subview_ids_validate_params);

  params->attached_subview_ids.Set(
      attached_subview_ids_fragment.is_null() ? nullptr : attached_subview_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attached_subview_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attached_subview_ids in NativeWidgetNSWindow.SortSubviews request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SortSubviews");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ClearTouchBar(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ClearTouchBar");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kClearTouchBar), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ClearTouchBar_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ClearTouchBar");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::UpdateTooltip(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::UpdateTooltip");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kUpdateTooltip), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_UpdateTooltip_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("UpdateTooltip");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::AcquireCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::AcquireCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kAcquireCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_AcquireCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("AcquireCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ReleaseCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ReleaseCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kReleaseCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ReleaseCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ReleaseCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::RedispatchKeyEvent(
    const std::vector<uint8_t>& in_native_event_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::RedispatchKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_event_data"), in_native_event_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kRedispatchKeyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_event_data)::BaseType>
      native_event_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_native_event_data,
    native_event_data_fragment,
    &native_event_data_validate_params);

  params->native_event_data.Set(
      native_event_data_fragment.is_null() ? nullptr : native_event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_event_data in NativeWidgetNSWindow.RedispatchKeyEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("RedispatchKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetLocalEventMonitorEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetLocalEventMonitorEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetLocalEventMonitorEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetCursor(
    const ::ui::Cursor& in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor"), in_cursor,
                        "<value of type const ::ui::Cursor&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cursor)::BaseType> cursor_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::CursorDataView>(
    in_cursor,
    cursor_fragment);

  params->cursor.Set(
      cursor_fragment.is_null() ? nullptr : cursor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor in NativeWidgetNSWindow.SetCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::EnableImmersiveFullscreen(
    uint64_t in_fullscreen_overlay_widget_id, uint64_t in_tab_widget_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::EnableImmersiveFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fullscreen_overlay_widget_id"), in_fullscreen_overlay_widget_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_widget_id"), in_tab_widget_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data> params(
          message);
  params.Allocate();

  params->fullscreen_overlay_widget_id = in_fullscreen_overlay_widget_id;

  params->tab_widget_id = in_tab_widget_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("EnableImmersiveFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::DisableImmersiveFullscreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::DisableImmersiveFullscreen");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("DisableImmersiveFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::UpdateToolbarVisibility(
    ToolbarVisibilityStyle in_style) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::UpdateToolbarVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), in_style,
                        "<value of type ToolbarVisibilityStyle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kUpdateToolbarVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::ToolbarVisibilityStyle>(
    in_style,
    &params->style);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("UpdateToolbarVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::OnTopContainerViewBoundsChanged(
    const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::OnTopContainerViewBoundsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in NativeWidgetNSWindow.OnTopContainerViewBoundsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("OnTopContainerViewBoundsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ImmersiveFullscreenRevealLock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealLock");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ImmersiveFullscreenRevealLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::ImmersiveFullscreenRevealUnlock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::ImmersiveFullscreenRevealUnlock");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("ImmersiveFullscreenRevealUnlock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetCanGoBack(
    bool in_can_go_back) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoBack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_go_back"), in_can_go_back,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetCanGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetCanGoBack_Params_Data> params(
          message);
  params.Allocate();

  params->can_go_back = in_can_go_back;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetCanGoBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetCanGoForward(
    bool in_can_go_forward) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetCanGoForward", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_go_forward"), in_can_go_forward,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetCanGoForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetCanGoForward_Params_Data> params(
          message);
  params.Allocate();

  params->can_go_forward = in_can_go_forward;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetCanGoForward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::DisplayContextMenu(
    ::remote_cocoa::mojom::ContextMenuPtr in_menu, ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost> in_host, ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::DisplayContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu"), in_menu,
                        "<value of type ::remote_cocoa::mojom::ContextMenuPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kDisplayContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_DisplayContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->menu)::BaseType> menu_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::ContextMenuDataView>(
    in_menu,
    menu_fragment);

  params->menu.Set(
      menu_fragment.is_null() ? nullptr : menu_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->menu.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null menu in NativeWidgetNSWindow.DisplayContextMenu request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::remote_cocoa::mojom::MenuHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in NativeWidgetNSWindow.DisplayContextMenu request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::remote_cocoa::mojom::MenuInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in NativeWidgetNSWindow.DisplayContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("DisplayContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetAllowScreenshots(
    bool in_allow) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetAllowScreenshots", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow"), in_allow,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetAllowScreenshots), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetAllowScreenshots_Params_Data> params(
          message);
  params.Allocate();

  params->allow = in_allow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetAllowScreenshots");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NativeWidgetNSWindowProxy::SetColorMode(
    ::ui::ColorProviderKey::ColorMode in_color_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::NativeWidgetNSWindow::SetColorMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_mode"), in_color_mode,
                        "<value of type ::ui::ColorProviderKey::ColorMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kSetColorMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_SetColorMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::ColorMode>(
    in_color_mode,
    &params->color_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("SetColorMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NativeWidgetNSWindow_InitCompositorView_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NativeWidgetNSWindow::InitCompositorViewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NativeWidgetNSWindow_InitCompositorView_ProxyToResponder> proxy(
        new NativeWidgetNSWindow_InitCompositorView_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NativeWidgetNSWindow_InitCompositorView_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeWidgetNSWindow_InitCompositorView_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NativeWidgetNSWindow_InitCompositorView_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NativeWidgetNSWindow::InitCompositorViewCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_cg_window_id);
};

bool NativeWidgetNSWindow_InitCompositorView_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NativeWidgetNSWindow.8
  bool success = true;
  uint32_t p_cg_window_id{};
  NativeWidgetNSWindow_InitCompositorView_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cg_window_id = input_data_view.cg_window_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeWidgetNSWindow::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cg_window_id));
  }
  return true;
}

void NativeWidgetNSWindow_InitCompositorView_ProxyToResponder::Run(
    uint32_t in_cg_window_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::NativeWidgetNSWindow::InitCompositorView", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cg_window_id"), in_cg_window_id,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NativeWidgetNSWindow::kInitCompositorView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->cg_window_id = in_cg_window_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeWidgetNSWindow::Name_);
  message.set_method_name("InitCompositorView");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeWidgetNSWindowStubDispatch::Accept(
    NativeWidgetNSWindow* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NativeWidgetNSWindow>(message->header()->name)) {
    case messages::NativeWidgetNSWindow::kCreateWindow: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_CreateWindow_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_CreateWindow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.0
      bool success = true;
      CreateWindowParamsPtr p_params{};
      NativeWidgetNSWindow_CreateWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWindow(        
        std::move(p_params));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetParent: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetParent_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetParent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.1
      bool success = true;
      uint64_t p_parent_id{};
      NativeWidgetNSWindow_SetParent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_parent_id = input_data_view.parent_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParent(        
        std::move(p_parent_id));
      return true;
    }
    case messages::NativeWidgetNSWindow::kCreateSelectFileDialog: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.2
      bool success = true;
      ::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog> p_dialog{};
      NativeWidgetNSWindow_CreateSelectFileDialog_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_dialog =
            input_data_view.TakeDialog<decltype(p_dialog)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSelectFileDialog(        
        std::move(p_dialog));
      return true;
    }
    case messages::NativeWidgetNSWindow::kShowCertificateViewer: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ShowCertificateViewer_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ShowCertificateViewer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.3
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      NativeWidgetNSWindow_ShowCertificateViewer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowCertificateViewer(        
        std::move(p_certificate));
      return true;
    }
    case messages::NativeWidgetNSWindow::kStackAbove: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_StackAbove_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_StackAbove_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.4
      bool success = true;
      uint64_t p_sibling_id{};
      NativeWidgetNSWindow_StackAbove_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sibling_id = input_data_view.sibling_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StackAbove(        
        std::move(p_sibling_id));
      return true;
    }
    case messages::NativeWidgetNSWindow::kStackAtTop: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_StackAtTop_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_StackAtTop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.5
      bool success = true;
      NativeWidgetNSWindow_StackAtTop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StackAtTop(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kShowEmojiPanel: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ShowEmojiPanel_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ShowEmojiPanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.6
      bool success = true;
      NativeWidgetNSWindow_ShowEmojiPanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowEmojiPanel(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kInitWindow: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_InitWindow_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_InitWindow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.7
      bool success = true;
      NativeWidgetNSWindowInitParamsPtr p_params{};
      NativeWidgetNSWindow_InitWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitWindow(        
        std::move(p_params));
      return true;
    }
    case messages::NativeWidgetNSWindow::kInitCompositorView: {
      break;
    }
    case messages::NativeWidgetNSWindow::kCreateContentView: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_CreateContentView_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_CreateContentView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.9
      bool success = true;
      uint64_t p_ns_view_id{};
      ::gfx::Rect p_bounds{};
      std::optional<int32_t> p_corner_radius{};
      NativeWidgetNSWindow_CreateContentView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_ns_view_id = input_data_view.ns_view_id();
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (success) {
        p_corner_radius = input_data_view.corner_radius();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateContentView(        
        std::move(p_ns_view_id), 
        std::move(p_bounds), 
        std::move(p_corner_radius));
      return true;
    }
    case messages::NativeWidgetNSWindow::kDestroyContentView: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_DestroyContentView_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_DestroyContentView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.10
      bool success = true;
      NativeWidgetNSWindow_DestroyContentView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyContentView(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kCloseWindow: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_CloseWindow_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_CloseWindow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.11
      bool success = true;
      NativeWidgetNSWindow_CloseWindow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseWindow(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kCloseWindowNow: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_CloseWindowNow_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_CloseWindowNow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.12
      bool success = true;
      NativeWidgetNSWindow_CloseWindowNow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseWindowNow(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetInitialBounds: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetInitialBounds_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetInitialBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.13
      bool success = true;
      ::gfx::Rect p_new_bounds{};
      ::gfx::Size p_minimum_content_size{};
      NativeWidgetNSWindow_SetInitialBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewBounds(&p_new_bounds))
        success = false;
      if (success && !input_data_view.ReadMinimumContentSize(&p_minimum_content_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialBounds(        
        std::move(p_new_bounds), 
        std::move(p_minimum_content_size));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetBounds: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetBounds_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.14
      bool success = true;
      ::gfx::Rect p_new_bounds{};
      ::gfx::Size p_minimum_content_size{};
      std::optional<::gfx::Size> p_maximum_content_size{};
      NativeWidgetNSWindow_SetBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewBounds(&p_new_bounds))
        success = false;
      if (success && !input_data_view.ReadMinimumContentSize(&p_minimum_content_size))
        success = false;
      if (success && !input_data_view.ReadMaximumContentSize(&p_maximum_content_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBounds(        
        std::move(p_new_bounds), 
        std::move(p_minimum_content_size), 
        std::move(p_maximum_content_size));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetSize: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetSize_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetSize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.15
      bool success = true;
      ::gfx::Size p_new_size{};
      ::gfx::Size p_minimum_content_size{};
      NativeWidgetNSWindow_SetSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewSize(&p_new_size))
        success = false;
      if (success && !input_data_view.ReadMinimumContentSize(&p_minimum_content_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSize(        
        std::move(p_new_size), 
        std::move(p_minimum_content_size));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetSizeAndCenter: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetSizeAndCenter_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetSizeAndCenter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.16
      bool success = true;
      ::gfx::Size p_content_size{};
      ::gfx::Size p_minimum_content_size{};
      NativeWidgetNSWindow_SetSizeAndCenter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentSize(&p_content_size))
        success = false;
      if (success && !input_data_view.ReadMinimumContentSize(&p_minimum_content_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSizeAndCenter(        
        std::move(p_content_size), 
        std::move(p_minimum_content_size));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetVisibilityState: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetVisibilityState_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetVisibilityState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.17
      bool success = true;
      WindowVisibilityState p_new_state{};
      NativeWidgetNSWindow_SetVisibilityState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewState(&p_new_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisibilityState(        
        std::move(p_new_state));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetAnimationEnabled: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetAnimationEnabled_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetAnimationEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.18
      bool success = true;
      bool p_animation_enabled{};
      NativeWidgetNSWindow_SetAnimationEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_animation_enabled = input_data_view.animation_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAnimationEnabled(        
        std::move(p_animation_enabled));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetTransitionsToAnimate: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.19
      bool success = true;
      VisibilityTransition p_transitions{};
      NativeWidgetNSWindow_SetTransitionsToAnimate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTransitions(&p_transitions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTransitionsToAnimate(        
        std::move(p_transitions));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.20
      bool success = true;
      bool p_always_visible{};
      NativeWidgetNSWindow_SetVisibleOnAllSpaces_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_always_visible = input_data_view.always_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisibleOnAllSpaces(        
        std::move(p_always_visible));
      return true;
    }
    case messages::NativeWidgetNSWindow::kEnterFullscreen: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_EnterFullscreen_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_EnterFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.21
      bool success = true;
      int64_t p_target_display_id{};
      NativeWidgetNSWindow_EnterFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_target_display_id = input_data_view.target_display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterFullscreen(        
        std::move(p_target_display_id));
      return true;
    }
    case messages::NativeWidgetNSWindow::kExitFullscreen: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ExitFullscreen_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ExitFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.22
      bool success = true;
      NativeWidgetNSWindow_ExitFullscreen_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitFullscreen(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.23
      bool success = true;
      bool p_can_appear_in_existing_fullscreen_spaces{};
      NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_appear_in_existing_fullscreen_spaces = input_data_view.can_appear_in_existing_fullscreen_spaces();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanAppearInExistingFullscreenSpaces(        
        std::move(p_can_appear_in_existing_fullscreen_spaces));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetMiniaturized: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetMiniaturized_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetMiniaturized_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.24
      bool success = true;
      bool p_miniaturized{};
      NativeWidgetNSWindow_SetMiniaturized_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_miniaturized = input_data_view.miniaturized();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMiniaturized(        
        std::move(p_miniaturized));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetZoomed: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetZoomed_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetZoomed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.25
      bool success = true;
      bool p_zoomed{};
      NativeWidgetNSWindow_SetZoomed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_zoomed = input_data_view.zoomed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetZoomed(        
        std::move(p_zoomed));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetSizeConstraints: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetSizeConstraints_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetSizeConstraints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.26
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      bool p_is_resizable{};
      bool p_is_maximizable{};
      NativeWidgetNSWindow_SetSizeConstraints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (success)
        p_is_resizable = input_data_view.is_resizable();
      if (success)
        p_is_maximizable = input_data_view.is_maximizable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSizeConstraints(        
        std::move(p_min_size), 
        std::move(p_max_size), 
        std::move(p_is_resizable), 
        std::move(p_is_maximizable));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetOpacity: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetOpacity_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetOpacity_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.27
      bool success = true;
      float p_opacity{};
      NativeWidgetNSWindow_SetOpacity_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_opacity = input_data_view.opacity();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOpacity(        
        std::move(p_opacity));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetWindowLevel: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetWindowLevel_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetWindowLevel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.28
      bool success = true;
      int32_t p_level{};
      NativeWidgetNSWindow_SetWindowLevel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_level = input_data_view.level();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowLevel(        
        std::move(p_level));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetActivationIndependence: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetActivationIndependence_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetActivationIndependence_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.29
      bool success = true;
      bool p_independence{};
      NativeWidgetNSWindow_SetActivationIndependence_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_independence = input_data_view.independence();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActivationIndependence(        
        std::move(p_independence));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetAspectRatio: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetAspectRatio_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetAspectRatio_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.30
      bool success = true;
      ::gfx::SizeF p_aspect_ratio{};
      ::gfx::Size p_excluded_margin{};
      NativeWidgetNSWindow_SetAspectRatio_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAspectRatio(&p_aspect_ratio))
        success = false;
      if (success && !input_data_view.ReadExcludedMargin(&p_excluded_margin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAspectRatio(        
        std::move(p_aspect_ratio), 
        std::move(p_excluded_margin));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetCALayerParams: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetCALayerParams_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetCALayerParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.31
      bool success = true;
      ::gfx::CALayerParams p_ca_layer_params{};
      NativeWidgetNSWindow_SetCALayerParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCaLayerParams(&p_ca_layer_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCALayerParams(        
        std::move(p_ca_layer_params));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetWindowTitle: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetWindowTitle_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetWindowTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.32
      bool success = true;
      ::std::u16string p_title{};
      NativeWidgetNSWindow_SetWindowTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowTitle(        
        std::move(p_title));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.33
      bool success = true;
      bool p_ignores_mouse_events{};
      NativeWidgetNSWindow_SetIgnoresMouseEvents_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_ignores_mouse_events = input_data_view.ignores_mouse_events();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIgnoresMouseEvents(        
        std::move(p_ignores_mouse_events));
      return true;
    }
    case messages::NativeWidgetNSWindow::kMakeFirstResponder: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_MakeFirstResponder_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_MakeFirstResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.34
      bool success = true;
      NativeWidgetNSWindow_MakeFirstResponder_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeFirstResponder(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kSortSubviews: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SortSubviews_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SortSubviews_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.35
      bool success = true;
      std::vector<uint64_t> p_attached_subview_ids{};
      NativeWidgetNSWindow_SortSubviews_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttachedSubviewIds(&p_attached_subview_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SortSubviews(        
        std::move(p_attached_subview_ids));
      return true;
    }
    case messages::NativeWidgetNSWindow::kClearTouchBar: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ClearTouchBar_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ClearTouchBar_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.36
      bool success = true;
      NativeWidgetNSWindow_ClearTouchBar_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTouchBar(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kUpdateTooltip: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_UpdateTooltip_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_UpdateTooltip_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.37
      bool success = true;
      NativeWidgetNSWindow_UpdateTooltip_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTooltip(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kAcquireCapture: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_AcquireCapture_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_AcquireCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.38
      bool success = true;
      NativeWidgetNSWindow_AcquireCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireCapture(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kReleaseCapture: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ReleaseCapture_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ReleaseCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.39
      bool success = true;
      NativeWidgetNSWindow_ReleaseCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseCapture(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kRedispatchKeyEvent: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.40
      bool success = true;
      std::vector<uint8_t> p_native_event_data{};
      NativeWidgetNSWindow_RedispatchKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeEventData(&p_native_event_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RedispatchKeyEvent(        
        std::move(p_native_event_data));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.41
      bool success = true;
      bool p_enabled{};
      NativeWidgetNSWindow_SetLocalEventMonitorEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLocalEventMonitorEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetCursor: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetCursor_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetCursor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.42
      bool success = true;
      ::ui::Cursor p_cursor{};
      NativeWidgetNSWindow_SetCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCursor(&p_cursor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 42, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursor(        
        std::move(p_cursor));
      return true;
    }
    case messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.43
      bool success = true;
      uint64_t p_fullscreen_overlay_widget_id{};
      uint64_t p_tab_widget_id{};
      NativeWidgetNSWindow_EnableImmersiveFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_fullscreen_overlay_widget_id = input_data_view.fullscreen_overlay_widget_id();
      if (success)
        p_tab_widget_id = input_data_view.tab_widget_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableImmersiveFullscreen(        
        std::move(p_fullscreen_overlay_widget_id), 
        std::move(p_tab_widget_id));
      return true;
    }
    case messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.44
      bool success = true;
      NativeWidgetNSWindow_DisableImmersiveFullscreen_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableImmersiveFullscreen(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kUpdateToolbarVisibility: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.45
      bool success = true;
      ToolbarVisibilityStyle p_style{};
      NativeWidgetNSWindow_UpdateToolbarVisibility_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStyle(&p_style))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateToolbarVisibility(        
        std::move(p_style));
      return true;
    }
    case messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.46
      bool success = true;
      ::gfx::Rect p_bounds{};
      NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTopContainerViewBoundsChanged(        
        std::move(p_bounds));
      return true;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.47
      bool success = true;
      NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImmersiveFullscreenRevealLock(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.48
      bool success = true;
      NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImmersiveFullscreenRevealUnlock(        );
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoBack: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetCanGoBack_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetCanGoBack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.49
      bool success = true;
      bool p_can_go_back{};
      NativeWidgetNSWindow_SetCanGoBack_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_go_back = input_data_view.can_go_back();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanGoBack(        
        std::move(p_can_go_back));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoForward: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetCanGoForward_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetCanGoForward_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.50
      bool success = true;
      bool p_can_go_forward{};
      NativeWidgetNSWindow_SetCanGoForward_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_go_forward = input_data_view.can_go_forward();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanGoForward(        
        std::move(p_can_go_forward));
      return true;
    }
    case messages::NativeWidgetNSWindow::kDisplayContextMenu: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_DisplayContextMenu_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_DisplayContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.51
      bool success = true;
      ::remote_cocoa::mojom::ContextMenuPtr p_menu{};
      ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost> p_host{};
      ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu> p_receiver{};
      NativeWidgetNSWindow_DisplayContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMenu(&p_menu))
        success = false;
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayContextMenu(        
        std::move(p_menu), 
        std::move(p_host), 
        std::move(p_receiver));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetAllowScreenshots: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetAllowScreenshots_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetAllowScreenshots_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.52
      bool success = true;
      bool p_allow{};
      NativeWidgetNSWindow_SetAllowScreenshots_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allow = input_data_view.allow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAllowScreenshots(        
        std::move(p_allow));
      return true;
    }
    case messages::NativeWidgetNSWindow::kSetColorMode: {
      DCHECK(message->is_serialized());
      internal::NativeWidgetNSWindow_SetColorMode_Params_Data* params =
          reinterpret_cast<internal::NativeWidgetNSWindow_SetColorMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.53
      bool success = true;
      ::ui::ColorProviderKey::ColorMode p_color_mode{};
      NativeWidgetNSWindow_SetColorMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColorMode(&p_color_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetColorMode(        
        std::move(p_color_mode));
      return true;
    }
  }
  return false;
}

// static
bool NativeWidgetNSWindowStubDispatch::AcceptWithResponder(
    NativeWidgetNSWindow* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NativeWidgetNSWindow>(message->header()->name)) {
    case messages::NativeWidgetNSWindow::kCreateWindow: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetParent: {
      break;
    }
    case messages::NativeWidgetNSWindow::kCreateSelectFileDialog: {
      break;
    }
    case messages::NativeWidgetNSWindow::kShowCertificateViewer: {
      break;
    }
    case messages::NativeWidgetNSWindow::kStackAbove: {
      break;
    }
    case messages::NativeWidgetNSWindow::kStackAtTop: {
      break;
    }
    case messages::NativeWidgetNSWindow::kShowEmojiPanel: {
      break;
    }
    case messages::NativeWidgetNSWindow::kInitWindow: {
      break;
    }
    case messages::NativeWidgetNSWindow::kInitCompositorView: {
      internal::NativeWidgetNSWindow_InitCompositorView_Params_Data* params =
          reinterpret_cast<
              internal::NativeWidgetNSWindow_InitCompositorView_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NativeWidgetNSWindow.8
      bool success = true;
      NativeWidgetNSWindow_InitCompositorView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeWidgetNSWindow::Name_, 8, false);
        return false;
      }
      auto callback =
          NativeWidgetNSWindow_InitCompositorView_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitCompositorView(std::move(callback));
      return true;
    }
    case messages::NativeWidgetNSWindow::kCreateContentView: {
      break;
    }
    case messages::NativeWidgetNSWindow::kDestroyContentView: {
      break;
    }
    case messages::NativeWidgetNSWindow::kCloseWindow: {
      break;
    }
    case messages::NativeWidgetNSWindow::kCloseWindowNow: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetInitialBounds: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetBounds: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetSize: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetSizeAndCenter: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetVisibilityState: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetAnimationEnabled: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetTransitionsToAnimate: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetVisibleOnAllSpaces: {
      break;
    }
    case messages::NativeWidgetNSWindow::kEnterFullscreen: {
      break;
    }
    case messages::NativeWidgetNSWindow::kExitFullscreen: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetCanAppearInExistingFullscreenSpaces: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetMiniaturized: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetZoomed: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetSizeConstraints: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetOpacity: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetWindowLevel: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetActivationIndependence: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetAspectRatio: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetCALayerParams: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetWindowTitle: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetIgnoresMouseEvents: {
      break;
    }
    case messages::NativeWidgetNSWindow::kMakeFirstResponder: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSortSubviews: {
      break;
    }
    case messages::NativeWidgetNSWindow::kClearTouchBar: {
      break;
    }
    case messages::NativeWidgetNSWindow::kUpdateTooltip: {
      break;
    }
    case messages::NativeWidgetNSWindow::kAcquireCapture: {
      break;
    }
    case messages::NativeWidgetNSWindow::kReleaseCapture: {
      break;
    }
    case messages::NativeWidgetNSWindow::kRedispatchKeyEvent: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetLocalEventMonitorEnabled: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetCursor: {
      break;
    }
    case messages::NativeWidgetNSWindow::kEnableImmersiveFullscreen: {
      break;
    }
    case messages::NativeWidgetNSWindow::kDisableImmersiveFullscreen: {
      break;
    }
    case messages::NativeWidgetNSWindow::kUpdateToolbarVisibility: {
      break;
    }
    case messages::NativeWidgetNSWindow::kOnTopContainerViewBoundsChanged: {
      break;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealLock: {
      break;
    }
    case messages::NativeWidgetNSWindow::kImmersiveFullscreenRevealUnlock: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoBack: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetCanGoForward: {
      break;
    }
    case messages::NativeWidgetNSWindow::kDisplayContextMenu: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetAllowScreenshots: {
      break;
    }
    case messages::NativeWidgetNSWindow::kSetColorMode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNativeWidgetNSWindowValidationInfo[] = {
    { &internal::NativeWidgetNSWindow_CreateWindow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetParent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ShowCertificateViewer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_StackAbove_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_StackAtTop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ShowEmojiPanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_InitWindow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_InitCompositorView_Params_Data::Validate,
     &internal::NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data::Validate},
    { &internal::NativeWidgetNSWindow_CreateContentView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_DestroyContentView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_CloseWindow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_CloseWindowNow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetInitialBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetSize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetSizeAndCenter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetVisibilityState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetAnimationEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_EnterFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ExitFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetMiniaturized_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetZoomed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetSizeConstraints_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetOpacity_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetWindowLevel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetActivationIndependence_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetAspectRatio_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetCALayerParams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetWindowTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_MakeFirstResponder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SortSubviews_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ClearTouchBar_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_UpdateTooltip_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_AcquireCapture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ReleaseCapture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetCursor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetCanGoBack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetCanGoForward_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_DisplayContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetAllowScreenshots_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NativeWidgetNSWindow_SetColorMode_Params_Data::Validate,
     nullptr /* no response */},
};

bool NativeWidgetNSWindowRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::NativeWidgetNSWindow::Name_,
    kNativeWidgetNSWindowValidationInfo);
}

bool NativeWidgetNSWindowResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::NativeWidgetNSWindow::Name_,
    kNativeWidgetNSWindowValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::CreateWindowParams::DataView, ::remote_cocoa::mojom::CreateWindowParamsPtr>::Read(
    ::remote_cocoa::mojom::CreateWindowParams::DataView input,
    ::remote_cocoa::mojom::CreateWindowParamsPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::CreateWindowParamsPtr result(::remote_cocoa::mojom::CreateWindowParams::New());
  
      if (success && !input.ReadWindowClass(&result->window_class))
        success = false;
      if (success)
        result->style_mask = input.style_mask();
      if (success)
        result->titlebar_appears_transparent = input.titlebar_appears_transparent();
      if (success)
        result->window_title_hidden = input.window_title_hidden();
      if (success)
        result->animation_enabled = input.animation_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::DataView, ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr>::Read(
    ::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::DataView input,
    ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr result(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::New());
  
      if (success && !input.ReadModalType(&result->modal_type))
        success = false;
      if (success)
        result->is_translucent = input.is_translucent();
      if (success)
        result->has_window_server_shadow = input.has_window_server_shadow();
      if (success)
        result->force_into_collection_cycle = input.force_into_collection_cycle();
      if (success && !input.ReadStateRestorationData(&result->state_restoration_data))
        success = false;
      if (success)
        result->is_tooltip = input.is_tooltip();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void NativeWidgetNSWindowInterceptorForTesting::CreateWindow(CreateWindowParamsPtr params) {
  GetForwardingInterface()->CreateWindow(
    std::move(params)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetParent(uint64_t parent_id) {
  GetForwardingInterface()->SetParent(
    std::move(parent_id)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::CreateSelectFileDialog(::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog> dialog) {
  GetForwardingInterface()->CreateSelectFileDialog(
    std::move(dialog)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::ShowCertificateViewer(const ::scoped_refptr<::net::X509Certificate>& certificate) {
  GetForwardingInterface()->ShowCertificateViewer(
    std::move(certificate)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::StackAbove(uint64_t sibling_id) {
  GetForwardingInterface()->StackAbove(
    std::move(sibling_id)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::StackAtTop() {
  GetForwardingInterface()->StackAtTop();
}
void NativeWidgetNSWindowInterceptorForTesting::ShowEmojiPanel() {
  GetForwardingInterface()->ShowEmojiPanel();
}
void NativeWidgetNSWindowInterceptorForTesting::InitWindow(NativeWidgetNSWindowInitParamsPtr params) {
  GetForwardingInterface()->InitWindow(
    std::move(params)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::InitCompositorView(InitCompositorViewCallback callback) {
  GetForwardingInterface()->InitCompositorView(std::move(callback));
}
void NativeWidgetNSWindowInterceptorForTesting::CreateContentView(uint64_t ns_view_id, const ::gfx::Rect& bounds, std::optional<int32_t> corner_radius) {
  GetForwardingInterface()->CreateContentView(
    std::move(ns_view_id)
    , 
    std::move(bounds)
    , 
    std::move(corner_radius)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::DestroyContentView() {
  GetForwardingInterface()->DestroyContentView();
}
void NativeWidgetNSWindowInterceptorForTesting::CloseWindow() {
  GetForwardingInterface()->CloseWindow();
}
void NativeWidgetNSWindowInterceptorForTesting::CloseWindowNow() {
  GetForwardingInterface()->CloseWindowNow();
}
void NativeWidgetNSWindowInterceptorForTesting::SetInitialBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size) {
  GetForwardingInterface()->SetInitialBounds(
    std::move(new_bounds)
    , 
    std::move(minimum_content_size)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size, const std::optional<::gfx::Size>& maximum_content_size) {
  GetForwardingInterface()->SetBounds(
    std::move(new_bounds)
    , 
    std::move(minimum_content_size)
    , 
    std::move(maximum_content_size)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetSize(const ::gfx::Size& new_size, const ::gfx::Size& minimum_content_size) {
  GetForwardingInterface()->SetSize(
    std::move(new_size)
    , 
    std::move(minimum_content_size)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetSizeAndCenter(const ::gfx::Size& content_size, const ::gfx::Size& minimum_content_size) {
  GetForwardingInterface()->SetSizeAndCenter(
    std::move(content_size)
    , 
    std::move(minimum_content_size)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetVisibilityState(WindowVisibilityState new_state) {
  GetForwardingInterface()->SetVisibilityState(
    std::move(new_state)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetAnimationEnabled(bool animation_enabled) {
  GetForwardingInterface()->SetAnimationEnabled(
    std::move(animation_enabled)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetTransitionsToAnimate(VisibilityTransition transitions) {
  GetForwardingInterface()->SetTransitionsToAnimate(
    std::move(transitions)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetVisibleOnAllSpaces(bool always_visible) {
  GetForwardingInterface()->SetVisibleOnAllSpaces(
    std::move(always_visible)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::EnterFullscreen(int64_t target_display_id) {
  GetForwardingInterface()->EnterFullscreen(
    std::move(target_display_id)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::ExitFullscreen() {
  GetForwardingInterface()->ExitFullscreen();
}
void NativeWidgetNSWindowInterceptorForTesting::SetCanAppearInExistingFullscreenSpaces(bool can_appear_in_existing_fullscreen_spaces) {
  GetForwardingInterface()->SetCanAppearInExistingFullscreenSpaces(
    std::move(can_appear_in_existing_fullscreen_spaces)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetMiniaturized(bool miniaturized) {
  GetForwardingInterface()->SetMiniaturized(
    std::move(miniaturized)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetZoomed(bool zoomed) {
  GetForwardingInterface()->SetZoomed(
    std::move(zoomed)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetSizeConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool is_resizable, bool is_maximizable) {
  GetForwardingInterface()->SetSizeConstraints(
    std::move(min_size)
    , 
    std::move(max_size)
    , 
    std::move(is_resizable)
    , 
    std::move(is_maximizable)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetOpacity(float opacity) {
  GetForwardingInterface()->SetOpacity(
    std::move(opacity)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetWindowLevel(int32_t level) {
  GetForwardingInterface()->SetWindowLevel(
    std::move(level)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetActivationIndependence(bool independence) {
  GetForwardingInterface()->SetActivationIndependence(
    std::move(independence)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetAspectRatio(const ::gfx::SizeF& aspect_ratio, const ::gfx::Size& excluded_margin) {
  GetForwardingInterface()->SetAspectRatio(
    std::move(aspect_ratio)
    , 
    std::move(excluded_margin)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) {
  GetForwardingInterface()->SetCALayerParams(
    std::move(ca_layer_params)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetWindowTitle(const ::std::u16string& title) {
  GetForwardingInterface()->SetWindowTitle(
    std::move(title)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetIgnoresMouseEvents(bool ignores_mouse_events) {
  GetForwardingInterface()->SetIgnoresMouseEvents(
    std::move(ignores_mouse_events)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::MakeFirstResponder() {
  GetForwardingInterface()->MakeFirstResponder();
}
void NativeWidgetNSWindowInterceptorForTesting::SortSubviews(const std::vector<uint64_t>& attached_subview_ids) {
  GetForwardingInterface()->SortSubviews(
    std::move(attached_subview_ids)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::ClearTouchBar() {
  GetForwardingInterface()->ClearTouchBar();
}
void NativeWidgetNSWindowInterceptorForTesting::UpdateTooltip() {
  GetForwardingInterface()->UpdateTooltip();
}
void NativeWidgetNSWindowInterceptorForTesting::AcquireCapture() {
  GetForwardingInterface()->AcquireCapture();
}
void NativeWidgetNSWindowInterceptorForTesting::ReleaseCapture() {
  GetForwardingInterface()->ReleaseCapture();
}
void NativeWidgetNSWindowInterceptorForTesting::RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data) {
  GetForwardingInterface()->RedispatchKeyEvent(
    std::move(native_event_data)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetLocalEventMonitorEnabled(bool enabled) {
  GetForwardingInterface()->SetLocalEventMonitorEnabled(
    std::move(enabled)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetCursor(const ::ui::Cursor& cursor) {
  GetForwardingInterface()->SetCursor(
    std::move(cursor)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::EnableImmersiveFullscreen(uint64_t fullscreen_overlay_widget_id, uint64_t tab_widget_id) {
  GetForwardingInterface()->EnableImmersiveFullscreen(
    std::move(fullscreen_overlay_widget_id)
    , 
    std::move(tab_widget_id)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::DisableImmersiveFullscreen() {
  GetForwardingInterface()->DisableImmersiveFullscreen();
}
void NativeWidgetNSWindowInterceptorForTesting::UpdateToolbarVisibility(ToolbarVisibilityStyle style) {
  GetForwardingInterface()->UpdateToolbarVisibility(
    std::move(style)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::OnTopContainerViewBoundsChanged(const ::gfx::Rect& bounds) {
  GetForwardingInterface()->OnTopContainerViewBoundsChanged(
    std::move(bounds)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::ImmersiveFullscreenRevealLock() {
  GetForwardingInterface()->ImmersiveFullscreenRevealLock();
}
void NativeWidgetNSWindowInterceptorForTesting::ImmersiveFullscreenRevealUnlock() {
  GetForwardingInterface()->ImmersiveFullscreenRevealUnlock();
}
void NativeWidgetNSWindowInterceptorForTesting::SetCanGoBack(bool can_go_back) {
  GetForwardingInterface()->SetCanGoBack(
    std::move(can_go_back)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetCanGoForward(bool can_go_forward) {
  GetForwardingInterface()->SetCanGoForward(
    std::move(can_go_forward)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::DisplayContextMenu(::remote_cocoa::mojom::ContextMenuPtr menu, ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost> host, ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu> receiver) {
  GetForwardingInterface()->DisplayContextMenu(
    std::move(menu)
    , 
    std::move(host)
    , 
    std::move(receiver)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetAllowScreenshots(bool allow) {
  GetForwardingInterface()->SetAllowScreenshots(
    std::move(allow)
    );
}
void NativeWidgetNSWindowInterceptorForTesting::SetColorMode(::ui::ColorProviderKey::ColorMode color_mode) {
  GetForwardingInterface()->SetColorMode(
    std::move(color_mode)
    );
}
NativeWidgetNSWindowAsyncWaiter::NativeWidgetNSWindowAsyncWaiter(
    NativeWidgetNSWindow* proxy) : proxy_(proxy) {}

NativeWidgetNSWindowAsyncWaiter::~NativeWidgetNSWindowAsyncWaiter() = default;


void NativeWidgetNSWindowAsyncWaiter::InitCompositorView(
    uint32_t* out_cg_window_id) {
  base::RunLoop loop;
  proxy_->InitCompositorView(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_cg_window_id
,
             uint32_t cg_window_id) {*out_cg_window_id = std::move(cg_window_id);
            loop->Quit();
          },
          &loop,
          out_cg_window_id));
  loop.Run();
}

uint32_t NativeWidgetNSWindowAsyncWaiter::InitCompositorView(
    ) {
  uint32_t async_wait_result;
  InitCompositorView(&async_wait_result);
  return async_wait_result;
}






}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif