// components/remote_cocoa/common/application.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/application.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/application.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* CutCopyPasteCommandToStringHelper(CutCopyPasteCommand value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CutCopyPasteCommand::kCut:
      return "kCut";
    case CutCopyPasteCommand::kCopy:
      return "kCopy";
    case CutCopyPasteCommand::kPaste:
      return "kPaste";
    default:
      return nullptr;
  }
}

std::string CutCopyPasteCommandToString(CutCopyPasteCommand value) {
  const char *str = CutCopyPasteCommandToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CutCopyPasteCommand value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CutCopyPasteCommand value) {
  return os << CutCopyPasteCommandToString(value);
}

namespace internal {


// static
bool Application_CreateAlert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_CreateAlert_Params_Data* object =
      static_cast<const Application_CreateAlert_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->alert_bridge_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->alert_bridge_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Application_CreateAlert_Params_Data::Application_CreateAlert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Application_CreateNativeWidgetNSWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_CreateNativeWidgetNSWindow_Params_Data* object =
      static_cast<const Application_CreateNativeWidgetNSWindow_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->window_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->window_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->text_input_host, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->text_input_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Application_CreateNativeWidgetNSWindow_Params_Data::Application_CreateNativeWidgetNSWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Application_CreateRenderWidgetHostNSView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_CreateRenderWidgetHostNSView_Params_Data* object =
      static_cast<const Application_CreateRenderWidgetHostNSView_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->view_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->view_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Application_CreateRenderWidgetHostNSView_Params_Data::Application_CreateRenderWidgetHostNSView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Application_CreateSystemMediaControlsBridge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_CreateSystemMediaControlsBridge_Params_Data* object =
      static_cast<const Application_CreateSystemMediaControlsBridge_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Application_CreateSystemMediaControlsBridge_Params_Data::Application_CreateSystemMediaControlsBridge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Application_CreateWebContentsNSView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_CreateWebContentsNSView_Params_Data* object =
      static_cast<const Application_CreateWebContentsNSView_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->view_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->view_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Application_CreateWebContentsNSView_Params_Data::Application_CreateWebContentsNSView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Application_ForwardCutCopyPaste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Application_ForwardCutCopyPaste_Params_Data* object =
      static_cast<const Application_ForwardCutCopyPaste_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::CutCopyPasteCommand_Data
        ::Validate(object->command, validation_context))
    return false;

  return true;
}

Application_ForwardCutCopyPaste_Params_Data::Application_ForwardCutCopyPaste_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::CutCopyPasteCommand>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::CutCopyPasteCommand value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::CutCopyPasteCommandToString(value));
}

} // namespace perfetto