// components/printing/common/print.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SEND_VALIDATION_H_

#include "components/printing/common/print.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "components/printing/common/print.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::printing::mojom::PrintFailureReason, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PreviewIdsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PreviewIdsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PreviewIds_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->request_id = Traits::request_id(input);

      fragment->ui_id = Traits::ui_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::RequestPrintPreviewParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::RequestPrintPreviewParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::RequestPrintPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_modifiable = Traits::is_modifiable(input);

      fragment->webnode_only = Traits::webnode_only(input);

      fragment->has_selection = Traits::has_selection(input);

      fragment->selection_only = Traits::selection_only(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrintFrameContentParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintFrameContentParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintFrameContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_printable_area,
        printable_area_fragment);

      fragment->printable_area.Set(
          printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printable_area.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintFrameContentParams struct");

      fragment->document_cookie = Traits::document_cookie(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::OptionsFromDocumentParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::OptionsFromDocumentParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::OptionsFromDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_scaling_disabled = Traits::is_scaling_disabled(input);

      fragment->copies = Traits::copies(input);

      
      mojo::internal::Serialize<::printing::mojom::DuplexMode>(
        Traits::duplex(input),
        &fragment->duplex);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::DidPrintContentParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintContentParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::metafile_data_region(input)) in_metafile_data_region = Traits::metafile_data_region(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metafile_data_region)::BaseType> metafile_data_region_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
        in_metafile_data_region,
        metafile_data_region_fragment);

      fragment->metafile_data_region.Set(
          metafile_data_region_fragment.is_null() ? nullptr : metafile_data_region_fragment.data());

      decltype(Traits::subframe_content_info(input)) in_subframe_content_info = Traits::subframe_content_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subframe_content_info)::BaseType>
          subframe_content_info_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>, send_validation>(
        in_subframe_content_info,
        subframe_content_info_fragment,
        &subframe_content_info_validate_params);

      fragment->subframe_content_info.Set(
          subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subframe_content_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_content_info in DidPrintContentParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::DidStartPreviewParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidStartPreviewParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidStartPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->page_count = Traits::page_count(input);

      decltype(Traits::pages_to_render(input)) in_pages_to_render = Traits::pages_to_render(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pages_to_render)::BaseType>
          pages_to_render_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pages_to_render_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_pages_to_render,
        pages_to_render_fragment,
        &pages_to_render_validate_params);

      fragment->pages_to_render.Set(
          pages_to_render_fragment.is_null() ? nullptr : pages_to_render_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pages_to_render.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages_to_render in DidStartPreviewParams struct");

      fragment->pages_per_sheet = Traits::pages_per_sheet(input);

      decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_size)::BaseType> page_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeFDataView, send_validation>(
        in_page_size,
        page_size_fragment);

      fragment->page_size.Set(
          page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->page_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidStartPreviewParams struct");

      fragment->fit_to_page_scaling = Traits::fit_to_page_scaling(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::DidPreviewPageParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewPageParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewPageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::content(input)) in_content = Traits::content(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content)::BaseType> content_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView, send_validation>(
        in_content,
        content_fragment);

      fragment->content.Set(
          content_fragment.is_null() ? nullptr : content_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewPageParams struct");

      fragment->page_index = Traits::page_index(input);

      fragment->document_cookie = Traits::document_cookie(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::DidPreviewDocumentParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewDocumentParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::content(input)) in_content = Traits::content(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content)::BaseType> content_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView, send_validation>(
        in_content,
        content_fragment);

      fragment->content.Set(
          content_fragment.is_null() ? nullptr : content_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewDocumentParams struct");

      fragment->document_cookie = Traits::document_cookie(input);

      fragment->expected_pages_count = Traits::expected_pages_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrintParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_size)::BaseType> page_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeFDataView, send_validation>(
        in_page_size,
        page_size_fragment);

      fragment->page_size.Set(
          page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->page_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in PrintParams struct");

      decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_size)::BaseType> content_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeFDataView, send_validation>(
        in_content_size,
        content_size_fragment);

      fragment->content_size.Set(
          content_size_fragment.is_null() ? nullptr : content_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_size in PrintParams struct");

      decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_printable_area,
        printable_area_fragment);

      fragment->printable_area.Set(
          printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printable_area.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintParams struct");

      fragment->margin_top = Traits::margin_top(input);

      fragment->margin_left = Traits::margin_left(input);

      
      mojo::internal::Serialize<::printing::mojom::PageOrientation>(
        Traits::page_orientation(input),
        &fragment->page_orientation);

      decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dpi)::BaseType> dpi_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_dpi,
        dpi_fragment);

      fragment->dpi.Set(
          dpi_fragment.is_null() ? nullptr : dpi_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dpi.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dpi in PrintParams struct");

      fragment->scale_factor = Traits::scale_factor(input);

      fragment->document_cookie = Traits::document_cookie(input);

      fragment->selection_only = Traits::selection_only(input);

      fragment->preview_ui_id = Traits::preview_ui_id(input);

      fragment->preview_request_id = Traits::preview_request_id(input);

      fragment->is_first_request = Traits::is_first_request(input);

      
      mojo::internal::Serialize<::printing::mojom::PrintScalingOption>(
        Traits::print_scaling_option(input),
        &fragment->print_scaling_option);

      fragment->print_to_pdf = Traits::print_to_pdf(input);

      fragment->display_header_footer = Traits::display_header_footer(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in PrintParams struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PrintParams struct");

      decltype(Traits::header_template(input)) in_header_template = Traits::header_template(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->header_template)::BaseType> header_template_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_header_template,
        header_template_fragment);

      fragment->header_template.Set(
          header_template_fragment.is_null() ? nullptr : header_template_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->header_template.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_template in PrintParams struct");

      decltype(Traits::footer_template(input)) in_footer_template = Traits::footer_template(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->footer_template)::BaseType> footer_template_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_footer_template,
        footer_template_fragment);

      fragment->footer_template.Set(
          footer_template_fragment.is_null() ? nullptr : footer_template_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->footer_template.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null footer_template in PrintParams struct");

      fragment->rasterize_pdf = Traits::rasterize_pdf(input);

      fragment->rasterize_pdf_dpi = Traits::rasterize_pdf_dpi(input);

      fragment->should_print_backgrounds = Traits::should_print_backgrounds(input);

      
      mojo::internal::Serialize<::printing::mojom::SkiaDocumentType>(
        Traits::printed_doc_type(input),
        &fragment->printed_doc_type);

      fragment->prefer_css_page_size = Traits::prefer_css_page_size(input);

      fragment->pages_per_sheet = Traits::pages_per_sheet(input);
      fragment->generate_tagged_pdf_$flag = Traits::generate_tagged_pdf(input).has_value();
      if (Traits::generate_tagged_pdf(input).has_value()) {
        fragment->generate_tagged_pdf_$value = Traits::generate_tagged_pdf(input).value();
      }

      
      mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
        Traits::generate_document_outline(input),
        &fragment->generate_document_outline);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrintPagesParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintPagesParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintPagesParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType> params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::PrintParamsDataView, send_validation>(
        in_params,
        params_fragment);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in PrintPagesParams struct");

      decltype(Traits::pages(input)) in_pages = Traits::pages(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pages)::BaseType>
          pages_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pages_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>, send_validation>(
        in_pages,
        pages_fragment,
        &pages_validate_params);

      fragment->pages.Set(
          pages_fragment.is_null() ? nullptr : pages_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pages.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages in PrintPagesParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::DidPrintDocumentParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintDocumentParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::content(input)) in_content = Traits::content(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content)::BaseType> content_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView, send_validation>(
        in_content,
        content_fragment);

      fragment->content.Set(
          content_fragment.is_null() ? nullptr : content_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPrintDocumentParams struct");

      fragment->document_cookie = Traits::document_cookie(input);

      decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_size)::BaseType> page_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_page_size,
        page_size_fragment);

      fragment->page_size.Set(
          page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->page_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidPrintDocumentParams struct");

      decltype(Traits::content_area(input)) in_content_area = Traits::content_area(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_area)::BaseType> content_area_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_content_area,
        content_area_fragment);

      fragment->content_area.Set(
          content_area_fragment.is_null() ? nullptr : content_area_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_area.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_area in DidPrintDocumentParams struct");

      decltype(Traits::physical_offsets(input)) in_physical_offsets = Traits::physical_offsets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->physical_offsets)::BaseType> physical_offsets_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_physical_offsets,
        physical_offsets_fragment);

      fragment->physical_offsets.Set(
          physical_offsets_fragment.is_null() ? nullptr : physical_offsets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->physical_offsets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_offsets in DidPrintDocumentParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::ScriptedPrintParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::ScriptedPrintParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::ScriptedPrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->cookie = Traits::cookie(input);

      fragment->expected_pages_count = Traits::expected_pages_count(input);

      fragment->has_selection = Traits::has_selection(input);

      fragment->is_scripted = Traits::is_scripted(input);

      
      mojo::internal::Serialize<::printing::mojom::MarginType>(
        Traits::margin_type(input),
        &fragment->margin_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrintWithParamsResultDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintWithParamsResultDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintWithParamsResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType> params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView, send_validation>(
        in_params,
        params_fragment);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in PrintWithParamsResultData struct");

      decltype(Traits::accessibility_tree(input)) in_accessibility_tree = Traits::accessibility_tree(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accessibility_tree)::BaseType> accessibility_tree_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView, send_validation>(
        in_accessibility_tree,
        accessibility_tree_fragment);

      fragment->accessibility_tree.Set(
          accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accessibility_tree.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accessibility_tree in PrintWithParamsResultData struct");

      
      mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
        Traits::generate_document_outline(input),
        &fragment->generate_document_outline);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::printing::mojom::PrintWithParamsResultDataDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintRenderFrame_PrintWithParams_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::PrintFailureReason, send_validation>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SEND_VALIDATION_H_