// components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-params-data.h"
#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared-message-ids.h"

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-import-headers.h"
#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-test-utils.h"


namespace password_manager::mojom {
CSVPasswordSequence::CSVPasswordSequence()
    : csv_passwords() {}

CSVPasswordSequence::CSVPasswordSequence(
    std::vector<::password_manager::CSVPassword> csv_passwords_in)
    : csv_passwords(std::move(csv_passwords_in)) {}

CSVPasswordSequence::~CSVPasswordSequence() = default;

void CSVPasswordSequence::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "csv_passwords"), this->csv_passwords,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::password_manager::CSVPassword>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSVPasswordSequence::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSVPassword::CSVPassword()
    : status(),
      username(),
      password(),
      note(),
      url(),
      invalid_url() {}

CSVPassword::CSVPassword(
    CSVPassword::Status status_in,
    const std::string& username_in,
    const std::string& password_in,
    const std::string& note_in,
    const ::GURL& url_in,
    const std::optional<std::string>& invalid_url_in)
    : status(std::move(status_in)),
      username(std::move(username_in)),
      password(std::move(password_in)),
      note(std::move(note_in)),
      url(std::move(url_in)),
      invalid_url(std::move(invalid_url_in)) {}

CSVPassword::~CSVPassword() = default;

void CSVPassword::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSVPassword::Status>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password"), this->password,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "note"), this->note,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "invalid_url"), this->invalid_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSVPassword::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CSVPasswordParser::IPCStableHashFunction CSVPasswordParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CSVPasswordParser>(message.name())) {
    case messages::CSVPasswordParser::kParseCSV: {
      return &CSVPasswordParser::ParseCSV_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CSVPasswordParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CSVPasswordParser>(message.name())) {
      case messages::CSVPasswordParser::kParseCSV:
            return "Receive password_manager::mojom::CSVPasswordParser::ParseCSV";
    }
  } else {
    switch (static_cast<messages::CSVPasswordParser>(message.name())) {
      case messages::CSVPasswordParser::kParseCSV:
            return "Receive reply password_manager::mojom::CSVPasswordParser::ParseCSV";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CSVPasswordParser::ParseCSV_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65cd1c52;  // IPCStableHash for password_manager::mojom::CSVPasswordParser::ParseCSV
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CSVPasswordParser_ParseCSV_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CSVPasswordParser_ParseCSV_ForwardToCallback(
      CSVPasswordParser::ParseCSVCallback callback
      ) : callback_(std::move(callback)) {
  }

  CSVPasswordParser_ParseCSV_ForwardToCallback(const CSVPasswordParser_ParseCSV_ForwardToCallback&) = delete;
  CSVPasswordParser_ParseCSV_ForwardToCallback& operator=(const CSVPasswordParser_ParseCSV_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CSVPasswordParser::ParseCSVCallback callback_;
};

CSVPasswordParserProxy::CSVPasswordParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CSVPasswordParserProxy::ParseCSV(
    const std::string& in_raw_csv, ParseCSVCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::CSVPasswordParser::ParseCSV", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_csv"), in_raw_csv,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CSVPasswordParser::kParseCSV), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::CSVPasswordParser_ParseCSV_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_csv)::BaseType> raw_csv_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_raw_csv,
    raw_csv_fragment);

  params->raw_csv.Set(
      raw_csv_fragment.is_null() ? nullptr : raw_csv_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->raw_csv.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null raw_csv in CSVPasswordParser.ParseCSV request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CSVPasswordParser::Name_);
  message.set_method_name("ParseCSV");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CSVPasswordParser_ParseCSV_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CSVPasswordParser_ParseCSV_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CSVPasswordParser::ParseCSVCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CSVPasswordParser_ParseCSV_ProxyToResponder> proxy(
        new CSVPasswordParser_ParseCSV_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CSVPasswordParser_ParseCSV_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CSVPasswordParser_ParseCSV_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CSVPasswordParser_ParseCSV_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CSVPasswordParser::ParseCSVCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CSVPasswordSequencePtr in_sequence);
};

bool CSVPasswordParser_ParseCSV_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CSVPasswordParser_ParseCSV_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CSVPasswordParser_ParseCSV_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CSVPasswordParser.0
  bool success = true;
  CSVPasswordSequencePtr p_sequence{};
  CSVPasswordParser_ParseCSV_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSequence(&p_sequence))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CSVPasswordParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_sequence));
  }
  return true;
}

void CSVPasswordParser_ParseCSV_ProxyToResponder::Run(
    CSVPasswordSequencePtr in_sequence) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::CSVPasswordParser::ParseCSV", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence"), in_sequence,
                        "<value of type CSVPasswordSequencePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CSVPasswordParser::kParseCSV), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::CSVPasswordParser_ParseCSV_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sequence)::BaseType> sequence_fragment(
          params.message());
  
  mojo::internal::Serialize<::password_manager::mojom::CSVPasswordSequenceDataView>(
    in_sequence,
    sequence_fragment);

  params->sequence.Set(
      sequence_fragment.is_null() ? nullptr : sequence_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CSVPasswordParser::Name_);
  message.set_method_name("ParseCSV");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CSVPasswordParserStubDispatch::Accept(
    CSVPasswordParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CSVPasswordParser>(message->header()->name)) {
    case messages::CSVPasswordParser::kParseCSV: {
      break;
    }
  }
  return false;
}

// static
bool CSVPasswordParserStubDispatch::AcceptWithResponder(
    CSVPasswordParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CSVPasswordParser>(message->header()->name)) {
    case messages::CSVPasswordParser::kParseCSV: {
      internal::CSVPasswordParser_ParseCSV_Params_Data* params =
          reinterpret_cast<
              internal::CSVPasswordParser_ParseCSV_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CSVPasswordParser.0
      bool success = true;
      std::string p_raw_csv{};
      CSVPasswordParser_ParseCSV_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawCsv(&p_raw_csv))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CSVPasswordParser::Name_, 0, false);
        return false;
      }
      auto callback =
          CSVPasswordParser_ParseCSV_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseCSV(        
        std::move(p_raw_csv), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCSVPasswordParserValidationInfo[] = {
    { &internal::CSVPasswordParser_ParseCSV_Params_Data::Validate,
     &internal::CSVPasswordParser_ParseCSV_ResponseParams_Data::Validate},
};

bool CSVPasswordParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::password_manager::mojom::CSVPasswordParser::Name_,
    kCSVPasswordParserValidationInfo);
}

bool CSVPasswordParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::password_manager::mojom::CSVPasswordParser::Name_,
    kCSVPasswordParserValidationInfo);
}


}  // password_manager::mojom


namespace mojo {


// static
bool StructTraits<::password_manager::mojom::CSVPasswordSequence::DataView, ::password_manager::mojom::CSVPasswordSequencePtr>::Read(
    ::password_manager::mojom::CSVPasswordSequence::DataView input,
    ::password_manager::mojom::CSVPasswordSequencePtr* output) {
  bool success = true;
  ::password_manager::mojom::CSVPasswordSequencePtr result(::password_manager::mojom::CSVPasswordSequence::New());
  
      if (success && !input.ReadCsvPasswords(&result->csv_passwords))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::password_manager::mojom::CSVPassword::DataView, ::password_manager::mojom::CSVPasswordPtr>::Read(
    ::password_manager::mojom::CSVPassword::DataView input,
    ::password_manager::mojom::CSVPasswordPtr* output) {
  bool success = true;
  ::password_manager::mojom::CSVPasswordPtr result(::password_manager::mojom::CSVPassword::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadUsername(&result->username))
        success = false;
      if (success && !input.ReadPassword(&result->password))
        success = false;
      if (success && !input.ReadNote(&result->note))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInvalidUrl(&result->invalid_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace password_manager::mojom {


void CSVPasswordParserInterceptorForTesting::ParseCSV(const std::string& raw_csv, ParseCSVCallback callback) {
  GetForwardingInterface()->ParseCSV(
    std::move(raw_csv)
    , std::move(callback));
}
CSVPasswordParserAsyncWaiter::CSVPasswordParserAsyncWaiter(
    CSVPasswordParser* proxy) : proxy_(proxy) {}

CSVPasswordParserAsyncWaiter::~CSVPasswordParserAsyncWaiter() = default;


void CSVPasswordParserAsyncWaiter::ParseCSV(
    const std::string& raw_csv, CSVPasswordSequencePtr* out_sequence) {
  base::RunLoop loop;
  proxy_->ParseCSV(
      std::move(raw_csv),
      base::BindOnce(
          [](base::RunLoop* loop,
             CSVPasswordSequencePtr* out_sequence
,
             CSVPasswordSequencePtr sequence) {*out_sequence = std::move(sequence);
            loop->Quit();
          },
          &loop,
          out_sequence));
  loop.Run();
}

CSVPasswordSequencePtr CSVPasswordParserAsyncWaiter::ParseCSV(
    const std::string& raw_csv) {
  CSVPasswordSequencePtr async_wait_result;
  ParseCSV(std::move(raw_csv),&async_wait_result);
  return async_wait_result;
}






}  // password_manager::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif