// components/optimization_guide/public/mojom/model_broker.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace optimization_guide::mojom {
namespace internal {
class  ModelSolution_CreateSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data session;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::on_device_model::mojom::internal::SessionParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<ModelSolution_CreateSession_Params_Data>;

  ModelSolution_CreateSession_Params_Data();
  ~ModelSolution_CreateSession_Params_Data() = delete;
};
static_assert(sizeof(ModelSolution_CreateSession_Params_Data) == 24,
              "Bad sizeof(ModelSolution_CreateSession_Params_Data)");
class  ModelSolution_CreateTextSafetySession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data session;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ModelSolution_CreateTextSafetySession_Params_Data>;

  ModelSolution_CreateTextSafetySession_Params_Data();
  ~ModelSolution_CreateTextSafetySession_Params_Data() = delete;
};
static_assert(sizeof(ModelSolution_CreateTextSafetySession_Params_Data) == 16,
              "Bad sizeof(ModelSolution_CreateTextSafetySession_Params_Data)");
class  ModelSolution_ReportHealthyCompletion_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ModelSolution_ReportHealthyCompletion_Params_Data>;

  ModelSolution_ReportHealthyCompletion_Params_Data();
  ~ModelSolution_ReportHealthyCompletion_Params_Data() = delete;
};
static_assert(sizeof(ModelSolution_ReportHealthyCompletion_Params_Data) == 8,
              "Bad sizeof(ModelSolution_ReportHealthyCompletion_Params_Data)");
class  ModelSubscriber_Unavailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ModelSubscriber_Unavailable_Params_Data>;

  ModelSubscriber_Unavailable_Params_Data();
  ~ModelSubscriber_Unavailable_Params_Data() = delete;
};
static_assert(sizeof(ModelSubscriber_Unavailable_Params_Data) == 16,
              "Bad sizeof(ModelSubscriber_Unavailable_Params_Data)");
class  ModelSubscriber_Available_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ModelSolutionConfig_Data> config;
  mojo::internal::Interface_Data capability;

 private:
  friend class mojo::internal::MessageFragment<ModelSubscriber_Available_Params_Data>;

  ModelSubscriber_Available_Params_Data();
  ~ModelSubscriber_Available_Params_Data() = delete;
};
static_assert(sizeof(ModelSubscriber_Available_Params_Data) == 24,
              "Bad sizeof(ModelSubscriber_Available_Params_Data)");
class  ModelBroker_Subscribe_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ModelSubscriptionOptions_Data> opts;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<ModelBroker_Subscribe_Params_Data>;

  ModelBroker_Subscribe_Params_Data();
  ~ModelBroker_Subscribe_Params_Data() = delete;
};
static_assert(sizeof(ModelBroker_Subscribe_Params_Data) == 24,
              "Bad sizeof(ModelBroker_Subscribe_Params_Data)");

}  // namespace internal


class ModelSolution_CreateSession_ParamsDataView {
 public:
  ModelSolution_CreateSession_ParamsDataView() = default;

  ModelSolution_CreateSession_ParamsDataView(
      internal::ModelSolution_CreateSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSession() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::SessionInterfaceBase>>(
            &data_->session, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetParamsDataView(
      ::on_device_model::mojom::SessionParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::SessionParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ModelSolution_CreateSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModelSolution_CreateTextSafetySession_ParamsDataView {
 public:
  ModelSolution_CreateTextSafetySession_ParamsDataView() = default;

  ModelSolution_CreateTextSafetySession_ParamsDataView(
      internal::ModelSolution_CreateTextSafetySession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSession() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::TextSafetySessionInterfaceBase>>(
            &data_->session, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ModelSolution_CreateTextSafetySession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModelSolution_ReportHealthyCompletion_ParamsDataView {
 public:
  ModelSolution_ReportHealthyCompletion_ParamsDataView() = default;

  ModelSolution_ReportHealthyCompletion_ParamsDataView(
      internal::ModelSolution_ReportHealthyCompletion_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ModelSolution_ReportHealthyCompletion_Params_Data* data_ = nullptr;
};


class ModelSubscriber_Unavailable_ParamsDataView {
 public:
  ModelSubscriber_Unavailable_ParamsDataView() = default;

  ModelSubscriber_Unavailable_ParamsDataView(
      internal::ModelSubscriber_Unavailable_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::optimization_guide::mojom::ModelUnavailableReason>(
        data_value, output);
  }
  ModelUnavailableReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::optimization_guide::mojom::ModelUnavailableReason>(data_->reason));
  }
 private:
  internal::ModelSubscriber_Unavailable_Params_Data* data_ = nullptr;
};


class ModelSubscriber_Available_ParamsDataView {
 public:
  ModelSubscriber_Available_ParamsDataView() = default;

  ModelSubscriber_Available_ParamsDataView(
      internal::ModelSubscriber_Available_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ModelSolutionConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::optimization_guide::mojom::ModelSolutionConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCapability() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::optimization_guide::mojom::ModelSolutionInterfaceBase>>(
            &data_->capability, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ModelSubscriber_Available_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModelBroker_Subscribe_ParamsDataView {
 public:
  ModelBroker_Subscribe_ParamsDataView() = default;

  ModelBroker_Subscribe_ParamsDataView(
      internal::ModelBroker_Subscribe_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptsDataView(
      ModelSubscriptionOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpts(UserType* output) {
    
    auto* pointer = data_->opts.Get();
    return mojo::internal::Deserialize<::optimization_guide::mojom::ModelSubscriptionOptionsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::optimization_guide::mojom::ModelSubscriberInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ModelBroker_Subscribe_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ModelSolution_CreateSession_ParamsDataView::GetParamsDataView(
    ::on_device_model::mojom::SessionParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::on_device_model::mojom::SessionParamsDataView(pointer, message_);
}








inline void ModelSubscriber_Available_ParamsDataView::GetConfigDataView(
    ModelSolutionConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ModelSolutionConfigDataView(pointer, message_);
}


inline void ModelBroker_Subscribe_ParamsDataView::GetOptsDataView(
    ModelSubscriptionOptionsDataView* output) {
  auto pointer = data_->opts.Get();
  *output = ModelSubscriptionOptionsDataView(pointer, message_);
}



}  // optimization_guide::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_PARAMS_DATA_H_