// components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-features.h"  // IWYU pragma: export
#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-shared.h"  // IWYU pragma: export
#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-forward.h"  // IWYU pragma: export
#include "components/optimization_guide/core/optimization_guide_common.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace optimization_guide_internals::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;
class PageHandlerFactoryResponseValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide_internals.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = PageHandlerFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
    kRequestDownloadedModelsInfoMinVersion = 0,
    kRequestLoggedModelQualityClientIdsMinVersion = 0,
    kRequestMqlsLogsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestDownloadedModelsInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestLoggedModelQualityClientIds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestMqlsLogs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page) = 0;

  using RequestDownloadedModelsInfoCallback = base::OnceCallback<void(std::vector<DownloadedModelInfoPtr>)>;
  using RequestDownloadedModelsInfoMojoCallback = base::OnceCallback<void(std::vector<DownloadedModelInfoPtr>)>;

  virtual void RequestDownloadedModelsInfo(RequestDownloadedModelsInfoCallback callback) = 0;

  using RequestLoggedModelQualityClientIdsCallback = base::OnceCallback<void(std::vector<LoggedClientIdsPtr>)>;
  using RequestLoggedModelQualityClientIdsMojoCallback = base::OnceCallback<void(std::vector<LoggedClientIdsPtr>)>;

  virtual void RequestLoggedModelQualityClientIds(RequestLoggedModelQualityClientIdsCallback callback) = 0;

  using RequestMqlsLogsCallback = base::OnceCallback<void(std::vector<MqlsLogPtr>)>;
  using RequestMqlsLogsMojoCallback = base::OnceCallback<void(std::vector<MqlsLogPtr>)>;

  virtual void RequestMqlsLogs(RequestMqlsLogsCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLogMessageAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLogMessageAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnLogMessageAdded(::base::Time event_time, ::optimization_guide_common::mojom::LogSource log_source, const std::string& source_file, int64_t source_line, const std::string& message) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page) final;
  
  void RequestDownloadedModelsInfo(RequestDownloadedModelsInfoCallback callback) final;
  
  void RequestLoggedModelQualityClientIds(RequestLoggedModelQualityClientIdsCallback callback) final;
  
  void RequestMqlsLogs(RequestMqlsLogsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLogMessageAdded(::base::Time event_time, ::optimization_guide_common::mojom::LogSource log_source, const std::string& source_file, int64_t source_line, const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  DownloadedModelInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadedModelInfo, T>::value>;
  using DataView = DownloadedModelInfoDataView;
  using Data_ = internal::DownloadedModelInfo_Data;

  template <typename... Args>
  static DownloadedModelInfoPtr New(Args&&... args) {
    return DownloadedModelInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadedModelInfoPtr From(const U& u) {
    return mojo::TypeConverter<DownloadedModelInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadedModelInfo>::Convert(*this);
  }


  DownloadedModelInfo();

  DownloadedModelInfo(
      const std::string& optimization_target,
      int64_t version,
      const std::string& file_path);


  ~DownloadedModelInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadedModelInfoPtr>
  DownloadedModelInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DownloadedModelInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DownloadedModelInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadedModelInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadedModelInfo_UnserializedMessageContext<
            UserType, DownloadedModelInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DownloadedModelInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DownloadedModelInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadedModelInfo_UnserializedMessageContext<
            UserType, DownloadedModelInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadedModelInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string optimization_target;
  
  int64_t version;
  
  std::string file_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadedModelInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LoggedClientIds {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoggedClientIds, T>::value>;
  using DataView = LoggedClientIdsDataView;
  using Data_ = internal::LoggedClientIds_Data;

  template <typename... Args>
  static LoggedClientIdsPtr New(Args&&... args) {
    return LoggedClientIdsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoggedClientIdsPtr From(const U& u) {
    return mojo::TypeConverter<LoggedClientIdsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoggedClientIds>::Convert(*this);
  }


  LoggedClientIds();

  explicit LoggedClientIds(
      int64_t client_id);


  ~LoggedClientIds();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoggedClientIdsPtr>
  LoggedClientIdsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoggedClientIds::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoggedClientIds::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoggedClientIds::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoggedClientIds_UnserializedMessageContext<
            UserType, LoggedClientIds::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoggedClientIds::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoggedClientIds::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoggedClientIds_UnserializedMessageContext<
            UserType, LoggedClientIds::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoggedClientIds::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t client_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoggedClientIds::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MqlsLog {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MqlsLog, T>::value>;
  using DataView = MqlsLogDataView;
  using Data_ = internal::MqlsLog_Data;

  template <typename... Args>
  static MqlsLogPtr New(Args&&... args) {
    return MqlsLogPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MqlsLogPtr From(const U& u) {
    return mojo::TypeConverter<MqlsLogPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MqlsLog>::Convert(*this);
  }


  MqlsLog();

  MqlsLog(
      const std::string& feature,
      const std::string& proto,
      const std::string& status);


  ~MqlsLog();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MqlsLogPtr>
  MqlsLogPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MqlsLog::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MqlsLog::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MqlsLog::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MqlsLog_UnserializedMessageContext<
            UserType, MqlsLog::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MqlsLog::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MqlsLog::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MqlsLog_UnserializedMessageContext<
            UserType, MqlsLog::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MqlsLog::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string feature;
  
  std::string proto;
  
  std::string status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MqlsLog::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






template <typename StructPtrType>
DownloadedModelInfoPtr DownloadedModelInfo::Clone() const {
  return New(
      mojo::Clone(optimization_target),
      mojo::Clone(version),
      mojo::Clone(file_path)
  );
}

template <typename T, DownloadedModelInfo::EnableIfSame<T>*>
bool DownloadedModelInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->optimization_target, other_struct.optimization_target))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  return true;
}

template <typename T, DownloadedModelInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.optimization_target < rhs.optimization_target)
    return true;
  if (rhs.optimization_target < lhs.optimization_target)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  return false;
}
template <typename StructPtrType>
LoggedClientIdsPtr LoggedClientIds::Clone() const {
  return New(
      mojo::Clone(client_id)
  );
}

template <typename T, LoggedClientIds::EnableIfSame<T>*>
bool LoggedClientIds::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  return true;
}

template <typename T, LoggedClientIds::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.client_id < rhs.client_id)
    return true;
  if (rhs.client_id < lhs.client_id)
    return false;
  return false;
}
template <typename StructPtrType>
MqlsLogPtr MqlsLog::Clone() const {
  return New(
      mojo::Clone(feature),
      mojo::Clone(proto),
      mojo::Clone(status)
  );
}

template <typename T, MqlsLog::EnableIfSame<T>*>
bool MqlsLog::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->feature, other_struct.feature))
    return false;
  if (!mojo::Equals(this->proto, other_struct.proto))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, MqlsLog::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.feature < rhs.feature)
    return true;
  if (rhs.feature < lhs.feature)
    return false;
  if (lhs.proto < rhs.proto)
    return true;
  if (rhs.proto < lhs.proto)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}


}  // optimization_guide_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::optimization_guide_internals::mojom::DownloadedModelInfo::DataView,
                                         ::optimization_guide_internals::mojom::DownloadedModelInfoPtr> {
  static bool IsNull(const ::optimization_guide_internals::mojom::DownloadedModelInfoPtr& input) { return !input; }
  static void SetToNull(::optimization_guide_internals::mojom::DownloadedModelInfoPtr* output) { output->reset(); }

  static const decltype(::optimization_guide_internals::mojom::DownloadedModelInfo::optimization_target)& optimization_target(
      const ::optimization_guide_internals::mojom::DownloadedModelInfoPtr& input) {
    return input->optimization_target;
  }

  static decltype(::optimization_guide_internals::mojom::DownloadedModelInfo::version) version(
      const ::optimization_guide_internals::mojom::DownloadedModelInfoPtr& input) {
    return input->version;
  }

  static const decltype(::optimization_guide_internals::mojom::DownloadedModelInfo::file_path)& file_path(
      const ::optimization_guide_internals::mojom::DownloadedModelInfoPtr& input) {
    return input->file_path;
  }

  static bool Read(::optimization_guide_internals::mojom::DownloadedModelInfo::DataView input, ::optimization_guide_internals::mojom::DownloadedModelInfoPtr* output);
};


template <>
struct  StructTraits<::optimization_guide_internals::mojom::LoggedClientIds::DataView,
                                         ::optimization_guide_internals::mojom::LoggedClientIdsPtr> {
  static bool IsNull(const ::optimization_guide_internals::mojom::LoggedClientIdsPtr& input) { return !input; }
  static void SetToNull(::optimization_guide_internals::mojom::LoggedClientIdsPtr* output) { output->reset(); }

  static decltype(::optimization_guide_internals::mojom::LoggedClientIds::client_id) client_id(
      const ::optimization_guide_internals::mojom::LoggedClientIdsPtr& input) {
    return input->client_id;
  }

  static bool Read(::optimization_guide_internals::mojom::LoggedClientIds::DataView input, ::optimization_guide_internals::mojom::LoggedClientIdsPtr* output);
};


template <>
struct  StructTraits<::optimization_guide_internals::mojom::MqlsLog::DataView,
                                         ::optimization_guide_internals::mojom::MqlsLogPtr> {
  static bool IsNull(const ::optimization_guide_internals::mojom::MqlsLogPtr& input) { return !input; }
  static void SetToNull(::optimization_guide_internals::mojom::MqlsLogPtr* output) { output->reset(); }

  static const decltype(::optimization_guide_internals::mojom::MqlsLog::feature)& feature(
      const ::optimization_guide_internals::mojom::MqlsLogPtr& input) {
    return input->feature;
  }

  static const decltype(::optimization_guide_internals::mojom::MqlsLog::proto)& proto(
      const ::optimization_guide_internals::mojom::MqlsLogPtr& input) {
    return input->proto;
  }

  static const decltype(::optimization_guide_internals::mojom::MqlsLog::status)& status(
      const ::optimization_guide_internals::mojom::MqlsLogPtr& input) {
    return input->status;
  }

  static bool Read(::optimization_guide_internals::mojom::MqlsLog::DataView input, ::optimization_guide_internals::mojom::MqlsLogPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_H_