// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import{assert}from"chrome://resources/js/assert.js";import{$,getRequiredElement}from"chrome://resources/js/util.js";import{PageHandlerFactory}from"./optimization_guide_internals.mojom-webui.js";import{OptimizationGuideInternalsBrowserProxy}from"./optimization_guide_internals_browser_proxy.js";const logMessages=[];class TableFilter{static FILTER_DELAY_MS=500;table;includeInput;excludeInput;filterStatsSpan;filterCellIndices;includeFun;excludeFun;filterDelayTimeoutId;numRows;numShown;constructor(table,includeInput,excludeInput,filterStatsSpan){this.table=table;this.includeInput=includeInput;this.excludeInput=excludeInput;this.filterStatsSpan=filterStatsSpan;this.filterCellIndices=[];this.readFilterCellIndices();this.includeFun=this.readFilter(this.includeInput);this.excludeFun=this.readFilter(this.excludeInput);this.filterDelayTimeoutId=null;this.numRows=0;this.numShown=0;this.includeInput.addEventListener("input",(e=>this.triggerUpdate(e)));this.excludeInput.addEventListener("input",(e=>this.triggerUpdate(e)))}readFilterCellIndices(){this.filterCellIndices.length=0;const headers=this.table.rows[0].cells;for(const[idx,header]of Array.from(headers).entries()){if(header.classList.contains("filterable")){this.filterCellIndices.push(idx)}}}readFilter(input){const t=input.value;return t===""?null:s=>s.indexOf(t)>=0}shouldRowBeShown(row){if(this.excludeFun!=null){for(const idx of this.filterCellIndices){const text=row.cells[idx]?.textContent??"";if(this.excludeFun(text)){return false}}}if(this.includeFun!=null){for(const idx of this.filterCellIndices){const text=row.cells[idx]?.textContent??"";if(this.includeFun(text)){return true}}return false}return true}applyFilterToRow(row){const shouldShow=this.shouldRowBeShown(row);row.classList.toggle("hidden",!shouldShow);return shouldShow}writeFilterStats(){this.filterStatsSpan.textContent=`${this.numShown} / ${this.numRows}`}readAndApplyAllFilters(){this.readFilterCellIndices();this.includeFun=this.readFilter(this.includeInput);this.excludeFun=this.readFilter(this.excludeInput);this.numRows=0;this.numShown=0;let isTitle=true;for(const row of this.table.rows){if(isTitle){isTitle=false}else{this.numShown+=Number(this.applyFilterToRow(row));++this.numRows}}this.writeFilterStats()}filterNewRow(row){this.numShown+=Number(this.applyFilterToRow(row));++this.numRows;this.writeFilterStats()}triggerUpdate(e){const elt=e.target;if(this.filterDelayTimeoutId!=null){clearTimeout(this.filterDelayTimeoutId);this.filterDelayTimeoutId=null}elt.classList.add("input-dirty");this.filterDelayTimeoutId=setTimeout((()=>{this.filterDelayTimeoutId=null;this.includeInput.classList.remove("input-dirty");this.excludeInput.classList.remove("input-dirty");this.readAndApplyAllFilters()}),TableFilter.FILTER_DELAY_MS)}}function convertMojoTimeToJS(mojoTime){const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaInMs=unixEpoch-windowsEpoch;const timeInMs=Number(mojoTime.internalValue)/1e3;return new Date(timeInMs-epochDeltaInMs)}function createChromiumSourceLink(sourceFile,sourceLine,targetElement){if(!sourceFile.startsWith("../../")){targetElement.textContent=`${sourceFile}(${sourceLine})`;return}const fileName=sourceFile.slice(sourceFile.lastIndexOf("/")+1);if(fileName.length===0){targetElement.textContent=`${sourceFile}(${sourceLine})`;return}const anchor=document.createElement("a");anchor.appendChild(document.createTextNode(`${fileName}(${sourceLine}`));anchor.href=`https://source.chromium.org/chromium/chromium/src/+/main:${sourceFile.slice(6)};l=${sourceLine}`;targetElement.appendChild(anchor)}function getLogSource(logSource){if(logSource===0){return"SERVICE_AND_SETTINGS"}if(logSource===1){return"HINTS"}if(logSource===2){return"MODEL_MANAGEMENT"}if(logSource===3){return"PAGE_CONTENT_ANNOTATIONS"}if(logSource===4){return"HINTS_NOTIFICATIONS"}if(logSource===5){return"TEXT_CLASSIFIER"}if(logSource===6){return"MODEL_EXECUTION"}if(logSource===7){return"NTP_MODULE"}if(logSource===8){return"BUILT_IN_AI"}if(logSource===9){return"CONTEXTUAL_TASKS_CONTEXT"}return logSource.toString()}function onLogMessagesDump(){const data=JSON.stringify(logMessages);const blob=new Blob([data],{type:"text/json"});const url=URL.createObjectURL(blob);const filename="optimization_guide_internals_logs_dump.json";const a=document.createElement("a");a.setAttribute("href",url);a.setAttribute("download",filename);const event=document.createEvent("MouseEvent");event.initMouseEvent("click",true,true,window,0,0,0,0,0,false,false,false,false,0,null);a.dispatchEvent(event)}async function onModelsPageOpen(){const downloadedModelsContainer=getRequiredElement("downloaded-models-container");try{const response=await PageHandlerFactory.getRemote().requestDownloadedModelsInfo();const downloadedModelsInfo=response.downloadedModelsInfo;for(const{optimizationTarget:optimizationTarget,version:version,filePath:filePath}of downloadedModelsInfo){const versionStr=version.toString();const existingModel=$(optimizationTarget);if(existingModel){existingModel.querySelector(".downloaded-models-version").textContent=versionStr;existingModel.querySelector(".downloaded-models-file-path").textContent=filePath}else{const downloadedModel=downloadedModelsContainer.insertRow();downloadedModel.id=optimizationTarget;appendTD(downloadedModel,optimizationTarget,"downloaded-models-optimization-target");appendTD(downloadedModel,versionStr,"downloaded-models-version");appendTD(downloadedModel,filePath,"downloaded-models-file-path")}}}catch(err){throw new Error(`Error resolving promise from requestDownloadedModelsInfo, ${err}`)}}async function onClientIDsPageOpen(){const loggedClientIdsContainer=getRequiredElement("logged-client-ids-container");try{const response=await PageHandlerFactory.getRemote().requestLoggedModelQualityClientIds();const loggedClientIds=response.loggedClientIds;for(const{clientId:clientId}of loggedClientIds){const clientIdStr=clientId.toString();const loggedClients=loggedClientIdsContainer.insertRow();appendTD(loggedClients,clientIdStr,"logged-client-ids")}}catch(err){throw new Error(`Error resolving promise from requestLoggedClientIds, ${err}`)}}async function onMqlsLogsPageOpen(){const mqlsLogsContainer=getRequiredElement("mqls-logs-container");try{const response=await PageHandlerFactory.getRemote().requestMqlsLogs();const mqlsLogs=response.mqlsLogs;for(const{feature:feature,proto:proto,status:status}of mqlsLogs){const row=mqlsLogsContainer.insertRow();const featureStr=feature.toString();const protoStr=proto.toString();const statusStr=status.toString();appendTD(row,featureStr,"mqls-logs-feature");appendTD(row,protoStr,"mqls-logs-proto");appendTD(row,statusStr,"mqls-logs-status")}}catch(err){throw new Error(`Error resolving promise from requestMqlsLogs, ${err}`)}}function appendTD(parent,textContent,className){const td=parent.insertCell();td.textContent=textContent;td.className=className;parent.appendChild(td);return td}function getProxy(){return OptimizationGuideInternalsBrowserProxy.getInstance()}function initialize(){const tabbox=document.querySelector("cr-tab-box");assert(tabbox);tabbox.hidden=false;const logMessageContainer=getRequiredElement("log-message-container");const tabFilter=new TableFilter(logMessageContainer,getRequiredElement("log-message-include"),getRequiredElement("log-message-exclude"),getRequiredElement("log-message-filter-stats"));getRequiredElement("log-messages-dump").addEventListener("click",onLogMessagesDump);getRequiredElement("mqls-logs-refresh").addEventListener("click",onMqlsLogsPageOpen);getProxy().getCallbackRouter().onLogMessageAdded.addListener(((eventTime,logSource,sourceFile,sourceLine,message)=>{const eventTimeStr=convertMojoTimeToJS(eventTime).toISOString();const logSourceStr=getLogSource(logSource);logMessages.push({eventTime:eventTimeStr,logSource:logSourceStr,sourceLocation:`${sourceFile}:${sourceLine}`,message:message});const logMessage=logMessageContainer.insertRow();logMessage.innerHTML=window.trustedTypes?window.trustedTypes.emptyHTML:"";appendTD(logMessage,eventTimeStr,"event-logs-time");appendTD(logMessage,logSourceStr,"event-logs-log-source");createChromiumSourceLink(sourceFile,sourceLine,appendTD(logMessage,"","event-logs-source-location"));appendTD(logMessage,message,"event-logs-message");tabFilter.filterNewRow(logMessage)}));const tabpanelNodeList=document.querySelectorAll("div[slot='panel']");const tabpanels=Array.prototype.slice.call(tabpanelNodeList,0);const tabpanelIds=tabpanels.map((function(tab){return tab.id}));tabbox.addEventListener("selected-index-change",(e=>{const tabpanel=tabpanels[e.detail];const hash=tabpanel.id.match(/(?:^tabpanel-)(.+)/)[1];window.location.hash=hash}));const activateTabByHash=function(){let hash=window.location.hash;hash=hash.substring(1);const id="tabpanel-"+hash;const index=tabpanelIds.indexOf(id);if(index===-1){return}tabbox.setAttribute("selected-index",`${index}`);if(hash==="models"){onModelsPageOpen()}else if(hash==="client-ids"){onClientIDsPageOpen()}else if(hash==="mqls-logs"){onMqlsLogsPageOpen()}};window.onhashchange=activateTabByHash;activateTabByHash()}document.addEventListener("DOMContentLoaded",initialize);