// components/mirroring/mojom/resource_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_H_
#define COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/resource_provider.mojom-features.h"  // IWYU pragma: export
#include "components/mirroring/mojom/resource_provider.mojom-shared.h"  // IWYU pragma: export
#include "components/mirroring/mojom/resource_provider.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture.mojom-forward.h"
#include "services/network/public/mojom/network_context.mojom-forward.h"
#include "media/mojo/mojom/remoting.mojom-forward.h"
#include "media/mojo/mojom/audio_data_pipe.mojom-forward.h"
#include "media/mojo/mojom/audio_input_stream.mojom-forward.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-forward.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "services/viz/public/mojom/gpu.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mirroring::mojom {

class AudioStreamCreatorClientProxy;

template <typename ImplRefTraits>
class AudioStreamCreatorClientStub;

class AudioStreamCreatorClientRequestValidator;


class AudioStreamCreatorClient
    : public AudioStreamCreatorClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mirroring.mojom.AudioStreamCreatorClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioStreamCreatorClientInterfaceBase;
  using Proxy_ = AudioStreamCreatorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioStreamCreatorClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioStreamCreatorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStreamCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StreamCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioStreamCreatorClient() = default;

  virtual void StreamCreated(::mojo::PendingRemote<::media::mojom::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> client_receiver, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) = 0;
};

class ResourceProviderProxy;

template <typename ImplRefTraits>
class ResourceProviderStub;

class ResourceProviderRequestValidator;


class ResourceProvider
    : public ResourceProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mirroring.mojom.ResourceProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResourceProviderInterfaceBase;
  using Proxy_ = ResourceProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceProviderStub<ImplRefTraits>;

  using RequestValidator_ = ResourceProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindGpuMinVersion = 0,
    kGetVideoCaptureHostMinVersion = 0,
    kGetVideoEncoderMetricsProviderMinVersion = 0,
    kGetNetworkContextMinVersion = 0,
    kCreateAudioStreamMinVersion = 0,
    kConnectToRemotingSourceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindGpu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoCaptureHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoEncoderMetricsProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNetworkContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAudioStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectToRemotingSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResourceProvider() = default;

  virtual void BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) = 0;

  virtual void GetVideoCaptureHost(::mojo::PendingReceiver<::media::mojom::VideoCaptureHost> receiver) = 0;

  virtual void GetVideoEncoderMetricsProvider(::mojo::PendingReceiver<::media::mojom::VideoEncoderMetricsProvider> receiver) = 0;

  virtual void GetNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> receiver) = 0;

  virtual void CreateAudioStream(::mojo::PendingRemote<AudioStreamCreatorClient> client, const ::media::AudioParameters& param, uint32_t shared_memory_count) = 0;

  virtual void ConnectToRemotingSource(::mojo::PendingRemote<::media::mojom::Remoter> remoter, ::mojo::PendingReceiver<::media::mojom::RemotingSource> receiver) = 0;
};



class  AudioStreamCreatorClientProxy
    : public AudioStreamCreatorClient {
 public:
  using InterfaceType = AudioStreamCreatorClient;

  explicit AudioStreamCreatorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StreamCreated(::mojo::PendingRemote<::media::mojom::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> client_receiver, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ResourceProviderProxy
    : public ResourceProvider {
 public:
  using InterfaceType = ResourceProvider;

  explicit ResourceProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) final;
  
  void GetVideoCaptureHost(::mojo::PendingReceiver<::media::mojom::VideoCaptureHost> receiver) final;
  
  void GetVideoEncoderMetricsProvider(::mojo::PendingReceiver<::media::mojom::VideoEncoderMetricsProvider> receiver) final;
  
  void GetNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> receiver) final;
  
  void CreateAudioStream(::mojo::PendingRemote<AudioStreamCreatorClient> client, const ::media::AudioParameters& param, uint32_t shared_memory_count) final;
  
  void ConnectToRemotingSource(::mojo::PendingRemote<::media::mojom::Remoter> remoter, ::mojo::PendingReceiver<::media::mojom::RemotingSource> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioStreamCreatorClientStubDispatch {
 public:
  static bool Accept(AudioStreamCreatorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioStreamCreatorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioStreamCreatorClient>>
class AudioStreamCreatorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioStreamCreatorClientStub() = default;
  ~AudioStreamCreatorClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioStreamCreatorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioStreamCreatorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResourceProviderStubDispatch {
 public:
  static bool Accept(ResourceProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceProvider>>
class ResourceProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceProviderStub() = default;
  ~ResourceProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioStreamCreatorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ResourceProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // mirroring::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_H_