// components/metrics/structured/mojom/event.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_DATA_VIEW_H_
#define COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/metrics/structured/mojom/event.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace metrics::structured::mojom {
class EventDataView;

class MetricValueDataView;


}  // metrics::structured::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::metrics::structured::mojom::EventDataView> {
  using Data = ::metrics::structured::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::metrics::structured::mojom::MetricValueDataView> {
  using Data = ::metrics::structured::mojom::internal::MetricValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace metrics::structured::mojom {


class EventDataView {
 public:
  EventDataView() = default;

  EventDataView(
      internal::Event_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProjectNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProjectName(UserType* output) {
    
    auto* pointer = data_->project_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEventNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventName(UserType* output) {
    
    auto* pointer = data_->event_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMetricsDataView(
      mojo::MapDataView<mojo::StringDataView, MetricValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetrics(UserType* output) {
    
    auto* pointer = data_->metrics.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::metrics::structured::mojom::MetricValueDataView>>(
        pointer, output, message_);
  }
  inline void GetSystemUptimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemUptime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `system_uptime` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSystemUptime` instead "
    "of `ReadSystemUptime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->system_uptime.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool is_event_sequence() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->is_event_sequence;
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MetricValueDataView {
 public:
  using Tag = internal::MetricValue_Data::MetricValue_Tag;

  MetricValueDataView() = default;

  MetricValueDataView(
      internal::MetricValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_hmac_value() const { return data_->tag == Tag::kHmacValue; }
  inline void GetHmacValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHmacValue(UserType* output) const {
    
    CHECK(is_hmac_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_hmac_value.Get(), output, message_);
  }
  bool is_long_value() const { return data_->tag == Tag::kLongValue; }
  int64_t long_value() const {
    CHECK(is_long_value());
    return data_->data.f_long_value;
  }
  bool is_int_value() const { return data_->tag == Tag::kIntValue; }
  int32_t int_value() const {
    CHECK(is_int_value());
    return data_->data.f_int_value;
  }
  bool is_double_value() const { return data_->tag == Tag::kDoubleValue; }
  double double_value() const {
    CHECK(is_double_value());
    return data_->data.f_double_value;
  }
  bool is_raw_str_value() const { return data_->tag == Tag::kRawStrValue; }
  inline void GetRawStrValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRawStrValue(UserType* output) const {
    
    CHECK(is_raw_str_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_raw_str_value.Get(), output, message_);
  }
  bool is_bool_value() const { return data_->tag == Tag::kBoolValue; }
  bool bool_value() const {
    CHECK(is_bool_value());
    return data_->data.f_bool_value;
  }

 private:
  internal::MetricValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // metrics::structured::mojom

#endif  // COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_DATA_VIEW_H_