// components/metrics/public/mojom/histogram_fetcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/public/mojom/histogram_fetcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/public/mojom/histogram_fetcher.mojom-params-data.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared-message-ids.h"

#include "components/metrics/public/mojom/histogram_fetcher.mojom-import-headers.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-test-utils.h"


namespace metrics::mojom {
// The declaration includes the definition on other builds.

ChildHistogramFetcherFactory::IPCStableHashFunction ChildHistogramFetcherFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildHistogramFetcherFactory>(message.name())) {
    case messages::ChildHistogramFetcherFactory::kCreateFetcher: {
      return &ChildHistogramFetcherFactory::CreateFetcher_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildHistogramFetcherFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildHistogramFetcherFactory>(message.name())) {
      case messages::ChildHistogramFetcherFactory::kCreateFetcher:
            return "Receive metrics::mojom::ChildHistogramFetcherFactory::CreateFetcher";
    }
  } else {
    switch (static_cast<messages::ChildHistogramFetcherFactory>(message.name())) {
      case messages::ChildHistogramFetcherFactory::kCreateFetcher:
            return "Receive reply metrics::mojom::ChildHistogramFetcherFactory::CreateFetcher";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildHistogramFetcherFactory::CreateFetcher_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd85f6f51;  // IPCStableHash for metrics::mojom::ChildHistogramFetcherFactory::CreateFetcher
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ChildHistogramFetcherFactoryProxy::ChildHistogramFetcherFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildHistogramFetcherFactoryProxy::CreateFetcher(
    ::base::UnsafeSharedMemoryRegion in_shared_memory, ::mojo::PendingReceiver<ChildHistogramFetcher> in_child_histogram_fetcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics::mojom::ChildHistogramFetcherFactory::CreateFetcher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_histogram_fetcher"), in_child_histogram_fetcher,
                        "<value of type ::mojo::PendingReceiver<ChildHistogramFetcher>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildHistogramFetcherFactory::kCreateFetcher), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shared_memory)::BaseType> shared_memory_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_shared_memory,
    shared_memory_fragment);

  params->shared_memory.Set(
      shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::metrics::mojom::ChildHistogramFetcherInterfaceBase>>(
    in_child_histogram_fetcher,
    &params->child_histogram_fetcher,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->child_histogram_fetcher)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid child_histogram_fetcher in ChildHistogramFetcherFactory.CreateFetcher request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcherFactory::Name_);
  message.set_method_name("CreateFetcher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ChildHistogramFetcherFactoryStubDispatch::Accept(
    ChildHistogramFetcherFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildHistogramFetcherFactory>(message->header()->name)) {
    case messages::ChildHistogramFetcherFactory::kCreateFetcher: {
      DCHECK(message->is_serialized());
      internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data* params =
          reinterpret_cast<internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChildHistogramFetcherFactory.0
      bool success = true;
      ::base::UnsafeSharedMemoryRegion p_shared_memory{};
      ::mojo::PendingReceiver<ChildHistogramFetcher> p_child_histogram_fetcher{};
      ChildHistogramFetcherFactory_CreateFetcher_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSharedMemory(&p_shared_memory))
        success = false;
      if (success) {
        p_child_histogram_fetcher =
            input_data_view.TakeChildHistogramFetcher<decltype(p_child_histogram_fetcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildHistogramFetcherFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFetcher(        
        std::move(p_shared_memory), 
        std::move(p_child_histogram_fetcher));
      return true;
    }
  }
  return false;
}

// static
bool ChildHistogramFetcherFactoryStubDispatch::AcceptWithResponder(
    ChildHistogramFetcherFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildHistogramFetcherFactory>(message->header()->name)) {
    case messages::ChildHistogramFetcherFactory::kCreateFetcher: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChildHistogramFetcherFactoryValidationInfo[] = {
    { &internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data::Validate,
     nullptr /* no response */},
};

bool ChildHistogramFetcherFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::metrics::mojom::ChildHistogramFetcherFactory::Name_,
    kChildHistogramFetcherFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ChildHistogramFetcher::IPCStableHashFunction ChildHistogramFetcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildHistogramFetcher>(message.name())) {
    case messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData: {
      return &ChildHistogramFetcher::GetChildNonPersistentHistogramData_Sym::IPCStableHash;
    }
    case messages::ChildHistogramFetcher::kPing: {
      return &ChildHistogramFetcher::Ping_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildHistogramFetcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildHistogramFetcher>(message.name())) {
      case messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData:
            return "Receive metrics::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData";
      case messages::ChildHistogramFetcher::kPing:
            return "Receive metrics::mojom::ChildHistogramFetcher::Ping";
    }
  } else {
    switch (static_cast<messages::ChildHistogramFetcher>(message.name())) {
      case messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData:
            return "Receive reply metrics::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData";
      case messages::ChildHistogramFetcher::kPing:
            return "Receive reply metrics::mojom::ChildHistogramFetcher::Ping";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildHistogramFetcher::GetChildNonPersistentHistogramData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ec447e6;  // IPCStableHash for metrics::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildHistogramFetcher::Ping_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafbe693b;  // IPCStableHash for metrics::mojom::ChildHistogramFetcher::Ping
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback(
      ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback(const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback&) = delete;
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback& operator=(const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback callback_;
};

class ChildHistogramFetcher_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChildHistogramFetcher_Ping_ForwardToCallback(
      ChildHistogramFetcher::PingCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChildHistogramFetcher_Ping_ForwardToCallback(const ChildHistogramFetcher_Ping_ForwardToCallback&) = delete;
  ChildHistogramFetcher_Ping_ForwardToCallback& operator=(const ChildHistogramFetcher_Ping_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChildHistogramFetcher::PingCallback callback_;
};

ChildHistogramFetcherProxy::ChildHistogramFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildHistogramFetcherProxy::GetChildNonPersistentHistogramData(
    GetChildNonPersistentHistogramDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send metrics::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("GetChildNonPersistentHistogramData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChildHistogramFetcherProxy::Ping(
    UmaPingCallSource in_call_source, PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics::mojom::ChildHistogramFetcher::Ping", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_source"), in_call_source,
                        "<value of type UmaPingCallSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildHistogramFetcher::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::ChildHistogramFetcher_Ping_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::metrics::mojom::UmaPingCallSource>(
    in_call_source,
    &params->call_source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChildHistogramFetcher_Ping_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder> proxy(
        new ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_deltas);
};

bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChildHistogramFetcher.0
  bool success = true;
  std::vector<std::string> p_deltas{};
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeltas(&p_deltas))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChildHistogramFetcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_deltas));
  }
  return true;
}

void ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::Run(
    const std::vector<std::string>& in_deltas) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply metrics::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deltas"), in_deltas,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->deltas)::BaseType>
      deltas_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& deltas_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
    in_deltas,
    deltas_fragment,
    &deltas_validate_params);

  params->deltas.Set(
      deltas_fragment.is_null() ? nullptr : deltas_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->deltas.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null deltas in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("GetChildNonPersistentHistogramData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChildHistogramFetcher_Ping_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChildHistogramFetcher::PingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChildHistogramFetcher_Ping_ProxyToResponder> proxy(
        new ChildHistogramFetcher_Ping_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChildHistogramFetcher_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChildHistogramFetcher_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChildHistogramFetcher_Ping_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChildHistogramFetcher::PingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ChildHistogramFetcher_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChildHistogramFetcher_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChildHistogramFetcher_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChildHistogramFetcher.1
  bool success = true;
  ChildHistogramFetcher_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChildHistogramFetcher::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ChildHistogramFetcher_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply metrics::mojom::ChildHistogramFetcher::Ping");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildHistogramFetcher::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::ChildHistogramFetcher_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChildHistogramFetcherStubDispatch::Accept(
    ChildHistogramFetcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildHistogramFetcher>(message->header()->name)) {
    case messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData: {
      break;
    }
    case messages::ChildHistogramFetcher::kPing: {
      break;
    }
  }
  return false;
}

// static
bool ChildHistogramFetcherStubDispatch::AcceptWithResponder(
    ChildHistogramFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildHistogramFetcher>(message->header()->name)) {
    case messages::ChildHistogramFetcher::kGetChildNonPersistentHistogramData: {
      internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data* params =
          reinterpret_cast<
              internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChildHistogramFetcher.0
      bool success = true;
      ChildHistogramFetcher_GetChildNonPersistentHistogramData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildHistogramFetcher::Name_, 0, false);
        return false;
      }
      auto callback =
          ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChildNonPersistentHistogramData(std::move(callback));
      return true;
    }
    case messages::ChildHistogramFetcher::kPing: {
      internal::ChildHistogramFetcher_Ping_Params_Data* params =
          reinterpret_cast<
              internal::ChildHistogramFetcher_Ping_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChildHistogramFetcher.1
      bool success = true;
      UmaPingCallSource p_call_source{};
      ChildHistogramFetcher_Ping_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCallSource(&p_call_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildHistogramFetcher::Name_, 1, false);
        return false;
      }
      auto callback =
          ChildHistogramFetcher_Ping_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(        
        std::move(p_call_source), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChildHistogramFetcherValidationInfo[] = {
    { &internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::Validate,
     &internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::Validate},
    { &internal::ChildHistogramFetcher_Ping_Params_Data::Validate,
     &internal::ChildHistogramFetcher_Ping_ResponseParams_Data::Validate},
};

bool ChildHistogramFetcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::metrics::mojom::ChildHistogramFetcher::Name_,
    kChildHistogramFetcherValidationInfo);
}

bool ChildHistogramFetcherResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::metrics::mojom::ChildHistogramFetcher::Name_,
    kChildHistogramFetcherValidationInfo);
}


}  // metrics::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics::mojom {


void ChildHistogramFetcherFactoryInterceptorForTesting::CreateFetcher(::base::UnsafeSharedMemoryRegion shared_memory, ::mojo::PendingReceiver<ChildHistogramFetcher> child_histogram_fetcher) {
  GetForwardingInterface()->CreateFetcher(
    std::move(shared_memory)
    , 
    std::move(child_histogram_fetcher)
    );
}
ChildHistogramFetcherFactoryAsyncWaiter::ChildHistogramFetcherFactoryAsyncWaiter(
    ChildHistogramFetcherFactory* proxy) : proxy_(proxy) {}

ChildHistogramFetcherFactoryAsyncWaiter::~ChildHistogramFetcherFactoryAsyncWaiter() = default;





void ChildHistogramFetcherInterceptorForTesting::GetChildNonPersistentHistogramData(GetChildNonPersistentHistogramDataCallback callback) {
  GetForwardingInterface()->GetChildNonPersistentHistogramData(std::move(callback));
}
void ChildHistogramFetcherInterceptorForTesting::Ping(UmaPingCallSource call_source, PingCallback callback) {
  GetForwardingInterface()->Ping(
    std::move(call_source)
    , std::move(callback));
}
ChildHistogramFetcherAsyncWaiter::ChildHistogramFetcherAsyncWaiter(
    ChildHistogramFetcher* proxy) : proxy_(proxy) {}

ChildHistogramFetcherAsyncWaiter::~ChildHistogramFetcherAsyncWaiter() = default;


void ChildHistogramFetcherAsyncWaiter::GetChildNonPersistentHistogramData(
    std::vector<std::string>* out_deltas) {
  base::RunLoop loop;
  proxy_->GetChildNonPersistentHistogramData(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_deltas
,
             const std::vector<std::string>& deltas) {*out_deltas = std::move(deltas);
            loop->Quit();
          },
          &loop,
          out_deltas));
  loop.Run();
}

std::vector<std::string> ChildHistogramFetcherAsyncWaiter::GetChildNonPersistentHistogramData(
    ) {
  std::vector<std::string> async_wait_result;
  GetChildNonPersistentHistogramData(&async_wait_result);
  return async_wait_result;
}

void ChildHistogramFetcherAsyncWaiter::Ping(
    UmaPingCallSource call_source) {
  base::RunLoop loop;
  proxy_->Ping(
      std::move(call_source),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // metrics::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif