// components/media_router/common/mojom/media_status.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SHARED_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/media_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/media_router/common/mojom/media_status.mojom-data-view.h"




namespace std {

template <>
struct hash<::media_router::mojom::MediaStatus_PlayState>
    : public mojo::internal::EnumHashImpl<::media_router::mojom::MediaStatus_PlayState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaStatus_PlayState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_router::mojom::MediaStatus_PlayState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_router::mojom::MediaStatus_PlayState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in MediaImage struct");

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());
  }

  static bool Deserialize(::media_router::mojom::internal::MediaImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::MediaImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in MediaStatus struct");

    decltype(Traits::secondary_title(input)) in_secondary_title = Traits::secondary_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secondary_title)::BaseType> secondary_title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_secondary_title,
      secondary_title_fragment);

    fragment->secondary_title.Set(
        secondary_title_fragment.is_null() ? nullptr : secondary_title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->secondary_title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null secondary_title in MediaStatus struct");

    fragment->can_play_pause = Traits::can_play_pause(input);

    fragment->can_mute = Traits::can_mute(input);

    fragment->can_set_volume = Traits::can_set_volume(input);

    fragment->can_seek = Traits::can_seek(input);

    fragment->can_skip_to_next_track = Traits::can_skip_to_next_track(input);

    fragment->can_skip_to_previous_track = Traits::can_skip_to_previous_track(input);

    
    mojo::internal::Serialize<::media_router::mojom::MediaStatus_PlayState>(
      Traits::play_state(input),
      &fragment->play_state);

    fragment->is_muted = Traits::is_muted(input);

    fragment->volume = Traits::volume(input);

    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration,
      duration_fragment);

    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in MediaStatus struct");

    decltype(Traits::current_time(input)) in_current_time = Traits::current_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_time)::BaseType> current_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_current_time,
      current_time_fragment);

    fragment->current_time.Set(
        current_time_fragment.is_null() ? nullptr : current_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->current_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null current_time in MediaStatus struct");

    decltype(Traits::images(input)) in_images = Traits::images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->images)::BaseType>
        images_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::MediaImageDataView>>(
      in_images,
      images_fragment,
      &images_validate_params);

    fragment->images.Set(
        images_fragment.is_null() ? nullptr : images_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->images.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null images in MediaStatus struct");
  }

  static bool Deserialize(::media_router::mojom::internal::MediaStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::MediaStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media_router::mojom {

inline void MediaImageDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void MediaImageDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void MediaStatusDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStatusDataView::GetSecondaryTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->secondary_title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStatusDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void MediaStatusDataView::GetCurrentTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->current_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void MediaStatusDataView::GetImagesDataView(
    mojo::ArrayDataView<MediaImageDataView>* output) {
  auto pointer = data_->images.Get();
  *output = mojo::ArrayDataView<MediaImageDataView>(pointer, message_);
}



}  // media_router::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_router::mojom::MediaStatus_PlayState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_router::mojom::MediaStatus_PlayState value);
};

} // namespace perfetto

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SHARED_H_