// components/media_router/common/mojom/logger.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_LOGGER_MOJOM_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_LOGGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/logger.mojom-features.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/logger.mojom-shared.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/logger.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media_router::mojom {

class LoggerProxy;

template <typename ImplRefTraits>
class LoggerStub;

class LoggerRequestValidator;


class Logger
    : public LoggerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_router.mojom.Logger";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LoggerInterfaceBase;
  using Proxy_ = LoggerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LoggerStub<ImplRefTraits>;

  using RequestValidator_ = LoggerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLogInfoMinVersion = 0,
    kLogWarningMinVersion = 0,
    kLogErrorMinVersion = 0,
    kBindReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LogInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogWarning_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Logger() = default;

  virtual void LogInfo(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) = 0;

  virtual void LogWarning(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) = 0;

  virtual void LogError(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) = 0;

  virtual void BindReceiver(::mojo::PendingReceiver<Logger> receiver) = 0;
};



class  LoggerProxy
    : public Logger {
 public:
  using InterfaceType = Logger;

  explicit LoggerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LogInfo(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) final;
  
  void LogWarning(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) final;
  
  void LogError(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) final;
  
  void BindReceiver(::mojo::PendingReceiver<Logger> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LoggerStubDispatch {
 public:
  static bool Accept(Logger* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Logger* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Logger>>
class LoggerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LoggerStub() = default;
  ~LoggerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LoggerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LoggerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LoggerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media_router::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_LOGGER_MOJOM_H_